(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15779,        539]
NotebookOptionsPosition[     10975,        398]
NotebookOutlinePosition[     13910,        472]
CellTagsIndexPosition[     13818,        466]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Input and Output in Notebooks" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/InputAndOutputInNotebooksOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Input and Output in Notebooks\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Entering Tables and Matrices", "Title",
 CellTags->{"S1.10.5", "5.1"},
 CellID->27005],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end provides an ",
 StyleBox[ButtonBox["Insert",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InsertMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Table/Matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/TableMatrix"], "MenuName"],
 " submenu for creating and editing arrays with any specified number of rows \
and columns. Once you have such an array, you can edit it to fill in whatever \
elements you want."
}], "Text",
 CellID->24176],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " treats an array like this as a matrix represented by a list of lists. "
}], "MathCaption",
 CellID->18479],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {"a", "b", "c"},
   {"1", "2", "3"}
  }]], "Input",
 CellLabel->"In[1]:=",
 CellID->1695],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->126803562]
}, Open  ]],

Cell["\<\
Putting parentheses around the array makes it look more like a matrix, but \
does not affect its interpretation. \
\>", "MathCaption",
 CellID->32468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a", "b", "c"},
    {"1", "2", "3"}
   }], ")"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13998],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->443420334]
}, Open  ]],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 " tells ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to display the result of the ",
 Cell[BoxData[
  ButtonBox["Transpose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Transpose"]], "InlineFormula"],
 " as a matrix. "
}], "MathCaption",
 CellID->23639],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Transpose", "[", 
   RowBox[{"(", GridBox[{
      {"a", "b", "c"},
      {"1", "2", "3"}
     }], ")"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->29515],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"a", "1"},
     {"b", "2"},
     {"c", "3"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.28], {
         Offset[0.7]}, 
        Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{46, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->155976213]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox[",", "KeyEvent"]
    }], "TableText"], Cell["add a column", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Enter", "KeyEvent"]
    }], "TableText"], Cell["add a row", "TableText"]},
   {Cell[TextData[StyleBox["Tab", "KeyEvent"]], "TableText"], Cell[TextData[{
     "go to the next ",
     Cell[BoxData["\[Placeholder]"], "InlineFormula"],
     " or ",
     Cell[BoxData["\[SelectionPlaceholder]"], "InlineFormula"],
     " element"
    }], "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], Cell["move out of the table or matrix", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->29993],

Cell["Entering tables and matrices. ", "Caption",
 CellID->15826],

Cell[TextData[{
 "Note that you can use ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox[",", "KeyEvent"],
 " and ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Enter", "KeyEvent"],
 " to start building up an array, and particularly for small arrays this is \
often more convenient than using the ",
 StyleBox[ButtonBox["New",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/New-TableMatrix"], "MenuName"],
 " menu item in the ",
 StyleBox[ButtonBox["Table/Matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/TableMatrix"], "MenuName"],
 " submenu. The ",
 StyleBox[ButtonBox["Table/Matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/TableMatrix"], "MenuName"],
 " menu items typically allow you to make basic adjustments, such as drawing \
lines between rows or columns. "
}], "Text",
 CellID->15722],

Cell[TextData[{
 "Entering a ",
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 " expression is a special case of entering a table."
}], "Text",
 CellID->304935857],

Cell[TextData[{
 "Enter the ",
 Cell[BoxData[
  ButtonBox["\\[Piecewise]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Piecewise"]], "InlineCharacterName"],
 " character and press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox[",", "KeyEvent"],
 " to get a template of placeholders for two cases."
}], "MathCaption",
 CellID->14092505],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"\[Piecewise]", GridBox[{
     {"\[Placeholder]", "\[Placeholder]"},
     {"\[Placeholder]", "\[Placeholder]"}
    }]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->157997708],

Cell["\<\
Fill in the placeholders to complete the piecewise expression.\
\>", "MathCaption",
 CellID->11063108],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"\[Piecewise]", GridBox[{
     {"0", 
      RowBox[{"x", "<", "0"}]},
     {"1", 
      RowBox[{"x", "=", "0"}]}
    }]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->54671826],

Cell[TextData[{
 "To add additional cases, use ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Enter", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->752050440],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"\[Piecewise]", GridBox[{
     {"0", 
      RowBox[{"x", "<", "0"}]},
     {"1", 
      RowBox[{"x", "=", "0"}]},
     {"\[Placeholder]", "\[Placeholder]"}
    }]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->56459685],

Cell[TextData[{
 "You can make an element in a table span over multiple rows or columns by \
selecting the entire block that you want the element to span and using the ",
 StyleBox[ButtonBox["Insert",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InsertMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Table/Matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/TableMatrix"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Make Spanning",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/MakeSpanning"], "MenuName"],
 " menu command. To split a spanning element into individual components, use \
",
 StyleBox[ButtonBox["Insert",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InsertMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Table/Matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/TableMatrix"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Split Spanning",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/SplitSpanning"], "MenuName"],
 "."
}], "Text",
 CellID->737865176],

Cell["\<\
To make the top element span across both columns, first select the row.\
\>", "MathCaption",
 CellID->100476293],

Cell[BoxData[GridBox[{
   {
    StyleBox["x",
     FontColor->RGBColor[1, 0.8, 0.2]], 
    StyleBox["\[Placeholder]",
     FontColor->GrayLevel[1]]},
   {"y", "z"}
  },
  GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {
      GrayLevel[0]}}]], "Input",
 CellLabel->"In[2]:=",
 CellID->480993010],

Cell[TextData[{
 "Now use the ",
 StyleBox[ButtonBox["Make Spanning",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/MakeSpanning"], "MenuName"],
 StyleBox[" menu command.", "SR"]
}], "MathCaption",
 CellID->376338161],

Cell[BoxData[GridBox[{
   {"x", "\[SpanFromLeft]"},
   {"y", "z"}
  }]], "Input",
 CellLabel->"In[2]:=",
 CellID->17120827],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->19629325],

Cell[TextData[ButtonBox["Input and Output in Notebooks",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/InputAndOutputInNotebooksOverview"]], "RelatedTutorials",
 CellID->133182837]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Entering Tables and Matrices - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Input and Output in Notebooks", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/InputAndOutputInNotebooksOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/EnteringFormulas"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/SubscriptsBarsAndOtherModifiers"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 8.5172812}", "context" -> "", 
    "keywords" -> {
     "arrays", "grids", "matrices", "menu item", "spreadsheets", "tab", 
      "tables", "hot keys", "key shortcuts", "keyboard shortcuts", 
      "key sequences"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The Mathematica front end provides an Insert > Table/Matrix submenu for \
creating and editing arrays with any specified number of rows and columns. \
Once you have such an array, you can edit it to fill in whatever elements you \
want. Mathematica treats an array like this as a matrix represented by a list \
of lists. Putting parentheses around the array makes it look more like a \
matrix, but does not affect its interpretation. ", "synonyms" -> {"1.10.5"}, 
    "title" -> "Entering Tables and Matrices", "type" -> "Tutorial", "uri" -> 
    "tutorial/EnteringTablesAndMatrices"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.10.5"->{
  Cell[1286, 44, 92, 2, 70, "Title",
   CellTags->{"S1.10.5", "5.1"},
   CellID->27005]},
 "5.1"->{
  Cell[1286, 44, 92, 2, 70, "Title",
   CellTags->{"S1.10.5", "5.1"},
   CellID->27005]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.10.5", 13605, 455},
 {"5.1", 13705, 459}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 661, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1286, 44, 92, 2, 70, "Title",
 CellTags->{"S1.10.5", "5.1"},
 CellID->27005],
Cell[1381, 48, 594, 16, 70, "Text",
 CellID->24176],
Cell[1978, 66, 174, 5, 70, "MathCaption",
 CellID->18479],
Cell[CellGroupData[{
Cell[2177, 75, 115, 5, 39, "Input",
 CellID->1695],
Cell[2295, 82, 322, 11, 36, "Output",
 CellID->126803562]
}, Open  ]],
Cell[2632, 96, 160, 4, 70, "MathCaption",
 CellID->32468],
Cell[CellGroupData[{
Cell[2817, 104, 141, 6, 39, "Input",
 CellID->13998],
Cell[2961, 112, 322, 11, 36, "Output",
 CellID->443420334]
}, Open  ]],
Cell[3298, 126, 419, 16, 70, "MathCaption",
 CellID->23639],
Cell[CellGroupData[{
Cell[3742, 146, 221, 8, 39, "Input",
 CellID->29515],
Cell[3966, 156, 710, 23, 78, "Output",
 CellID->155976213]
}, Open  ]],
Cell[4691, 182, 1215, 31, 70, "DefinitionBox",
 CellID->29993],
Cell[5909, 215, 65, 1, 70, "Caption",
 CellID->15826],
Cell[5977, 218, 903, 25, 70, "Text",
 CellID->15722],
Cell[6883, 245, 238, 8, 70, "Text",
 CellID->304935857],
Cell[7124, 255, 384, 12, 70, "MathCaption",
 CellID->14092505],
Cell[7511, 269, 249, 8, 70, "Input",
 CellID->157997708],
Cell[7763, 279, 112, 3, 70, "MathCaption",
 CellID->11063108],
Cell[7878, 284, 250, 10, 70, "Input",
 CellID->54671826],
Cell[8131, 296, 193, 7, 70, "MathCaption",
 CellID->752050440],
Cell[8327, 305, 293, 11, 70, "Input",
 CellID->56459685],
Cell[8623, 318, 1227, 29, 70, "Text",
 CellID->737865176],
Cell[9853, 349, 122, 3, 70, "MathCaption",
 CellID->100476293],
Cell[9978, 354, 301, 11, 70, "Input",
 CellID->480993010],
Cell[10282, 367, 227, 7, 70, "MathCaption",
 CellID->376338161],
Cell[10512, 376, 123, 5, 70, "Input",
 CellID->17120827],
Cell[CellGroupData[{
Cell[10660, 385, 71, 1, 70, "RelatedTutorialsSection",
 CellID->19629325],
Cell[10734, 388, 187, 4, 70, "RelatedTutorials",
 CellID->133182837]
}, Open  ]]
}, Open  ]],
Cell[10948, 396, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

