(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     64011,       2412]
NotebookOptionsPosition[     51372,       1972]
NotebookOutlinePosition[     54563,       2050]
CellTagsIndexPosition[     54470,       2044]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Equations and Inequalities" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Manipulating Equations and Inequalities\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InverseFunction" :> 
          Documentation`HelpLookup["paclet:ref/InverseFunction"], "Root" :> 
          Documentation`HelpLookup["paclet:ref/Root"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"InverseFunction\"\>", 
       2->"\<\"Root\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Equations in One Variable", "Title",
 CellTags->{"S3.4.2", "2.1"},
 CellID->16840],

Cell[TextData[{
 "The main equations that ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " and related ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions deal with are ",
 StyleBox["polynomial equations",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->27633],

Cell[TextData[{
 "It is easy to solve a linear equation in\[NonBreakingSpace]",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->27037],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "x"}], "+", "b"}], "==", "c"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->23893],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "b"}], "+", "c"}], "a"]}], "}"}], "}"}]], "Output",
 ImageSize->{94, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->22630]
}, Open  ]],

Cell["\<\
One can also solve quadratic equations just by applying a simple formula. \
\>", "MathCaption",
 CellID->20274],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"a", " ", "x"}], "+", "2"}], "==", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->12993],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "-", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "8"}], "+", 
          SuperscriptBox["a", "2"]}]]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "8"}], "+", 
          SuperscriptBox["a", "2"]}]]}], ")"}]}]}], "}"}]}], "}"}]], "Output",\

 ImageSize->{332, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->28782]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can also find exact solutions to cubic equations. Here is the first \
solution to a comparatively simple cubic equation. "
}], "MathCaption",
 CellID->32203],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "+", 
      RowBox[{"34", " ", "x"}], "+", "1"}], "==", "0"}], ",", "x"}], "]"}], 
  "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->17461],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "34"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["2", 
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "9"}], "+", 
           SqrtBox["471729"]}], ")"}]}]], ")"}], 
      RowBox[{"1", "/", "3"}]]}], "+", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "9"}], "+", 
          SqrtBox["471729"]}], ")"}]}], ")"}], 
      RowBox[{"1", "/", "3"}]], 
     SuperscriptBox["3", 
      RowBox[{"2", "/", "3"}]]]}]}], "}"}]], "Output",
 ImageSize->{374, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->8290]
}, Open  ]],

Cell[TextData[{
 "For cubic and quartic equations the results are often complicated, but for \
all equations with degrees up to four ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is always able to give explicit formulas for the solutions. "
}], "Text",
 CellID->19662],

Cell[TextData[{
 "An important feature of these formulas is that they involve only ",
 StyleBox["radicals",
  FontSlant->"Italic"],
 ": arithmetic combinations of square roots, cube roots and higher roots. "
}], "Text",
 CellID->22307],

Cell["\<\
It is a fundamental mathematical fact, however, that for equations of degree \
five or higher, it is no longer possible in general to give explicit formulas \
for solutions in terms of radicals.\
\>", "Text",
 CellID->20997],

Cell["\<\
There are some specific equations for which this is still possible, but in \
the vast majority of cases it is not. \
\>", "Text",
 CellID->31151],

Cell["This constructs a degree six polynomial. ", "MathCaption",
 CellID->18423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{"Product", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"2", " ", "i"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->8890],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "48"}], "+", 
  RowBox[{"44", " ", 
   SuperscriptBox["x", "2"]}], "-", 
  RowBox[{"12", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  SuperscriptBox["x", "6"]}]], "Output",
 ImageSize->{136, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->16717]
}, Open  ]],

Cell[TextData[{
 "For a polynomial that factors in the way this one does, it is \
straightforward for ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " to find the roots. "
}], "MathCaption",
 CellID->6640],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"%", "==", "0"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->28703],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      SqrtBox["2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     SqrtBox["2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      SqrtBox["6"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     SqrtBox["6"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{429, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->5566]
}, Open  ]],

Cell["This constructs a polynomial of degree eight. ", "MathCaption",
 CellID->4883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", "2"}], "/.", 
    RowBox[{"x", "->", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "3"}]}]}], "/.", 
   RowBox[{"x", "->", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", "5"}]}]}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->23661],

Cell[BoxData[
 RowBox[{"482", "-", 
  RowBox[{"440", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"144", " ", 
   SuperscriptBox["x", "4"]}], "-", 
  RowBox[{"20", " ", 
   SuperscriptBox["x", "6"]}], "+", 
  SuperscriptBox["x", "8"]}]], "Output",
 ImageSize->{191, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->22659]
}, Open  ]],

Cell[TextData[{
 "The polynomial does not factor, but it can be decomposed into nested \
polynomials, so ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " can again find explicit formulas for the roots. "
}], "MathCaption",
 CellID->18245],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"%", "==", "0"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->20386],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"5", "-", 
        SqrtBox[
         RowBox[{"3", "-", 
          SqrtBox["2"]}]]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     SqrtBox[
      RowBox[{"5", "-", 
       SqrtBox[
        RowBox[{"3", "-", 
         SqrtBox["2"]}]]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"5", "+", 
        SqrtBox[
         RowBox[{"3", "-", 
          SqrtBox["2"]}]]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     SqrtBox[
      RowBox[{"5", "+", 
       SqrtBox[
        RowBox[{"3", "-", 
         SqrtBox["2"]}]]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"5", "-", 
        SqrtBox[
         RowBox[{"3", "+", 
          SqrtBox["2"]}]]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     SqrtBox[
      RowBox[{"5", "-", 
       SqrtBox[
        RowBox[{"3", "+", 
         SqrtBox["2"]}]]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"5", "+", 
        SqrtBox[
         RowBox[{"3", "+", 
          SqrtBox["2"]}]]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     SqrtBox[
      RowBox[{"5", "+", 
       SqrtBox[
        RowBox[{"3", "+", 
         SqrtBox["2"]}]]}]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{473, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->32651]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Root",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Root"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["k", "TI"], "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula"],
     " root of the equation ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["x", "TI"], "]", "==", "0"}]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->32765],

Cell["Implicit representation for roots. ", "Caption",
 CellID->19601],

Cell[TextData[{
 "No explicit formulas for the solution to this equation can be given in \
terms of radicals, so ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses an implicit symbolic representation."
}], "MathCaption",
 CellID->17209],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "5"}], "-", "x", "+", "11"}], "==", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->1497],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"11", "-", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"11", "-", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "2"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"11", "-", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "3"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"11", "-", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "4"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"11", "-", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "5"}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{582, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->27283]
}, Open  ]],

Cell["This finds a numerical approximation to each root. ", "MathCaption",
 CellID->29250],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->18058],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1.6614869808014447`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.4619400851906823`"}], "-", 
      RowBox[{"1.5649989957979031`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.4619400851906823`"}], "+", 
      RowBox[{"1.5649989957979031`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"1.2926835755914046`", "\[InvisibleSpace]", "-", 
      RowBox[{"0.9030321731520191`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"1.2926835755914046`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.9030321731520191`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{439, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->8421]
}, Open  ]],

Cell[TextData[{
 "If what you want in the end is a numerical solution, it is usually much \
faster to use ",
 Cell[BoxData[
  ButtonBox["NSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSolve"]], "InlineFormula"],
 " from the outset. "
}], "MathCaption",
 CellID->175],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "5"}], "-", "x", "+", "11"}], "==", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->30581],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1.6614869808014447`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.4619400851906823`"}], "-", 
      RowBox[{"1.5649989957979031`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.4619400851906823`"}], "+", 
      RowBox[{"1.5649989957979031`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"1.2926835755914046`", "\[InvisibleSpace]", "-", 
      RowBox[{"0.9030321731520191`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"1.2926835755914046`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.9030321731520191`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{439, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->26787]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects provide an exact, though implicit, representation for the roots of \
a polynomial. You can work with them much as you would work with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sqrt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sqrt"], "[", "2", "]"}]], "InlineFormula"],
 " or any other expression that represents an exact numerical quantity. "
}], "Text",
 CellID->3271],

Cell[TextData[{
 "Here is the ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " object representing the first root of the polynomial discussed above. "
}], "MathCaption",
 CellID->4287],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "^", "5"}], "-", "#", "+", "11"}], "&"}], ",", "1"}], 
   "]"}]}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->27999],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"11", "-", "#1", "+", 
     SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}]], "Output",
 ImageSize->{148, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->12504]
}, Open  ]],

Cell["This is a numerical approximation to its value. ", "MathCaption",
 CellID->24979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "r", "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->2138],

Cell[BoxData[
 RowBox[{"-", "1.6614869808014447`"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->10700]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Round",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Round"]], "InlineFormula"],
 " does an exact computation to find the closest integer to the root. "
}], "MathCaption",
 CellID->530],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Round", "[", "r", "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->2461],

Cell[BoxData[
 RowBox[{"-", "2"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->12118]
}, Open  ]],

Cell["\<\
If you substitute the root into the original polynomial, and then simplify \
the result, you get zero. \
\>", "MathCaption",
 CellID->205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "5"}], "-", "x", "+", "11"}], "/.", 
   RowBox[{"x", "->", "r"}]}], "]"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->7540],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->18828]
}, Open  ]],

Cell["\<\
This finds the product of all the roots of the original polynomial. \
\>", "MathCaption",
 CellID->24459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"Product", "[", 
   RowBox[{
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"11", "-", "#", "+", 
        RowBox[{"#", "^", "5"}]}], "&"}], ",", "k"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->11622],

Cell[BoxData[
 RowBox[{"-", "11"}]], "Output",
 ImageSize->{26, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->14398]
}, Open  ]],

Cell["The complex conjugate of the third root is the second root. ", \
"MathCaption",
 CellID->3760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Conjugate", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"11", "-", "#", "+", 
      RowBox[{"#", "^", "5"}]}], "&"}], ",", "3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->27098],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"11", "-", "#1", "+", 
     SuperscriptBox["#1", "5"]}], "&"}], ",", "2"}], "]"}]], "Output",
 ImageSize->{148, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->12935]
}, Open  ]],

Cell["\<\
If the only symbolic parameter that exists in an equation is the variable \
that you are solving for, then all the solutions to the equation will just be \
numbers. But if there are other symbolic parameters in the equation, then the \
solutions will typically be functions of these parameters.\
\>", "Text",
 CellID->10481],

Cell[TextData[{
 "The solution to this equation can again be represented by ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects, but now each ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " object involves the parameter ",
 Cell[BoxData["a"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->30614],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "5"}], "+", "x", "+", "a"}], "==", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->19567],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"a", "+", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"a", "+", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "2"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"a", "+", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "3"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"a", "+", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "4"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"a", "+", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "5"}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{561, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]= ",
 CellID->18493]
}, Open  ]],

Cell[TextData[{
 "When ",
 Cell[BoxData["a"], "InlineFormula"],
 " is replaced with ",
 Cell[BoxData["1"], "InlineFormula"],
 ", the ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects can be simplified, and some are given as explicit radicals. "
}], "MathCaption",
 CellID->28596],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"%", "/.", 
   RowBox[{"a", "->", "1"}]}], "]"}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->19161],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         SuperscriptBox["#1", "2"], "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], "+", 
        SqrtBox["3"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{"\[ImaginaryI]", "+", 
        SqrtBox["3"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         SuperscriptBox["#1", "2"], "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "2"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         SuperscriptBox["#1", "2"], "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "3"}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{519, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]= ",
 CellID->7746]
}, Open  ]],

Cell[TextData[{
 "This shows the behavior of the first root as a function of ",
 Cell[BoxData["a"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->10538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "5"}], "+", "#", "+", "a"}], "&"}], ",", "1"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[19]:= ",
 CellID->7670],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]= ",
 CellID->769030521]
}, Open  ]],

Cell[TextData[{
 "This finds the derivative of the first root with respect to ",
 Cell[BoxData["a"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21476],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "5"}], "+", "#", "+", "a"}], "&"}], ",", "1"}], 
    "]"}], ",", "a"}], "]"}]], "Input",
 CellLabel->"In[20]:= ",
 CellID->21555],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["1", 
   RowBox[{"1", "+", 
    RowBox[{"5", " ", 
     SuperscriptBox[
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"a", "+", "#1", "+", 
          SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}], 
      "4"]}]}]]}]], "Output",
 ImageSize->{188, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]= ",
 CellID->24917]
}, Open  ]],

Cell[TextData[{
 "If you give ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " any ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineMath"],
 "\[Hyphen]degree polynomial equation, then it will always return exactly ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " solutions, although some of these may be represented by ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects. If there are degenerate solutions, then the number of times that \
each particular solution appears will be equal to its multiplicity."
}], "Text",
 CellID->16371],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " gives two identical solutions to this equation. "
}], "MathCaption",
 CellID->16760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "==", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[21]:= ",
 CellID->5752],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]= ",
 CellID->13758]
}, Open  ]],

Cell["\<\
Here are the first four solutions to a tenth degree equation. The solutions \
come in pairs. \
\>", "MathCaption",
 CellID->15433],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"x", "^", "5"}], "-", "x", "+", "11"}], ")"}], "^", "2"}], "==",
       "0"}], ",", "x"}], "]"}], ",", "4"}], "]"}]], "Input",
 CellLabel->"In[22]:= ",
 CellID->32255],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"11", "-", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"11", "-", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"11", "-", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "2"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"11", "-", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "2"}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{391, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]= ",
 CellID->29065]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " also knows how to solve equations which are not explicitly in the form of \
polynomials. "
}], "Text",
 CellID->726],

Cell["Here is an equation involving square roots. ", "MathCaption",
 CellID->2401],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", "x", "]"}], "+", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "+", "x"}], "]"}]}], "==", "a"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[23]:= ",
 CellID->3034],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    FractionBox[
     RowBox[{"1", "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"]}], "+", 
      SuperscriptBox["a", "4"]}], 
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"]}]]}], "}"}], "}"}]], "Output",
 ImageSize->{127, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]= ",
 CellID->12759]
}, Open  ]],

Cell["And here is one involving logarithms. ", "MathCaption",
 CellID->10393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", "x", "]"}], "+", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", "x"}], "]"}]}], "==", "a"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[24]:= ",
 CellID->30548],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SqrtBox[
         RowBox[{"1", "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", "a"]}]}]]}], ")"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SqrtBox[
         RowBox[{"1", "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", "a"]}]}]]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{321, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]= ",
 CellID->27273]
}, Open  ]],

Cell[TextData[{
 "So long as it can reduce an equation to some kind of polynomial form, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will always be able to represent its solution in terms of ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects. However, with more general equations, involving say \
transcendental functions, there is no systematic way to use ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects, or even necessarily to find numerical approximations."
}], "Text",
 CellID->18792],

Cell[TextData[{
 "Here is a simple transcendental equation for ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->16193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcSin", "[", "x", "]"}], "==", "a"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[25]:= ",
 CellID->12933],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"Sin", "[", "a", "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]= ",
 CellID->30137]
}, Open  ]],

Cell["\<\
There is no solution to this equation in terms of standard functions. \
\>", "MathCaption",
 CellID->17103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "==", "x"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[26]:= ",
 CellID->3690],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"tdep\"\>"}], ":", 
  " ", "\<\"The equations appear to involve the variables to be solved for in \
an essentially non-algebraic way.\"\>"}]], "Message", "MSG",
 CellID->28211],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "\[Equal]", "x"}], ",", "x"}], 
  "]"}]], "Output",
 ImageSize->{138, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]= ",
 CellID->13694]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can nevertheless find a numerical solution even in this case. "
}], "MathCaption",
 CellID->24668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "==", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[27]:= ",
 CellID->32627],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "0.7390851332151607`"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]= ",
 CellID->7498]
}, Open  ]],

Cell[TextData[{
 "Polynomial equations in one variable only ever have a finite number of \
solutions. But transcendental equations often have an infinite number. \
Typically the reason for this is that functions like ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " in effect have infinitely many possible inverses. With the default option \
setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseFunctions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFunctions"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " will nevertheless assume that there is a definite inverse for any such \
function. ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " may then be able to return particular solutions in terms of this inverse \
function. "
}], "Text",
 CellID->989],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " returns a particular solution in terms of ",
 Cell[BoxData[
  ButtonBox["ArcSin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSin"]], "InlineFormula"],
 ", but prints a warning indicating that other solutions are lost. "
}], "MathCaption",
 CellID->15248],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "==", "a"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[28]:= ",
 CellID->3879],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution \
information.\"\>"}]], "Message", "MSG",
 CellID->11647],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"ArcSin", "[", "a", "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]= ",
 CellID->11149]
}, Open  ]],

Cell[TextData[{
 "Here the answer comes out in terms of ",
 Cell[BoxData[
  ButtonBox["ProductLog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ProductLog"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->30931],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Exp", "[", "x", "]"}], "+", "x", "+", "1"}], "==", "0"}], ",", 
   "x"}], "]"}]], "Input",
 CellLabel->"In[29]:= ",
 CellID->669],

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used. Values may be lost for \
multivalued inverses.\"\>"}]], "Message", "MSG",
 CellID->30875],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution \
information.\"\>"}]], "Message", "MSG",
 CellID->25598],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{
     RowBox[{"-", "1"}], "-", 
     RowBox[{"ProductLog", "[", 
      FractionBox["1", "\[ExponentialE]"], "]"}]}]}], "}"}], "}"}]], "Output",\

 ImageSize->{178, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]= ",
 CellID->25449]
}, Open  ]],

Cell[TextData[{
 "If you ask ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " to solve an equation involving an arbitrary function like ",
 Cell[BoxData["f"], "InlineFormula"],
 ", it will by default try to construct a formal solution in terms of inverse \
functions. "
}], "Text",
 CellID->25436],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " by default uses a formal inverse for the function ",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->24599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "==", "a"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[30]:= ",
 CellID->20123],

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used. Values may be lost for \
multivalued inverses.\"\>"}]], "Message", "MSG",
 CellID->1443],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{
     TagBox[
      SuperscriptBox["f", 
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}]],
      {InverseFunction, 1, 1},
      Editable->False], "[", "a", "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{104, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]= ",
 CellID->1731]
}, Open  ]],

Cell["This is the structure of the inverse function. ", "MathCaption",
 CellID->18154],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[31]:= ",
 CellID->22861],

Cell["{{x -> InverseFunction[f, 1, 1][a]}}", "Output",
 ImageSize->{252, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]//InputForm= ",
 CellID->4434]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["InverseFunction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseFunction"], "[", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "the inverse function of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["InverseFunction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseFunction"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["k", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "the inverse function of the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "\[Hyphen]argument function ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " with respect to its ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula"],
     " argument"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->9385],

Cell["Inverse functions. ", "Caption",
 CellID->23967],

Cell["This returns an explicit inverse function. ", "MathCaption",
 CellID->10816],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFunction", "[", "Tan", "]"}]], "Input",
 CellLabel->"In[32]:= ",
 CellID->11393],

Cell[BoxData["ArcTan"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[32]= ",
 CellID->16704]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can do formal operations on inverse functions. "
}], "MathCaption",
 CellID->29866],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"InverseFunction", "[", "f", "]"}], "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[33]:= ",
 CellID->30953],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "x"}], 
  RowBox[{
   SuperscriptBox["f", "\[Prime]",
    MultilineFunction->None], "[", 
   RowBox[{
    TagBox[
     SuperscriptBox["f", 
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}]],
     InverseFunction,
     Editable->False], "[", 
    SuperscriptBox["x", "2"], "]"}], "]"}]]], "Output",
 ImageSize->{87, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[33]= ",
 CellID->30308]
}, Open  ]],

Cell[TextData[{
 "While ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " can only give specific solutions to an equation, ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " can give a representation of a whole solution set. For transcendental \
equations, it often ends up introducing new parameters, say with values \
ranging over all possible integers. "
}], "Text",
 CellID->28223],

Cell["This is a complete representation of the solution set. ", "MathCaption",
 CellID->18684],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "==", "a"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[34]:= ",
 CellID->30792],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"\[Pi]", "-", 
      RowBox[{"ArcSin", "[", "a", "]"}], "+", 
      RowBox[{"2", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "1", "]"}]}]}]}], "||", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      RowBox[{"ArcSin", "[", "a", "]"}], "+", 
      RowBox[{"2", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "1", "]"}]}]}]}]}], ")"}]}]], "Output",
 ImageSize->{474, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[34]= ",
 CellID->22667]
}, Open  ]],

Cell["Here again is a representation of the general solution. ", "MathCaption",
 CellID->10048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Exp", "[", "x", "]"}], "+", "x", "+", "1"}], "==", "0"}], ",", 
   "x"}], "]"}]], "Input",
 CellLabel->"In[35]:= ",
 CellID->32469],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{"-", "1"}], "-", 
    RowBox[{"ProductLog", "[", 
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], ",", 
      FractionBox["1", "\[ExponentialE]"]}], "]"}]}]}]}]], "Output",
 ImageSize->{308, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[35]= ",
 CellID->13930]
}, Open  ]],

Cell[TextData[{
 "As discussed at more length in \"",
 ButtonBox["Equations and Inequalities over Domains\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/EquationsAndInequalitiesOverDomains"],
 ", ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " allows you to restrict the domains of variables. Sometimes this will let \
you generate definite solutions to transcendental equations\[LongDash]or show \
that they do not exist. "
}], "Text",
 CellID->30811],

Cell[TextData[{
 "With the domain of ",
 Cell[BoxData["x"], "InlineFormula"],
 " restricted, this yields definite solutions. "
}], "MathCaption",
 CellID->19814],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], "==", 
      RowBox[{"1", "/", "2"}]}], ",", 
     RowBox[{
      RowBox[{"Abs", "[", "x", "]"}], "<", "4"}]}], "}"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[36]:= ",
 CellID->16090],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"7", " ", "\[Pi]"}], "6"]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   FractionBox["\[Pi]", "6"]}], "||", 
  RowBox[{"x", "\[Equal]", 
   FractionBox[
    RowBox[{"5", " ", "\[Pi]"}], "6"]}]}]], "Output",
 ImageSize->{180, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[36]= ",
 CellID->5427]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData["x"], "InlineFormula"],
 " constrained to be real, only one solution is possible. "
}], "MathCaption",
 CellID->23743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Exp", "[", "x", "]"}], "+", "x", "+", "1"}], "==", "0"}], ",", 
   "x", ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[37]:= ",
 CellID->1604],

Cell[BoxData[
 RowBox[{"x", "\[Equal]", 
  RowBox[{
   RowBox[{"-", "1"}], "-", 
   RowBox[{"ProductLog", "[", 
    FractionBox["1", "\[ExponentialE]"], "]"}]}]}]], "Output",
 ImageSize->{151, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[37]= ",
 CellID->10599]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " knows there can be no solution here. "
}], "MathCaption",
 CellID->16474],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], "==", "x"}], ",", 
     RowBox[{"x", ">", "1"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[38]:= ",
 CellID->7195],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[38]= ",
 CellID->506]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->718953167],

Cell[TextData[ButtonBox["Manipulating Equations and Inequalities",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"]], \
"RelatedTutorials",
 CellID->6804882]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Equations in One Variable - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Manipulating Equations and Inequalities", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/TheRepresentationOfEquationsAndSolutions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/AlgebraicNumbers"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 11.9704946}", "context" -> "", 
    "keywords" -> {
     "Abel Theorem", "algebraic curves", "algebraic equations", 
      "biquadratic equations", "quartic equations", "bi-quadratic", 
      "Cardano formula", "cubic equations", "curves", 
      "decomposition of polynomials", "equations", "exponential equations", 
      "implicit curves", "impossibility", "InverseFunction", 
      "InverseFunctions", "linear equations", "multiplicity", "NSolve", 
      "polynomial equations", "polynomials", "quadratic equations", 
      "quartic equations", "quintic equations", "radicals", "Root", "roots", 
      "roots of equations", "transcendental equations"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "The main equations that Solve and related Mathematica functions deal \
with are polynomial equations. It is easy to solve a linear equation in x. \
One can also solve quadratic equations just by applying a simple formula. ", 
    "synonyms" -> {"3.4.2"}, "title" -> "Equations in One Variable", "type" -> 
    "Tutorial", "uri" -> "tutorial/EquationsInOneVariable"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.4.2"->{
  Cell[1972, 61, 88, 2, 70, "Title",
   CellTags->{"S3.4.2", "2.1"},
   CellID->16840]},
 "2.1"->{
  Cell[1972, 61, 88, 2, 70, "Title",
   CellTags->{"S3.4.2", "2.1"},
   CellID->16840]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.4.2", 54259, 2033},
 {"2.1", 54358, 2037}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1347, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1972, 61, 88, 2, 70, "Title",
 CellTags->{"S3.4.2", "2.1"},
 CellID->16840],
Cell[2063, 65, 346, 14, 70, "Text",
 CellID->27633],
Cell[2412, 81, 158, 5, 70, "MathCaption",
 CellID->27037],
Cell[CellGroupData[{
Cell[2595, 90, 200, 8, 28, "Input",
 CellID->23893],
Cell[2798, 100, 301, 11, 51, "Output",
 CellID->22630]
}, Open  ]],
Cell[3114, 114, 121, 3, 70, "MathCaption",
 CellID->20274],
Cell[CellGroupData[{
Cell[3260, 121, 236, 9, 28, "Input",
 CellID->12993],
Cell[3499, 132, 785, 30, 52, "Output",
 CellID->28782]
}, Open  ]],
Cell[4299, 165, 225, 6, 70, "MathCaption",
 CellID->32203],
Cell[CellGroupData[{
Cell[4549, 175, 293, 11, 28, "Input",
 CellID->17461],
Cell[4845, 188, 850, 31, 72, "Output",
 CellID->8290]
}, Open  ]],
Cell[5710, 222, 277, 7, 70, "Text",
 CellID->19662],
Cell[5990, 231, 235, 6, 70, "Text",
 CellID->22307],
Cell[6228, 239, 234, 5, 70, "Text",
 CellID->20997],
Cell[6465, 246, 155, 4, 70, "Text",
 CellID->31151],
Cell[6623, 252, 80, 1, 70, "MathCaption",
 CellID->18423],
Cell[CellGroupData[{
Cell[6728, 257, 284, 10, 70, "Input",
 CellID->8890],
Cell[7015, 269, 339, 12, 36, "Output",
 CellID->16717]
}, Open  ]],
Cell[7369, 284, 275, 9, 70, "MathCaption",
 CellID->6640],
Cell[CellGroupData[{
Cell[7669, 297, 146, 5, 70, "Input",
 CellID->28703],
Cell[7818, 304, 695, 26, 43, "Output",
 CellID->5566]
}, Open  ]],
Cell[8528, 333, 84, 1, 70, "MathCaption",
 CellID->4883],
Cell[CellGroupData[{
Cell[8637, 338, 354, 13, 70, "Input",
 CellID->23661],
Cell[8994, 353, 383, 13, 36, "Output",
 CellID->22659]
}, Open  ]],
Cell[9392, 369, 308, 9, 70, "MathCaption",
 CellID->18245],
Cell[CellGroupData[{
Cell[9725, 382, 146, 5, 70, "Input",
 CellID->20386],
Cell[9874, 389, 1662, 67, 138, "Output",
 CellID->32651]
}, Open  ]],
Cell[11551, 459, 906, 28, 70, "DefinitionBox",
 CellID->32765],
Cell[12460, 489, 70, 1, 70, "Caption",
 CellID->19601],
Cell[12533, 492, 245, 7, 70, "MathCaption",
 CellID->17209],
Cell[CellGroupData[{
Cell[12803, 503, 210, 8, 70, "Input",
 CellID->1497],
Cell[13016, 513, 1310, 47, 58, "Output",
 CellID->27283]
}, Open  ]],
Cell[14341, 563, 90, 1, 70, "MathCaption",
 CellID->29250],
Cell[CellGroupData[{
Cell[14456, 568, 94, 3, 70, "Input",
 CellID->18058],
Cell[14553, 573, 1037, 29, 54, "Output",
 CellID->8421]
}, Open  ]],
Cell[15605, 605, 278, 9, 70, "MathCaption",
 CellID->175],
Cell[CellGroupData[{
Cell[15908, 618, 213, 8, 70, "Input",
 CellID->30581],
Cell[16124, 628, 1039, 29, 54, "Output",
 CellID->26787]
}, Open  ]],
Cell[17178, 660, 517, 14, 70, "Text",
 CellID->3271],
Cell[17698, 676, 252, 8, 70, "MathCaption",
 CellID->4287],
Cell[CellGroupData[{
Cell[17975, 688, 233, 9, 70, "Input",
 CellID->27999],
Cell[18211, 699, 294, 10, 39, "Output",
 CellID->12504]
}, Open  ]],
Cell[18520, 712, 87, 1, 70, "MathCaption",
 CellID->24979],
Cell[CellGroupData[{
Cell[18632, 717, 94, 3, 70, "Input",
 CellID->2138],
Cell[18729, 722, 191, 6, 36, "Output",
 CellID->10700]
}, Open  ]],
Cell[18935, 731, 233, 7, 70, "MathCaption",
 CellID->530],
Cell[CellGroupData[{
Cell[19193, 742, 98, 3, 70, "Input",
 CellID->2461],
Cell[19294, 747, 173, 6, 36, "Output",
 CellID->12118]
}, Open  ]],
Cell[19482, 756, 148, 4, 70, "MathCaption",
 CellID->205],
Cell[CellGroupData[{
Cell[19655, 764, 214, 7, 70, "Input",
 CellID->7540],
Cell[19872, 773, 156, 5, 36, "Output",
 CellID->18828]
}, Open  ]],
Cell[20043, 781, 115, 3, 70, "MathCaption",
 CellID->24459],
Cell[CellGroupData[{
Cell[20183, 788, 364, 12, 70, "Input",
 CellID->11622],
Cell[20550, 802, 174, 6, 36, "Output",
 CellID->14398]
}, Open  ]],
Cell[20739, 811, 100, 2, 70, "MathCaption",
 CellID->3760],
Cell[CellGroupData[{
Cell[20864, 817, 242, 8, 70, "Input",
 CellID->27098],
Cell[21109, 827, 294, 10, 39, "Output",
 CellID->12935]
}, Open  ]],
Cell[21418, 840, 334, 6, 70, "Text",
 CellID->10481],
Cell[21755, 848, 443, 15, 70, "MathCaption",
 CellID->30614],
Cell[CellGroupData[{
Cell[22223, 867, 211, 8, 70, "Input",
 CellID->19567],
Cell[22437, 877, 1306, 47, 58, "Output",
 CellID->18493]
}, Open  ]],
Cell[23758, 927, 354, 12, 70, "MathCaption",
 CellID->28596],
Cell[CellGroupData[{
Cell[24137, 943, 151, 5, 70, "Input",
 CellID->19161],
Cell[24291, 950, 1441, 50, 81, "Output",
 CellID->7746]
}, Open  ]],
Cell[25747, 1003, 158, 5, 70, "MathCaption",
 CellID->10538],
Cell[CellGroupData[{
Cell[25930, 1012, 348, 13, 28, "Input",
 CellID->7670],
Cell[26281, 1027, 2321, 42, 135, "Output",
 Evaluatable->False,
 CellID->769030521]
}, Open  ]],
Cell[28617, 1072, 159, 5, 70, "MathCaption",
 CellID->21476],
Cell[CellGroupData[{
Cell[28801, 1081, 266, 10, 70, "Input",
 CellID->21555],
Cell[29070, 1093, 439, 16, 58, "Output",
 CellID->24917]
}, Open  ]],
Cell[29524, 1112, 805, 23, 70, "Text",
 CellID->16371],
Cell[30332, 1137, 216, 7, 70, "MathCaption",
 CellID->16760],
Cell[CellGroupData[{
Cell[30573, 1148, 227, 9, 70, "Input",
 CellID->5752],
Cell[30803, 1159, 312, 11, 36, "Output",
 CellID->13758]
}, Open  ]],
Cell[31130, 1173, 140, 4, 70, "MathCaption",
 CellID->15433],
Cell[CellGroupData[{
Cell[31295, 1181, 338, 12, 70, "Input",
 CellID->32255],
Cell[31636, 1195, 1085, 39, 58, "Output",
 CellID->29065]
}, Open  ]],
Cell[32736, 1237, 184, 6, 70, "Text",
 CellID->726],
Cell[32923, 1245, 82, 1, 70, "MathCaption",
 CellID->2401],
Cell[CellGroupData[{
Cell[33030, 1250, 269, 10, 70, "Input",
 CellID->3034],
Cell[33302, 1262, 429, 15, 56, "Output",
 CellID->12759]
}, Open  ]],
Cell[33746, 1280, 77, 1, 70, "MathCaption",
 CellID->10393],
Cell[CellGroupData[{
Cell[33848, 1285, 268, 10, 70, "Input",
 CellID->30548],
Cell[34119, 1297, 783, 29, 51, "Output",
 CellID->27273]
}, Open  ]],
Cell[34917, 1329, 649, 17, 70, "Text",
 CellID->18792],
Cell[35569, 1348, 144, 5, 70, "MathCaption",
 CellID->16193],
Cell[CellGroupData[{
Cell[35738, 1357, 185, 7, 70, "Input",
 CellID->12933],
Cell[35926, 1366, 263, 9, 36, "Output",
 CellID->30137]
}, Open  ]],
Cell[36204, 1378, 117, 3, 70, "MathCaption",
 CellID->17103],
Cell[CellGroupData[{
Cell[36346, 1385, 178, 6, 70, "Input",
 CellID->3690],
Cell[36527, 1393, 229, 5, 70, "Message",
 CellID->28211],
Cell[36759, 1400, 277, 10, 36, "Output",
 CellID->13694]
}, Open  ]],
Cell[37051, 1413, 166, 5, 70, "MathCaption",
 CellID->24668],
Cell[CellGroupData[{
Cell[37242, 1422, 231, 8, 70, "Input",
 CellID->32627],
Cell[37476, 1432, 224, 7, 36, "Output",
 CellID->7498]
}, Open  ]],
Cell[37715, 1442, 1094, 32, 70, "Text",
 CellID->989],
Cell[38812, 1476, 331, 10, 70, "MathCaption",
 CellID->15248],
Cell[CellGroupData[{
Cell[39168, 1490, 178, 6, 70, "Input",
 CellID->3879],
Cell[39349, 1498, 265, 6, 70, "Message",
 CellID->11647],
Cell[39617, 1506, 267, 9, 36, "Output",
 CellID->11149]
}, Open  ]],
Cell[39899, 1518, 222, 8, 70, "MathCaption",
 CellID->30931],
Cell[CellGroupData[{
Cell[40146, 1530, 217, 8, 70, "Input",
 CellID->669],
Cell[40366, 1540, 218, 5, 70, "Message",
 CellID->30875],
Cell[40587, 1547, 265, 6, 70, "Message",
 CellID->25598],
Cell[40855, 1555, 359, 13, 51, "Output",
 CellID->25449]
}, Open  ]],
Cell[41229, 1571, 367, 11, 70, "Text",
 CellID->25436],
Cell[41599, 1584, 263, 9, 70, "MathCaption",
 CellID->24599],
Cell[CellGroupData[{
Cell[41887, 1597, 177, 6, 70, "Input",
 CellID->20123],
Cell[42067, 1605, 217, 5, 70, "Message",
 CellID->1443],
Cell[42287, 1612, 409, 15, 39, "Output",
 CellID->1731]
}, Open  ]],
Cell[42711, 1630, 86, 1, 70, "MathCaption",
 CellID->18154],
Cell[CellGroupData[{
Cell[42822, 1635, 103, 3, 70, "Input",
 CellID->22861],
Cell[42928, 1640, 193, 5, 50, "Output",
 CellID->4434]
}, Open  ]],
Cell[43136, 1648, 1329, 41, 70, "DefinitionBox",
 CellID->9385],
Cell[44468, 1691, 54, 1, 70, "Caption",
 CellID->23967],
Cell[44525, 1694, 82, 1, 70, "MathCaption",
 CellID->10816],
Cell[CellGroupData[{
Cell[44632, 1699, 111, 3, 70, "Input",
 CellID->11393],
Cell[44746, 1704, 161, 5, 36, "Output",
 CellID->16704]
}, Open  ]],
Cell[44922, 1712, 151, 5, 70, "MathCaption",
 CellID->29866],
Cell[CellGroupData[{
Cell[45098, 1721, 216, 7, 70, "Input",
 CellID->30953],
Cell[45317, 1730, 477, 18, 57, "Output",
 CellID->30308]
}, Open  ]],
Cell[45809, 1751, 524, 15, 70, "Text",
 CellID->28223],
Cell[46336, 1768, 94, 1, 70, "MathCaption",
 CellID->18684],
Cell[CellGroupData[{
Cell[46455, 1773, 180, 6, 70, "Input",
 CellID->30792],
Cell[46638, 1781, 648, 20, 36, "Output",
 CellID->22667]
}, Open  ]],
Cell[47301, 1804, 95, 1, 70, "MathCaption",
 CellID->10048],
Cell[CellGroupData[{
Cell[47421, 1809, 220, 8, 70, "Input",
 CellID->32469],
Cell[47644, 1819, 458, 15, 51, "Output",
 CellID->13930]
}, Open  ]],
Cell[48117, 1837, 534, 14, 70, "Text",
 CellID->30811],
Cell[48654, 1853, 161, 5, 70, "MathCaption",
 CellID->19814],
Cell[CellGroupData[{
Cell[48840, 1862, 323, 12, 70, "Input",
 CellID->16090],
Cell[49166, 1876, 429, 15, 51, "Output",
 CellID->5427]
}, Open  ]],
Cell[49610, 1894, 158, 5, 70, "MathCaption",
 CellID->23743],
Cell[CellGroupData[{
Cell[49793, 1903, 233, 8, 70, "Input",
 CellID->1604],
Cell[50029, 1913, 303, 10, 51, "Output",
 CellID->10599]
}, Open  ]],
Cell[50347, 1926, 207, 7, 70, "MathCaption",
 CellID->16474],
Cell[CellGroupData[{
Cell[50579, 1937, 258, 9, 70, "Input",
 CellID->7195],
Cell[50840, 1948, 158, 5, 36, "Output",
 CellID->506]
}, Open  ]],
Cell[CellGroupData[{
Cell[51035, 1958, 72, 1, 70, "RelatedTutorialsSection",
 CellID->718953167],
Cell[51110, 1961, 208, 5, 70, "RelatedTutorials",
 CellID->6804882]
}, Open  ]]
}, Open  ]],
Cell[51345, 1970, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

