(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14007,        423]
NotebookOptionsPosition[      9970,        314]
NotebookOutlinePosition[     13138,        392]
CellTagsIndexPosition[     13044,        386]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink and External Program Communication" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]}\
, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"MathLink and External Program Communication\"\>"}, \
"\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Install" :> Documentation`HelpLookup["paclet:ref/Install"], 
          "MLAbort" :> Documentation`HelpLookup["paclet:ref/c/MLAbort"], 
          "MLClearError" :> 
          Documentation`HelpLookup["paclet:ref/c/MLClearError"], "MLError" :> 
          Documentation`HelpLookup["paclet:ref/c/MLError"], "MLErrorMessage" :> 
          Documentation`HelpLookup["paclet:ref/c/MLErrorMessage"], "MLINK" :> 
          Documentation`HelpLookup["paclet:ref/c/MLINK"], "MLNewPacket" :> 
          Documentation`HelpLookup["paclet:ref/c/MLNewPacket"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Install\"\>", 2->"\<\"MLAbort\"\>", 
       3->"\<\"MLClearError\"\>", 4->"\<\"MLError\"\>", 
       5->"\<\"MLErrorMessage\"\>", 6->"\<\"MLINK\"\>", 
       7->"\<\"MLNewPacket\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Error and Interrupt Handling", "Title",
 CellTags->{"S2.13.13", "13.1"},
 CellID->21265],

Cell[TextData[{
 "When you are putting and getting data via ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " various kinds of errors can occur. Whenever any error occurs, ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " goes into a completely inactive state, and all ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " functions you call will return 0 immediately."
}], "Text",
 CellID->31260],

Cell[BoxData[GridBox[{
   {
    RowBox[{"int", 
     ButtonBox["MLError",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLError"], 
     RowBox[{"(", 
      RowBox[{
       ButtonBox["MLINK",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/c/MLINK"], " ", 
       StyleBox["link", "TI"]}], ")"}]}], Cell[TextData[{
     "return a number identifying the current error, or ",
     Cell[BoxData["0"], "InlineFormula"],
     " if none has occurred"
    }], "TableText"]},
   {
    RowBox[{"char", "*", 
     ButtonBox["MLErrorMessage",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLErrorMessage"], 
     RowBox[{"(", 
      RowBox[{
       ButtonBox["MLINK",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/c/MLINK"], " ", 
       StyleBox["link", "TI"]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell[
    "return a character string describing the current error", "TableText"]},
   {
    RowBox[{"int", " ", 
     ButtonBox["MLClearError",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLClearError"], 
     RowBox[{"(", 
      RowBox[{
       ButtonBox["MLINK",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/c/MLINK"], " ", 
       StyleBox["link", "TI"]}], ")"}]}], Cell[TextData[{
     "clear the current error, returning ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " if possible to an active state"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {True}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->5045],

Cell[TextData[{
 "Handling errors in ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs. "
}], "Caption",
 CellID->20778],

Cell[TextData[{
 "When you do complicated operations, it is often convenient to check for \
errors only at the end. If you find that an error occurred, you must then \
call ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLClearError",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLClearError"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " to activate ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " again. "
}], "Text",
 CellID->5821],

Cell[BoxData[GridBox[{
   {
    RowBox[{"int", " ", 
     ButtonBox["MLNewPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLNewPacket"], 
     RowBox[{"(", 
      RowBox[{
       ButtonBox["MLINK",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/c/MLINK"], " ", 
       StyleBox["link", "TI"]}], ")"}]}], Cell[
    "skip to the end of the current packet", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->13855],

Cell["Clearing out the remains of a packet. ", "Caption",
 CellID->2520],

Cell[TextData[{
 "After an error, it is common to want to discard the remainder of the packet \
or expression that you are currently processing. You can do this using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLNewPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLNewPacket"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->12927],

Cell[TextData[{
 "In some cases, you may want to set it up so that if an error occurs while \
you are processing particular data, you can then later go back and reprocess \
the data in a different way. You can do this by calling ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLCreateMark",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLCreateMark"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " to create a mark before you first process the data, and then calling ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLSeekMark",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLSeekMark"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " to seek back to the mark if you need to reprocess the data. You should not \
forgot to call ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLDestroyMark",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLDestroyMark"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " when you have finally finished with the data\[LongDash]otherwise ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " will continue to store it. "
}], "Text",
 CellID->24773],

Cell[BoxData[GridBox[{
   {
    RowBox[{"int", 
     ButtonBox["MLAbort",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLAbort"]}], Cell[TextData[{
     "a global variable set when a program set up by ",
     Cell[BoxData[
      ButtonBox["Install",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Install"]], "InlineFormula"],
     " is sent an abort interrupt"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->25134],

Cell["Aborting an external program. ", "Caption",
 CellID->27251],

Cell[TextData[{
 "If you interrupt ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " while it is in the middle of executing an external function, it will \
typically give you the opportunity to try to abort the external function. If \
you choose to do this, what will happen is that the global variable ",
 Cell[BoxData[
  ButtonBox["MLAbort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/c/MLAbort"]], "InlineFormula"],
 " will be set to ",
 Cell[BoxData["1"], "InlineFormula"],
 " inside your external program. "
}], "Text",
 CellID->22675],

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " cannot automatically back out of an external function call that has been \
made. So if you have a function that can take a long time, you should \
explicitly check ",
 Cell[BoxData[
  ButtonBox["MLAbort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/c/MLAbort"]], "InlineFormula"],
 " every so often, returning from the function if you find that the variable \
has been set. "
}], "Text",
 CellID->13336],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]
}], "RelatedTutorials",
 CellID->239218697]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Error and Interrupt Handling - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "MathLink and External Program Communication", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 13.4861584}", "context" -> "", 
    "keywords" -> {
     "clearing errors", "discard packet", "error handling", 
      "handling interrupts in MathLink", "interrupts", "MLAbort", 
      "MLClearError", "MLClearError()", "MLError()", "MLErrorMessage()", 
      "MLNewPacket", "MLNewPacket()", "rewinding", "skip packet"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "When you are putting and getting data via MathLink various kinds of \
errors can occur. Whenever any error occurs, MathLink goes into a completely \
inactive state, and all MathLink functions you call will return 0 \
immediately. Handling errors in MathLink programs. When you do complicated \
operations, it is often convenient to check for errors only at the end. If \
you find that an error occurred, you must then call MLClearError() to \
activate MathLink again. ", "synonyms" -> {"2.3.13"}, "title" -> 
    "Error and Interrupt Handling", "type" -> "Tutorial", "uri" -> 
    "tutorial/ErrorAndInterruptHandling"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.13.13"->{
  Cell[2508, 68, 94, 2, 70, "Title",
   CellTags->{"S2.13.13", "13.1"},
   CellID->21265]},
 "13.1"->{
  Cell[2508, 68, 94, 2, 70, "Title",
   CellTags->{"S2.13.13", "13.1"},
   CellID->21265]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.13.13", 12826, 375},
 {"13.1", 12929, 379}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1883, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2508, 68, 94, 2, 70, "Title",
 CellTags->{"S2.13.13", "13.1"},
 CellID->21265],
Cell[2605, 72, 399, 12, 70, "Text",
 CellID->31260],
Cell[3007, 86, 1874, 56, 70, "DefinitionBox",
 CellID->5045],
Cell[4884, 144, 131, 6, 70, "Caption",
 CellID->20778],
Cell[5018, 152, 447, 15, 70, "Text",
 CellID->5821],
Cell[5468, 169, 717, 21, 70, "DefinitionBox",
 CellID->13855],
Cell[6188, 192, 72, 1, 70, "Caption",
 CellID->2520],
Cell[6263, 195, 370, 11, 70, "Text",
 CellID->12927],
Cell[6636, 208, 1086, 30, 70, "Text",
 CellID->24773],
Cell[7725, 240, 724, 21, 70, "DefinitionBox",
 CellID->25134],
Cell[8452, 263, 65, 1, 70, "Caption",
 CellID->27251],
Cell[8520, 266, 551, 15, 70, "Text",
 CellID->22675],
Cell[9074, 283, 473, 13, 70, "Text",
 CellID->13336],
Cell[9550, 298, 378, 11, 70, "RelatedTutorials",
 CellID->239218697]
}, Open  ]],
Cell[9943, 312, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

