(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17973,        484]
NotebookOptionsPosition[     13293,        353]
NotebookOutlinePosition[     16536,        431]
CellTagsIndexPosition[     16444,        425]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FrontEndExecute" :> 
          Documentation`HelpLookup["paclet:ref/FrontEndExecute"], 
          "NotebookWrite" :> 
          Documentation`HelpLookup["paclet:ref/NotebookWrite"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FrontEndExecute\"\>", 
       2->"\<\"NotebookWrite\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Executing Notebook Commands Directly in the Front End", "Title",
 CellTags->{"S2.11.5", "5.1"},
 CellID->18842],

Cell[TextData[{
 "When you execute a command like ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NotebookWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookWrite"], "[", 
   RowBox[{
    StyleBox["obj", "TI"], ",", 
    StyleBox["data", "TI"]}], "]"}]], "InlineFormula"],
 " the actual operation of inserting data into your notebook is performed in \
the front end. Normally, however, the kernel is needed in order to evaluate \
the original command, and to construct the appropriate request to send to the \
front end. But it turns out that the front end is set up to execute a limited \
collection of commands directly, without ever involving the kernel. "
}], "Text",
 CellID->17260],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NotebookWrite",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookWrite"], "[", 
     StyleBox["obj", "TI"], ",", 
     StyleBox["data", "TI"], "]"}], Cell[TextData[{
     "version of ",
     Cell[BoxData[
      ButtonBox["NotebookWrite",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NotebookWrite"]], "InlineFormula"],
     " to be executed in the kernel"
    }], "TableText"]},
   {
    RowBox[{"FrontEnd`NotebookWrite", "[", 
     StyleBox["obj", "TI"], ",", 
     StyleBox["data", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "version of ",
     Cell[BoxData[
      ButtonBox["NotebookWrite",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NotebookWrite"]], "InlineFormula"],
     " to be executed directly in the front end"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->22161],

Cell["Distinguishing kernel and front end versions of commands. ", "Caption",
 CellID->31620],

Cell[TextData[{
 "The basic way that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " distinguishes between commands to be executed in the kernel and to be \
executed directly in the front end is by using contexts. The kernel commands \
are in the usual ",
 Cell[BoxData["System`"], "InlineFormula"],
 " context, but the front end commands are in the ",
 Cell[BoxData["FrontEnd`"], "InlineFormula"],
 " context. "
}], "Text",
 CellID->4343],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FrontEndExecute",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FrontEndExecute"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "send ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to be executed in the front end"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->9578],

Cell["Sending an expression to be executed in the front end. ", "Caption",
 CellID->1187],

Cell["Here is a blank notebook. ", "MathCaption",
 CellID->113],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztV11uwjAMdhM6ECBUbZr22lvsBuOJQ1RoEjxMoI5r9bFX6WOvUmInJg0q
HararqBawiR2/Jt8qryJTrvvn+i030bhOo6Ou/32N/w6xEokPQDxDgCfIeC6
UEvDLH0gA5B6RzrF3pB5RiIvKmB93aE8z5U+SRJiK2SChJKE7IcNfRtYkTpX
ZFkGeoVsQbYTlLK2SNNUVAfHP2sb1MR1bYS2YVoiq8v6xcmac6OiuT1zMphc
yjIHahK/DqiLYZrS3r9uFZ6GVp3iT3W4XaeVmU5vdtF9pbMbWXZSeqtOSzX1
kOng+mnAOvBLeqx+jngf8FMa8T7ifcT7YPvZH97d0kvYeJrS+8V7dT9bf0rm
gv4jywfHeie37o5Z5X5qITQes+yEuqSw8t5Pd5PpspkNU0B7923+NZu/IhNa
Zz2ZYR+8M3fJU7A=\
\>"], "Picture",
 ImageSize->{533, 55},
 ImageMargins->0,
 CellID->346001242],

Cell["This uses kernel commands to write data into the notebook. ", \
"MathCaption",
 CellID->4591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookWrite", "[", 
  RowBox[{
   RowBox[{"SelectedNotebook", "[", "]"}], ",", "\"\<x + y + z\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->5934],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWFtMlEcUHvYCosbgGmt8Kl5ioqnVxqqxzao8eMNIRK02amgJGsFY1iAP
LU1MNPEFjfdofFBw1UQfMEqCpKkRW0AQVIrCGouCuKC7luyyKpduXD5n5p/Z
3Z8s67r+ijjJnH8u55w53zlz+2dFem7m5l/Sc7My0hOX5KRvz8zK2JG42JJD
m/QxhOjGEkLmJhJWBi0KEkjjGCFEr9R4HyVjGIkRLXp/F5H94Ziam5tpf1FR
ESejGNHxRj1vlHqkoDEwME2UDzabjSglRkZwWQNrlb0oKSnRhR6cfQKyCWHG
VcvoFBmZRjISzupYldXSNg5aumc4FzD4YQmGMIb3H1ABI1Mcrxv7u4pxE02V
skw9rK3SkJbGDehF9SwdNoCVHwS6pkqDMH0ESz85f4rF+okHaWj587Nd73OE
mlddr3Hxz/9wofQ5z02t3YrAFcFwoqAKGzef43l9xlns2XuVjNYuBLOFqso6
DxLm3YD+63Kec/c2q+3o9PTgqcPDc+sTF1ZtKNTSjrmc6rH/dBvGLajG/16f
ovMP0eFwvqD4z/FaQr9x32PjmcBpHG43vkTszAoYZpSj4o4Hw7+tBPmqHDuP
PlbOPypnNpvhcDh4TbYVl3VwvsJLDjIsBJ9R0PELqzmfzGPNVYrtZyPAF+Wa
nSiw9fT6sOtYK4wU3w0aZ9N3VUjZ1ojH7T1+HCaTCXa7XYUtOasBcd9UYObq
O35swXwSG50r0E0vx8miZzhT7GTzRwNsb4/dJE4NyDvYwuesOa2eYZVmZWdn
Izk5GUajEUlJSazsN7mlrYebfPz8Ux726zWdJBI5n68PqRYbJiypQbuzF+dL
n78b1CgPiYlCVV9fH1Zvt2HE7ErM/6meLxNpm9VqRX5+PuLj45GXl8fK/r5f
D7Tgi/nV8Hp9WLfjPlZmN0Ykx8Jpf9aLOT/WYd6Gf5h71XgfNDmxamMhXO4u
LUMrl2Wboxc/5NznS+baTTfGfF+FpVvuwfaoK+TUNQi5shqFd3rqbXS4vdi0
818eb2uxM6ScxPvlohpk7m7C74daEEPHTPvtgYLljBCqv9eO1PUFWJNmjXz7
i2yZVte/wNQVtzBleS3+qu3ErLV1vHz5WoffZovFApfLpcK6r8COyctqMS3l
FhqaXmHhz3d5nWIOKSexsnnE+GRevrVBMdAq1DOsLLZlfz9kc1rD3Z4zdAp9
chj2FcsnpGvf5z7g5sVY1VgsifEGghbtTcEl3P6kzY0jJyqw73AZZaZHOG1L
WXeKH+YIs0NEcznzCF3BBzXL3d1eLQ9q+NPg/lOoPRK0tQ7WdXWI/1OE9qfm
138RoMGwcoj/T3yQqKufdoL9qTSSqJ92Aq9iI/mw+khv6dG8aEUnI5OyC6vn
5tveA02M6JS+gCbxwEhi3gAYACkT\
\>"], "Picture",
 ImageSize->{533, 55},
 ImageMargins->0,
 CellID->1236734106]
}, Open  ]],

Cell["In the kernel, these commands do absolutely nothing. ", "MathCaption",
 CellID->656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FrontEnd`NotebookWrite", "[", 
  RowBox[{
   RowBox[{"FrontEnd`SelectedNotebook", "[", "]"}], ",", 
   "\"\<a + b + c + d\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->29761],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWFtMlEcUHvYCosbgGmt8Kl5ioqnVxqqxzao8eMNIRK02amgJGsFY1iAP
LU1MNPEFjfdofFBw1UQfMEqCpKkRW0AQVIrCGouCuKC7luyyKpduXD5n5p/Z
3Z8s67r+ijjJnH8u55w53zlz+2dFem7m5l/Sc7My0hOX5KRvz8zK2JG42JJD
m/QxhOjGEkLmJhJWBi0KEkjjGCFEr9R4HyVjGIkRLXp/F5H94Ziam5tpf1FR
ESejGNHxRj1vlHqkoDEwME2UDzabjSglRkZwWQNrlb0oKSnRhR6cfQKyCWHG
VcvoFBmZRjISzupYldXSNg5aumc4FzD4YQmGMIb3H1ABI1Mcrxv7u4pxE02V
skw9rK3SkJbGDehF9SwdNoCVHwS6pkqDMH0ESz85f4rF+okHaWj587Nd73OE
mlddr3Hxz/9wofQ5z02t3YrAFcFwoqAKGzef43l9xlns2XuVjNYuBLOFqso6
DxLm3YD+63Kec/c2q+3o9PTgqcPDc+sTF1ZtKNTSjrmc6rH/dBvGLajG/16f
ovMP0eFwvqD4z/FaQr9x32PjmcBpHG43vkTszAoYZpSj4o4Hw7+tBPmqHDuP
PlbOPypnNpvhcDh4TbYVl3VwvsJLDjIsBJ9R0PELqzmfzGPNVYrtZyPAF+Wa
nSiw9fT6sOtYK4wU3w0aZ9N3VUjZ1ojH7T1+HCaTCXa7XYUtOasBcd9UYObq
O35swXwSG50r0E0vx8miZzhT7GTzRwNsb4/dJE4NyDvYwuesOa2eYZVmZWdn
Izk5GUajEUlJSazsN7mlrYebfPz8Ux726zWdJBI5n68PqRYbJiypQbuzF+dL
n78b1CgPiYlCVV9fH1Zvt2HE7ErM/6meLxNpm9VqRX5+PuLj45GXl8fK/r5f
D7Tgi/nV8Hp9WLfjPlZmN0Ykx8Jpf9aLOT/WYd6Gf5h71XgfNDmxamMhXO4u
LUMrl2Wboxc/5NznS+baTTfGfF+FpVvuwfaoK+TUNQi5shqFd3rqbXS4vdi0
818eb2uxM6ScxPvlohpk7m7C74daEEPHTPvtgYLljBCqv9eO1PUFWJNmjXz7
i2yZVte/wNQVtzBleS3+qu3ErLV1vHz5WoffZovFApfLpcK6r8COyctqMS3l
FhqaXmHhz3d5nWIOKSexsnnE+GRevrVBMdAq1DOsLLZlfz9kc1rD3Z4zdAp9
chj2FcsnpGvf5z7g5sVY1VgsifEGghbtTcEl3P6kzY0jJyqw73AZZaZHOG1L
WXeKH+YIs0NEcznzCF3BBzXL3d1eLQ9q+NPg/lOoPRK0tQ7WdXWI/1OE9qfm
138RoMGwcoj/T3yQqKufdoL9qTSSqJ92Aq9iI/mw+khv6dG8aEUnI5OyC6vn
5tveA02M6JS+gCbxwEhi3gAYACkT\
\>"], "Picture",
 ImageSize->{533, 55},
 ImageMargins->0,
 CellID->150067611]
}, Open  ]],

Cell["\<\
If they are sent to the front end, however, they cause data to be written \
into the notebook. \
\>", "MathCaption",
 CellID->28411],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FrontEndExecute", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->11959],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 79},
 ImageMargins->{{1, 0}, {0, 0}},
 CellID->147234653]
}, Open  ]],

Cell["\<\
If you write sophisticated programs for manipulating notebooks, then you will \
have no choice but to execute these programs primarily in the kernel. But for \
the kinds of operations typically performed by simple buttons, you may find \
that it is possible to execute all the commands you need directly in the \
front end\[LongDash]without the kernel even needing to be running. \
\>", "Text",
 CellID->18738],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->718805985],

Cell[TextData[ButtonBox["Manipulating Notebooks",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksOverview"]], "RelatedTutorials",
 CellID->81824477]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Executing Notebook Commands Directly in the Front End - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Manipulating Notebooks", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/ManipulatingNotebooksOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ManipulatingTheFrontEndFromTheKernel"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TheStructureOfCells"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 20.7988456}", "context" -> "", 
    "keywords" -> {"front end", "FrontEnd context", "FrontEndExecute"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "When you execute a command like NotebookWrite[obj,data] the actual \
operation of inserting data into your notebook is performed in the front end. \
Normally, however, the kernel is needed in order to evaluate the original \
command, and to construct the appropriate request to send to the front end. \
But it turns out that the front end is set up to execute a limited collection \
of commands directly, without ever involving the kernel. Distinguishing \
kernel and front end versions of commands. The basic way that Mathematica \
distinguishes between commands to be executed in the kernel and to be \
executed directly in the front end is by using contexts. The kernel commands \
are in the usual System` context, but the front end commands are in the \
FrontEnd` context. ", "synonyms" -> {"2.11.5"}, "title" -> 
    "Executing Notebook Commands Directly in the Front End", "type" -> 
    "Tutorial", "uri" -> 
    "tutorial/ExecutingNotebookCommandsDirectlyInTheFrontEnd"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.11.5"->{
  Cell[1966, 61, 117, 2, 70, "Title",
   CellTags->{"S2.11.5", "5.1"},
   CellID->18842]},
 "5.1"->{
  Cell[1966, 61, 117, 2, 70, "Title",
   CellTags->{"S2.11.5", "5.1"},
   CellID->18842]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.11.5", 16229, 414},
 {"5.1", 16330, 418}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1341, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1966, 61, 117, 2, 70, "Title",
 CellTags->{"S2.11.5", "5.1"},
 CellID->18842],
Cell[2086, 65, 698, 16, 70, "Text",
 CellID->17260],
Cell[2787, 83, 1323, 38, 70, "DefinitionBox",
 CellID->22161],
Cell[4113, 123, 93, 1, 70, "Caption",
 CellID->31620],
Cell[4209, 126, 446, 12, 70, "Text",
 CellID->4343],
Cell[4658, 140, 668, 20, 70, "DefinitionBox",
 CellID->9578],
Cell[5329, 162, 89, 1, 70, "Caption",
 CellID->1187],
Cell[5421, 165, 63, 1, 70, "MathCaption",
 CellID->113],
Cell[5487, 168, 565, 12, 70, "Picture",
 CellID->346001242],
Cell[6055, 182, 99, 2, 70, "MathCaption",
 CellID->4591],
Cell[CellGroupData[{
Cell[6179, 188, 186, 6, 70, "Input",
 CellID->5934],
Cell[6368, 196, 1554, 28, 70, "Picture",
 CellID->1236734106]
}, Open  ]],
Cell[7937, 227, 90, 1, 70, "MathCaption",
 CellID->656],
Cell[CellGroupData[{
Cell[8052, 232, 210, 6, 70, "Input",
 CellID->29761],
Cell[8265, 240, 1553, 28, 70, "Picture",
 CellID->150067611]
}, Open  ]],
Cell[9833, 271, 142, 4, 70, "MathCaption",
 CellID->28411],
Cell[CellGroupData[{
Cell[10000, 279, 108, 3, 70, "Input",
 CellID->11959],
Cell[10111, 284, 2418, 42, 70, "Picture",
 CellID->147234653]
}, Open  ]],
Cell[12544, 329, 420, 7, 70, "Text",
 CellID->18738],
Cell[CellGroupData[{
Cell[12989, 340, 72, 1, 70, "RelatedTutorialsSection",
 CellID->718805985],
Cell[13064, 343, 175, 4, 70, "RelatedTutorials",
 CellID->81824477]
}, Open  ]]
}, Open  ]],
Cell[13266, 351, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

