(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28673,        862]
NotebookOptionsPosition[     24033,        727]
NotebookOutlinePosition[     26919,        800]
CellTagsIndexPosition[     26827,        794]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Structure of Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"], 
          "Files and External Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FilesAndExternalOperationsOverview"], 
          "Importing Graphics and Sounds" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ImportingGraphicsAndSounds"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"The Structure of Graphics and Sound\"\>", 
       2->"\<\"Files and External Operations\"\>", 
       3->"\<\"Importing Graphics and Sounds\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"AIFF\"" :> 
          Documentation`HelpLookup["paclet:ref/format/AIFF"], "\"AU\"" :> 
          Documentation`HelpLookup["paclet:ref/format/AU"], "\"AVI\"" :> 
          Documentation`HelpLookup["paclet:ref/format/AVI"], "\"BMP\"" :> 
          Documentation`HelpLookup["paclet:ref/format/BMP"], "\"DICOM\"" :> 
          Documentation`HelpLookup["paclet:ref/format/DICOM"], "\"DXF\"" :> 
          Documentation`HelpLookup["paclet:ref/format/DXF"], "\"EPS\"" :> 
          Documentation`HelpLookup["paclet:ref/format/EPS"], "Export" :> 
          Documentation`HelpLookup["paclet:ref/Export"], "ExportString" :> 
          Documentation`HelpLookup["paclet:ref/ExportString"], "\"GIF\"" :> 
          Documentation`HelpLookup["paclet:ref/format/GIF"], "\"JPEG\"" :> 
          Documentation`HelpLookup["paclet:ref/format/JPEG"], "\"PBM\"" :> 
          Documentation`HelpLookup["paclet:ref/format/PBM"], "\"PCX\"" :> 
          Documentation`HelpLookup["paclet:ref/format/PCX"], "\"PDF\"" :> 
          Documentation`HelpLookup["paclet:ref/format/PDF"], "\"PGM\"" :> 
          Documentation`HelpLookup["paclet:ref/format/PGM"], "\"PICT\"" :> 
          Documentation`HelpLookup["paclet:ref/format/PICT"], "\"PNG\"" :> 
          Documentation`HelpLookup["paclet:ref/format/PNG"], "\"PNM\"" :> 
          Documentation`HelpLookup["paclet:ref/format/PNM"], "\"PPM\"" :> 
          Documentation`HelpLookup["paclet:ref/format/PPM"], "\"SND\"" :> 
          Documentation`HelpLookup["paclet:ref/format/SND"], "\"STL\"" :> 
          Documentation`HelpLookup["paclet:ref/format/STL"], "\"SVG\"" :> 
          Documentation`HelpLookup["paclet:ref/format/SVG"], "\"TIFF\"" :> 
          Documentation`HelpLookup["paclet:ref/format/TIFF"], "\"WAV\"" :> 
          Documentation`HelpLookup["paclet:ref/format/WAV"], "\"WMF\"" :> 
          Documentation`HelpLookup["paclet:ref/format/WMF"], "\"XBM\"" :> 
          Documentation`HelpLookup["paclet:ref/format/XBM"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"AIFF\\\"\"\>", 
       2->"\<\"\\\"AU\\\"\"\>", 3->"\<\"\\\"AVI\\\"\"\>", 
       4->"\<\"\\\"BMP\\\"\"\>", 5->"\<\"\\\"DICOM\\\"\"\>", 
       6->"\<\"\\\"DXF\\\"\"\>", 7->"\<\"\\\"EPS\\\"\"\>", 
       8->"\<\"Export\"\>", 9->"\<\"ExportString\"\>", 
       10->"\<\"\\\"GIF\\\"\"\>", 11->"\<\"\\\"JPEG\\\"\"\>", 
       12->"\<\"\\\"PBM\\\"\"\>", 13->"\<\"\\\"PCX\\\"\"\>", 
       14->"\<\"\\\"PDF\\\"\"\>", 15->"\<\"\\\"PGM\\\"\"\>", 
       16->"\<\"\\\"PICT\\\"\"\>", 17->"\<\"\\\"PNG\\\"\"\>", 
       18->"\<\"\\\"PNM\\\"\"\>", 19->"\<\"\\\"PPM\\\"\"\>", 
       20->"\<\"\\\"SND\\\"\"\>", 21->"\<\"\\\"STL\\\"\"\>", 
       22->"\<\"\\\"SVG\\\"\"\>", 23->"\<\"\\\"TIFF\\\"\"\>", 
       24->"\<\"\\\"WAV\\\"\"\>", 25->"\<\"\\\"WMF\\\"\"\>", 
       26->"\<\"\\\"XBM\\\"\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Exporting Graphics and Sounds", "Title",
 CellTags->{"S1.11.4", "4.1"},
 CellID->1790],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to export graphics and sounds in a wide variety of formats. If \
you use the notebook front end for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", then you can typically just copy and paste graphics and sounds directly \
into other programs using the standard mechanism available on your computer \
system."
}], "Text",
 CellID->17013],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Export",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Export"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\)\>\"", ",", 
     StyleBox["graphics", "TI"], "]"}], Cell["\<\
export graphics to a file in a format deduced from the file name\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["Export",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Export"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     StyleBox["graphics", "TI"], ",", "\"\<\!\(\*
StyleBox[\"format\", \"TI\"]\)\>\"", "]"}], "\[SpanFromLeft]"},
   {"", Cell["export graphics in the specified format", "TableText"]},
   {
    RowBox[{
     ButtonBox["Export",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Export"], "[", "\"\<!\!\(\*
StyleBox[\"command\", \"TI\"]\)\>\"", ",", 
     StyleBox["graphics", "TI"], ",", "\"\<\!\(\*
StyleBox[\"format\", \"TI\"]\)\>\"", "]"}], "\[SpanFromLeft]"},
   {"", Cell["export graphics to an external command", "TableText"]},
   {
    RowBox[{
     ButtonBox["Export",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Export"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "{", 
     SubscriptBox[
      StyleBox["g", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["g", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[
    "export a sequence of graphics for an animation", "TableText"]},
   {
    RowBox[{
     ButtonBox["ExportString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ExportString"], "[", 
     StyleBox["graphics", "TI"], ",", "\"\<\!\(\*
StyleBox[\"format\", \"TI\"]\)\>\"", "]"}], Cell[
    "generate a string representation of exported graphics", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->30412],

Cell[TextData[{
 "Exporting ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics and sounds. "
}], "Caption",
 CellID->14855],

Cell[BoxData[GridBox[{
   {
    ButtonBox["\"\<EPS\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/EPS"], Cell[TextData[{
     "Encapsulated PostScript (",
     Cell[BoxData[
      RowBox[{".", "eps"}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    ButtonBox["\"\<PDF\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/PDF"], Cell[TextData[{
     "Adobe Acrobat portable document format (",
     Cell[BoxData[
      RowBox[{".", "pdf"}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    ButtonBox["\"\<SVG\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/SVG"], Cell[TextData[{
     "Scalable Vector Graphics (",
     Cell[BoxData[
      RowBox[{".", "svg"}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    ButtonBox["\"\<PICT\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/PICT"], Cell[
    "Macintosh PICT", "TableText"]},
   {
    ButtonBox["\"\<WMF\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/WMF"], Cell[TextData[{
     "Windows metafile format (",
     Cell[BoxData[
      RowBox[{".", "wmf"}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    ButtonBox["\"\<TIFF\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/TIFF"], Cell[TextData[{
     "TIFF (",
     Cell[BoxData[
      RowBox[{".", "tif"}]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{".", "tiff"}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    ButtonBox["\"\<GIF\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/GIF"], Cell[TextData[{
     "GIF and animated GIF (",
     Cell[BoxData[
      RowBox[{".", "gif"}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    ButtonBox["\"\<JPEG\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/JPEG"], Cell[TextData[{
     "JPEG (",
     Cell[BoxData[
      RowBox[{".", "jpg"}]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{".", "jpeg"}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    ButtonBox["\"\<PNG\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/PNG"], Cell[TextData[{
     "PNG format (",
     Cell[BoxData[
      RowBox[{".", "png"}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    ButtonBox["\"\<BMP\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/BMP"], Cell[TextData[{
     "Microsoft bitmap format (",
     Cell[BoxData[
      RowBox[{".", "bmp"}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    ButtonBox["\"\<PCX\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/PCX"], Cell[TextData[{
     "PCX format (",
     Cell[BoxData[
      RowBox[{".", "pcx"}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    ButtonBox["\"\<XBM\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/XBM"], Cell[TextData[{
     "X window system bitmap (",
     Cell[BoxData[
      RowBox[{".", "xbm"}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    ButtonBox["\"\<PBM\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/PBM"], Cell[TextData[{
     "portable bitmap format (",
     Cell[BoxData[
      RowBox[{".", "pbm"}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    ButtonBox["\"\<PPM\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/PPM"], Cell[TextData[{
     "portable pixmap format (",
     Cell[BoxData[
      RowBox[{".", "ppm"}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    ButtonBox["\"\<PGM\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/PGM"], Cell[TextData[{
     "portable graymap format (",
     Cell[BoxData[
      RowBox[{".", "pgm"}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    ButtonBox["\"\<PNM\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/PNM"], Cell[TextData[{
     "portable anymap format (",
     Cell[BoxData[
      RowBox[{".", "pnm"}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    ButtonBox["\"\<DICOM\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/DICOM"], Cell[TextData[{
     "DICOM medical imaging format (",
     Cell[BoxData[
      RowBox[{".", "dcm"}]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{".", "dic"}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    ButtonBox["\"\<AVI\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/AVI"], Cell[TextData[{
     "Audio Video Interleave format (",
     Cell[BoxData[
      RowBox[{".", "avi"}]], "InlineFormula"],
     ")"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, True, False, False, False, False, 
     False, False, False, False, False, False, False, False, False, {False}, 
     False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->10761],

Cell[TextData[{
 "Typical graphics formats supported by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The first group are resolution independent. "
}], "Caption",
 CellID->5469],

Cell["This generates a plot. ", "MathCaption",
 CellID->8472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "+", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", "2", "]"}], " ", "x"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->25402],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->1060467934]
}, Open  ]],

Cell["\<\
This exports the plot to a file in Encapsulated PostScript format. \
\>", "MathCaption",
 CellID->13543],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<sinplot.eps\>\"", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->7373],

Cell[BoxData["\<\"sinplot.eps\"\>"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->6266]
}, Open  ]],

Cell[TextData[{
 "When you export a graphic outside of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you usually have to specify the absolute size at which the graphic should \
be rendered. You can do this using the ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " option to ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->32503],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"], "->", 
   StyleBox["x", "TI"]}]], "InlineFormula"],
 " makes the width of the graphic be ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " printer\[CloseCurlyQuote]s points; ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"], "->", 
   RowBox[{"72", 
    StyleBox["xi", "TI"]}]}]], "InlineFormula"],
 " thus makes the width ",
 Cell[BoxData[
  StyleBox["xi", "TI"]], "InlineFormula"],
 " inches. The default is to produce an image that is four inches wide. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"]}], "}"}]}]], "InlineFormula"],
 " scales the graphic so that it fits in an ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Cross]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " region. "
}], "Text",
 CellID->32729],

Cell[BoxData[GridBox[{
   {
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
absolute image size in printer\[CloseCurlyQuote]s points\
\>", "TableText"]},
   {"\"\<ImageTopOrientation\>\"", 
    ButtonBox["Top",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Top"], Cell[
    "how the image is oriented in the file ", "TableText"]},
   {
    ButtonBox["ImageResolution",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageResolution"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "resolution in dpi for the image", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->17107],

Cell[TextData[{
 "Options for ",
 StyleBox["Export", "MR"],
 ". "
}], "Caption",
 CellID->27892],

Cell[TextData[{
 "Within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", graphics are manipulated in a way that is completely independent of the \
resolution of the computer screen or other output device on which the \
graphics will eventually be rendered. "
}], "Text",
 CellID->2451],

Cell[TextData[{
 "Many programs and devices accept graphics in resolution\[Hyphen]independent \
formats such as Encapsulated PostScript (EPS). But some require that the \
graphics be converted to rasters or bitmaps with a specific resolution. The \
",
 Cell[BoxData[
  ButtonBox["ImageResolution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageResolution"]], "InlineFormula"],
 " option for ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " allows you to determine what resolution in dots per inch (dpi) should be \
used. The lower you set this resolution, the lower the quality of the image \
you will get, but also the less memory the image will take to store. For \
screen display, typical resolutions are 72 dpi and above; for printers, 300 \
dpi and above. "
}], "Text",
 CellID->17953],

Cell[BoxData[GridBox[{
   {
    ButtonBox["\"\<DXF\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/DXF"], Cell[TextData[{
     "AutoCAD drawing interchange format (",
     Cell[BoxData[
      RowBox[{".", "dxf"}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    ButtonBox["\"\<STL\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/STL"], Cell[TextData[{
     "STL stereolithography format (",
     Cell[BoxData[
      RowBox[{".", "stl"}]], "InlineFormula"],
     ")"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->28392],

Cell[TextData[{
 "Typical 3D geometry formats supported by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->22570],

Cell[BoxData[GridBox[{
   {
    ButtonBox["\"\<WAV\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/WAV"], Cell[TextData[{
     "Microsoft wave format (",
     Cell[BoxData[
      RowBox[{".", "wav"}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    ButtonBox["\"\<AU\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/AU"], Cell[
    "\[Mu] law encoding (.au)", "TableText"]},
   {
    ButtonBox["\"\<SND\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/SND"], Cell[TextData[{
     "sound file format (",
     Cell[BoxData[
      RowBox[{".", "snd"}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    ButtonBox["\"\<AIFF\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/AIFF"], Cell[TextData[{
     "AIFF format (",
     Cell[BoxData[
      RowBox[{".", "aif"}]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{".", "aiff"}]], "InlineFormula"],
     ")"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->13519],

Cell[TextData[{
 "Typical sound formats supported by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->19472],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->362284229],

Cell[TextData[ButtonBox["The Structure of Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]], \
"RelatedTutorials",
 CellID->1229394717],

Cell[TextData[ButtonBox["Files and External Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FilesAndExternalOperationsOverview"]], "RelatedTutorials",
 CellID->16088632],

Cell[TextData[ButtonBox["Importing Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ImportingGraphicsAndSounds"]], "RelatedTutorials",
 CellID->9009]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Exporting Graphics and Sounds - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["The Structure of Graphics and Sound", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TheRepresentationOfSound"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ImportingGraphicsAndSounds"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 21.2363568}", "context" -> "", 
    "keywords" -> {
     "conversions", "exporting graphics", "graphics", "images", "output", 
      "pictures"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica allows you to export graphics and sounds in a wide variety \
of formats. If you use the notebook front end for Mathematica, then you can \
typically just copy and paste graphics and sounds directly into other \
programs using the standard mechanism available on your computer system. \
Exporting Mathematica graphics and sounds. Typical graphics formats supported \
by Mathematica. The first group are resolution independent. ", 
    "synonyms" -> {"1.11.4"}, "title" -> "Exporting Graphics and Sounds", 
    "type" -> "Tutorial", "uri" -> "tutorial/ExportingGraphicsAndSounds"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.11.4"->{
  Cell[4900, 104, 92, 2, 70, "Title",
   CellTags->{"S1.11.4", "4.1"},
   CellID->1790]},
 "4.1"->{
  Cell[4900, 104, 92, 2, 70, "Title",
   CellTags->{"S1.11.4", "4.1"},
   CellID->1790]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.11.4", 26614, 783},
 {"4.1", 26714, 787}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 4275, 77, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4900, 104, 92, 2, 70, "Title",
 CellTags->{"S1.11.4", "4.1"},
 CellID->1790],
Cell[4995, 108, 423, 11, 70, "Text",
 CellID->17013],
Cell[5421, 121, 2298, 62, 70, "DefinitionBox",
 CellID->30412],
Cell[7722, 185, 136, 6, 70, "Caption",
 CellID->14855],
Cell[7861, 193, 5067, 179, 70, "DefinitionBox",
 CellID->10761],
Cell[12931, 374, 187, 6, 70, "Caption",
 CellID->5469],
Cell[13121, 382, 61, 1, 70, "MathCaption",
 CellID->8472],
Cell[CellGroupData[{
Cell[13207, 387, 329, 11, 28, "Input",
 CellID->25402],
Cell[13539, 400, 2744, 49, 121, "Output",
 Evaluatable->False,
 CellID->1060467934]
}, Open  ]],
Cell[16298, 452, 114, 3, 70, "MathCaption",
 CellID->13543],
Cell[CellGroupData[{
Cell[16437, 459, 139, 4, 70, "Input",
 CellID->7373],
Cell[16579, 465, 172, 5, 36, "Output",
 CellID->6266]
}, Open  ]],
Cell[16766, 473, 514, 17, 70, "Text",
 CellID->32503],
Cell[17283, 492, 1197, 42, 70, "Text",
 CellID->32729],
Cell[18483, 536, 1088, 31, 70, "DefinitionBox3Col",
 CellID->17107],
Cell[19574, 569, 96, 5, 70, "Caption",
 CellID->27892],
Cell[19673, 576, 293, 8, 70, "Text",
 CellID->2451],
Cell[19969, 586, 870, 20, 70, "Text",
 CellID->17953],
Cell[20842, 608, 849, 27, 70, "DefinitionBox",
 CellID->28392],
Cell[21694, 637, 147, 6, 70, "Caption",
 CellID->22570],
Cell[21844, 645, 1322, 44, 70, "DefinitionBox",
 CellID->13519],
Cell[23169, 691, 141, 6, 70, "Caption",
 CellID->19472],
Cell[CellGroupData[{
Cell[23335, 701, 72, 1, 70, "RelatedTutorialsSection",
 CellID->362284229],
Cell[23410, 704, 201, 5, 70, "RelatedTutorials",
 CellID->1229394717],
Cell[23614, 711, 187, 4, 70, "RelatedTutorials",
 CellID->16088632],
Cell[23804, 717, 175, 4, 70, "RelatedTutorials",
 CellID->9009]
}, Open  ]]
}, Open  ]],
Cell[24006, 725, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

