(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18978,        654]
NotebookOptionsPosition[     13945,        505]
NotebookOutlinePosition[     17130,        583]
CellTagsIndexPosition[     17039,        577]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicManipulationOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Algebraic Manipulation\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ComplexExpand" :> 
          Documentation`HelpLookup["paclet:ref/ComplexExpand"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"ComplexExpand\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Expressions Involving Complex Variables", "Title",
 CellTags->{"S3.3.8", "8.1"},
 CellID->146],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " usually pays no attention to whether variables like ",
 Cell[BoxData["x"], "InlineFormula"],
 " stand for real or complex numbers. Sometimes, however, you may want to \
make transformations which are appropriate only if particular variables are \
assumed to be either real or complex. "
}], "Text",
 CellID->4229],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  ButtonBox["ComplexExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexExpand"]], "InlineFormula"],
 " expands out algebraic and trigonometric expressions, making definite \
assumptions about the variables that appear. "
}], "Text",
 CellID->10471],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ComplexExpand",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ComplexExpand"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "expand ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " assuming that all variables are real"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ComplexExpand",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ComplexExpand"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "expand ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " assuming that the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " are complex"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->10428],

Cell["Expanding complex expressions. ", "Caption",
 CellID->10559],

Cell[TextData[{
 "This expands the expression, assuming that ",
 Cell[BoxData["x"], "InlineFormula"],
 " and ",
 Cell[BoxData["y"], "InlineFormula"],
 " are both real. "
}], "MathCaption",
 CellID->22241],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{"Tan", "[", 
   RowBox[{"x", "+", 
    RowBox[{"I", " ", "y"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->29421],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", "x"}], "]"}], 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "x"}], "]"}], "+", 
    RowBox[{"Cosh", "[", 
     RowBox[{"2", " ", "y"}], "]"}]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"Sinh", "[", 
     RowBox[{"2", " ", "y"}], "]"}]}], 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "x"}], "]"}], "+", 
    RowBox[{"Cosh", "[", 
     RowBox[{"2", " ", "y"}], "]"}]}]]}]], "Output",
 ImageSize->{273, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->22688]
}, Open  ]],

Cell[TextData[{
 "In this case, ",
 Cell[BoxData["a"], "InlineFormula"],
 " is assumed to be real, but ",
 Cell[BoxData["x"], "InlineFormula"],
 " is assumed to be complex, and is broken into explicit real and imaginary \
parts. "
}], "MathCaption",
 CellID->16366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"x", "^", "2"}]}], ",", 
   RowBox[{"{", "x", "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->12033],

Cell[BoxData[
 RowBox[{"a", "-", 
  SuperscriptBox[
   RowBox[{"Im", "[", "x", "]"}], "2"], "+", 
  RowBox[{"2", " ", "\[ImaginaryI]", " ", 
   RowBox[{"Im", "[", "x", "]"}], " ", 
   RowBox[{"Re", "[", "x", "]"}]}], "+", 
  SuperscriptBox[
   RowBox[{"Re", "[", "x", "]"}], "2"]}]], "Output",
 ImageSize->{224, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->26685]
}, Open  ]],

Cell["\<\
With several complex variables, you quickly get quite complicated results. \
\>", "MathCaption",
 CellID->2270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    RowBox[{"Exp", "[", "y", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->25329],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"Re", "[", "y", "]"}]], " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"Im", "[", "y", "]"}], "]"}], " ", 
   RowBox[{"Cosh", "[", 
    RowBox[{"Im", "[", "x", "]"}], "]"}], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"Re", "[", "x", "]"}], "]"}]}], "-", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"Re", "[", "y", "]"}]], " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"Re", "[", "x", "]"}], "]"}], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"Im", "[", "y", "]"}], "]"}], " ", 
   RowBox[{"Sinh", "[", 
    RowBox[{"Im", "[", "x", "]"}], "]"}]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"Re", "[", "y", "]"}]], " ", 
      RowBox[{"Cosh", "[", 
       RowBox[{"Im", "[", "x", "]"}], "]"}], " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"Im", "[", "y", "]"}], "]"}], " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"Re", "[", "x", "]"}], "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"Re", "[", "y", "]"}]], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"Im", "[", "y", "]"}], "]"}], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"Re", "[", "x", "]"}], "]"}], " ", 
      RowBox[{"Sinh", "[", 
       RowBox[{"Im", "[", "x", "]"}], "]"}]}]}], ")"}]}]}]], "Output",
 ImageSize->{566, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->32261]
}, Open  ]],

Cell[TextData[{
 "There are several ways to write a complex variable ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " in terms of real parameters. As above, for example, ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " can be written in the \[OpenCurlyDoubleQuote]Cartesian form\
\[CloseCurlyDoubleQuote] ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Re",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Re"], "[", 
    StyleBox["z", "TI"], "]"}], "+", 
   RowBox[{
    ButtonBox["I",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/I"], " ", 
    RowBox[{
     ButtonBox["Im",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Im"], "[", 
     StyleBox["z", "TI"], "]"}]}]}]], "InlineFormula"],
 ". But it can equally well be written in the \[OpenCurlyDoubleQuote]polar \
form\[CloseCurlyDoubleQuote] ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Abs",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Abs"], "[", 
    StyleBox["z", "TI"], "]"}], " ", 
   RowBox[{
    ButtonBox["Exp",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Exp"], "[", 
    RowBox[{
     ButtonBox["I",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/I"], " ", 
     RowBox[{
      ButtonBox["Arg",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Arg"], "[", 
      StyleBox["z", "TI"], "]"}]}], "]"}]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->22860],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["TargetFunctions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TargetFunctions"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["ComplexExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexExpand"]], "InlineFormula"],
 " allows you to specify how complex variables should be written. ",
 Cell[BoxData[
  ButtonBox["TargetFunctions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TargetFunctions"]], "InlineFormula"],
 " can be set to a list of functions from the set ",
 Cell[BoxData[
  FormBox["{", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  RowBox[{
   ButtonBox["Re",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Re"], ",", 
   ButtonBox["Im",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Im"], ",", 
   ButtonBox["Abs",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abs"], ",", 
   ButtonBox["Arg",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Arg"], ",", 
   ButtonBox["Conjugate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Conjugate"], ",", 
   ButtonBox["Sign",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sign"]}]], "InlineFormula"],
 Cell[BoxData[
  FormBox["}", TraditionalForm]], "InlineMath"],
 ". ",
 Cell[BoxData[
  ButtonBox["ComplexExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexExpand"]], "InlineFormula"],
 " will try to give results in terms of whichever of these functions you \
request. The default is typically to give results in terms of ",
 Cell[BoxData[
  ButtonBox["Re",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Re"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Im",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Im"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->2208],

Cell["This gives an expansion in Cartesian form. ", "MathCaption",
 CellID->8982],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"z", "^", "2"}], "]"}], ",", 
   RowBox[{"{", "z", "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->22162],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SuperscriptBox[
    RowBox[{"Im", "[", "z", "]"}], "2"]}], "+", 
  SuperscriptBox[
   RowBox[{"Re", "[", "z", "]"}], "2"]}]], "Output",
 ImageSize->{106, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->32506]
}, Open  ]],

Cell["Here is an expansion in polar form. ", "MathCaption",
 CellID->6878],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"z", "^", "2"}], "]"}], ",", 
   RowBox[{"{", "z", "}"}], ",", 
   RowBox[{"TargetFunctions", "->", 
    RowBox[{"{", 
     RowBox[{"Abs", ",", "Arg"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->11979],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox[
    RowBox[{"Abs", "[", "z", "]"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", 
     RowBox[{"Arg", "[", "z", "]"}], "]"}], "2"]}], "-", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Abs", "[", "z", "]"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{"Arg", "[", "z", "]"}], "]"}], "2"]}]}]], "Output",
 ImageSize->{283, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->1897]
}, Open  ]],

Cell["Here is another form of expansion. ", "MathCaption",
 CellID->7887],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"z", "^", "2"}], "]"}], ",", 
   RowBox[{"{", "z", "}"}], ",", 
   RowBox[{"TargetFunctions", "->", "Conjugate"}]}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->6538],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["z", "2"], "2"], "+", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"Conjugate", "[", "z", "]"}], "2"], "2"]}]], "Output",
 ImageSize->{127, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->14469]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->535122885],

Cell[TextData[ButtonBox["Algebraic Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AlgebraicManipulationOverview"]], "RelatedTutorials",
 CellID->91103315]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Expressions Involving Complex Variables - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Algebraic Manipulation", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/AlgebraicManipulationOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TrigonometricExpressions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/LogicalAndPiecewiseFunctions"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 22.4707634}", "context" -> "", 
    "keywords" -> {
     "abs", "Arg", "assume real variables", "assumptions", "Cartesian form", 
      "ComplexExpand", "complex variables", "conjugate", "de Moivres Theorem",
       "expansion", "Im", "imaginary part", "imaginary quantities", 
      "polar form", "re", "real part", "rectangular form", "sign", 
      "symbolic complex expressions", "symbolic frequency analysis", 
      "TargetFunctions"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica usually pays no attention to whether variables like x stand \
for real or complex numbers. Sometimes, however, you may want to make \
transformations which are appropriate only if particular variables are \
assumed to be either real or complex. The function ComplexExpand expands out \
algebraic and trigonometric expressions, making definite assumptions about \
the variables that appear. Expanding complex expressions. ", 
    "synonyms" -> {"3.3.8"}, "title" -> 
    "Expressions Involving Complex Variables", "type" -> "Tutorial", "uri" -> 
    "tutorial/ExpressionsInvolvingComplexVariables"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.3.8"->{
  Cell[1837, 59, 100, 2, 70, "Title",
   CellTags->{"S3.3.8", "8.1"},
   CellID->146]},
 "8.1"->{
  Cell[1837, 59, 100, 2, 70, "Title",
   CellTags->{"S3.3.8", "8.1"},
   CellID->146]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.3.8", 16830, 566},
 {"8.1", 16928, 570}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1212, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1837, 59, 100, 2, 70, "Title",
 CellTags->{"S3.3.8", "8.1"},
 CellID->146],
Cell[1940, 63, 381, 9, 70, "Text",
 CellID->4229],
Cell[2324, 74, 311, 9, 70, "Text",
 CellID->10471],
Cell[2638, 85, 1463, 45, 70, "DefinitionBox",
 CellID->10428],
Cell[4104, 132, 66, 1, 70, "Caption",
 CellID->10559],
Cell[4173, 135, 204, 7, 70, "MathCaption",
 CellID->22241],
Cell[CellGroupData[{
Cell[4402, 146, 185, 6, 28, "Input",
 CellID->29421],
Cell[4590, 154, 653, 23, 53, "Output",
 CellID->22688]
}, Open  ]],
Cell[5258, 180, 265, 8, 70, "MathCaption",
 CellID->16366],
Cell[CellGroupData[{
Cell[5548, 192, 202, 7, 28, "Input",
 CellID->12033],
Cell[5753, 201, 421, 13, 36, "Output",
 CellID->26685]
}, Open  ]],
Cell[6189, 217, 121, 3, 70, "MathCaption",
 CellID->2270],
Cell[CellGroupData[{
Cell[6335, 224, 266, 9, 70, "Input",
 CellID->25329],
Cell[6604, 235, 1526, 45, 56, "Output",
 CellID->32261]
}, Open  ]],
Cell[8145, 283, 1423, 49, 70, "Text",
 CellID->22860],
Cell[9571, 334, 1773, 59, 70, "Text",
 CellID->2208],
Cell[11347, 395, 81, 1, 70, "MathCaption",
 CellID->8982],
Cell[CellGroupData[{
Cell[11453, 400, 208, 7, 70, "Input",
 CellID->22162],
Cell[11664, 409, 306, 11, 36, "Output",
 CellID->32506]
}, Open  ]],
Cell[11985, 423, 74, 1, 70, "MathCaption",
 CellID->6878],
Cell[CellGroupData[{
Cell[12084, 428, 312, 10, 70, "Input",
 CellID->11979],
Cell[12399, 440, 517, 18, 36, "Output",
 CellID->1897]
}, Open  ]],
Cell[12931, 461, 73, 1, 70, "MathCaption",
 CellID->7887],
Cell[CellGroupData[{
Cell[13029, 466, 264, 8, 70, "Input",
 CellID->6538],
Cell[13296, 476, 308, 11, 54, "Output",
 CellID->14469]
}, Open  ]],
Cell[CellGroupData[{
Cell[13641, 492, 72, 1, 70, "RelatedTutorialsSection",
 CellID->535122885],
Cell[13716, 495, 175, 4, 70, "RelatedTutorials",
 CellID->91103315]
}, Open  ]]
}, Open  ]],
Cell[13918, 503, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

