(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20469,        716]
NotebookOptionsPosition[     15151,        551]
NotebookOutlinePosition[     18154,        627]
CellTagsIndexPosition[     18063,        621]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functional Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FunctionalOperationsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Functional Operations\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Compile" :> Documentation`HelpLookup["paclet:ref/Compile"], 
          "CompiledFunction" :> 
          Documentation`HelpLookup["paclet:ref/CompiledFunction"], "Function" :> 
          Documentation`HelpLookup["paclet:ref/Function"], 
          "InterpolatingFunction" :> 
          Documentation`HelpLookup["paclet:ref/InterpolatingFunction"], 
          "Interpolation" :> 
          Documentation`HelpLookup["paclet:ref/Interpolation"], "LinearSolve" :> 
          Documentation`HelpLookup["paclet:ref/LinearSolve"], 
          "LinearSolveFunction" :> 
          Documentation`HelpLookup["paclet:ref/LinearSolveFunction"], 
          "NDSolve" :> Documentation`HelpLookup["paclet:ref/NDSolve"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Compile\"\>", 
       2->"\<\"CompiledFunction\"\>", 3->"\<\"Function\"\>", 
       4->"\<\"InterpolatingFunction\"\>", 5->"\<\"Interpolation\"\>", 
       6->"\<\"LinearSolve\"\>", 7->"\<\"LinearSolveFunction\"\>", 
       8->"\<\"NDSolve\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Expressions with Heads That Are Not Symbols", "Title",
 CellTags->{"S2.2.8", "8.1"},
 CellID->2317],

Cell[TextData[{
 "In most cases, you want the head ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " of a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression like ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " to be a single symbol. There are, however, some important applications of \
heads that are not symbols. "
}], "Text",
 CellID->26134],

Cell[TextData[{
 "This expression has ",
 Cell[BoxData[
  RowBox[{"f", "[", "3", "]"}]], "InlineFormula"],
 " as a head. You can use heads like this to represent \
\[OpenCurlyDoubleQuote]indexed functions\[CloseCurlyDoubleQuote]. "
}], "MathCaption",
 CellID->32053],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "3", "]"}], "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->18135],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "3", "]"}], "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->12258]
}, Open  ]],

Cell["\<\
You can use any expression as a head. Remember to put in the necessary \
parentheses. \
\>", "MathCaption",
 CellID->2593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "+", "b"}], ")"}], "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->17843],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "+", "b"}], ")"}], "[", "x", "]"}]], "Output",
 ImageSize->{66, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->21693]
}, Open  ]],

Cell[TextData[{
 "One case where we have already encountered the use of complicated \
expressions as heads is in working with pure functions in \"",
 ButtonBox["Pure Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PureFunctions"],
 "\". By giving ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Function",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Function"], "[", 
   RowBox[{
    StyleBox["vars", "TI"], ",", 
    StyleBox["body", "TI"]}], "]"}]], "InlineFormula"],
 " as the head of an expression, you specify a function of the arguments to \
be evaluated. "
}], "Text",
 CellID->16466],

Cell[TextData[{
 "With the head ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Function",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Function"], "[", 
   RowBox[{"x", ",", 
    RowBox[{"x", "^", "2"}]}], "]"}]], "InlineFormula"],
 ", the value of the expression is the square of the argument. "
}], "MathCaption",
 CellID->22951],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "[", 
   RowBox[{"x", ",", 
    RowBox[{"x", "^", "2"}]}], "]"}], "[", 
  RowBox[{"a", "+", "b"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->18140],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"a", "+", "b"}], ")"}], "2"]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->11094]
}, Open  ]],

Cell[TextData[{
 "There are several constructs in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " which work much like pure functions, but which represent specific kinds of \
functions, typically numerical ones. In all cases, the basic mechanism \
involves giving a head which contains complete information about the function \
you want to use. "
}], "Text",
 CellID->12937],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Function",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Function"], "[", 
     StyleBox["vars", "TI"], ",", 
     StyleBox["body", "TI"], "]", "[", 
     StyleBox["args", "TI"], "]"}], Cell["pure function", "TableText"]},
   {
    RowBox[{
     ButtonBox["InterpolatingFunction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InterpolatingFunction"], "[", 
     StyleBox["data", "TI"], "]", "[", 
     StyleBox["args", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "approximate numerical function (generated by ",
     Cell[BoxData[
      ButtonBox["Interpolation",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Interpolation"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["NDSolve",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CompiledFunction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CompiledFunction"], "[", 
     StyleBox["data", "TI"], "]", "[", 
     StyleBox["args", "TI"], "]"}], Cell[TextData[{
     "compiled numerical function (generated by ",
     Cell[BoxData[
      ButtonBox["Compile",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Compile"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LinearSolveFunction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LinearSolveFunction"], "[", 
     StyleBox["data", "TI"], "]", "[", 
     StyleBox["vec", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "matrix solution function (generated by ",
     Cell[BoxData[
      ButtonBox["LinearSolve",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
     ")"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->5174],

Cell["Some expressions which have heads that are not symbols. ", "Caption",
 CellID->2512],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " returns a list of rules that give ",
 Cell[BoxData["y"], "InlineFormula"],
 " as an ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " object. "
}], "MathCaption",
 CellID->6097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}], "==", 
      RowBox[{"y", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "0", "]"}], "==", "1"}]}], "}"}], ",", "y", 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->9551],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "5.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{309, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->2695]
}, Open  ]],

Cell[TextData[{
 "Here is the ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " object. "
}], "MathCaption",
 CellID->21817],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"y", "/.", 
  RowBox[{"First", "[", "%", "]"}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->23492],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "5.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{258, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->21292]
}, Open  ]],

Cell[TextData[{
 "You can use the ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " object as a head to get numerical approximations to values of the function \
",
 Cell[BoxData["y"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->20237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "[", "3.8", "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->27530],

Cell[BoxData["44.70118814328359`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->613]
}, Open  ]],

Cell[TextData[{
 "Another important use of more complicated expressions as heads is in \
implementing ",
 StyleBox["functionals",
  FontSlant->"Italic"],
 " and ",
 StyleBox["functional operators",
  FontSlant->"Italic"],
 " in mathematics. "
}], "Text",
 CellID->25296],

Cell[TextData[{
 "As one example, consider the operation of differentiation. As will be \
discussed in \"",
 ButtonBox["The Representation of Derivatives\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheRepresentationOfDerivatives"],
 ", an expression like ",
 Cell[BoxData[
  RowBox[{"f", "'"}]], "InlineFormula"],
 " represents a ",
 StyleBox["derivative function",
  FontSlant->"Italic"],
 ", obtained from ",
 Cell[BoxData["f"], "InlineFormula"],
 " by applying a functional operator to it. In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", ",
 Cell[BoxData[
  RowBox[{"f", "'"}]], "InlineFormula"],
 " is represented as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Derivative",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Derivative"], "[", "1", "]"}], "[", "f", "]"}]], 
  "InlineFormula"],
 ": the \[OpenCurlyDoubleQuote]functional operator\[CloseCurlyDoubleQuote] ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Derivative",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Derivative"], "[", "1", "]"}]], "InlineFormula"],
 " is applied to ",
 Cell[BoxData["f"], "InlineFormula"],
 " to give another function, represented as ",
 Cell[BoxData[
  RowBox[{"f", "'"}]], "InlineFormula"],
 "."
}], "Text",
 CellID->21710],

Cell[TextData[{
 "This expression has a head which represents the application of the \
\[OpenCurlyDoubleQuote]functional operator\[CloseCurlyDoubleQuote] ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Derivative",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Derivative"], "[", "1", "]"}]], "InlineFormula"],
 " to the \[OpenCurlyDoubleQuote]function\[CloseCurlyDoubleQuote] ",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->32389],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "'"}], "[", "x", "]"}], "//", "FullForm"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->5628],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{
    RowBox[{
     RowBox[{"Derivative", "[", "1", "]"}], "[", "f", "]"}], "[", "x", "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]//FullForm= ",
 CellID->5809]
}, Open  ]],

Cell[TextData[{
 "You can replace the head ",
 Cell[BoxData[
  RowBox[{"f", "'"}]], "InlineFormula"],
 " with another head, such as ",
 Cell[BoxData["fp"], "InlineFormula"],
 ". This effectively takes ",
 Cell[BoxData["fp"], "InlineFormula"],
 " to be a \[OpenCurlyDoubleQuote]derivative function\[CloseCurlyDoubleQuote] \
obtained from ",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->28786],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{
   RowBox[{"f", "'"}], "->", "fp"}]}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->31744],

Cell[BoxData[
 RowBox[{"fp", "[", "x", "]"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->18840]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->353532957],

Cell[TextData[ButtonBox["Functional Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FunctionalOperationsOverview"]], "RelatedTutorials",
 CellID->222363673]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Expressions with Heads That Are Not Symbols - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Functional Operations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/FunctionalOperationsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/SelectingPartsOfExpressionsWithFunctions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/WorkingWithOperators"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 28.3302884}", "context" -> "", 
    "keywords" -> {
     "CompiledFunction", "compiled function", "derivative", "function", 
      "functionals", "functions", "heads", "indexed functions", 
      "InterpolatingFunction", "interpolating function", 
      "LinearSolveFunction", "operators", "pure functions"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "In most cases, you want the head f of a Mathematica expression like f[x] \
to be a single symbol. There are, however, some important applications of \
heads that are not symbols. This expression has f[3] as a head. You can use \
heads like this to represent 'indexed functions'. You can use any expression \
as a head. Remember to put in the necessary parentheses. ", 
    "synonyms" -> {"2.2.8"}, "title" -> 
    "Expressions with Heads That Are Not Symbols", "type" -> "Tutorial", 
    "uri" -> "tutorial/ExpressionsWithHeadsThatAreNotSymbols"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.2.8"->{
  Cell[2670, 72, 105, 2, 70, "Title",
   CellTags->{"S2.2.8", "8.1"},
   CellID->2317]},
 "8.1"->{
  Cell[2670, 72, 105, 2, 70, "Title",
   CellTags->{"S2.2.8", "8.1"},
   CellID->2317]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.2.8", 17852, 610},
 {"8.1", 17951, 614}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2045, 45, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2670, 72, 105, 2, 70, "Title",
 CellTags->{"S2.2.8", "8.1"},
 CellID->2317],
Cell[2778, 76, 435, 15, 70, "Text",
 CellID->26134],
Cell[3216, 93, 266, 7, 70, "MathCaption",
 CellID->32053],
Cell[CellGroupData[{
Cell[3507, 104, 145, 5, 28, "Input",
 CellID->18135],
Cell[3655, 111, 233, 8, 36, "Output",
 CellID->12258]
}, Open  ]],
Cell[3903, 122, 132, 4, 70, "MathCaption",
 CellID->2593],
Cell[CellGroupData[{
Cell[4060, 130, 141, 5, 28, "Input",
 CellID->17843],
Cell[4204, 137, 229, 8, 36, "Output",
 CellID->21693]
}, Open  ]],
Cell[4448, 148, 609, 18, 70, "Text",
 CellID->16466],
Cell[5060, 168, 333, 11, 70, "MathCaption",
 CellID->22951],
Cell[CellGroupData[{
Cell[5418, 183, 201, 7, 28, "Input",
 CellID->18140],
Cell[5622, 192, 225, 8, 36, "Output",
 CellID->11094]
}, Open  ]],
Cell[5862, 203, 381, 9, 70, "Text",
 CellID->12937],
Cell[6246, 214, 2338, 70, 70, "DefinitionBox",
 CellID->5174],
Cell[8587, 286, 90, 1, 70, "Caption",
 CellID->2512],
Cell[8680, 289, 414, 14, 70, "MathCaption",
 CellID->6097],
Cell[CellGroupData[{
Cell[9119, 307, 484, 17, 70, "Input",
 CellID->9551],
Cell[9606, 326, 462, 17, 36, "Output",
 CellID->2695]
}, Open  ]],
Cell[10083, 346, 225, 8, 70, "MathCaption",
 CellID->21817],
Cell[CellGroupData[{
Cell[10333, 358, 122, 4, 70, "Input",
 CellID->23492],
Cell[10458, 364, 357, 13, 36, "Output",
 CellID->21292]
}, Open  ]],
Cell[10830, 380, 343, 11, 70, "MathCaption",
 CellID->20237],
Cell[CellGroupData[{
Cell[11198, 395, 96, 3, 70, "Input",
 CellID->27530],
Cell[11297, 400, 170, 5, 36, "Output",
 CellID->613]
}, Open  ]],
Cell[11482, 408, 270, 10, 70, "Text",
 CellID->25296],
Cell[11755, 420, 1261, 41, 70, "Text",
 CellID->21710],
Cell[13019, 463, 458, 12, 70, "MathCaption",
 CellID->32389],
Cell[CellGroupData[{
Cell[13502, 479, 143, 5, 70, "Input",
 CellID->5628],
Cell[13648, 486, 385, 14, 50, "Output",
 CellID->5809]
}, Open  ]],
Cell[14048, 503, 418, 13, 70, "MathCaption",
 CellID->28786],
Cell[CellGroupData[{
Cell[14491, 520, 134, 5, 70, "Input",
 CellID->31744],
Cell[14628, 527, 183, 6, 36, "Output",
 CellID->18840]
}, Open  ]],
Cell[CellGroupData[{
Cell[14848, 538, 72, 1, 70, "RelatedTutorialsSection",
 CellID->353532957],
Cell[14923, 541, 174, 4, 70, "RelatedTutorials",
 CellID->222363673]
}, Open  ]]
}, Open  ]],
Cell[15124, 549, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

