(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24372,        806]
NotebookOptionsPosition[     18142,        621]
NotebookOutlinePosition[     21511,        701]
CellTagsIndexPosition[     21419,        695]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Files and Streams" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FilesAndStreamsOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Files and Streams\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"OpenWrite" :> Documentation`HelpLookup["paclet:ref/OpenWrite"],
           "Run" :> Documentation`HelpLookup["paclet:ref/Run"], "RunThrough" :> 
          Documentation`HelpLookup["paclet:ref/RunThrough"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"OpenWrite\"\>", 2->"\<\"Run\"\>", 
       3->"\<\"RunThrough\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["External Programs", "Title",
 CellTags->{"S2.12.2", "2.1"},
 CellID->8182],

Cell[TextData[{
 "On most computer systems, you can execute external programs or commands \
from within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Often you will want to take expressions you have generated in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and send them to an external program, or take results from external \
programs, and read them into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->28569],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports two basic forms of communication with external programs: ",
 StyleBox["structured",
  FontSlant->"Italic"],
 " and ",
 StyleBox["unstructured",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->6120],

Cell[BoxData[GridBox[{
   {Cell["Structured communication", "TableText"], Cell[TextData[{
     "use ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " to exchange expressions with ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     "\[Hyphen]compatible external programs"
    }], "TableText"]},
   {Cell["Unstructured communication", "TableText"], Cell["\<\
use file reading and writing operations to exchange ordinary text\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->27393],

Cell[TextData[{
 "Two kinds of communication with external programs in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->6292],

Cell[TextData[{
 "The idea of structured communication is to exchange complete ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions to external programs which are specially set up to handle such \
objects. The basis for structured communication is the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " system, discussed in ",
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
 ". "
}], "Text",
 CellID->14962],

Cell["\<\
Unstructured communication consists in sending and receiving ordinary text \
from external programs. The basic idea is to treat an external program very \
much like a file, and to support the same kinds of reading and writing \
operations. \
\>", "Text",
 CellID->14214],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["expr", "TI"], ">>", "\"\<!\!\(\*
StyleBox[\"command\", \"TI\"]\)\>\""}], Cell[
    "send the text of an expression to an external program", "TableText"]},
   {
    RowBox[{"<<", "\"\<!\!\(\*
StyleBox[\"command\", \"TI\"]\)\>\""}], Cell[TextData[{
     "read in text from an external program as ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " input"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->12527],

Cell["Reading and writing to external programs. ", "Caption",
 CellID->26807],

Cell[TextData[{
 "In general, wherever you might use an ordinary file name, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you instead to give a ",
 StyleBox["pipe",
  FontSlant->"Italic"],
 ", written as an external command, prefaced by an exclamation point. When \
you use the pipe, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will execute the external command, and send or receive text from it. "
}], "Text",
 CellID->13194],

Cell[TextData[{
 "This sends the result from ",
 Cell[BoxData[
  ButtonBox["FactorInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorInteger"]], "InlineFormula"],
 " to the external program ",
 Cell[BoxData["lpr"], "InlineFormula"],
 ". On many Unix systems, this program generates a printout. "
}], "MathCaption",
 CellID->8705],

Cell[BoxData[
 RowBox[{
  RowBox[{"FactorInteger", "[", 
   RowBox[{
    RowBox[{"2", "^", "31"}], "-", "1"}], "]"}], ">>", "!lpr"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->14713],

Cell[TextData[{
 "This executes the external command ",
 Cell[BoxData[
  RowBox[{"echo", "$TERM"}]], "InlineFormula"],
 ", then reads the result as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input. "
}], "MathCaption",
 CellID->7011],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "\"\<!echo $TERM\>\""}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->18913],

Cell[BoxData["xterm"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->726215132]
}, Open  ]],

Cell[TextData[{
 "One point to notice is that you can get away with dropping the double \
quotes around the name of a pipe on the right\[Hyphen]hand side of ",
 Cell[BoxData["<<"], "InlineFormula"],
 " or ",
 Cell[BoxData[">>"], "InlineFormula"],
 " if the name does not contain any spaces or other special characters. "
}], "Text",
 CellID->19664],

Cell[TextData[{
 "Pipes in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provide a very general mechanism for unstructured communication with \
external programs. On many computer systems, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " pipes are implemented using pipe mechanisms in the underlying operating \
system; in some cases, however, other interprocess communication mechanisms \
are used. One restriction of unstructured communication in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is that a given pipe can only be used for input or for output, and not for \
both at the same time. In order to do genuine two\[Hyphen]way communication, \
you need to use ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->26203],

Cell["\<\
Even with unstructured communication, you can nevertheless set up somewhat \
more complicated arrangements by using \"temporary files\". The basic idea is \
to write data to a file, then to read it as needed. \
\>", "Text",
 CellID->28995],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["OpenWrite",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OpenWrite"], "[", "]"}], Cell["\<\
open a new file with a unique name in the default area for temporary files on \
your computer system\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->17762],

Cell["Opening a \"temporary file\". ", "Caption",
 CellID->14381],

Cell[TextData[{
 "Particularly when you work with temporary files, you may find it useful to \
be able to execute external commands which do not explicitly send or receive \
data from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". You can do this using the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["Run",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Run"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->26946],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Run",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Run"], "[", "\"\<\!\(\*
StyleBox[\"command\", \"TI\"]\)\>\"", ",", 
     SubscriptBox[
      StyleBox["arg", "TI"], 
      StyleBox["1", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "run an external command from within ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->29909],

Cell["Running external commands without input or output. ", "Caption",
 CellID->1048],

Cell[TextData[{
 "This executes the external Unix command ",
 Cell[BoxData["date"], "InlineFormula"],
 ". The returned value is an \"exit code\" from the operating system. "
}], "MathCaption",
 CellID->21768],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Run", "[", "\"\<date\>\"", "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->26624],

Cell[BoxData["\<\"Thu Mar 31 19:20:32 CST 2005\"\>"], "Print",
 CellID->22511],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->7954]
}, Open  ]],

Cell[TextData[{
 "Note that when you use ",
 Cell[BoxData[
  ButtonBox["Run",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Run"]], "InlineFormula"],
 ", you must not preface commands with exclamation points. ",
 Cell[BoxData[
  ButtonBox["Run",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Run"]], "InlineFormula"],
 " simply takes the textual forms of the arguments you specify, then joins \
them together with spaces in between, and executes the resulting string as an \
external shell command. "
}], "Text",
 CellID->51380329],

Cell[TextData[{
 "It is important to realize that ",
 Cell[BoxData[
  ButtonBox["Run",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Run"]], "InlineFormula"],
 " never \"captures\" any of the output from an external command. As a \
result, where this output goes is purely determined by your operating system. \
Similarly, ",
 Cell[BoxData[
  ButtonBox["Run",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Run"]], "InlineFormula"],
 " does not supply input to external commands. This means that the commands \
can get input through any mechanism provided by your operating system. \
Sometimes external commands may be able to access the same input and output \
streams that are used by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " itself. In some cases, this may be what you want. But particularly if you \
are using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with a front end, this can cause considerable trouble. "
}], "Text",
 CellID->1127],

Cell[BoxData[GridBox[{
   {
    RowBox[{"!", 
     StyleBox["command", "TI"]}], Cell[TextData[{
     "intercept a line of ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " input, and run it as an external command"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->14633],

Cell[TextData[{
 "Using shell escapes with a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " text-based interface. "
}], "Caption",
 CellID->28240],

Cell[TextData[{
 "If you use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with a text\[Hyphen]based interface, there is usually a special mechanism \
for executing external commands. With such an interface, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " takes any line of input that starts with an exclamation point, and \
executes the text on the remainder of the line as an external command. "
}], "Text",
 CellID->1862],

Cell[TextData[{
 "The way ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses ",
 Cell[BoxData[
  RowBox[{"!", 
   StyleBox["command", "TI"]}]], "InlineFormula"],
 " is typical of the way \"shell escapes\" work in programs running under the \
Unix operating system. In most versions of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you will be able to start an interactive shell from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " simply by typing a single exclamation point on its own on a line. "
}], "Text",
 CellID->15127],

Cell[TextData[{
 "With a text-based interface, this line is taken as a \"shell escape\", and \
executes the Unix command ",
 Cell[BoxData["date"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->27577],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"!", "date"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->23817],

Cell[BoxData["\<\"Thu Mar 31 19:20:32 CST 2005\"\>"], "Print",
 CellID->2340],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->10142]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["RunThrough",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RunThrough"], "[", "\"\<\!\(\*
StyleBox[\"command\", \"TI\"]\)\>\"", ",", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "run ",
     Cell[BoxData[
      StyleBox["command", "TI"]], "InlineFormula"],
     ", using ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " as input, and reading the output back into ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->15100],

Cell[TextData[{
 "Running ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions through external programs. "
}], "Caption",
 CellID->28400],

Cell[TextData[{
 "As discussed above, ",
 Cell[BoxData["<<"], "InlineFormula"],
 " and ",
 Cell[BoxData[">>"], "InlineFormula"],
 " cannot be used to both send and receive data from an external program at \
the same time. Nevertheless, by using temporary files, you can effectively \
both send and receive data from an external program while still using \
unstructured communication. "
}], "Text",
 CellID->6558],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  ButtonBox["RunThrough",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RunThrough"]], "InlineFormula"],
 " writes the text of an expression to a temporary file, then feeds this file \
as input to an external program, and captures the output as input to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Note that in ",
 Cell[BoxData[
  ButtonBox["RunThrough",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RunThrough"]], "InlineFormula"],
 ", like ",
 Cell[BoxData[
  ButtonBox["Run",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Run"]], "InlineFormula"],
 ", you should not preface the names of external commands with exclamation \
points. "
}], "Text",
 CellID->21476],

Cell[TextData[{
 "This feeds the expression ",
 Cell[BoxData["789"], "InlineFormula"],
 " to the external program ",
 Cell[BoxData["cat"], "InlineFormula"],
 ", which in this case simply echoes the text of the expression. The output \
from ",
 Cell[BoxData["cat"], "InlineFormula"],
 " is then read back into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "MathCaption",
 CellID->3154],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RunThrough", "[", 
  RowBox[{"\"\<cat\>\"", ",", "789"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->10935],

Cell[BoxData["789"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->16430]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->56737298],

Cell[TextData[ButtonBox["Files and Streams",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FilesAndStreamsOverview"]], "RelatedTutorials",
 CellID->107813958]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"External Programs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Files and Streams", "OverviewNavText"], BaseStyle -> "Link",
         ButtonData -> "paclet:tutorial/FilesAndStreamsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ReadingAndWritingMathematicaFiles"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/StreamsAndLowLevelInputAndOutput"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 28.8303012}", "context" -> "", 
    "keywords" -> {
     "cat Unix command", "commands", "communication", "date Unix command", 
      "echo Unix command", "exclamation point", "execute external command", 
      "execute shell command", "exit code", "expressions", 
      "external programs", "filter", "fork", "interprocess communication", 
      "IPC", "monitor escapes", "OpenTemporary", "OpenWrite", 
      "operating system command", "| (pipe prefix)", "pipes", "run", 
      "scratch files", "shell command", "shell escapes", "subprocess", 
      "temporary files", "TERM Unix environment variable", 
      "text-based interface", "tmp files", "Unix"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "On most computer systems, you can execute external programs or commands \
from within Mathematica. Often you will want to take expressions you have \
generated in Mathematica, and send them to an external program, or take \
results from external programs, and read them into Mathematica. Mathematica \
supports two basic forms of communication with external programs: structured \
and unstructured. Two kinds of communication with external programs in \
Mathematica. ", "synonyms" -> {"2.12.2"}, "title" -> "External Programs", 
    "type" -> "Tutorial", "uri" -> "tutorial/ExternalPrograms"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.12.2"->{
  Cell[1983, 60, 80, 2, 70, "Title",
   CellTags->{"S2.12.2", "2.1"},
   CellID->8182]},
 "2.1"->{
  Cell[1983, 60, 80, 2, 70, "Title",
   CellTags->{"S2.12.2", "2.1"},
   CellID->8182]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.12.2", 21208, 684},
 {"2.1", 21307, 688}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1358, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1983, 60, 80, 2, 70, "Title",
 CellTags->{"S2.12.2", "2.1"},
 CellID->8182],
Cell[2066, 64, 462, 14, 70, "Text",
 CellID->28569],
Cell[2531, 80, 277, 11, 70, "Text",
 CellID->6120],
Cell[2811, 93, 780, 21, 70, "DefinitionBox",
 CellID->27393],
Cell[3594, 116, 158, 6, 70, "Caption",
 CellID->6292],
Cell[3755, 124, 695, 20, 70, "Text",
 CellID->14962],
Cell[4453, 146, 280, 6, 70, "Text",
 CellID->14214],
Cell[4736, 154, 759, 22, 70, "DefinitionBox",
 CellID->12527],
Cell[5498, 178, 77, 1, 70, "Caption",
 CellID->26807],
Cell[5578, 181, 453, 13, 70, "Text",
 CellID->13194],
Cell[6034, 196, 343, 10, 70, "MathCaption",
 CellID->8705],
Cell[6380, 208, 183, 6, 70, "Input",
 CellID->14713],
Cell[6566, 216, 245, 9, 70, "MathCaption",
 CellID->7011],
Cell[CellGroupData[{
Cell[6836, 229, 103, 3, 70, "Input",
 CellID->18913],
Cell[6942, 234, 162, 5, 36, "Output",
 CellID->726215132]
}, Open  ]],
Cell[7119, 242, 348, 8, 70, "Text",
 CellID->19664],
Cell[7470, 252, 773, 20, 70, "Text",
 CellID->26203],
Cell[8246, 274, 249, 5, 70, "Text",
 CellID->28995],
Cell[8498, 281, 598, 17, 70, "DefinitionBox",
 CellID->17762],
Cell[9099, 300, 65, 1, 70, "Caption",
 CellID->14381],
Cell[9167, 303, 475, 16, 70, "Text",
 CellID->26946],
Cell[9645, 321, 769, 23, 70, "DefinitionBox",
 CellID->29909],
Cell[10417, 346, 85, 1, 70, "Caption",
 CellID->1048],
Cell[10505, 349, 208, 5, 70, "MathCaption",
 CellID->21768],
Cell[CellGroupData[{
Cell[10738, 358, 107, 3, 70, "Input",
 CellID->26624],
Cell[10848, 363, 78, 1, 70, "Print",
 CellID->22511],
Cell[10929, 366, 154, 5, 36, "Output",
 CellID->7954]
}, Open  ]],
Cell[11098, 374, 537, 15, 70, "Text",
 CellID->51380329],
Cell[11638, 391, 971, 25, 70, "Text",
 CellID->1127],
Cell[12612, 418, 571, 17, 70, "DefinitionBox",
 CellID->14633],
Cell[13186, 437, 154, 6, 70, "Caption",
 CellID->28240],
Cell[13343, 445, 440, 11, 70, "Text",
 CellID->1862],
Cell[13786, 458, 552, 17, 70, "Text",
 CellID->15127],
Cell[14341, 477, 205, 6, 70, "MathCaption",
 CellID->27577],
Cell[CellGroupData[{
Cell[14571, 487, 87, 3, 70, "Input",
 CellID->23817],
Cell[14661, 492, 77, 1, 70, "Print",
 CellID->2340],
Cell[14741, 495, 155, 5, 36, "Output",
 CellID->10142]
}, Open  ]],
Cell[14911, 503, 870, 26, 70, "DefinitionBox",
 CellID->15100],
Cell[15784, 531, 152, 6, 70, "Caption",
 CellID->28400],
Cell[15939, 539, 412, 10, 70, "Text",
 CellID->6558],
Cell[16354, 551, 736, 23, 70, "Text",
 CellID->21476],
Cell[17093, 576, 399, 13, 70, "MathCaption",
 CellID->3154],
Cell[CellGroupData[{
Cell[17517, 593, 138, 4, 70, "Input",
 CellID->10935],
Cell[17658, 599, 157, 5, 36, "Output",
 CellID->16430]
}, Open  ]],
Cell[CellGroupData[{
Cell[17852, 609, 71, 1, 70, "RelatedTutorialsSection",
 CellID->56737298],
Cell[17926, 612, 162, 3, 70, "RelatedTutorials",
 CellID->107813958]
}, Open  ]]
}, Open  ]],
Cell[18115, 619, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

