(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17363,        567]
NotebookOptionsPosition[     12398,        422]
NotebookOutlinePosition[     15533,        498]
CellTagsIndexPosition[     15441,        492]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Files and External Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FilesAndExternalOperationsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Files and External Operations\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CopyFile" :> Documentation`HelpLookup["paclet:ref/CopyFile"], 
          "DeleteFile" :> Documentation`HelpLookup["paclet:ref/DeleteFile"], 
          "Directory" :> Documentation`HelpLookup["paclet:ref/Directory"], 
          "FileNames" :> Documentation`HelpLookup["paclet:ref/FileNames"], 
          "FindList" :> Documentation`HelpLookup["paclet:ref/FindList"], 
          "SetDirectory" :> 
          Documentation`HelpLookup["paclet:ref/SetDirectory"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CopyFile\"\>", 
       2->"\<\"DeleteFile\"\>", 3->"\<\"Directory\"\>", 
       4->"\<\"FileNames\"\>", 5->"\<\"FindList\"\>", 
       6->"\<\"SetDirectory\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Finding and Manipulating Files", "Title",
 CellTags->{"S1.11.2", "2.1"},
 CellID->14631],

Cell[TextData[{
 "Although the details of how files are named and organized differ from one \
computer system to another, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides some fairly general mechanisms for finding and handling files. "
}], "Text",
 CellID->13640],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " assumes that files on your computer system are organized in a collection \
of ",
 StyleBox["directories",
  FontSlant->"Italic"],
 ". At any point, you have a ",
 StyleBox["current working directory",
  FontSlant->"Italic"],
 ". You can always refer to files in this directory just by giving their \
names. "
}], "Text",
 CellID->8934],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Directory",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Directory"], "[", "]"}], Cell[
    "give your current working directory", "TableText"]},
   {
    RowBox[{
     ButtonBox["SetDirectory",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SetDirectory"], "[", "\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\>\"", "]"}], Cell[
    "set your current working directory", "TableText"]},
   {
    RowBox[{
     ButtonBox["FileNames",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FileNames"], "[", "]"}], Cell[
    "list the files in your current working directory", "TableText"]},
   {
    RowBox[{
     ButtonBox["FileNames",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FileNames"], "[", "\"\<\!\(\*
StyleBox[\"form\", \"TI\"]\)\>\"", "]"}], Cell[
    "list the files whose names match a certain form", "TableText"]},
   {
    RowBox[{"<<", 
     StyleBox["name", "TI"]}], Cell[
    "read in a file with the specified name", "TableText"]},
   {
    RowBox[{"<<", 
     StyleBox["context", "TI"], 
     StyleBox["`", "MR"]}], Cell[
    "read in a file corresponding to the specified context", "TableText"]},
   {
    RowBox[{
     ButtonBox["CopyFile",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CopyFile"], "[", 
     RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"file\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"file\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\""}], "]"}], Cell[TextData[{
     "copy ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["file", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["file", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["DeleteFile",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DeleteFile"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", "]"}], Cell["delete a file", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->18040],

Cell["Functions for finding and manipulating files. ", "Caption",
 CellID->7986],

Cell["\<\
This is the current working directory. The form it has differs from one \
computer system to another. \
\>", "MathCaption",
 CellID->28834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Directory", "[", "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->14248],

Cell["/users/sw", "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->1539]
}, Open  ]],

Cell["This resets the current working directory. ", "MathCaption",
 CellID->28765],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetDirectory", "[", "\"\<Examples\>\"", "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->12796],

Cell["/users/sw/Examples", "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->10312]
}, Open  ]],

Cell[TextData[{
 "This gives a list of all files in your current working directory whose \
names match the form ",
 Cell[BoxData[
  RowBox[{"Test", "*", 
   RowBox[{".", "m"}]}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->7262],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FileNames", "[", "\"\<Test*.m\>\"", "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->25052],

Cell["{Test1.m, Test2.m, TestFinal.m}", "Output",
 ImageSize->{217, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->30731]
}, Open  ]],

Cell[TextData[{
 "The file name form you give to ",
 Cell[BoxData[
  ButtonBox["FileNames",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FileNames"]], "InlineFormula"],
 " can use any of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s string pattern objects, typically combined with the ",
 Cell[BoxData[
  ButtonBox["~~",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
 " operator. "
}], "Text",
 CellID->250707282],

Cell[TextData[{
 "This lists only those files with names of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox[
    RowBox[{"Test", 
     StyleBox["d", "TI"]}]], ".", "m"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 " is a sequence of one or more digits. "
}], "MathCaption",
 CellID->722345794],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FileNames", "[", 
  RowBox[{"\"\<Test\>\"", "~~", 
   RowBox[{"DigitCharacter", ".."}], "~~", "\"\<.m\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->459991907],

Cell["{Test1.m, Test2.m}", "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->146532095]
}, Open  ]],

Cell[TextData[{
 "Although you usually want to create files only in your current working \
directory, you often need to read in files from other directories. As a \
result, when you ask ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to read in a file with a particular name, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically searches a list of directories (specified by the value of \
the search path variable ",
 Cell[BoxData[
  ButtonBox["$Path",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Path"]], "InlineFormula"],
 ") to try and find a file with that name. "
}], "Text",
 CellID->23987],

Cell[TextData[{
 "One issue in handling files in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is that the form of file and directory names varies between computer \
systems. This means for example that names of files which contain standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " packages may be quite different on different systems. Through a sequence \
of conventions, it is however possible to read in a standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package with the same command on all systems. The way this works is that \
each package defines a so\[Hyphen]called ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " context, of the form ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["name", "TI"], "`", 
    StyleBox["name", "TI"], "`"}]]], "InlineFormula"],
 ". On each system, all files are named in correspondence with the contexts \
they define. Then when you use the command ",
 Cell[BoxData[
  RowBox[{"<<", 
   StyleBox[
    RowBox[{
     StyleBox["name", "TI"], "`", 
     StyleBox["name", "TI"], "`"}]]}]], "InlineFormula"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically translates the context name into the file name appropriate \
for your particular computer system."
}], "Text",
 CellID->24464],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FindList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FindList"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"text\", \"TI\"]\)\>\"", "]"}], Cell["\<\
give a list of all lines in a file that contain the specified text\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["FindList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FindList"], "[", 
     ButtonBox["FileNames",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FileNames"], "[", "]", ",", "\"\<\!\(\*
StyleBox[\"text\", \"TI\"]\)\>\"", "]"}], Cell[
    "search in all files in your current directory", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->32557],

Cell["Searching for text in files. ", "Caption",
 CellID->29556],

Cell[TextData[{
 "This searches for all lines in the file ",
 Cell[BoxData["BookIndex"], "InlineFormula"],
 " containing ",
 Cell[BoxData["diagrams"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->20170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindList", "[", 
  RowBox[{"\"\<BookIndex\>\"", ",", "\"\<diagrams\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->5450],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Ferrers diagrams: DiscreteMath`Combinatorica`\"\>", 
   ",", "\<\"Hasse diagrams: DiscreteMath`Combinatorica`\"\>"}], 
  "}"}]], "Output",
 ImageSize->{333, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->27182]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->162314877],

Cell[TextData[ButtonBox["Files and External Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FilesAndExternalOperationsOverview"]], "RelatedTutorials",
 CellID->16088632]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Finding and Manipulating Files - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Files and External Operations", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/FilesAndExternalOperationsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ReadingAndWritingMathematicaFiles-Basics"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ImportingAndExportingData"]}],
       "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 31.0647334}", "context" -> "", 
    "keywords" -> {
     "back quote", "cd", "change directory", "CopyFile", "DeleteFile", "dir", 
      "directories", "Directory", "FileNames", "files", "FindList", "folders",
       "grep", "ls", "Path", "pwd", "searching", "search path", 
      "SetDirectory", "text", "Thirdparty packages", "translation", "path"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Although the details of how files are named and organized differ from \
one computer system to another, Mathematica provides some fairly general \
mechanisms for finding and handling files. Mathematica assumes that files on \
your computer system are organized in a collection of directories. At any \
point, you have a current working directory. You can always refer to files in \
this directory just by giving their names. Functions for finding and \
manipulating files. ", "synonyms" -> {"1.11.2"}, "title" -> 
    "Finding and Manipulating Files", "type" -> "Tutorial", "uri" -> 
    "tutorial/FindingAndManipulatingFiles"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.11.2"->{
  Cell[2368, 67, 94, 2, 70, "Title",
   CellTags->{"S1.11.2", "2.1"},
   CellID->14631]},
 "2.1"->{
  Cell[2368, 67, 94, 2, 70, "Title",
   CellTags->{"S1.11.2", "2.1"},
   CellID->14631]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.11.2", 15228, 481},
 {"2.1", 15328, 485}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1743, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2368, 67, 94, 2, 70, "Title",
 CellTags->{"S1.11.2", "2.1"},
 CellID->14631],
Cell[2465, 71, 278, 7, 70, "Text",
 CellID->13640],
Cell[2746, 80, 403, 13, 70, "Text",
 CellID->8934],
Cell[3152, 95, 2406, 73, 70, "DefinitionBox",
 CellID->18040],
Cell[5561, 170, 80, 1, 70, "Caption",
 CellID->7986],
Cell[5644, 173, 149, 4, 70, "MathCaption",
 CellID->28834],
Cell[CellGroupData[{
Cell[5818, 181, 97, 3, 28, "Input",
 CellID->14248],
Cell[5918, 186, 153, 5, 36, "Output",
 CellID->1539]
}, Open  ]],
Cell[6086, 194, 82, 1, 70, "MathCaption",
 CellID->28765],
Cell[CellGroupData[{
Cell[6193, 199, 120, 3, 28, "Input",
 CellID->12796],
Cell[6316, 204, 164, 5, 36, "Output",
 CellID->10312]
}, Open  ]],
Cell[6495, 212, 237, 8, 70, "MathCaption",
 CellID->7262],
Cell[CellGroupData[{
Cell[6757, 224, 116, 3, 70, "Input",
 CellID->25052],
Cell[6876, 229, 177, 5, 36, "Output",
 CellID->30731]
}, Open  ]],
Cell[7068, 237, 470, 16, 70, "Text",
 CellID->250707282],
Cell[7541, 255, 342, 12, 70, "MathCaption",
 CellID->722345794],
Cell[CellGroupData[{
Cell[7908, 271, 194, 5, 70, "Input",
 CellID->459991907],
Cell[8105, 278, 218, 7, 36, "Output",
 CellID->146532095]
}, Open  ]],
Cell[8338, 288, 625, 17, 70, "Text",
 CellID->23987],
Cell[8966, 307, 1292, 36, 70, "Text",
 CellID->24464],
Cell[10261, 345, 1013, 28, 70, "DefinitionBox",
 CellID->32557],
Cell[11277, 375, 64, 1, 70, "Caption",
 CellID->29556],
Cell[11344, 378, 209, 7, 70, "MathCaption",
 CellID->20170],
Cell[CellGroupData[{
Cell[11578, 389, 154, 4, 70, "Input",
 CellID->5450],
Cell[11735, 395, 310, 9, 54, "Output",
 CellID->27182]
}, Open  ]],
Cell[CellGroupData[{
Cell[12082, 409, 72, 1, 70, "RelatedTutorialsSection",
 CellID->162314877],
Cell[12157, 412, 187, 4, 70, "RelatedTutorials",
 CellID->16088632]
}, Open  ]]
}, Open  ]],
Cell[12371, 420, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

