(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28296,       1030]
NotebookOptionsPosition[     21643,        813]
NotebookOutlinePosition[     24545,        886]
CellTagsIndexPosition[     24454,        880]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Series, Limits and Residues" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SeriesLimitsAndResiduesOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Series, Limits and Residues\"\>"}, "\<\"related tutorials\"\>",
        
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Direction" :> Documentation`HelpLookup["paclet:ref/Direction"],
           "Limit" :> Documentation`HelpLookup["paclet:ref/Limit"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Direction\"\>", 
       2->"\<\"Limit\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Finding Limits", "Title",
 CellTags->{"S3.6.9", "9.1"},
 CellID->25197],

Cell[TextData[{
 "In doing many kinds of calculations, you need to evaluate expressions when \
variables take on particular values. In many cases, you can do this simply by \
applying transformation rules for the variables using the ",
 Cell[BoxData["/."], "InlineFormula"],
 " operator. "
}], "Text",
 CellID->4508],

Cell[TextData[{
 "You can get the value of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"cos", 
    RowBox[{"(", 
     SuperscriptBox["x", "2"], ")"}]}], TraditionalForm]], "InlineMath"],
 " at 0 just by explicitly replacing ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " with 0, and then evaluating the result. "
}], "MathCaption",
 CellID->22908],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", 
   RowBox[{"x", "^", "2"}], "]"}], "/.", 
  RowBox[{"x", "->", "0"}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->17411],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->13993]
}, Open  ]],

Cell["In some cases, however, you have to be more careful. ", "Text",
 CellID->7665],

Cell[TextData[{
 "Consider, for example, finding the value of the expression ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"sin", 
     RowBox[{"(", "x", ")"}]}], "x"], TraditionalForm]], "InlineMath"],
 " when ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "0"}], TraditionalForm]], "InlineMath"],
 ". If you simply replace ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " by ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 " in this expression, you get the indeterminate result ",
 Cell[BoxData[
  FormBox[
   FractionBox["0", "0"], TraditionalForm]], "InlineMath"],
 ". To find the correct value of ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"sin", 
     RowBox[{"(", "x", ")"}]}], "x"], TraditionalForm]], "InlineMath"],
 " when ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "0"}], TraditionalForm]], "InlineMath"],
 ", you need to take the ",
 StyleBox["limit",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->26781],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Limit",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Limit"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["x", "TI"], "->", 
     SubscriptBox[
      StyleBox["x", "TI"], "0"], "]"}], Cell[TextData[{
     "find the limit of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " when ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " approaches ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], "0"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->3202],

Cell["Finding limits. ", "Caption",
 CellID->17610],

Cell[TextData[{
 "This gives the correct value for the limit of ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"sin", 
     RowBox[{"(", "x", ")"}]}], "x"], TraditionalForm]], "InlineMath"],
 " as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[Rule]", "0"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->24828],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "/", "x"}], ",", 
   RowBox[{"x", "->", "0"}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->27256],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->27705]
}, Open  ]],

Cell["No finite limit exists in this case. ", "MathCaption",
 CellID->8965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "/", 
    RowBox[{"x", "^", "2"}]}], ",", 
   RowBox[{"x", "->", "0"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->18023],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->945247960]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Limit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Limit"]], "InlineFormula"],
 " can find this limit, even though you cannot get an ordinary power series \
for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "log", 
    RowBox[{"(", "x", ")"}]}], TraditionalForm]], "InlineMath"],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "0"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->11715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"Log", "[", "x", "]"}]}], ",", 
   RowBox[{"x", "->", "0"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->20253],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->57564083]
}, Open  ]],

Cell["The same is true here. ", "MathCaption",
 CellID->23684],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "x"}]}], ")"}], "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "x"}], ")"}]}], ",", 
   RowBox[{"x", "->", "0"}]}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->29478],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->32145]
}, Open  ]],

Cell[TextData[{
 "The value of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sign",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sign"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " at ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "=", "0"}]], "InlineFormula"],
 " is ",
 Cell[BoxData["0"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->21840],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sign", "[", "0", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->833],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->136483794]
}, Open  ]],

Cell[TextData[{
 "Its ",
 StyleBox["limit",
  FontSlant->"Italic"],
 ", however, is ",
 Cell[BoxData["1"], "InlineFormula"],
 ". The limit is by default taken from above. "
}], "MathCaption",
 CellID->26900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Sign", "[", "x", "]"}], ",", 
   RowBox[{"x", "->", "0"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->10968],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->318812075]
}, Open  ]],

Cell[TextData[{
 "Not all functions have definite limits at particular points. For example, \
the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", 
    RowBox[{"(", 
     RowBox[{"1", "/", "x"}], ")"}]}], TraditionalForm]], "InlineMath"],
 " oscillates infinitely often near ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "0"}], TraditionalForm]], "InlineMath"],
 ", so it has no definite limit there. Nevertheless, at least so long as ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " remains real, the values of the function near ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "0"}], TraditionalForm]], "InlineMath"],
 " always lie between ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 " and 1. ",
 Cell[BoxData[
  ButtonBox["Limit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Limit"]], "InlineFormula"],
 " represents values with bounded variation using ",
 Cell[BoxData[
  ButtonBox["Interval",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Interval"]], "InlineFormula"],
 " objects. In general, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Interval",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Interval"], "[", "{"}]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", 
    StyleBox["min", "TI"]], TraditionalForm]], "InlineMath"],
 Cell[BoxData[","], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", 
    StyleBox["max", "TI"]], TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  RowBox[{"}", "]"}]], "InlineFormula"],
 " represents an uncertain value which lies somewhere in the interval ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", 
    StyleBox["min", "TI"]], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", 
    StyleBox["max", "TI"]], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->16633],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Limit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Limit"]], "InlineFormula"],
 " returns an ",
 Cell[BoxData[
  ButtonBox["Interval",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Interval"]], "InlineFormula"],
 " object, representing the range of possible values of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", 
    RowBox[{"(", 
     RowBox[{"1", "/", "x"}], ")"}]}], TraditionalForm]], "InlineMath"],
 " near its essential singularity at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "0"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->13885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"1", "/", "x"}], "]"}], ",", 
   RowBox[{"x", "->", "0"}]}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->348],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->18281]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can do arithmetic with ",
 Cell[BoxData[
  ButtonBox["Interval",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Interval"]], "InlineFormula"],
 " objects. "
}], "MathCaption",
 CellID->18032],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "+", "%"}], ")"}], "^", "3"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->16256],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "8"}], "}"}], "]"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->29910]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " represents this limit symbolically in terms of an ",
 Cell[BoxData[
  ButtonBox["Interval",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Interval"]], "InlineFormula"],
 " object. "
}], "MathCaption",
 CellID->10872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"x", "->", "Infinity"}]}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->8982],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    FractionBox["1", "\[ExponentialE]"], ",", "\[ExponentialE]"}], "}"}], 
  "]"}]], "Output",
 ImageSize->{118, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->23901]
}, Open  ]],

Cell[TextData[{
 "Some functions may have different limits at particular points, depending on \
the direction from which you approach those points. You can use the ",
 Cell[BoxData[
  ButtonBox["Direction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Direction"]], "InlineFormula"],
 " option for ",
 Cell[BoxData[
  ButtonBox["Limit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Limit"]], "InlineFormula"],
 " to specify the direction you want. "
}], "Text",
 CellID->12306],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Limit",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Limit"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["x", "TI"], "->", 
     SubscriptBox[
      StyleBox["x", "TI"], "0"], ",", 
     ButtonBox["Direction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Direction"], "->", "1", "]"}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "find the limit as ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " approaches ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], "0"]], "InlineFormula"],
     " from below"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Limit",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Limit"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["x", "TI"], "->", 
     SubscriptBox[
      StyleBox["x", "TI"], "0"], ",", 
     ButtonBox["Direction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Direction"], "->", "-", "1", "]"}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "find the limit as ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " approaches ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], "0"]], "InlineFormula"],
     " from above"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->10635],

Cell["Directional limits. ", "Caption",
 CellID->17860],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "x"}], TraditionalForm]], "InlineMath"],
 " has a different limiting value at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "0"}], TraditionalForm]], "InlineMath"],
 ", depending on whether you approach from above or below. "
}], "MathCaption",
 CellID->32471],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"1", "/", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->29527],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9mD1MHEcUx9e3CxwHTpDzRRQZzlIUOUUSlMIiihwTJ4az+XTiECQ3ICsS
jhQFOS7oKCkpKSmR0tBYoqSkpKSkpKSkvPzee7Ps7tzs3lkoPolldub/PuZ9
zuz82uv1P/5ae/3yxVpz5tXaxvrLF/80p/9+xVR8I4qiN/z9ORoxbjPSvzft
Nv+fyzOWd/1Fyzr7TGe3t7cvLy9lmKSo8/NzH9VsNs/Ozgqoo6OjDPWrzl5c
XIyMjMiwj0cN0O+51ZOTk4mJiXS1k8cCT5msOdr+IGpRngPZXqJoY2NjZ2eH
QQnfFs+EybiDcmlp6eDgoJyyU5bZIaUQgjLk6OioDXrm3Wq1KikWnF1qurq1
tRXZL2ynX3R2amrKzfYXPGKr9Xrd+T7M46nnt4EKFHG0ubnZDZXpE0YtpXGE
+VAtqhe0ttX9/f2VlRUZ1it4rK6u7u3tlaPU/jEyiFiRNFiB2t3dXV9fl+Fg
QR9bnZycPD4+TlfDfstbsVGBsogsR817vIYK+sx7PIaCPOZ09vDw0AVc7CI5
HAOzqZ3YJnIzv7m4jUupaoSo5F3SE8UTnWWKECl4LUeV5dtjnSIV0YpypVqV
14xWisZqkr4+73C+zXhUDScjjJ7WWQIBtNjpVsEzj9I4YndEd/RBkMdP8kxO
T09BEXAY/cMg7kfFwQcLI461j4O4B7o57AOOysVTIv2TIPa+YpGNYMOKnp8W
djHQzip03n6CGHfIOLcm1ammJQr7UaPv6g8roMZnnhbNCvrxCrmKD0ZLlOSr
6+2OGY3LfjxG3UIt6yQYYMzTbLyD0s+B212l1+xf7Dbl9hV3pRNfJSn9cH6F
/MVHBApFnCSg/KK6dKj/TfvuNlafNvA1sq29EknW2dCVSfzu73nM+b35DvXU
rLpJfKMSpRLd6BZmShRmAIb5XKcXDe90tWyKbHbVoFdNrYKbRcWoUlOjIQyL
kmZb2hdjZlih4ZmRjX+HbnlZ3ePEpxjvcVf5WqxRLoonZP2W/qgvNTFxQou3
VGAjMqN7i7E7eDF92ttSfr7GTW99zJer2lgfJbPNv8ogUfkoYhqhWk10jO3g
KwQ/tPN1r5Hzglh3wdPEKujza8/KTv71NA90qR7f37smfem70/mdyXub9w6r
+b76wlv/qouXJAoeyltCdFgWUnoTidWEujalP9qH9rnYyBUe5HtPHv1WefhR
tWFEcFpGWEZHennQmdgqpwjT7EgQbZQU+8GghG/kUaerWYMgyGFkqUapMK40
PJbk0mRxb1c7IfwoyPNLeQzzAgm0VwzpO6YgGcQqBroTpP9cHg1ORRQoFOLI
whpc2DgWMMq7BYsrnzrTUHDYRxxEFGkEwebroBTtDwN20jAVIeCyIOfDb4MU
2q/6EMEusD3qiDnuBbF6m+vDc3A31hg4+q6gtZ6s+qgQYIyfyP4+yE8tnVDt
iB2AML4fxOlJUc56SKTKs70HQdwtfScscAo7sjPilWa2isaYUc4JD4M89Oou
9ysESZ3T86je3uOo89z7vr7zgvUE/bOil738qnlUViVwojsJP+qJ6qa+Y012
J71hupRKXg2d3YMM/awdPr8P63t2x5u5Qud5+989hlKNsKh42e7uvzkZYTQC
ECPDVsE7Q6lN3K3ucdA7V52M6CpHDaZ6EYDilScVKHKZ/JNhGGXnE7jAS/Y4
W9B6MI0pd4+creBBDhNW5aiBVJK7jc9VoHAqrpXhXEGfumfjKh52SStH9adW
dJ9x5itQZBu5WUSl55K8PlU8Mn0MtdgufgsL997se5t2Ofvy0Xkiq8gr45Pd
uq/Hh8AkPN+WT1Zbsm8219Mjs+b1+HinCPVKerIMecWynvpEvshwsRAPhs6i
N1vt5JFZ0kO5b7NJ6je3Tw/ltF6umI1u/AfCUHIq\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->43823436]
}, Open  ]],

Cell[TextData[{
 "Approaching from below gives a limiting value of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->8343],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"1", "/", "x"}], ",", 
   RowBox[{"x", "->", "0"}], ",", 
   RowBox[{"Direction", "->", "1"}]}], "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->9768],

Cell[BoxData[
 RowBox[{"-", "\[Infinity]"}]], "Output",
 ImageSize->{20, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->28233]
}, Open  ]],

Cell[TextData[{
 "Approaching from above gives a limiting value of ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->3995],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"1", "/", "x"}], ",", 
   RowBox[{"x", "->", "0"}], ",", 
   RowBox[{"Direction", "->", 
    RowBox[{"-", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->29171],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->267310542]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Limit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Limit"]], "InlineFormula"],
 " makes no assumptions about functions like ",
 Cell[BoxData[
  RowBox[{"f", "[", "x", "]"}]], "InlineFormula"],
 " about which it does not have definite knowledge. As a result, ",
 Cell[BoxData[
  ButtonBox["Limit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Limit"]], "InlineFormula"],
 " remains unevaluated in most cases involving symbolic functions. "
}], "Text",
 CellID->28942],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Limit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Limit"]], "InlineFormula"],
 " has no definite knowledge about ",
 Cell[BoxData["f"], "InlineFormula"],
 ", so it leaves this limit unevaluated. "
}], "MathCaption",
 CellID->18011],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"f", "[", "x", "]"}]}], ",", 
   RowBox[{"x", "->", "0"}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->7879],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"f", "[", "x", "]"}]}], ",", 
   RowBox[{"x", "\[Rule]", "0"}]}], "]"}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->70026391]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->423189526],

Cell[TextData[ButtonBox["Series, Limits and Residues",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SeriesLimitsAndResiduesOverview"]], "RelatedTutorials",
 CellID->78569985]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Finding Limits - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Series, Limits and Residues", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/SeriesLimitsAndResiduesOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/SolvingRecurrenceEquations"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/Residues"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 33.2054132}", "context" -> "", 
    "keywords" -> {
     "asymptote", "direction", "directional limits", "discontinuities", 
      "discontinuity", "essential singularities", "interval", 
      "LHospitals rule", "limit", "limits", "non-differentiable functions", 
      "oscillating functions"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "In doing many kinds of calculations, you need to evaluate expressions \
when variables take on particular values. In many cases, you can do this \
simply by applying transformation rules for the variables using the /. \
operator. You can get the value of cos(x^2) at 0 just by explicitly replacing \
x with 0, and then evaluating the result. In some cases, however, you have to \
be more careful. ", "synonyms" -> {"3.6.9"}, "title" -> "Finding Limits", 
    "type" -> "Tutorial", "uri" -> "tutorial/FindingLimits"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.6.9"->{
  Cell[1922, 60, 77, 2, 70, "Title",
   CellTags->{"S3.6.9", "9.1"},
   CellID->25197]},
 "9.1"->{
  Cell[1922, 60, 77, 2, 70, "Title",
   CellTags->{"S3.6.9", "9.1"},
   CellID->25197]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.6.9", 24243, 869},
 {"9.1", 24342, 873}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1297, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1922, 60, 77, 2, 70, "Title",
 CellTags->{"S3.6.9", "9.1"},
 CellID->25197],
Cell[2002, 64, 316, 7, 70, "Text",
 CellID->4508],
Cell[2321, 73, 366, 12, 70, "MathCaption",
 CellID->22908],
Cell[CellGroupData[{
Cell[2712, 89, 168, 6, 28, "Input",
 CellID->17411],
Cell[2883, 97, 155, 5, 36, "Output",
 CellID->13993]
}, Open  ]],
Cell[3053, 105, 84, 1, 70, "Text",
 CellID->7665],
Cell[3140, 108, 997, 36, 70, "Text",
 CellID->26781],
Cell[4140, 146, 904, 29, 70, "DefinitionBox",
 CellID->3202],
Cell[5047, 177, 51, 1, 70, "Caption",
 CellID->17610],
Cell[5101, 180, 344, 13, 70, "MathCaption",
 CellID->24828],
Cell[CellGroupData[{
Cell[5470, 197, 202, 7, 70, "Input",
 CellID->27256],
Cell[5675, 206, 155, 5, 36, "Output",
 CellID->27705]
}, Open  ]],
Cell[5845, 214, 75, 1, 70, "MathCaption",
 CellID->8965],
Cell[CellGroupData[{
Cell[5945, 219, 226, 8, 70, "Input",
 CellID->18023],
Cell[6174, 229, 168, 5, 36, "Output",
 CellID->945247960]
}, Open  ]],
Cell[6357, 237, 466, 17, 70, "MathCaption",
 CellID->11715],
Cell[CellGroupData[{
Cell[6848, 258, 201, 7, 70, "Input",
 CellID->20253],
Cell[7052, 267, 157, 5, 36, "Output",
 CellID->57564083]
}, Open  ]],
Cell[7224, 275, 62, 1, 70, "MathCaption",
 CellID->23684],
Cell[CellGroupData[{
Cell[7311, 280, 299, 11, 70, "Input",
 CellID->29478],
Cell[7613, 293, 192, 6, 36, "Output",
 CellID->32145]
}, Open  ]],
Cell[7820, 302, 372, 16, 70, "MathCaption",
 CellID->21840],
Cell[CellGroupData[{
Cell[8217, 322, 94, 3, 70, "Input",
 CellID->833],
Cell[8314, 327, 158, 5, 36, "Output",
 CellID->136483794]
}, Open  ]],
Cell[8487, 335, 207, 8, 70, "MathCaption",
 CellID->26900],
Cell[CellGroupData[{
Cell[8719, 347, 177, 6, 70, "Input",
 CellID->10968],
Cell[8899, 355, 158, 5, 36, "Output",
 CellID->318812075]
}, Open  ]],
Cell[9072, 363, 1886, 63, 70, "Text",
 CellID->16633],
Cell[10961, 428, 628, 22, 70, "MathCaption",
 CellID->13885],
Cell[CellGroupData[{
Cell[11614, 454, 200, 7, 70, "Input",
 CellID->348],
Cell[11817, 463, 257, 9, 36, "Output",
 CellID->18281]
}, Open  ]],
Cell[12089, 475, 261, 10, 70, "MathCaption",
 CellID->18032],
Cell[CellGroupData[{
Cell[12375, 489, 136, 5, 70, "Input",
 CellID->16256],
Cell[12514, 496, 237, 8, 36, "Output",
 CellID->29910]
}, Open  ]],
Cell[12766, 507, 287, 10, 70, "MathCaption",
 CellID->10872],
Cell[CellGroupData[{
Cell[13078, 521, 216, 7, 70, "Input",
 CellID->8982],
Cell[13297, 530, 292, 10, 51, "Output",
 CellID->23901]
}, Open  ]],
Cell[13604, 543, 485, 14, 70, "Text",
 CellID->12306],
Cell[14092, 559, 1792, 58, 70, "DefinitionBox",
 CellID->10635],
Cell[15887, 619, 55, 1, 70, "Caption",
 CellID->17860],
Cell[15945, 622, 345, 11, 70, "MathCaption",
 CellID->32471],
Cell[CellGroupData[{
Cell[16315, 637, 223, 8, 28, "Input",
 CellID->29527],
Cell[16541, 647, 2143, 39, 127, "Output",
 Evaluatable->False,
 CellID->43823436]
}, Open  ]],
Cell[18699, 689, 202, 7, 70, "MathCaption",
 CellID->8343],
Cell[CellGroupData[{
Cell[18926, 700, 213, 7, 70, "Input",
 CellID->9768],
Cell[19142, 709, 183, 6, 36, "Output",
 CellID->28233]
}, Open  ]],
Cell[19340, 718, 183, 6, 70, "MathCaption",
 CellID->3995],
Cell[CellGroupData[{
Cell[19548, 728, 233, 8, 70, "Input",
 CellID->29171],
Cell[19784, 738, 169, 5, 36, "Output",
 CellID->267310542]
}, Open  ]],
Cell[19968, 746, 520, 15, 70, "Text",
 CellID->28942],
Cell[20491, 763, 282, 9, 70, "MathCaption",
 CellID->18011],
Cell[CellGroupData[{
Cell[20798, 776, 198, 7, 70, "Input",
 CellID->7879],
Cell[20999, 785, 296, 10, 36, "Output",
 CellID->70026391]
}, Open  ]],
Cell[CellGroupData[{
Cell[21332, 800, 72, 1, 70, "RelatedTutorialsSection",
 CellID->423189526],
Cell[21407, 803, 182, 4, 70, "RelatedTutorials",
 CellID->78569985]
}, Open  ]]
}, Open  ]],
Cell[21616, 811, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

