(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23158,        867]
NotebookOptionsPosition[     17350,        673]
NotebookOutlinePosition[     19987,        744]
CellTagsIndexPosition[     19896,        738]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicManipulationOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Algebraic Manipulation\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Coefficient" :> 
          Documentation`HelpLookup["paclet:ref/Coefficient"], 
          "CoefficientList" :> 
          Documentation`HelpLookup["paclet:ref/CoefficientList"], "Exponent" :> 
          Documentation`HelpLookup["paclet:ref/Exponent"], "PolynomialQ" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialQ"], "Variables" :> 
          Documentation`HelpLookup["paclet:ref/Variables"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Coefficient\"\>", 
       2->"\<\"CoefficientList\"\>", 3->"\<\"Exponent\"\>", 
       4->"\<\"PolynomialQ\"\>", 5->"\<\"Variables\"\>"}, "\<\"functions\"\>",
        
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Finding the Structure of a Polynomial", "Title",
 CellTags->{"S3.3.2", "2.1"},
 CellID->14512],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["PolynomialQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PolynomialQ"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "test whether ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a polynomial in ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PolynomialQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PolynomialQ"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "test whether ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a polynomial in the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Variables",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Variables"], "[", 
     StyleBox["poly", "TI"], "]"}], Cell[TextData[{
     "a list of the variables in ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Exponent",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Exponent"], "[", 
     StyleBox["poly", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "the maximum exponent with which ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " appears in ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Coefficient",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Coefficient"], "[", 
     StyleBox["poly", "TI"], ",", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "the coefficient of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Coefficient",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Coefficient"], "[", 
     StyleBox["poly", "TI"], ",", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "the coefficient of ",
     Cell[BoxData[
      RowBox[{
       StyleBox["expr", "TI"], "^", 
       StyleBox["n", "TI"]}]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Coefficient",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Coefficient"], "[", 
     StyleBox["poly", "TI"], ",", 
     StyleBox["expr", "TI"], ",", "0", "]"}], Cell[TextData[{
     "the term in ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"],
     " independent of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CoefficientList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CoefficientList"], "[", 
     StyleBox["poly", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "generate an array of the coefficients of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->24593],

Cell["\<\
Finding the structure of polynomials written in expanded form. \
\>", "Caption",
 CellID->530],

Cell["Here is a polynomial in two variables. ", "MathCaption",
 CellID->14161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "^", "3"}], " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", "y", "-", "x"}], ")"}], "^", "2"}]}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->23234],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], "3"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "-", "x", "-", "y"}], ")"}], "2"]}]], "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->10258]
}, Open  ]],

Cell["This is the polynomial in expanded form. ", "MathCaption",
 CellID->21926],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", "t", "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->5906],

Cell[BoxData[
 RowBox[{"1", "+", "x", "-", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "2"]}], "-", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  SuperscriptBox["x", "4"], "+", 
  SuperscriptBox["x", "5"], "-", 
  RowBox[{"2", " ", "y"}], "-", 
  RowBox[{"4", " ", "x", " ", "y"}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["x", "3"], " ", "y"}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "4"], " ", "y"}], "+", 
  SuperscriptBox["y", "2"], "+", 
  RowBox[{"3", " ", "x", " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{
   SuperscriptBox["x", "3"], " ", 
   SuperscriptBox["y", "2"]}]}]], "Output",
 ImageSize->{473, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->5191]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolynomialQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialQ"]], "InlineFormula"],
 " reports that ",
 Cell[BoxData["t"], "InlineFormula"],
 " is a polynomial in ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->14443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialQ", "[", 
  RowBox[{"t", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->6188],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->30227]
}, Open  ]],

Cell[TextData[{
 "This expression, however, is not a polynomial in ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->32719],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialQ", "[", 
  RowBox[{
   RowBox[{"x", "+", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->26484],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->5224]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Variables",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Variables"]], "InlineFormula"],
 " gives a list of the variables in the polynomial ",
 Cell[BoxData["t"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->19093],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variables", "[", "t", "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->30435],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->13224]
}, Open  ]],

Cell[TextData[{
 "This gives the maximum exponent with which ",
 Cell[BoxData["x"], "InlineFormula"],
 " appears in the polynomial ",
 Cell[BoxData["t"], "InlineFormula"],
 ". For a polynomial in one variable, ",
 Cell[BoxData[
  ButtonBox["Exponent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exponent"]], "InlineFormula"],
 " gives the degree of the polynomial. "
}], "MathCaption",
 CellID->28094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exponent", "[", 
  RowBox[{"t", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->3582],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->8867]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Coefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Coefficient"], "[", 
   RowBox[{
    StyleBox["poly", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " gives the total coefficient with which ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " appears in ",
 Cell[BoxData[
  StyleBox["poly", "TI"]], "InlineFormula"],
 ". In this case, the result is a sum of two terms. "
}], "MathCaption",
 CellID->8627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coefficient", "[", 
  RowBox[{"t", ",", 
   RowBox[{"x", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->22005],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["y", "2"]}]}]], "Output",
 ImageSize->{54, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->11146]
}, Open  ]],

Cell[TextData[{
 "This is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Coefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Coefficient"], "[", 
   RowBox[{"t", ",", 
    RowBox[{"x", "^", "2"}]}], "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->32686],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coefficient", "[", 
  RowBox[{"t", ",", "x", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->16589],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["y", "2"]}]}]], "Output",
 ImageSize->{54, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->20540]
}, Open  ]],

Cell[TextData[{
 "This picks out the coefficient of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "0"], TraditionalForm]], "InlineMath"],
 " in\[NonBreakingSpace]",
 Cell[BoxData["t"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->18237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coefficient", "[", 
  RowBox[{"t", ",", "x", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->22850],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{"2", " ", "y"}], "+", 
  SuperscriptBox["y", "2"]}]], "Output",
 ImageSize->{66, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->18759]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CoefficientList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoefficientList"]], "InlineFormula"],
 " gives a list of the coefficients of each power of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", starting with ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "0"], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->9578],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientList", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"3", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"4", 
     RowBox[{"x", "^", "4"}]}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->28956],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0", ",", "3", ",", "0", ",", "4"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->32677]
}, Open  ]],

Cell[TextData[{
 "For multivariate polynomials, ",
 Cell[BoxData[
  ButtonBox["CoefficientList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoefficientList"]], "InlineFormula"],
 " gives an array of the coefficients for each power of each variable. "
}], "MathCaption",
 CellID->2403],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientList", "[", 
  RowBox[{"t", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->28042],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "2"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "4"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{449, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->6300]
}, Open  ]],

Cell["\<\
It is important to notice that the functions in this section will often work \
even on polynomials that are not explicitly given in expanded form. \
\>", "Text",
 CellID->15811],

Cell["\<\
Many of the functions also work on expressions that are not strictly \
polynomials. \
\>", "Text",
 CellID->5225],

Cell[TextData[{
 "Without giving specific integer values to ",
 Cell[BoxData["a"], "InlineFormula"],
 ", ",
 Cell[BoxData["b"], "InlineFormula"],
 " and ",
 Cell[BoxData["c"], "InlineFormula"],
 ", this expression cannot strictly be considered a polynomial. "
}], "MathCaption",
 CellID->21143],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "^", "a"}], "+", 
  RowBox[{"x", "^", "b"}], "+", 
  RowBox[{"y", "^", "c"}]}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->21595],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "a"], "+", 
  SuperscriptBox["x", "b"], "+", 
  SuperscriptBox["y", "c"]}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->21016]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Exponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exponent"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", "x"}], "]"}]], "InlineFormula"],
 " still gives the maximum exponent of ",
 Cell[BoxData["x"], "InlineFormula"],
 " in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ", but here has to write the result in symbolic form. "
}], "MathCaption",
 CellID->26615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exponent", "[", 
  RowBox[{"%", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->28804],

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"0", ",", "a", ",", "b"}], "]"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->21006]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->355767686],

Cell[TextData[ButtonBox["Algebraic Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AlgebraicManipulationOverview"]], "RelatedTutorials",
 CellID->91103315]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Finding the Structure of a Polynomial - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Algebraic Manipulation", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/AlgebraicManipulationOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/StructuralOperationsOnPolynomials"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/StructuralOperationsOnRationalExpressions"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 33.9398070}", "context" -> "", 
    "keywords" -> {
     "Coefficient", "CoefficientList", "Exponent", "PolynomialQ", 
      "Polynomials", "Variables"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Finding the structure of polynomials written in expanded form. Here is a \
polynomial in two variables. This is the polynomial in expanded form. ", 
    "synonyms" -> {"3.3.2"}, "title" -> 
    "Finding the Structure of a Polynomial", "type" -> "Tutorial", "uri" -> 
    "tutorial/FindingTheStructureOfAPolynomial"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.3.2"->{
  Cell[2279, 66, 100, 2, 70, "Title",
   CellTags->{"S3.3.2", "2.1"},
   CellID->14512]},
 "2.1"->{
  Cell[2279, 66, 100, 2, 70, "Title",
   CellTags->{"S3.3.2", "2.1"},
   CellID->14512]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.3.2", 19683, 727},
 {"2.1", 19783, 731}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1654, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2279, 66, 100, 2, 70, "Title",
 CellTags->{"S3.3.2", "2.1"},
 CellID->14512],
Cell[2382, 70, 3843, 129, 70, "DefinitionBox",
 CellID->24593],
Cell[6228, 201, 104, 3, 70, "Caption",
 CellID->530],
Cell[6335, 206, 78, 1, 70, "MathCaption",
 CellID->14161],
Cell[CellGroupData[{
Cell[6438, 211, 272, 10, 28, "Input",
 CellID->23234],
Cell[6713, 223, 334, 12, 36, "Output",
 CellID->10258]
}, Open  ]],
Cell[7062, 238, 80, 1, 70, "MathCaption",
 CellID->21926],
Cell[CellGroupData[{
Cell[7167, 243, 98, 3, 28, "Input",
 CellID->5906],
Cell[7268, 248, 851, 27, 36, "Output",
 CellID->5191]
}, Open  ]],
Cell[8134, 278, 301, 11, 70, "MathCaption",
 CellID->14443],
Cell[CellGroupData[{
Cell[8460, 293, 126, 4, 28, "Input",
 CellID->6188],
Cell[8589, 299, 158, 5, 36, "Output",
 CellID->30227]
}, Open  ]],
Cell[8762, 307, 148, 5, 70, "MathCaption",
 CellID->32719],
Cell[CellGroupData[{
Cell[8935, 316, 183, 6, 70, "Input",
 CellID->26484],
Cell[9121, 324, 158, 5, 36, "Output",
 CellID->5224]
}, Open  ]],
Cell[9294, 332, 269, 9, 70, "MathCaption",
 CellID->19093],
Cell[CellGroupData[{
Cell[9588, 345, 102, 3, 70, "Input",
 CellID->30435],
Cell[9693, 350, 200, 7, 36, "Output",
 CellID->13224]
}, Open  ]],
Cell[9908, 360, 407, 12, 70, "MathCaption",
 CellID->28094],
Cell[CellGroupData[{
Cell[10340, 376, 123, 4, 70, "Input",
 CellID->3582],
Cell[10466, 382, 154, 5, 36, "Output",
 CellID->8867]
}, Open  ]],
Cell[10635, 390, 513, 17, 70, "MathCaption",
 CellID->8627],
Cell[CellGroupData[{
Cell[11173, 411, 151, 5, 70, "Input",
 CellID->22005],
Cell[11327, 418, 243, 9, 36, "Output",
 CellID->11146]
}, Open  ]],
Cell[11585, 430, 288, 11, 70, "MathCaption",
 CellID->32686],
Cell[CellGroupData[{
Cell[11898, 445, 137, 4, 70, "Input",
 CellID->16589],
Cell[12038, 451, 243, 9, 36, "Output",
 CellID->20540]
}, Open  ]],
Cell[12296, 463, 249, 9, 70, "MathCaption",
 CellID->18237],
Cell[CellGroupData[{
Cell[12570, 476, 137, 4, 70, "Input",
 CellID->22850],
Cell[12710, 482, 234, 8, 36, "Output",
 CellID->18759]
}, Open  ]],
Cell[12959, 493, 418, 14, 70, "MathCaption",
 CellID->9578],
Cell[CellGroupData[{
Cell[13402, 511, 258, 9, 70, "Input",
 CellID->28956],
Cell[13663, 522, 231, 7, 36, "Output",
 CellID->32677]
}, Open  ]],
Cell[13909, 532, 290, 8, 70, "MathCaption",
 CellID->2403],
Cell[CellGroupData[{
Cell[14224, 544, 181, 6, 70, "Input",
 CellID->28042],
Cell[14408, 552, 679, 23, 36, "Output",
 CellID->6300]
}, Open  ]],
Cell[15102, 578, 187, 4, 70, "Text",
 CellID->15811],
Cell[15292, 584, 123, 4, 70, "Text",
 CellID->5225],
Cell[15418, 590, 294, 9, 70, "MathCaption",
 CellID->21143],
Cell[CellGroupData[{
Cell[15737, 603, 169, 6, 70, "Input",
 CellID->21595],
Cell[15909, 611, 260, 9, 36, "Output",
 CellID->21016]
}, Open  ]],
Cell[16184, 623, 454, 15, 70, "MathCaption",
 CellID->26615],
Cell[CellGroupData[{
Cell[16663, 642, 125, 4, 70, "Input",
 CellID->28804],
Cell[16791, 648, 218, 7, 36, "Output",
 CellID->21006]
}, Open  ]],
Cell[CellGroupData[{
Cell[17046, 660, 72, 1, 70, "RelatedTutorialsSection",
 CellID->355767686],
Cell[17121, 663, 175, 4, 70, "RelatedTutorials",
 CellID->91103315]
}, Open  ]]
}, Open  ]],
Cell[17323, 671, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

