(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39501,       1469]
NotebookOptionsPosition[     31484,       1209]
NotebookOutlinePosition[     34702,       1286]
CellTagsIndexPosition[     34609,       1280]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/PatternsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Patterns\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:ref/Attributes"], 
          "ClearAttributes" :> 
          Documentation`HelpLookup["paclet:ref/ClearAttributes"], "Flat" :> 
          Documentation`HelpLookup["paclet:ref/Flat"], "OneIdentity" :> 
          Documentation`HelpLookup["paclet:ref/OneIdentity"], "Orderless" :> 
          Documentation`HelpLookup["paclet:ref/Orderless"], "SetAttributes" :> 
          Documentation`HelpLookup["paclet:ref/SetAttributes"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"ClearAttributes\"\>", 3->"\<\"Flat\"\>", 
       4->"\<\"OneIdentity\"\>", 5->"\<\"Orderless\"\>", 
       6->"\<\"SetAttributes\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Flat and Orderless Functions", "Title",
 CellTags->{"S2.3.7", "7.1"},
 CellID->28368],

Cell[TextData[{
 "Although ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " matches patterns in a purely structural fashion, its notion of structural \
equivalence is quite sophisticated. In particular, it takes account of \
properties such as commutativity and associativity in functions like ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->31641],

Cell[TextData[{
 "This means, for example, that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " considers the expressions ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "+", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   StyleBox["y", "TI"], "+", 
   StyleBox["x", "TI"]}]], "InlineFormula"],
 " equivalent for the purposes of pattern matching. As a result, a pattern \
like ",
 Cell[BoxData[
  RowBox[{"g", "[", 
   RowBox[{
    RowBox[{"x_", "+", "y_"}], ",", "x_"}], "]"}]], "InlineFormula"],
 " can match not only ",
 Cell[BoxData[
  RowBox[{"g", "[", 
   RowBox[{
    RowBox[{"a", "+", "b"}], ",", "a"}], "]"}]], "InlineFormula"],
 ", but also ",
 Cell[BoxData[
  RowBox[{"g", "[", 
   RowBox[{
    RowBox[{"a", "+", "b"}], ",", "b"}], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->30335],

Cell["This expression has exactly the same form as the pattern. ", \
"MathCaption",
 CellID->698],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", 
   RowBox[{
    RowBox[{"a", "+", "b"}], ",", "a"}], "]"}], "/.", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"x_", "+", "y_"}], ",", "x_"}], "]"}], "->", 
   RowBox[{"p", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->1325],

Cell[BoxData[
 RowBox[{"p", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->28313]
}, Open  ]],

Cell[TextData[{
 "In this case, the expression has to be put in the form ",
 Cell[BoxData[
  RowBox[{"g", "[", 
   RowBox[{
    RowBox[{"b", "+", "a"}], ",", "b"}], "]"}]], "InlineFormula"],
 " in order to have the same structure as the pattern. "
}], "MathCaption",
 CellID->28023],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", 
   RowBox[{
    RowBox[{"a", "+", "b"}], ",", "b"}], "]"}], "/.", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"x_", "+", "y_"}], ",", "x_"}], "]"}], "->", 
   RowBox[{"p", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}]}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->22312],

Cell[BoxData[
 RowBox[{"p", "[", 
  RowBox[{"b", ",", "a"}], "]"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->24618]
}, Open  ]],

Cell[TextData[{
 "Whenever ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " encounters an ",
 StyleBox["orderless",
  FontSlant->"Italic"],
 " or ",
 StyleBox["commutative",
  FontSlant->"Italic"],
 " function such as ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 " in a pattern, it effectively tests all the possible orders of arguments to \
try and find a match. Sometimes, there may be several orderings that lead to \
matches. In such cases, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " just uses the first ordering it finds. For example, ",
 Cell[BoxData[
  RowBox[{"h", "[", 
   RowBox[{
    RowBox[{"x_", "+", "y_"}], ",", 
    RowBox[{"x_", "+", "z_"}]}], "]"}]], "InlineFormula"],
 " could match ",
 Cell[BoxData[
  RowBox[{"h", "[", 
   RowBox[{
    RowBox[{"a", "+", "b"}], ",", 
    RowBox[{"a", "+", "b"}]}], "]"}]], "InlineFormula"],
 " with ",
 Cell[BoxData["x"], "InlineFormula"],
 Cell[BoxData[
  FormBox["\[RightArrow]", TraditionalForm]], "InlineMath"],
 Cell[BoxData["a"], "InlineFormula"],
 ", ",
 Cell[BoxData["y"], "InlineFormula"],
 Cell[BoxData[
  FormBox["\[RightArrow]", TraditionalForm]], "InlineMath"],
 Cell[BoxData["b"], "InlineFormula"],
 ", ",
 Cell[BoxData["z"], "InlineFormula"],
 Cell[BoxData[
  FormBox["\[RightArrow]", TraditionalForm]], "InlineMath"],
 Cell[BoxData["b"], "InlineFormula"],
 " or with ",
 Cell[BoxData["x"], "InlineFormula"],
 Cell[BoxData[
  FormBox["\[RightArrow]", TraditionalForm]], "InlineMath"],
 Cell[BoxData["b"], "InlineFormula"],
 ", ",
 Cell[BoxData["y"], "InlineFormula"],
 Cell[BoxData[
  FormBox["\[RightArrow]", TraditionalForm]], "InlineMath"],
 Cell[BoxData["a"], "InlineFormula"],
 ", ",
 Cell[BoxData["z"], "InlineFormula"],
 Cell[BoxData[
  FormBox["\[RightArrow]", TraditionalForm]], "InlineMath"],
 Cell[BoxData["a"], "InlineFormula"],
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " tries the case ",
 Cell[BoxData["x"], "InlineFormula"],
 Cell[BoxData[
  FormBox["\[RightArrow]", TraditionalForm]], "InlineMath"],
 Cell[BoxData["a"], "InlineFormula"],
 ", ",
 Cell[BoxData["y"], "InlineFormula"],
 Cell[BoxData[
  FormBox["\[RightArrow]", TraditionalForm]], "InlineMath"],
 Cell[BoxData["b"], "InlineFormula"],
 ", ",
 Cell[BoxData["z"], "InlineFormula"],
 Cell[BoxData[
  FormBox["\[RightArrow]", TraditionalForm]], "InlineMath"],
 Cell[BoxData["b"], "InlineFormula"],
 " first, and so uses this match."
}], "Text",
 CellID->18457],

Cell[TextData[{
 "This can match either with ",
 Cell[BoxData["x"], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[RightArrow]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData["a"], "InlineFormula"],
 " or with ",
 Cell[BoxData["x"], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[RightArrow]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData["b"], "InlineFormula"],
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " tries ",
 Cell[BoxData["x"], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[RightArrow]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData["a"], "InlineFormula"],
 " first, and so uses this match. "
}], "MathCaption",
 CellID->18396],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", 
   RowBox[{
    RowBox[{"a", "+", "b"}], ",", 
    RowBox[{"a", "+", "b"}]}], "]"}], "/.", 
  RowBox[{
   RowBox[{"h", "[", 
    RowBox[{
     RowBox[{"x_", "+", "y_"}], ",", 
     RowBox[{"x_", "+", "z_"}]}], "]"}], "->", 
   RowBox[{"p", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}]}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->8339],

Cell[BoxData[
 RowBox[{"p", "[", 
  RowBox[{"a", ",", "b", ",", "b"}], "]"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->21086]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReplaceList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceList"]], "InlineFormula"],
 " shows both possible matches. "
}], "MathCaption",
 CellID->32094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplaceList", "[", 
  RowBox[{
   RowBox[{"h", "[", 
    RowBox[{
     RowBox[{"a", "+", "b"}], ",", 
     RowBox[{"a", "+", "b"}]}], "]"}], ",", 
   RowBox[{
    RowBox[{"h", "[", 
     RowBox[{
      RowBox[{"x_", "+", "y_"}], ",", 
      RowBox[{"x_", "+", "z_"}]}], "]"}], "->", 
    RowBox[{"p", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->7846],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"p", "[", 
    RowBox[{"a", ",", "b", ",", "b"}], "]"}], ",", 
   RowBox[{"p", "[", 
    RowBox[{"b", ",", "a", ",", "a"}], "]"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->27043]
}, Open  ]],

Cell[TextData[{
 "As discussed in \"",
 ButtonBox["Attributes\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/Attributes"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to assign certain attributes to functions, which specify how \
those functions should be treated in evaluation and pattern matching. \
Functions can for example be assigned the attribute ",
 Cell[BoxData[
  ButtonBox["Orderless",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orderless"]], "InlineFormula"],
 ", which specifies that they should be treated as commutative or symmetric, \
and allows their arguments to be rearranged in trying to match patterns. "
}], "Text",
 CellID->31522],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Orderless",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Orderless"], Cell[TextData[{
     "commutative function: ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["b", "TI"], ",", 
       StyleBox["c", "TI"], ",", 
       StyleBox["a", "TI"], "]"}]], "InlineFormula"],
     ", etc., are equivalent to ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["a", "TI"], ",", 
       StyleBox["b", "TI"], ",", 
       StyleBox["c", "TI"], "]"}]], "InlineFormula"]
    }], "TableText"]},
   {
    ButtonBox["Flat",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Flat"], Cell[TextData[{
     "associative function: ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["f", "TI"], "[", 
       StyleBox["a", "TI"], "]", ",", 
       StyleBox["b", "TI"], "]"}]], "InlineFormula"],
     ", etc., are equivalent to ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["a", "TI"], ",", 
       StyleBox["b", "TI"], "]"}]], "InlineFormula"]
    }], "TableText"]},
   {
    ButtonBox["OneIdentity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/OneIdentity"], Cell[TextData[{
     StyleBox["f", "TI"],
     "[",
     StyleBox["f", "TI"],
     "[",
     StyleBox["a", "TI"],
     "]",
     "]",
     ", etc., are equivalent to ",
     StyleBox["a", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Attributes",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Attributes"], "[", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "give the attributes assigned to ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SetAttributes",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SetAttributes"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["attr", "TI"], "]"}], Cell[TextData[{
     "add ",
     Cell[BoxData[
      StyleBox["attr", "TI"]], "InlineFormula"],
     " to the attributes of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ClearAttributes",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ClearAttributes"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["attr", "TI"], "]"}], Cell[TextData[{
     "remove ",
     Cell[BoxData[
      StyleBox["attr", "TI"]], "InlineFormula"],
     " from the attributes of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, True, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->12911],

Cell["Some attributes that can be assigned to functions. ", "Caption",
 CellID->16280],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " has attributes ",
 Cell[BoxData[
  ButtonBox["Orderless",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orderless"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 ", as well as others. "
}], "MathCaption",
 CellID->23455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Plus", "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->26358],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Flat", ",", "Listable", ",", "NumericFunction", ",", "OneIdentity", ",", 
   "Orderless", ",", "Protected"}], "}"}]], "Output",
 ImageSize->{466, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->26847]
}, Open  ]],

Cell[TextData[{
 "This defines ",
 Cell[BoxData["q"], "InlineFormula"],
 " to be an orderless or commutative function. "
}], "MathCaption",
 CellID->28870],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"q", ",", "Orderless"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->990],

Cell[TextData[{
 "The arguments of ",
 Cell[BoxData["q"], "InlineFormula"],
 " are automatically sorted into order. "
}], "MathCaption",
 CellID->3873],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"q", "[", 
  RowBox[{"b", ",", "a", ",", "c"}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->4327],

Cell[BoxData[
 RowBox[{"q", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->3413]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " rearranges the arguments of ",
 Cell[BoxData["q"], "InlineFormula"],
 " functions to find a match. "
}], "MathCaption",
 CellID->3454],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"q", "[", 
     RowBox[{"a", ",", "b"}], "]"}], ",", 
    RowBox[{"q", "[", 
     RowBox[{"b", ",", "c"}], "]"}]}], "]"}], "/.", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"q", "[", 
      RowBox[{"x_", ",", "y_"}], "]"}], ",", 
     RowBox[{"q", "[", 
      RowBox[{"x_", ",", "z_"}], "]"}]}], "]"}], "->", 
   RowBox[{"p", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}]}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->31896],

Cell[BoxData[
 RowBox[{"p", "[", 
  RowBox[{"b", ",", "a", ",", "c"}], "]"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->12472]
}, Open  ]],

Cell[TextData[{
 "In addition to being orderless, functions like ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 " also have the property of being ",
 StyleBox["flat",
  FontSlant->"Italic"],
 " or ",
 StyleBox["associative",
  FontSlant->"Italic"],
 ". This means that you can effectively \[OpenCurlyDoubleQuote]parenthesize\
\[CloseCurlyDoubleQuote] their arguments in any way, so that, for example, ",
 Cell[BoxData[
  RowBox[{"x", "+", 
   RowBox[{"(", 
    RowBox[{"y", "+", "z"}], ")"}]}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"x", "+", "y", "+", "z"}]], "InlineFormula"],
 ", and so on."
}], "Text",
 CellID->24450],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " takes account of flatness in matching patterns. As a result, a pattern \
like ",
 Cell[BoxData[
  RowBox[{"g", "[", 
   RowBox[{"x_", "+", "y_"}], "]"}]], "InlineFormula"],
 " can match ",
 Cell[BoxData[
  RowBox[{"g", "[", 
   RowBox[{"a", "+", "b", "+", "c"}], "]"}]], "InlineFormula"],
 ", with ",
 Cell[BoxData["x"], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[RightArrow]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData["a"], "InlineFormula"],
 " and ",
 Cell[BoxData["y"], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[RightArrow]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{"b", "+", "c"}], ")"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->17241],

Cell[TextData[{
 "The argument of ",
 Cell[BoxData["g"], "InlineFormula"],
 " is written as ",
 Cell[BoxData[
  RowBox[{"a", "+", 
   RowBox[{"(", 
    RowBox[{"b", "+", "c"}], ")"}]}]], "InlineFormula"],
 " so as to match the pattern. "
}], "MathCaption",
 CellID->4641],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", 
   RowBox[{"a", "+", "b", "+", "c"}], "]"}], "/.", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"x_", "+", "y_"}], "]"}], "->", 
   RowBox[{"p", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}]}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->5646],

Cell[BoxData[
 RowBox[{"p", "[", 
  RowBox[{"a", ",", 
   RowBox[{"b", "+", "c"}]}], "]"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->23525]
}, Open  ]],

Cell[TextData[{
 "If there are no other constraints, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will match ",
 Cell[BoxData["x_"], "InlineFormula"],
 " to the first element of the sum. "
}], "MathCaption",
 CellID->28213],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", 
   RowBox[{"a", "+", "b", "+", "c", "+", "d"}], "]"}], "/.", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"x_", "+", "y_"}], "]"}], "->", 
   RowBox[{"p", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}]}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->16824],

Cell[BoxData[
 RowBox[{"p", "[", 
  RowBox[{"a", ",", 
   RowBox[{"b", "+", "c", "+", "d"}]}], "]"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->17929]
}, Open  ]],

Cell["This shows all the possible matches. ", "MathCaption",
 CellID->8695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplaceList", "[", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"a", "+", "b", "+", "c"}], "]"}], ",", 
   RowBox[{
    RowBox[{"g", "[", 
     RowBox[{"x_", "+", "y_"}], "]"}], "->", 
    RowBox[{"p", "[", 
     RowBox[{"x", ",", "y"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->25403],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"p", "[", 
    RowBox[{"a", ",", 
     RowBox[{"b", "+", "c"}]}], "]"}], ",", 
   RowBox[{"p", "[", 
    RowBox[{"b", ",", 
     RowBox[{"a", "+", "c"}]}], "]"}], ",", 
   RowBox[{"p", "[", 
    RowBox[{"c", ",", 
     RowBox[{"a", "+", "b"}]}], "]"}], ",", 
   RowBox[{"p", "[", 
    RowBox[{
     RowBox[{"a", "+", "b"}], ",", "c"}], "]"}], ",", 
   RowBox[{"p", "[", 
    RowBox[{
     RowBox[{"a", "+", "c"}], ",", "b"}], "]"}], ",", 
   RowBox[{"p", "[", 
    RowBox[{
     RowBox[{"b", "+", "c"}], ",", "a"}], "]"}]}], "}"}]], "Output",
 ImageSize->{469, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->12594]
}, Open  ]],

Cell[TextData[{
 "Here ",
 Cell[BoxData["x_"], "InlineFormula"],
 " is forced to match ",
 Cell[BoxData[
  RowBox[{"b", "+", "d"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->7993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", 
   RowBox[{
    RowBox[{"a", "+", "b", "+", "c", "+", "d"}], ",", 
    RowBox[{"b", "+", "d"}]}], "]"}], "/.", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"x_", "+", "y_"}], ",", "x_"}], "]"}], "->", 
   RowBox[{"p", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}]}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->26067],

Cell[BoxData[
 RowBox[{"p", "[", 
  RowBox[{
   RowBox[{"b", "+", "d"}], ",", 
   RowBox[{"a", "+", "c"}]}], "]"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->22187]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can usually apply a transformation rule to a function only if the pattern \
in the rule covers all the arguments in the function. However, if you have a \
flat function, it is sometimes possible to apply transformation rules even \
though not all the arguments are covered. "
}], "Text",
 CellID->4640],

Cell["\<\
This rule applies even though it does not cover all the terms in the sum. \
\>", "MathCaption",
 CellID->25079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "+", "b", "+", "c"}], "/.", 
  RowBox[{
   RowBox[{"a", "+", "c"}], "->", "p"}]}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->10041],

Cell[BoxData[
 RowBox[{"b", "+", "p"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->18125]
}, Open  ]],

Cell["This combines two of the terms in the sum. ", "MathCaption",
 CellID->12534],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", "a", "]"}], "+", 
   RowBox[{"u", "[", "b", "]"}], "+", 
   RowBox[{"v", "[", "c", "]"}], "+", 
   RowBox[{"v", "[", "d", "]"}]}], "/.", 
  RowBox[{
   RowBox[{
    RowBox[{"u", "[", "x_", "]"}], "+", 
    RowBox[{"u", "[", "y_", "]"}]}], "->", 
   RowBox[{"u", "[", 
    RowBox[{"x", "+", "y"}], "]"}]}]}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->4860],

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "[", 
   RowBox[{"a", "+", "b"}], "]"}], "+", 
  RowBox[{"v", "[", "c", "]"}], "+", 
  RowBox[{"v", "[", "d", "]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->23000]
}, Open  ]],

Cell[TextData[{
 "Functions like ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 " are both flat and orderless. There are, however, some functions, such as \
",
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 ", which are flat, but not orderless. "
}], "Text",
 CellID->4907],

Cell[TextData[{
 "Both ",
 Cell[BoxData["x_"], "InlineFormula"],
 " and ",
 Cell[BoxData["y_"], "InlineFormula"],
 " can match any sequence of terms in the dot product. "
}], "MathCaption",
 CellID->32621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"a", ".", "b", ".", "c", ".", "d", ".", "a", ".", "b"}], "/.", 
  RowBox[{
   RowBox[{"x_", ".", "y_", ".", "x_"}], "->", 
   RowBox[{"p", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}]}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->27692],

Cell[BoxData[
 RowBox[{"p", "[", 
  RowBox[{
   RowBox[{"a", ".", "b"}], ",", 
   RowBox[{"c", ".", "d"}]}], "]"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->25293]
}, Open  ]],

Cell[TextData[{
 "This assigns the attribute ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 " to the function ",
 Cell[BoxData["r"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->5117],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"r", ",", "Flat"}], "]"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->7717],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " writes the expression in the form ",
 Cell[BoxData[
  RowBox[{"r", "[", 
   RowBox[{
    RowBox[{"r", "[", 
     RowBox[{"a", ",", "b"}], "]"}], ",", 
    RowBox[{"r", "[", 
     RowBox[{"a", ",", "b"}], "]"}]}], "]"}]], "InlineFormula"],
 " to match the pattern. "
}], "MathCaption",
 CellID->20403],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "[", 
   RowBox[{"a", ",", "b", ",", "a", ",", "b"}], "]"}], "/.", 
  RowBox[{
   RowBox[{"r", "[", 
    RowBox[{"x_", ",", "x_"}], "]"}], "->", 
   RowBox[{"rp", "[", "x", "]"}]}]}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->3943],

Cell[BoxData[
 RowBox[{"rp", "[", 
  RowBox[{"r", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "]"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]= ",
 CellID->17893]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " writes this expression in the form ",
 Cell[BoxData[
  RowBox[{"r", "[", 
   RowBox[{"a", ",", 
    RowBox[{"r", "[", 
     RowBox[{
      RowBox[{"r", "[", "b", "]"}], ",", 
      RowBox[{"r", "[", "b", "]"}]}], "]"}], ",", "c"}], "]"}]], 
  "InlineFormula"],
 " to match the pattern. "
}], "MathCaption",
 CellID->10639],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "[", 
   RowBox[{"a", ",", "b", ",", "b", ",", "c"}], "]"}], "/.", 
  RowBox[{
   RowBox[{"r", "[", 
    RowBox[{"x_", ",", "x_"}], "]"}], "->", 
   RowBox[{"rp", "[", "x", "]"}]}]}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->29011],

Cell[BoxData[
 RowBox[{"r", "[", 
  RowBox[{"a", ",", 
   RowBox[{"rp", "[", 
    RowBox[{"r", "[", "b", "]"}], "]"}], ",", "c"}], "]"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]= ",
 CellID->26925]
}, Open  ]],

Cell[TextData[{
 "In an ordinary function that is not flat, a pattern such as ",
 Cell[BoxData["x_"], "InlineFormula"],
 " matches an individual argument of the function. But in a function ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"], ",", 
    StyleBox["c", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " that is flat, ",
 Cell[BoxData["x_"], "InlineFormula"],
 " can match objects such as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    StyleBox["b", "TI"], ",", 
    StyleBox["c", "TI"]}], "]"}]], "InlineFormula"],
 " which effectively correspond to a sequence of arguments. However, in the \
case where ",
 Cell[BoxData["x_"], "InlineFormula"],
 " matches a single argument in a flat function, the question comes up as to \
whether the object it matches is really just the argument ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " itself, or ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   StyleBox["a", "TI"], "]"}]], "InlineFormula"],
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " chooses the first of these cases if the function carries the attribute ",
 Cell[BoxData[
  ButtonBox["OneIdentity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OneIdentity"]], "InlineFormula"],
 ", and chooses the second case otherwise. "
}], "Text",
 CellID->24028],

Cell[TextData[{
 "This adds the attribute ",
 Cell[BoxData[
  ButtonBox["OneIdentity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OneIdentity"]], "InlineFormula"],
 " to the function ",
 Cell[BoxData["r"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->19978],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"r", ",", "OneIdentity"}], "]"}]], "Input",
 CellLabel->"In[19]:= ",
 CellID->10748],

Cell[TextData[{
 "Now ",
 Cell[BoxData["x_"], "InlineFormula"],
 " matches individual arguments, without ",
 Cell[BoxData["r"], "InlineFormula"],
 " wrapped around them. "
}], "MathCaption",
 CellID->2850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "[", 
   RowBox[{"a", ",", "b", ",", "b", ",", "c"}], "]"}], "/.", 
  RowBox[{
   RowBox[{"r", "[", 
    RowBox[{"x_", ",", "x_"}], "]"}], "->", 
   RowBox[{"rp", "[", "x", "]"}]}]}]], "Input",
 CellLabel->"In[20]:= ",
 CellID->22892],

Cell[BoxData[
 RowBox[{"r", "[", 
  RowBox[{"a", ",", 
   RowBox[{"rp", "[", "b", "]"}], ",", "c"}], "]"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]= ",
 CellID->26444]
}, Open  ]],

Cell[TextData[{
 "The functions ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 " all have the attribute ",
 Cell[BoxData[
  ButtonBox["OneIdentity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OneIdentity"]], "InlineFormula"],
 ", reflecting the fact that ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Plus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plus"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", and so on. However, in representing mathematical objects, it is often \
convenient to deal with flat functions that do not have the attribute ",
 Cell[BoxData[
  ButtonBox["OneIdentity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OneIdentity"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->10654],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->507249229],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsOverview"]], "RelatedTutorials",
 CellID->423797385]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Flat and Orderless Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Patterns", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/PatternsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/PatternSequences"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/FunctionsWithVariableNumbersOfArguments"]}], "Text",
       FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 36.7211282}", "context" -> "", 
    "keywords" -> {
     "addition", "associative functions", "attributes", "ClearAttributes", 
      "commutative functions", "Dot", "flat", "flat functions", "idempotence",
       "matches", "multiple arguments", "multiplication", "OneIdentity", 
      "orderless", "orderless functions", "patterns", "plus", "products", 
      "ReplaceList", "SetAttributes", "sums", "symmetric functions", "times"},
     "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Although Mathematica matches patterns in a purely structural fashion, \
its notion of structural equivalence is quite sophisticated. In particular, \
it takes account of properties such as commutativity and associativity in \
functions like Plus and Times. This means, for example, that Mathematica \
considers the expressions x+y and y+x equivalent for the purposes of pattern \
matching. As a result, a pattern like g[x_+y_,x_] can match not only \
g[a+b,a], but also g[a+b,b]. This expression has exactly the same form as the \
pattern. ", "synonyms" -> {"2.3.7"}, "title" -> 
    "Flat and Orderless Functions", "type" -> "Tutorial", "uri" -> 
    "tutorial/FlatAndOrderlessFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.3.7"->{
  Cell[2324, 66, 91, 2, 70, "Title",
   CellTags->{"S2.3.7", "7.1"},
   CellID->28368]},
 "7.1"->{
  Cell[2324, 66, 91, 2, 70, "Title",
   CellTags->{"S2.3.7", "7.1"},
   CellID->28368]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.3.7", 34398, 1269},
 {"7.1", 34497, 1273}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1699, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2324, 66, 91, 2, 70, "Title",
 CellTags->{"S2.3.7", "7.1"},
 CellID->28368],
Cell[2418, 70, 570, 18, 70, "Text",
 CellID->31641],
Cell[2991, 90, 851, 32, 70, "Text",
 CellID->30335],
Cell[3845, 124, 97, 2, 70, "MathCaption",
 CellID->698],
Cell[CellGroupData[{
Cell[3967, 130, 327, 12, 28, "Input",
 CellID->1325],
Cell[4297, 144, 205, 7, 36, "Output",
 CellID->28313]
}, Open  ]],
Cell[4517, 154, 282, 8, 70, "MathCaption",
 CellID->28023],
Cell[CellGroupData[{
Cell[4824, 166, 328, 12, 28, "Input",
 CellID->22312],
Cell[5155, 180, 205, 7, 36, "Output",
 CellID->24618]
}, Open  ]],
Cell[5375, 190, 2629, 87, 70, "Text",
 CellID->18457],
Cell[8007, 279, 692, 27, 70, "MathCaption",
 CellID->18396],
Cell[CellGroupData[{
Cell[8724, 310, 389, 14, 70, "Input",
 CellID->8339],
Cell[9116, 326, 215, 7, 36, "Output",
 CellID->21086]
}, Open  ]],
Cell[9346, 336, 209, 7, 70, "MathCaption",
 CellID->32094],
Cell[CellGroupData[{
Cell[9580, 347, 437, 15, 70, "Input",
 CellID->7846],
Cell[10020, 364, 329, 11, 36, "Output",
 CellID->27043]
}, Open  ]],
Cell[10364, 378, 694, 18, 70, "Text",
 CellID->31522],
Cell[11061, 398, 2954, 99, 70, "DefinitionBox",
 CellID->12911],
Cell[14018, 499, 86, 1, 70, "Caption",
 CellID->16280],
Cell[14107, 502, 449, 17, 70, "MathCaption",
 CellID->23455],
Cell[CellGroupData[{
Cell[14581, 523, 106, 3, 70, "Input",
 CellID->26358],
Cell[14690, 528, 298, 9, 36, "Output",
 CellID->26847]
}, Open  ]],
Cell[15003, 540, 155, 5, 70, "MathCaption",
 CellID->28870],
Cell[15161, 547, 135, 4, 70, "Input",
 CellID->990],
Cell[15299, 553, 151, 5, 70, "MathCaption",
 CellID->3873],
Cell[CellGroupData[{
Cell[15475, 562, 126, 4, 70, "Input",
 CellID->4327],
Cell[15604, 568, 214, 7, 36, "Output",
 CellID->3413]
}, Open  ]],
Cell[15833, 578, 202, 7, 70, "MathCaption",
 CellID->3454],
Cell[CellGroupData[{
Cell[16060, 589, 516, 18, 70, "Input",
 CellID->31896],
Cell[16579, 609, 215, 7, 36, "Output",
 CellID->12472]
}, Open  ]],
Cell[16809, 619, 842, 28, 70, "Text",
 CellID->24450],
Cell[17654, 649, 787, 30, 70, "Text",
 CellID->17241],
Cell[18444, 681, 271, 10, 70, "MathCaption",
 CellID->4641],
Cell[CellGroupData[{
Cell[18740, 695, 285, 10, 70, "Input",
 CellID->5646],
Cell[19028, 707, 229, 8, 36, "Output",
 CellID->23525]
}, Open  ]],
Cell[19272, 718, 233, 8, 70, "MathCaption",
 CellID->28213],
Cell[CellGroupData[{
Cell[19530, 730, 297, 10, 70, "Input",
 CellID->16824],
Cell[19830, 742, 240, 8, 36, "Output",
 CellID->17929]
}, Open  ]],
Cell[20085, 753, 75, 1, 70, "MathCaption",
 CellID->8695],
Cell[CellGroupData[{
Cell[20185, 758, 331, 11, 70, "Input",
 CellID->25403],
Cell[20519, 771, 722, 25, 36, "Output",
 CellID->12594]
}, Open  ]],
Cell[21256, 799, 190, 8, 70, "MathCaption",
 CellID->7993],
Cell[CellGroupData[{
Cell[21471, 811, 374, 13, 70, "Input",
 CellID->26067],
Cell[21848, 826, 254, 9, 36, "Output",
 CellID->22187]
}, Open  ]],
Cell[22117, 838, 370, 8, 70, "Text",
 CellID->4640],
Cell[22490, 848, 121, 3, 70, "MathCaption",
 CellID->25079],
Cell[CellGroupData[{
Cell[22636, 855, 172, 6, 70, "Input",
 CellID->10041],
Cell[22811, 863, 178, 6, 36, "Output",
 CellID->18125]
}, Open  ]],
Cell[23004, 872, 82, 1, 70, "MathCaption",
 CellID->12534],
Cell[CellGroupData[{
Cell[23111, 877, 413, 14, 70, "Input",
 CellID->4860],
Cell[23527, 893, 297, 10, 36, "Output",
 CellID->23000]
}, Open  ]],
Cell[23839, 906, 527, 19, 70, "Text",
 CellID->4907],
Cell[24369, 927, 205, 7, 70, "MathCaption",
 CellID->32621],
Cell[CellGroupData[{
Cell[24599, 938, 269, 8, 70, "Input",
 CellID->27692],
Cell[24871, 948, 254, 9, 36, "Output",
 CellID->25293]
}, Open  ]],
Cell[25140, 960, 258, 10, 70, "MathCaption",
 CellID->5117],
Cell[25401, 972, 132, 4, 70, "Input",
 CellID->7717],
Cell[25536, 978, 368, 13, 70, "MathCaption",
 CellID->20403],
Cell[CellGroupData[{
Cell[25929, 995, 272, 9, 70, "Input",
 CellID->3943],
Cell[26204, 1006, 236, 8, 36, "Output",
 CellID->17893]
}, Open  ]],
Cell[26455, 1017, 390, 14, 70, "MathCaption",
 CellID->10639],
Cell[CellGroupData[{
Cell[26870, 1035, 273, 9, 70, "Input",
 CellID->29011],
Cell[27146, 1046, 277, 9, 36, "Output",
 CellID->26925]
}, Open  ]],
Cell[27438, 1058, 1440, 43, 70, "Text",
 CellID->24028],
Cell[28881, 1103, 270, 10, 70, "MathCaption",
 CellID->19978],
Cell[29154, 1115, 140, 4, 70, "Input",
 CellID->10748],
Cell[29297, 1121, 205, 7, 70, "MathCaption",
 CellID->2850],
Cell[CellGroupData[{
Cell[29527, 1132, 273, 9, 70, "Input",
 CellID->22892],
Cell[29803, 1143, 246, 8, 36, "Output",
 CellID->26444]
}, Open  ]],
Cell[30064, 1154, 1120, 39, 70, "Text",
 CellID->10654],
Cell[CellGroupData[{
Cell[31209, 1197, 72, 1, 70, "RelatedTutorialsSection",
 CellID->507249229],
Cell[31284, 1200, 146, 3, 70, "RelatedTutorials",
 CellID->423797385]
}, Open  ]]
}, Open  ]],
Cell[31457, 1207, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

