(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     48101,       1199]
NotebookOptionsPosition[     42409,       1023]
NotebookOutlinePosition[     45347,       1096]
CellTagsIndexPosition[     45251,       1090]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Structure of Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"The Structure of Graphics and Sound\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BaseStyle" :> Documentation`HelpLookup["paclet:ref/BaseStyle"],
           "FontFamily" :> Documentation`HelpLookup["paclet:ref/FontFamily"], 
          "FontSize" :> Documentation`HelpLookup["paclet:ref/FontSize"], 
          "FontSlant" :> Documentation`HelpLookup["paclet:ref/FontSlant"], 
          "FontWeight" :> Documentation`HelpLookup["paclet:ref/FontWeight"], 
          "FormatType" :> Documentation`HelpLookup["paclet:ref/FormatType"], 
          "StandardForm" :> 
          Documentation`HelpLookup["paclet:ref/StandardForm"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"BaseStyle\"\>", 2->"\<\"FontFamily\"\>", 
       3->"\<\"FontSize\"\>", 4->"\<\"FontSlant\"\>", 5->"\<\"FontWeight\"\>",
        6->"\<\"FormatType\"\>", 7->"\<\"StandardForm\"\>", 
       8->"\<\"Style\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Formats for Text in Graphics", "Title",
 CellTags->{"S2.10.15", "15.1"},
 CellID->24353],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["BaseStyle",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BaseStyle"], "->", 
     StyleBox["value", "TI"]}], Cell[
    "an option for the text style in a graphic", "TableText"]},
   {
    RowBox[{
     ButtonBox["FormatType",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FormatType"], "->", 
     StyleBox["value", "TI"]}], Cell[
    "an option for the text format type in a graphic", "TableText"]}
  }]], "DefinitionBox",
 CellID->12036],

Cell["Specifying formats for text in graphics. ", "Caption",
 CellID->31547],

Cell["Here is a plot with default settings for all formats. ", "MathCaption",
 CellID->21346],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", " ", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotLabel", "->", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->826],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->264554809]
}, Open  ]],

Cell["\<\
Here is the same plot, but now using a 12\[Hyphen]point bold font. \
\>", "MathCaption",
 CellID->3904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", " ", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotLabel", "->", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "^", "2"}]}], ",", 
   RowBox[{"BaseStyle", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"FontWeight", "->", "\"\<Bold\>\""}], ",", 
      RowBox[{"FontSize", "\[Rule]", "12"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->10238],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->550904980]
}, Open  ]],

Cell[TextData[{
 "This uses ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " rather than ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " . "
}], "MathCaption",
 CellID->26886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", " ", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotLabel", "->", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "^", "2"}]}], ",", 
   RowBox[{"FormatType", "->", "StandardForm"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->16405],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->118656549]
}, Open  ]],

Cell[TextData[{
 "This tells ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " what default text style to use for all subsequent plots. "
}], "MathCaption",
 CellID->22056],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"Plot", ",", 
    RowBox[{"BaseStyle", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontFamily", "->", "\"\<Times\>\""}], ",", 
       RowBox[{"FontSize", "\[Rule]", "14"}]}], "}"}]}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->11728],

Cell["\<\
Now all the text is in 14\[Hyphen]point Times font. \
\>", "MathCaption",
 CellID->3751],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", " ", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotLabel", "->", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->2019],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->428779756]
}, Open  ]],

Cell[BoxData[GridBox[{
   {"\"\<\!\(\*
StyleBox[\"style\", \"TI\"]\)\>\"", Cell[
    "a named style in your current stylesheet", "TableText"]},
   {
    RowBox[{
     ButtonBox["FontSize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FontSize"], "->", 
     StyleBox["n", "TI"]}], Cell["\<\
the size of font to use in printer\[CloseCurlyQuote]s points\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["FontSlant",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FontSlant"], "->", "\"\<Italic\>\""}], Cell[
    "use an italic font", "TableText"]},
   {
    RowBox[{
     ButtonBox["FontWeight",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FontWeight"], "->", "\"\<Bold\>\""}], Cell[
    "use a bold font", "TableText"]},
   {
    RowBox[{
     ButtonBox["FontFamily",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FontFamily"], "->", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\""}], Cell[TextData[{
     "specify the name of the font family to use (e.g. ",
     Cell[BoxData["\"\<Times\>\""], "InlineFormula"],
     ", ",
     Cell[BoxData["\"\<Courier\>\""], "InlineFormula"],
     ", ",
     Cell[BoxData["\"\<Helvetica\>\""], "InlineFormula"],
     ")"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->18166],

Cell[TextData[{
 "Typical elements used in the setting for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 ". "
}], "Caption",
 CellID->5717],

Cell[TextData[{
 "If you use the standard notebook front end for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", then you can set ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " to be the name of a style defined in your current notebook's stylesheet. \
You can also explicitly specify how text should be formatted by using options \
such as ",
 Cell[BoxData[
  ButtonBox["FontSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontSize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FontFamily",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontFamily"]], "InlineFormula"],
 ". Note that ",
 Cell[BoxData[
  ButtonBox["FontSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontSize"]], "InlineFormula"],
 " gives the absolute size of the font to use, measured in units of printer\
\[CloseCurlyQuote]s points, with one point being ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", "72"], TraditionalForm]], "InlineMath"],
 " inches. If you resize a plot whose font size is specified as a number, the \
text in it will not by default change size: to get text of a different size \
you must explicitly specify a new value for the ",
 Cell[BoxData[
  ButtonBox["FontSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontSize"]], "InlineFormula"],
 "\[NonBreakingSpace]option. If you resize a plot whose font size is \
specified as a scaled quantity, the font will scale as the plot is resized.",
 " ",
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FontSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FontSize"], "->", 
   RowBox[{
    ButtonBox["Scaled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Scaled"], "[", 
    StyleBox["s", "TI"], "]"}]}]], "InlineFormula"],
 ", the effective font size will be ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " scaled units in the plot."
}], "Text",
 CellID->25846],

Cell["Now all the text resizes as the plot is resized. ", "MathCaption",
 CellID->682615608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", " ", "Pi"}]}], "}"}], ",", 
   RowBox[{"BaseStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"FontSize", "\[Rule]", 
      RowBox[{"Scaled", "[", ".05", "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->1443718255],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->414398823]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Style",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Style"], "[", 
     StyleBox["expr", "TI"], ",", "\"\<\!\(\*
StyleBox[\"style\", \"TI\"]\)\>\"", "]"}], Cell[TextData[{
     "output ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " in the specified style"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Style",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Style"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["options", "TI"], "]"}], Cell[TextData[{
     "output ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " using the specified font and style options"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StandardForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StandardForm"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "output ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      ButtonBox["StandardForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->3187],

Cell["Changing the formats of individual pieces of output. ", "Caption",
 CellID->1421],

Cell["\<\
This outputs the plot label using the section heading style in your current \
notebook. \
\>", "MathCaption",
 CellID->22912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", " ", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotLabel", "->", 
    RowBox[{"Style", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], ",", "\"\<Section\>\""}], 
     "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->6867],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->110789316]
}, Open  ]],

Cell["\<\
This uses the section heading style, but modified to be in italics. \
\>", "MathCaption",
 CellID->32444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", " ", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotLabel", "->", 
    RowBox[{"Style", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], ",", "\"\<Section\>\"", 
      ",", 
      RowBox[{"FontSlant", "->", "\"\<Italic\>\""}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->29897],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->267395570]
}, Open  ]],

Cell[TextData[{
 "This produces ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " output, with a 12\[Hyphen]point font. "
}], "MathCaption",
 CellID->3328],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", " ", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotLabel", "->", 
    RowBox[{"Style", "[", 
     RowBox[{
      RowBox[{"StandardForm", "[", 
       RowBox[{
        RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], "]"}], ",", 
      RowBox[{"FontSize", "->", "12"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->24942],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->479631199]
}, Open  ]],

Cell[TextData[{
 "You should realize that the ability to refer to styles such as ",
 Cell[BoxData["\"\<Section\>\""], "InlineFormula"],
 " depends on using the standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook front end. Even if you are just using a text\[Hyphen]based \
interface to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", however, you can still specify formatting of text in graphics using \
options such as ",
 Cell[BoxData[
  ButtonBox["FontSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontSize"]], "InlineFormula"],
 ". The complete collection of options that you can use is given in\
\[NonBreakingSpace]\"",
 ButtonBox["Text and Font Options\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TextAndFontOptions"],
 ". "
}], "Text",
 CellID->1768],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->419777204],

Cell[TextData[ButtonBox["The Structure of Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]], \
"RelatedTutorials",
 CellID->1229394717]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Formats for Text in Graphics - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["The Structure of Graphics and Sound", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/EfficientRepresentationOfManyPrimitives"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/GraphicsPrimitivesForText"]}],
       "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 37.7055284}", "context" -> "", 
    "keywords" -> {
     "bold fonts", "characters", "courier fonts", "faces", "FontFamily", 
      "fonts", "FontSize", "FontWeight", "FormatType", "graphics", 
      "Helvetica fonts", "italic fonts", "labels", "oblique fonts", 
      "PlotLabel", "plot label", "plots", "Roman fonts", "size", "StyleForm", 
      "styles", "text", "TextStyle", "times fonts", "typeface", 
      "typewriter font", "courier", "FormatType", "TextStyle"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Specifying formats for text in graphics. Here is a plot with default \
settings for all formats. Here is the same plot, but now using a 12-point \
bold font. ", "synonyms" -> {}, "title" -> "Formats for Text in Graphics", 
    "type" -> "Tutorial", "uri" -> "tutorial/FormatsForTextInGraphics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.10.15"->{
  Cell[2582, 69, 94, 2, 70, "Title",
   CellTags->{"S2.10.15", "15.1"},
   CellID->24353]},
 "15.1"->{
  Cell[2582, 69, 94, 2, 70, "Title",
   CellTags->{"S2.10.15", "15.1"},
   CellID->24353]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.10.15", 45033, 1079},
 {"15.1", 45136, 1083}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1957, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2582, 69, 94, 2, 70, "Title",
 CellTags->{"S2.10.15", "15.1"},
 CellID->24353],
Cell[2679, 73, 515, 16, 70, "DefinitionBox",
 CellID->12036],
Cell[3197, 91, 76, 1, 70, "Caption",
 CellID->31547],
Cell[3276, 94, 93, 1, 70, "MathCaption",
 CellID->21346],
Cell[CellGroupData[{
Cell[3394, 99, 360, 12, 28, "Input",
 CellID->826],
Cell[3757, 113, 3417, 60, 159, "Output",
 Evaluatable->False,
 CellID->264554809]
}, Open  ]],
Cell[7189, 176, 113, 3, 70, "MathCaption",
 CellID->3904],
Cell[CellGroupData[{
Cell[7327, 183, 545, 17, 47, "Input",
 CellID->10238],
Cell[7875, 202, 3433, 60, 160, "Output",
 Evaluatable->False,
 CellID->550904980]
}, Open  ]],
Cell[11323, 265, 350, 13, 70, "MathCaption",
 CellID->26886],
Cell[CellGroupData[{
Cell[11698, 282, 417, 13, 28, "Input",
 CellID->16405],
Cell[12118, 297, 3303, 58, 154, "Output",
 Evaluatable->False,
 CellID->118656549]
}, Open  ]],
Cell[15436, 358, 177, 6, 70, "MathCaption",
 CellID->22056],
Cell[15616, 366, 329, 11, 70, "Input",
 CellID->11728],
Cell[15948, 379, 98, 3, 70, "MathCaption",
 CellID->3751],
Cell[CellGroupData[{
Cell[16071, 386, 361, 12, 28, "Input",
 CellID->2019],
Cell[16435, 400, 3555, 62, 165, "Output",
 Evaluatable->False,
 CellID->428779756]
}, Open  ]],
Cell[20005, 465, 1572, 47, 70, "DefinitionBox",
 CellID->18166],
Cell[21580, 514, 218, 8, 70, "Caption",
 CellID->5717],
Cell[21801, 524, 1960, 57, 70, "Text",
 CellID->25846],
Cell[23764, 583, 92, 1, 70, "MathCaption",
 CellID->682615608],
Cell[CellGroupData[{
Cell[23881, 588, 418, 13, 28, "Input",
 CellID->1443718255],
Cell[24302, 603, 2698, 48, 160, "Output",
 Evaluatable->False,
 CellID->414398823]
}, Open  ]],
Cell[27015, 654, 1510, 48, 70, "DefinitionBox",
 CellID->3187],
Cell[28528, 704, 87, 1, 70, "Caption",
 CellID->1421],
Cell[28618, 707, 135, 4, 70, "MathCaption",
 CellID->22912],
Cell[CellGroupData[{
Cell[28778, 715, 446, 15, 28, "Input",
 CellID->6867],
Cell[29227, 732, 3532, 62, 164, "Output",
 Evaluatable->False,
 CellID->110789316]
}, Open  ]],
Cell[32774, 797, 115, 3, 70, "MathCaption",
 CellID->32444],
Cell[CellGroupData[{
Cell[32914, 804, 510, 17, 47, "Input",
 CellID->29897],
Cell[33427, 823, 3548, 62, 164, "Output",
 Evaluatable->False,
 CellID->267395570]
}, Open  ]],
Cell[36990, 888, 238, 8, 70, "MathCaption",
 CellID->3328],
Cell[CellGroupData[{
Cell[37253, 900, 508, 16, 47, "Input",
 CellID->24942],
Cell[37764, 918, 3467, 61, 158, "Output",
 Evaluatable->False,
 CellID->479631199]
}, Open  ]],
Cell[41246, 982, 808, 23, 70, "Text",
 CellID->1768],
Cell[CellGroupData[{
Cell[42079, 1009, 72, 1, 70, "RelatedTutorialsSection",
 CellID->419777204],
Cell[42154, 1012, 201, 5, 70, "RelatedTutorials",
 CellID->1229394717]
}, Open  ]]
}, Open  ]],
Cell[42382, 1021, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

