(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21795,        815]
NotebookOptionsPosition[     15973,        624]
NotebookOutlinePosition[     18490,        690]
CellTagsIndexPosition[     18399,        684]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Textual Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TextualInputAndOutputOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Textual Input and Output\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CForm" :> Documentation`HelpLookup["paclet:ref/CForm"], 
          "FortranForm" :> Documentation`HelpLookup["paclet:ref/FortranForm"],
           "FullForm" :> Documentation`HelpLookup["paclet:ref/FullForm"], 
          "InputForm" :> Documentation`HelpLookup["paclet:ref/InputForm"], 
          "MathMLForm" :> Documentation`HelpLookup["paclet:ref/MathMLForm"], 
          "OutputForm" :> Documentation`HelpLookup["paclet:ref/OutputForm"], 
          "StandardForm" :> 
          Documentation`HelpLookup["paclet:ref/StandardForm"], "TeXForm" :> 
          Documentation`HelpLookup["paclet:ref/TeXForm"], "TraditionalForm" :> 
          Documentation`HelpLookup["paclet:ref/TraditionalForm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CForm\"\>", 
       2->"\<\"FortranForm\"\>", 3->"\<\"FullForm\"\>", 
       4->"\<\"InputForm\"\>", 5->"\<\"MathMLForm\"\>", 
       6->"\<\"OutputForm\"\>", 7->"\<\"StandardForm\"\>", 
       8->"\<\"TeXForm\"\>", 
       9->"\<\"TraditionalForm\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Forms of Input and Output", "Title",
 CellTags->{"S2.9.1", "1.1"},
 CellID->12368],

Cell["Here is one way to enter a particular expression. ", "MathCaption",
 CellID->6421],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "^", "2"}], "+", 
  RowBox[{"Sqrt", "[", "y", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15258],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "2"], "+", 
  SqrtBox["y"]}]], "Output",
 ImageSize->{53, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->347826147]
}, Open  ]],

Cell["Here is another way to enter the same expression. ", "MathCaption",
 CellID->9647],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plus", "[", 
  RowBox[{
   RowBox[{"Power", "[", 
    RowBox[{"x", ",", "2"}], "]"}], ",", 
   RowBox[{"Sqrt", "[", "y", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4982],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "2"], "+", 
  SqrtBox["y"]}]], "Output",
 ImageSize->{53, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->910144108]
}, Open  ]],

Cell["\<\
With a notebook front end, you can also enter the expression directly in this \
way. \
\>", "MathCaption",
 CellID->24122],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "2"], "+", 
  SqrtBox["y"]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->17723],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "2"], "+", 
  SqrtBox["y"]}]], "Output",
 ImageSize->{53, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->117840249]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to output expressions in many different ways. "
}], "Text",
 CellID->18706],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebooks, expressions are by default output in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->10189],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "^", "2"}], "+", 
  RowBox[{"Sqrt", "[", "y", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->11156],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "2"], "+", 
  SqrtBox["y"]}]], "Output",
 ImageSize->{53, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->2204268]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 " uses only ordinary keyboard characters and is the default for \
text\[Hyphen]based interfaces to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "MathCaption",
 CellID->12351],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OutputForm", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"Sqrt", "[", "y", "]"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->6923],

Cell[OutputFormData["\<\
x^2 + Sqrt[y]\
\>", "\<\
 2
x  + Sqrt[y]\
\>"], "Output",
 ImageSize->{84, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//OutputForm=",
 CellID->1630114367]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " yields a form that can be typed directly on a keyboard. "
}], "MathCaption",
 CellID->31550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"Sqrt", "[", "y", "]"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->2097],

Cell["x^2 + Sqrt[y]", "Output",
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//InputForm=",
 CellID->499491651]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " shows the internal form of an expression in explicit functional notation. \
"
}], "MathCaption",
 CellID->10591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"Sqrt", "[", "y", "]"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->13406],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Plus", "[", 
    RowBox[{
     RowBox[{"Power", "[", 
      RowBox[{"x", ",", "2"}], "]"}], ",", 
     RowBox[{"Power", "[", 
      RowBox[{"y", ",", 
       RowBox[{"Rational", "[", 
        RowBox[{"1", ",", "2"}], "]"}]}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{294, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]//FullForm=",
 CellID->2103585821]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FullForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FullForm"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "the internal form of an expression", "TableText"]},
   {
    RowBox[{
     ButtonBox["InputForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InputForm"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "a form suitable for direct keyboard input", "TableText"]},
   {
    RowBox[{
     ButtonBox["OutputForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OutputForm"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell["\<\
a two\[Hyphen]dimensional form using only keyboard characters\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["StandardForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StandardForm"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "the default form used in ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " notebooks"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->25813],

Cell["Some output forms for expressions. ", "Caption",
 CellID->14651],

Cell[TextData[{
 "Output forms provide textual representations of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. In some cases these textual representations are also suitable \
for input to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". But in other cases they are intended just to be looked at, or to be \
exported to other programs, rather than to be used as input to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->25880],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " uses a large collection of ad hoc rules to produce an approximation to \
traditional mathematical notation. "
}], "MathCaption",
 CellID->27844],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraditionalForm", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"Sqrt", "[", "y", "]"}], "+", 
   RowBox[{
    RowBox[{"Gamma", "[", "z", "]"}], " ", 
    RowBox[{"EllipticK", "[", "z", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->24743],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["x", "2"], "+", 
   RowBox[{
    RowBox[{"K", "(", "z", ")"}], " ", 
    RowBox[{"\[CapitalGamma]", "(", "z", ")"}]}], "+", 
   SqrtBox["y"]}], TraditionalForm]], "Output",
 ImageSize->{110, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]//TraditionalForm=",
 CellID->85789083]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TeXForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TeXForm"]], "InlineFormula"],
 " yields output suitable for export to TeX. "
}], "MathCaption",
 CellID->11245],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TeXForm", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"Sqrt", "[", "y", "]"}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->14578],

Cell["x^2+\\sqrt{y}", "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]//TeXForm=",
 CellID->1687801009]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathMLForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathMLForm"]], "InlineFormula"],
 " yields output in MathML."
}], "MathCaption",
 CellID->752763780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathMLForm", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"Sqrt", "[", "y", "]"}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->581987910],

Cell["\<\
<math>
 <mrow>
  <msup>
   <mi>x</mi>
   <mn>2</mn>
  </msup>
  <mo>+</mo>
  <msqrt>
   <mi>y</mi>
  </msqrt>
 </mrow>
</math>\
\>", "Output",
 ImageSize->{91, 191},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]//MathMLForm=",
 CellID->1461685075]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CForm"]], "InlineFormula"],
 " yields output that can be included in a C program. Macros for objects like \
",
 Cell[BoxData[
  ButtonBox["Power",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Power"]], "InlineFormula"],
 " are included in the header file ",
 Cell[BoxData[
  RowBox[{"mdefs", ".", "h"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21705],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"Sqrt", "[", "y", "]"}]}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->24514],

Cell["Power(x,2) + Sqrt(y)", "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]//CForm=",
 CellID->831695862]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FortranForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FortranForm"]], "InlineFormula"],
 " yields output suitable for export to Fortran. "
}], "MathCaption",
 CellID->9227],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FortranForm", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"Sqrt", "[", "y", "]"}]}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->8624],

Cell["x**2 + Sqrt(y)", "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]//FortranForm=",
 CellID->976784061]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["TraditionalForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TraditionalForm"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "traditional mathematical notation", "TableText"]},
   {
    RowBox[{
     ButtonBox["TeXForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TeXForm"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "output suitable for export to ",
     Cell[BoxData[
      FormBox[
       StyleBox[
        RowBox[{"T", 
         AdjustmentBox["E",
          BoxBaselineShift->0.5,
          BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
        SingleLetterItalics->False], TraditionalForm]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MathMLForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MathMLForm"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "output suitable for use with MathML on the web", "TableText"]},
   {
    RowBox[{
     ButtonBox["CForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CForm"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "output suitable for export to C", "TableText"]},
   {
    RowBox[{
     ButtonBox["FortranForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FortranForm"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "output suitable for export to Fortran", "TableText"]}
  }]], "DefinitionBox",
 CellID->28356],

Cell[TextData[{
 "Output forms not normally used for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input. "
}], "Caption",
 CellID->23917],

Cell[TextData[{
 ButtonBox["\"Low-Level Input and Output Rules\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LowLevelInputAndOutputRules"],
 " will discuss how you can create your own output forms. You should realize \
however that in communicating with external programs it is often better to \
use ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " to send expressions directly than to generate a textual representation for \
these expressions. "
}], "Text",
 CellID->6227],

Cell[BoxData[GridBox[{
   {Cell["\<\
\[FilledSmallSquare] Exchange textual representations of expressions.\
\>", "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] Exchange expressions directly via ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     "."
    }], "TableText"]}
  }]], "FramedBox",
 CellID->555],

Cell[TextData[{
 "Two ways to communicate between ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and other programs."
}], "Caption",
 CellID->10102],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->761959250],

Cell[TextData[ButtonBox["Textual Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TextualInputAndOutputOverview"]], "RelatedTutorials",
 CellID->364580606]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Forms of Input and Output - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Textual Input and Output", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/TextualInputAndOutputOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/HowInputAndOutputWork"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 36, 9.5344682}", "context" -> "", 
    "keywords" -> {
     "CForm", "exchanging", "exporting", "expressions", "external programs", 
      "formatting", "FortranForm", "FullForm", "HTML output", "InputForm", 
      "MathMLForm", "OutputForm", "printing", "representations", 
      "StandardForm", "TeXForm", "TraditionalForm", "web format"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Here is one way to enter a particular expression. Here is another way to \
enter the same expression. With a notebook front end, you can also enter the \
expression directly in this way. ", "synonyms" -> {"1.10.9", "2.9.1"}, 
    "title" -> "Forms of Input and Output", "type" -> "Tutorial", "uri" -> 
    "tutorial/FormsOfInputAndOutput"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.9.1"->{
  Cell[2679, 71, 88, 2, 70, "Title",
   CellTags->{"S2.9.1", "1.1"},
   CellID->12368]},
 "1.1"->{
  Cell[2679, 71, 88, 2, 70, "Title",
   CellTags->{"S2.9.1", "1.1"},
   CellID->12368]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.9.1", 18188, 673},
 {"1.1", 18287, 677}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2054, 44, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2679, 71, 88, 2, 70, "Title",
 CellTags->{"S2.9.1", "1.1"},
 CellID->12368],
Cell[2770, 75, 88, 1, 70, "MathCaption",
 CellID->6421],
Cell[CellGroupData[{
Cell[2883, 80, 142, 5, 28, "Input",
 CellID->15258],
Cell[3028, 87, 216, 8, 38, "Output",
 CellID->347826147]
}, Open  ]],
Cell[3259, 98, 88, 1, 70, "MathCaption",
 CellID->9647],
Cell[CellGroupData[{
Cell[3372, 103, 208, 7, 28, "Input",
 CellID->4982],
Cell[3583, 112, 216, 8, 38, "Output",
 CellID->910144108]
}, Open  ]],
Cell[3814, 123, 132, 4, 70, "MathCaption",
 CellID->24122],
Cell[CellGroupData[{
Cell[3971, 131, 124, 5, 31, "Input",
 CellID->17723],
Cell[4098, 138, 216, 8, 38, "Output",
 CellID->117840249]
}, Open  ]],
Cell[4329, 149, 154, 5, 70, "Text",
 CellID->18706],
Cell[4486, 156, 294, 11, 70, "MathCaption",
 CellID->10189],
Cell[CellGroupData[{
Cell[4805, 171, 142, 5, 70, "Input",
 CellID->11156],
Cell[4950, 178, 214, 8, 38, "Output",
 CellID->2204268]
}, Open  ]],
Cell[5179, 189, 331, 11, 70, "MathCaption",
 CellID->12351],
Cell[CellGroupData[{
Cell[5535, 204, 180, 6, 70, "Input",
 CellID->6923],
Cell[5718, 212, 225, 10, 65, "Output",
 CellID->1630114367]
}, Open  ]],
Cell[5958, 225, 232, 7, 70, "MathCaption",
 CellID->31550],
Cell[CellGroupData[{
Cell[6215, 236, 179, 6, 70, "Input",
 CellID->2097],
Cell[6397, 244, 172, 5, 50, "Output",
 CellID->499491651]
}, Open  ]],
Cell[6584, 252, 250, 8, 70, "MathCaption",
 CellID->10591],
Cell[CellGroupData[{
Cell[6859, 264, 179, 6, 70, "Input",
 CellID->13406],
Cell[7041, 272, 541, 19, 50, "Output",
 CellID->2103585821]
}, Open  ]],
Cell[7597, 294, 1065, 35, 70, "DefinitionBox",
 CellID->25813],
Cell[8665, 331, 70, 1, 70, "Caption",
 CellID->14651],
Cell[8738, 334, 485, 14, 70, "Text",
 CellID->25880],
Cell[9226, 350, 296, 8, 70, "MathCaption",
 CellID->27844],
Cell[CellGroupData[{
Cell[9547, 362, 292, 9, 70, "Input",
 CellID->24743],
Cell[9842, 373, 372, 12, 53, "Output",
 CellID->85789083]
}, Open  ]],
Cell[10229, 388, 214, 7, 70, "MathCaption",
 CellID->11245],
Cell[CellGroupData[{
Cell[10468, 399, 178, 6, 70, "Input",
 CellID->14578],
Cell[10649, 407, 171, 5, 50, "Output",
 CellID->1687801009]
}, Open  ]],
Cell[10835, 415, 206, 7, 70, "MathCaption",
 CellID->752763780],
Cell[CellGroupData[{
Cell[11066, 426, 186, 6, 70, "Input",
 CellID->581987910],
Cell[11255, 434, 297, 18, 226, "Output",
 CellID->1461685075]
}, Open  ]],
Cell[11567, 455, 468, 16, 70, "MathCaption",
 CellID->21705],
Cell[CellGroupData[{
Cell[12060, 475, 177, 6, 70, "Input",
 CellID->24514],
Cell[12240, 483, 177, 5, 50, "Output",
 CellID->831695862]
}, Open  ]],
Cell[12432, 491, 225, 7, 70, "MathCaption",
 CellID->9227],
Cell[CellGroupData[{
Cell[12682, 502, 182, 6, 70, "Input",
 CellID->8624],
Cell[12867, 510, 176, 5, 50, "Output",
 CellID->976784061]
}, Open  ]],
Cell[13058, 518, 1452, 46, 70, "DefinitionBox",
 CellID->28356],
Cell[14513, 566, 147, 6, 70, "Caption",
 CellID->23917],
Cell[14663, 574, 486, 12, 70, "Text",
 CellID->6227],
Cell[15152, 588, 330, 11, 70, "FramedBox",
 CellID->555],
Cell[15485, 601, 156, 6, 70, "Caption",
 CellID->10102],
Cell[CellGroupData[{
Cell[15666, 611, 72, 1, 70, "RelatedTutorialsSection",
 CellID->761959250],
Cell[15741, 614, 178, 4, 70, "RelatedTutorials",
 CellID->364580606]
}, Open  ]]
}, Open  ]],
Cell[15946, 622, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

