(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     48975,       1491]
NotebookOptionsPosition[     41480,       1251]
NotebookOutlinePosition[     44528,       1328]
CellTagsIndexPosition[     44435,       1322]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Operations on Data" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalOperationsOnDataOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Operations on Data\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Fourier" :> Documentation`HelpLookup["paclet:ref/Fourier"], 
          "FourierDCT" :> Documentation`HelpLookup["paclet:ref/FourierDCT"], 
          "FourierDST" :> Documentation`HelpLookup["paclet:ref/FourierDST"], 
          "InverseFourier" :> 
          Documentation`HelpLookup["paclet:ref/InverseFourier"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Fourier\"\>", 
       2->"\<\"FourierDCT\"\>", 3->"\<\"FourierDST\"\>", 
       4->"\<\"InverseFourier\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Discrete Fourier Transforms", "Title",
 CellTags->{"S3.8.4", "4.1"},
 CellID->14286],

Cell["\<\
A common operation in analyzing various kinds of data is to find the discrete \
Fourier transform (or spectrum) of a list of values. The idea is typically to \
pick out components of the data with particular frequencies or ranges of \
frequencies.\
\>", "Text",
 CellID->19468],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Fourier",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Fourier"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["u", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["u", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"], ",", 
       SubscriptBox[
        StyleBox["u", "TI"], 
        StyleBox["n", "TI"]]}], "}"}], "]"}], Cell[
    "discrete Fourier transform", "TableText"]},
   {
    RowBox[{
     ButtonBox["InverseFourier",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseFourier"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"], ",", 
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["n", "TI"]]}], "}"}], "]"}], Cell[
    "inverse discrete Fourier transform", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->11698],

Cell["Discrete Fourier transforms. ", "Caption",
 CellID->8979],

Cell["Here is some data, corresponding to a square pulse.", "MathCaption",
 CellID->21411],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "1", ",", "1"}], 
  "}"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->12489],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "1", ",", "1"}], 
  "}"}]], "Output",
 ImageSize->{184, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->10758]
}, Open  ]],

Cell["\<\
Here is the discrete Fourier transform of the data. It involves complex \
numbers. \
\>", "MathCaption",
 CellID->13490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fourier", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->30775],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.7071067811865476`"}], "-", 
    RowBox[{"1.7071067811865475`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.7071067811865476`"}], "-", 
    RowBox[{"0.29289321881345254`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.7071067811865476`"}], "+", 
    RowBox[{"0.29289321881345254`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.7071067811865476`"}], "+", 
    RowBox[{"1.7071067811865475`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{435, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->28410]
}, Open  ]],

Cell["Here is the inverse discrete Fourier transform. ", "MathCaption",
 CellID->17132],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourier", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->27089],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.0000000000000002`"}], ",", 
   RowBox[{"-", "1.0000000000000002`"}], ",", 
   RowBox[{"-", "1.`"}], ",", 
   RowBox[{"-", "1.0000000000000002`"}], ",", "1.0000000000000002`", ",", 
   "1.0000000000000002`", ",", "1.`", ",", "1.0000000000000002`"}], 
  "}"}]], "Output",
 ImageSize->{240, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->27296]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Fourier",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fourier"]], "InlineFormula"],
 " works whether or not your list of data has a length which is a power of \
two. "
}], "MathCaption",
 CellID->11950],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fourier", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", 
    RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->23112],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.5773502691896257`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.5773502691896257`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.9999999999999999`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.5773502691896257`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.9999999999999999`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{301, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->20122]
}, Open  ]],

Cell["\<\
This generates a list of 200 elements containing a periodic signal with \
random noise added. \
\>", "MathCaption",
 CellID->12529],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"N", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"30", " ", "2", " ", "Pi", " ", 
         RowBox[{"n", "/", "200"}]}], "]"}], "+", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"RandomReal", "[", "]"}], "-", 
         RowBox[{"1", "/", "2"}]}], ")"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "200"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->7672],

Cell["The data looks fairly random if you plot it directly. ", "MathCaption",
 CellID->25836],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", "data", "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->18277],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw1Vgs4lGkbHtpKJdHWJpRpKxRFNhWF25moxmCcRmbGGJOynaSj+voT0nYg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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->{{0., 200.}, {-1.4600718494403373`, 1.475255343907672}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->891633012]
}, Open  ]],

Cell[TextData[{
 "The ",
 "discrete ",
 "Fourier transform, however, shows a strong peak at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"30", "+", "1"}], TraditionalForm]], "InlineMath"],
 ", and a symmetric peak at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"201", "-", "30"}], TraditionalForm]], "InlineMath"],
 ", reflecting the frequency component of the original signal near ",
 Cell[BoxData[
  FormBox[
   RowBox[{"30", "/", "200"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->13976],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"Fourier", "[", "data", "]"}], "]"}], ",", 
   RowBox[{"PlotRange", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->10670],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxdVwlMVFcUheIWrRYttg2LDsMiKlHrhojKEUZEQWAY9m3+7GNN40IVraBf
K1Cq2AS01bhN3KhLRGpRsSofpJS64S6IyyhaE7u4BAW1NW3T+03un2QyOfP+
fe++u53zfY1zEy3vuLi4NP37/e/3/8+TcE+/yhWF+VfD6Q8cqAn16h12iHAv
+HzT+rKhoZmwO15ddBus3nmRsAd6dMTcf95yhvBHGFCR0V+dd4uwN86N7BfY
WHCSsAq6wl5Xrg9tI6xG8EJtVWpEDWF/aBqzeu8c2Uo4EKbgmszdpfJ5QcjY
tLphlOUa4WFY8sCtua3pCuFgJFW5tqh3HSc8Am3a6yUb+kiER6HIQ+pnXfkz
4Y+x3lOdG7h+PeHRODpoxYKHW+X9x2Dgjr3Da+7I+4+FWHzhSti3pwiPw73l
m7+cF3md8Hg0b4363bv5J8IhqK7ObTkZc5PwBMzt8qh+3X6ZcChO6Sbe9S+W
7z8RTzcWmkvyLhEOw98FQ17M23Oa8CToNU35cyrleEyG7+7kXj5fyedNQVMr
rvtlyv6EIzPzg343ArxA6UXX7PMmNzvFVwQOqqXQsx3yflPh+UfQm9Jl5J84
FfXPredyvBppPQJPbveMP/aM4idG4FPfy7GBo2X/IjHIv/iT3rl0vhiJ0OGX
unkv/ZHWNdh2Mc/rYS3Vk6iBz6S2EO9L8n2nYWXx+PDLr87S+jRs0g0NqtLI
9RKFpPCpEaozVF9iFK4V5h713Sfnazo0ZQOONO2j+4jToX3keat/oxz/aCwb
98Dqn/ELrUfjpRCxoXuRXL8zMLJ2/pCKN7SfOAOGev0Xjwvl+8+E5+Do/Qce
Ub+IMzFpXWRb326y/zHwiG0OeuZWT+sxSLfnxfl8LZ8fi1VPg71bg+T4xaJ7
eVX+qRw5f7PweNh3B1tcaT9xFrwXqib08pH7Mw7VFQU2Y98mWo/D0+aIzvhF
cv7i4f5uxJOHk+/Qejz2/LDx9r3nsv8JiB8xLHbHCcoPErBl/qGy+gA53wlY
46yMWuBL50sJyI0/ua7jr71kr4XOr92cEUf9BC3K00+Xj/WX/dEi8HmL+/Fd
28lei0R16Jb5/eX+ScSD5NrPVHPIHySiIOW8Teq6TfaJOLTTr0+j6gbZJ2JO
9f0jFsNBstdh17jCgjlrqR6gw7wg15tl5ym+og57DtcGFKVQ/Ug6+Hx/ZnHx
Qrn/k6BpPvrhqVLZ/yT0Ua/ZYLtQS/ZJOPz58ilX4ST7JOifaev0b/ObjNIK
sSSgk+KNZJyIzw8Z2H6f7JOh2Xa3onyqHL9kdIW+Fx57herNJQVFk4XKF610
X6TApi/pqNsr11sKXG8NKH29mfIhpWB4sMa981gD2adi37YJ0aYx9DxSYSst
KwhLbCH7VNR5/9q0SnWB7FMRf81lrTBGjn8aPDpCqnx6yPlPQ88/zy7duYie
F9OAJY46Ly+Kj5QG9f7OKXkJcn+l4/3Fv62e2I3ihXRUr1vVXrv9GNkr1qV0
hX0G3x8ZivMzuH9ShsL/TH4/ZCrun8njI2Uq4pfF44ssRfyzeH6kLEX+snl+
ka3IfzavDylbUT85vL6Qo6i/HF6fUo6ifvW8vqFX1L+e94ekV/SPwPtLJfD+
g8D7UxB4/4oC72+HwPtfEvh8cAqK+WHg80Vl4PMHBj6fBAOfX6KBzzeHgc8/
ycDno9OgmJ9GPl9VRj5/YeTzWTDy+S0a+Xx3GPn8l4ycH5xGBX+YOL+oTJx/
YOL8JJg4f4kmzm8OE+c/ycT50WlS8KeZ86vKzPkXZs7Pgpnzt2jm/O4wc/6X
zFwfOM0K/WDh+kJl4foDFq5PBAvXL6KF6xuHhesfycL1kdOi0E9Wrq9UVq6/
YOX6TLBy/SZaub5zWLn+k6xcHzqtCv1o4/pSZeP6EzauTwUb16+ijetbh43r
X8nG9bHTptDPdq6vVXauv2Hn+lywc/0u2rm+d9i5/pfs/P3AaVe8P8x++37x
D8/fxYM=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->160777435]
}, Open  ]],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", the discrete Fourier transform ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["v", "s"], TraditionalForm]], "InlineMath"],
 " of a list ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["u", "r"], TraditionalForm]], "InlineMath"],
 " of length ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " is by default defined to be ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", 
     SqrtBox["n"]], 
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"r", "=", "1"}], "n",
     LimitsPositioning->True], 
    SubscriptBox["u", "r"], 
    SuperscriptBox["e", 
     RowBox[{"2", "\[Pi]", "i", 
      RowBox[{"(", 
       RowBox[{"r", "-", "1"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"s", "-", "1"}], ")"}], "/", "n"}]]}], TraditionalForm]], 
  "InlineMath"],
 ". Notice that the zero frequency term appears at position 1 in the \
resulting list. "
}], "Text",
 CellID->32652],

Cell[TextData[{
 "The inverse discrete Fourier transform ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["u", "r"], TraditionalForm]], "InlineMath"],
 " of a list ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["v", "s"], TraditionalForm]], "InlineMath"],
 " of length ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " is by default defined to be ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", 
     SqrtBox["n"]], 
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"s", "=", "1"}], "n",
     LimitsPositioning->True], 
    SubscriptBox["v", "s"], 
    SuperscriptBox["e", 
     RowBox[{
      RowBox[{"-", "2"}], "\[Pi]", "i", 
      RowBox[{"(", 
       RowBox[{"r", "-", "1"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"s", "-", "1"}], ")"}], "/", "n"}]]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Text",
 CellID->1751],

Cell[TextData[{
 "In different scientific and technical fields different conventions are \
often used for defining discrete Fourier transforms. The option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 " allows you to choose any of these conventions you want."
}], "Text",
 CellID->30397],

Cell[BoxData[GridBox[{
   {Cell["common convention", "TableHeader"], Cell["setting", "TableHeader"], 
    Cell["discrete Fourier transform", "TableHeader"], Cell[
    "inverse discrete Fourier transform", "TableHeader"]},
   {Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " default"
    }], "TableText"], 
    RowBox[{"{", "0", ",", "1", "}"}], 
    RowBox[{
     FractionBox["1", 
      SuperscriptBox[
       StyleBox["n", "TI"], 
       RowBox[{"1", "/", "2"}]]], 
     UnderoverscriptBox["\[Sum]", 
      RowBox[{
       StyleBox["r", "TI"], "=", "1"}], 
      StyleBox["n", "TI"],
      LimitsPositioning->True], 
     SubscriptBox[
      StyleBox["u", "TI"], 
      StyleBox["r", "TI"]], 
     SuperscriptBox[
      StyleBox["e", "TI"], 
      RowBox[{"2", "\[Pi]", 
       StyleBox["i", "TI"], 
       RowBox[{"(", 
        RowBox[{
         StyleBox["r", "TI"], "-", "1"}], ")"}], 
       RowBox[{"(", 
        RowBox[{
         StyleBox["s", "TI"], "-", "1"}], ")"}], "/", 
       StyleBox["n", "TI"]}]]}], 
    RowBox[{
     FractionBox["1", 
      SuperscriptBox[
       StyleBox["n", "TI"], 
       RowBox[{"1", "/", "2"}]]], 
     UnderoverscriptBox["\[Sum]", 
      RowBox[{
       StyleBox["s", "TI"], "=", "1"}], 
      StyleBox["n", "TI"],
      LimitsPositioning->True], 
     SubscriptBox[
      StyleBox["v", "TI"], 
      StyleBox["s", "TI"]], 
     SuperscriptBox[
      StyleBox["e", "TI"], 
      RowBox[{
       RowBox[{"-", "2"}], "\[Pi]", 
       StyleBox["i", "TI"], 
       RowBox[{"(", 
        RowBox[{
         StyleBox["r", "TI"], "-", "1"}], ")"}], 
       RowBox[{"(", 
        RowBox[{
         StyleBox["s", "TI"], "-", "1"}], ")"}], "/", 
       StyleBox["n", "TI"]}]]}]},
   {Cell["data analysis", "TableText"], 
    RowBox[{"{", "-", "1", ",", "1", "}"}], 
    RowBox[{
     FractionBox["1", 
      StyleBox["n", "TI"]], 
     UnderoverscriptBox["\[Sum]", 
      RowBox[{
       StyleBox["r", "TI"], "=", "1"}], 
      StyleBox["n", "TI"],
      LimitsPositioning->True], 
     SubscriptBox[
      StyleBox["u", "TI"], 
      StyleBox["r", "TI"]], 
     SuperscriptBox[
      StyleBox["e", "TI"], 
      RowBox[{"2", "\[Pi]", 
       StyleBox["i", "TI"], 
       RowBox[{"(", 
        RowBox[{
         StyleBox["r", "TI"], "-", "1"}], ")"}], 
       RowBox[{"(", 
        RowBox[{
         StyleBox["s", "TI"], "-", "1"}], ")"}], "/", 
       StyleBox["n", "TI"]}]]}], 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{
       StyleBox["s", "TI"], "=", "1"}], 
      StyleBox["n", "TI"],
      LimitsPositioning->True], 
     SubscriptBox[
      StyleBox["v", "TI"], 
      StyleBox["s", "TI"]], 
     SuperscriptBox[
      StyleBox["e", "TI"], 
      RowBox[{"-", "2", "\[Pi]", 
       StyleBox["i", "TI"], "(", 
       StyleBox["r", "TI"], "-", "1", ")", "(", 
       StyleBox["s", "TI"], "-", "1", ")", "/", 
       StyleBox["n", "TI"]}]]}]},
   {Cell["signal processing", "TableText"], 
    RowBox[{"{", "1", ",", "-", "1", "}"}], 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{
       StyleBox["r", "TI"], "=", "1"}], 
      StyleBox["n", "TI"],
      LimitsPositioning->True], 
     SubscriptBox[
      StyleBox["u", "TI"], 
      StyleBox["r", "TI"]], 
     SuperscriptBox[
      StyleBox["e", "TI"], 
      RowBox[{"-", "2", "\[Pi]", 
       StyleBox["i", "TI"], "(", 
       StyleBox["r", "TI"], "-", "1", ")", "(", 
       StyleBox["s", "TI"], "-", "1", ")", "/", 
       StyleBox["n", "TI"]}]]}], 
    RowBox[{
     FractionBox["1", 
      StyleBox["n", "TI"]], 
     UnderoverscriptBox["\[Sum]", 
      RowBox[{
       StyleBox["s", "TI"], "=", "1"}], 
      StyleBox["n", "TI"],
      LimitsPositioning->True], 
     SubscriptBox[
      StyleBox["v", "TI"], 
      StyleBox["s", "TI"]], 
     SuperscriptBox[
      StyleBox["e", "TI"], 
      RowBox[{"2", "\[Pi]", 
       StyleBox["i", "TI"], 
       RowBox[{"(", 
        RowBox[{
         StyleBox["r", "TI"], "-", "1"}], ")"}], 
       RowBox[{"(", 
        RowBox[{
         StyleBox["s", "TI"], "-", "1"}], ")"}], "/", 
       StyleBox["n", "TI"]}]]}]},
   {Cell["general case", "TableText"], 
    RowBox[{"{", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], "}"}], 
    RowBox[{"1", "/", 
     SuperscriptBox[
      StyleBox["n", "TI"], 
      RowBox[{"(", "1", "-", 
       StyleBox["a", "TI"], ")", "/", "2"}]], 
     UnderoverscriptBox["\[Sum]", 
      RowBox[{
       StyleBox["r", "TI"], "=", "1"}], 
      StyleBox["n", "TI"],
      LimitsPositioning->True], 
     SubscriptBox[
      StyleBox["u", "TI"], 
      StyleBox["r", "TI"]], 
     SuperscriptBox[
      StyleBox["e", "TI"], 
      RowBox[{"2", "\[Pi]", 
       StyleBox["i", "TI"], 
       StyleBox["b", "TI"], "(", 
       StyleBox["r", "TI"], "-", "1", ")", "(", 
       StyleBox["s", "TI"], "-", "1", ")", "/", 
       StyleBox["n", "TI"]}]]}], 
    RowBox[{
     FractionBox["1", 
      SuperscriptBox[
       StyleBox["n", "TI"], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          StyleBox["a", "TI"]}], ")"}], "/", "2"}]]], 
     UnderoverscriptBox["\[Sum]", 
      RowBox[{
       StyleBox["s", "TI"], "=", "1"}], 
      StyleBox["n", "TI"],
      LimitsPositioning->True], 
     SubscriptBox[
      StyleBox["v", "TI"], 
      StyleBox["s", "TI"]], 
     SuperscriptBox[
      StyleBox["e", "TI"], 
      RowBox[{
       RowBox[{"-", "2"}], "\[Pi]", 
       StyleBox["i", "TI"], 
       StyleBox["b", "TI"], 
       RowBox[{"(", 
        RowBox[{
         StyleBox["r", "TI"], "-", "1"}], ")"}], 
       RowBox[{"(", 
        RowBox[{
         StyleBox["s", "TI"], "-", "1"}], ")"}], "/", 
       StyleBox["n", "TI"]}]]}]}
  }]], "DefinitionBox4Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.2], 
     Scaled[0.1], 
     Scaled[0.35], {
      Scaled[0.35]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->19751],

Cell[TextData[{
 "Typical settings for ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 " with various conventions. "
}], "Caption",
 CellID->29001],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Fourier",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Fourier"], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["u", "TI"], 
          StyleBox["11", "TR"]], ",", 
         SubscriptBox[
          StyleBox["u", "TI"], 
          StyleBox["12", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["u", "TI"], 
          StyleBox["21", "TR"]], ",", 
         SubscriptBox[
          StyleBox["u", "TI"], 
          StyleBox["22", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], "\[SpanFromLeft]"},
   {"", Cell["\<\
two\[Hyphen]dimensional discrete Fourier transform\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->435],

Cell["\<\
Two\[Hyphen]dimensional discrete Fourier transform. \
\>", "Caption",
 CellID->16693],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can find discrete Fourier transforms for data in any number of dimensions. \
In ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " dimensions, the data is specified by a list nested ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " levels deep. Two\[Hyphen]dimensional ",
 "discrete ",
 "Fourier transforms are often used in image processing. "
}], "Text",
 CellID->15072],

Cell[TextData[{
 "One issue with the usual discrete Fourier transform for real data is that \
the result is complex-valued. There are variants of real discrete Fourier \
transforms that have real results. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has commands for computing the discrete cosine transform and the discrete \
sine transform."
}], "Text",
 CellID->89635326],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FourierDCT",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FourierDCT"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[
    "Fourier discrete cosine transform of a list of real numbers", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["FourierDST",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FourierDST"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[
    "Fourier discrete sine transform of a list of real numbers", 
     "TableText"]}
  }]], "DefinitionBox",
 CellID->73878609],

Cell["Discrete real Fourier transforms.", "Caption",
 CellID->479985102],

Cell["Here is some data, corresponding to a square pulse.", "MathCaption",
 CellID->145465090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pulse", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", 
    RowBox[{"-", "1"}], ",", 
    RowBox[{"-", "1"}], ",", 
    RowBox[{"-", "1"}], ",", 
    RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "1", ",", "1", ",", "1"}], 
   "}"}]}]], "Input",
 CellLabel->"In[21]:=",
 CellID->750254072],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "1", ",", "1", ",", "1"}], 
  "}"}]], "Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->214796240]
}, Open  ]],

Cell["Here is the Fourier discrete cosine transform of the data.", \
"MathCaption",
 CellID->106981496],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierDCT", "[", "pulse", "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->918336646],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", 
   RowBox[{"-", "2.021471201601977`"}], ",", "3.2975316691805027`*^-17", ",", 
   "0.6965515053690705`", ",", 
   RowBox[{"-", "5.680647880997788`*^-17"}], ",", 
   RowBox[{"-", "0.447213595499958`"}], ",", 
   RowBox[{"-", "4.1272322721684297`*^-17"}], ",", "0.3549107188691968`", ",",
    "4.7629417560683264`*^-17", ",", 
   RowBox[{"-", "0.3201695848978971`"}]}], "}"}]], "Output",
 ImageSize->{427, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->746457000]
}, Open  ]],

Cell["Here is the Fourier discrete sine transform of the data.", "MathCaption",
 CellID->389393447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierDST", "[", "pulse", "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->121842800],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"8.033649276373057`*^-17", ",", 
   RowBox[{"-", "2.0466690944067705`"}], ",", 
   RowBox[{"-", "3.8506248513386897`*^-17"}], ",", 
   RowBox[{"-", "9.378348791999613`*^-18"}], ",", "0.`", ",", 
   RowBox[{"-", "0.7817580303394192`"}], ",", "9.842592393709727`*^-17", ",", 
   "4.4885969940899884`*^-17", ",", "5.836787854364518`*^-17", ",", 
   RowBox[{"-", "0.6324555320336759`"}]}], "}"}]], "Output",
 ImageSize->{453, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->232576698]
}, Open  ]],

Cell["\<\
There are four types each of Fourier discrete sine and cosine transforms \
typically in use, denoted by number or sometimes roman numeral as in \
\"DCTII\" for the discrete cosine transform of type 2.\
\>", "Text",
 CellID->92106828],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FourierDCT",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FourierDCT"], "[", 
     RowBox[{
      StyleBox["list", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[TextData[{
     "Fourier discrete cosine transform of type ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FourierDST",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FourierDST"], "[", 
     RowBox[{
      StyleBox["list", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[TextData[{
     "Fourier discrete sine transform of type ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->162615495],

Cell["Discrete real Fourier transforms of different types.", "Caption",
 CellID->744347008],

Cell[TextData[{
 "The default is type 2 for both ",
 Cell[BoxData[
  ButtonBox["FourierDCT",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierDCT"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FourierDST",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierDST"]], "InlineFormula"],
 "."
}], "Text",
 CellID->358582876],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not have InverseFourierDCT or InverseFourierDST functions because ",
 Cell[BoxData[
  ButtonBox["FourierDCT",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierDCT"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FourierDST",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierDST"]], "InlineFormula"],
 " are their own inverses when used with the appropriate type. The inverse \
transforms for types 1, 2, 3, 4 are types 1, 3, 2, 4, respectively."
}], "Text",
 CellID->31063579],

Cell["\<\
Check that the type 3 transform is the inverse of the type 2 transform.\
\>", "MathCaption",
 CellID->402591641],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierDCT", "[", 
  RowBox[{
   RowBox[{"FourierDCT", "[", 
    RowBox[{"pulse", ",", "2"}], "]"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->57710227],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwqjEwMPBLMADZ/4Es
MAYBdSBmYGABkcwwsf8M4mh8OQr5YhTy0d3DDHY1M5qoBJBgAnLlCdDiBGhJ
NHOZsNrGCSRYGSDiIF1saPJ8AyzPNsDy7ATksYcqN5aYhukG0YIDLM85wPJc
eOQxQ5cJi2pQnKDndxGoOCuNxKmd/3nQ+Iz/iUlLg60UQ3cfcTli1BejviDN
F+i5HVTGUKOehNW36LkRUjuDmOpEsBgYAdgfhZg=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{294, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->208939150]
}, Open  ]],

Cell["\<\
The discrete real transforms are convenient to use for data or image \
compression.\
\>", "Text",
 CellID->485231861],

Cell["Here is data that might be like a front or an edge.", "MathCaption",
 CellID->669990994],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"ArcTan", "[", 
      RowBox[{"x", "-", "100"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1.", ",", "200."}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListLinePlot", "[", "data", "]"}]}], "Input",
 CellLabel->"In[43]:=",
 CellID->195390915],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWc1rVVcQP3n3fSi6FDVVJPpfuGilxBjTJCbR+gHi4jUIyaJaYrrRjW7a
TbLRjTbSLLSF1i4sFUtBQQyIQqlQFESFolB00VCouAgIt785H3fuPWfuxzNK
wnv33nkz85s5M3PmnHsy3J6eOPp5e3pyvN3TP9X+YmJy/ETPruNT+CnqUkpd
w/foRoXnGE/6ey2OcTfXDXSN6Ff9p77Rv7ZwpR9rKa4iGt8mnuk+p39b5ek3
PTpy9ODA/I4PL6jNdIlAHD/2Cz5qLV2iM6dvzH/7Oz6qTpfGwu2/7v/xt/k8
efyPGjf2I+uG9SSqatvSmzX96tWSAVZr6RLdvPE0Y/vUyd+Mb/iMf/aTqpHH
zbGRS6C//uoWZKC2tPTmcOXxE7mdiNWLi6+h/Ov1R0ABXF/vxcmJqz9ffQif
1CERr26j7ePu0MyHD17OziwcOfzDvbvPD+bqp+mGR3+safj15fR1+KUOJPkn
q+7esPedWhoRQoLo8VOxhnod5sH93yNQOVIGCxGFWXrcl0iRpT7NxbDgV5Yb
YsAG0kMxlKUMFiKNcNHj3oylXZqLMCIPWW6IAREIlknBDIyxlDSb6DE9m4wX
L178h5ixpp9NXdF1plWQzz4XEdQW45TNnHJc4x+mgqXHOvAvSsaHwWGIneqH
fmBeoi10ikMj79dszD3MQ9Z3dd6M5dlmrHKtjonZN1Lnzt658uOfWSlnuYZ5
L1eO0eX6KrIAJ+CKbEHmVsMIpRAkhCrPks91UUxXV3rVKMdvBnlrSZktxfHr
3ZRRClbE5Trlebg8v8pxXF3K8amm7/d3wttixxNZelPMPUhHJELLtDpEd1u+
WTDcn9Mmbj2lHaXu8mqR9qnHrweP3x2MKth3eBp+tQYVJ8k3Er4g5WjaMnXR
PZZmxcqPZGMlC+EoKC9bV9z77gJ+tQxssWOpBb5uyveetgZ53rNGMfKyvXb1
l8B2En80grK6Ztxw9dNV00z/kp9fuXZ6UtFx/STdCdJru+sYdK97eh/EYQfh
TuLHzawzjDxaIMV7gtGM57s1l1f8Ioy3k1qH65xyi4yvU7YDf9f8yvJ2L/PO
8N6T/00xqtvyaDsqqQZ4/5afXdqhyTuikOuQO9EJq4l3YpLPErcaRiiFN128
aLPUqjh/v9bIeMH7K6Opdz+F+yG/U/k7xpXAIdLo8xtanr4bv1+tRp/3ZUX6
RVUt47iMuJ2U6567RWk5y1jsBgfm86UMFr/JjSRSZGkgl9spBpyAK2UY3NuL
pLjjSpb4PGIkiWLe+7afF78zGITVnlS4ovr5dH1gtAP9KMnsd5fvXzh/b7n2
031geTh87tIJDmeE5xdnJP1+LWeBK1euBYON95bFxdf0uCdTC594tbCnAAPB
RsjLpDgKkiU+dZIxjBSfBgwXSPFZ2XASL7+C/c48pHmmp5PmkJgp/73SnxND
rm6wfQKWGnwrFO1189mzf+ELBoJBIwlwqr8yGpE66y20A0QMeezrvZicuqqa
PqBFRszZLQrsIxHb1aFfYftcnM35q8VDes1BL6q14Z1Mt/TJ9OzMgj0dXk8X
OqGxp8dr9OmxaXEE3sj1p4hux7byLWpLo8JKxiq8sF6t0V6ZZshW89aNObHm
zBl/+r8Aqut/1uHy1Q==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[44]=",
 CellID->99992067]
}, Open  ]],

Cell["\<\
The discrete cosine transform has most of the information in the first few \
modes.\
\>", "MathCaption",
 CellID->290531593],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"dct", "=", 
   RowBox[{"FourierDCT", "[", "data", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"dct", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellLabel->"In[45]:=",
 CellID->14202003],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNl8uLjWEcx585Zy7GNSEzGLms/QmyEJIkC1nIYkwys3CJsWHDhs3MZlya
YYaFS7ksiEhRokSJEiWUKLEgRRZT6vg87/d5n/c+jnMmnM55z+/9/b7P7/78
3udd29nbvXV7Z29PV+eCVbs7d3X3dO1ZsHLnbljlBmPMdX7dbQa6AhX8ZlYq
FVO2VPAxI/Zi/pRbgmnKp089dpKTSTyCw4fuprXUxZVFeP+RxYMHbqe1AN+5
41qNXFmEl28xgW/hapklt645FzXBXhujCgofr2k5d53Y+pTC2xr0VGff3tbn
b63rWlz2yuks7t93a/OmC+mKsXDjhvOZisHLr1gGXz/3b1hcv+5MxuKypUP5
FlGBLK2lSm79uie5/mnOlU4t6oIEyq61zdM4Zm9Wp2tyvJOsUpK5Yvnwly8/
hr08rqUpxKECRR8/fhNuitNTJE/0AtxU9gpWjBe/BsvNcf6L55+uXnlxIiPt
2nL59avPiBitKema1adpzadPPjB4Iea42oQ7t6OSnIchP8SpuOEnlLa7yqdX
lZORNnrLPd1XOmIVNDmTZm6YBXefROStaCvqrAL87KBxvDwHFd7bQ0CD/U/m
kiIoIoYh9L+PqK0qC1VEw27799G0jyEfI5bWeCx7e29oLL579/XRw/eBD6VQ
V8L7jtriiVYUap47DnFwVRyXLj4jJtluitsexxpl9GbPLW1h13hOsf5sbME0
aFFkzCoiY5gdGXgA7TQw6J3mEB/Olo5KdsaEE8r+N6bwcwrw0Wwyk+OZ1mMI
f5idDEvkd26/QXQ0wk+L49kqHHF8ib5/Hx0afKSF2kuZiPoiTbPimljtXUAB
E5zjk88NT7/R0Z/3773Fmvr53NmnTjdQp/tQpHt+Sjeu3LzxEjX0D2rINVII
AFiTr0ghCAA8SoXHPlsHPLFBgy9BmXZgeMSXnoSBTfAiwItASYrAcU8oJ+g0
2wK/p3M9ZdzTWlEs5BYn8Y3HBg7rfcEeKo0hEAik8HEPz2HCQSFu4yeGIMii
CQ4Qegnh2aM3Lpik0BIlIgg2C6XmqYkAXdDym6iExhIETntCJjEDQSLiRND9
kGaJWHyFVmNwC8EDXMmQFomUFdIjMITAnvBgAvWEwHGO1yyFpsR/fOYGmzp1
31SnvDmq3DxxSTqNQlXIMUWiKmSPhqMqBESf0duERZ1UDMpD90BQCB2LfNxc
J6bsLf7N/aJi/2aI2993n4bCLTU7NCXHLZxGiqMqPy2jNNqS9kdanG7EpmRf
iFq12QiK9EOoiwjNtsSAXxdMwFadwfjKpNpSW98ci2xM9DZodPJJWkDLL6DH
I+QEITGndsdZkCR8MINhuYYCNHHTiUUYYoHWdhpMRlAWwkYfO7u65wdmC2XK
kp1gRTI0VymTJ2qm/FVKmH3+F8ns1vwzGR8NyYwnktgtWbQqktn3mHI48RIY
us1hpqV6OHXC8O8HubjY/UghKno7S7wvZdZOSXHPBtypbo3urmeupuEXH+A+
Vg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[46]=",
 CellID->259046747]
}, Open  ]],

Cell["\<\
Reconstruct the front from only the first 20 modes (1/10 of the original data \
size). The oscillations are a consequence of the truncation and are known to \
show up in image processing applications as well.\
\>", "MathCaption",
 CellID->380021663],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tdata", "=", 
   RowBox[{"FourierDCT", "[", 
    RowBox[{
     RowBox[{"PadRight", "[", 
      RowBox[{
       RowBox[{"Take", "[", 
        RowBox[{"dct", ",", "20"}], "]"}], ",", "200", ",", "0"}], "]"}], ",",
      "3"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"{", 
   RowBox[{"data", ",", "tdata"}], "}"}], "]"}]}], "Input",
 CellLabel->"In[52]:=",
 CellID->17107750],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[53]=",
 CellID->53228866]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->855713088],

Cell[TextData[ButtonBox["Numerical Operations on Data",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalOperationsOnDataOverview"]], "RelatedTutorials",
 CellID->618122]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Discrete Fourier Transforms - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numerical Operations on Data", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/NumericalOperationsOnDataOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ApproximateFunctionsAndInterpolation"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ConvolutionsAndCorrelations"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 36, 10.2844874}", "context" -> "", 
    "keywords" -> {
     "Cooley-Tukey transform", "discrete Fourier transform", 
      "electrical engineering", "FFT", "Fourier", "FourierParameters", 
      "Fourier transforms", "frequency spectrum", "image transform", 
      "InverseFourier", "periodic signals", "power spectrum", "signals", 
      "spectrum", "square pulse", "symmetry", "time series analysis", 
      "transform"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "A common operation in analyzing various kinds of data is to find the \
discrete Fourier transform (or spectrum) of a list of values. The idea is \
typically to pick out components of the data with particular frequencies or \
ranges of frequencies. Discrete Fourier transforms. Here is some data, \
corresponding to a square pulse.", "synonyms" -> {"3.8.4"}, "title" -> 
    "Discrete Fourier Transforms", "type" -> "Tutorial", "uri" -> 
    "tutorial/FourierTransforms"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.8.4"->{
  Cell[2166, 64, 90, 2, 70, "Title",
   CellTags->{"S3.8.4", "4.1"},
   CellID->14286]},
 "4.1"->{
  Cell[2166, 64, 90, 2, 70, "Title",
   CellTags->{"S3.8.4", "4.1"},
   CellID->14286]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.8.4", 44224, 1311},
 {"4.1", 44323, 1315}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1541, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2166, 64, 90, 2, 70, "Title",
 CellTags->{"S3.8.4", "4.1"},
 CellID->14286],
Cell[2259, 68, 287, 6, 70, "Text",
 CellID->19468],
Cell[2549, 76, 1397, 45, 70, "DefinitionBox",
 CellID->11698],
Cell[3949, 123, 63, 1, 70, "Caption",
 CellID->8979],
Cell[4015, 126, 90, 1, 70, "MathCaption",
 CellID->21411],
Cell[CellGroupData[{
Cell[4130, 131, 251, 9, 28, "Input",
 CellID->12489],
Cell[4384, 142, 340, 12, 36, "Output",
 CellID->10758]
}, Open  ]],
Cell[4739, 157, 130, 4, 70, "MathCaption",
 CellID->13490],
Cell[CellGroupData[{
Cell[4894, 165, 100, 3, 28, "Input",
 CellID->30775],
Cell[4997, 170, 1078, 28, 54, "Output",
 CellID->28410]
}, Open  ]],
Cell[6090, 201, 87, 1, 70, "MathCaption",
 CellID->17132],
Cell[CellGroupData[{
Cell[6202, 206, 107, 3, 70, "Input",
 CellID->27089],
Cell[6312, 211, 456, 13, 36, "Output",
 CellID->27296]
}, Open  ]],
Cell[6783, 227, 251, 8, 70, "MathCaption",
 CellID->11950],
Cell[CellGroupData[{
Cell[7059, 239, 177, 6, 70, "Input",
 CellID->23112],
Cell[7239, 247, 552, 14, 36, "Output",
 CellID->20122]
}, Open  ]],
Cell[7806, 264, 141, 4, 70, "MathCaption",
 CellID->12529],
Cell[7950, 270, 524, 17, 70, "Input",
 CellID->7672],
Cell[8477, 289, 93, 1, 70, "MathCaption",
 CellID->25836],
Cell[CellGroupData[{
Cell[8595, 294, 108, 3, 70, "Input",
 CellID->18277],
Cell[8706, 299, 3361, 63, 128, "Output",
 CellID->891633012]
}, Open  ]],
Cell[12082, 365, 507, 17, 70, "MathCaption",
 CellID->13976],
Cell[CellGroupData[{
Cell[12614, 386, 233, 7, 70, "Input",
 CellID->10670],
Cell[12850, 395, 2438, 47, 145, "Output",
 CellID->160777435]
}, Open  ]],
Cell[15303, 445, 971, 35, 70, "Text",
 CellID->32652],
Cell[16277, 482, 858, 32, 70, "Text",
 CellID->1751],
Cell[17138, 516, 382, 9, 70, "Text",
 CellID->30397],
Cell[17523, 527, 6244, 208, 70, "DefinitionBox4Col",
 CellID->19751],
Cell[23770, 737, 240, 8, 70, "Caption",
 CellID->29001],
Cell[24013, 747, 1214, 38, 70, "DefinitionBox",
 CellID->435],
Cell[25230, 787, 95, 3, 70, "Caption",
 CellID->16693],
Cell[25328, 792, 479, 14, 70, "Text",
 CellID->15072],
Cell[25810, 808, 383, 9, 70, "Text",
 CellID->89635326],
Cell[26196, 819, 566, 18, 70, "DefinitionBox",
 CellID->73878609],
Cell[26765, 839, 72, 1, 70, "Caption",
 CellID->479985102],
Cell[26840, 842, 94, 1, 70, "MathCaption",
 CellID->145465090],
Cell[CellGroupData[{
Cell[26959, 847, 328, 11, 70, "Input",
 CellID->750254072],
Cell[27290, 860, 383, 13, 36, "Output",
 CellID->214796240]
}, Open  ]],
Cell[27688, 876, 103, 2, 70, "MathCaption",
 CellID->106981496],
Cell[CellGroupData[{
Cell[27816, 882, 111, 3, 70, "Input",
 CellID->918336646],
Cell[27930, 887, 569, 14, 58, "Output",
 CellID->746457000]
}, Open  ]],
Cell[28514, 904, 99, 1, 70, "MathCaption",
 CellID->389393447],
Cell[CellGroupData[{
Cell[28638, 909, 111, 3, 70, "Input",
 CellID->121842800],
Cell[28752, 914, 574, 13, 58, "Output",
 CellID->232576698]
}, Open  ]],
Cell[29341, 930, 243, 5, 70, "Text",
 CellID->92106828],
Cell[29587, 937, 801, 26, 70, "DefinitionBox",
 CellID->162615495],
Cell[30391, 965, 91, 1, 70, "Caption",
 CellID->744347008],
Cell[30485, 968, 344, 13, 70, "Text",
 CellID->358582876],
Cell[30832, 983, 574, 16, 70, "Text",
 CellID->31063579],
Cell[31409, 1001, 122, 3, 70, "MathCaption",
 CellID->402591641],
Cell[CellGroupData[{
Cell[31556, 1008, 196, 6, 28, "Input",
 CellID->57710227],
Cell[31755, 1016, 497, 12, 36, "Output",
 Evaluatable->False,
 CellID->208939150]
}, Open  ]],
Cell[32267, 1031, 127, 4, 70, "Text",
 CellID->485231861],
Cell[32397, 1037, 94, 1, 70, "MathCaption",
 CellID->669990994],
Cell[CellGroupData[{
Cell[32516, 1042, 378, 12, 47, "Input",
 CellID->195390915],
Cell[32897, 1056, 1880, 35, 122, "Output",
 Evaluatable->False,
 CellID->99992067]
}, Open  ]],
Cell[34792, 1094, 134, 4, 70, "MathCaption",
 CellID->290531593],
Cell[CellGroupData[{
Cell[34951, 1102, 286, 8, 47, "Input",
 CellID->14202003],
Cell[35240, 1112, 1743, 33, 125, "Output",
 Evaluatable->False,
 CellID->259046747]
}, Open  ]],
Cell[36998, 1148, 259, 5, 70, "MathCaption",
 CellID->380021663],
Cell[CellGroupData[{
Cell[37282, 1157, 450, 14, 47, "Input",
 CellID->17107750],
Cell[37735, 1173, 3396, 60, 118, "Output",
 Evaluatable->False,
 CellID->53228866]
}, Open  ]],
Cell[CellGroupData[{
Cell[41168, 1238, 72, 1, 70, "RelatedTutorialsSection",
 CellID->855713088],
Cell[41243, 1241, 183, 4, 70, "RelatedTutorials",
 CellID->618122]
}, Open  ]]
}, Open  ]],
Cell[41453, 1249, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

