(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17286,        607]
NotebookOptionsPosition[     13943,        501]
NotebookOutlinePosition[     15593,        543]
CellTagsIndexPosition[     15550,        540]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"FrobeniusNumber" :> 
         Documentation`HelpLookup["paclet:ref/FrobeniusNumber"], 
         "FrobeniusSolve" :> 
         Documentation`HelpLookup["paclet:ref/FrobeniusSolve"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"FrobeniusNumber\"\>", 
      2->"\<\"FrobeniusSolve\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Solving Frobenius Equations and Computing Frobenius Numbers", "Title",
 CellID->2013],

Cell[TextData[{
 "A ",
 StyleBox["Frobenius equation",
  FontSlant->"Italic"],
 " is an equation of the form"
}], "Text",
 CellID->28836],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["a", "1"], 
        SubscriptBox["x", "1"]}], "+"}], "..."}], "+", 
     RowBox[{
      SubscriptBox["a", "n"], 
      SubscriptBox["x", "n"]}]}], "\[Equal]", " ", "m"}], ","}], 
  TraditionalForm]], "DisplayMath",
 CellID->16373],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", "1"], ",", "...", ",", " ", 
    SubscriptBox["a", "n"]}], TraditionalForm]], "InlineMath"],
 " are positive integers, ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " is an integer, and the coordinates ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "1"], ",", "...", ",", " ", 
    SubscriptBox["x", "n"]}], TraditionalForm]], "InlineMath"],
 " of solutions are required to be non\[Hyphen]negative integers."
}], "Text",
 CellID->10536],

Cell[TextData[{
 "The ",
 StyleBox["Frobenius number ",
  FontSlant->"Italic"],
 "of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", "1"], ",", "...", ",", " ", 
    SubscriptBox["a", "n"]}], TraditionalForm]], "InlineMath"],
 " is the largest integer ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "for which the Frobenius equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["a", "1"], 
        SubscriptBox["x", "1"]}], "+"}], "..."}], "+", 
     RowBox[{
      SubscriptBox["a", "n"], 
      SubscriptBox["x", "n"]}]}], "\[Equal]", " ", "m"}], TraditionalForm]], 
  "InlineMath"],
 " has no solutions."
}], "Text",
 CellID->21450],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FrobeniusSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FrobeniusSolve"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["1", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["n", "TI"]]}], "}"}], ",", 
      StyleBox["b", "TI"]}], "]"}], Cell[TextData[{
     "give a list of all solutions of the Frobenius equation ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{
         RowBox[{
          SubscriptBox["a", "1"], 
          SubscriptBox["x", "1"]}], "+", "\[Ellipsis]", "+", 
         RowBox[{
          SubscriptBox["a", "n"], 
          SubscriptBox["x", "n"]}]}], "=", "b"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FrobeniusSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FrobeniusSolve"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["1", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["n", "TI"]]}], "}"}], ",", 
      StyleBox["b", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[TextData[{
     "give ",
     Cell[BoxData[
      FormBox[Cell[TextData[Cell[BoxData[
        StyleBox["m", "TI"]], "InlineFormula"]], "InlineFormula"], 
       TraditionalForm]], "InlineMath"],
     " solutions of the Frobenius equation ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{
         RowBox[{
          SubscriptBox["a", "1"], 
          SubscriptBox["x", "1"]}], "+", "\[Ellipsis]", "+", 
         RowBox[{
          SubscriptBox["a", "n"], 
          SubscriptBox["x", "n"]}]}], "=", "b"}], TraditionalForm]], 
      "InlineMath"],
     "; if less than ",
     Cell[BoxData[
      FormBox[Cell[TextData[Cell[BoxData[
        StyleBox["m", "TI"]], "InlineFormula"]], "InlineFormula"], 
       TraditionalForm]], "InlineMath"],
     " solutions exist, give all solutions"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FrobeniusNumber",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FrobeniusNumber"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["1", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"], ",", 
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["n", "TI"]]}], "}"}], "]"}], Cell[TextData[{
     "give the Frobenius number of ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
        SubscriptBox["a", "n"]}], TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->89199694],

Cell["\<\
Functions for solving Frobenius equations and computing Frobenius numbers.\
\>", "Caption",
 CellID->127179636],

Cell[TextData[{
 "This gives all solutions of the Frobenius equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"12", "x"}], "+", 
     RowBox[{"16", "y"}], "+", 
     RowBox[{"20", "z"}], "+", 
     RowBox[{"27", "t"}]}], "==", "123"}], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->13891],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FrobeniusSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"12", ",", "16", ",", "20", ",", "27"}], "}"}], ",", "123"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23035],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0", ",", "3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{354, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->167655792]
}, Open  ]],

Cell[TextData[{
 "This gives one solution of the Frobenius equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"12", "x"}], "+", 
     RowBox[{"16", "y"}], "+", 
     RowBox[{"20", "z"}], "+", 
     RowBox[{"27", "t"}]}], "==", "123"}], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->5808],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FrobeniusSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"12", ",", "16", ",", "20", ",", "27"}], "}"}], ",", "123", ",", 
   "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29727],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"8", ",", "0", ",", "0", ",", "1"}], "}"}], "}"}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->12408975]
}, Open  ]],

Cell[TextData[{
 "Here is the Frobenius number of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"12", ",", "16", ",", "20", ",", "27"}], "}"}], TraditionalForm]],
   "InlineMath"],
 ", that is, the largest ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " for which the Frobenius equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"12", "x"}], "+", 
     RowBox[{"16", "y"}], "+", 
     RowBox[{"20", "z"}], "+", 
     RowBox[{"27", "t"}]}], "==", "m"}], TraditionalForm]], "InlineMath"],
 " has no solutions."
}], "MathCaption",
 CellID->6981],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FrobeniusNumber", "[", 
  RowBox[{"{", 
   RowBox[{"12", ",", "16", ",", "20", ",", "27"}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->30209],

Cell[BoxData["89"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->638167215]
}, Open  ]],

Cell[TextData[{
 "This shows that indeed, the Frobenius equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"12", "x"}], "+", 
     RowBox[{"16", "y"}], "+", 
     RowBox[{"20", "z"}], "+", 
     RowBox[{"27", "t"}]}], "==", "89"}], TraditionalForm]], "InlineMath"],
 " has no solutions."
}], "MathCaption",
 CellID->23731],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FrobeniusSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"12", ",", "16", ",", "20", ",", "27"}], "}"}], ",", "89", ",", 
   "1"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->19519],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->468090298]
}, Open  ]],

Cell["\<\
Here are all the ways of making 42 cents change using 1, 5, 10, and 25 cent \
coins.\
\>", "MathCaption",
 CellID->797143878],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FrobeniusSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "5", ",", "10", ",", "25"}], "}"}], ",", "42"}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->32949288],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "0", ",", "4", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "3", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "8", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "1", ",", "3", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "2", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "3", ",", "2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "5", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "7", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "0", ",", "3", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "4", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "6", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "3", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "5", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "2", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "4", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"27", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"27", ",", "3", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32", ",", "2", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"37", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"42", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{528, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->32619853]
}, Open  ]],

Cell["\<\
Using 24, 29, 31, 34, 37, and 39 cent stamps, you can pay arbitrary postage \
of more than 88 cents.\
\>", "MathCaption",
 CellID->71849645],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FrobeniusNumber", "[", 
  RowBox[{"{", 
   RowBox[{"24", ",", "29", ",", "31", ",", "34", ",", "37", ",", "39"}], 
   "}"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->35672211],

Cell[BoxData["88"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->79518352]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Solving Frobenius Equations and Computing Frobenius Numbers - \
Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 36, 12.0032814}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "A Frobenius equation is an equation of the form where a_1,..., a_n are \
positive integers, m is an integer, and the coordinates x_1,..., x_n of \
solutions are required to be non-negative integers. The Frobenius number of \
a_1,..., a_n is the largest integer m for which the Frobenius equation \
a_1x_1+...+a_nx_n== m has no solutions.", "synonyms" -> {}, "title" -> 
    "Solving Frobenius Equations and Computing Frobenius Numbers", "type" -> 
    "Tutorial", "uri" -> "tutorial/Frobenius"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 705, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1330, 44, 91, 1, 70, "Title",
 CellID->2013],
Cell[1424, 47, 137, 6, 70, "Text",
 CellID->28836],
Cell[1564, 55, 356, 14, 70, "DisplayMath",
 CellID->16373],
Cell[1923, 71, 561, 18, 70, "Text",
 CellID->10536],
Cell[2487, 91, 785, 31, 70, "Text",
 CellID->21450],
Cell[3275, 124, 2904, 93, 70, "DefinitionBox",
 CellID->89199694],
Cell[6182, 219, 121, 3, 70, "Caption",
 CellID->127179636],
Cell[6306, 224, 335, 12, 70, "MathCaption",
 CellID->13891],
Cell[CellGroupData[{
Cell[6666, 240, 207, 7, 28, "Input",
 CellID->23035],
Cell[6876, 249, 816, 23, 54, "Output",
 CellID->167655792]
}, Open  ]],
Cell[7707, 275, 333, 12, 70, "MathCaption",
 CellID->5808],
Cell[CellGroupData[{
Cell[8065, 291, 218, 7, 70, "Input",
 CellID->29727],
Cell[8286, 300, 246, 8, 36, "Output",
 CellID->12408975]
}, Open  ]],
Cell[8547, 311, 601, 21, 70, "MathCaption",
 CellID->6981],
Cell[CellGroupData[{
Cell[9173, 336, 178, 5, 70, "Input",
 CellID->30209],
Cell[9354, 343, 159, 5, 36, "Output",
 CellID->638167215]
}, Open  ]],
Cell[9528, 351, 347, 12, 70, "MathCaption",
 CellID->23731],
Cell[CellGroupData[{
Cell[9900, 367, 217, 7, 70, "Input",
 CellID->19519],
Cell[10120, 376, 175, 6, 36, "Output",
 CellID->468090298]
}, Open  ]],
Cell[10310, 385, 135, 4, 70, "MathCaption",
 CellID->797143878],
Cell[CellGroupData[{
Cell[10470, 393, 207, 7, 70, "Input",
 CellID->32949288],
Cell[10680, 402, 2651, 69, 122, "Output",
 CellID->32619853]
}, Open  ]],
Cell[13346, 474, 150, 4, 70, "MathCaption",
 CellID->71849645],
Cell[CellGroupData[{
Cell[13521, 482, 207, 6, 70, "Input",
 CellID->35672211],
Cell[13731, 490, 158, 5, 36, "Output",
 CellID->79518352]
}, Open  ]]
}, Open  ]],
Cell[13916, 499, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

