(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12531,        466]
NotebookOptionsPosition[      8213,        327]
NotebookOutlinePosition[     10652,        393]
CellTagsIndexPosition[     10561,        387]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Functional Operations" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/FunctionalOperationsOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Functional Operations\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Function Names as Expressions", "Title",
 CellTags->{"S2.2.1", "1.1"},
 CellID->29091],

Cell[TextData[{
 "In an expression like ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ", the \[OpenCurlyDoubleQuote]function name\[CloseCurlyDoubleQuote] ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is itself an expression, and you can treat it as you would any other \
expression. "
}], "Text",
 CellID->4047],

Cell["\<\
You can replace names of functions using transformation rules. \
\>", "MathCaption",
 CellID->13785],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], "+", 
   RowBox[{"f", "[", 
    RowBox[{"1", "-", "x"}], "]"}]}], "/.", 
  RowBox[{"f", "->", "g"}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->23231],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", 
   RowBox[{"1", "-", "x"}], "]"}], "+", 
  RowBox[{"g", "[", "x", "]"}]}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->7406]
}, Open  ]],

Cell["Any assignments you have made are used on function names. ", \
"MathCaption",
 CellID->8684],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"p1", "=", "p2"}], ";", 
  RowBox[{"p1", "[", 
   RowBox[{"x", ",", "y"}], "]"}]}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->21954],

Cell[BoxData[
 RowBox[{"p2", "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->16769]
}, Open  ]],

Cell["\<\
This defines a function which takes a function name as an argument. \
\>", "MathCaption",
 CellID->14709],

Cell[BoxData[
 RowBox[{
  RowBox[{"pf", "[", 
   RowBox[{"f_", ",", "x_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], "+", 
   RowBox[{"f", "[", 
    RowBox[{"1", "-", "x"}], "]"}]}]}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->27956],

Cell[TextData[{
 "This gives ",
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 " as the function name to use. "
}], "MathCaption",
 CellID->22421],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pf", "[", 
  RowBox[{"Log", ",", "q"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->15945],

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", 
   RowBox[{"1", "-", "q"}], "]"}], "+", 
  RowBox[{"Log", "[", "q", "]"}]}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->13465]
}, Open  ]],

Cell[TextData[{
 "The ability to treat the names of functions just like other kinds of \
expressions is an important consequence of the symbolic nature of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language. It makes possible the whole range of ",
 StyleBox["functional operations",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->16016],

Cell[TextData[{
 "Ordinary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions such as ",
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " typically operate on data such as numbers and algebraic expressions. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions that represent functional operations, however, can operate not \
only on ordinary data, but also on functions themselves. Thus, for example, \
the functional operation ",
 Cell[BoxData[
  ButtonBox["InverseFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFunction"]], "InlineFormula"],
 " takes a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function name as an argument, and represents the inverse of that function. \
"
}], "Text",
 CellID->21860],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFunction"]], "InlineFormula"],
 " is a functional operation: it takes a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function as an argument, and returns another function which represents its \
inverse. "
}], "MathCaption",
 CellID->16497],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFunction", "[", "ArcSin", "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->18335],

Cell[BoxData["Sin"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->5190]
}, Open  ]],

Cell[TextData[{
 "The result obtained from ",
 Cell[BoxData[
  ButtonBox["InverseFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFunction"]], "InlineFormula"],
 " is a function which you can apply to data. "
}], "MathCaption",
 CellID->5677],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "[", "x", "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->28049],

Cell[BoxData[
 RowBox[{"Sin", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->21005]
}, Open  ]],

Cell[TextData[{
 "You can also use ",
 Cell[BoxData[
  ButtonBox["InverseFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFunction"]], "InlineFormula"],
 " in a purely symbolic way. "
}], "MathCaption",
 CellID->7886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "[", "f", "]"}], "[", "x", "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->23388],

Cell[BoxData[
 RowBox[{
  TagBox[
   SuperscriptBox["f", 
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}]],
   InverseFunction,
   Editable->False], "[", "x", "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->18675]
}, Open  ]],

Cell[TextData[{
 "There are many kinds of functional operations in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Some represent mathematical operations; others represent various kinds of \
procedures and algorithms. "
}], "Text",
 CellID->13143],

Cell[TextData[{
 "Unless you are familiar with advanced symbolic languages, you will probably \
not recognize most of the functional operations discussed. At first, the \
operations may seem difficult to understand. But it is worth persisting. \
Functional operations provide one of the most conceptually and practically \
efficient ways to use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->17377],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->365968262],

Cell[TextData[ButtonBox["Functional Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FunctionalOperationsOverview"]], "RelatedTutorials",
 CellID->222363673]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Function Names as Expressions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Functional Operations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/FunctionalOperationsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ApplyingFunctionsRepeatedly"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 36, 13.4251928}", "context" -> "", 
    "keywords" -> {
     "arguments", "functional programming", "function names", "functions", 
      "InverseFunction", "symbolic systems"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "In an expression like f[x], the 'function name' f is itself an \
expression, and you can treat it as you would any other expression. You can \
replace names of functions using transformation rules. Any assignments you \
have made are used on function names. ", "synonyms" -> {"2.2.1"}, "title" -> 
    "Function Names as Expressions", "type" -> "Tutorial", "uri" -> 
    "tutorial/FunctionNamesAsExpressions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.2.1"->{
  Cell[1263, 43, 92, 2, 70, "Title",
   CellTags->{"S2.2.1", "1.1"},
   CellID->29091]},
 "1.1"->{
  Cell[1263, 43, 92, 2, 70, "Title",
   CellTags->{"S2.2.1", "1.1"},
   CellID->29091]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.2.1", 10350, 376},
 {"1.1", 10449, 380}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 638, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1263, 43, 92, 2, 70, "Title",
 CellTags->{"S2.2.1", "1.1"},
 CellID->29091],
Cell[1358, 47, 392, 12, 70, "Text",
 CellID->4047],
Cell[1753, 61, 110, 3, 70, "MathCaption",
 CellID->13785],
Cell[CellGroupData[{
Cell[1888, 68, 220, 8, 28, "Input",
 CellID->23231],
Cell[2111, 78, 256, 9, 36, "Output",
 CellID->7406]
}, Open  ]],
Cell[2382, 90, 98, 2, 70, "MathCaption",
 CellID->8684],
Cell[CellGroupData[{
Cell[2505, 96, 167, 6, 28, "Input",
 CellID->21954],
Cell[2675, 104, 206, 7, 36, "Output",
 CellID->16769]
}, Open  ]],
Cell[2896, 114, 115, 3, 70, "MathCaption",
 CellID->14709],
Cell[3014, 119, 251, 9, 70, "Input",
 CellID->27956],
Cell[3268, 130, 209, 8, 70, "MathCaption",
 CellID->22421],
Cell[CellGroupData[{
Cell[3502, 142, 120, 4, 70, "Input",
 CellID->15945],
Cell[3625, 148, 262, 9, 36, "Output",
 CellID->13465]
}, Open  ]],
Cell[3902, 160, 356, 10, 70, "Text",
 CellID->16016],
Cell[4261, 172, 955, 30, 70, "Text",
 CellID->21860],
Cell[5219, 204, 367, 11, 70, "MathCaption",
 CellID->16497],
Cell[CellGroupData[{
Cell[5611, 219, 113, 3, 70, "Input",
 CellID->18335],
Cell[5727, 224, 156, 5, 36, "Output",
 CellID->5190]
}, Open  ]],
Cell[5898, 232, 260, 8, 70, "MathCaption",
 CellID->5677],
Cell[CellGroupData[{
Cell[6183, 244, 94, 3, 70, "Input",
 CellID->28049],
Cell[6280, 249, 184, 6, 36, "Output",
 CellID->21005]
}, Open  ]],
Cell[6479, 258, 235, 8, 70, "MathCaption",
 CellID->7886],
Cell[CellGroupData[{
Cell[6739, 270, 136, 4, 70, "Input",
 CellID->23388],
Cell[6878, 276, 304, 12, 36, "Output",
 CellID->18675]
}, Open  ]],
Cell[7197, 291, 255, 7, 70, "Text",
 CellID->13143],
Cell[7455, 300, 430, 10, 70, "Text",
 CellID->17377],
Cell[CellGroupData[{
Cell[7910, 314, 72, 1, 70, "RelatedTutorialsSection",
 CellID->365968262],
Cell[7985, 317, 174, 4, 70, "RelatedTutorials",
 CellID->222363673]
}, Open  ]]
}, Open  ]],
Cell[8186, 325, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

