(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15696,        573]
NotebookOptionsPosition[     10630,        413]
NotebookOutlinePosition[     13374,        484]
CellTagsIndexPosition[     13283,        478]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functions and Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FunctionsAndProgramsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Functions and Programs\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Module" :> Documentation`HelpLookup["paclet:ref/Module"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Module\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Functions as Procedures", "Title",
 CellTags->{"S1.7.2", "2.1"},
 CellID->22482],

Cell[TextData[{
 "In many kinds of calculations, you may find yourself typing the same input \
to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " over and over again. You can save yourself a lot of typing by defining a \
",
 StyleBox["function",
  FontSlant->"Italic"],
 " that contains your input commands. "
}], "Text",
 CellID->25253],

Cell["\<\
This constructs a product of three terms, and expands out the result. \
\>", "MathCaption",
 CellID->15000],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{"Product", "[", 
   RowBox[{
    RowBox[{"x", "+", "i"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->27754],

Cell[BoxData[
 RowBox[{"6", "+", 
  RowBox[{"11", " ", "x"}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  SuperscriptBox["x", "3"]}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->289]
}, Open  ]],

Cell["This does the same thing, but with four terms. ", "MathCaption",
 CellID->32488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{"Product", "[", 
   RowBox[{
    RowBox[{"x", "+", "i"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "4"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->25215],

Cell[BoxData[
 RowBox[{"24", "+", 
  RowBox[{"50", " ", "x"}], "+", 
  RowBox[{"35", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"10", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  SuperscriptBox["x", "4"]}]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->12008]
}, Open  ]],

Cell[TextData[{
 "This defines a function ",
 Cell[BoxData["exprod"], "InlineFormula"],
 " which constructs a product of ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " terms, then expands it out. "
}], "MathCaption",
 CellID->31310],

Cell[BoxData[
 RowBox[{
  RowBox[{"exprod", "[", "n_", "]"}], ":=", 
  RowBox[{"Expand", "[", 
   RowBox[{"Product", "[", 
    RowBox[{
     RowBox[{"x", "+", "i"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->940],

Cell[TextData[{
 "Every time you use the function, it will execute the ",
 Cell[BoxData[
  ButtonBox["Product",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Product"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " operations. "
}], "MathCaption",
 CellID->27799],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"exprod", "[", "5", "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->2997],

Cell[BoxData[
 RowBox[{"120", "+", 
  RowBox[{"274", " ", "x"}], "+", 
  RowBox[{"225", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"85", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"15", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  SuperscriptBox["x", "5"]}]], "Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->9707]
}, Open  ]],

Cell[TextData[{
 "The functions you define in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are essentially procedures that execute the commands you give. You can \
have several steps in your procedures, separated by semicolons. "
}], "Text",
 CellID->8454],

Cell["\<\
The result you get from the whole function is simply the last expression in \
the procedure. Notice that you have to put parentheses around the procedure \
when you define it like this. \
\>", "MathCaption",
 CellID->304],

Cell[BoxData[
 RowBox[{
  RowBox[{"cex", "[", 
   RowBox[{"n_", ",", "i_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"t", "=", 
     RowBox[{"exprod", "[", "n", "]"}]}], ";", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"t", ",", 
      RowBox[{"x", "^", "i"}]}], "]"}]}], ")"}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->8237],

Cell["This \[OpenCurlyDoubleQuote]runs\[CloseCurlyDoubleQuote] the procedure. \
", "MathCaption",
 CellID->10485],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cex", "[", 
  RowBox[{"5", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->12499],

Cell[BoxData["85"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->30792]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], "1"], ";", 
     SubscriptBox[
      StyleBox["expr", "TI"], "2"], ";", 
     StyleBox["\[Ellipsis]", "TR"], "  "}], Cell[
    "a sequence of expressions to evaluate", "TableText"]},
   {
    RowBox[{
     ButtonBox["Module",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Module"], "[", "{", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["proc", "TI"], "]"}], Cell[TextData[{
     "a procedure with local variables ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     ", \[Ellipsis]",
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->29613],

Cell["Constructing procedures. ", "Caption",
 CellID->32612],

Cell[TextData[{
 "When you write procedures in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", it is usually a good idea to make variables you use inside the procedures \
",
 StyleBox["local",
  FontSlant->"Italic"],
 ", so that they do not interfere with things outside the procedures. You can \
do this by setting up your procedures as ",
 StyleBox["modules",
  FontSlant->"Italic"],
 ", in which you give a list of variables to be treated as local. "
}], "Text",
 CellID->18682],

Cell[TextData[{
 "The function ",
 Cell[BoxData["cex"], "InlineFormula"],
 " defined above is not a module, so the value of ",
 Cell[BoxData["t"], "InlineFormula"],
 " \[OpenCurlyDoubleQuote]escapes\[CloseCurlyDoubleQuote], and exists even \
after the function returns. "
}], "MathCaption",
 CellID->12983],

Cell[CellGroupData[{

Cell[BoxData["t"], "Input",
 CellLabel->"In[7]:= ",
 CellID->15351],

Cell[BoxData[
 RowBox[{"120", "+", 
  RowBox[{"274", " ", "x"}], "+", 
  RowBox[{"225", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"85", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"15", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  SuperscriptBox["x", "5"]}]], "Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->16129]
}, Open  ]],

Cell[TextData[{
 "This function is defined as a module with local variable ",
 Cell[BoxData["u"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->17137],

Cell[BoxData[
 RowBox[{
  RowBox[{"ncex", "[", 
   RowBox[{"n_", ",", "i_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "u", "}"}], ",", 
    RowBox[{
     RowBox[{"u", "=", 
      RowBox[{"exprod", "[", "n", "]"}]}], ";", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"u", ",", 
       RowBox[{"x", "^", "i"}]}], "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->5033],

Cell["The function gives the same result as before. ", "MathCaption",
 CellID->16600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ncex", "[", 
  RowBox[{"5", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->31864],

Cell[BoxData["85"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->23683]
}, Open  ]],

Cell[TextData[{
 "Now, however, the value of ",
 Cell[BoxData["u"], "InlineFormula"],
 " does not escape from the function. "
}], "MathCaption",
 CellID->11857],

Cell[CellGroupData[{

Cell[BoxData["u"], "Input",
 CellLabel->"In[10]:= ",
 CellID->8968],

Cell[BoxData["u"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->1710]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->373776613],

Cell[TextData[ButtonBox["Functions and Programs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FunctionsAndProgramsOverview"]], "RelatedTutorials",
 CellID->1392681]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Functions as Procedures - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Functions and Programs", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/FunctionsAndProgramsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DefiningFunctions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/RepetitiveOperations"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 36, 14.2377136}", "context" -> "", 
    "keywords" -> {
     "blocks", "compound expressions", "local variables", "module", 
      "procedures", "programs", "scoping", "semicolon"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "In many kinds of calculations, you may find yourself typing the same \
input to Mathematica over and over again. You can save yourself a lot of \
typing by defining a function that contains your input commands. This \
constructs a product of three terms, and expands out the result. This does \
the same thing, but with four terms. ", "synonyms" -> {"1.7.2"}, "title" -> 
    "Functions as Procedures", "type" -> "Tutorial", "uri" -> 
    "tutorial/FunctionsAsProcedures"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.7.2"->{
  Cell[1805, 58, 86, 2, 70, "Title",
   CellTags->{"S1.7.2", "2.1"},
   CellID->22482]},
 "2.1"->{
  Cell[1805, 58, 86, 2, 70, "Title",
   CellTags->{"S1.7.2", "2.1"},
   CellID->22482]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.7.2", 13072, 467},
 {"2.1", 13171, 471}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1180, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1805, 58, 86, 2, 70, "Title",
 CellTags->{"S1.7.2", "2.1"},
 CellID->22482],
Cell[1894, 62, 344, 11, 70, "Text",
 CellID->25253],
Cell[2241, 75, 117, 3, 70, "MathCaption",
 CellID->15000],
Cell[CellGroupData[{
Cell[2383, 82, 233, 8, 28, "Input",
 CellID->27754],
Cell[2619, 92, 292, 10, 36, "Output",
 CellID->289]
}, Open  ]],
Cell[2926, 105, 86, 1, 70, "MathCaption",
 CellID->32488],
Cell[CellGroupData[{
Cell[3037, 110, 233, 8, 28, "Input",
 CellID->25215],
Cell[3273, 120, 355, 12, 36, "Output",
 CellID->12008]
}, Open  ]],
Cell[3643, 135, 248, 8, 70, "MathCaption",
 CellID->31310],
Cell[3894, 145, 304, 10, 70, "Input",
 CellID->940],
Cell[4201, 157, 367, 13, 70, "MathCaption",
 CellID->27799],
Cell[CellGroupData[{
Cell[4593, 174, 98, 3, 70, "Input",
 CellID->2997],
Cell[4694, 179, 416, 14, 36, "Output",
 CellID->9707]
}, Open  ]],
Cell[5125, 196, 266, 7, 70, "Text",
 CellID->8454],
Cell[5394, 205, 231, 5, 70, "MathCaption",
 CellID->304],
Cell[5628, 212, 346, 12, 70, "Input",
 CellID->8237],
Cell[5977, 226, 113, 2, 70, "MathCaption",
 CellID->10485],
Cell[CellGroupData[{
Cell[6115, 232, 119, 4, 70, "Input",
 CellID->12499],
Cell[6237, 238, 156, 5, 36, "Output",
 CellID->30792]
}, Open  ]],
Cell[6408, 246, 1104, 35, 70, "DefinitionBox",
 CellID->29613],
Cell[7515, 283, 60, 1, 70, "Caption",
 CellID->32612],
Cell[7578, 286, 489, 14, 70, "Text",
 CellID->18682],
Cell[8070, 302, 306, 8, 70, "MathCaption",
 CellID->12983],
Cell[CellGroupData[{
Cell[8401, 314, 67, 2, 70, "Input",
 CellID->15351],
Cell[8471, 318, 417, 14, 36, "Output",
 CellID->16129]
}, Open  ]],
Cell[8903, 335, 156, 5, 70, "MathCaption",
 CellID->17137],
Cell[9062, 342, 412, 14, 70, "Input",
 CellID->5033],
Cell[9477, 358, 85, 1, 70, "MathCaption",
 CellID->16600],
Cell[CellGroupData[{
Cell[9587, 363, 120, 4, 70, "Input",
 CellID->31864],
Cell[9710, 369, 156, 5, 36, "Output",
 CellID->23683]
}, Open  ]],
Cell[9881, 377, 160, 5, 70, "MathCaption",
 CellID->11857],
Cell[CellGroupData[{
Cell[10066, 386, 67, 2, 70, "Input",
 CellID->8968],
Cell[10136, 390, 155, 5, 36, "Output",
 CellID->1710]
}, Open  ]],
Cell[CellGroupData[{
Cell[10328, 400, 72, 1, 70, "RelatedTutorialsSection",
 CellID->373776613],
Cell[10403, 403, 173, 4, 70, "RelatedTutorials",
 CellID->1392681]
}, Open  ]]
}, Open  ]],
Cell[10603, 411, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

