(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     72452,       1762]
NotebookOptionsPosition[     65814,       1562]
NotebookOutlinePosition[     69384,       1645]
CellTagsIndexPosition[     69291,       1639]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicalFunctionsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Mathematical Functions\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ArcCos" :> Documentation`HelpLookup["paclet:ref/ArcCos"], 
          "ArcCosh" :> Documentation`HelpLookup["paclet:ref/ArcCosh"], 
          "ArcCot" :> Documentation`HelpLookup["paclet:ref/ArcCot"], 
          "ArcCoth" :> Documentation`HelpLookup["paclet:ref/ArcCoth"], 
          "ArcCsc" :> Documentation`HelpLookup["paclet:ref/ArcCsc"], 
          "ArcCsch" :> Documentation`HelpLookup["paclet:ref/ArcCsch"], 
          "ArcSec" :> Documentation`HelpLookup["paclet:ref/ArcSec"], 
          "ArcSech" :> Documentation`HelpLookup["paclet:ref/ArcSech"], 
          "ArcSin" :> Documentation`HelpLookup["paclet:ref/ArcSin"], 
          "ArcSinh" :> Documentation`HelpLookup["paclet:ref/ArcSinh"], 
          "ArcTan" :> Documentation`HelpLookup["paclet:ref/ArcTan"], 
          "ArcTanh" :> Documentation`HelpLookup["paclet:ref/ArcTanh"], "Exp" :> 
          Documentation`HelpLookup["paclet:ref/Exp"], "Log" :> 
          Documentation`HelpLookup["paclet:ref/Log"], "Re" :> 
          Documentation`HelpLookup["paclet:ref/Re"], "Sqrt" :> 
          Documentation`HelpLookup["paclet:ref/Sqrt"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ArcCos\"\>", 2->"\<\"ArcCosh\"\>", 
       3->"\<\"ArcCot\"\>", 4->"\<\"ArcCoth\"\>", 5->"\<\"ArcCsc\"\>", 
       6->"\<\"ArcCsch\"\>", 7->"\<\"ArcSec\"\>", 8->"\<\"ArcSech\"\>", 
       9->"\<\"ArcSin\"\>", 10->"\<\"ArcSinh\"\>", 11->"\<\"ArcTan\"\>", 
       12->"\<\"ArcTanh\"\>", 13->"\<\"Exp\"\>", 14->"\<\"Log\"\>", 
       15->"\<\"Re\"\>", 16->"\<\"Sqrt\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Functions That Do Not Have Unique Values", "Title",
 CellTags->{"S3.2.8", "8.1"},
 CellID->21968],

Cell[TextData[{
 "When you ask for the square root ",
 Cell[BoxData[
  FormBox["s", TraditionalForm]], "InlineMath"],
 " of a number ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 ", you are effectively asking for the solution to the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["s", "2"], "=", "a"}], TraditionalForm]], "InlineMath"],
 ". This equation, however, in general has two different solutions. Both ",
 Cell[BoxData[
  FormBox[
   RowBox[{"s", "=", "2"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"s", "=", 
    RowBox[{"-", "2"}]}], TraditionalForm]], "InlineMath"],
 " are, for example, solutions to the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["s", "2"], "=", "4"}], TraditionalForm]], "InlineMath"],
 ". When you evaluate the \[OpenCurlyDoubleQuote]function\
\[CloseCurlyDoubleQuote] ",
 Cell[BoxData[
  FormBox[
   SqrtBox["4"], TraditionalForm]], "InlineMath"],
 ", however, you usually want to get a single number, and so you have to \
choose one of these two solutions. A standard choice is that ",
 Cell[BoxData[
  FormBox[
   SqrtBox["x"], TraditionalForm]], "InlineMath"],
 " should be positive for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ">", "0"}], TraditionalForm]], "InlineMath"],
 ". This is what the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sqrt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sqrt"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " does."
}], "Text",
 CellID->31708],

Cell[TextData[{
 "The need to make one choice from two solutions means that ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sqrt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sqrt"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " cannot be a true ",
 StyleBox["inverse function",
  FontSlant->"Italic"],
 " for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "^", "2"}]], "InlineFormula"],
 ". Taking a number, squaring it, and then taking the square root can give \
you a different number than you started with. "
}], "Text",
 CellID->2641],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SqrtBox["4"], TraditionalForm]], "InlineMath"],
 " gives ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "2"}], TraditionalForm]], "InlineMath"],
 ", not ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "2"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->27732],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", "4", "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->12437],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->11684]
}, Open  ]],

Cell["\<\
Squaring and taking the square root does not necessarily give you the number \
you started with. \
\>", "MathCaption",
 CellID->32499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"-", "2"}], ")"}], "^", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->32701],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->29869]
}, Open  ]],

Cell[TextData[{
 "When you evaluate ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{
     RowBox[{"-", "2"}], "i"}]], TraditionalForm]], "InlineMath"],
 ", there are again two possible answers: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "1"}], "+", "i"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "-", "i"}], TraditionalForm]], "InlineMath"],
 ". In this case, however, it is less clear which one to choose. "
}], "Text",
 CellID->28583],

Cell[TextData[{
 "There is in fact no way to choose ",
 Cell[BoxData[
  FormBox[
   SqrtBox["z"], TraditionalForm]], "InlineMath"],
 " so that it is continuous for all complex values of ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 ". There has to be a \[OpenCurlyDoubleQuote]branch cut\
\[CloseCurlyDoubleQuote]\[LongDash]a line in the complex plane across which \
the function ",
 Cell[BoxData[
  FormBox[
   SqrtBox["z"], TraditionalForm]], "InlineMath"],
 " is discontinuous. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " adopts the usual convention of taking the branch cut for ",
 Cell[BoxData[
  FormBox[
   SqrtBox["z"], TraditionalForm]], "InlineMath"],
 " to be along the negative real axis."
}], "Text",
 CellID->29256],

Cell[TextData[{
 "This gives ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "-", "i"}], TraditionalForm]], "InlineMath"],
 ", not ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "1"}], "+", "i"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->19692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{"-", "2"}], " ", "I"}], "]"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->7640],

Cell[BoxData[
 RowBox[{"1.`", "\[InvisibleSpace]", "-", 
  RowBox[{"1.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->452849139]
}, Open  ]],

Cell[TextData[{
 "The branch cut in ",
 Cell[BoxData[
  ButtonBox["Sqrt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sqrt"]], "InlineFormula"],
 " along the negative real axis means that values of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sqrt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sqrt"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " just above and below the axis are very different. "
}], "MathCaption",
 CellID->15012],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     RowBox[{"0.1", " ", "I"}]}], "]"}], ",", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"-", "2"}], "-", 
     RowBox[{"0.1", " ", "I"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->13810],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.03534430258244289`", "\[InvisibleSpace]", "+", 
    RowBox[{"1.4146551592967944`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.03534430258244289`", "\[InvisibleSpace]", "-", 
    RowBox[{"1.4146551592967944`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{301, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->5820]
}, Open  ]],

Cell["Their squares are nevertheless close. ", "MathCaption",
 CellID->14835],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "^", "2"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->1663],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.9999999999999996`"}], "+", 
    RowBox[{"0.09999999999999969`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.9999999999999996`"}], "-", 
    RowBox[{"0.09999999999999969`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{162, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->10615]
}, Open  ]],

Cell["\<\
The discontinuity along the negative real axis is quite clear in this three\
\[Hyphen]dimensional picture of the imaginary part of the square root \
function. \
\>", "MathCaption",
 CellID->25897],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->18677],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->644949092]
}, Open  ]],

Cell[TextData[{
 "When you find an ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " root using ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["z", 
    RowBox[{"1", "/", "n"}]], TraditionalForm]], "InlineMath"],
 ", there are, in principle, ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " possible results. To get a single value, you have to choose a particular \
",
 StyleBox["principal root",
  FontSlant->"Italic"],
 ". There is absolutely no guarantee that taking the ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " root of an ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " power will leave you with the same number. "
}], "Text",
 CellID->10134],

Cell["\<\
This takes the tenth power of a complex number. The result is unique. \
\>", "MathCaption",
 CellID->27553],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"2.5", "+", "I"}], ")"}], "^", "10"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->19533],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "15781.1513671875`"}], "-", 
  RowBox[{"12335.83984375`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{138, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->28878]
}, Open  ]],

Cell[TextData[{
 "There are ten possible tenth roots. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " chooses one of them. In this case it is not the number whose tenth power \
you took. "
}], "MathCaption",
 CellID->2286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "^", 
  RowBox[{"(", 
   RowBox[{"1", "/", "10"}], ")"}]}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->25624],

Cell[BoxData[
 RowBox[{"2.610327738229842`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.6604461363562355`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->2734]
}, Open  ]],

Cell[TextData[{
 "There are many mathematical functions which, like roots, essentially give \
solutions to equations. The logarithm function and the inverse trigonometric \
functions are examples. In almost all cases, there are many possible \
solutions to the equations. Unique \[OpenCurlyDoubleQuote]principal\
\[CloseCurlyDoubleQuote] values nevertheless have to be chosen for the \
functions. The choices cannot be made continuous over the whole complex \
plane. Instead, lines of discontinuity, or branch cuts, must occur. The \
positions of these branch cuts are often quite arbitrary. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " makes the most standard mathematical choices for them."
}], "Text",
 CellID->18075],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     RowBox[{
      ButtonBox["Sqrt",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Sqrt"], "[", 
      StyleBox["z", "TI"], "]"}], Cell[
     " \[ThinSpace]and \[ThinSpace]", "TableText"], 
     RowBox[{
      StyleBox["z", "TI"], "^", 
      StyleBox["s", "TI"]}]}], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "\[Infinity]"}], ",", "0"}], ")"}], TraditionalForm]], 
      "InlineMath"],
     " for ",
     Cell[BoxData[
      ButtonBox["Re",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Re"]], "InlineFormula"],
     " ",
     Cell[BoxData[
      FormBox[
       RowBox[{"s", ">", "0"}], TraditionalForm]], "InlineMath"],
     ", ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "\[Infinity]"}], ",", "0"}]}], "]"}], 
       TraditionalForm]], "InlineMath"],
     " for ",
     Cell[BoxData[
      ButtonBox["Re",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Re"]], "InlineFormula"],
     " ",
     Cell[BoxData[
      FormBox[
       RowBox[{"s", "\[LessEqual]", "0"}], TraditionalForm]], "InlineMath"],
     " (",
     Cell[BoxData[
      FormBox["s", TraditionalForm]], "InlineMath"],
     " not an integer)"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Exp",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Exp"], "[", 
     StyleBox["z", "TI"], "]"}], Cell["none", "TableText"]},
   {
    RowBox[{
     ButtonBox["Log",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Log"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[Cell[BoxData[
     FormBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "\[Infinity]"}], ",", "0"}]}], "]"}], TraditionalForm]],
      "InlineMath"]], "TableText"]},
   {Cell["trigonometric functions", "TableText"], Cell["none", "TableText"]},
   {
    RowBox[{
     ButtonBox["ArcSin",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcSin"], "[", 
     StyleBox["z", "TI"], "]", Cell[
     " \[ThinSpace]and \[ThinSpace]", "TableText"], 
     ButtonBox["ArcCos",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcCos"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "\[Infinity]"}], ",", 
         RowBox[{"-", "1"}]}], ")"}], TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"+", "1"}], ",", 
         RowBox[{"+", "\[Infinity]"}]}], ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ArcTan",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcTan"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "i"}], "\[InvisibleSpace]", "\[Infinity]"}], ",", 
         RowBox[{"-", "i"}]}], "]"}], TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        RowBox[{"i", ",", 
         RowBox[{"i", "\[InvisibleSpace]", "\[Infinity]"}]}], "]"}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ArcCsc",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcCsc"], "[", 
     StyleBox["z", "TI"], "]", Cell[
     " \[ThinSpace]and \[ThinSpace]", "TableText"], 
     ButtonBox["ArcSec",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcSec"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[Cell[BoxData[
     FormBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"+", "1"}]}], ")"}], TraditionalForm]], "InlineMath"]], 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["ArcCot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcCot"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[Cell[BoxData[
     FormBox[
      RowBox[{"[", 
       RowBox[{
        RowBox[{"-", "i"}], ",", 
        RowBox[{"+", "i"}]}], "]"}], TraditionalForm]], "InlineMath"]], 
     "TableText"]},
   {Cell["hyperbolic functions", "TableText"], Cell["none", "TableText"]},
   {
    RowBox[{
     ButtonBox["ArcSinh",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcSinh"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "i"}], "\[InvisibleSpace]", "\[Infinity]"}], ",", 
         RowBox[{"-", "i"}]}], ")"}], TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"+", "i"}], ",", 
         RowBox[{
          RowBox[{"+", "i"}], "\[InvisibleSpace]", "\[Infinity]"}]}], ")"}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ArcCosh",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcCosh"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[Cell[BoxData[
     FormBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "\[Infinity]"}], ",", 
        RowBox[{"+", "1"}]}], ")"}], TraditionalForm]], "InlineMath"]], 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["ArcTanh",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcTanh"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "\[Infinity]"}], ",", 
          RowBox[{"-", "1"}]}]}], "]"}], TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"[", 
         RowBox[{
          RowBox[{"+", "1"}], ",", 
          RowBox[{"+", "\[Infinity]"}]}]}], ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ArcCsch",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcCsch"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[Cell[BoxData[
     FormBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "i"}], ",", "i"}], ")"}], TraditionalForm]], 
     "InlineMath"]], "TableText"]},
   {
    RowBox[{
     ButtonBox["ArcSech",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcSech"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "\[Infinity]"}], ",", "0"}]}], "]"}], 
       TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"+", "1"}], ",", 
         RowBox[{"+", "\[Infinity]"}]}], ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ArcCoth",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcCoth"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[Cell[BoxData[
     FormBox[
      RowBox[{"[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"+", "1"}]}], "]"}], TraditionalForm]], "InlineMath"]], 
     "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, False, 
     False, False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->15349],

Cell["\<\
Some branch\[Hyphen]cut discontinuities in the complex plane.\
\>", "Caption",
 CellID->30712],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcSin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSin"]], "InlineFormula"],
 " is a multiple\[Hyphen]valued function, so there is no guarantee that it \
always gives the \[OpenCurlyDoubleQuote]inverse\[CloseCurlyDoubleQuote] of ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->26984],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSin", "[", 
  RowBox[{"Sin", "[", "4.5", "]"}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->30624],

Cell[BoxData[
 RowBox[{"-", "1.3584073464102064`"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->27792]
}, Open  ]],

Cell[TextData[{
 "Values of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArcSin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcSin"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " on opposite sides of the branch cut can be very different. "
}], "MathCaption",
 CellID->6504],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArcSin", "[", 
    RowBox[{"2", "+", 
     RowBox[{"0.1", " ", "I"}]}], "]"}], ",", 
   RowBox[{"ArcSin", "[", 
    RowBox[{"2", "-", 
     RowBox[{"0.1", " ", "I"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->28822],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1.5131571227434844`", "\[InvisibleSpace]", "+", 
    RowBox[{"1.3188765472109005`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.5131571227434844`", "\[InvisibleSpace]", "-", 
    RowBox[{"1.3188765472109005`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{273, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->4055]
}, Open  ]],

Cell[TextData[{
 "A three\[Hyphen]dimensional picture, showing the two branch cuts for the \
function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["sin", 
     RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->18913],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"ArcSin", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->462],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->241432268]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->361613967],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/MathematicalFunctionsOverview"]], "RelatedTutorials",
 CellID->13333267]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Functions That Do Not Have Unique Values - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Mathematical Functions", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/MathematicalFunctionsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ElementaryTranscendentalFunctions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/MathematicalConstants"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 36, 16.7377776}", "context" -> "", 
    "keywords" -> {
     "branch cuts", "complex functions", "complex numbers", "discontinuities",
       "functions", "inverse trigonometric functions", 
      "jumps in complex functions", "logarithms", "multiple-valued functions",
       "multivalued functions", "powers", "principal roots", "radicals", 
      "Riemann sheets", "roots", "roots of complex numbers", 
      "roots of negative numbers", "sheets", "square roots"}, "index" -> True,
     "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "When you ask for the square root s of a number a, you are effectively \
asking for the solution to the equation s^2=a. This equation, however, in \
general has two different solutions. Both s=2 and s=-2 are, for example, \
solutions to the equation s^2=4. When you evaluate the 'function' SqrtBox[4], \
however, you usually want to get a single number, and so you have to choose \
one of these two solutions. A standard choice is that SqrtBox[x] should be \
positive for x>0. This is what the Mathematica function Sqrt[x] does. The \
need to make one choice from two solutions means that Sqrt[x] cannot be a \
true inverse function for x^2. Taking a number, squaring it, and then taking \
the square root can give you a different number than you started with. \
SqrtBox[4] gives +2, not -2. ", "synonyms" -> {"3.2.8"}, "title" -> 
    "Functions That Do Not Have Unique Values", "type" -> "Tutorial", "uri" -> 
    "tutorial/FunctionsThatDoNotHaveUniqueValues"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.2.8"->{
  Cell[3191, 77, 103, 2, 70, "Title",
   CellTags->{"S3.2.8", "8.1"},
   CellID->21968]},
 "8.1"->{
  Cell[3191, 77, 103, 2, 70, "Title",
   CellTags->{"S3.2.8", "8.1"},
   CellID->21968]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.2.8", 69078, 1628},
 {"8.1", 69178, 1632}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2566, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3191, 77, 103, 2, 70, "Title",
 CellTags->{"S3.2.8", "8.1"},
 CellID->21968],
Cell[3297, 81, 1611, 52, 70, "Text",
 CellID->31708],
Cell[4911, 135, 560, 18, 70, "Text",
 CellID->2641],
Cell[5474, 155, 322, 14, 70, "MathCaption",
 CellID->27732],
Cell[CellGroupData[{
Cell[5821, 173, 97, 3, 28, "Input",
 CellID->12437],
Cell[5921, 178, 155, 5, 36, "Output",
 CellID->11684]
}, Open  ]],
Cell[6091, 186, 144, 4, 70, "MathCaption",
 CellID->32499],
Cell[CellGroupData[{
Cell[6260, 194, 164, 6, 28, "Input",
 CellID->32701],
Cell[6427, 202, 155, 5, 36, "Output",
 CellID->29869]
}, Open  ]],
Cell[6597, 210, 502, 18, 70, "Text",
 CellID->28583],
Cell[7102, 230, 761, 23, 70, "Text",
 CellID->29256],
Cell[7866, 255, 279, 12, 70, "MathCaption",
 CellID->19692],
Cell[CellGroupData[{
Cell[8170, 271, 167, 6, 70, "Input",
 CellID->7640],
Cell[8340, 279, 240, 7, 36, "Output",
 CellID->452849139]
}, Open  ]],
Cell[8595, 289, 532, 18, 70, "MathCaption",
 CellID->15012],
Cell[CellGroupData[{
Cell[9152, 311, 324, 12, 70, "Input",
 CellID->13810],
Cell[9479, 325, 441, 12, 36, "Output",
 CellID->5820]
}, Open  ]],
Cell[9935, 340, 77, 1, 70, "MathCaption",
 CellID->14835],
Cell[CellGroupData[{
Cell[10037, 345, 88, 3, 70, "Input",
 CellID->1663],
Cell[10128, 350, 440, 14, 36, "Output",
 CellID->10615]
}, Open  ]],
Cell[10583, 367, 206, 5, 70, "MathCaption",
 CellID->25897],
Cell[CellGroupData[{
Cell[10814, 376, 408, 14, 28, "Input",
 CellID->18677],
Cell[11225, 392, 17871, 297, 172, "Output",
 Evaluatable->False,
 CellID->644949092]
}, Open  ]],
Cell[29111, 692, 984, 33, 70, "Text",
 CellID->10134],
Cell[30098, 727, 117, 3, 70, "MathCaption",
 CellID->27553],
Cell[CellGroupData[{
Cell[30240, 734, 139, 5, 70, "Input",
 CellID->19533],
Cell[30382, 741, 261, 8, 36, "Output",
 CellID->28878]
}, Open  ]],
Cell[30658, 752, 229, 7, 70, "MathCaption",
 CellID->2286],
Cell[CellGroupData[{
Cell[30912, 763, 137, 5, 70, "Input",
 CellID->25624],
Cell[31052, 770, 268, 7, 36, "Output",
 CellID->2734]
}, Open  ]],
Cell[31335, 780, 730, 13, 70, "Text",
 CellID->18075],
Cell[32068, 795, 7686, 258, 70, "DefinitionBox",
 CellID->15349],
Cell[39757, 1055, 104, 3, 70, "Caption",
 CellID->30712],
Cell[39864, 1060, 435, 13, 70, "MathCaption",
 CellID->26984],
Cell[CellGroupData[{
Cell[40324, 1077, 131, 4, 70, "Input",
 CellID->30624],
Cell[40458, 1083, 190, 6, 36, "Output",
 CellID->27792]
}, Open  ]],
Cell[40663, 1092, 294, 10, 70, "MathCaption",
 CellID->6504],
Cell[CellGroupData[{
Cell[40982, 1106, 287, 10, 70, "Input",
 CellID->28822],
Cell[41272, 1118, 440, 12, 36, "Output",
 CellID->4055]
}, Open  ]],
Cell[41727, 1133, 287, 10, 70, "MathCaption",
 CellID->18913],
Cell[CellGroupData[{
Cell[42039, 1147, 408, 14, 28, "Input",
 CellID->462],
Cell[42450, 1163, 23023, 381, 173, "Output",
 Evaluatable->False,
 CellID->241432268]
}, Open  ]],
Cell[CellGroupData[{
Cell[65510, 1549, 72, 1, 70, "RelatedTutorialsSection",
 CellID->361613967],
Cell[65585, 1552, 175, 4, 70, "RelatedTutorials",
 CellID->13333267]
}, Open  ]]
}, Open  ]],
Cell[65787, 1560, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

