(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21964,        761]
NotebookOptionsPosition[     16502,        596]
NotebookOutlinePosition[     19564,        672]
CellTagsIndexPosition[     19473,        666]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/PatternsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Patterns\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Longest" :> Documentation`HelpLookup["paclet:ref/Longest"], 
          "Shortest" :> Documentation`HelpLookup["paclet:ref/Shortest"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Longest\"\>", 
       2->"\<\"Shortest\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Functions with Variable Numbers of Arguments", "Title",
 CellTags->{"S2.3.8", "8.1"},
 CellID->17118],

Cell[TextData[{
 "Unless ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is a flat function, a pattern like ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    StyleBox[
     RowBox[{
      StyleBox["x", "TI"], "_"}]], ",", 
    StyleBox[
     RowBox[{
      StyleBox["y", "TI"], "_"}]]}], "]"}]], "InlineFormula"],
 " stands only for instances of the function with exactly two arguments. \
Sometimes you need to set up patterns that can allow any number of arguments. \
"
}], "Text",
 CellID->25668],

Cell[TextData[{
 "You can do this using ",
 StyleBox["multiple blanks",
  FontSlant->"Italic"],
 ". While a single blank such as ",
 Cell[BoxData["x_"], "InlineFormula"],
 " stands for a single ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression, a double blank such as ",
 Cell[BoxData["x__"], "InlineFormula"],
 " stands for a sequence of one or more expressions. "
}], "Text",
 CellID->10006],

Cell[TextData[{
 "Here ",
 Cell[BoxData["x__"], "InlineFormula"],
 " stands for the sequence of expressions ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{"a", ",", "b", ",", "c"}], ")"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->9729],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}], "/.", 
  RowBox[{
   RowBox[{"f", "[", "x__", "]"}], "->", 
   RowBox[{"p", "[", 
    RowBox[{"x", ",", "x", ",", "x"}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24008],

Cell[BoxData[
 RowBox[{"p", "[", 
  RowBox[{
  "a", ",", "b", ",", "c", ",", "a", ",", "b", ",", "c", ",", "a", ",", "b", 
   ",", "c"}], "]"}]], "Output",
 ImageSize->{178, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->329159578]
}, Open  ]],

Cell[TextData[{
 "Here is a more complicated definition, which picks out pairs of duplicated \
elements in ",
 Cell[BoxData["h"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->225],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", 
   RowBox[{"a___", ",", "x_", ",", "b___", ",", "x_", ",", "c___"}], "]"}], ":=",
   
  RowBox[{
   RowBox[{"hh", "[", "x", "]"}], " ", 
   RowBox[{"h", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15536],

Cell["\<\
The definition is applied twice, picking out the two paired elements. \
\>", "MathCaption",
 CellID->11980],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "[", 
  RowBox[{"2", ",", "3", ",", "2", ",", "4", ",", "5", ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->716],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", 
   RowBox[{"4", ",", "5"}], "]"}], " ", 
  RowBox[{"hh", "[", "2", "]"}], " ", 
  RowBox[{"hh", "[", "3", "]"}]}]], "Output",
 ImageSize->{127, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->42319829]
}, Open  ]],

Cell[TextData[{
 "\[OpenCurlyDoubleQuote]Double blanks\[CloseCurlyDoubleQuote] ",
 Cell[BoxData["__"], "InlineFormula"],
 " stand for sequences of one or more expressions. \
\[OpenCurlyDoubleQuote]Triple blanks\[CloseCurlyDoubleQuote] ",
 Cell[BoxData["___"], "InlineFormula"],
 " stand for sequences of zero or more expressions. You should be very \
careful whenever you use triple blank patterns. It is easy to make a mistake \
that can lead to an infinite loop. For example, if you define ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"p", "[", 
    RowBox[{"x_", ",", "y___"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"p", "[", "x", "]"}], " ", 
    RowBox[{"q", "[", "y", "]"}]}]}]], "InlineFormula"],
 ", then typing in ",
 Cell[BoxData[
  RowBox[{"p", "[", "a", "]"}]], "InlineFormula"],
 " will lead to an infinite loop, with ",
 Cell[BoxData["y"], "InlineFormula"],
 " repeatedly matching a sequence with zero elements. Unless you are sure you \
want to include the case of zero elements, you should always use double \
blanks rather than triple blanks. "
}], "Text",
 CellID->15384],

Cell[BoxData[GridBox[{
   {"_", Cell["any single expression", "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], 
     StyleBox["_", "MR"]}], Cell[TextData[{
     "any single expression, to be named ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {"__", Cell["any sequence of one or more expressions", "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], 
     StyleBox["__", "MR"]}], Cell[TextData[{
     "sequence named ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], 
     StyleBox["__", "MR"], 
     StyleBox["h", "TI"]}], Cell[TextData[{
     "sequence of expressions, all of whose heads are\[NonBreakingSpace]",
     StyleBox["h", "TI"]
    }], "TableText"]},
   {"___", Cell["any sequence of zero or more expressions", "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], 
     StyleBox["___", "MR"]}], Cell[TextData[{
     "sequence of zero or more expressions named ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], 
     StyleBox["___", "MR"], 
     StyleBox["h", "TI"]}], Cell[TextData[{
     "sequence of zero or more expressions, all of whose heads are\
\[NonBreakingSpace]",
     StyleBox["h", "TI"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->28747],

Cell["More kinds of pattern objects. ", "Caption",
 CellID->20328],

Cell[TextData[{
 "Notice that with flat functions such as ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically handles variable numbers of arguments, so you do not \
explicitly need to use double or triple blanks, as discussed in \"",
 ButtonBox["Flat and Orderless Functions\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/FlatAndOrderlessFunctions"],
 ". "
}], "Text",
 CellID->27936],

Cell[TextData[{
 "When you use multiple blanks, there are often several matches that are \
possible for a particular expression. By default, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " tries first those matches that assign the shortest sequences of arguments \
to the first multiple blanks that appear in the pattern. You can change this \
order by wrapping ",
 Cell[BoxData[
  ButtonBox["Longest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Longest"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Shortest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Shortest"]], "InlineFormula"],
 " around parts of the pattern."
}], "Text",
 CellID->6204],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Longest",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Longest"], "[", 
     StyleBox["p", "TI"], "]"}], Cell[TextData[{
     "match the longest sequence consistent with the pattern ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     "."
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Shortest",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Shortest"], "[", 
     StyleBox["p", "TI"], "]"}], Cell[TextData[{
     "match the shortest sequence consistent with the pattern ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     "."
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->53689283],

Cell["Controlling the order in which matches are tried.", "Caption",
 CellID->105237499],

Cell[TextData[{
 "This gives a list of all the matches that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " tries. "
}], "MathCaption",
 CellID->10700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplaceList", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], ",", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"x__", ",", "y__"}], "]"}], "->", 
    RowBox[{"g", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{"{", "y", "}"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->7523],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"{", "a", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "c", ",", "d"}], "}"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", "d", "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{373, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->124137544]
}, Open  ]],

Cell[TextData[{
 "This forces ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to try the longest matches for ",
 Cell[BoxData[
  StyleBox["x__", "TI"]], "InlineFormula"],
 " first. "
}], "MathCaption",
 CellID->531919713],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplaceList", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], ",", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{
      RowBox[{"Longest", "[", "x__", "]"}], ",", "y__"}], "]"}], "->", 
    RowBox[{"g", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{"{", "y", "}"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->58005111],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", "d", "}"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"{", "a", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "c", ",", "d"}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{373, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->683021416]
}, Open  ]],

Cell[TextData[{
 "Many kinds of enumeration can be done by using ",
 Cell[BoxData[
  ButtonBox["ReplaceList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceList"]], "InlineFormula"],
 " with various kinds of patterns. "
}], "MathCaption",
 CellID->1411],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplaceList", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], ",", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"___", ",", "x__"}], "]"}], "->", 
    RowBox[{"g", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->16040],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"b", ",", "c", ",", "d"}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"c", ",", "d"}], "]"}], ",", 
   RowBox[{"g", "[", "d", "]"}]}], "}"}]], "Output",
 ImageSize->{273, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->353961626]
}, Open  ]],

Cell["\<\
This effectively enumerates all sublists with at least one element. \
\>", "MathCaption",
 CellID->11504],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplaceList", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], ",", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"___", ",", "x__", ",", "___"}], "]"}], "->", 
    RowBox[{"g", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->23483],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"g", "[", "a", "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], ",", 
   RowBox[{"g", "[", "b", "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"b", ",", "c"}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"b", ",", "c", ",", "d"}], "]"}], ",", 
   RowBox[{"g", "[", "c", "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"c", ",", "d"}], "]"}], ",", 
   RowBox[{"g", "[", "d", "]"}]}], "}"}]], "Output",
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->107676562]
}, Open  ]],

Cell[TextData[{
 "This tries the shortest matches for ",
 Cell[BoxData[
  StyleBox["x__", "TI"]], "InlineFormula"],
 " first. "
}], "MathCaption",
 CellID->162906843],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplaceList", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], ",", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"___", ",", 
      RowBox[{"Shortest", "[", "x__", "]"}], ",", "___"}], "]"}], "->", 
    RowBox[{"g", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->700842637],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"g", "[", "a", "]"}], ",", 
   RowBox[{"g", "[", "b", "]"}], ",", 
   RowBox[{"g", "[", "c", "]"}], ",", 
   RowBox[{"g", "[", "d", "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"b", ",", "c"}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"c", ",", "d"}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"b", ",", "c", ",", "d"}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]}], "}"}]], "Output",
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->45240333]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->143084780],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsOverview"]], "RelatedTutorials",
 CellID->423797385]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Functions with Variable Numbers of Arguments - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Patterns", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/PatternsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/FlatAndOrderlessFunctions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/OptionalAndDefaultArguments"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 36, 19.8003560}", "context" -> "", 
    "keywords" -> {
     "___", "__", "_", "arguments", "arity", "BlankNullSequence", "blanks", 
      "BlankSequence", "debugging", "diagnostics", "elided arguments", 
      "enumerating sublists", "functions", "matches", "ReplaceList", 
      "varargs", "Longest", "Shortest"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Unless f is a flat function, a pattern like f[x_,y_] stands only for \
instances of the function with exactly two arguments. Sometimes you need to \
set up patterns that can allow any number of arguments. You can do this using \
multiple blanks. While a single blank such as x_ stands for a single \
Mathematica expression, a double blank such as x__ stands for a sequence of \
one or more expressions. Here x__ stands for the sequence of expressions \
(a,b,c). ", "synonyms" -> {"2.3.8"}, "title" -> 
    "Functions with Variable Numbers of Arguments", "type" -> "Tutorial", 
    "uri" -> "tutorial/FunctionsWithVariableNumbersOfArguments"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.3.8"->{
  Cell[1854, 58, 107, 2, 70, "Title",
   CellTags->{"S2.3.8", "8.1"},
   CellID->17118]},
 "8.1"->{
  Cell[1854, 58, 107, 2, 70, "Title",
   CellTags->{"S2.3.8", "8.1"},
   CellID->17118]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.3.8", 19260, 655},
 {"8.1", 19360, 659}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1229, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1854, 58, 107, 2, 70, "Title",
 CellTags->{"S2.3.8", "8.1"},
 CellID->17118],
Cell[1964, 62, 538, 19, 70, "Text",
 CellID->25668],
Cell[2505, 83, 409, 13, 70, "Text",
 CellID->10006],
Cell[2917, 98, 245, 9, 70, "MathCaption",
 CellID->9729],
Cell[CellGroupData[{
Cell[3187, 111, 270, 9, 28, "Input",
 CellID->24008],
Cell[3460, 122, 286, 9, 36, "Output",
 CellID->329159578]
}, Open  ]],
Cell[3761, 134, 186, 6, 70, "MathCaption",
 CellID->225],
Cell[3950, 142, 302, 10, 70, "Input",
 CellID->15536],
Cell[4255, 154, 117, 3, 70, "MathCaption",
 CellID->11980],
Cell[CellGroupData[{
Cell[4397, 161, 157, 5, 28, "Input",
 CellID->716],
Cell[4557, 168, 300, 10, 36, "Output",
 CellID->42319829]
}, Open  ]],
Cell[4872, 181, 1084, 25, 70, "Text",
 CellID->15384],
Cell[5959, 208, 1749, 55, 70, "DefinitionBox",
 CellID->28747],
Cell[7711, 265, 66, 1, 70, "Caption",
 CellID->20328],
Cell[7780, 268, 651, 21, 70, "Text",
 CellID->27936],
Cell[8434, 291, 676, 19, 70, "Text",
 CellID->6204],
Cell[9113, 312, 719, 24, 70, "DefinitionBox",
 CellID->53689283],
Cell[9835, 338, 88, 1, 70, "Caption",
 CellID->105237499],
Cell[9926, 341, 158, 6, 70, "MathCaption",
 CellID->10700],
Cell[CellGroupData[{
Cell[10109, 351, 394, 13, 70, "Input",
 CellID->7523],
Cell[10506, 366, 660, 23, 36, "Output",
 CellID->124137544]
}, Open  ]],
Cell[11181, 392, 228, 9, 70, "MathCaption",
 CellID->531919713],
Cell[CellGroupData[{
Cell[11434, 405, 436, 14, 70, "Input",
 CellID->58005111],
Cell[11873, 421, 660, 23, 36, "Output",
 CellID->683021416]
}, Open  ]],
Cell[12548, 447, 263, 8, 70, "MathCaption",
 CellID->1411],
Cell[CellGroupData[{
Cell[12836, 459, 315, 10, 70, "Input",
 CellID->16040],
Cell[13154, 471, 445, 14, 36, "Output",
 CellID->353961626]
}, Open  ]],
Cell[13614, 488, 115, 3, 70, "MathCaption",
 CellID->11504],
Cell[CellGroupData[{
Cell[13754, 495, 327, 10, 70, "Input",
 CellID->23483],
Cell[14084, 507, 764, 23, 36, "Output",
 CellID->107676562]
}, Open  ]],
Cell[14863, 533, 166, 6, 70, "MathCaption",
 CellID->162906843],
Cell[CellGroupData[{
Cell[15054, 543, 370, 11, 70, "Input",
 CellID->700842637],
Cell[15427, 556, 763, 23, 36, "Output",
 CellID->45240333]
}, Open  ]],
Cell[CellGroupData[{
Cell[16227, 584, 72, 1, 70, "RelatedTutorialsSection",
 CellID->143084780],
Cell[16302, 587, 146, 3, 70, "RelatedTutorials",
 CellID->423797385]
}, Open  ]]
}, Open  ]],
Cell[16475, 594, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

