(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10896,        371]
NotebookOptionsPosition[      6795,        251]
NotebookOutlinePosition[      9651,        324]
CellTagsIndexPosition[      9561,        318]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Files and External Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FilesAndExternalOperationsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Files and External Operations\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TeXForm" :> Documentation`HelpLookup["paclet:ref/TeXForm"], 
          "ToExpression" :> 
          Documentation`HelpLookup["paclet:ref/ToExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"TeXForm\"\>", 
       2->"\<\"ToExpression\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Generating and Importing TeX", "Title",
 CellTags->{"S1.11.6", "6.1"},
 CellID->32618],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebooks provide a sophisticated environment for creating technical \
documents. But particularly if you want to merge your work with existing \
material in TeX, you may find it convenient to use ",
 Cell[BoxData[
  ButtonBox["TeXForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TeXForm"]], "InlineFormula"],
 " to convert expressions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " into a form suitable for input to TeX."
}], "Text",
 CellID->21419],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["TeXForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TeXForm"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "print ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " in TeX input form"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->24007],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " output for TeX. "
}], "Caption",
 CellID->22284],

Cell[TextData[{
 "Here is an expression, printed in standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " form. "
}], "MathCaption",
 CellID->24547],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "+", "y"}], ")"}], "^", "2"}], "/", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"x", " ", "y"}], "]"}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->29977],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"x", "+", "y"}], ")"}], "2"], 
  SqrtBox[
   RowBox[{"x", " ", "y"}]]]], "Output",
 ImageSize->{55, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->15675]
}, Open  ]],

Cell["Here is the expression in TeX input form. ", "MathCaption",
 CellID->18613],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TeXForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->18709],

Cell["\\frac{(x+y)^2}{\\sqrt{x y}}", "Output",
 ImageSize->{182, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TeXForm= ",
 CellID->13371]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ToExpression",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ToExpression"], "[", "\"\<\!\(\*
StyleBox[\"input\", \"TI\"]\)\>\"", ",", 
     ButtonBox["TeXForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TeXForm"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "convert TeX input to ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->28642],

Cell[TextData[{
 "Converting TeX strings to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->16339],

Cell[TextData[{
 "This converts a TeX string to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Note the double backslashes needed in the string. "
}], "MathCaption",
 CellID->6336],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", 
  RowBox[{"\"\<\\\\sqrt{x y}\>\"", ",", "TeXForm"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->32621],

Cell[BoxData[
 SqrtBox[
  RowBox[{"x", " ", "y"}]]], "Output",
 ImageSize->{38, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->21501]
}, Open  ]],

Cell[TextData[{
 "In addition to being able to convert individual expressions to TeX, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " also provides capabilities for translating complete notebooks. These \
capabilities can usually be accessed from the ",
 StyleBox["Save As Special", "SR"],
 " menu in the notebook front end, where various options can be set."
}], "Text",
 CellID->26034],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->293876449],

Cell[TextData[ButtonBox["Files and External Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FilesAndExternalOperationsOverview"]], "RelatedTutorials",
 CellID->16088632]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Generating and Importing TeX - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Files and External Operations", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/FilesAndExternalOperationsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ExportingGraphicsAndSounds"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ExchangingMaterialWithTheWeb"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 36, 25.1754936}", "context" -> "", 
    "keywords" -> {
     "input", "nb2tex", "notebooks", "NotebooktoTeX conversion", "output", 
      "TeXForm", "TeX output", "ToExpression"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica notebooks provide a sophisticated environment for creating \
technical documents. But particularly if you want to merge your work with \
existing material in TeX, you may find it convenient to use TeXForm to \
convert expressions in Mathematica into a form suitable for input to TeX. \
Mathematica output for TeX. Here is an expression, printed in standard \
Mathematica form. ", "synonyms" -> {"1.11.6"}, "title" -> 
    "Generating and Importing TeX", "type" -> "Tutorial", "uri" -> 
    "tutorial/GeneratingAndImportingTeX"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.11.6"->{
  Cell[1949, 61, 92, 2, 70, "Title",
   CellTags->{"S1.11.6", "6.1"},
   CellID->32618]},
 "6.1"->{
  Cell[1949, 61, 92, 2, 70, "Title",
   CellTags->{"S1.11.6", "6.1"},
   CellID->32618]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.11.6", 9348, 307},
 {"6.1", 9448, 311}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1324, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1949, 61, 92, 2, 70, "Title",
 CellTags->{"S1.11.6", "6.1"},
 CellID->32618],
Cell[2044, 65, 536, 15, 70, "Text",
 CellID->21419],
Cell[2583, 82, 640, 20, 70, "DefinitionBox",
 CellID->24007],
Cell[3226, 104, 116, 5, 70, "Caption",
 CellID->22284],
Cell[3345, 111, 158, 6, 70, "MathCaption",
 CellID->24547],
Cell[CellGroupData[{
Cell[3528, 121, 216, 8, 28, "Input",
 CellID->29977],
Cell[3747, 131, 284, 11, 59, "Output",
 CellID->15675]
}, Open  ]],
Cell[4046, 145, 81, 1, 70, "MathCaption",
 CellID->18613],
Cell[CellGroupData[{
Cell[4152, 150, 100, 3, 28, "Input",
 CellID->18709],
Cell[4255, 155, 183, 5, 50, "Output",
 CellID->13371]
}, Open  ]],
Cell[4453, 163, 894, 26, 70, "DefinitionBox",
 CellID->28642],
Cell[5350, 191, 132, 6, 70, "Caption",
 CellID->16339],
Cell[5485, 199, 189, 6, 70, "MathCaption",
 CellID->6336],
Cell[CellGroupData[{
Cell[5699, 209, 154, 4, 70, "Input",
 CellID->32621],
Cell[5856, 215, 189, 7, 38, "Output",
 CellID->21501]
}, Open  ]],
Cell[6060, 225, 394, 9, 70, "Text",
 CellID->26034],
Cell[CellGroupData[{
Cell[6479, 238, 72, 1, 70, "RelatedTutorialsSection",
 CellID->293876449],
Cell[6554, 241, 187, 4, 70, "RelatedTutorials",
 CellID->16088632]
}, Open  ]]
}, Open  ]],
Cell[6768, 249, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

