(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13387,        494]
NotebookOptionsPosition[      8394,        339]
NotebookOutlinePosition[     11176,        409]
CellTagsIndexPosition[     11083,        403]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Symbolic Mathematics" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SymbolicMathematicsOverview"]}, #, 2]& , Evaluator -> 
       Automatic], {
      1->"\<\"Symbolic Mathematics\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Generic and Non\[Hyphen]Generic Cases", "Title",
 CellTags->{"S1.5.15", "15.1"},
 CellID->16439],

Cell[TextData[{
 "This gives a result for the integral of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "n"], TraditionalForm]], "InlineMath"],
 " that is valid for almost all values of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->27441],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", "^", "n"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6648],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["x", 
   RowBox[{"1", "+", "n"}]], 
  RowBox[{"1", "+", "n"}]]], "Output",
 ImageSize->{35, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->278533539]
}, Open  ]],

Cell[TextData[{
 "For the special case of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", 
    RowBox[{"-", "1"}]], TraditionalForm]], "InlineMath"],
 ", however, the correct result is different. "
}], "MathCaption",
 CellID->27834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", "^", 
    RowBox[{"-", "1"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19368],

Cell[BoxData[
 RowBox[{"Log", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->281757942]
}, Open  ]],

Cell["\<\
The overall goal of symbolic computation is typically to get formulas that \
are valid for many possible values of the variables that appear in them. It \
is however often not practical to try to get formulas that are valid for \
absolutely every possible value of each variable. \
\>", "Text",
 CellID->8872],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " always replaces ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "/", "x"}], TraditionalForm]], "InlineMath"],
 " by ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->32668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"0", "/", "x"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->19974],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->16164375]
}, Open  ]],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " is equal to 0, however, then the true result is not 0. "
}], "MathCaption",
 CellID->5137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"0", "/", "0"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->20633],

Cell[BoxData[
 RowBox[{
  RowBox[{"Power", "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"Infinite expression \\!\\(1\\/0\\) encountered. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/infy\\\", \
ButtonNote -> \\\"Power::infy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[4]:=",
 CellID->297496146],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Infinity]", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"Indeterminate expression \\!\\(0\\\\ ComplexInfinity\\) \
encountered. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/indet\\\", ButtonNote -> \
\\\"Infinity::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[4]:=",
 CellID->153566629],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->24882837]
}, Open  ]],

Cell["\<\
This construct treats both cases, but would be quite unwieldy to use. \
\>", "MathCaption",
 CellID->31015],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"x", "!=", "0"}], ",", "0", ",", "Indeterminate"}], "]"}]], "Input",\

 CellLabel->"In[5]:=",
 CellID->22974],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"x", "\[NotEqual]", "0"}], ",", "0", ",", "Indeterminate"}], 
  "]"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->852388697]
}, Open  ]],

Cell[TextData[{
 "If ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " did not automatically replace ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "/", "x"}], TraditionalForm]], "InlineMath"],
 " by 0, then few symbolic computations would get very far. But you should \
realize that the practical necessity of making such replacements can cause \
misleading results to be obtained when exceptional values of parameters are \
used. "
}], "Text",
 CellID->846],

Cell[TextData[{
 "The basic operations of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are nevertheless carefully set up so that whenever possible the results \
obtained will be valid for almost all values of each variable. "
}], "Text",
 CellID->8956],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SqrtBox[
    SuperscriptBox["x", "2"]], TraditionalForm]], "InlineMath"],
 " is not automatically replaced by ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->25524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"x", "^", "2"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->6966],

Cell[BoxData[
 SqrtBox[
  SuperscriptBox["x", "2"]]], "Output",
 ImageSize->{36, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->135653326]
}, Open  ]],

Cell[TextData[{
 "If it were, then the result here would be ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "2"}], TraditionalForm]], "InlineMath"],
 ", which is incorrect. "
}], "MathCaption",
 CellID->8144],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"x", "->", 
   RowBox[{"-", "2"}]}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->32240],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->485959920]
}, Open  ]],

Cell[TextData[{
 "This makes the assumption that ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " is a positive real variable, and does the replacement. "
}], "MathCaption",
 CellID->15296],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"x", ">", "0"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->11876],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->932015829]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->3958907],

Cell[TextData[ButtonBox["Symbolic Mathematics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SymbolicMathematicsOverview"]], "RelatedTutorials",
 CellID->391267452]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Generic and Non-Generic Cases - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Symbolic Mathematics", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> "paclet:tutorial/SymbolicMathematicsOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/IntegralTransforms"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/MathematicalNotationInNotebooks-\
SymbolicMathematics"]}], "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 36, 26.8474114}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "This gives a result for the integral of x^n that is valid for almost all \
values of n. For the special case of x^-1, however, the correct result is \
different. The overall goal of symbolic computation is typically to get \
formulas that are valid for many possible values of the variables that appear \
in them. It is however often not practical to try to get formulas that are \
valid for absolutely every possible value of each variable. ", 
    "synonyms" -> {"1.5.15"}, "title" -> "Generic and Non-Generic Cases", 
    "type" -> "Tutorial", "uri" -> "tutorial/GenericAndNonGenericCases"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.5.15"->{
  Cell[1260, 43, 102, 2, 70, "Title",
   CellTags->{"S1.5.15", "15.1"},
   CellID->16439]},
 "15.1"->{
  Cell[1260, 43, 102, 2, 70, "Title",
   CellTags->{"S1.5.15", "15.1"},
   CellID->16439]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.5.15", 10865, 392},
 {"15.1", 10968, 396}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 635, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1260, 43, 102, 2, 70, "Title",
 CellTags->{"S1.5.15", "15.1"},
 CellID->16439],
Cell[1365, 47, 299, 10, 70, "MathCaption",
 CellID->27441],
Cell[CellGroupData[{
Cell[1689, 61, 147, 5, 28, "Input",
 CellID->6648],
Cell[1839, 68, 249, 9, 54, "Output",
 CellID->278533539]
}, Open  ]],
Cell[2103, 80, 236, 8, 70, "MathCaption",
 CellID->27834],
Cell[CellGroupData[{
Cell[2364, 92, 168, 6, 28, "Input",
 CellID->19368],
Cell[2535, 100, 187, 6, 36, "Output",
 CellID->281757942]
}, Open  ]],
Cell[2737, 109, 319, 6, 70, "Text",
 CellID->8872],
Cell[3059, 117, 288, 12, 70, "MathCaption",
 CellID->32668],
Cell[CellGroupData[{
Cell[3372, 133, 88, 3, 28, "Input",
 CellID->19974],
Cell[3463, 138, 157, 5, 36, "Output",
 CellID->16164375]
}, Open  ]],
Cell[3635, 146, 181, 6, 70, "MathCaption",
 CellID->5137],
Cell[CellGroupData[{
Cell[3841, 156, 88, 3, 70, "Input",
 CellID->20633],
Cell[3932, 161, 411, 8, 70, "Message",
 CellID->297496146],
Cell[4346, 171, 446, 9, 70, "Message",
 CellID->153566629],
Cell[4795, 182, 169, 5, 36, "Output",
 CellID->24882837]
}, Open  ]],
Cell[4979, 190, 117, 3, 70, "MathCaption",
 CellID->31015],
Cell[CellGroupData[{
Cell[5121, 197, 166, 6, 70, "Input",
 CellID->22974],
Cell[5290, 205, 269, 9, 36, "Output",
 CellID->852388697]
}, Open  ]],
Cell[5574, 217, 462, 13, 70, "Text",
 CellID->846],
Cell[6039, 232, 262, 7, 70, "Text",
 CellID->8956],
Cell[6304, 241, 262, 10, 70, "MathCaption",
 CellID->25524],
Cell[CellGroupData[{
Cell[6591, 255, 118, 4, 70, "Input",
 CellID->6966],
Cell[6712, 261, 193, 7, 45, "Output",
 CellID->135653326]
}, Open  ]],
Cell[6920, 271, 205, 7, 70, "MathCaption",
 CellID->8144],
Cell[CellGroupData[{
Cell[7150, 282, 132, 5, 70, "Input",
 CellID->32240],
Cell[7285, 289, 158, 5, 36, "Output",
 CellID->485959920]
}, Open  ]],
Cell[7458, 297, 210, 6, 70, "MathCaption",
 CellID->15296],
Cell[CellGroupData[{
Cell[7693, 307, 204, 7, 70, "Input",
 CellID->11876],
Cell[7900, 316, 158, 5, 36, "Output",
 CellID->932015829]
}, Open  ]],
Cell[CellGroupData[{
Cell[8095, 326, 70, 1, 70, "RelatedTutorialsSection",
 CellID->3958907],
Cell[8168, 329, 172, 4, 70, "RelatedTutorials",
 CellID->391267452]
}, Open  ]]
}, Open  ]],
Cell[8367, 337, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

