(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31293,       1193]
NotebookOptionsPosition[     23607,        939]
NotebookOutlinePosition[     26664,       1014]
CellTagsIndexPosition[     26572,       1008]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Equations and Inequalities" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"], 
          "Complex Polynomial Systems" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ComplexPolynomialSystems"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Manipulating Equations and Inequalities\"\>", 
       2->"\<\"Complex Polynomial Systems\"\>"}, "\<\"related tutorials\"\>", 
       
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Reduce" :> Documentation`HelpLookup["paclet:ref/Reduce"], 
          "Solve" :> Documentation`HelpLookup["paclet:ref/Solve"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Reduce\"\>", 
       2->"\<\"Solve\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\<\
Generic and Non\[Hyphen]Generic Solutions\
\>", "Title",
 CellTags->{"S3.4.5", "5.1"},
 CellID->1205],

Cell[TextData[{
 "If you have an equation like ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"2", "x"}], "==", "0"}]], "InlineFormula"],
 ", it is perfectly clear that the only possible solution is ",
 Cell[BoxData[
  RowBox[{"x", "->", "0"}]], "InlineFormula"],
 ". However, if you have an equation like ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "x"}], "==", "0"}]], "InlineFormula"],
 ", things are not so clear. If ",
 Cell[BoxData["a"], "InlineFormula"],
 " is not equal to zero, then ",
 Cell[BoxData[
  RowBox[{"x", "->", "0"}]], "InlineFormula"],
 " is again the only solution. However, if ",
 Cell[BoxData["a"], "InlineFormula"],
 " is in fact equal to zero, then ",
 StyleBox["any",
  FontSlant->"Italic"],
 " value of ",
 Cell[BoxData["x"], "InlineFormula"],
 " is a solution. You can see this by using ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 "."
}], "Text",
 CellID->2018],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " implicitly assumes that the parameter ",
 Cell[BoxData["a"], "InlineFormula"],
 " does not have the special value ",
 Cell[BoxData["0"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->4291],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "x"}], "==", "0"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->31641],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", "0"}], "}"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->13465]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ", on the other hand, gives you all the possibilities, without assuming \
anything about the value of ",
 Cell[BoxData["a"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->16191],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "x"}], "==", "0"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->22471],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "\[Equal]", "0"}], "||", 
  RowBox[{"x", "\[Equal]", "0"}]}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->6259]
}, Open  ]],

Cell[TextData[{
 "A basic difference between ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " is that ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " gives ",
 StyleBox["all",
  FontSlant->"Italic"],
 " the possible solutions to a set of equations, while ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " gives only the ",
 StyleBox["generic",
  FontSlant->"Italic"],
 " ones. Solutions are considered \[OpenCurlyDoubleQuote]generic\
\[CloseCurlyDoubleQuote] if they involve conditions only on the variables \
that you explicitly solve for, and not on other parameters in the equations. \
",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " also differ in that ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " always returns combinations of equations, while ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " gives results in the form of transformation rules. "
}], "Text",
 CellID->23700],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Solve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Solve"], "[", 
     StyleBox["eqns", "TI"], ",", 
     StyleBox["vars", "TI"], "]"}], Cell[
    "find generic solutions to equations", "TableText"]},
   {
    RowBox[{
     ButtonBox["Reduce",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Reduce"], "[", 
     StyleBox["eqns", "TI"], ",", 
     StyleBox["vars", "TI"], "]"}], Cell[
    "reduce equations, maintaining all solutions", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->20217],

Cell["Solving equations. ", "Caption",
 CellID->2016],

Cell[TextData[{
 "This is the solution to an arbitrary linear equation given by ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->1943],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "x"}], "+", "b"}], "==", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->14624],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"-", 
     FractionBox["b", "a"]}]}], "}"}], "}"}]], "Output",
 ImageSize->{74, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->17064]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " gives the full version, which includes the possibility ",
 Cell[BoxData[
  RowBox[{"a", "==", "b", "==", "0"}]], "InlineFormula"],
 ". In reading the output, note that ",
 Cell[BoxData["&&"], "InlineFormula"],
 " has higher precedence than ",
 Cell[BoxData["||"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->31505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "x"}], "+", "b"}], "==", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->1157],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"b", "\[Equal]", "0"}], "&&", 
    RowBox[{"a", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[NotEqual]", "0"}], "&&", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", 
      FractionBox["b", "a"]}]}]}], ")"}]}]], "Output",
 ImageSize->{224, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->31502]
}, Open  ]],

Cell[TextData[{
 "Here is the full solution to a general quadratic equation. There are three \
alternatives. If ",
 Cell[BoxData["a"], "InlineFormula"],
 " is non\[Hyphen]zero, then there are two solutions for ",
 Cell[BoxData["x"], "InlineFormula"],
 ", given by the standard quadratic formula. If ",
 Cell[BoxData["a"], "InlineFormula"],
 " is zero, however, the equation reduces to a linear one. Finally, if ",
 Cell[BoxData["a"], "InlineFormula"],
 ", ",
 Cell[BoxData["b"], "InlineFormula"],
 " and ",
 Cell[BoxData["c"], "InlineFormula"],
 " are all zero, there is no restriction on ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->7666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"b", " ", "x"}], "+", "c"}], "==", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->9275],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[NotEqual]", "0"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       FractionBox[
        RowBox[{
         RowBox[{"-", "b"}], "-", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
        RowBox[{"2", " ", "a"}]]}], "||", 
      RowBox[{"x", "\[Equal]", 
       FractionBox[
        RowBox[{
         RowBox[{"-", "b"}], "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
        RowBox[{"2", " ", "a"}]]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "0"}], "&&", 
    RowBox[{"b", "\[NotEqual]", "0"}], "&&", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", 
      FractionBox["c", "b"]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"c", "\[Equal]", "0"}], "&&", 
    RowBox[{"b", "\[Equal]", "0"}], "&&", 
    RowBox[{"a", "\[Equal]", "0"}]}], ")"}]}]], "Output",
 ImageSize->{369, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->32046]
}, Open  ]],

Cell[TextData[{
 "When you have several simultaneous equations, ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " can show you under what conditions the equations have solutions. ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " shows you whether there are any generic solutions."
}], "Text",
 CellID->17632],

Cell["\<\
This shows there can never be any solution to these equations. \
\>", "MathCaption",
 CellID->29789],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "==", "1"}], ",", 
     RowBox[{"x", "==", "2"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->6046],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->2145]
}, Open  ]],

Cell[TextData[{
 "There is a solution to these equations, but only when ",
 Cell[BoxData["a"], "InlineFormula"],
 " has the special value\[NonBreakingSpace]",
 Cell[BoxData["1"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->6003],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "==", "1"}], ",", 
     RowBox[{"x", "==", "a"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->13152],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "\[Equal]", "1"}], "&&", 
  RowBox[{"x", "\[Equal]", "1"}]}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->31901]
}, Open  ]],

Cell[TextData[{
 "The solution is not generic, and is rejected by ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->8326],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "==", "1"}], ",", 
     RowBox[{"x", "==", "a"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->29153],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->21184]
}, Open  ]],

Cell[TextData[{
 "But if ",
 Cell[BoxData["a"], "InlineFormula"],
 " is constrained to have value ",
 Cell[BoxData["1"], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " again returns a solution. "
}], "MathCaption",
 CellID->19649],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "==", "1"}], ",", 
     RowBox[{"x", "==", "a"}], ",", 
     RowBox[{"a", "==", "1"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->30350],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", "1"}], "}"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->10405]
}, Open  ]],

Cell[TextData[{
 "This equation is true for any value of\[NonBreakingSpace]",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->24346],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"x", "==", "x"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->1025],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->28970]
}, Open  ]],

Cell[TextData[{
 "This is the kind of result ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " returns when you give an equation that is always true. "
}], "MathCaption",
 CellID->14336],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"x", "==", "x"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->4795],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", "}"}], "}"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->9793]
}, Open  ]],

Cell[TextData[{
 "When you work with systems of linear equations, you can use ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " to get generic solutions, and ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to find out for what values of parameters solutions exist. "
}], "Text",
 CellID->11323],

Cell[TextData[{
 "Here is a matrix whose ",
 Cell[BoxData[
  FormBox[
   RowBox[{"i", ",", "j"}], TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineMath"],
 " element is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"i", "+", "j"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->5532],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"i", "+", "j"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->28856],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->15896]
}, Open  ]],

Cell["The matrix has determinant zero. ", "MathCaption",
 CellID->3210],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", "m", "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->17776],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->5692]
}, Open  ]],

Cell["This makes a set of three simultaneous equations. ", "MathCaption",
 CellID->14550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqn", "=", 
  RowBox[{
   RowBox[{"m", ".", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "==", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}]}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->15290],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"2", " ", "x"}], "+", 
     RowBox[{"3", " ", "y"}], "+", 
     RowBox[{"4", " ", "z"}]}], ",", 
    RowBox[{
     RowBox[{"3", " ", "x"}], "+", 
     RowBox[{"4", " ", "y"}], "+", 
     RowBox[{"5", " ", "z"}]}], ",", 
    RowBox[{
     RowBox[{"4", " ", "x"}], "+", 
     RowBox[{"5", " ", "y"}], "+", 
     RowBox[{"6", " ", "z"}]}]}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}]}]], "Output",
 ImageSize->{344, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->13795]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " reports that there are no generic solutions. "
}], "MathCaption",
 CellID->13852],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"eqn", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->17350],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->8315]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ", however, shows that there ",
 StyleBox["would",
  FontSlant->"Italic"],
 " be a solution if the parameters satisfied the special condition ",
 Cell[BoxData[
  RowBox[{"a", "==", 
   RowBox[{
    RowBox[{"2", "b"}], "-", "c"}]}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->10036],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"eqn", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->29361],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "\[Equal]", 
   RowBox[{
    RowBox[{"2", " ", "b"}], "-", "c"}]}], "&&", 
  RowBox[{"y", "\[Equal]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "6"}], " ", "b"}], "+", 
    RowBox[{"5", " ", "c"}], "-", 
    RowBox[{"2", " ", "x"}]}]}], "&&", 
  RowBox[{"z", "\[Equal]", 
   RowBox[{
    RowBox[{"5", " ", "b"}], "-", 
    RowBox[{"4", " ", "c"}], "+", "x"}]}]}]], "Output",
 ImageSize->{303, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->3760]
}, Open  ]],

Cell["\<\
For nonlinear equations, the conditions for the existence of solutions can be \
much more complicated. \
\>", "Text",
 CellID->9984],

Cell["Here is a very simple pair of nonlinear equations. ", "MathCaption",
 CellID->8729],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqn", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"x", " ", "y"}], "==", "a"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], " ", 
      RowBox[{"y", "^", "2"}]}], "==", "b"}]}], "}"}]}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->2534],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"x", " ", "y"}], "\[Equal]", "a"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], " ", 
     SuperscriptBox["y", "2"]}], "\[Equal]", "b"}]}], "}"}]], "Output",
 ImageSize->{123, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]= ",
 CellID->6050]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " shows that the equations have no generic solutions. "
}], "MathCaption",
 CellID->28082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"eqn", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->16806],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]= ",
 CellID->1936]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " gives the complete conditions for a solution to exist. "
}], "MathCaption",
 CellID->25584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"eqn", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[19]:= ",
 CellID->10790],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"b", "\[Equal]", "0"}], "&&", 
    RowBox[{"a", "\[Equal]", "0"}], "&&", 
    RowBox[{"x", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "\[Equal]", 
       RowBox[{"-", 
        SqrtBox["b"]}]}], "||", 
      RowBox[{"a", "\[Equal]", 
       SqrtBox["b"]}]}], ")"}], "&&", 
    RowBox[{"x", "\[NotEqual]", "0"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     FractionBox["a", "x"]}]}], ")"}]}]], "Output",
 ImageSize->{424, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]= ",
 CellID->21617]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->583653463],

Cell[TextData[ButtonBox["Manipulating Equations and Inequalities",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"]], \
"RelatedTutorials",
 CellID->6804882],

Cell[TextData[ButtonBox["Complex Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ComplexPolynomialSystems"]], "RelatedTutorials",\

 CellID->65437048]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Generic and Non-Generic Solutions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Manipulating Equations and Inequalities", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/SimultaneousEquations"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/EliminatingVariables"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 36, 27.5193036}", "context" -> "", 
    "keywords" -> {
     "consistency", "equations", "existence of solutions", "genericity", 
      "parameters", "quadratic equations", "reduce", "solutions", "solve"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "If you have an equation like 2x==0, it is perfectly clear that the only \
possible solution is x->0. However, if you have an equation like ax==0, \
things are not so clear. If a is not equal to zero, then x->0 is again the \
only solution. However, if a is in fact equal to zero, then any value of x is \
a solution. You can see this by using Reduce. Solve implicitly assumes that \
the parameter a does not have the special value 0. Reduce, on the other hand, \
gives you all the possibilities, without assuming anything about the value of \
a. ", "synonyms" -> {"3.4.5"}, "title" -> "Generic and Non-Generic Solutions",
     "type" -> "Tutorial", "uri" -> 
    "tutorial/GenericAndNonGenericSolutions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.4.5"->{
  Cell[2127, 63, 111, 4, 70, "Title",
   CellTags->{"S3.4.5", "5.1"},
   CellID->1205]},
 "5.1"->{
  Cell[2127, 63, 111, 4, 70, "Title",
   CellTags->{"S3.4.5", "5.1"},
   CellID->1205]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.4.5", 26361, 997},
 {"5.1", 26460, 1001}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1502, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2127, 63, 111, 4, 70, "Title",
 CellTags->{"S3.4.5", "5.1"},
 CellID->1205],
Cell[2241, 69, 959, 31, 70, "Text",
 CellID->2018],
Cell[3203, 102, 326, 11, 70, "MathCaption",
 CellID->4291],
Cell[CellGroupData[{
Cell[3554, 117, 171, 6, 28, "Input",
 CellID->31641],
Cell[3728, 125, 230, 8, 36, "Output",
 CellID->13465]
}, Open  ]],
Cell[3973, 136, 315, 10, 70, "MathCaption",
 CellID->16191],
Cell[CellGroupData[{
Cell[4313, 150, 172, 6, 28, "Input",
 CellID->22471],
Cell[4488, 158, 237, 8, 36, "Output",
 CellID->6259]
}, Open  ]],
Cell[4740, 169, 1558, 52, 70, "Text",
 CellID->23700],
Cell[6301, 223, 839, 25, 70, "DefinitionBox",
 CellID->20217],
Cell[7143, 250, 53, 1, 70, "Caption",
 CellID->2016],
Cell[7199, 253, 235, 8, 70, "MathCaption",
 CellID->1943],
Cell[CellGroupData[{
Cell[7459, 265, 200, 8, 70, "Input",
 CellID->14624],
Cell[7662, 275, 274, 10, 51, "Output",
 CellID->17064]
}, Open  ]],
Cell[7951, 288, 456, 14, 70, "MathCaption",
 CellID->31505],
Cell[CellGroupData[{
Cell[8432, 306, 200, 8, 70, "Input",
 CellID->1157],
Cell[8635, 316, 452, 16, 51, "Output",
 CellID->31502]
}, Open  ]],
Cell[9102, 335, 669, 18, 70, "MathCaption",
 CellID->7666],
Cell[CellGroupData[{
Cell[9796, 357, 263, 10, 70, "Input",
 CellID->9275],
Cell[10062, 369, 1220, 41, 100, "Output",
 CellID->32046]
}, Open  ]],
Cell[11297, 413, 448, 13, 70, "Text",
 CellID->17632],
Cell[11748, 428, 110, 3, 70, "MathCaption",
 CellID->29789],
Cell[CellGroupData[{
Cell[11883, 435, 224, 8, 70, "Input",
 CellID->6046],
Cell[12110, 445, 158, 5, 36, "Output",
 CellID->2145]
}, Open  ]],
Cell[12283, 453, 236, 7, 70, "MathCaption",
 CellID->6003],
Cell[CellGroupData[{
Cell[12544, 464, 225, 8, 70, "Input",
 CellID->13152],
Cell[12772, 474, 238, 8, 36, "Output",
 CellID->31901]
}, Open  ]],
Cell[13025, 485, 221, 8, 70, "MathCaption",
 CellID->8326],
Cell[CellGroupData[{
Cell[13271, 497, 224, 8, 70, "Input",
 CellID->29153],
Cell[13498, 507, 172, 6, 36, "Output",
 CellID->21184]
}, Open  ]],
Cell[13685, 516, 329, 12, 70, "MathCaption",
 CellID->19649],
Cell[CellGroupData[{
Cell[14039, 532, 261, 9, 70, "Input",
 CellID->30350],
Cell[14303, 543, 230, 8, 36, "Output",
 CellID->10405]
}, Open  ]],
Cell[14548, 554, 156, 5, 70, "MathCaption",
 CellID->24346],
Cell[CellGroupData[{
Cell[14729, 563, 147, 5, 70, "Input",
 CellID->1025],
Cell[14879, 570, 159, 5, 36, "Output",
 CellID->28970]
}, Open  ]],
Cell[15053, 578, 255, 8, 70, "MathCaption",
 CellID->14336],
Cell[CellGroupData[{
Cell[15333, 590, 146, 5, 70, "Input",
 CellID->4795],
Cell[15482, 597, 195, 7, 36, "Output",
 CellID->9793]
}, Open  ]],
Cell[15692, 607, 436, 13, 70, "Text",
 CellID->11323],
Cell[16131, 622, 372, 14, 70, "MathCaption",
 CellID->5532],
Cell[CellGroupData[{
Cell[16528, 640, 283, 10, 70, "Input",
 CellID->28856],
Cell[16814, 652, 389, 13, 36, "Output",
 CellID->15896]
}, Open  ]],
Cell[17218, 668, 71, 1, 70, "MathCaption",
 CellID->3210],
Cell[CellGroupData[{
Cell[17314, 673, 97, 3, 70, "Input",
 CellID->17776],
Cell[17414, 678, 155, 5, 36, "Output",
 CellID->5692]
}, Open  ]],
Cell[17584, 686, 89, 1, 70, "MathCaption",
 CellID->14550],
Cell[CellGroupData[{
Cell[17698, 691, 260, 9, 70, "Input",
 CellID->15290],
Cell[17961, 702, 639, 22, 36, "Output",
 CellID->13795]
}, Open  ]],
Cell[18615, 727, 213, 7, 70, "MathCaption",
 CellID->13852],
Cell[CellGroupData[{
Cell[18853, 738, 183, 6, 70, "Input",
 CellID->17350],
Cell[19039, 746, 172, 6, 36, "Output",
 CellID->8315]
}, Open  ]],
Cell[19226, 755, 423, 15, 70, "MathCaption",
 CellID->10036],
Cell[CellGroupData[{
Cell[19674, 774, 184, 6, 70, "Input",
 CellID->29361],
Cell[19861, 782, 543, 19, 36, "Output",
 CellID->3760]
}, Open  ]],
Cell[20419, 804, 142, 4, 70, "Text",
 CellID->9984],
Cell[20564, 810, 89, 1, 70, "MathCaption",
 CellID->8729],
Cell[CellGroupData[{
Cell[20678, 815, 296, 11, 70, "Input",
 CellID->2534],
Cell[20977, 828, 367, 13, 39, "Output",
 CellID->6050]
}, Open  ]],
Cell[21359, 844, 220, 7, 70, "MathCaption",
 CellID->28082],
Cell[CellGroupData[{
Cell[21604, 855, 173, 6, 70, "Input",
 CellID->16806],
Cell[21780, 863, 172, 6, 36, "Output",
 CellID->1936]
}, Open  ]],
Cell[21967, 872, 225, 7, 70, "MathCaption",
 CellID->25584],
Cell[CellGroupData[{
Cell[22217, 883, 174, 6, 70, "Input",
 CellID->10790],
Cell[22394, 891, 663, 23, 50, "Output",
 CellID->21617]
}, Open  ]],
Cell[CellGroupData[{
Cell[23094, 919, 72, 1, 70, "RelatedTutorialsSection",
 CellID->583653463],
Cell[23169, 922, 208, 5, 70, "RelatedTutorials",
 CellID->6804882],
Cell[23380, 929, 173, 4, 70, "RelatedTutorials",
 CellID->65437048]
}, Open  ]]
}, Open  ]],
Cell[23580, 937, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

