(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29730,       1112]
NotebookOptionsPosition[     24856,        945]
NotebookOutlinePosition[     26757,        999]
CellTagsIndexPosition[     26666,        993]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"All" :> Documentation`HelpLookup["paclet:ref/All"], 
         "ArrayRules" :> Documentation`HelpLookup["paclet:ref/ArrayRules"], 
         "List" :> Documentation`HelpLookup["paclet:ref/List"], "Take" :> 
         Documentation`HelpLookup["paclet:ref/Take"], "Tr" :> 
         Documentation`HelpLookup["paclet:ref/Tr"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"All\"\>", 2->"\<\"ArrayRules\"\>", 
      3->"\<\"List\"\>", 4->"\<\"Take\"\>", 
      5->"\<\"Tr\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Getting and Setting Pieces of Matrices", "Title",
 CellTags->{"S3.7.2", "2.1"},
 CellID->29182],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     StyleBox["i", "TI"], ",", 
     StyleBox["j", "TI"], "]", "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      RowBox[{
       StyleBox["i", "TI"], ",", 
       StyleBox["j", "TI"]}]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " entry"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     StyleBox["i", "TI"], "]", "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " row"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"], ",", 
     StyleBox["i", "TI"], "]", "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " column"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Take",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Take"], "[", 
     StyleBox["m", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["i", "TI"], "0"], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["j", "TI"], "0"], ",", 
     SubscriptBox[
      StyleBox["j", "TI"], "1"], "}", "]"}], Cell[TextData[{
     "the submatrix with rows ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and columns ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{
        SubscriptBox[
         StyleBox["i", "TI"], "0"], ";;", 
        SubscriptBox[
         StyleBox["i", "TI"], "1"]}], ",", 
       RowBox[{
        SubscriptBox[
         StyleBox["j", "TI"], "0"], ";;", 
        SubscriptBox[
         StyleBox["j", "TI"], "1"]}]}], "]"}], "]"}], Cell[TextData[{
     "the submatrix with rows ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and columns ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", 
     RowBox[{"[", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["i", "TI"], "1"], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        RowBox[{
         SubscriptBox[
          StyleBox["i", "TI"], 
          StyleBox["r", "TI"]], Cell["}, {", "TableText"], 
         SubscriptBox[
          StyleBox["j", "TI"], "1"], Cell[", \[Ellipsis] , ", "TableText"], 
         SubscriptBox[
          StyleBox["j", "TI"], 
          StyleBox["s", "TI"]], Cell["}]]", "TableText"], 
         StyleBox[" ", "TR"]}]}]}]}]}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "the ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     "\[Times]",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " submatrix with elements having row indices ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"],
     " and column indices ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Tr",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Tr"], "[", 
     StyleBox["m", "TI"], ",", 
     ButtonBox["List",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/List"], "]"}], Cell[
    "elements on the diagonal", "TableText"]},
   {
    RowBox[{
     ButtonBox["ArrayRules",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArrayRules"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[
    "positions of non\[Hyphen]zero elements", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->19066],

Cell["Ways to get pieces of matrices. ", "Caption",
 CellID->23116],

Cell[TextData[{
 "Matrices in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are represented as lists of lists. You can use all the standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " list\[Hyphen]manipulation operations on matrices. "
}], "Text",
 CellID->6388],

Cell["Here is a sample 3\[Times]3 matrix. ", "MathCaption",
 CellID->9425],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"Array", "[", 
   RowBox[{"a", ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->13101],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "1"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "2"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "3"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"2", ",", "1"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"2", ",", "2"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"2", ",", "3"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"3", ",", "1"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"3", ",", "2"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"3", ",", "3"}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{566, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->5610]
}, Open  ]],

Cell["This picks out the second row of the matrix. ", "MathCaption",
 CellID->6450],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->19982],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "[", 
    RowBox[{"2", ",", "1"}], "]"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"2", ",", "2"}], "]"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"2", ",", "3"}], "]"}]}], "}"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->28621]
}, Open  ]],

Cell["Here is the second column of the matrix. ", "MathCaption",
 CellID->5193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->27038],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "[", 
    RowBox[{"1", ",", "2"}], "]"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"2", ",", "2"}], "]"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"3", ",", "2"}], "]"}]}], "}"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->16754]
}, Open  ]],

Cell["This picks out a submatrix. ", "MathCaption",
 CellID->4593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{"t", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->14895],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "2"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "3"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"2", ",", "2"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"2", ",", "3"}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->20280]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["m", "TI"], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["a", "TI"], 
          StyleBox["11", "TR"]], ",", 
         SubscriptBox[
          StyleBox["a", "TI"], 
          StyleBox["12", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["a", "TI"], 
          StyleBox["21", "TR"]], ",", 
         SubscriptBox[
          StyleBox["a", "TI"], 
          StyleBox["22", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], Cell[TextData[{
     "assign ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " to be a matrix"
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      StyleBox["m", "TI"], "[", 
      RowBox[{"[", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        StyleBox["j", "TI"]}], "]"}], "]"}], "=", 
     StyleBox["a", "TI"]}], Cell[TextData[{
     "reset element ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        StyleBox["j", "TI"]}], "}"}]], "InlineFormula"],
     " to be ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      StyleBox["m", "TI"], "[", 
      RowBox[{"[", 
       StyleBox["i", "TI"], "]"}], "]"}], "=", 
     StyleBox["a", "TI"]}], Cell[TextData[{
     "reset all elements in row ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " to be ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      StyleBox["m", "TI"], "[", 
      RowBox[{"[", 
       StyleBox["i", "TI"], "]"}], "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["a", "TI"], "1"], ",", 
       SubscriptBox[
        StyleBox["a", "TI"], "2"], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], Cell[TextData[{
     "reset elements in row ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " to be ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      StyleBox["m", "TI"], "[", 
      RowBox[{"[", 
       RowBox[{
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["0", "TR"]], ";;", 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["1", "TR"]]}], "]"}], "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["v", "TI"], "1"], ",", 
       SubscriptBox[
        StyleBox["v", "TI"], "2"], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], Cell[TextData[{
     "reset rows ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " to be vectors ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      StyleBox["m", "TI"], "[", 
      RowBox[{"[", 
       RowBox[{
        ButtonBox["All",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/All"], ",", 
        StyleBox["j", "TI"]}], "]"}], "]"}], "=", 
     StyleBox["a", "TI"]}], Cell[TextData[{
     "reset all elements in column ",
     Cell[BoxData[
      StyleBox["j", "TI"]], "InlineFormula"],
     " to be ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      StyleBox["m", "TI"], "[", 
      RowBox[{"[", 
       RowBox[{
        ButtonBox["All",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/All"], ",", 
        StyleBox["j", "TI"]}], "]"}], "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["a", "TI"], "1"], ",", 
       SubscriptBox[
        StyleBox["a", "TI"], "2"], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], Cell[TextData[{
     "reset elements in column ",
     Cell[BoxData[
      StyleBox["j", "TI"]], "InlineFormula"],
     " to be ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      StyleBox["m", "TI"], "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{
         SubscriptBox[
          StyleBox["i", "TI"], 
          StyleBox["0", "TR"]], ";;", 
         SubscriptBox[
          StyleBox["i", "TI"], 
          StyleBox["1", "TR"]]}], ",", 
        RowBox[{
         SubscriptBox[
          StyleBox["j", "TI"], 
          StyleBox["0", "TR"]], ";;", 
         SubscriptBox[
          StyleBox["j", "TI"], 
          StyleBox["1", "TR"]]}]}], "]"}], "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["a", "TI"], 
          StyleBox["11", "TR"]], ",", 
         SubscriptBox[
          StyleBox["a", "TI"], 
          StyleBox["12", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["a", "TI"], 
          StyleBox["21", "TR"]], ",", 
         SubscriptBox[
          StyleBox["a", "TI"], 
          StyleBox["22", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "reset the submatrix with rows ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and columns ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " to new values "
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->5638],

Cell["Resetting parts of matrices. ", "Caption",
 CellID->25167],

Cell["Here is a 3\[Times]3 matrix. ", "MathCaption",
 CellID->17420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"g", ",", "h", ",", "i"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4345],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"g", ",", "h", ",", "i"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->99384389]
}, Open  ]],

Cell[TextData[{
 "This resets the 2, 2 element to be ",
 Cell[BoxData["x"], "InlineFormula"],
 ", then shows the whole matrix. "
}], "MathCaption",
 CellID->23865],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"m", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "2"}], "]"}], "]"}], "=", "x"}], ";", "m"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24696],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "x", ",", "f"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"g", ",", "h", ",", "i"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->73744845]
}, Open  ]],

Cell[TextData[{
 "This resets all elements in the second column to be ",
 Cell[BoxData["z"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->10390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"m", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2"}], "]"}], "]"}], "=", "z"}], ";", "m"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->22632],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "z", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "z", ",", "f"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"g", ",", "z", ",", "i"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->289023237]
}, Open  ]],

Cell["\<\
This separately resets the three elements in the second column. \
\>", "MathCaption",
 CellID->17839],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"m", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2"}], "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"i", ",", "j", ",", "k"}], "}"}]}], ";", "m"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->20183],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "i", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "j", ",", "f"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"g", ",", "k", ",", "i"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->255190263]
}, Open  ]],

Cell["This increments all the values in the second column. ", "MathCaption",
 CellID->22129],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"m", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2"}], "]"}], "]"}], "++"}], ";", "m"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->6753],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"1", "+", "i"}], ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", 
     RowBox[{"1", "+", "j"}], ",", "f"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"g", ",", 
     RowBox[{"1", "+", "k"}], ",", "i"}], "}"}]}], "}"}]], "Output",
 ImageSize->{272, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->49201392]
}, Open  ]],

Cell[TextData[{
 "A range of indices can be specified by using ",
 Cell[BoxData[";;"], "InlineFormula"],
 " (",
 Cell[BoxData[
  ButtonBox["Span",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Span"]], "InlineFormula"],
 "). "
}], "Text",
 CellID->342716979],

Cell["This resets the first two rows to be new vectors. ", "MathCaption",
 CellID->401538121],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"m", "[", 
    RowBox[{"[", 
     RowBox[{"1", ";;", "2"}], "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", "w"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}]}], ";", 
  "m"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->458365735],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", ",", "v", ",", "w"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"g", ",", 
     RowBox[{"1", "+", "k"}], ",", "i"}], "}"}]}], "}"}]], "Output",
 ImageSize->{233, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->17561056]
}, Open  ]],

Cell["\<\
This resets elements in the first and third columns of each row. \
\>", "MathCaption",
 CellID->259615072],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"m", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", 
      RowBox[{"1", ";;", "3", ";;", "2"}]}], "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "6"}], "}"}]}], "}"}]}], ";", "m"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->450313767],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "v", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "y", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"1", "+", "k"}], ",", "6"}], "}"}]}], "}"}]], "Output",
 ImageSize->{233, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->34492577]
}, Open  ]],

Cell["\<\
This resets elements in the first and third columns of rows 2 through 3. \
\>", "MathCaption",
 CellID->61247371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"m", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;", "3"}], ",", 
      RowBox[{"1", ";;", "3", ";;", "2"}]}], "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}]}], ";", "m"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->107751323],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "v", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "y", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"1", "+", "k"}], ",", "d"}], "}"}]}], "}"}]], "Output",
 ImageSize->{233, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->599044784]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Getting and Setting Pieces of Matrices - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 36, 28.3318244}", "context" -> "", 
    "keywords" -> {
     "ArrayRules", "block matrices", "columns", "diagonal", "matrices", 
      "part", "range", "rows", "Submatrices", "Tr", "transpose"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Ways to get pieces of matrices. Matrices in Mathematica are represented \
as lists of lists. You can use all the standard Mathematica list-manipulation \
operations on matrices. Here is a sample 3x3 matrix. ", 
    "synonyms" -> {"3.7.2"}, "title" -> 
    "Getting and Setting Pieces of Matrices", "type" -> "Tutorial", "uri" -> 
    "tutorial/GettingAndSettingPiecesOfMatrices"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.7.2"->{
  Cell[1515, 46, 101, 2, 70, "Title",
   CellTags->{"S3.7.2", "2.1"},
   CellID->29182]},
 "2.1"->{
  Cell[1515, 46, 101, 2, 70, "Title",
   CellTags->{"S3.7.2", "2.1"},
   CellID->29182]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.7.2", 26453, 982},
 {"2.1", 26553, 986}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 890, 19, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1515, 46, 101, 2, 70, "Title",
 CellTags->{"S3.7.2", "2.1"},
 CellID->29182],
Cell[1619, 50, 5270, 181, 70, "DefinitionBox",
 CellID->19066],
Cell[6892, 233, 67, 1, 70, "Caption",
 CellID->23116],
Cell[6962, 236, 282, 9, 70, "Text",
 CellID->6388],
Cell[7247, 247, 74, 1, 70, "MathCaption",
 CellID->9425],
Cell[CellGroupData[{
Cell[7346, 252, 196, 7, 28, "Input",
 CellID->13101],
Cell[7545, 261, 909, 31, 36, "Output",
 CellID->5610]
}, Open  ]],
Cell[8469, 295, 83, 1, 70, "MathCaption",
 CellID->6450],
Cell[CellGroupData[{
Cell[8577, 300, 117, 4, 28, "Input",
 CellID->19982],
Cell[8697, 306, 373, 13, 36, "Output",
 CellID->28621]
}, Open  ]],
Cell[9085, 322, 79, 1, 70, "MathCaption",
 CellID->5193],
Cell[CellGroupData[{
Cell[9189, 327, 143, 5, 70, "Input",
 CellID->27038],
Cell[9335, 334, 373, 13, 36, "Output",
 CellID->16754]
}, Open  ]],
Cell[9723, 350, 66, 1, 70, "MathCaption",
 CellID->4593],
Cell[CellGroupData[{
Cell[9814, 355, 228, 8, 70, "Input",
 CellID->14895],
Cell[10045, 365, 531, 19, 36, "Output",
 CellID->20280]
}, Open  ]],
Cell[10591, 387, 6952, 247, 70, "DefinitionBox",
 CellID->5638],
Cell[17546, 636, 64, 1, 70, "Caption",
 CellID->25167],
Cell[17613, 639, 68, 1, 70, "MathCaption",
 CellID->17420],
Cell[CellGroupData[{
Cell[17706, 644, 327, 11, 70, "Input",
 CellID->4345],
Cell[18036, 657, 390, 13, 36, "Output",
 CellID->99384389]
}, Open  ]],
Cell[18441, 673, 163, 5, 70, "MathCaption",
 CellID->23865],
Cell[CellGroupData[{
Cell[18629, 682, 191, 7, 70, "Input",
 CellID->24696],
Cell[18823, 691, 390, 13, 36, "Output",
 CellID->73744845]
}, Open  ]],
Cell[19228, 707, 151, 5, 70, "MathCaption",
 CellID->10390],
Cell[CellGroupData[{
Cell[19404, 716, 195, 8, 70, "Input",
 CellID->22632],
Cell[19602, 726, 391, 13, 36, "Output",
 CellID->289023237]
}, Open  ]],
Cell[20008, 742, 111, 3, 70, "MathCaption",
 CellID->17839],
Cell[CellGroupData[{
Cell[20144, 749, 252, 9, 70, "Input",
 CellID->20183],
Cell[20399, 760, 391, 13, 36, "Output",
 CellID->255190263]
}, Open  ]],
Cell[20805, 776, 92, 1, 70, "MathCaption",
 CellID->22129],
Cell[CellGroupData[{
Cell[20922, 781, 188, 7, 70, "Input",
 CellID->6753],
Cell[21113, 790, 468, 16, 36, "Output",
 CellID->49201392]
}, Open  ]],
Cell[21596, 809, 261, 10, 70, "Text",
 CellID->342716979],
Cell[21860, 821, 93, 1, 70, "MathCaption",
 CellID->401538121],
Cell[CellGroupData[{
Cell[21978, 826, 374, 14, 70, "Input",
 CellID->458365735],
Cell[22355, 842, 416, 14, 36, "Output",
 CellID->17561056]
}, Open  ]],
Cell[22786, 859, 116, 3, 70, "MathCaption",
 CellID->259615072],
Cell[CellGroupData[{
Cell[22927, 866, 454, 16, 70, "Input",
 CellID->450313767],
Cell[23384, 884, 416, 14, 36, "Output",
 CellID->34492577]
}, Open  ]],
Cell[23815, 901, 123, 3, 70, "MathCaption",
 CellID->61247371],
Cell[CellGroupData[{
Cell[23963, 908, 418, 15, 70, "Input",
 CellID->107751323],
Cell[24384, 925, 418, 14, 36, "Output",
 CellID->599044784]
}, Open  ]]
}, Open  ]],
Cell[24829, 943, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

