(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22580,        831]
NotebookOptionsPosition[     16837,        642]
NotebookOutlinePosition[     19496,        712]
CellTagsIndexPosition[     19405,        706]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/ListsOverview"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Lists\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Drop" :> Documentation`HelpLookup["paclet:ref/Drop"], "First" :> 
          Documentation`HelpLookup["paclet:ref/First"], "Last" :> 
          Documentation`HelpLookup["paclet:ref/Last"], "Most" :> 
          Documentation`HelpLookup["paclet:ref/Most"], "Part" :> 
          Documentation`HelpLookup["paclet:ref/Part"], "Rest" :> 
          Documentation`HelpLookup["paclet:ref/Rest"], "Take" :> 
          Documentation`HelpLookup["paclet:ref/Take"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Drop\"\>", 2->"\<\"First\"\>", 3->"\<\"Last\"\>",
        4->"\<\"Most\"\>", 5->"\<\"Part\"\>", 6->"\<\"Rest\"\>", 
       7->"\<\"Take\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Getting Pieces of Lists", "Title",
 CellTags->{"S1.8.4", "4.1"},
 CellID->30946],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["First",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/First"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "the first element in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Last",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Last"], "[", 
     StyleBox["list", "TI"], "]"}], Cell["the last element", "TableText"]},
   {
    RowBox[{
     ButtonBox["Part",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Part"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["n", "TI"], "]", Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     StyleBox["list", "TI"], "[", "[", 
     StyleBox["n", "TI"], "]", "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " element"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Part",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Part"], "[", 
     StyleBox["list", "TI"], ",", "-", 
     StyleBox["n", "TI"], "]", Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     StyleBox["list", "TI"], "[", "[", "-", 
     StyleBox["n", "TI"], "]", "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " element from the end"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Part",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Part"], "[", 
     RowBox[{
      StyleBox["list", "TI"], ",", 
      RowBox[{
       StyleBox["m", "TI"], ";;", 
       StyleBox["n", "TI"]}]}], "]"}], Cell[TextData[{
     "elements ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Part",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Part"], "[", 
     StyleBox["list", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]", Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     StyleBox["list", "TI"], "[", "[", "{", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "the list of elements at positions ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["n", "1"], ",", 
        SubscriptBox["n", "2"], ",", "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->31065],

Cell["Picking out elements of lists. ", "Caption",
 CellID->8380],

Cell["We will use this list for the examples. ", "MathCaption",
 CellID->13165],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}], 
   "}"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->5946],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->503656651]
}, Open  ]],

Cell[TextData[{
 "Here is the last element of ",
 Cell[BoxData["t"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->27297],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Last", "[", "t", "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->8042],

Cell[BoxData["g"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->14464]
}, Open  ]],

Cell["This gives the third element. ", "MathCaption",
 CellID->23194],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "[", 
  RowBox[{"[", "3", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->12584],

Cell[BoxData["c"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->10270]
}, Open  ]],

Cell["This gives the list of elements 3 through 6.", "MathCaption",
 CellID->211397182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "[", 
  RowBox[{"[", 
   RowBox[{"3", ";;", "6"}], "]"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->228934890],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"c", ",", "d", ",", "e", ",", "f"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->116991846]
}, Open  ]],

Cell["This gives a list of the first and fourth elements. ", "MathCaption",
 CellID->32715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "[", 
  RowBox[{"[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->32200],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "d"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->1206]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Take",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Take"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "the first ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " elements in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Take",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Take"], "[", 
     StyleBox["list", "TI"], ",", "-", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "the last ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " elements"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Take",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Take"], "[", 
     StyleBox["list", "TI"], ",", "{", 
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"], "}", "]"}], Cell[TextData[{
     "elements ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     " through ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " (inclusive)"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Rest",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Rest"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     StyleBox["list", "TI"],
     " with its first element dropped"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Drop",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Drop"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     StyleBox["list", "TI"],
     " with its first ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " elements dropped"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Most",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Most"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     StyleBox["list", "TI"],
     " with its last element dropped"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Drop",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Drop"], "[", 
     StyleBox["list", "TI"], ",", "-", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     StyleBox["list", "TI"],
     " with its last ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " elements dropped"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Drop",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Drop"], "[", 
     StyleBox["list", "TI"], ",", "{", 
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"], "}", "]"}], Cell[TextData[{
     StyleBox["list", "TI"],
     " with elements ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     " through ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " dropped"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, True, False, False, False, {False}, False},
    "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->32106],

Cell["Picking out sequences in lists. ", "Caption",
 CellID->31302],

Cell[TextData[{
 "This gives the first three elements of the list ",
 Cell[BoxData["t"], "InlineFormula"],
 " defined above. "
}], "MathCaption",
 CellID->24696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{"t", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->8833],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->7611]
}, Open  ]],

Cell["This gives the last three elements. ", "MathCaption",
 CellID->19067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{"t", ",", 
   RowBox[{"-", "3"}]}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->415],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"e", ",", "f", ",", "g"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->6645]
}, Open  ]],

Cell[TextData[{
 "This gives elements ",
 Cell[BoxData["2"], "InlineFormula"],
 " through ",
 Cell[BoxData["5"], "InlineFormula"],
 " inclusive. "
}], "MathCaption",
 CellID->30175],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{"t", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->6354],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "c", ",", "d", ",", "e"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->23448]
}, Open  ]],

Cell[TextData[{
 "This gives elements ",
 Cell[BoxData["3"], "InlineFormula"],
 " through ",
 Cell[BoxData["7"], "InlineFormula"],
 " in steps of ",
 Cell[BoxData["2"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->24919],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{"t", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "7", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->13079],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"c", ",", "e", ",", "g"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->27988]
}, Open  ]],

Cell[TextData[{
 "This gives ",
 Cell[BoxData["t"], "InlineFormula"],
 " with the first element dropped. "
}], "MathCaption",
 CellID->26321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rest", "[", "t", "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->7592],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->31597]
}, Open  ]],

Cell[TextData[{
 "This gives ",
 Cell[BoxData["t"], "InlineFormula"],
 " with its first three elements dropped. "
}], "MathCaption",
 CellID->22197],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Drop", "[", 
  RowBox[{"t", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->13509],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"d", ",", "e", ",", "f", ",", "g"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->8652]
}, Open  ]],

Cell[TextData[{
 "This gives ",
 Cell[BoxData["t"], "InlineFormula"],
 " with only its third element dropped. "
}], "MathCaption",
 CellID->71],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Drop", "[", 
  RowBox[{"t", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->658],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "d", ",", "e", ",", "f", ",", "g"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->14122]
}, Open  ]],

Cell[TextData[{
 ButtonBox["\"Manipulating Expressions like Lists\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ManipulatingExpressionsLikeLists"],
 " shows how all the functions here can be generalized to work not only on \
lists, but on any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. "
}], "Text",
 CellID->26859],

Cell[TextData[{
 "The functions here allow you to pick out pieces that occur at particular \
positions in lists. \"",
 ButtonBox["Finding Expressions That Match a Pattern\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/FindingExpressionsThatMatchAPattern"],
 " shows how you can use functions like ",
 Cell[BoxData[
  ButtonBox["Select",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Select"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Cases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cases"]], "InlineFormula"],
 " to pick out elements of lists based not on their positions, but instead on \
their properties. "
}], "Text",
 CellID->7997],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->10790947],

Cell[TextData[ButtonBox["Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ListsOverview"]], "RelatedTutorials",
 CellID->27407539]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Getting Pieces of Lists - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Lists", "OverviewNavText"], BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ListsOverview"]], "Text", FontFamily -> "Verdana"], 
    "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/VectorsAndMatrices"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/TestingAndSearchingListElements"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 36, 29.8787390}", "context" -> "", 
    "keywords" -> {
     ";;", "]]", "[[", "beginning of list", "car", "cdr", "deleting elements",
       "discard elements", "Drop", "First", "Last", "lists", "Most", "Part", 
      "parts", "removing elements from lists", "Rest", "sequence of elements",
       "stride", "Sublists", "Take", "truncate list"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Picking out elements of lists. We will use this list for the examples. \
Here is the last element of t. ", "synonyms" -> {"1.8.4"}, "title" -> 
    "Getting Pieces of Lists", "type" -> "Tutorial", "uri" -> 
    "tutorial/GettingPiecesOfLists"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.8.4"->{
  Cell[2258, 64, 86, 2, 70, "Title",
   CellTags->{"S1.8.4", "4.1"},
   CellID->30946]},
 "4.1"->{
  Cell[2258, 64, 86, 2, 70, "Title",
   CellTags->{"S1.8.4", "4.1"},
   CellID->30946]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.8.4", 19194, 695},
 {"4.1", 19293, 699}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1633, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2258, 64, 86, 2, 70, "Title",
 CellTags->{"S1.8.4", "4.1"},
 CellID->30946],
Cell[2347, 68, 3423, 109, 70, "DefinitionBox",
 CellID->31065],
Cell[5773, 179, 65, 1, 70, "Caption",
 CellID->8380],
Cell[5841, 182, 79, 1, 70, "MathCaption",
 CellID->13165],
Cell[CellGroupData[{
Cell[5945, 187, 188, 6, 28, "Input",
 CellID->5946],
Cell[6136, 195, 257, 8, 36, "Output",
 CellID->503656651]
}, Open  ]],
Cell[6408, 206, 127, 5, 70, "MathCaption",
 CellID->27297],
Cell[CellGroupData[{
Cell[6560, 215, 96, 3, 28, "Input",
 CellID->8042],
Cell[6659, 220, 155, 5, 36, "Output",
 CellID->14464]
}, Open  ]],
Cell[6829, 228, 69, 1, 70, "MathCaption",
 CellID->23194],
Cell[CellGroupData[{
Cell[6923, 233, 117, 4, 28, "Input",
 CellID->12584],
Cell[7043, 239, 155, 5, 36, "Output",
 CellID->10270]
}, Open  ]],
Cell[7213, 247, 87, 1, 70, "MathCaption",
 CellID->211397182],
Cell[CellGroupData[{
Cell[7325, 252, 145, 5, 70, "Input",
 CellID->228934890],
Cell[7473, 259, 223, 7, 36, "Output",
 CellID->116991846]
}, Open  ]],
Cell[7711, 269, 91, 1, 70, "MathCaption",
 CellID->32715],
Cell[CellGroupData[{
Cell[7827, 274, 166, 6, 70, "Input",
 CellID->32200],
Cell[7996, 282, 199, 7, 36, "Output",
 CellID->1206]
}, Open  ]],
Cell[8210, 292, 3314, 113, 70, "DefinitionBox",
 CellID->32106],
Cell[11527, 407, 67, 1, 70, "Caption",
 CellID->31302],
Cell[11597, 410, 161, 5, 70, "MathCaption",
 CellID->24696],
Cell[CellGroupData[{
Cell[11783, 419, 119, 4, 70, "Input",
 CellID->8833],
Cell[11905, 425, 209, 7, 36, "Output",
 CellID->7611]
}, Open  ]],
Cell[12129, 435, 75, 1, 70, "MathCaption",
 CellID->19067],
Cell[CellGroupData[{
Cell[12229, 440, 137, 5, 70, "Input",
 CellID->415],
Cell[12369, 447, 209, 7, 36, "Output",
 CellID->6645]
}, Open  ]],
Cell[12593, 457, 181, 7, 70, "MathCaption",
 CellID->30175],
Cell[CellGroupData[{
Cell[12799, 468, 168, 6, 70, "Input",
 CellID->6354],
Cell[12970, 476, 220, 7, 36, "Output",
 CellID->23448]
}, Open  ]],
Cell[13205, 486, 227, 9, 70, "MathCaption",
 CellID->24919],
Cell[CellGroupData[{
Cell[13457, 499, 179, 6, 70, "Input",
 CellID->13079],
Cell[13639, 507, 210, 7, 36, "Output",
 CellID->27988]
}, Open  ]],
Cell[13864, 517, 141, 5, 70, "MathCaption",
 CellID->26321],
Cell[CellGroupData[{
Cell[14030, 526, 96, 3, 70, "Input",
 CellID->7592],
Cell[14129, 531, 244, 8, 36, "Output",
 CellID->31597]
}, Open  ]],
Cell[14388, 542, 148, 5, 70, "MathCaption",
 CellID->22197],
Cell[CellGroupData[{
Cell[14561, 551, 121, 4, 70, "Input",
 CellID->13509],
Cell[14685, 557, 220, 7, 36, "Output",
 CellID->8652]
}, Open  ]],
Cell[14920, 567, 143, 5, 70, "MathCaption",
 CellID->71],
Cell[CellGroupData[{
Cell[15088, 576, 168, 6, 70, "Input",
 CellID->658],
Cell[15259, 584, 245, 8, 36, "Output",
 CellID->14122]
}, Open  ]],
Cell[15519, 595, 350, 10, 70, "Text",
 CellID->26859],
Cell[15872, 607, 673, 19, 70, "Text",
 CellID->7997],
Cell[CellGroupData[{
Cell[16570, 630, 71, 1, 70, "RelatedTutorialsSection",
 CellID->10790947],
Cell[16644, 633, 139, 3, 70, "RelatedTutorials",
 CellID->27407539]
}, Open  ]]
}, Open  ]],
Cell[16810, 640, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

