(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12216,        359]
NotebookOptionsPosition[      8007,        254]
NotebookOutlinePosition[     11647,        338]
CellTagsIndexPosition[     11556,        332]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Numerical Calculations" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/NumericalCalculationsOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Numerical Calculations\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Getting Used to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Title",
 CellTags->{"S1.1.6", "6.1"},
 CellID->10999],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "\[FilledSmallSquare] Arguments of functions are given in ",
     StyleBox["square brackets",
      FontSlant->"Italic"],
     "."
    }], "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Names of built\[Hyphen]in functions have their first \
letters capitalized.\
\>", "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Multiplication can be represented by a space.\
\>", "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] Powers are denoted by ",
     Cell[BoxData["^"], "InlineFormula"],
     "."
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] Numbers in scientific notation are entered, for \
example, as ",
     Cell[BoxData["2.5*^-4"], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{"2.5", "10", "^", "-", "4"}]], "InlineFormula"],
     "."
    }], "TableText"]}
  }]], "FramedBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->1899],

Cell[TextData[{
 "Important points to remember in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->4120],

Cell[TextData[{
 ButtonBox["\"Numerical Calculations\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NumericalCalculationsOverview"],
 " gives you a first glimpse of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". If you have used other computer systems before, you will probably notice \
some similarities and some differences. Often you will find the differences \
the most difficult parts to remember. It may help you, however, to understand \
a little about ",
 StyleBox["why",
  FontSlant->"Italic"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is set up the way it is, and why such differences exist."
}], "Text",
 CellID->1320],

Cell[TextData[{
 "One important feature of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that differs from other computer languages, and from conventional \
mathematical notation, is that function arguments are enclosed in square \
brackets, not parentheses. Parentheses in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are reserved specifically for indicating the grouping of terms. There is \
obviously a conceptual distinction between giving arguments to a function and \
grouping terms together; the fact that the same notation has often been used \
for both is largely a consequence of typography and of early computer \
keyboards. In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", the concepts are distinguished by different notation. "
}], "Text",
 CellID->32036],

Cell[TextData[{
 "This distinction has several advantages. In parenthesis notation, it is not \
clear whether ",
 Cell[BoxData[
  FormBox[
   RowBox[{"c", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}]}], TraditionalForm]], "InlineMath"],
 " means ",
 Cell[BoxData[
  RowBox[{"c", "[", 
   RowBox[{"1", "+", "x"}], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"c", "*", 
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}]}]], "InlineFormula"],
 ". Using square brackets for function arguments removes this ambiguity. It \
also allows multiplication to be indicated without an explicit ",
 Cell[BoxData["*"], "InlineFormula"],
 " or other character. As a result, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can handle expressions like ",
 Cell[BoxData[
  RowBox[{"2", "x"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"a", "x"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"a", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}]}]], "InlineFormula"],
 ", treating them just as in standard mathematical notation. "
}], "Text",
 CellID->16984],

Cell[TextData[{
 "You can see from \"",
 ButtonBox["Some Mathematical Functions\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SomeMathematicalFunctions"],
 " that built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions often have quite long names. You may wonder why, for example, \
the pseudorandom number function for generating reals is called ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 ", rather than, say, ",
 Cell[BoxData["Rand"], "InlineFormula"],
 ". The answer, which pervades much of the design of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", is consistency. There is a general convention in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that all function names are spelled out as full English words, unless \
there is a standard mathematical abbreviation for them. The great advantage \
of this scheme is that it is ",
 StyleBox["predictable",
  FontSlant->"Italic"],
 ". Once you know what a function does, you will usually be able to guess \
exactly what its name is. If the names were abbreviated, you would always \
have to remember which shortening of the standard English words was used."
}], "Text",
 CellID->4912],

Cell[TextData[{
 "Another feature of built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " names is that they all start with capital letters. In \"",
 ButtonBox["Defining Variables\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DefiningVariables"],
 " and \"",
 ButtonBox["Defining Functions\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DefiningFunctions"],
 ", you will see how to define variables and functions of your own. The \
capital letter convention makes it easy to distinguish built\[Hyphen]in \
objects. If ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " used ",
 Cell[BoxData["max"], "InlineFormula"],
 " instead of ",
 Cell[BoxData[
  ButtonBox["Max",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Max"]], "InlineFormula"],
 " to represent the operation of finding a maximum, then you would never be \
able to use ",
 Cell[BoxData["max"], "InlineFormula"],
 " as the name of one of your variables. In addition, when you read programs \
written in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", the capitalization of built\[Hyphen]in names makes them easier to pick \
out."
}], "Text",
 CellID->1915],

Cell[TextData[ButtonBox["Numerical Calculations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalCalculationsOverview"]], "RelatedTutorials",
 CellID->21356267]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Getting Used to Mathematica - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numerical Calculations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/NumericalCalculationsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ComplexNumbers"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/MathematicalNotationInNotebooks-\
NumericalCalculations"]}], "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 36, 32.5038062}", "context" -> "", 
    "keywords" -> {
     "brackets", "capital letters", "commands", "errors", "functions", 
      "mistakes", "multiplication", "naming conventions", 
      "scientific notation", "spaces", "square brackets", "symbol names", 
      "uppercase", "variables"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Important points to remember in Mathematica. \"Numerical Calculations\" \
gives you a first glimpse of Mathematica. If you have used other computer \
systems before, you will probably notice some similarities and some \
differences. Often you will find the differences the most difficult parts to \
remember. It may help you, however, to understand a little about why \
Mathematica is set up the way it is, and why such differences exist. One \
important feature of Mathematica that differs from other computer languages, \
and from conventional mathematical notation, is that function arguments are \
enclosed in square brackets, not parentheses. Parentheses in Mathematica are \
reserved specifically for indicating the grouping of terms. There is \
obviously a conceptual distinction between giving arguments to a function and \
grouping terms together; the fact that the same notation has often been used \
for both is largely a consequence of typography and of early computer \
keyboards. In Mathematica, the concepts are distinguished by different \
notation. ", "synonyms" -> {"1.1.6"}, "title" -> 
    "Getting Used to Mathematica", "type" -> "Tutorial", "uri" -> 
    "tutorial/GettingUsedToMathematica"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.1.6"->{
  Cell[1266, 43, 143, 6, 70, "Title",
   CellTags->{"S1.1.6", "6.1"},
   CellID->10999]},
 "6.1"->{
  Cell[1266, 43, 143, 6, 70, "Title",
   CellTags->{"S1.1.6", "6.1"},
   CellID->10999]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.1.6", 11343, 321},
 {"6.1", 11443, 325}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 641, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1266, 43, 143, 6, 70, "Title",
 CellTags->{"S1.1.6", "6.1"},
 CellID->10999],
Cell[1412, 51, 1215, 37, 70, "FramedBox",
 CellID->1899],
Cell[2630, 90, 137, 6, 70, "Caption",
 CellID->4120],
Cell[2770, 98, 664, 18, 70, "Text",
 CellID->1320],
Cell[3437, 118, 797, 18, 70, "Text",
 CellID->32036],
Cell[4237, 138, 1103, 36, 70, "Text",
 CellID->16984],
Cell[5343, 176, 1272, 31, 70, "Text",
 CellID->4912],
Cell[6618, 209, 1169, 34, 70, "Text",
 CellID->1915],
Cell[7790, 245, 175, 4, 70, "RelatedTutorials",
 CellID->21356267]
}, Open  ]],
Cell[7980, 252, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

