(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33776,        971]
NotebookOptionsPosition[     26576,        789]
NotebookOutlinePosition[     31288,        886]
CellTagsIndexPosition[     31196,        880]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Global Aspects of Mathematica Sessions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GlobalAspectsOfMathematicaSessionsOverview"], 
          "Naming and Finding Files" :> 
          Documentation`HelpLookup["paclet:tutorial/NamingAndFindingFiles"], 
          "Mathematica File Organization" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicaFileOrganization"], 
          "System Administration for Single-User Licenses" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/\
SystemAdministrationForSingleUserLicensesOverview"], 
          "System Administration for Network Licenses" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]},\
 #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Global Aspects of Mathematica Sessions\"\>", 
       2->"\<\"Naming and Finding Files\"\>", 
       3->"\<\"Mathematica File Organization\"\>", 
       4->"\<\"System Administration for Single-User Licenses\"\>", 
       5->"\<\"System Administration for Network Licenses\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Directories & Directory Operations" :> 
          Documentation`HelpLookup[
           "paclet:guide/DirectoriesAndDirectoryOperations"], 
          "Mathematica System Setup" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSystemSetup"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Directories & Directory Operations\"\>", 
       2->"\<\"Mathematica System Setup\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DateList" :> Documentation`HelpLookup["paclet:ref/DateList"], 
          "Environment" :> Documentation`HelpLookup["paclet:ref/Environment"],
           "LinkObject" :> Documentation`HelpLookup["paclet:ref/LinkObject"], 
          "Null" :> Documentation`HelpLookup["paclet:ref/Null"], 
          "$BatchInput" :> Documentation`HelpLookup["paclet:ref/$BatchInput"],
           "$BatchOutput" :> 
          Documentation`HelpLookup["paclet:ref/$BatchOutput"], 
          "$ByteOrdering" :> 
          Documentation`HelpLookup["paclet:ref/$ByteOrdering"], 
          "$CommandLine" :> 
          Documentation`HelpLookup["paclet:ref/$CommandLine"], 
          "$CreationDate" :> 
          Documentation`HelpLookup["paclet:ref/$CreationDate"], 
          "$LicenseExpirationDate" :> 
          Documentation`HelpLookup["paclet:ref/$LicenseExpirationDate"], 
          "$LicenseID" :> Documentation`HelpLookup["paclet:ref/$LicenseID"], 
          "$LicenseServer" :> 
          Documentation`HelpLookup["paclet:ref/$LicenseServer"], 
          "$MachineAddresses" :> 
          Documentation`HelpLookup["paclet:ref/$MachineAddresses"], 
          "$MachineDomains" :> 
          Documentation`HelpLookup["paclet:ref/$MachineDomains"], 
          "$MachineID" :> Documentation`HelpLookup["paclet:ref/$MachineID"], 
          "$MachineName" :> 
          Documentation`HelpLookup["paclet:ref/$MachineName"], "$MachineType" :> 
          Documentation`HelpLookup["paclet:ref/$MachineType"], "$Notebooks" :> 
          Documentation`HelpLookup["paclet:ref/$Notebooks"], 
          "$OperatingSystem" :> 
          Documentation`HelpLookup["paclet:ref/$OperatingSystem"], 
          "$ParentLink" :> Documentation`HelpLookup["paclet:ref/$ParentLink"],
           "$ParentProcessID" :> 
          Documentation`HelpLookup["paclet:ref/$ParentProcessID"], 
          "$ProcessID" :> Documentation`HelpLookup["paclet:ref/$ProcessID"], 
          "$ProcessorType" :> 
          Documentation`HelpLookup["paclet:ref/$ProcessorType"], 
          "$ReleaseNumber" :> 
          Documentation`HelpLookup["paclet:ref/$ReleaseNumber"], "$SessionID" :> 
          Documentation`HelpLookup["paclet:ref/$SessionID"], "$System" :> 
          Documentation`HelpLookup["paclet:ref/$System"], 
          "$SystemCharacterEncoding" :> 
          Documentation`HelpLookup["paclet:ref/$SystemCharacterEncoding"], 
          "$SystemID" :> Documentation`HelpLookup["paclet:ref/$SystemID"], 
          "$UserName" :> Documentation`HelpLookup["paclet:ref/$UserName"], 
          "$Version" :> Documentation`HelpLookup["paclet:ref/$Version"], 
          "$VersionNumber" :> 
          Documentation`HelpLookup["paclet:ref/$VersionNumber"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DateList\"\>", 
       2->"\<\"Environment\"\>", 3->"\<\"LinkObject\"\>", 4->"\<\"Null\"\>", 
       5->"\<\"$BatchInput\"\>", 6->"\<\"$BatchOutput\"\>", 
       7->"\<\"$ByteOrdering\"\>", 8->"\<\"$CommandLine\"\>", 
       9->"\<\"$CreationDate\"\>", 10->"\<\"$LicenseExpirationDate\"\>", 
       11->"\<\"$LicenseID\"\>", 12->"\<\"$LicenseServer\"\>", 
       13->"\<\"$MachineAddresses\"\>", 14->"\<\"$MachineDomains\"\>", 
       15->"\<\"$MachineID\"\>", 16->"\<\"$MachineName\"\>", 
       17->"\<\"$MachineType\"\>", 18->"\<\"$Notebooks\"\>", 
       19->"\<\"$OperatingSystem\"\>", 20->"\<\"$ParentLink\"\>", 
       21->"\<\"$ParentProcessID\"\>", 22->"\<\"$ProcessID\"\>", 
       23->"\<\"$ProcessorType\"\>", 24->"\<\"$ReleaseNumber\"\>", 
       25->"\<\"$SessionID\"\>", 26->"\<\"$System\"\>", 
       27->"\<\"$SystemCharacterEncoding\"\>", 28->"\<\"$SystemID\"\>", 
       29->"\<\"$UserName\"\>", 30->"\<\"$Version\"\>", 
       31->"\<\"$VersionNumber\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Global System Information", "Title",
 CellTags->{"S2.14.5", "5.1"},
 CellID->25706],

Cell[TextData[{
 "In order to write the most general ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programs you will sometimes need to find out global information about the \
setup under which your program is being run."
}], "Text",
 CellID->23849],

Cell[TextData[{
 "Thus, for example, to tell whether your program should be calling functions \
like ",
 Cell[BoxData[
  ButtonBox["NotebookWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookWrite"]], "InlineFormula"],
 ", you need to find out whether the program is being run in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session that is using the notebook front end. You can do this by testing \
the global variable ",
 Cell[BoxData[
  ButtonBox["$Notebooks",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Notebooks"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->24075],

Cell[BoxData[GridBox[{
   {
    ButtonBox["$Notebooks",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$Notebooks"], Cell[
    "whether a notebook front end is being used", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->28026],

Cell["Determining whether a notebook front end is being used. ", "Caption",
 CellID->20124],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is usually used interactively, but it can also operate in a batch mode\
\[LongDash]say taking input from a file and writing output to a file. In such \
a case, a program cannot for example expect to get interactive input from the \
user. "
}], "Text",
 CellID->27607],

Cell[BoxData[GridBox[{
   {
    ButtonBox["$BatchInput",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$BatchInput"], Cell[
    "whether input is being given in batch mode", "TableText"]},
   {
    ButtonBox["$BatchOutput",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$BatchOutput"], Cell["\<\
whether output should be given in batch mode, without labeling, etc.\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->17774],

Cell["Variables specifying batch mode operation. ", "Caption",
 CellID->2884],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel is a process that runs under the operating system on your computer. \
Within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " there are several global variables that allow you to find the \
characteristics of this process and its environment. "
}], "Text",
 CellID->20128],

Cell[BoxData[GridBox[{
   {
    ButtonBox["$CommandLine",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$CommandLine"], Cell[TextData[{
     "the original command line used to invoke the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " kernel"
    }], "TableText"]},
   {
    ButtonBox["$ParentLink",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$ParentLink"], Cell[TextData[{
     "the ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " ",
     Cell[BoxData[
      ButtonBox["LinkObject",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LinkObject"]], "InlineFormula"],
     " specifying the program that invoked the kernel (or ",
     Cell[BoxData[
      ButtonBox["Null",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Null"]], "InlineFormula"],
     " if the kernel was invoked directly)"
    }], "TableText"]},
   {
    ButtonBox["$ProcessID",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$ProcessID"], Cell[TextData[{
     "the ID assigned to the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " kernel process by the operating system"
    }], "TableText"]},
   {
    ButtonBox["$ParentProcessID",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$ParentProcessID"], Cell[TextData[{
     "the ID of the process that invoked the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " kernel"
    }], "TableText"]},
   {
    ButtonBox["$UserName",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$UserName"], Cell[TextData[{
     "the login name of the user running the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " kernel"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Environment",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Environment"], "[", "\"\<\!\(\*
StyleBox[\"var\", \"TI\"]\)\>\"", "]"}], Cell[
    "the value of a variable defined by the operating system", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->24546],

Cell[TextData[{
 "Variables associated with the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel process. "
}], "Caption",
 CellID->3145],

Cell[TextData[{
 "If you have a variable such as ",
 Cell[BoxData["x"], "InlineFormula"],
 " in a particular ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, you may or may not want that variable to be the same as an ",
 Cell[BoxData["x"], "InlineFormula"],
 " in another ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. In order to make it possible to maintain distinct objects in \
different sessions, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports the variable ",
 Cell[BoxData[
  ButtonBox["$SessionID",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$SessionID"]], "InlineFormula"],
 ", which uses information such as starting time, process ID and machine ID \
to try to give a different value for every single ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, whether it is run on the same computer or a different one. "
}], "Text",
 CellID->20481],

Cell[BoxData[GridBox[{
   {
    ButtonBox["$SessionID",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$SessionID"], Cell[TextData[{
     "a number set up to be different for every ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " session"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->11714],

Cell[TextData[{
 "A unique number different for every ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. "
}], "Caption",
 CellID->20149],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides various global variables that allow you to tell which version of \
the kernel you are running. This is important if you write programs that make \
use of features that are, say, new in Version 6. You can then check ",
 Cell[BoxData[
  ButtonBox["$VersionNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$VersionNumber"]], "InlineFormula"],
 " to find out if these features will be available. "
}], "Text",
 CellID->24168],

Cell[BoxData[GridBox[{
   {
    ButtonBox["$Version",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$Version"], Cell[TextData[{
     "a string giving the complete version of ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " in use"
    }], "TableText"]},
   {
    ButtonBox["$VersionNumber",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$VersionNumber"], Cell[TextData[{
     "the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " kernel version number (e.g. ",
     Cell[BoxData["5.0"], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    ButtonBox["$ReleaseNumber",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$ReleaseNumber"], Cell[TextData[{
     "the release number for your version of the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " kernel on your particular computer system"
    }], "TableText"]},
   {
    ButtonBox["$CreationDate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$CreationDate"], Cell[TextData[{
     "the date, in ",
     Cell[BoxData[
      StyleBox[
       ButtonBox["DateList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DateList"],
       ButtonNote -> Inherited]], "InlineFormula"],
     " format, on which your particular ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " release was created"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->13338],

Cell[TextData[{
 "Variables specifying the version of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " used. "
}], "Caption",
 CellID->20307],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " itself is set up to be as independent of the details of the particular \
computer system on which it is run as possible. However, if you want to \
access external aspects of your computer system, then you will often need to \
find out its characteristics. "
}], "Text",
 CellID->26793],

Cell[BoxData[GridBox[{
   {
    ButtonBox["$System",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$System"], Cell[
    "a full string describing the computer system in use", "TableText"]},
   {
    ButtonBox["$SystemID",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$SystemID"], Cell[
    "a short string specifying the computer system in use", "TableText"]},
   {
    ButtonBox["$ProcessorType",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$ProcessorType"], Cell[
    "the architecture of the processor in your computer system", 
     "TableText"]},
   {
    ButtonBox["$MachineType",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$MachineType"], Cell[
    "the general type of your computer system", "TableText"]},
   {
    ButtonBox["$ByteOrdering",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$ByteOrdering"], Cell[
    "the native byte ordering convention on your computer system", 
     "TableText"]},
   {
    ButtonBox["$OperatingSystem",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$OperatingSystem"], Cell[
    "the basic operating system in use", "TableText"]},
   {
    ButtonBox["$SystemCharacterEncoding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$SystemCharacterEncoding"], Cell["\<\
the default raw character encoding used by your operating system\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->23504],

Cell["\<\
Variables specifying the characteristics of your computer system. \
\>", "Caption",
 CellID->1105],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the values of ",
 Cell[BoxData[
  ButtonBox["$SystemID",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$SystemID"]], "InlineFormula"],
 " to label directories that contain versions of files for different computer \
systems, as discussed in\[NonBreakingSpace]\"",
 ButtonBox["Reading and Writing ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"],
  FontSlant->"Italic"],
 ButtonBox[" Files: Files and Streams\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"],
 " and\[NonBreakingSpace]\"",
 ButtonBox["Portability of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
  FontSlant->"Italic"],
 ButtonBox[" Programs\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
 ". Computer systems for which ",
 Cell[BoxData[
  ButtonBox["$SystemID",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$SystemID"]], "InlineFormula"],
 " is the same will normally be binary compatible. "
}], "Text",
 CellID->1697],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$OperatingSystem",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$OperatingSystem"]], "InlineFormula"],
 " has values such as ",
 Cell[BoxData["\"\<Windows\>\""], "InlineFormula"],
 " or ",
 Cell[BoxData["\"\<Unix\>\""], "InlineFormula"],
 ". By testing ",
 Cell[BoxData[
  ButtonBox["$OperatingSystem",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$OperatingSystem"]], "InlineFormula"],
 " you can determine whether a particular external program is likely to be \
available on your computer system. "
}], "Text",
 CellID->18217],

Cell["\<\
This gives some characteristics of the computer system on which the input is \
evaluated. \
\>", "MathCaption",
 CellID->15955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"$System", ",", "$ProcessorType", ",", "$OperatingSystem"}], 
  "}"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->16641],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Linux x86 (32-bit)\"\>", ",", "\<\"x86\"\>", 
   ",", "\<\"Unix\"\>"}], "}"}]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->2343]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    ButtonBox["$MachineAddresses",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$MachineAddresses"], Cell[
    "the list of current IP addresses", "TableText"]},
   {
    ButtonBox["$MachineName",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$MachineName"], Cell[TextData[{
     "the name of the computer on which ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " is running"
    }], "TableText"]},
   {
    ButtonBox["$MachineDomains",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$MachineDomains"], Cell[
    "the current network domains for the computer", "TableText"]},
   {
    ButtonBox["$MachineID",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$MachineID"], Cell[TextData[{
     "the unique ID assigned by ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " to the computer"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->26133],

Cell[TextData[{
 "Variables identifying the computer on which ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is running. "
}], "Caption",
 CellID->32097],

Cell[BoxData[GridBox[{
   {
    ButtonBox["$LicenseID",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$LicenseID"], Cell[TextData[{
     "the ID for the license under which ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " is running"
    }], "TableText"]},
   {
    ButtonBox["$LicenseExpirationDate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$LicenseExpirationDate"], Cell[
    "the date on which the license expires", "TableText"]},
   {"$NetworkLicense", Cell[
    "whether this is a network license", "TableText"]},
   {
    ButtonBox["$LicenseServer",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$LicenseServer"], Cell[
    "the full name of the machine serving the license", "TableText"]},
   {"$LicenseProcesses", Cell[TextData[{
     "the number of ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " processes currently being run under the license"
    }], "TableText"]},
   {"$MaxLicenseProcesses", Cell[
    "the maximum number of processes provided by the license", "TableText"]},
   {"$PasswordFile", Cell[
    "password file used when the kernel was started", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->679],

Cell["Variables associated with license management. ", "Caption",
 CellID->20736],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->920581041],

Cell[TextData[ButtonBox["Directories & Directory Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DirectoriesAndDirectoryOperations"]], "TutorialMoreAbout",
 CellID->74069176],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSystemSetup"],
  FontSlant->"Italic"],
 ButtonBox[" System Setup",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSystemSetup"]
}], "TutorialMoreAbout",
 CellID->454905762]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->448632700],

Cell[TextData[{
 ButtonBox["Global Aspects of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GlobalAspectsOfMathematicaSessionsOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GlobalAspectsOfMathematicaSessionsOverview"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GlobalAspectsOfMathematicaSessionsOverview"]
}], "RelatedTutorials",
 CellID->1006056654],

Cell[TextData[ButtonBox["Naming and Finding Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NamingAndFindingFiles"]], "RelatedTutorials",
 CellID->183121913],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaFileOrganization"],
  FontSlant->"Italic"],
 ButtonBox[" File Organization",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaFileOrganization"]
}], "RelatedTutorials",
 CellID->40230661],

Cell[TextData[ButtonBox["System Administration for Single-User Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]], \
"RelatedTutorials",
 CellID->309296652],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"RelatedTutorials",
 CellID->518845713]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Global System Information - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Global Aspects of Mathematica Sessions", "OverviewNavText"],
         BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/GlobalAspectsOfMathematicaSessionsOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/MemoryManagement"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/MathematicaSessions"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 36, 33.2538254}", "context" -> "", 
    "keywords" -> {
     "account", "architecture", "argc", "argv", "arguments", "batch files", 
      "blank lines", "command language", "compatibility", 
      "copy of Mathematica", "command line", "command-line arguments", 
      "CPU ID", "CPU type", "dates", "endianness", "big-endian", 
      "little-endian", "environment", "ethernet address", "external commands",
       "floating licenses", "host name", "information", "interface", 
      "internet address", "IP address", "job number", "killing a process", 
      "process limit", "login name", "manufacturer", "name", "node ID", 
      "notebook-based interface", "network address", "graphical interface", 
      "parameters", "PID", "process ID", "platform", "PPID", 
      "parent process ID", "command prompt", "serial number", "shell type", 
      "shell variables", "signalling a process", "text-based interface", 
      "unique number", "updates", "variables", "BatchInput", "batch input", 
      "BatchOutput", "batch output", "batch processing", "ByteOrdering", 
      "byte ordering", "CommandLine", "CreationDate", "LicenseExpirationDate",
       "license expiration date", "LicenseID", "LicenseProcesses", 
      "license processes", "LicenseServer", "license server", "MachineDomain",
       "machine domain", "MachineID", "MachineName", "machine name", 
      "MachineType", "machine type", "MaxLicenseProcesses", "NetworkLicense", 
      "network license", "notebooks", "OperatingSystem", "operating system", 
      "ParentLink", "parent link", "ParentProcessID", "PasswordFile", 
      "password file", "ProcessID", "ProcessorType", "processor type", 
      "ProductInformation", "product information", "ReleaseNumber", 
      "release number", "SessionID", "system", "SystemCharacterEncoding", 
      "system character encoding", "SystemID", "UserName", "user name", 
      "version", "VersionNumber", "version number"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "In order to write the most general Mathematica programs you will \
sometimes need to find out global information about the setup under which \
your program is being run. Thus, for example, to tell whether your program \
should be calling functions like NotebookWrite, you need to find out whether \
the program is being run in a Mathematica session that is using the notebook \
front end. You can do this by testing the global variable $Notebooks. \
Determining whether a notebook front end is being used. ", 
    "synonyms" -> {"2.14.5"}, "title" -> "Global System Information", "type" -> 
    "Tutorial", "uri" -> "tutorial/GlobalSystemInformation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.14.5"->{
  Cell[7094, 153, 89, 2, 70, "Title",
   CellTags->{"S2.14.5", "5.1"},
   CellID->25706]},
 "5.1"->{
  Cell[7094, 153, 89, 2, 70, "Title",
   CellTags->{"S2.14.5", "5.1"},
   CellID->25706]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.14.5", 30981, 869},
 {"5.1", 31082, 873}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 6469, 126, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[7094, 153, 89, 2, 70, "Title",
 CellTags->{"S2.14.5", "5.1"},
 CellID->25706],
Cell[7186, 157, 257, 7, 70, "Text",
 CellID->23849],
Cell[7446, 166, 605, 18, 70, "Text",
 CellID->24075],
Cell[8054, 186, 511, 14, 70, "DefinitionBox",
 CellID->28026],
Cell[8568, 202, 91, 1, 70, "Caption",
 CellID->20124],
Cell[8662, 205, 335, 8, 70, "Text",
 CellID->27607],
Cell[9000, 215, 712, 20, 70, "DefinitionBox",
 CellID->17774],
Cell[9715, 237, 77, 1, 70, "Caption",
 CellID->2884],
Cell[9795, 240, 362, 11, 70, "Text",
 CellID->20128],
Cell[10160, 253, 2302, 72, 70, "DefinitionBox",
 CellID->24546],
Cell[12465, 327, 150, 6, 70, "Caption",
 CellID->3145],
Cell[12618, 335, 917, 26, 70, "Text",
 CellID->20481],
Cell[13538, 363, 603, 18, 70, "DefinitionBox",
 CellID->11714],
Cell[14144, 383, 150, 6, 70, "Caption",
 CellID->20149],
Cell[14297, 391, 507, 12, 70, "Text",
 CellID->24168],
Cell[14807, 405, 1733, 55, 70, "DefinitionBox",
 CellID->13338],
Cell[16543, 462, 147, 6, 70, "Caption",
 CellID->20307],
Cell[16693, 470, 353, 8, 70, "Text",
 CellID->26793],
Cell[17049, 480, 1712, 48, 70, "DefinitionBox",
 CellID->23504],
Cell[18764, 530, 108, 3, 70, "Caption",
 CellID->1105],
Cell[18875, 535, 1373, 38, 70, "Text",
 CellID->1697],
Cell[20251, 575, 580, 17, 70, "Text",
 CellID->18217],
Cell[20834, 594, 137, 4, 70, "MathCaption",
 CellID->15955],
Cell[CellGroupData[{
Cell[20996, 602, 159, 5, 70, "Input",
 CellID->16641],
Cell[21158, 609, 260, 8, 36, "Output",
 CellID->2343]
}, Open  ]],
Cell[21433, 620, 1231, 37, 70, "DefinitionBox",
 CellID->26133],
Cell[22667, 659, 161, 6, 70, "Caption",
 CellID->32097],
Cell[22831, 667, 1513, 41, 70, "DefinitionBox",
 CellID->679],
Cell[24347, 710, 81, 1, 70, "Caption",
 CellID->20736],
Cell[CellGroupData[{
Cell[24453, 715, 66, 1, 70, "TutorialMoreAboutSection",
 CellID->920581041],
Cell[24522, 718, 189, 4, 70, "TutorialMoreAbout",
 CellID->74069176],
Cell[24714, 724, 296, 9, 70, "TutorialMoreAbout",
 CellID->454905762]
}, Open  ]],
Cell[CellGroupData[{
Cell[25047, 738, 72, 1, 70, "RelatedTutorialsSection",
 CellID->448632700],
Cell[25122, 741, 469, 12, 70, "RelatedTutorials",
 CellID->1006056654],
Cell[25594, 755, 167, 3, 70, "RelatedTutorials",
 CellID->183121913],
Cell[25764, 760, 315, 9, 70, "RelatedTutorials",
 CellID->40230661],
Cell[26082, 771, 222, 5, 70, "RelatedTutorials",
 CellID->309296652],
Cell[26307, 778, 215, 5, 70, "RelatedTutorials",
 CellID->518845713]
}, Open  ]]
}, Open  ]],
Cell[26549, 787, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

