(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    159545,       4429]
NotebookOptionsPosition[    134756,       3597]
NotebookOutlinePosition[    149249,       4051]
CellTagsIndexPosition[    148658,       4028]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"GraphPlot" :> Documentation`HelpLookup["paclet:ref/GraphPlot"], 
         "GraphPlot3D" :> Documentation`HelpLookup["paclet:ref/GraphPlot3D"], 
         "LayeredGraphPlot" :> 
         Documentation`HelpLookup["paclet:ref/LayeredGraphPlot"], "TreePlot" :> 
         Documentation`HelpLookup["paclet:ref/TreePlot"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"GraphPlot\"\>", 2->"\<\"GraphPlot3D\"\>", 
      3->"\<\"LayeredGraphPlot\"\>", 
      4->"\<\"TreePlot\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Introduction to Graph Drawing", "Title",
 CellTags->{"introduction", "i:2", "b:0.0"},
 CellID->251542051],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides functions for the aesthetic drawing of graphs. Algorithms \
implemented include the spring embedding, spring-electrical embedding, \
high-dimensional embedding, radial drawing, random embedding, circular \
embedding, and spiral embedding. In addition, algorithms for \
layered/hierarchical drawing of directed graphs as well as for the drawing of \
trees are available. These algorithms are implemented via four functions: ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["GraphPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TreePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreePlot"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.0",
 CellID->29196500],

Cell[BoxData[GridBox[{
   {
    ButtonBox["GraphPlot",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GraphPlot"], Cell[
    "generate a plot of a graph", "TableText"]},
   {
    ButtonBox["GraphPlot3D",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GraphPlot3D"], Cell[
    "generate a 3D plot of a graph", "TableText"]},
   {
    ButtonBox["LayeredGraphPlot",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/LayeredGraphPlot"], Cell[
    "generate a layered plot of a graph", "TableText"]},
   {
    ButtonBox["TreePlot",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TreePlot"], Cell[
    "generate a tree plot of a graph", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"b:0.1",
 CellID->25485965],

Cell[TextData[StyleBox["Functions for graph drawing.", "SR"]], "Caption",
 CellTags->{"S5.18.1", "b:0.0"},
 CellID->661590988],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["GraphPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFormula"],
 " are suitable for straight line drawing of general graphs. ",
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 " attempts to draw the vertices of a graph in a series of layers; therefore \
it is most suitable for applications such as the drawing of flow charts. ",
 Cell[BoxData[
  ButtonBox["TreePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreePlot"]], "InlineFormula"],
 " is particularly useful for drawing trees or tree-like graphs. ",
 "These functions are designed to work efficiently for very large graphs. "
}], "Text",
 CellID->17385],

Cell["This shows a graph drawn using each of the four functions.", \
"MathCaption",
 CellTags->"b:0.0",
 CellID->829970625],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"#", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"4", "\[Rule]", "2"}], ",", 
          RowBox[{"4", "\[Rule]", "3"}], ",", 
          RowBox[{"5", "\[Rule]", "2"}], ",", 
          RowBox[{"5", "\[Rule]", "3"}], ",", 
          RowBox[{"5", "\[Rule]", "4"}], ",", 
          RowBox[{"6", "\[Rule]", "2"}], ",", 
          RowBox[{"6", "\[Rule]", "3"}], ",", 
          RowBox[{"6", "\[Rule]", "4"}], ",", 
          RowBox[{"6", "\[Rule]", "5"}], ",", 
          RowBox[{"6", "\[Rule]", "7"}], ",", 
          RowBox[{"7", "\[Rule]", "8"}], ",", 
          RowBox[{"7", "\[Rule]", "9"}]}], "}"}], ",", 
        RowBox[{"PlotRangePadding", "->", "Automatic"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "180"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", "#"}]}], "]"}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"GraphPlot", ",", "GraphPlot3D"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"LayeredGraphPlot", ",", "TreePlot"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"-", "1"}], "}"}]}], "]"}], "}"}], "//", "TableForm"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->465726308],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0., 0.724024897664831}, {
            0.39848107596991933`, 0.}, {0.3986109535723801, 
            1.4480601392732395`}, {0.5053639917923882, 0.7241197108018271}, {
            1.1932054538580061`, 0.7239092866818234}, {2.77245943200628, 
            0.7239469961603822}, {3.701835655830594, 0.06191165170363144}, {
            3.702254714214859, 1.386039208133221}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {4, 2}, {4, 3}, {4, 1}, {5, 2}, {5, 
               3}, {5, 1}, {5, 4}, {5, 6}, {6, 7}, {6, 8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "9"],
               Annotation[#, 9, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0., 0.724024897664831}, {
             0.39848107596991933`, 0.}, {0.3986109535723801, 
             1.4480601392732395`}, {0.5053639917923882, 0.7241197108018271}, {
             1.1932054538580061`, 0.7239092866818234}, {2.77245943200628, 
             0.7239469961603822}, {3.701835655830594, 0.06191165170363144}, {
             3.702254714214859, 1.386039208133221}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          ImageSize->180,
          PlotLabel->FormBox["GraphPlot", TraditionalForm],
          PlotRange->All,
          PlotRangePadding->Automatic]},
        {
         Graphics3DBox[
          
          TagBox[GraphicsComplex3DBox[{{0., 0.3272146942939443, 
            0.27388283915308054`}, {0.13674248206303075`, 
            0.13576672029911907`, 1.0225231166846114`}, {0.1366472714482998, 
            1.049515805312348, 0.}, {0.00026733848408388994`, 
            0.8589785170046613, 0.7499006003151134}, {0.9078439510373331, 
            0.5928441407822556, 0.5118113179964215}, {2.4703934796615616`, 
            0.5929080928742237, 0.5117502648027377}, {3.388128282954292, 0., 
            0.2242945757319899}, {3.3881263436051547`, 1.1857283930074687`, 
            0.7987937324555249}}, {
             {RGBColor[0.5, 0., 0.], 
              Line3DBox[{{1, 2}, {1, 3}, {4, 2}, {4, 3}, {4, 1}, {5, 2}, {5, 
               3}, {5, 1}, {5, 4}, {5, 6}, {6, 7}, {6, 8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[Point3DBox[1],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[Point3DBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[Point3DBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[Point3DBox[4],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[Point3DBox[5],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[Point3DBox[6],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[Point3DBox[7],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[Point3DBox[8],
                "9"],
               Annotation[#, 9, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0., 0.3272146942939443, 
             0.27388283915308054`}, {0.13674248206303075`, 
             0.13576672029911907`, 1.0225231166846114`}, {0.1366472714482998, 
             1.049515805312348, 0.}, {0.00026733848408388994`, 
             0.8589785170046613, 0.7499006003151134}, {0.9078439510373331, 
             0.5928441407822556, 0.5118113179964215}, {2.4703934796615616`, 
             0.5929080928742237, 0.5117502648027377}, {3.388128282954292, 0., 
             0.2242945757319899}, {3.3881263436051547`, 1.1857283930074687`, 
             0.7987937324555249}}]& ],
          AspectRatio->Automatic,
          ImageSize->180,
          PlotLabel->FormBox["GraphPlot3D", TraditionalForm],
          PlotRange->All,
          PlotRangePadding->Automatic]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], 
     TagBox[GridBox[{
        {
         GraphicsBox[
          TagBox[GraphicsComplexBox[CompressedData["
1:eJxllgtQU0cUhhNCAhUFKigiWittiSIyvpCi6NmR4qNFaBUqarWCoFZ8Ua2K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            "], {
             {RGBColor[0.5, 0., 0.], 
              Arrowheads[{{0.023064257028112448`, 0.8}}], ArrowBox[{1, 2}], 
              ArrowBox[{1, 3}], 
              ArrowBox[{4, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28,
                29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 2}], 
              ArrowBox[{4, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54,
                55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 3}], 
              ArrowBox[{4, 1}], 
              ArrowBox[{5, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
                81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 
               96, 97, 98, 99, 100, 101, 102, 2}], 
              ArrowBox[{5, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 
               113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 
               125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 
               137, 3}], 
              ArrowBox[{5, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 
               148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 
               160, 161, 162, 163, 1}], ArrowBox[{5, 4}], ArrowBox[{5, 6}], 
              ArrowBox[{6, 7}], ArrowBox[{6, 8}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "9"],
               Annotation[#, 9, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0., 1.}, {-2., 0.}, {0., 0.}, {-1., 
             2.}, {-1., 3.}, {-4., 2.}, {-5., 1.}, {-4., 1.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          ImageSize->180,
          PlotLabel->FormBox["LayeredGraphPlot", TraditionalForm],
          PlotRange->All,
          PlotRangePadding->Automatic]},
        {
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0., 0.5733821790809959}, {
            0.5733821790809959, 0.5733821790809959}, {1.1467643581619917`, 
            0.5733821790809959}, {1.7201465372429876`, 0.5733821790809959}, {
            1.1467643581619917`, 1.1467643581619917`}, {2.2935287163239835`, 
            0.5733821790809959}, {2.0068376267834855`, 0.}, {
            2.5802198058644814`, 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {4, 2}, {4, 3}, {4, 1}, {5, 2}, {5, 
               3}, {5, 1}, {5, 4}, {5, 6}, {6, 7}, {6, 8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "9"],
               Annotation[#, 9, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0., 0.5733821790809959}, {
             0.5733821790809959, 0.5733821790809959}, {1.1467643581619917`, 
             0.5733821790809959}, {1.7201465372429876`, 0.5733821790809959}, {
             1.1467643581619917`, 1.1467643581619917`}, {2.2935287163239835`, 
             0.5733821790809959}, {2.0068376267834855`, 0.}, {
             2.5802198058644814`, 0.}}]& ],
          AspectRatio->0.6666666666666667,
          FrameTicks->None,
          ImageSize->180,
          PlotLabel->FormBox["TreePlot", TraditionalForm],
          PlotRange->All,
          PlotRangePadding->Automatic]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{372, 259},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->1381899581]
}, {2}]],

Cell[TextData[{
 "In these functions, a graph is represented either by a list of rules of the \
form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox[
      StyleBox["v", "TI"], 
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["1", "TR"]]], "->", 
     SubscriptBox[
      StyleBox["v", "TI"], 
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["1", "TR"]]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   SubscriptBox[
    StyleBox["i", "TI"], 
    StyleBox["1", "TR"]]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   SubscriptBox[
    StyleBox["j", "TI"], 
    StyleBox["1", "TR"]]]], "InlineFormula"],
 " are vertices, or by the adjacency matrix of the graph. Graphs in the ",
 StyleBox["Combinatorica",
  FontSlant->"Italic"],
 " package format are also supported."
}], "Text",
 CellTags->"b:0.0",
 CellID->295686867],

Cell[CellGroupData[{

Cell["Graph Theory Notations", "Section",
 CellTags->{"i:1", "b:0.0"},
 CellID->26381778],

Cell[TextData[{
 "A graph ",
 Cell[BoxData[
  FormBox[
   RowBox[{"G", "=", 
    RowBox[{"{", 
     RowBox[{"V", ",", "E"}], "}"}]}], TraditionalForm]], "InlineMath"],
 " consists of a set of vertices ",
 Cell[BoxData[
  FormBox["V", TraditionalForm]], "InlineMath"],
 " (also called nodes)",
 " ",
 "and a set of edges ",
 Cell[BoxData[
  FormBox["E", TraditionalForm]], "InlineMath"],
 ". Two vertices ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "and", "v"}], TraditionalForm]], "InlineMath"],
 " form an edge of the graph if ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"{", 
     RowBox[{"u", ",", "v"}], "}"}], "\[Element]", "E"}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Text",
 CellTags->"b:0.0",
 CellID->187590257],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"{", 
     RowBox[{"u", ",", "v"}], "}"}], "\[Element]", "E"}], TraditionalForm]], 
  "InlineMath"],
 " implies that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"{", 
     RowBox[{"v", ",", "u"}], "}"}], "\[Element]", "E"}], TraditionalForm]], 
  "InlineMath"],
 ", then ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 " is an undirected graph. Otherwise it is a directed graph, also known as a \
directed acyclic graph (DAG). The former can be drawn using line segments, \
while the latter can be drawn with arrows. In an undirected graph, it is \
often convenient to denote that an edge exists between ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]], "InlineMath"],
 " with the notation ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "\[LeftRightArrow]", "v"}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellTags->"b:0.0",
 CellID->49492652],

Cell["For example, this is a directed graph.", "MathCaption",
 CellTags->"b:0.0",
 CellID->76573419],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", " ", "->", " ", "3"}], ",", " ", 
     RowBox[{"5", " ", "->", " ", "3"}], ",", " ", 
     RowBox[{"5", " ", "->", " ", "4"}], ",", " ", 
     RowBox[{"6", " ", "->", " ", "1"}], ",", " ", 
     RowBox[{"6", " ", "->", " ", "2"}], ",", " ", 
     RowBox[{"6", " ", "->", " ", "4"}], ",", " ", 
     RowBox[{"6", " ", "->", " ", "5"}]}], "}"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->471361096],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.8789848462003222`, 0.40512657335567664`}, {
    2.733113738858003, 0.7370918526949127}, {1.8800812137971656`, 
    1.0683336030580033`}, {0.8339699596559951, 0.7370508964279406}, {0., 
    1.473915953032161}, {0.00031196653204967895`, 0.}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.030063112978640748`, 0.8}}], 
      ArrowBox[{1, 2}], ArrowBox[{3, 2}], ArrowBox[{3, 1}], ArrowBox[{4, 5}], 
      ArrowBox[{4, 6}], ArrowBox[{4, 1}], ArrowBox[{4, 3}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "2"],
       Annotation[#, 2, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.8789848462003222`, 0.40512657335567664`}, {
     2.733113738858003, 0.7370918526949127}, {1.8800812137971656`, 
     1.0683336030580033`}, {0.8339699596559951, 0.7370508964279406}, {0., 
     1.473915953032161}, {0.00031196653204967895`, 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{217., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{221, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1238678085]
}, Open  ]],

Cell["Here is an undirected graph.", "MathCaption",
 CellTags->"b:0.0",
 CellID->740228454],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"4", " ", "->", " ", "3"}], ",", " ", 
    RowBox[{"5", " ", "->", " ", "3"}], ",", " ", 
    RowBox[{"5", " ", "->", " ", "4"}], ",", " ", 
    RowBox[{"6", " ", "->", " ", "1"}], ",", " ", 
    RowBox[{"6", " ", "->", " ", "2"}], ",", " ", 
    RowBox[{"6", " ", "->", " ", "4"}], ",", " ", 
    RowBox[{"6", " ", "->", " ", "5"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1744761596],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.8789848462003222`, 0.40512657335567664`}, {
    2.733113738858003, 0.7370918526949127}, {1.8800812137971656`, 
    1.0683336030580033`}, {0.8339699596559951, 0.7370508964279406}, {0., 
    1.473915953032161}, {0.00031196653204967895`, 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {3, 2}, {3, 1}, {4, 5}, {4, 6}, {4, 1}, {4, 3}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "2"],
       Annotation[#, 2, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.8789848462003222`, 0.40512657335567664`}, {
     2.733113738858003, 0.7370918526949127}, {1.8800812137971656`, 
     1.0683336030580033`}, {0.8339699596559951, 0.7370508964279406}, {0., 
     1.473915953032161}, {0.00031196653204967895`, 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{220., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{224, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->936571727]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input Formats", "Section",
 CellTags->"b:0.0",
 CellID->231602437],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica,",
  FontSlant->"Italic"],
 " graphs can be represented by one of the following three data structures. "
}], "Text",
 CellTags->"b:0.0",
 CellID->184544861],

Cell["A graph can be represented by a list of rules.", "Text",
 CellTags->"b:0.0",
 CellID->607452952],

Cell[TextData[{
 " For example, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "1"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}]}], "}"}], TraditionalForm]], 
  "InlineMath"],
 " represents the following directed graph",
 "."
}], "MathCaption",
 CellTags->"b:0.0",
 CellID->460032087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "1"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}]}], "}"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1569627277],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.031166207415109, 0.8476089911717175}, {
    2.031392069504462, 0.}, {1.1150150060533053`, 0.42367905609906936`}, {0., 
    0.42374792835552705`}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.03365841991702141, 0.7}}], 
      ArrowBox[{1, 2}], ArrowBox[{2, 3}], ArrowBox[{3, 1}], 
      ArrowBox[{3, 4}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.031166207415109, 0.8476089911717175}, {
     2.031392069504462, 0.}, {1.1150150060533053`, 0.42367905609906936`}, {0.,
      0.42374792835552705`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{257., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{261, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->366054056]
}, Open  ]],

Cell[TextData[{
 "A graph can also be represented by its adjacency matrix. Let ",
 Cell[BoxData[
  FormBox[
   RowBox[{"G", " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{"V", ",", " ", "E"}], "}"}]}], TraditionalForm]], "InlineMath"],
 " be a directed graph. Assuming that the vertices are indices from ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ", that is, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"V", "=", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "\[Ellipsis]", ",", "n"}], "}"}]}], 
   TraditionalForm]], "InlineMath"],
 ", then the adjacency matrix of ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 " is an ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "\[Times]", "n"}], TraditionalForm]], "InlineMath"],
 " matrix, with entries ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", 
     RowBox[{"i", "\[InvisibleSpace]", "j"}]], "=", "1"}], TraditionalForm]], 
  "InlineMath"],
 " if ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"{", 
     RowBox[{"i", ",", "j"}], "}"}], "\[Element]", "E"}], TraditionalForm]], 
  "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", 
     RowBox[{"i", "\[InvisibleSpace]", "j"}]], "=", "0"}], TraditionalForm]], 
  "InlineMath"],
 " otherwise."
}], "Text",
 CellTags->"b:0.0",
 CellID->206274755],

Cell["\<\
The following adjacency matrix represents the same directed graph.\
\>", "MathCaption",
 CellTags->"b:0.0",
 CellID->577233883],

Cell[BoxData[
 FormBox[
  RowBox[{"(", GridBox[{
     {"0", "1", "0", "0"},
     {"0", "0", "1", "0"},
     {"1", "0", "0", "1"},
     {"0", "0", "0", "0"}
    }], ")"}], TraditionalForm]], "DisplayMath",
 CellTags->"b:0.0",
 CellID->72624360],

Cell[TextData[{
 "An undirected graph, on the other hand, is represented by a symmetric \
adjacency matrix. The matrix entries ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", 
     RowBox[{"i", "\[InvisibleSpace]", "j"}]], "=", 
    RowBox[{
     SubscriptBox["a", 
      RowBox[{"j", "\[InvisibleSpace]", "i"}]], "=", "1"}]}], 
   TraditionalForm]], "InlineMath"],
 " if ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"{", 
     RowBox[{"i", ",", "j"}], "}"}], "\[Element]", "E"}], TraditionalForm]], 
  "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", 
     StyleBox[
      RowBox[{"i", "\[InvisibleSpace]", "j"}],
      FontSlant->"Italic"]], "=", "0"}], TraditionalForm]], "InlineMath"],
 " otherwise."
}], "Text",
 CellTags->"b:0.0",
 CellID->486914829],

Cell["\<\
This adjacency matrix represents the undirected graph that follows it.\
\>", "MathCaption",
 CellTags->"b:0.0",
 CellID->389792830],

Cell[BoxData[
 FormBox[
  RowBox[{"(", GridBox[{
     {"0", "1", "1", "0"},
     {"1", "0", "1", "0"},
     {"1", "1", "0", "1"},
     {"0", "0", "1", "0"}
    }], ")"}], TraditionalForm]], "DisplayMath",
 CellTags->"b:0.0",
 CellID->18154319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   FormBox[
    RowBox[{"(", GridBox[{
       {"0", "1", "1", "0"},
       {"1", "0", "1", "0"},
       {"1", "1", "0", "1"},
       {"0", "0", "1", "0"}
      }], ")"}],
    TraditionalForm], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1463241116],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.031166207415109, 0.8476089911717175}, {
    2.031392069504462, 0.}, {1.1150150060533053`, 0.42367905609906936`}, {0., 
    0.42374792835552705`}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{{1, 2}, {1, 3}, {2, 3}, {3, 4}}]}, {
      InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.031166207415109, 0.8476089911717175}, {
     2.031392069504462, 0.}, {1.1150150060533053`, 0.42367905609906936`}, {0.,
      0.42374792835552705`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{243., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{247, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->682957595]
}, Open  ]],

Cell[TextData[{
 "Because of the zero entries in an adjacency matrix, it is often convenient \
to represent the matrix using a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.0",
 CellID->456407675],

Cell["\<\
The previous matrix can be written as the following sparse array.\
\>", "MathCaption",
 CellTags->"b:0.0",
 CellID->393688691],

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "3"}], "}"}], "\[Rule]", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "4"}], "}"}]}], "]"}], ";"}]], "Input",
 CellTags->"b:0.0",
 CellLabel->"In[6]:=",
 CellID->19032932],

Cell[TextData[{
 "Finally, graphs in the ",
 StyleBox["Combinatorica",
  FontSlant->"Italic"],
 " package format are also supported."
}], "Text",
 CellTags->"b:0.0",
 CellID->52142691],

Cell[TextData[{
 "This example creates a butterfly graph using ",
 StyleBox["Combinatorica",
  FontSlant->"Italic"],
 " and shows the layout ",
 StyleBox["Combinatorica",
  FontSlant->"Italic"],
 " assigned",
 "."
}], "MathCaption",
 CellTags->"b:0.1",
 CellID->75897099],

Cell[BoxData[
 RowBox[{
  RowBox[{"<<", "Combinatorica`"}], ";"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[7]:=",
 CellID->518567599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"ButterflyGraph", "[", "3", "]"}]}], ";", " ", 
  RowBox[{"ShowGraph", "[", "g", "]"}]}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[8]:=",
 CellID->1531202620],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{177, 177},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[8]=",
 CellID->413283960]
}, Open  ]],

Cell[TextData[{
 "This draws the same graph using ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->"b:0.1",
 CellID->621000783],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", "g", "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[9]:=",
 CellID->67598844],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{3.190151854183597, 3.171315400488597}, {
    3.5861697132098755`, 2.2996233842704514`}, {3.931947180844844, 
    1.3544271914855508`}, {3.5254337676495515`, 0.4292514103361922}, {
    0.9856467570907679, 0.933022600027543}, {1.660499984321204, 
    0.36270948133062775`}, {2.6090438338809445`, 0.023291997723640323`}, {
    3.710356401587318, 0.2585895493918602}, {3.6660110038784337`, 
    3.6787347182171604`}, {3.9209948955912806`, 2.5803415414162156`}, {
    3.592796613994419, 1.6380895200104097`}, {2.989392370155172, 
    0.9799854205487467}, {0.2935273144709043, 0.20212744462334276`}, {
    1.4094965799839385`, 0.}, {2.3358893543145633`, 0.377676540153145}, {
    3.2193391869857777`, 0.7663260431391659}, {2.973893618674266, 
    2.946533840600709}, {2.2859552453495002`, 3.5180448234120503`}, {
    1.5935638035385062`, 3.5029186964465557`}, {0.7128604601420092, 
    3.1300327202032516`}, {0.7683324913683631, 0.708182105657744}, {
    0.35753495931303925`, 1.575199970264575}, {0.3494612290100978, 
    2.2476196481806103`}, {0.933563175420276, 2.9148756282457553`}, {
    3.4923121055365147`, 3.50517512285964}, {2.5438085085555633`, 
    3.882325286463611}, {1.330585324601122, 3.867581496627391}, {
    0.3991957222549558, 3.4554510289192546`}, {0.48591412764069664`, 
    0.3584142883058241}, {0.03265855573811316, 1.2890699055152304`}, {0., 
    2.5168585202879137`}, {0.22903819863892583`, 3.632144921849198}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 18}, {2, 3}, {2, 11}, {2, 17}, {3, 4}, {3, 8}, {3, 
       10}, {4, 7}, {5, 6}, {5, 22}, {6, 7}, {6, 15}, {6, 21}, {7, 8}, {7, 
       14}, {9, 10}, {9, 26}, {10, 11}, {10, 25}, {11, 12}, {11, 16}, {12, 
       15}, {13, 14}, {13, 30}, {14, 15}, {14, 29}, {15, 16}, {17, 18}, {18, 
       19}, {18, 27}, {19, 20}, {19, 24}, {19, 26}, {20, 23}, {21, 22}, {22, 
       23}, {22, 31}, {23, 24}, {23, 30}, {25, 26}, {26, 27}, {27, 28}, {27, 
       32}, {28, 31}, {29, 30}, {30, 31}, {31, 32}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "30"],
       Annotation[#, 30, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "31"],
       Annotation[#, 31, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        "32"],
       Annotation[#, 32, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{3.190151854183597, 3.171315400488597}, {
     3.5861697132098755`, 2.2996233842704514`}, {3.931947180844844, 
     1.3544271914855508`}, {3.5254337676495515`, 0.4292514103361922}, {
     0.9856467570907679, 0.933022600027543}, {1.660499984321204, 
     0.36270948133062775`}, {2.6090438338809445`, 0.023291997723640323`}, {
     3.710356401587318, 0.2585895493918602}, {3.6660110038784337`, 
     3.6787347182171604`}, {3.9209948955912806`, 2.5803415414162156`}, {
     3.592796613994419, 1.6380895200104097`}, {2.989392370155172, 
     0.9799854205487467}, {0.2935273144709043, 0.20212744462334276`}, {
     1.4094965799839385`, 0.}, {2.3358893543145633`, 0.377676540153145}, {
     3.2193391869857777`, 0.7663260431391659}, {2.973893618674266, 
     2.946533840600709}, {2.2859552453495002`, 3.5180448234120503`}, {
     1.5935638035385062`, 3.5029186964465557`}, {0.7128604601420092, 
     3.1300327202032516`}, {0.7683324913683631, 0.708182105657744}, {
     0.35753495931303925`, 1.575199970264575}, {0.3494612290100978, 
     2.2476196481806103`}, {0.933563175420276, 2.9148756282457553`}, {
     3.4923121055365147`, 3.50517512285964}, {2.5438085085555633`, 
     3.882325286463611}, {1.330585324601122, 3.867581496627391}, {
     0.3991957222549558, 3.4554510289192546`}, {0.48591412764069664`, 
     0.3584142883058241}, {0.03265855573811316, 1.2890699055152304`}, {0., 
     2.5168585202879137`}, {0.22903819863892583`, 3.632144921849198}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageMargins->{{0., 0.}, {0., 0.}},
  ImageSize->{231., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{235, 228},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[9]=",
 CellID->1488694231]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " uses the algorithms described in the next section to lay out a graph. If \
",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " is to be used for a graph in ",
 StyleBox["Combinatorica",
  FontSlant->"Italic"],
 " format, but the drawing assigned by ",
 StyleBox["Combinatorica",
  FontSlant->"Italic"],
 " is to be preserved, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 " can be specified."
}], "Text",
 CellID->949616064],

Cell[TextData[{
 "Option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 " draws the graph using layout from ",
 StyleBox["Combinatorica",
  FontSlant->"Italic"],
 "."
}], "MathCaption",
 CellID->906788346],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Method", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->423083302],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1., -3.5}, {2., -3.5}, {3., -3.5}, {4., -3.5}, {
    1., -2.5}, {2., -2.5}, {3., -2.5}, {4., -2.5}, {1., -1.5}, {2., -1.5}, {
    3., -1.5}, {4., -1.5}, {1., -0.5}, {2., -0.5}, {3., -0.5}, {4., -0.5}, {
    1., 0.5}, {2., 0.5}, {3., 0.5}, {4., 0.5}, {1., 1.5}, {2., 1.5}, {3., 
    1.5}, {4., 1.5}, {1., 2.5}, {2., 2.5}, {3., 2.5}, {4., 2.5}, {1., 3.5}, {
    2., 3.5}, {3., 3.5}, {4., 3.5}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 18}, {2, 3}, {2, 11}, {2, 17}, {3, 4}, {3, 8}, {3, 
       10}, {4, 7}, {5, 6}, {5, 22}, {6, 7}, {6, 15}, {6, 21}, {7, 8}, {7, 
       14}, {9, 10}, {9, 26}, {10, 11}, {10, 25}, {11, 12}, {11, 16}, {12, 
       15}, {13, 14}, {13, 30}, {14, 15}, {14, 29}, {15, 16}, {17, 18}, {18, 
       19}, {18, 27}, {19, 20}, {19, 24}, {19, 26}, {20, 23}, {21, 22}, {22, 
       23}, {22, 31}, {23, 24}, {23, 30}, {25, 26}, {26, 27}, {27, 28}, {27, 
       32}, {28, 31}, {29, 30}, {30, 31}, {31, 32}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "30"],
       Annotation[#, 30, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "31"],
       Annotation[#, 31, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        "32"],
       Annotation[#, 32, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1., -3.5}, {2., -3.5}, {3., -3.5}, {
     4., -3.5}, {1., -2.5}, {2., -2.5}, {3., -2.5}, {4., -2.5}, {1., -1.5}, {
     2., -1.5}, {3., -1.5}, {4., -1.5}, {1., -0.5}, {2., -0.5}, {3., -0.5}, {
     4., -0.5}, {1., 0.5}, {2., 0.5}, {3., 0.5}, {4., 0.5}, {1., 1.5}, {2., 
     1.5}, {3., 1.5}, {4., 1.5}, {1., 2.5}, {2., 2.5}, {3., 2.5}, {4., 2.5}, {
     1., 3.5}, {2., 3.5}, {3., 3.5}, {4., 3.5}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{119.71428571428572`, Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{124, 278},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->1770740929]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graph Drawing Algorithms", "Section",
 CellTags->"b:0.1",
 CellID->194525651],

Cell[TextData[{
 "Graphs are often used to encapsulate the relationship between items. Graph \
drawing enables visualization of these relationships. The usefulness of the \
visual representation depends upon whether the drawing is aesthetic. While \
there are no strict criteria for aesthetic drawing, it is generally agreed \
that such a drawing has minimal edge crossing and even spacing between \
vertices. This problem has been studied extensively in the literature [",
 Cell[BoxData[
  ButtonBox["1",
   BaseStyle->"Link",
   ButtonData->"paclet:tutorial/GraphDrawingIntroduction#25676449"]], 
  "InlineFormula"],
 "], and many approaches have been proposed. Two popular straight-edge \
drawing algorithms, the spring embedding and spring-electrical embedding, \
work by minimizing the energy of physical models of the graph. The \
high-dimensional embedding method, on the other hand, embedding a graph in \
high-dimensional space and then projecting back to two- or three-dimensional \
space. In addition, there are algorithms for drawing directed graphs in a \
hierarchical fashion, as well as for drawing trees. Random embedding, \
circular embedding, and spiral embedding do not utilize any connectivity \
information for laying out a graph, and therefore are not described any \
further here."
}], "Text",
 CellTags->"b:0.1",
 CellID->465767437],

Cell[CellGroupData[{

Cell["Spring embedding", "Subsection",
 CellTags->{"spring model", "b:0.1"},
 CellID->301083942],

Cell["\<\
The spring embedding algorithm assigns force between each pair of nodes. When \
two nodes are too close together, a repelling force comes into effect. When \
two nodes are too far apart, they are subject to an attractive force. This \
scenario can be illustrated by linking the vertices with \
springs\[LongDash]hence the name \"spring embedding\". \
\>", "Text",
 CellTags->"b:0.1",
 CellID->176133299],

Cell["\<\
This algorithm works by adding springs to all edges and adding looser springs \
to all vertex pairs that are not adjacent. Thus, in two dimensions, the total \
energy of the system is \
\>", "Text",
 CellTags->"b:0.1",
 CellID->270261448],

Cell[BoxData[
 FormBox[
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"i", "=", "1"}], 
    RowBox[{
     RowBox[{"\[LeftBracketingBar]", "V", "\[RightBracketingBar]"}], "-", 
     "1"}]], 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"j", "=", 
      RowBox[{"i", "+", "1"}]}], 
     RowBox[{"\[LeftBracketingBar]", "V", "\[RightBracketingBar]"}]], 
    RowBox[{
     SubscriptBox["k", "ij"], "  ", 
     SuperscriptBox[
      RowBox[{"(", " ", 
       RowBox[{"||", 
        RowBox[{
         SubscriptBox["x", "i"], "-", 
         SubscriptBox["x", "j"]}], 
        SuperscriptBox["||", "2"], 
        RowBox[{"-", " ", 
         SubscriptBox["l", 
          StyleBox["ij",
           FontSlant->"Italic"]]}]}], " ", ")"}], "2"]}]}]}], 
  TraditionalForm]], "DisplayMath",
 CellTags->"b:0.1",
 CellID->40464462],

Cell[TextData[{
 "Here, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "j"], TraditionalForm]], "InlineMath"],
 " are the coordinate vectors of nodes ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]], "InlineMath"],
 ", and",
 Cell[BoxData[
  FormBox[
   RowBox[{"||", 
    RowBox[{
     SubscriptBox["x", "i"], "-", 
     SubscriptBox["x", "j"]}], "||"}], TraditionalForm]], "InlineMath"],
 " is the Euclidean distance between them. ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["l", 
    RowBox[{"i", "\[InvisibleSpace]", "j"}]], TraditionalForm]], 
  "InlineMath"],
 " is the natural length of the spring between vertex ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " and vertex ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]], "InlineMath"],
 ", and can be chosen as the graph distance between ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]], "InlineMath"],
 ". The parameters ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["k", 
     RowBox[{"i", "\[InvisibleSpace]", "j"}]], "=", 
    RowBox[{"R", "/", 
     SuperscriptBox[
      SubscriptBox["l", 
       RowBox[{"i", "\[InvisibleSpace]", "j"}]], "2"]}], " "}], 
   TraditionalForm]], "InlineMath"],
 "are the strength of the springs, where ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 " is a parameter representing the strength of the strings.",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", "V", "|"}], TraditionalForm]], "InlineMath"],
 " is the number of vertices. "
}], "Text",
 CellTags->"b:0.1",
 CellID->352667799],

Cell["\<\
The layout of the graph vertices is calculated by minimizing this energy \
function. One way to minimize the energy function is by iteratively moving \
each of the vertices along the direction of the spring force until an \
approximate equilibrium is reached. Multilevel techniques are used to \
overcome local minima.\
\>", "Text",
 CellTags->"b:0.1",
 CellID->65696215],

Cell["\<\
The spring embedding works particularly well for problems like regular grid \
graphs, in which it is possible to lay out the graph so that Euclidean \
distances between vertices are proportional to the graph distances. \
\>", "Text",
 CellTags->"b:0.1",
 CellID->1055789860],

Cell["\<\
This draws a 20\[Times]20 grid graph using the spring embedding algorithm.\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->397360721],

Cell[BoxData[
 RowBox[{
  RowBox[{"<<", "Combinatorica`"}], ";"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[11]:=",
 CellID->232833340],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"GridGraph", "[", 
    RowBox[{"20", ",", "20"}], "]"}], ",", 
   RowBox[{"Method", "\[Rule]", "\"\<SpringEmbedding\>\""}]}], "]"}]], "Input",\

 CellTags->"b:0.1",
 CellLabel->"In[12]:=",
 CellID->557662836],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{185, 185},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[12]=",
 CellID->68165165]
}, Open  ]],

Cell[TextData[{
 "This method does, however, require more memory and CPU time. To reduce its \
",
 Cell[BoxData[
  FormBox[
   RowBox[{"O", "(", 
    RowBox[{"|", "V", 
     SuperscriptBox["|", "2"]}], ")"}], TraditionalForm]], "InlineMath"],
 " complexity, vertices that are far apart are ignored in the calculation of \
force and energy. See the method option ",
 Cell[BoxData["\"\<InferentialDistance\>\""], "InlineFormula"],
 " of ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["GraphPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFormula"],
 " for more information."
}], "Text",
 CellTags->"b:0.1",
 CellID->392929208]
}, Open  ]],

Cell[CellGroupData[{

Cell["Spring-electrical embedding", "Subsection",
 CellTags->{"spring-electrical model", "b:0.1"},
 CellID->425607435],

Cell[TextData[{
 "The disadvantage of the spring embedding algorithm is that it requires \
knowing the graph distance between every pair of vertices. Spring-electrical \
embedding uses two forces. The attractive force, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["f", "a"], "=", 
    RowBox[{
     SuperscriptBox[
      SubscriptBox["d", 
       RowBox[{"i", "\[InvisibleSpace]", "j"}]], "2"], "/", "K"}]}], 
   TraditionalForm]], "InlineMath"],
 ", is restricted to adjacent vertices and is proportional to the Euclidean \
distance between them, where ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]], "InlineMath"],
 " is related to the natural spring length. The electrical force, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["f", "r"], " ", "=", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["K", "2"]}], "/", 
     SubscriptBox["d", 
      RowBox[{"i", "\[InvisibleSpace]", "j"}]]}]}], TraditionalForm]], 
  "InlineMath"],
 ", on the other hand, is global and is inversely proportional to the \
Euclidean distance between nodes ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]], "InlineMath"],
 ". Overall, the energy to be minimized is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"i", "=", "1"}], 
     RowBox[{"|", "V", "|"}]], 
    SuperscriptBox[
     SubscriptBox["f", 
      SubscriptBox["", "i"]], "2"]}], TraditionalForm]], "InlineMath"],
 ", where"
}], "Text",
 CellTags->"b:0.1",
 CellID->12708941],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["f", "i"], "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "C"}], " ", 
      RowBox[{
       UnderscriptBox["\[Sum]", 
        RowBox[{"j", "\[NotEqual]", "i"}]], " ", 
       RowBox[{
        FractionBox[
         SuperscriptBox["K", "2"], 
         SubscriptBox["d", 
          StyleBox["ij",
           FontSlant->"Italic"]]], 
        FractionBox[
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["x", "j"], "-", 
           SubscriptBox["x", "i"]}], ")"}], 
         SubscriptBox["d", 
          StyleBox["ij",
           FontSlant->"Italic"]]]}]}]}], "+", 
     RowBox[{
      UnderscriptBox["\[Sum]", 
       RowBox[{"i", "\[LongLeftRightArrow]", "j"}]], 
      RowBox[{
       FractionBox[
        SuperscriptBox[
         SubscriptBox["d", 
          StyleBox["ij",
           FontSlant->"Italic"]], "2"], "K"], " ", 
       FractionBox[
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["x", "j"], "-", 
          SubscriptBox["x", "i"]}], ")"}], 
        SubscriptBox["d", 
         StyleBox["ij",
          FontSlant->"Italic"]]]}]}]}], " ", "=", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "C"}], " ", 
      RowBox[{
       UnderscriptBox["\[Sum]", 
        RowBox[{"j", "\[NotEqual]", "i"}]], 
       RowBox[{
        FractionBox[
         SuperscriptBox["K", "2"], 
         SuperscriptBox[
          SubscriptBox["d", 
           StyleBox["ij",
            FontSlant->"Italic"]], "2"]], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["x", "j"], "-", 
          SubscriptBox["x", "i"]}], ")"}]}]}]}], " ", "+", 
     RowBox[{
      UnderscriptBox["\[Sum]", 
       RowBox[{
        RowBox[{"i", "<"}], "\[Rule]", "j"}]], 
      RowBox[{
       FractionBox[
        SubscriptBox["d", 
         StyleBox["ij",
          FontSlant->"Italic"]], "K"], 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["x", "j"], "-", 
         SubscriptBox["x", "i"]}], ")"}]}]}]}]}]}], 
  TraditionalForm]], "DisplayMath",
 CellTags->"b:0.1",
 CellID->268030069],

Cell[TextData[{
 "Here, ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath"],
 " is a constant that regulates the relative strength of the repulsive and \
attractive forces, and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["d", 
     RowBox[{"i", "\[InvisibleSpace]", "j"}]], "=", 
    RowBox[{"||", 
     RowBox[{
      SubscriptBox["x", "i"], "-", 
      SubscriptBox["x", "j"]}], "||"}]}], TraditionalForm]], "InlineMath"],
 " is the Euclidean distance between nodes ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]], "InlineMath"],
 ". For a graph of two vertices, the ideal Euclidean distance between the \
vertices is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"K", " ", 
    SuperscriptBox["C", 
     RowBox[{"1", "/", "3"}]]}], TraditionalForm]], "InlineMath"],
 ", which gives a total energy of zero."
}], "Text",
 CellTags->"b:0.1",
 CellID->605554554],

Cell["\<\
The layout of the graph vertices is calculated by minimizing the energy \
function. One way to do this is by iteratively moving each of the vertices \
along the direction of the spring force until an approximate equilibrium is \
reached. Multilevel techniques are used to overcome local minima, and an \
octree data structure is used to reduce the computational complexity in some \
cases.\
\>", "Text",
 CellTags->"b:0.1",
 CellID->27523184],

Cell[TextData[{
 "In general, spring-electrical embedding works well for most problems. With \
multilevel and octree techniques, it is implemented very efficiently with a \
complexity of about ",
 Cell[BoxData[
  FormBox[
   RowBox[{"O", "(", 
    RowBox[{"|", "V", "|", 
     RowBox[{"log", "(", 
      RowBox[{"|", "V", "|"}], ")"}]}], ")"}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Text",
 CellTags->"b:0.1",
 CellID->1655679217],

Cell[TextData[{
 " This shows the drawing of a 20\[Times]20 grid graph using ",
 Cell[BoxData["\"\<SpringElectricalEmbedding\>\""], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->"b:0.1",
 CellID->470653372],

Cell[BoxData[
 RowBox[{
  RowBox[{"<<", "Combinatorica`"}], ";"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[13]:=",
 CellID->299574666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"GridGraph", "[", 
    RowBox[{"20", ",", "20"}], "]"}], ",", 
   RowBox[{"Method", "\[Rule]", "\"\<SpringElectricalEmbedding\>\""}]}], 
  "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[14]:=",
 CellID->760805916],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{199, 187},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[14]=",
 CellID->313166313]
}, Open  ]],

Cell[TextData[{
 "A side effect of this algorithm is that vertices at the periphery tend to \
be closer to each other than those in the center, as seen in the above \
drawing. This tendency can be alleviated with the method option ",
 Cell[BoxData["\"\<RepulsiveForcePower\>\""], "InlineFormula"],
 ", which is described in \"",
 ButtonBox["Graph Drawing",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GraphDrawing"],
 "\"."
}], "Text",
 CellTags->"b:0.1",
 CellID->519376322]
}, Open  ]],

Cell[CellGroupData[{

Cell["High-dimensional embedding algorithm", "Subsection",
 CellTags->{"high-dimensional embedding", "b:0.1"},
 CellID->105832149],

Cell[TextData[{
 "In the high-dimensional embedding method, a graph is embedded in \
high-dimensional space, and then projected back to two- or three-dimensional \
space. First, a ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 "-dimensional coordinate system is created based on ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " centers. The centers are a set of ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " vertices that are chosen to be as far apart as possible. The first vertex \
is selected at random, and then each of the remaining centers is chosen as \
the farthest vertex from the previously selected centers. In other words, if \
",
 Cell[BoxData[
  FormBox["j", TraditionalForm]], "InlineMath"],
 " centers have been selected, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["c", 
    RowBox[{
     StyleBox["j",
      FontSlant->"Italic"], 
     StyleBox["+",
      FontSlant->"Plain"], 
     StyleBox["1",
      FontSlant->"Plain"]}]], TraditionalForm]], "InlineMath"],
 " is the vertex whose shortest graph distance to the ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]], "InlineMath"],
 " centers is larger than or equal to the shortest graph distance of all the \
other vertices to the ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]], "InlineMath"],
 " centers. "
}], "Text",
 CellTags->"b:0.1",
 CellID->584621403],

Cell[TextData[{
 "With these ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "centers, a ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 "-dimensional coordinate system can be established. Each vertex ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["u", "i"], TraditionalForm]], "InlineMath"],
 " has the coordinates ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "i"], "=", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["d", 
       RowBox[{
        SubscriptBox["u", "i"], 
        SubscriptBox["c", "1"]}]], ",", 
      SubscriptBox["d", 
       RowBox[{
        SubscriptBox["u", "i"], 
        SubscriptBox["c", "2"]}]], ",", "\[Ellipsis]", ",", 
      SubscriptBox["d", 
       RowBox[{
        SubscriptBox["u", "i"], 
        SubscriptBox["c", "k"]}]]}], "}"}]}], TraditionalForm]], 
  "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["d", 
    RowBox[{
     SubscriptBox["u", "i"], 
     SubscriptBox[
      StyleBox["c",
       FontSlant->"Italic"], "j"]}]], TraditionalForm]], "InlineMath"],
 " is the graph distance between the vertex ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["u", "i"], TraditionalForm]], "InlineMath"],
 " and the center ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["c", "i"], TraditionalForm]], "InlineMath"],
 ". The ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "\[InvisibleSpace]", "k"}], TraditionalForm]], "InlineMath"],
 "-dimensional coordinate vectors form an ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "\[Times]", "k"}], TraditionalForm]], "InlineMath"],
 " matrix ",
 Cell[BoxData[
  FormBox["X", TraditionalForm]], "InlineMath"],
 StyleBox[", ",
  FontSlant->"Italic"],
 "where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
 " is the ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " row of ",
 Cell[BoxData[
  FormBox["X", TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellTags->"b:0.1",
 CellID->280170679],

Cell[TextData[{
 "Since it is only possible to draw in two and three dimensions, and since \
the coordinates are correlated, the ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 "-dimensional coordinates are projected back to two or three dimensions by a \
suitable linear combination. Assume that the graph with ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " coordinates and ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " centers is projected back to two dimensions. In order to make this \
projection shift-invariant, ",
 Cell[BoxData[
  FormBox["X", TraditionalForm]], "InlineMath"],
 " is first normalized to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["X", "'"], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellTags->"b:0.1",
 CellID->366643026],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["X", "'"], "=", 
   RowBox[{
    RowBox[{"X", " ", "-", " ", 
     RowBox[{"e", " ", 
      SuperscriptBox["e", "T"], " ", 
      RowBox[{"X", "/", "n"}]}]}], ",", " ", 
    RowBox[{"e", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "\[Ellipsis]", ",", "1"}], "}"}]}]}]}], 
  TraditionalForm]], "DisplayMath",
 CellTags->"b:0.1",
 CellID->164473343],

Cell[TextData[{
 "Let ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["v", "1"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["v", "2"], TraditionalForm]], "InlineMath"],
 " be two ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 "-dimensional vectors we need to find for the purpose of linear combination. \
The two linear combinations should be uncorrelated, so they must be \
orthogonal to each other."
}], "Text",
 CellTags->"b:0.1",
 CellID->28964186],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["X", "'"], " ", 
       SubscriptBox["v", "1"]}], ")"}], "T"], " ", 
    SuperscriptBox["X", "'"], " ", 
    SubscriptBox["v", "2"]}], " ", "=", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      SubscriptBox["v", "1"], "T"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["X", 
        RowBox[{"'", "T"}]], " ", 
       SuperscriptBox["X", "'"]}], ")"}], " ", 
     SubscriptBox["v", "2"]}], " ", "=", " ", "0"}]}], 
  TraditionalForm]], "DisplayMath",
 CellTags->"b:0.1",
 CellID->247416686],

Cell["Each must be as far away from 0 as possible. ", "Text",
 CellTags->"b:0.1",
 CellID->46564267],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox[
       SubscriptBox["v", "i"], "T"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["X", 
         RowBox[{"'", "T"}]], " ", 
        SuperscriptBox["X", "'"]}], ")"}], " ", 
      RowBox[{
       SubscriptBox["v", "i"], " ", "/"}]}], " ", "||", 
     SubscriptBox["v", "i"], 
     SuperscriptBox["||", "2"]}], " ", "\[Rule]", " ", "max"}], ",", "  ", 
   RowBox[{"i", " ", "=", " ", "1"}], ",", " ", "2"}], 
  TraditionalForm]], "DisplayMath",
 CellTags->"b:0.1",
 CellID->911136577],

Cell[TextData[{
 "To achieve this, we therefore select ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["v", "1"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["v", "2"], TraditionalForm]], "InlineMath"],
 " be the two eigenvectors that correspond to the first two largest \
eigenvalues of the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"k", "\[Times]", "k"}], TraditionalForm]], "InlineMath"],
 " symmetric matrix ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["X", 
     RowBox[{"'", "T"}]], 
    SuperscriptBox[
     StyleBox["X",
      FontSlant->"Italic"], "'"]}], TraditionalForm]], "InlineMath"],
 ". This process of choosing two highly uncorrelated vectors is also known as \
principal component analysis."
}], "Text",
 CellTags->"b:0.1",
 CellID->629305703],

Cell[TextData[{
 "In summary, for two-dimensional drawing, the high-dimensional embedding \
method uses the coordinates of the vertices given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["X", "'"], 
    SubscriptBox["v", "1"]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["X", "'"], 
    RowBox[{
     SubscriptBox["v", "2"], "."}]}], TraditionalForm]], "InlineMath"]
}], "Text",
 CellTags->"b:0.1",
 CellID->102602607],

Cell[TextData[{
 " This shows the drawing of a 20\[Times]20 grid graph using ",
 Cell[BoxData["\"\<HighDimensionalEmbedding\>\""], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->"b:0.1",
 CellID->1422530350],

Cell[BoxData[
 RowBox[{
  RowBox[{"<<", "Combinatorica`"}], ";"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[15]:=",
 CellID->565700163],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"GridGraph", "[", 
    RowBox[{"20", ",", "20"}], "]"}], ",", 
   RowBox[{"Method", "\[Rule]", "\"\<HighDimensionalEmbedding\>\""}]}], 
  "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[16]:=",
 CellID->99263445],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{179, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[16]=",
 CellID->382903097]
}, Open  ]],

Cell[TextData[{
 "The high-dimensional embedding method tends to be very fast but its results \
are often of lower quality than force-directed algorithms. The method can be \
specified with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", 
   "\"\<HighDimensionalEmbedding\>\""}]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["GraphPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.1",
 CellID->213368396]
}, Open  ]],

Cell[CellGroupData[{

Cell["A hierarchical drawing algorithm for directed graphs", "Subsection",
 CellTags->{"trees", "b:0.1", "LayereDigraphDrawing"},
 CellID->447313943],

Cell[TextData[{
 "The algorithm for drawing directed acyclic graphs (DAGs) follows the \
algorithm of Sugiyama et al. [",
 Cell[BoxData[
  ButtonBox["14",
   BaseStyle->"Link",
   ButtonData->"paclet:tutorial/GraphDrawingIntroduction#467855775"]], 
  "InlineFormula"],
 "], and subsequent development [",
 Cell[BoxData[
  ButtonBox["15",
   BaseStyle->"Link",
   ButtonData->"paclet:tutorial/GraphDrawingIntroduction#106127544"]], 
  "InlineFormula"],
 "]. It consists of the following stages:"
}], "Text",
 CellID->87279083],

Cell[TextData[{
 "Vertices of the DAG are first assigned a preliminary ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 "-ranking such that if there is an edge from ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]], "InlineMath"],
 ", then it is likely that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["yrank",
      FontSlant->"Italic"], "(", "i", ")"}], ">", 
    RowBox[{
     StyleBox["yrank",
      FontSlant->"Italic"], "(", "j", ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". This is to ensure that the final drawing has directed edges pointing \
mostly downward."
}], "ItemizedText",
 CellID->69175192],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " coordinates are generated so that if there is an edge from ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["yrank",
      FontSlant->"Italic"], "(", "i", ")"}], ">", 
    RowBox[{
     StyleBox["yrank",
      FontSlant->"Italic"], "(", "j", ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ", their ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " coordinates are as close as possible, but separated by a set minimum. This \
ensures that the final resulting drawing does not have many long edges. This \
process assigns the vertices into a finite number of layers. If an edge lies \
across a number of layers, virtual vertices are added."
}], "ItemizedText",
 CellID->44131576],

Cell[TextData[{
 "A preliminary ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 "-ranking is assigned to each vertex to minimize the number of edge \
crossings."
}], "ItemizedText",
 CellID->92244645],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " coordinates are generated by minimizing ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Sum]", 
     RowBox[{"i", "\[Rule]", "j"}]], 
    RowBox[{"|", 
     RowBox[{
      RowBox[{"x", "(", "i", ")"}], "-", 
      RowBox[{"x", "(", "j", ")"}]}], "|"}]}], TraditionalForm]], 
  "InlineMath"],
 " subject to the constraints that vertices on the same layer obey the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 "-ranking generated in step 3 and are separated by a set minimum."
}], "ItemizedText",
 CellID->83769734],

Cell[TextData[{
 "The resulting drawing lays out the graph in a hierarchical structure, where \
most of the edges point downward.",
 " ",
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 StyleBox[" ",
  FontFamily->"Courier",
  FontColor->RGBColor[1, 0, 0]],
 "function implements this algorithm."
}], "Text",
 CellID->826523325]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algorithms for drawing trees", "Subsection",
 CellTags->{"trees", "b:0.1"},
 CellID->437048596],

Cell[TextData[{
 "Two algorithms for drawing trees are the radial drawing algorithm and the \
layered drawing algorithm [",
 Cell[BoxData[
  ButtonBox["1",
   BaseStyle->"Link",
   ButtonData->"paclet:tutorial/GraphDrawingIntroduction#25676449"]], 
  "InlineFormula"],
 "]. In the radial drawing algorithm, a reasonable root of the tree is \
chosen. Then, starting from that root of the tree, each subtree is drawn \
inside a wedge, with the angle of the wedge proportional to the number of \
leaves in that subtree. In the layered drawing algorithm, a reasonable root \
of the tree is chosen. Then, starting from that root, subtrees of the root \
are recursively drawn such that vertices on the same level have the same ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " coordinate, and the horizontally closest vertices of adjacent subtrees are \
of unit distance apart. The root is placed at the center of the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " coordinates of its subtrees and its ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " coordinate is one unit above them. ",
 Cell[BoxData[
  ButtonBox["TreePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreePlot"]], "InlineFormula"],
 " function chooses between these two algorithms, depending on the second \
argument of this function."
}], "Text",
 CellTags->"b:0.1",
 CellID->11527193]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Selecting the appropriate graph drawing function", "Section",
 CellTags->"b:0.1",
 CellID->192062428],

Cell[TextData[{
 "For general graph drawing, consider using ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["GraphPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 "/",
 Cell[BoxData[
  ButtonBox["GraphPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFormula"],
 " calculates a visually appealing 2D/3D layout and plots the graph using \
this layout. See ",
 ButtonBox["General Graph Drawing: ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GraphDrawing"],
 StyleBox[ButtonBox["GraphPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GraphDrawing"], "InlineFormula"],
 ButtonBox[" and ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GraphDrawing"],
 StyleBox[ButtonBox["GraphPlot3D",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GraphDrawing"], "InlineFormula"],
 " for these functions, and [16] for algorithmic details."
}], "Text",
 CellTags->"b:0.1",
 CellID->977095909],

Cell[TextData[{
 "To get a layered/hierarchical drawing of a directed graph, use ",
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 " attempts to draw the vertices of a graph in a series of layers, with \
dominant vertices at the top, and vertices lower in the hierarchy \
progressively farther down. This function is most suitable for applications \
such as flow chart drawing. See ",
 StyleBox[ButtonBox["LayeredGraphPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LayeredGraphDrawing"], "InlineFormula"],
 ButtonBox[": Hierarchical drawing of directed graphs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LayeredGraphDrawing"],
 StyleBox[" ",
  FontColor->RGBColor[1, 0, 0]],
 "for this function."
}], "Text",
 CellID->343456355],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TreePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreePlot"]], "InlineFormula"],
 " is specifically designed to draw trees and tree-like graphs. See ",
 ButtonBox["Tree Drawing: ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TreeDrawing"],
 StyleBox[ButtonBox["TreePlot",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TreeDrawing"], "InlineFormula"],
 " for this function."
}], "Text",
 CellID->208828973]
}, Open  ]],

Cell[CellGroupData[{

Cell["References", "Section",
 CellTags->"b:0.12",
 CellID->415774208],

Cell[TextData[{
 "[1] G. Di Battista, P. Eades, R. Tamassia, and I. G. Tollis, ",
 StyleBox["Graph Drawing: Algorithms for the Visualization of Graphs",
  FontSlant->"Italic"],
 ", Upper Saddle River, N.J.: Prentice Hall, 1999."
}], "Text",
 CellTags->{"[1]", "b:0.12"},
 CellID->25676449],

Cell[TextData[{
 "[2] T. M. J. Fruchterman and E. M. Reingold, \"Graph drawing by \
Force-Directed Placement,\" ",
 StyleBox["Software\[LongDash]Practice and Experience",
  FontSlant->"Italic"],
 ", 21(11), 1991 pp. 1129\[Dash]1164."
}], "Text",
 CellTags->{"[2]", "b:0.12"},
 CellID->116152207],

Cell[TextData[{
 "[3] P. Eades, \"A Heuristic for Graph Drawing,\" ",
 StyleBox["Congressus Numerantium",
  FontSlant->"Italic"],
 ", 42, 1984 pp. 149\[Dash]160."
}], "Text",
 CellTags->{"[3]", "b:0.12"},
 CellID->134151936],

Cell[TextData[{
 "[4] N. Quinn and M. Breuer, \"A Force Directed Component Placement \
Procedure for Printed Circuit Boards,\" ",
 StyleBox["IEEE Trans. on Circuits and Systems, CAS-26",
  FontSlant->"Italic"],
 ", (6), 1979 pp. 377\[Dash]388."
}], "Text",
 CellTags->{"[4]", "b:0.12"},
 CellID->614934272],

Cell[TextData[{
 "[5] T. Kamada and S. Kawai, \"An Algorithm for Drawing General Undirected \
Graphs,\" ",
 StyleBox["Information Processing Letters",
  FontSlant->"Italic"],
 ", 31, 1989 pp. 7\[Dash]15."
}], "Text",
 CellTags->{"[5]", "b:0.12"},
 CellID->884372698],

Cell[TextData[{
 "[6] D. Harel and Y. Koren, \"Graph Drawing by High-Dimensional Embedding",
 ",\"",
 " in ",
 StyleBox["Proceedings of 10th Int. Symp. Graph Drawing (GD'02)",
  FontSlant->"Italic"],
 ";",
 StyleBox[" ",
  FontSlant->"Italic"],
 "Lecture Notes in Computer Science, Vol. 2528, Springer Verlag, 2002 pp. 207\
\[Dash]219."
}], "Text",
 CellTags->{"[6]", "b:0.12"},
 CellID->6614549],

Cell[TextData[{
 "[7] C. Walshaw, \"A Multilevel Algorithm for Force-Directed \
Graph-Drawing,\" ",
 StyleBox["J. Graph Algorithms Appl.",
  FontSlant->"Italic"],
 ", 7(3), 2003 pp. 253\[Dash]285."
}], "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->590863096],

Cell[TextData[{
 "[8] E. Cuthill and J. McKee, \"Reducing the Bandwidth of Sparse Symmetric \
Matrices,\" in ",
 StyleBox["Proceedings, 24th National Conference of ACM",
  FontSlant->"Italic"],
 ", ACM Publications, 1969 pp. 157\[Dash]172.\n[9] A. Lim, B. Rodrigues and \
F. Xiao, \"A Centroid-Based Approach to Solve the Bandwidth Minimization \
Problem,\" ",
 StyleBox["Proceedings of the 37th Annual Hawaii International Conference on",
  
  FontSlant->"Italic"],
 " ",
 StyleBox["System Sciences (HICSS'04)",
  FontSlant->"Italic"],
 ", 3(Track 3), IEEE Computer Society, 2004, p.30075.1."
}], "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->1458996],

Cell[TextData[{
 "[10] S. T. Barnard, A. Pothen, H. D. Simon, \"A Spectral Algorithm for \
Envelope Reduction of Sparse Matrices,\" ",
 StyleBox["Journal of Numerical Linear Algebra with Applications",
  FontSlant->"Italic"],
 ", 2(4), 1995 pp. 317\[Dash]334."
}], "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->174376694],

Cell[TextData[{
 "[11] S. Sloan, \"A Fortran Program for Profile and Wavefront Reduction,\" \
",
 StyleBox["International Journal for Numerical Methods in Engineering",
  FontSlant->"Italic"],
 ", 28(11), 1989 pp. 2651\[Dash]2679."
}], "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->25351331],

Cell[TextData[{
 "[12] J. K. Reid and J. A. Scott, \"Ordering Symmetric Sparse Matrices for \
Small Profile and Wavefront,\" ",
 StyleBox["International Journal for Numerical Methods in Engineering",
  FontSlant->"Italic"],
 ", 45(12), 1999 pp. 1737\[Dash]1755."
}], "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->171495988],

Cell["\<\
[13] J. A. George, \"Computer Implementation of the Finite-Element Method,\" \
Report STAN CS-71-208, Ph. D. Thesis, Department of Computer Science, \
Stanford University, Stanford, California, 1971.\
\>", "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->181065655],

Cell[TextData[{
 "[14] K. Sugiyama, S. Tagawa and M. Toda, \"Methods for Visual Understanding \
of Hierarchical Systems,\" ",
 StyleBox["IEEE Trans. Syst. Man, Cybern",
  FontSlant->"Italic"],
 "., SMC-11(2), 1981 pp. 109\[Dash]125."
}], "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->467855775],

Cell[TextData[{
 "[15] E. R. Gansner, E. Koutsofios, S. C. North and K.-P. Vo, \"A Technique \
for Drawing Directed Graphs,\" ",
 StyleBox["IEEE Trans. Software Engineering",
  FontSlant->"Italic"],
 ", 19(3), 1993, 214\[Dash]230."
}], "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->106127544],

Cell[TextData[{
 "[16] Y. F. Hu, \"Efficient, high-quality force-directed graph drawing,\" \
The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Journal, 10(1), 2006, pp. 37\[Dash]71."
}], "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->1624856609]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Introduction to Graph Drawing - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 36, 35.0663718}", "context" -> "", 
    "keywords" -> {
     "digraph layout", "flow chart layout", "graph drawing", 
      "graph embedding", "graph layout", "graph visualization", 
      "hierarchical graph layout", "network layout", "network visualization", 
      "tree layout"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica provides functions for the aesthetic drawing of graphs. \
Algorithms implemented include the spring embedding, spring-electrical \
embedding, high-dimensional embedding, radial drawing, random embedding, \
circular embedding, and spiral embedding. In addition, algorithms for \
layered/hierarchical drawing of directed graphs as well as for the drawing of \
trees are available. These algorithms are implemented via four functions: \
GraphPlot, GraphPlot3D, LayeredGraphPlot and TreePlot. Functions for graph \
drawing. GraphPlot and GraphPlot3D are suitable for straight line drawing of \
general graphs. LayeredGraphPlot attempts to draw the vertices of a graph in \
a series of layers; therefore it is most suitable for applications such as \
the drawing of flow charts. TreePlot is particularly useful for drawing trees \
or tree-like graphs. These functions are designed to work efficiently for \
very large graphs. ", "synonyms" -> {}, "title" -> 
    "Introduction to Graph Drawing", "type" -> "Tutorial", "uri" -> 
    "tutorial/GraphDrawingIntroduction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "introduction"->{
  Cell[1516, 46, 111, 2, 70, "Title",
   CellTags->{"introduction", "i:2", "b:0.0"},
   CellID->251542051]},
 "i:2"->{
  Cell[1516, 46, 111, 2, 70, "Title",
   CellTags->{"introduction", "i:2", "b:0.0"},
   CellID->251542051]},
 "b:0.0"->{
  Cell[1516, 46, 111, 2, 70, "Title",
   CellTags->{"introduction", "i:2", "b:0.0"},
   CellID->251542051],
  Cell[1630, 50, 1082, 31, 70, "Text",
   CellTags->"b:0.0",
   CellID->29196500],
  Cell[3446, 108, 126, 2, 70, "Caption",
   CellTags->{"S5.18.1", "b:0.0"},
   CellID->661590988],
  Cell[4494, 138, 123, 3, 70, "MathCaption",
   CellTags->"b:0.0",
   CellID->829970625],
  Cell[20196, 517, 1019, 38, 70, "Text",
   CellTags->"b:0.0",
   CellID->295686867],
  Cell[21240, 559, 89, 2, 70, "Section",
   CellTags->{"i:1", "b:0.0"},
   CellID->26381778],
  Cell[21332, 563, 739, 29, 70, "Text",
   CellTags->"b:0.0",
   CellID->187590257],
  Cell[22074, 594, 1031, 34, 70, "Text",
   CellTags->"b:0.0",
   CellID->49492652],
  Cell[23108, 630, 100, 2, 70, "MathCaption",
   CellTags->"b:0.0",
   CellID->76573419],
  Cell[25526, 703, 91, 2, 70, "MathCaption",
   CellTags->"b:0.0",
   CellID->740228454],
  Cell[27782, 776, 72, 2, 70, "Section",
   CellTags->"b:0.0",
   CellID->231602437],
  Cell[27857, 780, 203, 7, 70, "Text",
   CellTags->"b:0.0",
   CellID->184544861],
  Cell[28063, 789, 102, 2, 70, "Text",
   CellTags->"b:0.0",
   CellID->607452952],
  Cell[28168, 793, 407, 15, 70, "MathCaption",
   CellTags->"b:0.0",
   CellID->460032087],
  Cell[30531, 866, 1417, 51, 70, "Text",
   CellTags->"b:0.0",
   CellID->206274755],
  Cell[31951, 919, 137, 4, 70, "MathCaption",
   CellTags->"b:0.0",
   CellID->577233883],
  Cell[32091, 925, 243, 9, 70, "DisplayMath",
   CellTags->"b:0.0",
   CellID->72624360],
  Cell[32337, 936, 815, 30, 70, "Text",
   CellTags->"b:0.0",
   CellID->486914829],
  Cell[33155, 968, 141, 4, 70, "MathCaption",
   CellTags->"b:0.0",
   CellID->389792830],
  Cell[33299, 974, 243, 9, 70, "DisplayMath",
   CellTags->"b:0.0",
   CellID->18154319],
  Cell[35334, 1041, 311, 10, 70, "Text",
   CellTags->"b:0.0",
   CellID->456407675],
  Cell[35648, 1053, 136, 4, 70, "MathCaption",
   CellTags->"b:0.0",
   CellID->393688691],
  Cell[35787, 1059, 1050, 34, 70, "Input",
   CellTags->"b:0.0",
   CellID->19032932],
  Cell[36840, 1095, 184, 7, 70, "Text",
   CellTags->"b:0.0",
   CellID->52142691]},
 "b:0.1"->{
  Cell[2715, 83, 728, 23, 70, "DefinitionBox",
   CellTags->"b:0.1",
   CellID->25485965],
  Cell[37027, 1104, 271, 11, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->75897099],
  Cell[37301, 1117, 139, 5, 70, "Input",
   CellTags->"b:0.1",
   CellID->518567599],
  Cell[37465, 1126, 219, 7, 28, "Input",
   CellTags->"b:0.1",
   CellID->1531202620],
  Cell[37687, 1135, 7792, 132, 198, "Output",
   Evaluatable->False,
   CellTags->"b:0.1",
   CellID->413283960],
  Cell[45494, 1270, 237, 9, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->621000783],
  Cell[45756, 1283, 124, 4, 70, "Input",
   CellTags->"b:0.1",
   CellID->67598844],
  Cell[45883, 1289, 7144, 193, 70, "Output",
   CellTags->"b:0.1",
   CellID->1488694231],
  Cell[59495, 1708, 83, 2, 70, "Section",
   CellTags->"b:0.1",
   CellID->194525651],
  Cell[59581, 1712, 1356, 24, 70, "Text",
   CellTags->"b:0.1",
   CellID->465767437],
  Cell[60962, 1740, 96, 2, 70, "Subsection",
   CellTags->{"spring model", "b:0.1"},
   CellID->301083942],
  Cell[61061, 1744, 413, 8, 70, "Text",
   CellTags->"b:0.1",
   CellID->176133299],
  Cell[61477, 1754, 248, 6, 70, "Text",
   CellTags->"b:0.1",
   CellID->270261448],
  Cell[61728, 1762, 838, 28, 70, "DisplayMath",
   CellTags->"b:0.1",
   CellID->40464462],
  Cell[62569, 1792, 1786, 61, 70, "Text",
   CellTags->"b:0.1",
   CellID->352667799],
  Cell[64358, 1855, 381, 8, 70, "Text",
   CellTags->"b:0.1",
   CellID->65696215],
  Cell[64742, 1865, 284, 6, 70, "Text",
   CellTags->"b:0.1",
   CellID->1055789860],
  Cell[65029, 1873, 145, 4, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->397360721],
  Cell[65177, 1879, 140, 5, 70, "Input",
   CellTags->"b:0.1",
   CellID->232833340],
  Cell[65342, 1888, 272, 9, 28, "Input",
   CellTags->"b:0.1",
   CellID->557662836],
  Cell[65617, 1899, 10550, 178, 206, "Output",
   Evaluatable->False,
   CellTags->"b:0.1",
   CellID->68165165],
  Cell[76182, 2080, 771, 24, 70, "Text",
   CellTags->"b:0.1",
   CellID->392929208],
  Cell[76990, 2109, 118, 2, 70, "Subsection",
   CellTags->{"spring-electrical model", "b:0.1"},
   CellID->425607435],
  Cell[77111, 2113, 1569, 48, 70, "Text",
   CellTags->"b:0.1",
   CellID->12708941],
  Cell[78683, 2163, 2092, 74, 70, "DisplayMath",
   CellTags->"b:0.1",
   CellID->268030069],
  Cell[80778, 2239, 960, 31, 70, "Text",
   CellTags->"b:0.1",
   CellID->605554554],
  Cell[81741, 2272, 452, 9, 70, "Text",
   CellTags->"b:0.1",
   CellID->27523184],
  Cell[82196, 2283, 440, 14, 70, "Text",
   CellTags->"b:0.1",
   CellID->1655679217],
  Cell[82639, 2299, 213, 6, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->470653372],
  Cell[82855, 2307, 140, 5, 70, "Input",
   CellTags->"b:0.1",
   CellID->299574666],
  Cell[83020, 2316, 283, 9, 28, "Input",
   CellTags->"b:0.1",
   CellID->760805916],
  Cell[83306, 2327, 15374, 257, 208, "Output",
   Evaluatable->False,
   CellTags->"b:0.1",
   CellID->313166313],
  Cell[98695, 2587, 483, 12, 70, "Text",
   CellTags->"b:0.1",
   CellID->519376322],
  Cell[99215, 2604, 130, 2, 70, "Subsection",
   CellTags->{"high-dimensional embedding", "b:0.1"},
   CellID->105832149],
  Cell[99348, 2608, 1400, 39, 70, "Text",
   CellTags->"b:0.1",
   CellID->584621403],
  Cell[100751, 2649, 2126, 79, 70, "Text",
   CellTags->"b:0.1",
   CellID->280170679],
  Cell[102880, 2730, 826, 23, 70, "Text",
   CellTags->"b:0.1",
   CellID->366643026],
  Cell[103709, 2755, 415, 14, 70, "DisplayMath",
   CellTags->"b:0.1",
   CellID->164473343],
  Cell[104127, 2771, 513, 17, 70, "Text",
   CellTags->"b:0.1",
   CellID->28964186],
  Cell[104643, 2790, 638, 23, 70, "DisplayMath",
   CellTags->"b:0.1",
   CellID->247416686],
  Cell[105284, 2815, 100, 2, 70, "Text",
   CellTags->"b:0.1",
   CellID->46564267],
  Cell[105387, 2819, 598, 20, 70, "DisplayMath",
   CellTags->"b:0.1",
   CellID->911136577],
  Cell[105988, 2841, 813, 27, 70, "Text",
   CellTags->"b:0.1",
   CellID->629305703],
  Cell[106804, 2870, 495, 17, 70, "Text",
   CellTags->"b:0.1",
   CellID->102602607],
  Cell[107302, 2889, 213, 6, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->1422530350],
  Cell[107518, 2897, 140, 5, 70, "Input",
   CellTags->"b:0.1",
   CellID->565700163],
  Cell[107683, 2906, 281, 9, 28, "Input",
   CellTags->"b:0.1",
   CellID->99263445],
  Cell[107967, 2917, 13015, 218, 194, "Output",
   Evaluatable->False,
   CellTags->"b:0.1",
   CellID->382903097],
  Cell[120997, 3138, 691, 23, 70, "Text",
   CellTags->"b:0.1",
   CellID->213368396],
  Cell[121725, 3166, 149, 2, 70, "Subsection",
   CellTags->{"trees", "b:0.1", "LayereDigraphDrawing"},
   CellID->447313943],
  Cell[125450, 3297, 101, 2, 70, "Subsection",
   CellTags->{"trees", "b:0.1"},
   CellID->437048596],
  Cell[125554, 3301, 1419, 32, 70, "Text",
   CellTags->"b:0.1",
   CellID->11527193],
  Cell[127022, 3339, 107, 2, 70, "Section",
   CellTags->"b:0.1",
   CellID->192062428],
  Cell[127132, 3343, 1217, 38, 70, "Text",
   CellTags->"b:0.1",
   CellID->977095909]},
 "S5.18.1"->{
  Cell[3446, 108, 126, 2, 70, "Caption",
   CellTags->{"S5.18.1", "b:0.0"},
   CellID->661590988]},
 "i:1"->{
  Cell[21240, 559, 89, 2, 70, "Section",
   CellTags->{"i:1", "b:0.0"},
   CellID->26381778]},
 "spring model"->{
  Cell[60962, 1740, 96, 2, 70, "Subsection",
   CellTags->{"spring model", "b:0.1"},
   CellID->301083942]},
 "spring-electrical model"->{
  Cell[76990, 2109, 118, 2, 70, "Subsection",
   CellTags->{"spring-electrical model", "b:0.1"},
   CellID->425607435]},
 "high-dimensional embedding"->{
  Cell[99215, 2604, 130, 2, 70, "Subsection",
   CellTags->{"high-dimensional embedding", "b:0.1"},
   CellID->105832149]},
 "trees"->{
  Cell[121725, 3166, 149, 2, 70, "Subsection",
   CellTags->{"trees", "b:0.1", "LayereDigraphDrawing"},
   CellID->447313943],
  Cell[125450, 3297, 101, 2, 70, "Subsection",
   CellTags->{"trees", "b:0.1"},
   CellID->437048596]},
 "LayereDigraphDrawing"->{
  Cell[121725, 3166, 149, 2, 70, "Subsection",
   CellTags->{"trees", "b:0.1", "LayereDigraphDrawing"},
   CellID->447313943]},
 "b:0.12"->{
  Cell[129846, 3429, 70, 2, 70, "Section",
   CellTags->"b:0.12",
   CellID->415774208],
  Cell[129919, 3433, 289, 7, 70, "Text",
   CellTags->{"[1]", "b:0.12"},
   CellID->25676449],
  Cell[130211, 3442, 295, 8, 70, "Text",
   CellTags->{"[2]", "b:0.12"},
   CellID->116152207],
  Cell[130509, 3452, 224, 7, 70, "Text",
   CellTags->{"[3]", "b:0.12"},
   CellID->134151936],
  Cell[130736, 3461, 306, 8, 70, "Text",
   CellTags->{"[4]", "b:0.12"},
   CellID->614934272],
  Cell[131045, 3471, 266, 8, 70, "Text",
   CellTags->{"[5]", "b:0.12"},
   CellID->884372698],
  Cell[131314, 3481, 396, 13, 70, "Text",
   CellTags->{"[6]", "b:0.12"},
   CellID->6614549],
  Cell[131713, 3496, 259, 8, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->590863096],
  Cell[131975, 3506, 653, 17, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->1458996],
  Cell[132631, 3525, 322, 8, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->174376694],
  Cell[132956, 3535, 292, 8, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->25351331],
  Cell[133251, 3545, 324, 8, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->171495988],
  Cell[133578, 3555, 273, 6, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->181065655],
  Cell[133854, 3563, 295, 8, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->467855775],
  Cell[134152, 3573, 293, 8, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->106127544],
  Cell[134448, 3583, 254, 8, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->1624856609]},
 "[1]"->{
  Cell[129919, 3433, 289, 7, 70, "Text",
   CellTags->{"[1]", "b:0.12"},
   CellID->25676449]},
 "[2]"->{
  Cell[130211, 3442, 295, 8, 70, "Text",
   CellTags->{"[2]", "b:0.12"},
   CellID->116152207]},
 "[3]"->{
  Cell[130509, 3452, 224, 7, 70, "Text",
   CellTags->{"[3]", "b:0.12"},
   CellID->134151936]},
 "[4]"->{
  Cell[130736, 3461, 306, 8, 70, "Text",
   CellTags->{"[4]", "b:0.12"},
   CellID->614934272]},
 "[5]"->{
  Cell[131045, 3471, 266, 8, 70, "Text",
   CellTags->{"[5]", "b:0.12"},
   CellID->884372698]},
 "[6]"->{
  Cell[131314, 3481, 396, 13, 70, "Text",
   CellTags->{"[6]", "b:0.12"},
   CellID->6614549]},
 "[7]"->{
  Cell[131713, 3496, 259, 8, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->590863096],
  Cell[131975, 3506, 653, 17, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->1458996],
  Cell[132631, 3525, 322, 8, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->174376694],
  Cell[132956, 3535, 292, 8, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->25351331],
  Cell[133251, 3545, 324, 8, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->171495988],
  Cell[133578, 3555, 273, 6, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->181065655],
  Cell[133854, 3563, 295, 8, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->467855775],
  Cell[134152, 3573, 293, 8, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->106127544],
  Cell[134448, 3583, 254, 8, 70, "Text",
   CellTags->{"[7]", "b:0.12"},
   CellID->1624856609]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"introduction", 137135, 3645},
 {"i:2", 137254, 3649},
 {"b:0.0", 137375, 3653},
 {"b:0.1", 139526, 3726},
 {"S5.18.1", 144542, 3893},
 {"i:1", 144652, 3897},
 {"spring model", 144766, 3901},
 {"spring-electrical model", 144905, 3905},
 {"high-dimensional embedding", 145059, 3909},
 {"trees", 145195, 3913},
 {"LayereDigraphDrawing", 145453, 3920},
 {"b:0.12", 145594, 3924},
 {"[1]", 147131, 3973},
 {"[2]", 147237, 3977},
 {"[3]", 147344, 3981},
 {"[4]", 147451, 3985},
 {"[5]", 147558, 3989},
 {"[6]", 147665, 3993},
 {"[7]", 147771, 3997}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 891, 19, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1516, 46, 111, 2, 70, "Title",
 CellTags->{"introduction", "i:2", "b:0.0"},
 CellID->251542051],
Cell[1630, 50, 1082, 31, 70, "Text",
 CellTags->"b:0.0",
 CellID->29196500],
Cell[2715, 83, 728, 23, 70, "DefinitionBox",
 CellTags->"b:0.1",
 CellID->25485965],
Cell[3446, 108, 126, 2, 70, "Caption",
 CellTags->{"S5.18.1", "b:0.0"},
 CellID->661590988],
Cell[3575, 112, 916, 24, 70, "Text",
 CellID->17385],
Cell[4494, 138, 123, 3, 70, "MathCaption",
 CellTags->"b:0.0",
 CellID->829970625],
Cell[CellGroupData[{
Cell[4642, 145, 1292, 35, 70, "Input",
 CellID->465726308],
Cell[5937, 182, 14247, 332, 294, "Output",
 CellID->1381899581]
}, {2}]],
Cell[20196, 517, 1019, 38, 70, "Text",
 CellTags->"b:0.0",
 CellID->295686867],
Cell[CellGroupData[{
Cell[21240, 559, 89, 2, 70, "Section",
 CellTags->{"i:1", "b:0.0"},
 CellID->26381778],
Cell[21332, 563, 739, 29, 70, "Text",
 CellTags->"b:0.0",
 CellID->187590257],
Cell[22074, 594, 1031, 34, 70, "Text",
 CellTags->"b:0.0",
 CellID->49492652],
Cell[23108, 630, 100, 2, 70, "MathCaption",
 CellTags->"b:0.0",
 CellID->76573419],
Cell[CellGroupData[{
Cell[23233, 636, 561, 14, 70, "Input",
 CellID->471361096],
Cell[23797, 652, 1714, 48, 70, "Output",
 CellID->1238678085]
}, Open  ]],
Cell[25526, 703, 91, 2, 70, "MathCaption",
 CellTags->"b:0.0",
 CellID->740228454],
Cell[CellGroupData[{
Cell[25642, 709, 485, 12, 70, "Input",
 CellID->1744761596],
Cell[26130, 723, 1603, 47, 70, "Output",
 CellID->936571727]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27782, 776, 72, 2, 70, "Section",
 CellTags->"b:0.0",
 CellID->231602437],
Cell[27857, 780, 203, 7, 70, "Text",
 CellTags->"b:0.0",
 CellID->184544861],
Cell[28063, 789, 102, 2, 70, "Text",
 CellTags->"b:0.0",
 CellID->607452952],
Cell[28168, 793, 407, 15, 70, "MathCaption",
 CellTags->"b:0.0",
 CellID->460032087],
Cell[CellGroupData[{
Cell[28600, 812, 450, 12, 70, "Input",
 CellID->1569627277],
Cell[29053, 826, 1463, 37, 129, "Output",
 CellID->366054056]
}, Open  ]],
Cell[30531, 866, 1417, 51, 70, "Text",
 CellTags->"b:0.0",
 CellID->206274755],
Cell[31951, 919, 137, 4, 70, "MathCaption",
 CellTags->"b:0.0",
 CellID->577233883],
Cell[32091, 925, 243, 9, 70, "DisplayMath",
 CellTags->"b:0.0",
 CellID->72624360],
Cell[32337, 936, 815, 30, 70, "Text",
 CellTags->"b:0.0",
 CellID->486914829],
Cell[33155, 968, 141, 4, 70, "MathCaption",
 CellTags->"b:0.0",
 CellID->389792830],
Cell[33299, 974, 243, 9, 70, "DisplayMath",
 CellTags->"b:0.0",
 CellID->18154319],
Cell[CellGroupData[{
Cell[33567, 987, 364, 13, 70, "Input",
 CellID->1463241116],
Cell[33934, 1002, 1385, 36, 123, "Output",
 CellID->682957595]
}, Open  ]],
Cell[35334, 1041, 311, 10, 70, "Text",
 CellTags->"b:0.0",
 CellID->456407675],
Cell[35648, 1053, 136, 4, 70, "MathCaption",
 CellTags->"b:0.0",
 CellID->393688691],
Cell[35787, 1059, 1050, 34, 70, "Input",
 CellTags->"b:0.0",
 CellID->19032932],
Cell[36840, 1095, 184, 7, 70, "Text",
 CellTags->"b:0.0",
 CellID->52142691],
Cell[37027, 1104, 271, 11, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->75897099],
Cell[37301, 1117, 139, 5, 70, "Input",
 CellTags->"b:0.1",
 CellID->518567599],
Cell[CellGroupData[{
Cell[37465, 1126, 219, 7, 28, "Input",
 CellTags->"b:0.1",
 CellID->1531202620],
Cell[37687, 1135, 7792, 132, 198, "Output",
 Evaluatable->False,
 CellTags->"b:0.1",
 CellID->413283960]
}, Open  ]],
Cell[45494, 1270, 237, 9, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->621000783],
Cell[CellGroupData[{
Cell[45756, 1283, 124, 4, 70, "Input",
 CellTags->"b:0.1",
 CellID->67598844],
Cell[45883, 1289, 7144, 193, 70, "Output",
 CellTags->"b:0.1",
 CellID->1488694231]
}, Open  ]],
Cell[53042, 1485, 815, 28, 70, "Text",
 CellID->949616064],
Cell[53860, 1515, 380, 15, 70, "MathCaption",
 CellID->906788346],
Cell[CellGroupData[{
Cell[54265, 1534, 167, 5, 70, "Input",
 CellID->423083302],
Cell[54435, 1541, 5011, 161, 70, "Output",
 CellID->1770740929]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[59495, 1708, 83, 2, 70, "Section",
 CellTags->"b:0.1",
 CellID->194525651],
Cell[59581, 1712, 1356, 24, 70, "Text",
 CellTags->"b:0.1",
 CellID->465767437],
Cell[CellGroupData[{
Cell[60962, 1740, 96, 2, 70, "Subsection",
 CellTags->{"spring model", "b:0.1"},
 CellID->301083942],
Cell[61061, 1744, 413, 8, 70, "Text",
 CellTags->"b:0.1",
 CellID->176133299],
Cell[61477, 1754, 248, 6, 70, "Text",
 CellTags->"b:0.1",
 CellID->270261448],
Cell[61728, 1762, 838, 28, 70, "DisplayMath",
 CellTags->"b:0.1",
 CellID->40464462],
Cell[62569, 1792, 1786, 61, 70, "Text",
 CellTags->"b:0.1",
 CellID->352667799],
Cell[64358, 1855, 381, 8, 70, "Text",
 CellTags->"b:0.1",
 CellID->65696215],
Cell[64742, 1865, 284, 6, 70, "Text",
 CellTags->"b:0.1",
 CellID->1055789860],
Cell[65029, 1873, 145, 4, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->397360721],
Cell[65177, 1879, 140, 5, 70, "Input",
 CellTags->"b:0.1",
 CellID->232833340],
Cell[CellGroupData[{
Cell[65342, 1888, 272, 9, 28, "Input",
 CellTags->"b:0.1",
 CellID->557662836],
Cell[65617, 1899, 10550, 178, 206, "Output",
 Evaluatable->False,
 CellTags->"b:0.1",
 CellID->68165165]
}, Open  ]],
Cell[76182, 2080, 771, 24, 70, "Text",
 CellTags->"b:0.1",
 CellID->392929208]
}, Open  ]],
Cell[CellGroupData[{
Cell[76990, 2109, 118, 2, 70, "Subsection",
 CellTags->{"spring-electrical model", "b:0.1"},
 CellID->425607435],
Cell[77111, 2113, 1569, 48, 70, "Text",
 CellTags->"b:0.1",
 CellID->12708941],
Cell[78683, 2163, 2092, 74, 70, "DisplayMath",
 CellTags->"b:0.1",
 CellID->268030069],
Cell[80778, 2239, 960, 31, 70, "Text",
 CellTags->"b:0.1",
 CellID->605554554],
Cell[81741, 2272, 452, 9, 70, "Text",
 CellTags->"b:0.1",
 CellID->27523184],
Cell[82196, 2283, 440, 14, 70, "Text",
 CellTags->"b:0.1",
 CellID->1655679217],
Cell[82639, 2299, 213, 6, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->470653372],
Cell[82855, 2307, 140, 5, 70, "Input",
 CellTags->"b:0.1",
 CellID->299574666],
Cell[CellGroupData[{
Cell[83020, 2316, 283, 9, 28, "Input",
 CellTags->"b:0.1",
 CellID->760805916],
Cell[83306, 2327, 15374, 257, 208, "Output",
 Evaluatable->False,
 CellTags->"b:0.1",
 CellID->313166313]
}, Open  ]],
Cell[98695, 2587, 483, 12, 70, "Text",
 CellTags->"b:0.1",
 CellID->519376322]
}, Open  ]],
Cell[CellGroupData[{
Cell[99215, 2604, 130, 2, 70, "Subsection",
 CellTags->{"high-dimensional embedding", "b:0.1"},
 CellID->105832149],
Cell[99348, 2608, 1400, 39, 70, "Text",
 CellTags->"b:0.1",
 CellID->584621403],
Cell[100751, 2649, 2126, 79, 70, "Text",
 CellTags->"b:0.1",
 CellID->280170679],
Cell[102880, 2730, 826, 23, 70, "Text",
 CellTags->"b:0.1",
 CellID->366643026],
Cell[103709, 2755, 415, 14, 70, "DisplayMath",
 CellTags->"b:0.1",
 CellID->164473343],
Cell[104127, 2771, 513, 17, 70, "Text",
 CellTags->"b:0.1",
 CellID->28964186],
Cell[104643, 2790, 638, 23, 70, "DisplayMath",
 CellTags->"b:0.1",
 CellID->247416686],
Cell[105284, 2815, 100, 2, 70, "Text",
 CellTags->"b:0.1",
 CellID->46564267],
Cell[105387, 2819, 598, 20, 70, "DisplayMath",
 CellTags->"b:0.1",
 CellID->911136577],
Cell[105988, 2841, 813, 27, 70, "Text",
 CellTags->"b:0.1",
 CellID->629305703],
Cell[106804, 2870, 495, 17, 70, "Text",
 CellTags->"b:0.1",
 CellID->102602607],
Cell[107302, 2889, 213, 6, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->1422530350],
Cell[107518, 2897, 140, 5, 70, "Input",
 CellTags->"b:0.1",
 CellID->565700163],
Cell[CellGroupData[{
Cell[107683, 2906, 281, 9, 28, "Input",
 CellTags->"b:0.1",
 CellID->99263445],
Cell[107967, 2917, 13015, 218, 194, "Output",
 Evaluatable->False,
 CellTags->"b:0.1",
 CellID->382903097]
}, Open  ]],
Cell[120997, 3138, 691, 23, 70, "Text",
 CellTags->"b:0.1",
 CellID->213368396]
}, Open  ]],
Cell[CellGroupData[{
Cell[121725, 3166, 149, 2, 70, "Subsection",
 CellTags->{"trees", "b:0.1", "LayereDigraphDrawing"},
 CellID->447313943],
Cell[121877, 3170, 525, 16, 70, "Text",
 CellID->87279083],
Cell[122405, 3188, 730, 24, 70, "ItemizedText",
 CellID->69175192],
Cell[123138, 3214, 955, 29, 70, "ItemizedText",
 CellID->44131576],
Cell[124096, 3245, 220, 7, 70, "ItemizedText",
 CellID->92244645],
Cell[CellGroupData[{
Cell[124341, 3256, 641, 20, 70, "ItemizedText",
 CellID->83769734],
Cell[124985, 3278, 416, 13, 70, "Text",
 CellID->826523325]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[125450, 3297, 101, 2, 70, "Subsection",
 CellTags->{"trees", "b:0.1"},
 CellID->437048596],
Cell[125554, 3301, 1419, 32, 70, "Text",
 CellTags->"b:0.1",
 CellID->11527193]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[127022, 3339, 107, 2, 70, "Section",
 CellTags->"b:0.1",
 CellID->192062428],
Cell[127132, 3343, 1217, 38, 70, "Text",
 CellTags->"b:0.1",
 CellID->977095909],
Cell[128352, 3383, 981, 25, 70, "Text",
 CellID->343456355],
Cell[129336, 3410, 473, 14, 70, "Text",
 CellID->208828973]
}, Open  ]],
Cell[CellGroupData[{
Cell[129846, 3429, 70, 2, 70, "Section",
 CellTags->"b:0.12",
 CellID->415774208],
Cell[129919, 3433, 289, 7, 70, "Text",
 CellTags->{"[1]", "b:0.12"},
 CellID->25676449],
Cell[130211, 3442, 295, 8, 70, "Text",
 CellTags->{"[2]", "b:0.12"},
 CellID->116152207],
Cell[130509, 3452, 224, 7, 70, "Text",
 CellTags->{"[3]", "b:0.12"},
 CellID->134151936],
Cell[130736, 3461, 306, 8, 70, "Text",
 CellTags->{"[4]", "b:0.12"},
 CellID->614934272],
Cell[131045, 3471, 266, 8, 70, "Text",
 CellTags->{"[5]", "b:0.12"},
 CellID->884372698],
Cell[131314, 3481, 396, 13, 70, "Text",
 CellTags->{"[6]", "b:0.12"},
 CellID->6614549],
Cell[131713, 3496, 259, 8, 70, "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->590863096],
Cell[131975, 3506, 653, 17, 70, "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->1458996],
Cell[132631, 3525, 322, 8, 70, "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->174376694],
Cell[132956, 3535, 292, 8, 70, "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->25351331],
Cell[133251, 3545, 324, 8, 70, "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->171495988],
Cell[133578, 3555, 273, 6, 70, "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->181065655],
Cell[133854, 3563, 295, 8, 70, "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->467855775],
Cell[134152, 3573, 293, 8, 70, "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->106127544],
Cell[134448, 3583, 254, 8, 70, "Text",
 CellTags->{"[7]", "b:0.12"},
 CellID->1624856609]
}, Open  ]]
}, Open  ]],
Cell[134729, 3595, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

