(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     65948,       1896]
NotebookOptionsPosition[     56812,       1614]
NotebookOutlinePosition[     60687,       1701]
CellTagsIndexPosition[     60593,       1695]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Structure of Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"The Structure of Graphics and Sound\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AbsoluteDashing" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteDashing"], 
          "AbsolutePointSize" :> 
          Documentation`HelpLookup["paclet:ref/AbsolutePointSize"], 
          "AbsoluteThickness" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteThickness"], 
          "Background" :> Documentation`HelpLookup["paclet:ref/Background"], 
          "BaseStyle" :> Documentation`HelpLookup["paclet:ref/BaseStyle"], 
          "BoxStyle" :> Documentation`HelpLookup["paclet:ref/BoxStyle"], 
          "Dashing" :> Documentation`HelpLookup["paclet:ref/Dashing"], 
          "Epilog" :> Documentation`HelpLookup["paclet:ref/Epilog"], 
          "GrayLevel" :> Documentation`HelpLookup["paclet:ref/GrayLevel"], 
          "Hue" :> Documentation`HelpLookup["paclet:ref/Hue"], "MeshStyle" :> 
          Documentation`HelpLookup["paclet:ref/MeshStyle"], "Plot" :> 
          Documentation`HelpLookup["paclet:ref/Plot"], "PlotStyle" :> 
          Documentation`HelpLookup["paclet:ref/PlotStyle"], "PointSize" :> 
          Documentation`HelpLookup["paclet:ref/PointSize"], "Prolog" :> 
          Documentation`HelpLookup["paclet:ref/Prolog"], "RGBColor" :> 
          Documentation`HelpLookup["paclet:ref/RGBColor"], "Thickness" :> 
          Documentation`HelpLookup["paclet:ref/Thickness"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AbsoluteDashing\"\>", 
       2->"\<\"AbsolutePointSize\"\>", 3->"\<\"AbsoluteThickness\"\>", 
       4->"\<\"Background\"\>", 5->"\<\"BaseStyle\"\>", 6->"\<\"BoxStyle\"\>",
        7->"\<\"Dashing\"\>", 8->"\<\"Epilog\"\>", 9->"\<\"GrayLevel\"\>", 
       10->"\<\"Hue\"\>", 11->"\<\"MeshStyle\"\>", 12->"\<\"Plot\"\>", 
       13->"\<\"PlotStyle\"\>", 14->"\<\"PointSize\"\>", 15->"\<\"Prolog\"\>",
        16->"\<\"RGBColor\"\>", 17->"\<\"Thickness\"\>"}, "\<\"functions\"\>",
        
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Graphics Directives and Options", "Title",
 CellTags->{"S2.10.3", "3.1"},
 CellID->25633],

Cell[TextData[{
 "When you set up a graphics object in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you typically give a list of graphical elements. You can include in that \
list ",
 StyleBox["graphics directives",
  FontSlant->"Italic"],
 " which specify how subsequent elements in the list should be rendered. "
}], "Text",
 CellID->1954],

Cell["\<\
In general, the graphical elements in a particular graphics object can be \
given in a collection of nested lists. When you insert graphics directives in \
this kind of structure, the rule is that a particular graphics directive \
affects all subsequent elements of the list it is in, together with all \
elements of sublists that may occur. The graphics directive does not, \
however, have any effect outside the list it is in. \
\>", "Text",
 CellID->930],

Cell[TextData[{
 "The first sublist contains the graphics directive ",
 Cell[BoxData[
  ButtonBox["GrayLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GrayLevel"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->10252],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", 
     RowBox[{"Rectangle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Rectangle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19904],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"GrayLevel", "[", "0.5`", "]"}], ",", 
     RowBox[{"Rectangle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Rectangle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{486, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->275916535]
}, Open  ]],

Cell[TextData[{
 "Only the rectangle in the first sublist is affected by the ",
 Cell[BoxData[
  ButtonBox["GrayLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GrayLevel"]], "InlineFormula"],
 " directive. "
}], "MathCaption",
 CellID->12488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24870],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0.5], RectangleBox[{0, 0}]}, RectangleBox[{1, 1}]}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->371078911]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["GrayLevel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GrayLevel"], "[", 
     StyleBox["i", "TI"], "]"}], Cell[
    "gray level between 0 (black) and 1 (white)", "TableText"]},
   {
    RowBox[{
     ButtonBox["RGBColor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RGBColor"], "[", 
     StyleBox["r", "TI"], ",", 
     StyleBox["g", "TI"], ",", 
     StyleBox["b", "TI"], "]"}], Cell["\<\
color with specified red, green and blue components, each between 0 and 1\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["Hue",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hue"], "[", 
     StyleBox["h", "TI"], "]"}], Cell[TextData[{
     "color with hue ",
     Cell[BoxData[
      StyleBox["h", "TI"]], "InlineFormula"],
     " between 0 and 1"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Hue",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hue"], "[", 
     StyleBox["h", "TI"], ",", 
     StyleBox["s", "TI"], ",", 
     StyleBox["b", "TI"], "]"}], Cell["\<\
color with specified hue, saturation and brightness, each between 0 and 1\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->32176],

Cell[TextData[{
 "Basic ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " color specifications. "
}], "Caption",
 CellID->26701],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " accepts the names of many colors directly as color specifications. These \
color names, such as ",
 Cell[BoxData[
  ButtonBox["Red",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Red"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Gray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Gray"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["LightGreen",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LightGreen"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Purple",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Purple"]], "InlineFormula"],
 ", are implemented as variables which evaluate to an ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 " specification. The color names can be used interchangeably with color \
directives."
}], "Text",
 CellID->267365338],

Cell[TextData[{
 "The first plot is colored with a color name, while the second one has a \
fine-tuned ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 " specification."
}], "MathCaption",
 CellID->15415],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"BesselI", "[", 
      RowBox[{"1", ",", "x"}], "]"}], ",", 
     RowBox[{"BesselI", "[", 
      RowBox[{"2", ",", "x"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "Red", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"RGBColor", "[", 
        RowBox[{"0.3", ",", "0.7", ",", "0.1"}], "]"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->18086],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->79207416]
}, Open  ]],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Hue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hue"], "[", 
   StyleBox["h", "TI"], "]"}]], "InlineFormula"],
 " provides a convenient way to specify a range of colors using just one \
parameter. As ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 " varies from 0 to 1, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Hue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hue"], "[", 
   StyleBox["h", "TI"], "]"}]], "InlineFormula"],
 " runs through red, yellow, green, cyan, blue, magenta, and back to red \
again. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Hue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hue"], "[", 
   RowBox[{
    StyleBox["h", "TI"], ",", 
    StyleBox["s", "TI"], ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 " allows you to specify not only the \[OpenCurlyDoubleQuote]hue\
\[CloseCurlyDoubleQuote], but also the \[OpenCurlyDoubleQuote]saturation\
\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]brightness\
\[CloseCurlyDoubleQuote] of a color. Taking the saturation to be equal to one \
gives the deepest colors; decreasing the saturation toward zero leads to \
progressively more \[OpenCurlyDoubleQuote]washed out\[CloseCurlyDoubleQuote] \
colors. "
}], "Text",
 CellID->17480],

Cell[TextData[{
 "When you give a graphics directive such as ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 ", it affects ",
 StyleBox["all",
  FontSlant->"Italic"],
 " subsequent graphical elements that appear in a particular list. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " also supports various graphics directives which affect only specific types \
of graphical elements. "
}], "Text",
 CellID->30260],

Cell[TextData[{
 "The graphics directive ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PointSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PointSize"], "[", 
   StyleBox["d", "TI"], "]"}]], "InlineFormula"],
 " specifies that all ",
 Cell[BoxData[
  ButtonBox["Point",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Point"]], "InlineFormula"],
 " elements which appear in a graphics object should be drawn as circles with \
diameter ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 ". In ",
 Cell[BoxData[
  ButtonBox["PointSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PointSize"]], "InlineFormula"],
 ", the diameter ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 " is measured as a fraction of the width of your whole plot. "
}], "Text",
 CellID->20514],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " also provides the graphics directive ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AbsolutePointSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsolutePointSize"], "[", 
   StyleBox["d", "TI"], "]"}]], "InlineFormula"],
 ", which allows you to specify the \[OpenCurlyDoubleQuote]absolute\
\[CloseCurlyDoubleQuote] diameter of points, measured in fixed units. The \
units are ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", "72"], TraditionalForm]], "InlineMath"],
 " of an inch, approximately printer\[CloseCurlyQuote]s points. "
}], "Text",
 CellID->8938],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["PointSize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PointSize"], "[", 
     StyleBox["d", "TI"], "]"}], Cell[TextData[{
     "give all points a diameter ",
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"],
     " as a fraction of the width of the whole plot"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["AbsolutePointSize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AbsolutePointSize"], "[", 
     StyleBox["d", "TI"], "]"}], Cell[TextData[{
     "give all points a diameter ",
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"],
     " measured in absolute units"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->16657],

Cell["Graphics directives for points. ", "Caption",
 CellID->14990],

Cell["Here is a list of points. ", "MathCaption",
 CellID->19438],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Point", "[", 
    RowBox[{"{", 
     RowBox[{"n", ",", 
      RowBox[{"Prime", "[", "n", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->28981],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Point", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Point", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Point", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Point", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "7"}], "}"}], "]"}], ",", 
   RowBox[{"Point", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "11"}], "}"}], "]"}], ",", 
   RowBox[{"Point", "[", 
    RowBox[{"{", 
     RowBox[{"6", ",", "13"}], "}"}], "]"}]}], "}"}]], "Output",
 ImageSize->{319, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->185348845]
}, Open  ]],

Cell["\<\
This makes each point have a diameter equal to one\[Hyphen]tenth of the width \
of the plot. \
\>", "MathCaption",
 CellID->5242],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PointSize", "[", "0.1", "]"}], ",", "%"}], "}"}], ",", 
   RowBox[{"PlotRange", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->24618],

Cell[BoxData[
 GraphicsBox[
  {PointSize[0.1], PointBox[{1, 2}], PointBox[{2, 3}], PointBox[{3, 5}], 
   PointBox[{4, 7}], PointBox[{5, 11}], PointBox[{6, 13}]},
  PlotRange->All]], "Output",
 ImageSize->{108, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->133598032]
}, Open  ]],

Cell["Here each point has size 3 in absolute units. ", "MathCaption",
 CellID->25631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Prime", "[", "n", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"AbsolutePointSize", "[", "3", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->24061],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], AbsolutePointSize[3], 
    PointBox[{{1., 2.}, {2., 3.}, {3., 5.}, {4., 7.}, {5., 11.}, {6., 13.}, {
     7., 17.}, {8., 19.}, {9., 23.}, {10., 29.}, {11., 31.}, {12., 37.}, {13.,
      41.}, {14., 43.}, {15., 47.}, {16., 53.}, {17., 59.}, {18., 61.}, {19., 
     67.}, {20., 71.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 20.}, {0., 71.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->8730703]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Thickness",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Thickness"], "[", 
     StyleBox["w", "TI"], "]"}], Cell[TextData[{
     "give all lines a thickness ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"],
     " as a fraction of the width of the whole plot"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["AbsoluteThickness",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AbsoluteThickness"], "[", 
     StyleBox["w", "TI"], "]"}], Cell[TextData[{
     "give all lines a thickness ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"],
     " measured in absolute units"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Dashing",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dashing"], "[", "{", 
     SubscriptBox[
      StyleBox["w", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["w", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "show all lines as a sequence of dashed segments, with lengths ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["w", "TI"], "1"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["w", "TI"], "2"]], "InlineFormula"],
     ", \[Ellipsis]"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["AbsoluteDashing",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AbsoluteDashing"], "[", "{", 
     SubscriptBox[
      StyleBox["w", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["w", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[
    "use absolute units to measure dashed segments", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->28781],

Cell["Graphics directives for lines. ", "Caption",
 CellID->20990],

Cell["\<\
This generates a list of lines with different absolute thicknesses. \
\>", "MathCaption",
 CellID->12833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"AbsoluteThickness", "[", "n", "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->8672],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"AbsoluteThickness", "[", "3", "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"AbsoluteThickness", "[", "4", "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{329, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->174298017]
}, Open  ]],

Cell["Here is a picture of the lines. ", "MathCaption",
 CellID->21302],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", "%", "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->502],

Cell[BoxData[
 GraphicsBox[{
   {AbsoluteThickness[1], LineBox[{{0, 0}, {1, 1}}]}, 
   {AbsoluteThickness[2], LineBox[{{0, 0}, {2, 1}}]}, 
   {AbsoluteThickness[3], LineBox[{{0, 0}, {3, 1}}]}, 
   {AbsoluteThickness[4], LineBox[{{0, 0}, {4, 1}}]}}]], "Output",
 ImageSize->{184, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->265231475]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Dashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashing"]], "InlineFormula"],
 " graphics directive allows you to create lines with various kinds of \
dashing. The basic idea is to break lines into segments which are alternately \
drawn and omitted. By changing the lengths of the segments, you can get \
different line styles. ",
 Cell[BoxData[
  ButtonBox["Dashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashing"]], "InlineFormula"],
 " allows you to specify a sequence of segment lengths. This sequence is \
repeated as many times as necessary in drawing the whole line. "
}], "Text",
 CellID->30721],

Cell["\<\
This gives a dashed line with a succession of equal\[Hyphen]length segments. \
\
\>", "MathCaption",
 CellID->24898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Dashing", "[", 
     RowBox[{"{", 
      RowBox[{"0.05", ",", "0.05"}], "}"}], "]"}], ",", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->31447],

Cell[BoxData[
 GraphicsBox[
  {Dashing[{0.05, 0.05}], LineBox[{{-1, -1}, {1, 1}}]}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->150058766]
}, Open  ]],

Cell["This gives a dot\[Hyphen]dashed line. ", "MathCaption",
 CellID->28406],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Dashing", "[", 
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.05", ",", "0.05", ",", "0.05"}], "}"}], "]"}], 
    ",", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->2222],

Cell[BoxData[
 GraphicsBox[
  {Dashing[{0.01, 0.05, 0.05, 0.05}], LineBox[{{-1, -1}, {1, 1}}]}]], "Output",\

 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->59612756]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashing"]], "InlineFormula"],
 " can be turned off by specifying an empty list. Here, ",
 Cell[BoxData[
  ButtonBox["Dashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashing"]], "InlineFormula"],
 " is turned off for only the second line."
}], "MathCaption",
 CellID->235028883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Dashing", "[", 
     RowBox[{"{", "0.05", "}"}], "]"}], ",", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "}"}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Dashing", "[", 
       RowBox[{"{", "}"}], "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->191959849],

Cell[BoxData[
 GraphicsBox[
  {Dashing[{0.05}], LineBox[{{0, 0}, {1, 1}}], 
   {Dashing[{}], LineBox[{{0, 0}, {2, 1}}]}, 
   LineBox[{{0, 0}, {3, 1}}]}]], "Output",
 ImageSize->{184, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->526934425]
}, Open  ]],

Cell[TextData[{
 "Graphics directives which require a numerical size specification can also \
accept values of ",
 Cell[BoxData[
  ButtonBox["Tiny",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tiny"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Small",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Small"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Medium",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Medium"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Large",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Large"]], "InlineFormula"],
 ". For each directive, these values have been fine-tuned to produce an \
appearance which will seem appropriate to the human eye."
}], "Text",
 CellID->400853079],

Cell["This specifies a large thickness with medium dashing.", "MathCaption",
 CellID->15327576],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Dashing", "[", 
        RowBox[{"{", "Medium", "}"}], "]"}], ",", " ", 
       RowBox[{"Thickness", "[", "Large", "]"}]}], "}"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->571401502],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->602938187]
}, Open  ]],

Cell["\<\
This specifies that the entire multipoint should use large, green points.\
\>", "MathCaption",
 CellID->291552514],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"PointSize", "[", "Large", "]"}], ",", "Green", ",", 
    RowBox[{"Point", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", ".5"}]}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->95348591],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[0, 1, 0], PointSize[Large], 
   PointBox[{{0, 0}, {1, 0.5}, {2, 0}, {1, -0.5}}]}]], "Output",
 ImageSize->{184, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->194268924]
}, Open  ]],

Cell[TextData[{
 "One way to use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics directives is to insert them directly into the lists of graphics \
primitives used by graphics objects. Sometimes, however, you want the \
graphics directives to be applied more globally, and for example to determine \
the overall \[OpenCurlyDoubleQuote]style\[CloseCurlyDoubleQuote] with which a \
particular type of graphical element should be rendered. There are typically \
graphics options which can be set to specify such styles in terms of lists of \
graphics directives. "
}], "Text",
 CellID->5794],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["PlotStyle",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PlotStyle"], "->", 
     StyleBox["style", "TI"]}], Cell[TextData[{
     "specify a style to be used for all curves in ",
     Cell[BoxData[
      ButtonBox["Plot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Plot"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PlotStyle",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PlotStyle"], "->", "{", "{", 
     SubscriptBox[
      StyleBox["style", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["style", "TI"], "2"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], Cell[TextData[{
     "specify styles to be used (cyclically) for a sequence of curves in ",
     Cell[BoxData[
      ButtonBox["Plot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Plot"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MeshStyle",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MeshStyle"], "->", 
     StyleBox["style", "TI"]}], Cell["\<\
specify a style to be used for a mesh in density and surface graphics\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["BoxStyle",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BoxStyle"], "->", 
     StyleBox["style", "TI"]}], Cell["\<\
specify a style to be used for the bounding box in three\[Hyphen]dimensional \
graphics\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->23577],

Cell["Some graphics options for specifying styles. ", "Caption",
 CellID->12844],

Cell["\<\
This generates a plot in which all curves are specified to use the same \
style. \
\>", "MathCaption",
 CellID->18683],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"BesselJ", "[", 
      RowBox[{"1", ",", "x"}], "]"}], ",", 
     RowBox[{"BesselJ", "[", 
      RowBox[{"2", ",", "x"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.02", "]"}], ",", "Gray"}], "}"}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[31]:=",
 CellID->21547],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]=",
 CellID->213695393]
}, Open  ]],

Cell[TextData[{
 "A different ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " expression can be used to give specific styles to each curve. "
}], "MathCaption",
 CellID->185678201],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"BesselJ", "[", 
      RowBox[{"1", ",", "x"}], "]"}], ",", 
     RowBox[{"BesselJ", "[", 
      RowBox[{"2", ",", "x"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thickness", "[", "0.02", "]"}], ",", "Gray"}], "}"}], ",", 
      " ", 
      RowBox[{"{", "Red", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[32]:=",
 CellID->637104644],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[32]=",
 CellID->362878812]
}, Open  ]],

Cell[TextData[{
 "The various \[OpenCurlyDoubleQuote]style options\[CloseCurlyDoubleQuote] \
allow you to specify how particular graphical elements in a plot should be \
rendered. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " also provides options that affect the rendering of the whole plot. "
}], "Text",
 CellID->31723],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Background",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Background"], "->", 
     StyleBox["color", "TI"]}], Cell[
    "specify the background color for a plot", "TableText"]},
   {
    RowBox[{
     ButtonBox["BaseStyle",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BaseStyle"], "->", 
     StyleBox["color", "TI"]}], Cell[TextData[{
     "specify the base style for a plot, affecting elements not affected by ",
     
     Cell[BoxData[
      ButtonBox["PlotStyle",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Prolog",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Prolog"], "->", 
     StyleBox["g", "TI"]}], Cell[
    "give graphics to render before a plot is started", "TableText"]},
   {
    RowBox[{
     ButtonBox["Epilog",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Epilog"], "->", 
     StyleBox["g", "TI"]}], Cell[
    "give graphics to render after a plot is finished", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->20337],

Cell["Graphics options that affect whole plots. ", "Caption",
 CellID->16653],

Cell["This draws the plot in white on a gray background. ", "MathCaption",
 CellID->27168],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", "Gray"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "White"}]}], "]"}]], "Input",
 CellLabel->"In[33]:=",
 CellID->28130],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[33]=",
 CellID->343029961]
}, Open  ]],

Cell["This makes the axes white as well. ", "MathCaption",
 CellID->1466],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"%", ",", 
   RowBox[{"BaseStyle", "\[Rule]", "White"}]}], "]"}]], "Input",
 CellLabel->"In[34]:=",
 CellID->4858],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[34]=",
 CellID->440718630]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->465132819],

Cell[TextData[ButtonBox["The Structure of Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]], \
"RelatedTutorials",
 CellID->1229394717]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Graphics Directives and Options - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["The Structure of Graphics and Sound", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/TwoDimensionalGraphicsElements"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/CoordinateSystemsForTwoDimensionalGraphics"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 36, 53.8637280}", "context" -> "", 
    "keywords" -> {
     "AbsoluteDashing", "AbsolutePointSize", "absolute size", 
      "AbsoluteThickness", "background", "black", "blue", "BoxStyle", 
      "brightness", "color", "color wheel", "curves", "cyan", "darkness", 
      "dashed lines", "dashing", "DefaultColor", "density", "dotted lines", 
      "Epilog", "graphics", "graphics directives", "GrayLevel", "Green", 
      "HSB color space", "hue", "inches", "intensity", "inverse video", 
      "lines", "lists", "magenta", "MeshStyle", "multiple curves", "plot", 
      "plots", "PlotStyle", "points", "PointSize", "printers points", 
      "Prolog", "red", "RGBColor", "saturation", "scoping", "screen density", 
      "size", "style", "style options", "styles", "text", "thickness", 
      "tint (color)", "White", "yellow"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "When you set up a graphics object in Mathematica, you typically give a \
list of graphical elements. You can include in that list graphics directives \
which specify how subsequent elements in the list should be rendered. In \
general, the graphical elements in a particular graphics object can be given \
in a collection of nested lists. When you insert graphics directives in this \
kind of structure, the rule is that a particular graphics directive affects \
all subsequent elements of the list it is in, together with all elements of \
sublists that may occur. The graphics directive does not, however, have any \
effect outside the list it is in. The first sublist contains the graphics \
directive GrayLevel. ", "synonyms" -> {}, "title" -> 
    "Graphics Directives and Options", "type" -> "Tutorial", "uri" -> 
    "tutorial/GraphicsDirectivesAndOptions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.10.3"->{
  Cell[3547, 84, 95, 2, 70, "Title",
   CellTags->{"S2.10.3", "3.1"},
   CellID->25633]},
 "3.1"->{
  Cell[3547, 84, 95, 2, 70, "Title",
   CellTags->{"S2.10.3", "3.1"},
   CellID->25633]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.10.3", 60380, 1684},
 {"3.1", 60480, 1688}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2922, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3547, 84, 95, 2, 70, "Title",
 CellTags->{"S2.10.3", "3.1"},
 CellID->25633],
Cell[3645, 88, 352, 10, 70, "Text",
 CellID->1954],
Cell[4000, 100, 467, 8, 70, "Text",
 CellID->930],
Cell[4470, 110, 232, 8, 70, "MathCaption",
 CellID->10252],
Cell[CellGroupData[{
Cell[4727, 122, 549, 19, 28, "Input",
 CellID->19904],
Cell[5279, 143, 643, 22, 36, "Output",
 CellID->275916535]
}, Open  ]],
Cell[5937, 168, 251, 8, 70, "MathCaption",
 CellID->12488],
Cell[CellGroupData[{
Cell[6213, 180, 100, 3, 28, "Input",
 CellID->24870],
Cell[6316, 185, 238, 7, 201, "Output",
 CellID->371078911]
}, Open  ]],
Cell[6569, 195, 1510, 47, 70, "DefinitionBox",
 CellID->32176],
Cell[8082, 244, 133, 6, 70, "Caption",
 CellID->26701],
Cell[8218, 252, 944, 32, 70, "Text",
 CellID->267365338],
Cell[9165, 286, 278, 9, 70, "MathCaption",
 CellID->15415],
Cell[CellGroupData[{
Cell[9468, 299, 593, 20, 47, "Input",
 CellID->18086],
Cell[10064, 321, 3083, 55, 140, "Output",
 Evaluatable->False,
 CellID->79207416]
}, Open  ]],
Cell[13162, 379, 1326, 38, 70, "Text",
 CellID->17480],
Cell[14491, 419, 493, 15, 70, "Text",
 CellID->30260],
Cell[14987, 436, 802, 27, 70, "Text",
 CellID->20514],
Cell[15792, 465, 633, 18, 70, "Text",
 CellID->8938],
Cell[16428, 485, 1025, 31, 70, "DefinitionBox",
 CellID->16657],
Cell[17456, 518, 67, 1, 70, "Caption",
 CellID->14990],
Cell[17526, 521, 65, 1, 70, "MathCaption",
 CellID->19438],
Cell[CellGroupData[{
Cell[17616, 526, 289, 10, 70, "Input",
 CellID->28981],
Cell[17908, 538, 750, 25, 54, "Output",
 CellID->185348845]
}, Open  ]],
Cell[18673, 566, 139, 4, 70, "MathCaption",
 CellID->5242],
Cell[CellGroupData[{
Cell[18837, 574, 248, 8, 70, "Input",
 CellID->24618],
Cell[19088, 584, 323, 9, 237, "Output",
 CellID->133598032]
}, Open  ]],
Cell[19426, 596, 85, 1, 70, "MathCaption",
 CellID->25631],
Cell[CellGroupData[{
Cell[19536, 601, 349, 11, 70, "Input",
 CellID->24061],
Cell[19888, 614, 710, 19, 141, "Output",
 CellID->8730703]
}, Open  ]],
Cell[20613, 636, 2039, 62, 70, "DefinitionBox",
 CellID->28781],
Cell[22655, 700, 66, 1, 70, "Caption",
 CellID->20990],
Cell[22724, 703, 115, 3, 70, "MathCaption",
 CellID->12833],
Cell[CellGroupData[{
Cell[22864, 710, 471, 16, 70, "Input",
 CellID->8672],
Cell[23338, 728, 1439, 48, 88, "Output",
 CellID->174298017]
}, Open  ]],
Cell[24792, 779, 71, 1, 70, "MathCaption",
 CellID->21302],
Cell[CellGroupData[{
Cell[24888, 784, 98, 3, 70, "Input",
 CellID->502],
Cell[24989, 789, 391, 10, 72, "Output",
 CellID->265231475]
}, Open  ]],
Cell[25395, 802, 679, 17, 70, "Text",
 CellID->30721],
Cell[26077, 821, 126, 4, 70, "MathCaption",
 CellID->24898],
Cell[CellGroupData[{
Cell[26228, 829, 495, 18, 70, "Input",
 CellID->31447],
Cell[26726, 849, 227, 7, 201, "Output",
 CellID->150058766]
}, Open  ]],
Cell[26968, 859, 77, 1, 70, "MathCaption",
 CellID->28406],
Cell[CellGroupData[{
Cell[27070, 864, 526, 19, 70, "Input",
 CellID->2222],
Cell[27599, 885, 241, 8, 201, "Output",
 CellID->59612756]
}, Open  ]],
Cell[27855, 896, 391, 12, 70, "MathCaption",
 CellID->235028883],
Cell[CellGroupData[{
Cell[28271, 912, 1022, 35, 70, "Input",
 CellID->191959849],
Cell[29296, 949, 296, 9, 86, "Output",
 CellID->526934425]
}, Open  ]],
Cell[29607, 961, 754, 25, 70, "Text",
 CellID->400853079],
Cell[30364, 988, 95, 1, 70, "MathCaption",
 CellID->15327576],
Cell[CellGroupData[{
Cell[30484, 993, 508, 16, 28, "Input",
 CellID->571401502],
Cell[30995, 1011, 2393, 43, 128, "Output",
 Evaluatable->False,
 CellID->602938187]
}, Open  ]],
Cell[33403, 1057, 124, 3, 70, "MathCaption",
 CellID->291552514],
Cell[CellGroupData[{
Cell[33552, 1064, 573, 19, 70, "Input",
 CellID->95348591],
Cell[34128, 1085, 265, 8, 115, "Output",
 CellID->194268924]
}, Open  ]],
Cell[34408, 1096, 604, 12, 70, "Text",
 CellID->5794],
Cell[35015, 1110, 1813, 54, 70, "DefinitionBox",
 CellID->23577],
Cell[36831, 1166, 80, 1, 70, "Caption",
 CellID->12844],
Cell[36914, 1169, 128, 4, 70, "MathCaption",
 CellID->18683],
Cell[CellGroupData[{
Cell[37067, 1177, 531, 18, 28, "Input",
 CellID->21547],
Cell[37601, 1197, 4805, 83, 125, "Output",
 Evaluatable->False,
 CellID->213695393]
}, Open  ]],
Cell[42421, 1283, 259, 8, 70, "MathCaption",
 CellID->185678201],
Cell[CellGroupData[{
Cell[42705, 1295, 599, 20, 47, "Input",
 CellID->637104644],
Cell[43307, 1317, 4797, 83, 125, "Output",
 Evaluatable->False,
 CellID->362878812]
}, Open  ]],
Cell[48119, 1403, 331, 8, 70, "Text",
 CellID->31723],
Cell[48453, 1413, 1439, 43, 70, "DefinitionBox",
 CellID->20337],
Cell[49895, 1458, 77, 1, 70, "Caption",
 CellID->16653],
Cell[49975, 1461, 90, 1, 70, "MathCaption",
 CellID->27168],
Cell[CellGroupData[{
Cell[50090, 1466, 347, 10, 28, "Input",
 CellID->28130],
Cell[50440, 1478, 2860, 51, 119, "Output",
 Evaluatable->False,
 CellID->343029961]
}, Open  ]],
Cell[53315, 1532, 73, 1, 70, "MathCaption",
 CellID->1466],
Cell[CellGroupData[{
Cell[53413, 1537, 161, 5, 28, "Input",
 CellID->4858],
Cell[53577, 1544, 2868, 51, 119, "Output",
 Evaluatable->False,
 CellID->440718630]
}, Open  ]],
Cell[CellGroupData[{
Cell[56482, 1600, 72, 1, 70, "RelatedTutorialsSection",
 CellID->465132819],
Cell[56557, 1603, 201, 5, 70, "RelatedTutorials",
 CellID->1229394717]
}, Open  ]]
}, Open  ]],
Cell[56785, 1612, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

