(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25450,        791]
NotebookOptionsPosition[     20758,        649]
NotebookOutlinePosition[     23493,        719]
CellTagsIndexPosition[     23399,        713]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Structure of Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"The Structure of Graphics and Sound\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Text" :> Documentation`HelpLookup["paclet:ref/Text"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Text\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Graphics Primitives for Text", "Title",
 CellTags->{"S2.10.16", "16.1"},
 CellID->3318],

Cell[TextData[{
 "With the ",
 Cell[BoxData[
  ButtonBox["Text",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Text"]], "InlineFormula"],
 " graphics primitive, you can insert text at any position in two\[Hyphen] or \
three\[Hyphen]dimensional ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics. Unless you explicitly specify a style or font using ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 ", the text will be given in the graphic's base style. "
}], "Text",
 CellID->13201],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Text",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Text"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "}", "]"}], Cell[TextData[{
     "text centered at the point ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"], "}"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Text",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Text"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "}", ",", "{", "-", "1", ",", "0", "}", "]"}], Cell[
    TextData[{
     "text with its left\[Hyphen]hand end at ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"], "}"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Text",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Text"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "}", ",", "{", "1", ",", "0", "}", "]"}], Cell[
    TextData[{
     "right\[Hyphen]hand end at ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"], "}"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Text",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Text"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "}", ",", "{", "0", ",", "-", "1", "}", "]"}], Cell[
    TextData[{
     "centered above ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"], "}"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Text",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Text"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "}", ",", "{", "0", ",", "1", "}", "]"}], Cell[
    TextData[{
     "centered below ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"], "}"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Text",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Text"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "}", ",", "{", 
     StyleBox["dx", "TI"], ",", 
     StyleBox["dy", "TI"], "}", "]"}], Cell[TextData[{
     "text positioned so that ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"], "}"}]], "InlineFormula"],
     " is at relative coordinates ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["dx", "TI"], ",", 
       StyleBox["dy", "TI"], "}"}]], "InlineFormula"],
     " within the box that bounds the text"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Text",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Text"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "}", ",", "{", 
     StyleBox["dx", "TI"], ",", 
     StyleBox["dy", "TI"], "}", ",", "{", "0", ",", "1", "}", "]"}], Cell[
    "text oriented vertically to read from bottom to top", "TableText"]},
   {
    RowBox[{
     ButtonBox["Text",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Text"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "}", ",", "{", 
     StyleBox["dx", "TI"], ",", 
     StyleBox["dy", "TI"], "}", ",", "{", "0", ",", "-", "1", "}", "]"}], 
    Cell["text that reads from top to bottom", "TableText"]},
   {
    RowBox[{
     ButtonBox["Text",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Text"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "}", ",", "{", 
     StyleBox["dx", "TI"], ",", 
     StyleBox["dy", "TI"], "}", ",", "{", "-", "1", ",", "0", "}", "]"}], 
    Cell["text that is upside\[Hyphen]down", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->142],

Cell["Two\[Hyphen]dimensional text. ", "Caption",
 CellID->21276],

Cell["\<\
This generates five pieces of text, and displays them in a plot. \
\>", "MathCaption",
 CellID->31506],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Expand", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "x"}], ")"}], "^", "n"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "n"}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"PlotRange", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->32702],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    RowBox[{"x", "+", "1"}], {1, 1}], InsetBox[
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"2", " ", "x"}], "+", "1"}], {2, 2}], InsetBox[
    RowBox[{
     SuperscriptBox["x", "3"], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"3", " ", "x"}], "+", "1"}], {3, 3}], InsetBox[
    RowBox[{
     SuperscriptBox["x", "4"], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["x", "3"]}], "+", 
     RowBox[{"6", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"4", " ", "x"}], "+", "1"}], {4, 4}], InsetBox[
    RowBox[{
     SuperscriptBox["x", "5"], "+", 
     RowBox[{"5", " ", 
      SuperscriptBox["x", "4"]}], "+", 
     RowBox[{"10", " ", 
      SuperscriptBox["x", "3"]}], "+", 
     RowBox[{"10", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"5", " ", "x"}], "+", "1"}], {5, 5}]},
  PlotRange->All]], "Output",
 ImageSize->{184, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->563084712]
}, Open  ]],

Cell[TextData[{
 "Here is some vertically oriented text with its left\[Hyphen]hand side at \
the point ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"2", ",", "2"}], "}"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->15023],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"Text", "[", 
     RowBox[{
      RowBox[{"StyleForm", "[", 
       RowBox[{"\"\<Some text\>\"", ",", 
        RowBox[{"FontSize", "->", "14"}], ",", 
        RowBox[{"FontWeight", "->", "\"\<Bold\>\""}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"Frame", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->30270],

Cell[BoxData[
 GraphicsBox[InsetBox[
   TagBox[
    StyleBox["\<\"Some text\"\>",
     FontSize->14,
     FontWeight->"Bold"],
    StyleForm[#, FontSize -> 14, FontWeight -> "Bold"]& ], {2, 2}, {-1, 0}, 
   Automatic, {0, 1}],
  Frame->True]], "Output",
 ImageSize->{184, 178},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->1951805902]
}, Open  ]],

Cell[TextData[{
 "When you specify an offset for text, the relative coordinates that are used \
are taken to run from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 " to 1 in each direction across the box that bounds the text. The point ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0", ",", "0"}], "}"}]], "InlineFormula"],
 " in this coordinate system is defined to be center of the text. Note that \
the offsets you specify need not lie in the range ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 " to 1. "
}], "Text",
 CellID->8250],

Cell[TextData[{
 "Note that you can specify the color of a piece of text by preceding the ",
 Cell[BoxData[
  ButtonBox["Text",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Text"]], "InlineFormula"],
 " graphics primitive with an appropriate ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 " or other graphics directive. "
}], "Text",
 CellID->13475],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Text",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Text"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["z", "TI"], "}", "]"}], Cell[TextData[{
     "text centered at the point ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"], ",", 
       StyleBox["z", "TI"], "}"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Text",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Text"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["z", "TI"], "}", ",", "{", 
     StyleBox["sdx", "TI"], ",", 
     StyleBox["sdy", "TI"], "}", "]"}], Cell["\<\
text with a two\[Hyphen]dimensional offset\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->20311],

Cell["Three\[Hyphen]dimensional text. ", "Caption",
 CellID->26850],

Cell["\<\
This puts text at the specified position in three dimensions. \
\>", "MathCaption",
 CellID->11520],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"PolyhedronData", "[", 
     RowBox[{"\"\<Dodecahedron\>\"", ",", "\"\<Faces\>\""}], "]"}], ",", 
    RowBox[{"Text", "[", 
     RowBox[{"\"\<a point\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->26101],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 200},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->307027914]
}, Open  ]],

Cell[TextData[{
 "Note that when you use text in three\[Hyphen]dimensional graphics, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " assumes that the text is never hidden by any polygons or other objects. "
}], "Text",
 CellID->24798],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["background color", "TableText"]},
   {
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell["style or font specification", "TableText"]},
   {
    ButtonBox["FormatType",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FormatType"], 
    ButtonBox["StandardForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/StandardForm"], Cell[
    "format type", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->27892],

Cell[TextData[{
 "Options for ",
 StyleBox["Text", "MR"],
 ". "
}], "Caption",
 CellID->18848],

Cell["\<\
By default the text is just put straight on top of whatever graphics have \
already been drawn. \
\>", "MathCaption",
 CellID->6784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", 
      RowBox[{"Rectangle", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], "}"}], ",", 
    RowBox[{"Text", "[", 
     RowBox[{"\"\<Some text\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"0.5", ",", "0.5"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->30245],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0.5], RectangleBox[{0, 0}]}, 
   InsetBox["\<\"Some text\"\>", {0.5, 0.5}]}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->502205141]
}, Open  ]],

Cell["\<\
Now there is a rectangle with the background color of the whole plot \
enclosing the text. \
\>", "MathCaption",
 CellID->14462],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", 
      RowBox[{"Rectangle", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], "}"}], ",", 
    RowBox[{"Text", "[", 
     RowBox[{"\"\<Some text\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"0.5", ",", "0.5"}], "}"}], ",", 
      RowBox[{"Background", "->", "Automatic"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->28343],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0.5], RectangleBox[{0, 0}]}, 
   InsetBox["\<\"Some text\"\>", {0.5, 0.5},
    Background->Automatic]}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->951072077]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->653660549],

Cell[TextData[ButtonBox["The Structure of Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]], \
"RelatedTutorials",
 CellID->1229394717]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Graphics Primitives for Text - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["The Structure of Graphics and Sound", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/FormatsForTextInGraphics"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TheRepresentationOfSound"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 36, 55.3168902}", "context" -> "", 
    "keywords" -> {
     "annotations", "graphics", "labels", "legends on plots", "text"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "With the Text graphics primitive, you can insert text at any position in \
two- or three-dimensional Mathematica graphics. Unless you explicitly specify \
a style or font using Style, the text will be given in the graphic's base \
style. Two-dimensional text. This generates five pieces of text, and displays \
them in a plot. ", "synonyms" -> {}, "title" -> 
    "Graphics Primitives for Text", "type" -> "Tutorial", "uri" -> 
    "tutorial/GraphicsPrimitivesForText"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.10.16"->{
  Cell[1829, 58, 93, 2, 70, "Title",
   CellTags->{"S2.10.16", "16.1"},
   CellID->3318]},
 "16.1"->{
  Cell[1829, 58, 93, 2, 70, "Title",
   CellTags->{"S2.10.16", "16.1"},
   CellID->3318]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.10.16", 23183, 702},
 {"16.1", 23285, 706}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1204, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1829, 58, 93, 2, 70, "Title",
 CellTags->{"S2.10.16", "16.1"},
 CellID->3318],
Cell[1925, 62, 565, 17, 70, "Text",
 CellID->13201],
Cell[2493, 81, 4544, 140, 70, "DefinitionBox",
 CellID->142],
Cell[7040, 223, 65, 1, 70, "Caption",
 CellID->21276],
Cell[7108, 226, 112, 3, 70, "MathCaption",
 CellID->31506],
Cell[CellGroupData[{
Cell[7245, 233, 560, 18, 28, "Input",
 CellID->32702],
Cell[7808, 253, 1069, 32, 141, "Output",
 CellID->563084712]
}, Open  ]],
Cell[8892, 288, 231, 8, 70, "MathCaption",
 CellID->15023],
Cell[CellGroupData[{
Cell[9148, 300, 638, 19, 70, "Input",
 CellID->30270],
Cell[9789, 321, 387, 13, 199, "Output",
 CellID->1951805902]
}, Open  ]],
Cell[10191, 337, 616, 17, 70, "Text",
 CellID->8250],
Cell[10810, 356, 429, 13, 70, "Text",
 CellID->13475],
Cell[11242, 371, 1226, 38, 70, "DefinitionBox",
 CellID->20311],
Cell[12471, 411, 67, 1, 70, "Caption",
 CellID->26850],
Cell[12541, 414, 109, 3, 70, "MathCaption",
 CellID->11520],
Cell[CellGroupData[{
Cell[12675, 421, 453, 13, 47, "Input",
 CellID->26101],
Cell[13131, 436, 3723, 65, 221, "Output",
 Evaluatable->False,
 CellID->307027914]
}, Open  ]],
Cell[16869, 504, 241, 6, 70, "Text",
 CellID->24798],
Cell[17113, 512, 1092, 31, 70, "DefinitionBox3Col",
 CellID->27892],
Cell[18208, 545, 94, 5, 70, "Caption",
 CellID->18848],
Cell[18305, 552, 142, 4, 70, "MathCaption",
 CellID->6784],
Cell[CellGroupData[{
Cell[18472, 560, 561, 18, 70, "Input",
 CellID->30245],
Cell[19036, 580, 264, 8, 201, "Output",
 CellID->502205141]
}, Open  ]],
Cell[19315, 591, 138, 4, 70, "MathCaption",
 CellID->14462],
Cell[CellGroupData[{
Cell[19478, 599, 619, 20, 70, "Input",
 CellID->28343],
Cell[20100, 621, 291, 9, 201, "Output",
 CellID->951072077]
}, Open  ]],
Cell[CellGroupData[{
Cell[20428, 635, 72, 1, 70, "RelatedTutorialsSection",
 CellID->653660549],
Cell[20503, 638, 201, 5, 70, "RelatedTutorials",
 CellID->1229394717]
}, Open  ]]
}, Open  ]],
Cell[20731, 647, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

