(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    223706,       7331]
NotebookOptionsPosition[    193044,       6257]
NotebookOutlinePosition[    195096,       6303]
CellTagsIndexPosition[    195053,       6300]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Column" :> Documentation`HelpLookup["paclet:ref/Column"], 
         "Dividers" :> Documentation`HelpLookup["paclet:ref/Dividers"], 
         "Frame" :> Documentation`HelpLookup["paclet:ref/Frame"], 
         "FrameStyle" :> Documentation`HelpLookup["paclet:ref/FrameStyle"], 
         "GraphicsColumn" :> 
         Documentation`HelpLookup["paclet:ref/GraphicsColumn"], 
         "GraphicsGrid" :> 
         Documentation`HelpLookup["paclet:ref/GraphicsGrid"], "GraphicsRow" :> 
         Documentation`HelpLookup["paclet:ref/GraphicsRow"], "Grid" :> 
         Documentation`HelpLookup["paclet:ref/Grid"], "Item" :> 
         Documentation`HelpLookup["paclet:ref/Item"], "Row" :> 
         Documentation`HelpLookup["paclet:ref/Row"], "Spacings" :> 
         Documentation`HelpLookup["paclet:ref/Spacings"], "SpanFromAbove" :> 
         Documentation`HelpLookup["paclet:ref/SpanFromAbove"], "SpanFromBoth" :> 
         Documentation`HelpLookup["paclet:ref/SpanFromBoth"], "SpanFromLeft" :> 
         Documentation`HelpLookup["paclet:ref/SpanFromLeft"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Column\"\>", 2->"\<\"Dividers\"\>", 
      3->"\<\"Frame\"\>", 4->"\<\"FrameStyle\"\>", 
      5->"\<\"GraphicsColumn\"\>", 6->"\<\"GraphicsGrid\"\>", 
      7->"\<\"GraphicsRow\"\>", 8->"\<\"Grid\"\>", 9->"\<\"Item\"\>", 
      10->"\<\"Row\"\>", 11->"\<\"Spacings\"\>", 12->"\<\"SpanFromAbove\"\>", 
      13->"\<\"SpanFromBoth\"\>", 
      14->"\<\"SpanFromLeft\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Grids, Rows, and Columns in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Title",
 CellID->509267359],

Cell[CellGroupData[{

Cell["The Basic Constructs", "Section",
 CellID->1091725847],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides a broad range of powerful constructs for laying out content on a \
screen or page. They are designed to be immediately useful for the beginner, \
yet also allow fine control over almost every aspect of their appearance. "
}], "Text",
 CellID->344237187],

Cell["\<\
These constructs can be placed into three families: constructs that appear \
within notebooks as typesetting structures; functions that generate graphics \
whose contents are arranged on a grid; and constructs that can appear inside \
grids to adjust details of formatting.\
\>", "Reference",
 CellID->1493879423],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Column",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Column"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Row",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Row"]], "InlineFormula"],
 " form the first family, referred to in this tutorial as the Grid family. \
The Grid family's defining characteristic is that it is a tightly integrated \
part of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s typesetting system. This means that any expression whatsoever can appear \
as content, and that the construct itself can respond to changes such as \
window width or even the size of its elements. Like other typesetting \
constructs, the Grid family's members are inert declarative descriptions and \
do not evaluate to some other form. "
}], "Text",
 CellID->2000928762],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Labeled", "[", 
  RowBox[{
   RowBox[{"Grid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Text", "@", 
          RowBox[{"Style", "[", 
           RowBox[{"#", ",", "14"}], "]"}]}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{"\"\<Grid\>\"", ",", "\"\<Column\>\"", ",", "\"\<Row\>\""}], 
         "}"}]}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Grid", "[", 
          RowBox[{"Partition", "[", 
           RowBox[{
            RowBox[{"CharacterRange", "[", 
             RowBox[{"\"\<a\>\"", ",", "\"\<z\>\""}], "]"}], ",", "6"}], 
           "]"}], "]"}], ",", 
         RowBox[{"Column", "[", 
          RowBox[{"{", 
           RowBox[{
           "\"\<a\>\"", ",", "\"\<b\>\"", ",", "\"\<c\>\"", ",", 
            "\"\<d\>\""}], "}"}], "]"}], ",", 
         RowBox[{"Row", "[", 
          RowBox[{"CharacterRange", "[", 
           RowBox[{"\"\<a\>\"", ",", "\"\<z\>\""}], "]"}], "]"}]}], "}"}]}], 
      "}"}], ",", 
     RowBox[{"Alignment", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Center", ",", 
        RowBox[{"{", 
         RowBox[{"Bottom", ",", "Top"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "All"}], ",", 
     RowBox[{"ItemSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"10", ",", "10", ",", "10"}], "}"}], "}"}]}], ",", 
     RowBox[{"Spacings", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}], ",", 
   RowBox[{
   "Text", "@", 
    "\"\<Examples of the Grid family of formatting constructs.\>\""}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"Bottom", ",", "Left"}], "}"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[668]:=",
 CellID->815991614],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{380, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->64652122]
}, {2}]],

Cell[TextData[{
 "A parallel set of constructs\[LongDash]the Graphics Grid \
family\[LongDash]exists specifically for generating graphics, with the \
individual graphical elements arranged in a grid. These constructs are ",
 Cell[BoxData[
  ButtonBox["GraphicsGrid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsGrid"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["GraphicsColumn",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsColumn"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["GraphicsRow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsRow"]], "InlineFormula"],
 ". Though graphics can be used in the Grid family, the Graphics Grid family \
supports sizing and editing behavior more tailored to graphics. The Graphics \
Grid family has functions that take arguments and evaluates them into a new \
graphics expression, which means it is difficult to make the generated grid \
respond to changes in its environment, but easy to interactively add \
arbitrary annotation and additional graphics."
}], "Text",
 CellID->207512326],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Labeled", "[", 
  RowBox[{
   RowBox[{"Grid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Text", "@", 
          RowBox[{"Style", "[", 
           RowBox[{"#", ",", "14"}], "]"}]}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{
         "\"\<GraphicsGrid\>\"", ",", "\"\<GraphicsColumn\>\"", ",", 
          "\"\<GraphicsRow\>\""}], "}"}]}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GraphicsGrid", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Graphics", "[", 
                RowBox[{"Rectangle", "[", "]"}], "]"}], ",", 
               RowBox[{"Graphics", "[", 
                RowBox[{"Disk", "[", "]"}], "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Graphics", "[", 
                RowBox[{"Disk", "[", "]"}], "]"}], ",", 
               RowBox[{"Graphics", "[", 
                RowBox[{"Rectangle", "[", "]"}], "]"}]}], "}"}]}], "}"}], ",",
            
           RowBox[{"ImageSize", "\[Rule]", "100"}]}], "]"}], ",", 
         RowBox[{"GraphicsColumn", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Graphics", "[", 
              RowBox[{"Rectangle", "[", "]"}], "]"}], ",", 
             RowBox[{"Graphics", "[", 
              RowBox[{"Disk", "[", "]"}], "]"}], ",", 
             RowBox[{"Graphics", "[", 
              RowBox[{"Rectangle", "[", "]"}], "]"}]}], "}"}], ",", 
           RowBox[{"ImageSize", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"50", ",", "100"}], "}"}]}]}], "]"}], ",", 
         RowBox[{"GraphicsRow", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Graphics", "[", 
              RowBox[{"Rectangle", "[", "]"}], "]"}], ",", 
             RowBox[{"Graphics", "[", 
              RowBox[{"Disk", "[", "]"}], "]"}], ",", 
             RowBox[{"Graphics", "[", 
              RowBox[{"Rectangle", "[", "]"}], "]"}]}], "}"}], ",", 
           RowBox[{"ImageSize", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"100", ",", "50"}], "}"}]}]}], "]"}]}], "}"}]}], "}"}], 
     ",", 
     RowBox[{"Alignment", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Center", ",", 
        RowBox[{"{", 
         RowBox[{"Bottom", ",", "Top"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "All"}], ",", 
     RowBox[{"ItemSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"10", ",", "10", ",", "10"}], "}"}], "}"}]}], ",", 
     RowBox[{"Spacings", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}], ",", 
   RowBox[{
   "Text", "@", 
    "\"\<Examples of the GraphicsGrid family of formatting constructs.\>\""}],
    ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"Bottom", ",", "Left"}], "}"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[669]:=",
 CellID->1241370748],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{380, 165},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->132625587]
}, {2}]],

Cell[TextData[{
 "The final family\[LongDash]the Embedded Constructs \
family\[LongDash]consists of constructs that are embedded within the grids \
themselves, and alter the grid's appearance from within. ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 " can be wrapped around elements in a grid in order to style the region in \
which they appear. ",
 Cell[BoxData[
  ButtonBox["SpanFromLeft",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpanFromLeft"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["SpanFromAbove",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpanFromAbove"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["SpanFromBoth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpanFromBoth"]], "InlineFormula"],
 " are used to create regions that span across multiple rows or columns."
}], "Text",
 CellID->804197510],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Labeled", "[", 
  RowBox[{
   RowBox[{"Grid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Text", "@", 
          RowBox[{"Style", "[", 
           RowBox[{"#", ",", "14"}], "]"}]}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{
         "\"\<Item\>\"", ",", "\"\<SpanFromLeft\>\"", ",", " ", 
          "\"\<SpanFromAbove\>\"", ",", "\"\<SpanFromBoth\>\""}], "}"}]}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Grid", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Item", "[", 
               RowBox[{"\"\<a\>\"", ",", 
                RowBox[{"Background", "\[Rule]", "Red"}], ",", 
                RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
              "\"\<b\>\"", ",", "\"\<c\>\""}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<d\>\"", ",", "\"\<e\>\"", ",", "\"\<f\>\""}], "}"}],
             ",", 
            RowBox[{"{", 
             RowBox[{"\"\<g\>\"", ",", "\"\<h\>\"", ",", "\"\<i\>\""}], 
             "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Grid", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\"\<a\>\"", ",", "SpanFromLeft", ",", "\"\<c\>\""}], 
              "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<d\>\"", ",", "\"\<e\>\"", ",", "\"\<f\>\""}], 
              "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<g\>\"", ",", "\"\<h\>\"", ",", "\"\<i\>\""}], 
              "}"}]}], "}"}], ",", 
           RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}], ",", 
         RowBox[{"Grid", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\"\<a\>\"", ",", "\"\<b\>\"", ",", "\"\<c\>\""}], 
              "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"SpanFromAbove", ",", "\"\<e\>\"", ",", "\"\<f\>\""}], 
              "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<g\>\"", ",", "\"\<h\>\"", ",", "\"\<i\>\""}], 
              "}"}]}], "}"}], ",", 
           RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}], ",", 
         RowBox[{"Grid", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\"\<a\>\"", ",", "SpanFromLeft", ",", "\"\<c\>\""}], 
              "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
              "SpanFromAbove", ",", "SpanFromBoth", ",", "\"\<f\>\""}], "}"}],
              ",", 
             RowBox[{"{", 
              RowBox[{"\"\<g\>\"", ",", "\"\<h\>\"", ",", "\"\<i\>\""}], 
              "}"}]}], "}"}], ",", 
           RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]}], "}"}]}], "}"}], 
     ",", 
     RowBox[{"Alignment", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Center", ",", 
        RowBox[{"{", 
         RowBox[{"Bottom", ",", "Top"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "All"}], ",", 
     RowBox[{"ItemSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"5", ",", "8", ",", "9", ",", "9"}], "}"}], "}"}]}], ",", 
     RowBox[{"Spacings", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
   
   RowBox[{"Text", "@", "\"\<Examples of embeddable constructs.\>\""}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"Bottom", ",", "Left"}], "}"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[748]:=",
 CellID->829809070],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{394, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[748]=",
 CellID->118334785]
}, {2}]],

Cell["\<\
Some very basic examples of all of these constructs follow below.\
\>", "Text",
 CellID->1338280749],

Cell[CellGroupData[{

Cell["Grid family", "Subsection",
 CellID->391204127],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Grid",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Grid"], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["expr", "TI"], 
          StyleBox["11", "TR"]], ",", 
         SubscriptBox[
          StyleBox["expr", "TI"], 
          StyleBox["12", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["expr", "TI"], 
          StyleBox["21", "TR"]], ",", 
         SubscriptBox[
          StyleBox["expr", "TI"], 
          StyleBox["22", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "an object that formats with the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["ij", "TI"]]], "InlineFormula"],
     " arranged in a two-dimensional grid"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Column",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Column"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[TextData[{
     "an object that formats with the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " arranged in a column, with ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " above ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", etc."
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Row",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Row"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[TextData[{
     "an object that formats with the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " arranged in a row, potentially extending over several lines"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->1410847087],

Cell["The Grid family of 2D formatting constructs.", "Caption",
 CellID->1740044682],

Cell["A grid of elements.", "MathCaption",
 CellID->1639368631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<a\>\"", ",", "\"\<b\>\"", ",", "\"\<c\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<d\>\"", ",", "\"\<e\>\"", ",", "\"\<f\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<g\>\"", ",", "\"\<h\>\"", ",", "\"\<i\>\""}], "}"}]}], 
   "}"}], "]"}]], "Input",
 CellLabel->"In[684]:=",
 CellID->752842721],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"a\"\>", "\<\"b\"\>", "\<\"c\"\>"},
    {"\<\"d\"\>", "\<\"e\"\>", "\<\"f\"\>"},
    {"\<\"g\"\>", "\<\"h\"\>", "\<\"i\"\>"}
   }],
  "Grid"]], "Output",
 ImageSize->{41, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[684]=",
 CellID->1888313412]
}, Open  ]],

Cell["A column of elements.", "MathCaption",
 CellID->653390207],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"{", 
   RowBox[{
   "\"\<a\>\"", ",", " ", "\"\<b\>\"", ",", " ", "\"\<c\>\"", ",", " ", 
    "\"\<d\>\""}], "}"}], "]"}]], "Input",
 CellLabel->"In[686]:=",
 CellID->53963723],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"a\"\>"},
    {"\<\"b\"\>"},
    {"\<\"c\"\>"},
    {"\<\"d\"\>"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}}],
  "Column"]], "Output",
 ImageSize->{11, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[686]=",
 CellID->1150096445]
}, Open  ]],

Cell["A row of elements.", "MathCaption",
 CellID->1445321938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"CharacterRange", "[", 
   RowBox[{"\"\<a\>\"", ",", " ", "\"\<z\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[685]:=",
 CellID->730193427],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVs1OwzAM9tKkHeMw4MRxB8RpEhLwDHDiIaoJaTsg0Niz7fVKmtqZ6zhb
twlBpdaz8/kn9pz4rd4s3z/qzWpRz17X9ddytfievXyuvagYAcDWv9Nb8L8b
/yu826bxdO6/hWevkd4jHSN99NR6ehHQD+23FTfhCVqcvxP8WPBP2joY/514
oUWfLXXQyS3Sli+QBxfU8CGTYRllBYGYLwNoOmqSXa45VlEF825FVBSlYzgj
4xGxcJ58GEatjB19jTo8WqYVsDskLh4tqbQIXeRZnKlURuvyupkcxJ24mJO9
Hs+XqhXRUZWQMrtGWIo6+j56GXdcP/F8WqXLQZmXnXF2rTMZKgX2bytcqSj9
vzqsptTpTqC17u2fZodrZLMop+zt7Apajir+Xe34zXDqvvUd9GrY6yXpK9OR
4oYZ0qX8tB94MileogVZpV88iffs8GAe+HkZ77gTz+Wj/2FpvANwu76le53W
AaiTLKQ3PuWQtBzHlFE9gikrhbDZmxAoY0mn0rTSSeTkQZ1jMmtiKlJQNPdo
01K0mkxkpbSyF63Nb12/yQlyKni5PhH8jeDlufYs+HnwWmGkV0gvm91UbCCN
Kq1MiyIr78HmNvOF0Q/XQY+V\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{182, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[685]=",
 CellID->449254694]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["GraphicsGrid family", "Subsection",
 CellID->721792705],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["GraphicsGrid",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GraphicsGrid"], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["g", "TI"], 
          StyleBox["11", "TR"]], ",", 
         SubscriptBox[
          StyleBox["g", "TI"], 
          StyleBox["12", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[TextData[{
     "generates a graphic in which the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["ij", "TI"]]], "InlineFormula"],
     " are laid out in a two-dimensional grid"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["GraphicsColumn",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GraphicsColumn"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["g", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["g", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[TextData[{
     "generates a graphic in which the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " are laid out in a column, with ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " above ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", etc."
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["GraphicsRow",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GraphicsRow"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["g", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["g", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[TextData[{
     "generates a graphic in which the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " are laid out in a row"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->1237732552],

Cell["The GraphicsGrid family of 2D graphics layout functions.", "Caption",
 CellID->2044396622],

Cell["Display elements in a graphics grid.", "MathCaption",
 CellID->170644468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      GraphicsBox[RectangleBox[{0, 0}],
       ImageSize->20], ",", 
      GraphicsBox[DiskBox[{0, 0}],
       ImageSize->20]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      GraphicsBox[DiskBox[{0, 0}],
       ImageSize->20], ",", 
      GraphicsBox[RectangleBox[{0, 0}],
       ImageSize->20]}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[678]:=",
 CellID->464408655],

Cell[BoxData[
 GraphicsBox[{{{}, {}}, {{InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       ImageSize->20], {192., -192.}, ImageScaled[{0.5, 0.5}], {360., 360.}], 
     InsetBox[
      GraphicsBox[DiskBox[{0, 0}],
       ImageSize->20], {576., -192.}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}, {InsetBox[
      GraphicsBox[DiskBox[{0, 0}],
       ImageSize->20], {192., -576.}, ImageScaled[{0.5, 0.5}], {360., 360.}], 
     InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       ImageSize->20], {576., -576.}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}}, {{}, 
    StyleBox[{{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}},
     Antialiasing->False]}},
  ImageSize->{118.66666666666649`, Automatic},
  PlotRange->{{0, 768.}, {0, -768.}},
  PlotRangePadding->{5, 5}]], "Output",
 ImageSize->{123, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[678]=",
 CellID->2021127198]
}, Open  ]],

Cell["Display elements in a graphics column.", "MathCaption",
 CellID->1130904931],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsColumn", "[", 
  RowBox[{"{", 
   RowBox[{
    GraphicsBox[RectangleBox[{0, 0}],
     ImageSize->20], ",", 
    GraphicsBox[DiskBox[{0, 0}],
     ImageSize->20], ",", 
    GraphicsBox[RectangleBox[{0, 0}],
     ImageSize->20]}], "}"}], "]"}]], "Input",
 CellLabel->"In[689]:=",
 CellID->480907568],

Cell[BoxData[
 GraphicsBox[{{{}, {}, {}}, {InsetBox[
     GraphicsBox[RectangleBox[{0, 0}],
      ImageSize->20], {9., -193.5}, ImageScaled[{0, 0.5}], {360., 360.}], 
    InsetBox[
     GraphicsBox[DiskBox[{0, 0}],
      ImageSize->20], {9., -580.5}, ImageScaled[{0, 0.5}], {360., 360.}], 
    InsetBox[
     GraphicsBox[RectangleBox[{0, 0}],
      ImageSize->20], {9., -967.5}, 
     ImageScaled[{0, 0.5}], {360., 360.}]}, {{}, 
    StyleBox[{{{}, {}, {}}, {{}, {}, {}}, {}, {}, {}, {}},
     Antialiasing->False]}},
  ImageSize->{62.472530600626115`, Automatic},
  PlotRange->{{0, 378.}, {0, -1161.}},
  PlotRangePadding->{5, 5}]], "Output",
 ImageSize->{67, 189},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[689]=",
 CellID->1709459933]
}, Open  ]],

Cell["Display elements in a graphics row.", "MathCaption",
 CellID->1888899367],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsRow", "[", 
  RowBox[{"{", 
   RowBox[{
    GraphicsBox[RectangleBox[{0, 0}],
     ImageSize->20], ",", 
    GraphicsBox[DiskBox[{0, 0}],
     ImageSize->20], ",", 
    GraphicsBox[RectangleBox[{0, 0}],
     ImageSize->20]}], "}"}], "]"}]], "Input",
 CellLabel->"In[691]:=",
 CellID->1856864365],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[RectangleBox[{0, 0}],
      ImageSize->20], {13.5, -189.}, ImageScaled[{0, 0.5}], {360., 360.}], 
    InsetBox[
     GraphicsBox[DiskBox[{0, 0}],
      ImageSize->20], {400.5, -189.}, ImageScaled[{0, 0.5}], {360., 360.}], 
    InsetBox[
     GraphicsBox[RectangleBox[{0, 0}],
      ImageSize->20], {787.5, -189.}, 
     ImageScaled[{0, 0.5}], {360., 360.}]}, {{}, 
    StyleBox[{{}, {}, {}, {}, {{}, {}, {}}, {{}, {}, {}}},
     Antialiasing->False]}},
  ImageSize->{203.33333333333331`, Automatic},
  PlotRange->{{0, 1161.}, {0, -378.}},
  PlotRangePadding->{5, 5}]], "Output",
 ImageSize->{207, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[691]=",
 CellID->974882228]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Embedded constructs family", "Subsection",
 CellID->34871032],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Item",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Item"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      StyleBox["options", "TI"]}], "]"}], Cell[TextData[{
     "displays with ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " as the content, and with the specified options applied to the region \
containing ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    ButtonBox["SpanFromLeft",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SpanFromLeft"], Cell["\<\
indicates that the position is occupied by the contents on the left\
\>", "TableText"]},
   {
    ButtonBox["SpanFromAbove",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SpanFromAbove"], Cell["\<\
indicates that the position is occupied by the contents above\
\>", "TableText"]},
   {
    ButtonBox["SpanFromBoth",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SpanFromBoth"], Cell["\<\
indicates that the position is occupied from both above and left\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellID->1108212702],

Cell["\<\
Constructs with special meaning when they are embedded as elements within the \
Grid and GraphicsGrid families.\
\>", "Caption",
 CellID->605212083],

Cell["Embed styling information around the element \"a\".", "MathCaption",
 CellID->1692863033],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Item", "[", 
       RowBox[{"\"\<a\>\"", ",", " ", 
        RowBox[{"Background", " ", "->", " ", "Red"}], ",", " ", 
        RowBox[{"Frame", " ", "->", " ", "True"}]}], "]"}], ",", " ", 
      "\"\<b\>\"", ",", " ", "\"\<c\>\""}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<d\>\"", ",", " ", "\"\<e\>\"", ",", " ", "\"\<f\>\""}], 
     "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<g\>\"", ",", " ", "\"\<h\>\"", ",", " ", "\"\<i\>\""}], 
     "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[708]:=",
 CellID->391961076],

Cell[BoxData[
 TagBox[GridBox[{
    {
     ItemBox["\<\"a\"\>",
      Background->RGBColor[1, 0, 0],
      Frame->True,
      StripOnInput->False], "\<\"b\"\>", "\<\"c\"\>"},
    {"\<\"d\"\>", "\<\"e\"\>", "\<\"f\"\>"},
    {"\<\"g\"\>", "\<\"h\"\>", "\<\"i\"\>"}
   }],
  "Grid"]], "Output",
 ImageSize->{47, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[708]=",
 CellID->447956663]
}, Open  ]],

Cell["Span \"a\" across the first two columns.", "MathCaption",
 CellID->2085640175],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<a\>\"", ",", " ", "SpanFromLeft", ",", " ", "\"\<c\>\""}], 
      "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<d\>\"", ",", " ", "\"\<e\>\"", ",", " ", "\"\<f\>\""}], 
      "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<g\>\"", ",", " ", "\"\<h\>\"", ",", " ", "\"\<i\>\""}], 
      "}"}]}], "}"}], ",", " ", 
   RowBox[{"Frame", " ", "->", " ", "All"}]}], "]"}]], "Input",
 CellLabel->"In[709]:=",
 CellID->1357458983],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"a\"\>", "\[SpanFromLeft]", "\<\"c\"\>"},
    {"\<\"d\"\>", "\<\"e\"\>", "\<\"f\"\>"},
    {"\<\"g\"\>", "\<\"h\"\>", "\<\"i\"\>"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{53, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[709]=",
 CellID->1877452306]
}, Open  ]],

Cell["Span \"a\" across the first two rows.", "MathCaption",
 CellID->2126334891],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<a\>\"", ",", " ", "\"\<b\>\"", ",", " ", "\"\<c\>\""}], 
      "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"SpanFromAbove", ",", " ", "\"\<e\>\"", ",", " ", "\"\<f\>\""}],
       "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<g\>\"", ",", " ", "\"\<h\>\"", ",", " ", "\"\<i\>\""}], 
      "}"}]}], "}"}], ",", " ", 
   RowBox[{"Frame", " ", "->", " ", "All"}]}], "]"}]], "Input",
 CellLabel->"In[710]:=",
 CellID->2094345200],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"a\"\>", "\<\"b\"\>", "\<\"c\"\>"},
    {"\[SpanFromAbove]", "\<\"e\"\>", "\<\"f\"\>"},
    {"\<\"g\"\>", "\<\"h\"\>", "\<\"i\"\>"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{53, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[710]=",
 CellID->1363681571]
}, Open  ]],

Cell["Span \"a\" across the first two columns and rows.", "MathCaption",
 CellID->1035143310],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<a\>\"", ",", " ", "SpanFromLeft", ",", " ", "\"\<c\>\""}], 
      "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
      "SpanFromAbove", ",", " ", "SpanFromBoth", ",", " ", "\"\<f\>\""}], 
      "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<g\>\"", ",", " ", "\"\<h\>\"", ",", " ", "\"\<i\>\""}], 
      "}"}]}], "}"}], ",", " ", 
   RowBox[{"Frame", " ", "->", " ", "All"}]}], "]"}]], "Input",
 CellLabel->"In[711]:=",
 CellID->255318423],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"a\"\>", "\[SpanFromLeft]", "\<\"c\"\>"},
    {"\[SpanFromAbove]", "\[SpanFromBoth]", "\<\"f\"\>"},
    {"\<\"g\"\>", "\<\"h\"\>", "\<\"i\"\>"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{53, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[711]=",
 CellID->1450683013]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Classes of Functionality", "Section",
 CellID->1329116983],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " and related constructs allow considerable appearance customization, often \
with very little syntax. The tables below indicate the kind of functionality \
that is supported; it is explained in detail in later sections."
}], "Reference",
 CellID->2045043897],

Cell[CellGroupData[{

Cell["\<\
Frames and dividers can be placed in any position to partition regions of the \
grid.\
\>", "BulletedText",
 CellID->888586823],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXM1Kw0AQ3tpWQaqiBxG81NaL9eekCIqKCPZUBQ8Wj7EI7UHU2pseeir4
Ar6c+Cxx0z/TIUmzSTY7ux2hm842nZmdb3aS+aipWZ3m07PVaTWsYrVtvTZb
jffi9UubT2UzjM2tMMauNhh/b/N3/dfob5W//sWB9MbHbLfbLfHjJT+5PJR7
w+NX/6xvZ8yOdbFlIC9NkQtAdobjvuZNPp7zD84StlDlwxoXf8dW3J+eAHnd
FYUkvdga6i1P0Xs7EW2zvD0Fcs75NhcXwHw24vw8mK9O8f4nkteONZZ37ybm
YXtO+ll5Kav1yyisq/bL1Gm5VQDHXTsok3M+3xodoe+mRDGOv4sCs5Wh/UOg
+c4TDW+vROx5z8Ko6Lrz00LNAhoJLcxo1W2xinhgq0STKmi0CrqTkr19G2N2
yL6jJJT9Vyu/oifRCapA7T4lO2ajJXpHX1ca9Tgdg5t9CduBq60IWHkJXFGR
vUOgvk87iTs+1avoAdm7y8CageE6WrO8x8bzRcsgXftJ0evkY6joEAMmbkN/
BoxQNAFFXSsZMWOEpni8ZqPbpspMzJl/tIkfnQWUiXGL06GkzWN8KI1OEMNA
fKMfpqJ8Sb/+COwYkxg3PbzEkinEC6bPC+Jgxqh/C57F9asi6rNMYMAIxWgo
JnM/Q8zY5FnEjEXTS1lAWUAVXw5as8WcYeNHo/63ilq0iHELio5qfgTX6oP4
xgsub9syGTTVvEkFyCU7SR5FdiZB7x+09LrGhyMu7oXy1qyM0Xs1ca8z2HlG
qC/c/qJ+KhiFtO6coR+40KM+KF78xCoVoaoXqsRvmlyJb1KyS3wnZQW2rKAr
RDJXCL0YNt15TagXBwrYmIz0K5is57LhXbXf0/CS4StH9gZP3mOZP3o1v10=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{527, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->115730928]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
The grid and its contents can be aligned and positioned in a number of ways.\
\>", "BulletedText",
 CellID->877452923],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {"1"},
        {"2"},
        {"6"},
        {"24"},
        {"120"}
       },
       GridBoxAlignment->{"Columns" -> {{Right}}},
       GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
      "Column"], 
     TagBox[GridBox[{
        {"1.234`"},
        {"12.34`"},
        {"123.4`"},
        {"1234.`"}
       },
       GridBoxAlignment->{"Columns" -> {{"."}}, "Rows" -> {{"."}}},
       GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
      "Grid"], 
     TagBox[GridBox[{
        {"\<\"first\"\>", "1"},
        {"\<\"second\"\>", "100"},
        {"\<\"last\"\>", "1000"}
       },
       GridBoxAlignment->{"Columns" -> {Right, Left}},
       GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
      "Grid"], 
     RowBox[{"{", 
      RowBox[{
       TagBox[GridBox[{
          {"a", "b"},
          {"c", "d"}
         },
         BaselinePosition->{2, 2},
         GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
        "Grid"], ",", 
       TagBox[GridBox[{
          {"a", "b"},
          {"c", "d"}
         },
         BaselinePosition->{1, 1},
         GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
        "Grid"]}], "}"}]}
   },
   ColumnsEqual->False,
   FrameStyle->Directive[
     Dashing[2], 
     GrayLevel[0.5], 
     Thickness[3]],
   GridBoxAlignment->{"Rows" -> {{Top}}},
   GridBoxDividers->{"Columns" -> {
       GrayLevel[1], {
        GrayLevel[0.5]}, 
       GrayLevel[1]}, "Rows" -> {{None}}},
   GridBoxFrame->{"ColumnsIndexed" -> {{{1, -1}, {1, -1}} -> GrayLevel[1]}},
   GridBoxItemSize->{"Columns" -> {6, 8, 8, 9}},
   GridBoxSpacings->{"Columns" -> {{3}}, "Rows" -> {{2}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{544, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->1287429333]
}, Open  ]],

Cell[CellGroupData[{

Cell["Backgrounds and styles can be imposed on any region.", "BulletedText",
 CellID->581072912],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW81OwkAQXijKTwjEmxcTjoB48xXUcPBgIkoiF0JM4GBU5GiEkwlP41Ff
xmepsz/9cdm220JLKUOA6c4y29lvd3a/2er1cDZ+fBrOJqNh42o6fBlPRm+N
y+cpqIwcIfk6IeTimMC1CVfsY72O4OMUVaVX+DYWi8WnJNtUQlM1IauSPPO1
btHaA7cnRNiuaishtB27B1/0yrDriSGVyzt4Ly80m3ty/ySx1rkXtQ8/94PQ
6vtaqyPngckGfJ+D7IKsgqxDsNdBVkD2hO5D+DjQtvi1f5kHyfuplrT+xO1n
gTknXiUoFAjvaonwSkPSGyBb/i14YN4RVkvbWwCWWZnCM44xL9OWOIq2is0H
T+2hpJV7umJVNHlvWM2/qiIRroWwycu4qG3XnvuniaPYTQi9XoyofSNaqUQL
IxRRTAuKWYhcykyCOb8uU2CIRGIIPbWlh1d9ZV82lWtYDModJTKTakl1N2ay
vHmXfPRjou977MsujF0cPvrnWJsYqb7dUvpXLSfPw10/+q5vnV0NEE3kUAr0
spH9IFph0MIIRRR1UUwTT/ixvdI/x43K1fSe+axzh3ifC6WR16fJl33NMTbp
Y5rWhvsE+41sJlh7FzAewbku7t/R92+9566I8nooBz2fxnUiWGudsyd3PpEF
1DBXXAe9aFlOev7aI1z2E0OeNJ+Tpku3jKEVT6+FFeUXdH7VhKxKUvPMXLTG
Y9V0zROTWLmYrK2E0Ebk8xIyTSvORbuGVC5v0M9tRAJ012kBCtYvq5I0toRJ
5nYkwJi/mQ1ItU0lhJa2f4tjgmMS45hsnYvENEZZXNP2fazY+Ybpx0twBdND
PGgFS+4sIyuIqtmuc26xKxywLWKKnx1YXeH/y0Nyf8qccuA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{527, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->193492714]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
The structure can be elaborated using spanning elements, or elements that are \
themselves grids.\
\>", "BulletedText",
 CellID->1484289075],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXMtu1DAUdZMJRbQwtKoQYoGmILFH4ik2tAUKiwKLIrEdVSO1CwS0/YBZ
VeIH2CC+1dhxMnUvN5k4iV+xR5pkruVxnHOujx/XycH0/Hj2bXp+cjSd7J9O
fxyfHJ1N3n0/ZUnpCiHJmBCyd5ew35T9yr/lZ4N9L01h/WTHdD6fP2DnHZb5
YWFfFOdfea7f/JguyiK3gH1zib0ObH54npd8r7juK61X6LPkLQmxPsvdRpGP
tZftl8Ae8asxcxWkpy3Tr4F0ftDjRfBOeA1IJrdWgtQn0Z4ra4xAidl1pNw2
6ZCTKk91FalmLQAvaxVNTcF/sx5zjQaC9m12nrHkDS9R90UFngD7BbAfAfsP
jSx0zxUWCz4rkAorY+qjUlWxo3sEVoUyx+kxwsow0IaK1HW0CZUjUSwflgfr
30x5dI8Yh4lanzM+eYaPtSidd1ffEl2f19pHS8cqyTIPb6vuUMXteL5pPdA/
UoG9nX1FsdHW3MN52NpmCe+RnGubGXCUpBd102uNjqrLf7mgt0DcYL3NaLur
s8SwWI1rwldzOa6wnb3Az9n1UL2o19F6oL4xlH6l1XwUrZuK5zTrJSL3arns
cI9j2K7GsIYfqPCfT9Qn/xhSv7FYOzfKe9knPEP//ZEOwRtsRkT8UoEr3iCl
f6Y++YEXUQejvL4HNs5njAZZ4aWh6noVdbKiWnxX3MgIfnL6fcVyzPYWXecL
zaJeqhgYjXJ1njd/ocKvdhcY9OlXUBX7xtLXlaxDYL/Rgr7pVu165GY3ou5Q
G5BZyawpUIybCfsQLcUOJzEi1qzf5uYexRiyFRnTyWQoeuhXBMNlT3BrpO0n
vy5ptRuzxn0qxiubxTnfgR/5tMan+TWsTQxTbzzANcV2MTYUBsMxFjRE9nWv
ubnPLlfthJkwHfotzqvpSFGY/JSrdoSULa56LKVzRW5ChhgtgjHuLWDjnu/b
yqcb84ES86dUqA6/aiaVe+nT4UWXVFYVVZGIsSXzmAcS21CLKEWsNT/nBuN2
SSXGa1SoGXavXcZo60W+MXIHKqrqqObUcMDjDBxvkTFPJjso9jfQ643RVD0z
nTW0FDhKCCC6VMPnV2C/pm5wWaV25jn1Xy/fUtFmcY2M3BqOHDVgjO/u45U/
oG4w5r6y9v0GDJXdqpGP0PnwQ9FU3lhVv7+4r3F1FW59ja+7viVN5Ukh2+sV
y+6p/qk3G7WfMfPvojZ8NewOxfftX1B5r0TJhXiHNFn5B11iDXI=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{527, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->5753551]
}, Open  ]],

Cell[CellGroupData[{

Cell["The sizes and spacings in the grid can be adjusted.", "BulletedText",
 CellID->2077523808],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW71PXEcQX3NwHMenkWWfYx8cthAoUZSLnY9zIiVUCU2Uix0SSpAV6VxE
IY4LulBFihSJkpKSKA1/wpVXUqQgHSUlJeXL7Mzse2+XNw/I28c9HJ/k497b
ndmZ387Ozsyuv1p/1fnhx/VXL56vN758ub7RefH8l8YXP72EV6UbSg1MKqWe
1RT8DuAX/jOfm/AveqSnn+G7tLW19Zvz9/eEvvrXgv5VOj4+3t3d7XQ6amBp
aUmVYZRWqwU/19bWdnZ2jo6ONMVDeP1X4ijEBVgAFXRSVf1Vajab29vbp6en
aoKpZyxpXC7zyGV/f7/RaGgGE8ilVquBCLppLJGL1mIOKWGkdrutiaaREoQ5
OTnRTVVLek3RQApQDITUnW8hBQx8cHCgm0ZS9Z0zqIFwmvA2Uk9NTR0eHuqm
yoX0bRipGbWakYGlHhb1nUFKmBxFn7tICfNF06vKZ/StI0Wv12OKe0ixt7fH
FEOp+s4iNUMVUoPyIHycOl3fGTO/zKWOXMBEWIZBUd/7jr51R9/BwNX3nsEW
JkV3nkUKmDGmKKXqS2h1u10ej6jBvh3qZH1r8HdFz4rFDfS0uG1sbKRy+wOb
wvWu3nKe7zrPNef5Y3yGUaxRV1dXExHwMxpwt0YDw07F2+Vy2VHvWAhr1xUf
HVbShefLnxSRlc46VprnPG9ublqjghQ5zjM4ZGs0GP1S86z9sX4cd96PnPN+
LBV5cN2WVOBp/tP869HUUPiMfc+OXcnQa1TQgzwkb3/K+LlKpcJ+NtlDunN6
9fK3AtvXkNywGXO77Z+LIm9kL3XHXmx5i2cns/iegx1l9mPYn7lf+n5cND1g
VwYTj/SgEEzWo//28wk+Rzs6xV/Rjm7HX668vrzfp/iso3b63EEplpeXuX04
yHPPDWNu3nZvGxvk6DU9BvYlxQMjBcNwy3gelmIkUYqsu+BnZv7Zbm/iqNEu
aOcbWUf7POBVwqHFhNGRs42xIM95ptwOMiVQb3FxUY3g6LBHgblrDzp57jzH
Y+G3cVKAG6Qev+IHzAc4ww8Ir0EhNZ3Ib4r5LGTUSn+9G3LMwmm+MJJUPc+4
XTNwpTPeaMJ5XznnvevVrlbqZL/uyjScoZfrnbPaxz8oNiwTWGfkYiGbAi8H
ywTcnZZBe50PXhNtdV6hVz1Wpi5Qj1rDfuAvuHZSRq8E/qnX66HABcPHt7XX
Ga9JbJcrbwvc/xH2A2viHYu8eFR7KV0TvPLIHB+GdHLtcZ77vx8EVsQ6iv2i
iHWgYDi66/LqY2Wzsum9XKP9HtshelX0GTWWzLnvG2QlZKv4Xq5lr2B7lO2O
66/BMNtNxTXv3b5/uadZ+ShBSi1/jvs3sV+U8xGKYc6XiqKviK7/aCFVyplF
w0IrqoUSWmEt1CtaxVmJFUdr91zmKbYzdCEqYZ36DCpJGU//tEO/mHKG9A22
R1VA0i6sAp7RLo8Vkld8QLrLJ2AmWyW7h3jMwgCy2yvEIGtMWcZ2+ZyubukK
+46la7fbzUFXX/kF6SafJJINR6cpFIVEp2bpUYiv3dKXtkMBe2vhFLRt2jnq
pewBOlOXa5MVZLV4wkk+770fxLMoiKR0IQw+FeMFyOjx3OD/g5d8om3wehyw
ffGCoiwdVh9HC0XL0vW603vuE0tP+Qz9W2QNiwWcZVjKhA1R+8RKAXXz51Pk
k/4/C6JvvrYv3zUwtl+UOmS+OMi3HdJxKOZOKd+i+Dqg1YzzJ1ZlW4m69ivW
IZ3kuxpGJ4qJ5FrqR160ytcO5bsfxg6brC31lyuhdvY1lpPUhLl80yMeY2up
B7G/XHd87GWOXMvzlU3Z0bd8T6RtaSvXAvPRtn+ZNeEi30cxuJScfuNOv0de
cClu9YmycPneSzwLj/ByanaxODUZr9e/5kk4yvduknF0qnmxvT4Zx/7HuP2u
BMo3hJ5ayDoVwVg0+QZZF1mq18u3np5ZyDrVyNheUxRki+slCGn5hlf8ZCRC
3Kl9lsLaZ+ERz6t2XDU4CnfUHiTi6NRVS2FdtTA4+spTiK98m+67IB4VyrXZ
5Kjw+uJCo8v3/lYtXOQqbn9Odv3cbJHvHS4GSXmdXJv9MBGFomSx0zglafci
33H0LZtZF2qrfrL2rLb8dxCrmwiV0iehpOa8c4UZvIctl/k/jerGv52rXY4=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{527, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->161313004],

Cell["\<\
In addition to these styling features, various forms of interactive editing \
and dynamic behavior are possible. \
\>", "Reference",
 CellID->369446055]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Options Syntax", "Section",
 CellID->371443994],

Cell["\<\
All options can accept a single value to be used throughout the entire grid. \
Many options also allow a finer level of granularity, making it possible to \
have, for example, a different background for every column in the grid. The \
current section describes the general syntax for describing option values at \
the row, column, and item level. The subsequent section will describe \
specifics relevant to the different options.\
\>", "Reference",
 CellID->1453167266],

Cell[TextData[{
 "The overall syntax for options such as ",
 Cell[BoxData[
  ButtonBox["Alignment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alignment"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 " is based on forms like ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Background",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Background"], "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["spec", "TI"], 
      StyleBox["x", "TI"]], ",", 
     SubscriptBox[
      StyleBox["spec", "TI"], 
      StyleBox["y", "TI"]]}], "}"}]}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["spec", "TI"], 
   StyleBox["x", "TI"]]], "InlineFormula"],
 " is itself a modular syntax that contains values for different columns, \
while ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["spec", "TI"], 
   StyleBox["y", "TI"]]], "InlineFormula"],
 " contains values for the different rows."
}], "Reference",
 CellID->1913355813],

Cell[BoxData[GridBox[{
   {
    StyleBox["spec", "TI"], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      StyleBox["spec", "TI"]], "InlineFormula"],
     " to all items"
    }], "TableText"]},
   {
    RowBox[{"{", 
     SubscriptBox[
      StyleBox["spec", "TI"], 
      StyleBox["x", "TI"]], "}"}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["x", "TI"]]], "InlineFormula"],
     " at successive horizontal positions"
    }], "TableText"]},
   {
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["x", "TI"]], ",", 
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["y", "TI"]]}], "}"}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"],
     " at successive horizontal and vertical positions"
    }], "TableText"]},
   {
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["x", "TI"]], ",", 
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["y", "TI"]], ",", 
      StyleBox["rules", "TI"]}], "}"}], Cell[TextData[{
     "also allow explicit rules for individual ",
     Cell[BoxData[
      RowBox[{
       StyleBox["i", "TI"], ",", 
       StyleBox["j", "TI"]}]], "InlineFormula"],
     " elements"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->1351018913],

Cell["General options syntax.", "Caption",
 CellID->1230271060],

Cell[TextData[{
 Cell[BoxData[
  SubscriptBox[
   StyleBox["spec", "TI"], 
   StyleBox["x", "TI"]]], "InlineFormula"],
 " (columns), and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["spec", "TI"], 
   StyleBox["y", "TI"]]], "InlineFormula"],
 " (rows) are both syntax than can range from very simple to highly detailed, \
according to two methods described below. The first method is to just give \
rules for the desired value at a set of indices. The second is based on \
giving a sequence of values in a list. "
}], "Text",
 CellID->1193152104],

Cell["\<\
A set of rules specifying the index of a column and its desired background. \
\>", "MathCaption",
 CellID->1282256269],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "2", ",", " ", "3"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"4", ",", " ", "5", ",", " ", "6"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"7", ",", " ", "8", ",", " ", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"Background", " ", "->", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "Red"}], ",", 
        RowBox[{"2", "\[Rule]", "Green"}], ",", 
        RowBox[{"3", "\[Rule]", "Blue"}]}], "}"}], ",", " ", "Automatic"}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->882715438],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "3"},
    {"4", "5", "6"},
    {"7", "8", "9"}
   },
   GridBoxBackground->{
    "ColumnsIndexed" -> {
      1 -> RGBColor[1, 0, 0], 2 -> RGBColor[0, 1, 0], 3 -> RGBColor[0, 0, 1]},
      "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 ImageSize->{41, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->803879320]
}, Open  ]],

Cell["\<\
An equivalent list of background values to use for successive columns.\
\>", "MathCaption",
 CellID->1708041672],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "2", ",", " ", "3"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"4", ",", " ", "5", ",", " ", "6"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"7", ",", " ", "8", ",", " ", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"Background", " ", "->", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Red", ",", " ", "Green", ",", "Blue"}], "}"}], ",", " ", 
      "Automatic"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->742324325],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "3"},
    {"4", "5", "6"},
    {"7", "8", "9"}
   },
   GridBoxBackground->{"Columns" -> {
       RGBColor[1, 0, 0], 
       RGBColor[0, 1, 0], 
       RGBColor[0, 0, 1]}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 ImageSize->{41, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->980107963]
}, Open  ]],

Cell["\<\
These two methods have different strengths, as described below.\
\>", "Reference",
 CellID->1276731036],

Cell[CellGroupData[{

Cell["Using rules", "Subsection",
 CellID->1918055409],

Cell["\<\
Rules provide a direct and readable method to give a specific row or column a \
specific value.\
\>", "Reference",
 CellID->361921228],

Cell["Set the background for specific sets of columns.", "MathCaption",
 CellID->1723097556],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "4", "}"}]}], "]"}], ",", 
   RowBox[{"Background", " ", "->", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "Red"}], ",", 
        RowBox[{"3", "\[Rule]", "Red"}]}], "}"}], ",", " ", "Automatic"}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->1283643897],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x"},
    {"x", "x", "x", "x"},
    {"x", "x", "x", "x"},
    {"x", "x", "x", "x"}
   },
   GridBoxBackground->{
    "ColumnsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}, 
     "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 ImageSize->{56, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->808254961]
}, Open  ]],

Cell["Set the background for specific sets of rows.", "MathCaption",
 CellID->227212960],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "4", "}"}]}], "]"}], ",", 
   RowBox[{"Background", " ", "->", " ", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "Red"}], ",", 
        RowBox[{"3", "\[Rule]", "Red"}]}], "}"}]}], "}"}]}]}], "]"}]], "Input",\

 CellLabel->"In[26]:=",
 CellID->2093483687],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x"},
    {"x", "x", "x", "x"},
    {"x", "x", "x", "x"},
    {"x", "x", "x", "x"}
   },
   GridBoxBackground->{
    "Columns" -> {{Automatic}}, 
     "RowsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}],
  "Grid"]], "Output",
 ImageSize->{56, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->1606122250]
}, Open  ]],

Cell["\<\
When there are a large number of rows or columns, rules are a convenient way \
to set the properties of just a few of them.\
\>", "Reference",
 CellID->477039903],

Cell["\<\
Apply the option at a small number of the possible positions.\
\>", "MathCaption",
 CellID->14841573],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "10", "}"}]}], "]"}], ",", 
   RowBox[{"Background", " ", "->", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "Red"}], ",", 
        RowBox[{"3", "\[Rule]", "Red"}], ",", 
        RowBox[{
         RowBox[{"-", "2"}], "\[Rule]", "Red"}]}], "}"}], ",", "Automatic"}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->1053195470],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWEsOgjAQHWhB/IWtS67hBXRhPERDTGBhNMg5uHJ9bVm4wIBopCUlGd7w
ZpphMpm36FnUxeUq6jIX2bES96LMH9nhVoFiARE1sP2O4Et42hopgRtYCi8F
nlpc9URCHA9bjIEMrOEMxkA2IG/55ffQOoH+a4rUSzdvHFoAuYpxRetHs1Jy
5fDX5O7c9Y+YT2qGZgZtv4lUjZk+E2DUwW978N059udKM5uQk1syRg/cjLg5
n5ntiFcx2yfk5JZMry5exbyKeRWzZkJObsn06uJVzKuYVzFrJuTklozRA3M3
RcETAqc5Ew==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{142, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->870947158]
}, Open  ]],

Cell[TextData[{
 "Rules can also be used to give values to specific grid elements or \
subregions. Note however that while conceptually similar, this following \
syntax is separate from the discussion of ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["spec", "TI"], 
   StyleBox["x", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["spec", "TI"], 
   StyleBox["y", "TI"]]], "InlineFormula"],
 "."
}], "Reference",
 CellID->334214359],

Cell[TextData[{
 "Set the background of the ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"3", ",", "3"}], "}"}]], "InlineFormula"],
 " element."
}], "MathCaption",
 CellID->169044342],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "10", "}"}]}], "]"}], ",", 
   RowBox[{"Background", " ", "->", " ", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic", ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "Red"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->542294354],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAw9AGxpQQDkP0fyALj
vv//gTQyyQQUZgKyQDQnlB4sfEawCxlYIdR/MAAyGLhBNAuy0GATYYKELdQf
vFSimWlo6hAO5UGUYrGnYMxcByGlgSQ/kE6hiIfPfjYgzQxXA6HZ/kPifHDm
ZHYgxQJigEUhxRZIFCgwGNLaf9S8wwGkWaHhyvEf4kHq5Wzqmj4MQn/IpHRy
8zKukmK0rh6tq0fr6oGsq0dz5oClmf+jOXM0Z2LLdQyMABzifr8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{142, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->745192205]
}, Open  ]],

Cell[TextData[{
 "Set the background of the region from element ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "1"}], "}"}]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"3", ",", "3"}], "}"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->7391013],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "10", "}"}]}], "]"}], ",", 
   RowBox[{"Background", " ", "->", " ", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic", ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "3"}], "}"}]}], "}"}], "\[Rule]", "Red"}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->1814187612],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAw9AGxpQQDkP0fyALj
vv//gTQyyQQUZgKyQDQnlB4sfEawCxlYIdR/MAAyGLhBNAuy0GATYYKELdQf
vFSimWlo6hAO5UGUYrGnYMxcByG1gDiFJBbEbAjNSYDP9h8StwOSY0EJCFTk
QBjAuAMSLMhCmCLsQIplMKQnaPjxotEc/yGZhJKcSyuTh3iID4lUTXpuHc3V
gyiNjebq0Vw9mqtHc/Vorh6huRrS5mZgBACTtrp1\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{142, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->99432816]
}, Open  ]],

Cell["\<\
Rules are an efficient way to specify the exceptions to the value that \
otherwise exists. However, they are less efficient when the intention is to \
manually specify a value for each piece of the grid. \
\>", "Reference",
 CellID->1240574307],

Cell["Manually specify an alternating pattern using rules.", "MathCaption",
 CellID->413649026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "10", "}"}]}], "]"}], ",", 
   RowBox[{"Background", " ", "->", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "Red"}], ",", 
        RowBox[{"2", "\[Rule]", "Blue"}], ",", 
        RowBox[{"3", "\[Rule]", "Red"}], ",", 
        RowBox[{"4", "\[Rule]", "Blue"}], ",", 
        RowBox[{"5", "\[Rule]", "Red"}], ",", 
        RowBox[{"6", "\[Rule]", "Blue"}], ",", 
        RowBox[{"7", "\[Rule]", "Red"}], ",", 
        RowBox[{"8", "\[Rule]", "Blue"}], ",", 
        RowBox[{"9", "\[Rule]", "Red"}], ",", 
        RowBox[{"10", "\[Rule]", "Blue"}]}], "}"}], ",", "Automatic"}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[31]:=",
 CellID->2034987855],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmE0OgjAQhUt/gBgTti65hhfQlYdoiAksjAY5B1curz+LrowL0ZHMorzp
8ICU6XyLXuzUX292Gjrbnkf76Ifu2Z7uI1KqEELMGMeDQOwQhTE7B91jNJg1
L3QXnnjfKfF6mbSEKmRDLmkJVYR9RfxDxl9CGANRQbWf6fxGBdE+0LmZrlfG
GqX111CT1l1DzYp59eMvb7yiX+6SdbpuDR6xk6lNsW+Z2kxtqt3E1P4PJ9V9
wdTOetwxtSlXialNm3Hbc1LdF0ztrMcdU5tylZjan+NRPAsWxQLSeS30\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{142, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]=",
 CellID->191615694]
}, Open  ]],

Cell["\<\
To achieve repetitive patterns, it is instead recommended to use the list \
syntax described in the next section. \
\>", "Reference",
 CellID->794614643]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using lists", "Subsection",
 CellID->136845998],

Cell["\<\
Giving sequential values in a list is a compact and convenient way to specify \
large numbers of option values for adjacent rows or columns.\
\>", "Reference",
 CellID->1908025176],

Cell["List the values to be used for successive columns.", "MathCaption",
 CellID->928512228],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", " ", 
     RowBox[{"{", "4", "}"}], ",", " ", 
     RowBox[{"{", "10", "}"}]}], "]"}], ",", " ", 
   RowBox[{"Background", " ", "->", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "Red", ",", "Green", ",", "Blue", ",", "Orange", ",", "Yellow"}], 
       "}"}], ",", " ", "Automatic"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[52]:=",
 CellID->1888836894],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmEEOgjAQRQfaQo0ati65hhfAlYcgxkQXRqMegBNw5fHTmUR3JmqUmi7a
Vz5MCzOZv2DdXnfbQ3vdb9p6dW5Pu/3mUjfHMySTEVGPsVwQ1oxVGD0zOMOo
IFRQKu6ogtg8uZMjPFcWoMFTQVMWoEGUaMICNNhFYjuN7ciwxioLEBqrFjh5
8zoLb01umMLHy4JK0FKYHvQSsCTTXS4Bi/cNKjgshx06sqw7gCw7AHY4U1SW
46cfUnKpgebfg07z7kGn+fag0zx70Gl+Peg0L/MnNF8+6c8qFGWXvOIHcd6J
sz5/1iPJxcZeoSi75PfuklwsuVhysdFUKMou+b27JBdLLpZcbDQVirJLXvED
+TdF2Q0PZDi5\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{142, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[52]=",
 CellID->854084220]
}, Open  ]],

Cell["\<\
Additionally, sublists can be used to denote cyclic use of values. \
\>", "Reference",
 CellID->1953316028],

Cell["Specify that the list should be used cyclically.", "MathCaption",
 CellID->1857006039],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", " ", 
     RowBox[{"{", "4", "}"}], ",", " ", 
     RowBox[{"{", "10", "}"}]}], "]"}], ",", " ", 
   RowBox[{"Background", " ", "->", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"Red", ",", "Green"}], "}"}], "}"}], ",", " ", "Automatic"}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[53]:=",
 CellID->1320655622],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmE0OgkAMhQsz/MSYsHXJNbyArjzEhJjAwmiQc3Dl+phhMSt1IbGQLjqv
aR4hQ9tvwcUN7fXmhq5x9bl3j7ZrnvXp3qNkEiIaEccDIWdkPkZm6B5RoVC9
0Z1/4HtnOgUHzaEGVV+bNYcalusLH4kyf055SKiAWvJHVC8gdspsbJbrTUOP
5vuX0Gy+dwnNFqybP7954x39MNXr2LoleKROpbbEvVVqK7WlbpNSex1OqXOh
1I52nJXakruk1JbNuO05pc6FUjvacVZqS+6SUvt3PAr/gil5AdOULfQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{142, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[53]=",
 CellID->348386497]
}, Open  ]],

Cell["These cyclic sublists can be padded at the beginning or end.", \
"Reference",
 CellID->799970907],

Cell["Give an initial set of values before the cyclic portion.", "MathCaption",
 CellID->894893885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", " ", 
     RowBox[{"{", "4", "}"}], ",", " ", 
     RowBox[{"{", "10", "}"}]}], "]"}], ",", " ", 
   RowBox[{"Background", " ", "->", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Blue", ",", "Orange", ",", 
        RowBox[{"{", 
         RowBox[{"Red", ",", "Green"}], "}"}]}], "}"}], ",", " ", 
      "Automatic"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[58]:=",
 CellID->1653545254],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWEsKgzAQHY2moRTcduk1eoF21UMEKeiitFgP4Am88vTlU3DRRRcVcQgY
3/DyRmUm8xZe7dDe7nboGltfevtsu+ZVnx89KJUR0YR1OhJiRuTXxAw8IKp4
pApxhY1vuPcJvyvzsNihBipkeS6iBiqOuogaqJAdcgNq4Bq6UCQqQ6H83Qc7
YIFvp8KRo7scCyjcfjGTgnUEB3b2BF5dm3965PtjgGXsiwGWsS6GXQFCPQzw
H7xa+c3iOypg6pbwo6RMri1mxpNrS+uogKnbisfJU8o4P+JnPLm2tI4KmLqt
eJw8pYzzI37Gk2tL66iAqVvCj8K/YMre3dhhdA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{142, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[58]=",
 CellID->420381488]
}, Open  ]],

Cell["Give a final set of values.", "MathCaption",
 CellID->1863403729],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", " ", 
     RowBox[{"{", "4", "}"}], ",", " ", 
     RowBox[{"{", "10", "}"}]}], "]"}], ",", " ", 
   RowBox[{"Background", " ", "->", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Red", ",", "Green"}], "}"}], ",", "Blue", ",", "Orange"}], 
       "}"}], ",", " ", "Automatic"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[57]:=",
 CellID->1472449102],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmEEOgjAQRQdKgRgTti65hhfQlYdoiAksjAY5ACfgyvXTaSIbFyZoSTOL
9k2GD7RT5i+4mKG93szQNaY+9+bRds2zPt17pFRCRBPG8UCILSI3JmvBPUaF
RPWJUO7sSN8o03lYZg4qXHU5zxxUNpAOq+QcMwcVVs33MhO3C9JzmVyxOKAC
zMhNi3wBZHOULcUBtMTTO10A2bwX94SReFspn5GvUwlqX58S1GvlfX1LUPu6
qsBvjvxEKUA3rd51v/AjUYprR9LjwbxTXFtcW1x7e8o4vp/IezyYd4pri2uL
a29PGcf3E3mPB/NOcW1x7f+6Nv8LpuQFXI9hdA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{142, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[57]=",
 CellID->600125041]
}, Open  ]],

Cell["Use defaults in the middle.", "MathCaption",
 CellID->649762780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", " ", 
     RowBox[{"{", "4", "}"}], ",", " ", 
     RowBox[{"{", "10", "}"}]}], "]"}], ",", " ", 
   RowBox[{"Background", " ", "->", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Green", ",", 
        RowBox[{"{", "}"}], ",", "Blue", ",", "Orange"}], "}"}], ",", " ", 
      "Automatic"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[60]:=",
 CellID->608698465],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmEsOgjAQhgdaHr7i1iXX8AK68hANMYGF0SAH4ARcuf6dduHCBS7ElpSk
+aZDE/55dBZcVN9cb6pva1WdO/Vo2vpZne4dXCIhohHreCDYGhavUWtwi00L
aw/PWg/0yZPy0swcFHjLPsfVj/c5KKDG6rDMQQF19pxlwmop4/g4SmsUoDTR
SuPlB8ZmRk8BSCNHvisrAGk089mBrPzU5dzmuwQzl4fdlyzBzOWrBDOXJzHT
F5ZSiZC6f8p9/q8nrHwupYfjNPGlEiF1v2+zI04TP3o4ThNfKhFS9/s2O+I0
8aOH4zTxpRIhdf+U+2z/cVDyAhMYI84=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{142, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[60]=",
 CellID->25078377]
}, Open  ]],

Cell["\<\
Because positions in the list correspond to positions in the grid, specifying \
a single value in the middle requires giving all previous values. To achieve \
this more directly, use rules as described in the above section.\
\>", "Reference",
 CellID->588090713],

Cell["Make the fifth column red using the list syntax.", "MathCaption",
 CellID->802370369],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", " ", 
     RowBox[{"{", "4", "}"}], ",", " ", 
     RowBox[{"{", "10", "}"}]}], "]"}], ",", " ", 
   RowBox[{"Background", " ", "->", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "Automatic", ",", "Automatic", ",", "Automatic", ",", "Automatic", ",",
         "Red"}], "}"}], ",", " ", "Automatic"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[61]:=",
 CellID->1321899840],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmEEOgjAQRQdaEGOMW5dcgwvgykM0xAQWRoOcgyuX3xaNC8VqorFkSMqb
mTQT+jP8Rfeqqw9H1TWVynetOtdNdcnLU4uSiIioxyq2hFgjsqvXGizw3oDl
gyzGthiR4XKkb56C4tbDMQXFm31e5ZH9UkoctH0Q0MpQ3pd8KgtAmkA6lWwr
VFH4qJ9PJXZaj+dZP2EGJqOOmXYHntp/pfhB9xmoH8ykT/2v38/C0WkGM6nZ
EdgR2BHYEdgR/kL9YCadHYEdgR2BHcHPEdw9AEUDDO/WZw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{142, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[61]=",
 CellID->209080339]
}, Open  ]],

Cell["Use a rule to directly assign the background.", "MathCaption",
 CellID->1916389725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", " ", 
     RowBox[{"{", "4", "}"}], ",", " ", 
     RowBox[{"{", "10", "}"}]}], "]"}], ",", " ", 
   RowBox[{"Background", " ", "->", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"5", "\[Rule]", "Red"}], "}"}], ",", " ", "Automatic"}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[62]:=",
 CellID->1101149882],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmEEOgjAQRQdaEGOMW5dcgwvgykM0xAQWRoOcgyuX3xaNC8VqorFkSMqb
mTQT+jP8Rfeqqw9H1TWVynetOtdNdcnLU4uSiIioxyq2hFgjsqvXGizw3oDl
gyzGthiR4XKkb56C4tbDMQXFm31e5ZH9UkoctH0Q0MpQ3pd8KgtAmkA6lWwr
VFH4qJ9PJXZaj+dZP2EGJqOOmXYHntp/pfhB9xmoH8ykT/2v38/C0WkGM6nZ
EdgR2BHYEdgR/kL9YCadHYEdgR2BHcHPEdw9AEUDDO/WZw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{142, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[62]=",
 CellID->671565046]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using both", "Subsection",
 CellID->2078971978],

Cell["\<\
It is possible to have the best of both worlds, using the list syntax for \
specifying repetitive portions of the grid while also using the rule syntax \
to specify exceptions.\
\>", "Reference",
 CellID->1881384116],

Cell["\<\
Columns alternate between blue and green, except the first and last which are \
red.\
\>", "MathCaption",
 CellID->564356657],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", " ", 
     RowBox[{"{", "4", "}"}], ",", " ", 
     RowBox[{"{", "10", "}"}]}], "]"}], ",", " ", 
   RowBox[{"Background", " ", "->", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"Blue", ",", "Green"}], "}"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "\[Rule]", "Red"}], ",", 
          RowBox[{
           RowBox[{"-", "1"}], "\[Rule]", "Red"}]}], "}"}]}], "}"}], ",", 
      "Automatic"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[746]:=",
 CellID->105116242],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWEsKgzAUfBp/lILbLr1GL9CueoggBV2UFus5vPLr5FNqF10UFPUR4WXC
OBCTl5mFF90315vu21pX504/mrZ+Vqd7B0pFRDSgjgfCnDGzNTAD96gSRAnm
F+6M/g9lbIodZkCFt5bzmAEV1I5zmAEX0/H3N0d2F5Q6YHdeeHJgQnYY8Tkg
ITd86BywCq2ZJONtxPwezV4LYOrPpwCm/lwK4GS8X0stvLLwjpIE182RR0EZ
UnsFvp3C4yG1pXWUJLhuKxknTynj/gj3eEhtaR0lCa7bSsbJU8q4P8I9HlJb
WkdJguvmyCP3L5iiFwVHLfQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{142, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[746]=",
 CellID->383952544]
}, Open  ]],

Cell["Use blue for all columns, except the first and fifth.", "MathCaption",
 CellID->1854549047],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", " ", 
     RowBox[{"{", "4", "}"}], ",", " ", 
     RowBox[{"{", "10", "}"}]}], "]"}], ",", " ", 
   RowBox[{"Background", " ", "->", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Blue", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "\[Rule]", "Red"}], ",", 
          RowBox[{"5", "\[Rule]", "Red"}]}], "}"}]}], "}"}], ",", 
      "Automatic"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[89]:=",
 CellID->828180371],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAw9AGxpQQDkP0fyALj
vv//gTQPEOsCefxA2g0sgynCBFTOBKXZgDQzUBQsBqU5CfDZgDQzFcwhxGeE
+IwVRICZEAYDO5BmAfFYkCW4iRBhB1IsIAYLsoHkm0eMCBMkzKHhxAGkWaH+
40WjOYA0KxHq0GlmOtkwTGKCwlRL39RPTH4eWJGhFZ7DJA2PliaDJSYoTLWj
pcloaTLgaXi0NBksMUFhqh0tTUZLkwFPw6OlyWCJCQpT7eArTSBjHAyMAPB3
5SA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{142, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[89]=",
 CellID->296845443]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     "; then use defaults "
    }], "TableText"]},
   {
    RowBox[{"{", 
     RowBox[{"{", 
      StyleBox["c", "TI"], "}"}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     " in all cases "
    }], "TableText"]},
   {
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["2", "TR"]]}], "}"}], "}"}], Cell[TextData[{
     "alternate between ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}], Cell[TextData[{
     "cycle through all ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"{", 
     RowBox[{
      StyleBox["s", "TI"], ",", 
      RowBox[{"{", 
       StyleBox["c", "TI"], "}"}]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     ", then repeatedly use ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]], ",", 
      RowBox[{"{", 
       StyleBox["c", "TI"], "}"}], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", then repeatedly use ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     ", but use ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     " at the end "
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["{",
      GridElementStyleOptions -> {ColumnAlignments -> Left}], 
     RowBox[{
      StyleBox[
       SubscriptBox[
        StyleBox["s", "TI"], 
        StyleBox["1", "TR"]],
       GridElementStyleOptions -> {ColumnAlignments -> Left}], 
      StyleBox[",",
       GridElementStyleOptions -> {ColumnAlignments -> Left}], 
      StyleBox[
       SubscriptBox[
        StyleBox["s", "TI"], 
        StyleBox["2", "TR"]],
       GridElementStyleOptions -> {ColumnAlignments -> Left}], 
      StyleBox[",",
       GridElementStyleOptions -> {ColumnAlignments -> Left}], 
      StyleBox["\[Ellipsis]", "TR",
       GridElementStyleOptions -> {ColumnAlignments -> Left}], 
      StyleBox[",",
       GridElementStyleOptions -> {ColumnAlignments -> Left}], 
      RowBox[{
       StyleBox["{",
        GridElementStyleOptions -> {ColumnAlignments -> Left}], 
       RowBox[{
        StyleBox[
         SubscriptBox[
          StyleBox["c", "TI"], 
          StyleBox["1", "TR"]],
         GridElementStyleOptions -> {ColumnAlignments -> Left}], 
        StyleBox[",",
         GridElementStyleOptions -> {ColumnAlignments -> Left}], 
        RowBox[{Cell["", "TableText"], 
         SubscriptBox[
          StyleBox["c", "TI"], 
          StyleBox["2", "TR"]]}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{Cell["", "TableText"], 
       SubscriptBox[
        StyleBox["s", "TI"], 
        StyleBox["m", "TI"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      RowBox[{Cell["", "TableText"], 
       SubscriptBox[
        StyleBox["s", "TI"], 
        StyleBox["n", "TI"]], Cell["}", "TableText"], 
       StyleBox[" ", "TR"]}]}]}], Cell[TextData[{
     "use the first sequence of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at the beginning, then cyclically use the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ", then use the last sequence of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at the end "
    }], "TableText"]},
   {
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      RowBox[{"{", "}"}], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["m", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]}], "}"}], Cell[TextData[{
     "use the first sequence of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at the beginning and the last sequence at the end"
    }], "TableText"]},
   {
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "specify what to use at positions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"{", 
     RowBox[{
      StyleBox["spec", "TI"], ",", 
      StyleBox["rules", "TI"]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      StyleBox["rules", "TI"]], "InlineFormula"],
     " to override specifications in ",
     StyleBox["spec", "TI"],
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->160662587],

Cell[TextData[{
 "Summary of syntax for ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["spec", "TI"], 
   StyleBox["x", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["spec", "TI"], 
   StyleBox["y", "TI"]]], "InlineFormula"],
 "."
}], "Caption",
 CellID->869155430]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Columns, Rows, Gutters, and Items", "Section",
 CellID->318460735],

Cell[TextData[{
 "As introduced in the previous section, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides a flexible language for adjusting the details of a grid's \
formatting. This section provides context for that language and elaborates on \
the finer distinctions."
}], "Text",
 CellID->1486803875],

Cell[BoxData[
 GraphicsBox[{{{}, {}}, {{InsetBox[
      GraphicsBox[
       {EdgeForm[GrayLevel[0]], 
        {GrayLevel[1], RectangleBox[{0, 0}]}}], {280, -280}, 
      ImageScaled[{0.5, 0.5}], {360, 360}], InsetBox[
      GraphicsBox[
       {EdgeForm[GrayLevel[0]], 
        {GrayLevel[1], RectangleBox[{0, 0}]}}], {840, -280}, 
      ImageScaled[{0.5, 0.5}], {360, 360}]}, {InsetBox[
      GraphicsBox[
       {EdgeForm[GrayLevel[0]], 
        {GrayLevel[1], RectangleBox[{0, 0}]}}], {280, -840}, 
      ImageScaled[{0.5, 0.5}], {360, 360}], InsetBox[
      GraphicsBox[
       {EdgeForm[GrayLevel[0]], 
        {GrayLevel[1], RectangleBox[{0, 0}]}}], {840, -840}, 
      ImageScaled[{0.5, 0.5}], {360, 360}]}}, 
   {Dashing[0.02], 
    StyleBox[{{LineBox[{{0, 0}, {0, -560}}], 
       LineBox[{{0, -560}, {0, -1120}}]}, {LineBox[{{560, 0}, {560, -560}}], 
       LineBox[{{560, -560}, {560, -1120}}]}, {
       LineBox[{{1120, 0}, {1120, -560}}], 
       LineBox[{{1120, -560}, {1120, -1120}}]}, {LineBox[{{0, 0}, {560, 0}}], 
       LineBox[{{560, 0}, {1120, 0}}]}, {LineBox[{{0, -560}, {560, -560}}], 
       LineBox[{{560, -560}, {1120, -560}}]}, {
       LineBox[{{0, -1120}, {560, -1120}}], 
       LineBox[{{560, -1120}, {1120, -1120}}]}},
     Antialiasing->False]}, 
   ArrowBox[{{557.9074074074074, -267.03703703703724`}, {
    457.46296296296293`, -267.0370370370371}}], 
   ArrowBox[{{562.0925925925926, -267.03703703703775`}, {
    658.3518518518518, -267.03703703703724`}}], 
   InsetBox[Cell["gutter"], {513.6740462266778, -221.63046505151777`}, {-1., 0.},
     Offset[{40., 57.99999999999999}, {0., 0.}], {{1., 0.}, {0., 
    3.8666666666666667`}}], 
   ArrowBox[{{284.63106796116523`, -54.24271844660245}, {
    10.359223300970768`, -54.24271844660221}}], 
   ArrowBox[{{291.21359223301005`, -54.242718446602225`}, {
    545.7378640776705, -54.24271844660221}}], 
   InsetBox[Cell[
    "item"], {258.30097087378664`, -30.106796116505045`}, {-1., 0.}], 
   InsetBox[Cell[
    "content area"], {146.39805825242738`, -148.59223300970882`}, {-1., 0.}], 
   DiskBox[{284.63106796116523`, -280.24271844660234`}, \
{105.32038834951459`, 92.15533980582524}], 
   InsetBox[Cell[
    "element"], {242.94174757281584`, -389.9514563106801}, {-1., 0.}], 
   ArrowBox[{{269.23728813559336`, 245.33898305084756`}, {269.23728813559336`,
     29.067796610169637`}}], 
   ArrowBox[{{-262.1186440677966, -291.6101694915254}, {-73.81355932203383, \
-289.7457627118643}}], 
   InsetBox[Cell[
    "first column"], {291.6101694915255, 153.98305084745772`}, {-1., 0.}], 
   InsetBox[Cell[
    "first row"], {-236.0169491525424, -353.13559322033905`}, {-1., 0.}]},
  ImageSize->{354.6666666666662, Automatic},
  PlotRange->{{-300, 1120}, {300, -1120}},
  PlotRangePadding->{5, 5}]], "Text",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellID->1851162788],

Cell["Vocabulary for grids.", "Caption",
 CellID->133908131],

Cell[BoxData[GridBox[{
   {"column", Cell["vertical sequence of items", "TableText"]},
   {"row", Cell["horizontal sequence of items", "TableText"]},
   {"item", Cell["the region containing a grid element", "TableText"]},
   {"gutter", Cell[
    "the border between consecutive rows or columns", "TableText"]}
  }]], "DefinitionBox",
 CellID->1226602520],

Cell["Different slices of a 2D grid.", "Caption",
 CellID->1813026087],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["GraphicsGrid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsGrid"]], "InlineFormula"],
 " follow the same conventions for describing the different possible slices \
of the grid. ",
 Cell[BoxData[
  ButtonBox["Column",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Column"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["GraphicsColumn",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsColumn"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["GraphicsRow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsRow"]], "InlineFormula"],
 " follow the same general conventions, except that they only deal in one of \
the two possible dimensions. Finally, ",
 Cell[BoxData[
  ButtonBox["Row",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Row"]], "InlineFormula"],
 " does not participate in this system at all."
}], "Reference",
 CellID->898608130],

Cell[CellGroupData[{

Cell["The world of options", "Subsection",
 CellID->936898809],

Cell["\<\
The following table describes for each option which slices it can address. \
Not all options are valid for all constructs; refer to the key below to see \
which option can occur for a given construct.\
\>", "Reference",
 CellID->957516544],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXVmT3LYRhkiQs4d2V1dUslRytLIk2zpsy/KRuBI7R0mKU/FTjhc9qVyp
sh9SSTn+AfPv8rMYggTIZqPBY4YziwYxtTskmg2w+wO6AfSQwHdvf/7hn/96
+/OP37+99/qnt//54cfv/3vv1b9/KknpJSEuHZX//7slyvNCiPpffY7L//pU
n5UXjkX1SSse9SfeqK/U5CnEe+oLpJ+j9DlKPy6/Ll1QqXn5db1MHqHcJ5p+
FdEzTT9E9CNNP9n6rjB9NpDOBq6vopRRyh4pDzTzLX38nIXUh62UVfqm+sqa
tEqVn8+iLnvWJSm/pCKphKzpmklfqS/VH8WdqxPZ0PTNAKX8PGeju11vipro
o+EWrrRsS9OUHFLqb2lxfsICn9ySOx3AJKMxgZhrPJJAUDCnxkoq5l4UcNup
P5+ywMLUXLqVjSSNUYg+fMB9P2KBDm4Xja7Agxrk0sLym4jblCC7XGzsBtfh
P/hIbfUJf2Mhu+mxryPkv2YhPY/Rd3hS7m7G7FtMAUdC1uqvLH89q9T8S911
a9n9Xfss6ThKw1qa++WXGid96ZVUDxpp6vRnXkn3EEn3wivpkvJLJRNds/Co
6OXod11nUuxqgp1qjuqCbEoy/GnDL556pWklWAblFVpPoIWboktqVOxwSIoD
pGEJ6vRDLshgLicuNMcQLh8xwUEOtgtafwcFIlL+P2GCgq19NWfOoIcwOibC
VVJFzWFJNJoe2ghMC9tnGiSQroS3BZhp/aGvrZlViRw86BWko0TpA5TmYPNX
RnlEvzUzbe2G9l+XdZv6xCsp/RrfLkea8XND32bPMZIQWiShzzKo2NvFWFKU
MkoZpfRXyumRDHXlAHA+Z6HnLuMYFceIudkcI90LRQpzbTKvt0qeI7J3kajM
FOXQJc0xz/DLmkZEO4B1DSPJyIpgWtg+dlzkI2kutDcJwffiCMjvuOtiUb9m
oRGOeGB7+zULLXiMtpYj5QIiKOvyT5W/nlVq9qXuvLVMvmufBczxVNMkC4vS
R+m3kP5R+aWSn7LW4v1G+jr9PGrjjTaJbmHqmKCjoquI0LrOVZ5k9BVRjZTX
eia3bikJcbTzJU0B9Qdxkfc7YI16pWzWpLViCcCwJo2hSJoH1jGiCVe6U8ok
GVeIT3OnSJIs1FrDXGPqDFlhU0sOLHGeHmlG1BqsmSXVlBxjVZrP+KYK+dyu
FdkAV8MoR7UP6HEXbzdWLZhI2bouBeJht18y92aeTjrLXFAdwTRCFNZLW4cS
YZsV1KgBjwLs3pz2WmmBxiJwjKBpIY4DriFU7zjRgWXlKH0WIDLXkY63F4iM
afk3kVZ3i3p8foLox6y15T1/X470u4v1+RYNjZHhGBmO/iFKf7HS/0KPAv7I
Wosb5PjtD1Enz3RqZmDtzLy+SMRqZZciuvNIqY8HgP6ENTY90Y02ZqTRsqMR
0sHniEUMlKhOP1gomqY1YlpuIUnf41mouFmtqLLkvMGxOVGMGY2WhCWrxGP+
aHV0qvzYCvqx1kYnRhSLNtLVwxWm5SJbtCOGMA4oDUHownAJhf3bYCqC6jdA
+hZKfxWedpZ/+hVrHY0vvV2A35XA9ResteM9P1qO9MuNvPFY1Wv/pS5v/fEp
Fhalj9JvI31pg9XY9mPWWjxtpcdphto8Q9o8Ya1NopmkPqq0egjFvRav0FxS
k8wq1mBtY10WzPGANUp4NWPHqtY2hVgBHa/vnFo5JcUB0ng14fOIrf4+mIzl
I/7YdfRFlKK16v5V2NWpvWK9o3yU7z32GEJfVsMAVG7XLl8VwCcie+xgblY1
t1fPTh0tN0CbttqbtaI7pFuow9XhqR7L5GgrpKJKWI7KH1bPcxulJUofoHQA
/s2yoVskFVtQWEiY3WbeKQq9elzduj9grRXv2dlypN9dJMe3WJfyJTHu52tr
uaj1H6M0UZoozS6k2Sz+9FuvdNhVdEidfhWspt/4p9lskZTfeKfbDBEOv1vl
TNEGvz3L3/2TzpqH/9UrGc282S+p/OqDlyNNnJfuV+r9l+rfvLTPAuaI/EQp
o5RRyqVKacY3Zg9l+7fIVIjO3Bmnm9/TOvsq89iDm/pt0PGbK+bSaXzdIDI0
q33OEh96ptSHBU5nBJbJgvFIhT07Vni84IsHEavpe2phIKJgXWHcUkC9S9E+
Bdfoaj17QMUh0iAwUKdnKD0lduKPVth6r7DUyowD8PMgOaGtapHfsNCKxxgs
PCmXG1dZCw4rxu+/VP92r9u1JfXxb7+7QZQ+Sh+lj9JvK73aU6ce9zUrklSX
4f5h+nmKdZ1Z6BzC2vPavTsf3inKzXXGGk1ql6xRu/hNppB30vs8Nd+uklw7
Ag7cs90XK4S6wfu7ZZvXjLW/Vj6u7NEc6vQ0aPSNz+nuO0hQSYpjD8P+8ola
GOYKvybm9FCSqAmMplnNqBaU8F+Y19qbMFy/ZHR27YWL+9QOzs5aoUp37/rY
4ZCQQxUTVn+N0xlKXx7EU6L0O0H7DmyfuYXPMY3Y4C6+YeFmRtlH2mqOtD1l
mg7t+ClrTXnPhpYj/e5ibr5FJXGElkdcef+lLu/JtykWFqWP0m8j/eui/t30
Gmstvm2lr9JnrLX5M9LmlLU28Bd88+xIKrpPmdhvxpln/1b6mIAc41dnWrFG
jnyiY8xbaZMpQ08STk1vv/YT4A+g5sinDTerN+spUIwsvWoPfFJrNbl2DoOu
DeONRr8VOdp2zGnnOeWi9mKbrkoFnnwKsC7m9GiZuTJitbpdrHUVrg+r2rno
9uXUc6Ek0sLlyeDKWLDUbVfKCmsUgNP4yfXLpC3YaF91t9YqjdeZCqsPwLaa
W6gdT8Fx8qpdvNE0Y/ojzXykLU21RQXF9aK7mtcxa215z/CXI/1yn+7lIfX+
S42x4+gfovS7kl6tj6x69y9Ya/Gwlb5K+/SG43RtHiFtfHrfebo28C3w7SLB
vHcz8C8+y3t93lF4zhxDfRYsYuZ0zijnY/ZoXXT0MQAL3VuEMIDeYev4XgD+
aabYHG8klHZUDO5j1lrxniktR/oYg/Nb6v2Xyj8G55LGLz8QpYxSRikvXsq+
mNWh4rV2ADCzlaxoZzXw2M2BKJAPzL93+fvyfFjNEtca82xQb55qkrhqKAWY
VLvKc3D3r7tXdOca3OulNz7m2EGBiFvg51f6Z/79z98tpQ7MKRVxG3xu1NQQ
gQyKLTXMRIw9cOS3iN4ReqNVFAmOpjbm80P4/sA6GfUO02KAWYuBIDWnuNuy
TU9qyiZ6XmKFYWo1zCPGCIN3gSrSKcmF15O8FTX2UmMTD7xWgB4UXD/S108R
HceLb7DQlsccITwpY9zPb6n3X6p/cb+pd/XLYqI0c0pzRzP5tS9atQu6Ne7w
a9c9DjLCGJwUghy1j42qKaL9frIC4J5XOm8US+uNlI15dme4FCzXL1mjlhHa
NfPJBWNlTnEMkMbGEcULDq3BKJKLPrzrZy86FYciWjEnRT33DqdxUR6jb/0x
Ph6ikgIt3TstG/wwzUN/buFygmr5HKX9swHuOpj4yYluMfe9tCK/RtfLkSac
OMZ6Xf6p9e3Wc0rNv9Sdr1Y4+a59FrDvJwSj9FH6baS/Un6p5J9Ya3G1kb5O
v47aeKNNoluYOaqlsNfCfFKVqNeBXreUhDja+ZKmgPqDuMj7vcsayxS1jASg
V2uZYA5EE650p5TqPllDcfJVlBXi09xY1jvhIY/SyQAiEuXpQXkE9lCi8PBW
WEnR2nmFXW7jKhvVayCkGz2HT1pG+5V0+7GseXN/IZ1lLghhgFJWWP1PYfds
dg9F27/J0/SisN/TNN59G8bvjhMHmCtH6YesMciQNrcjBuJu+VXH/7r0c9Za
8p41Lkf63UWYfIvBxXhkjEdG/xClv1jpr+mx7CvWWlwlx20vo06e6WTFJsGs
qoosZHBmZlSFXFXamuFRszOCqzPvy4AsOcl/yhprMoLWG6lpKsCOKNgUkMfB
YUc/sHRjI54dytnCaqXiMghOrBlHbVr3yxZaGybqiaKdDYBjEECI6rxyDG9E
H+nTWw/IHoy/rklm9+J1fReYmc6dwdxCtDHV8RZplxFAfTi8R82M+0qAPYmn
iaDa9WV6XhrpFOZrxwSIg3f/TKINrt8n0cH9xxlKn7DGBGOAf8GLmKw7doWx
UdAcIvpN1trznl0vR/rlxm15PP26/1Lj+7BRGn+luaaZXnklFb1+78so40QZ
rRXlwPuwakLjWCcbri5VsTbpgt7nj+aashL5Bb3F2LtGdAOQbHONeT9xzOp0
HzLHptBvGm7y/qYDU1Dy+16hoxq2NA189Jubk9ZiY4YGsQPGiJ0J0JuphfYl
qwL4DWRFOHcGc/tnR3gvENjSRaNVTuNg6QbXPrSxU7fxy8OS2oPr971u11ha
vA4WL+k762YC+rdeSe3XWHg50oTz9mp9/Q3i31rqWCr7UpW9qK639ISFItfB
QvNR5xlhHYZb6mMCjmY1oKIpIhP6BqIVB8ccN5MeRzYTI3BhPs2tNRdOq9OD
UaX0UGWbdwIlhxRAB5LIWVDCpaSbo2Tlyqhcm+HRRyk/qp/OvcdjRVK3wCAT
qJUoHHCLnQcHaMUJao0C0I+21xzetWlG1Qfdy3gSOu9m9nGs9fxuoLQcyVB/
GsnSVrJDUvcDfR/Yvlol3Xpb6IA7mTrazBIuI66/DCCA2/wxSg/7BIMjTL+7
E9mru1oeA/9WRvp6Kxfm2kxihaY0zUfC+k/1fezeFvamsM/8gsAU8lA4d+yV
6L1xXsV7z8IDe4QESmj187hfTzUGmT5CnUaUqlu6jS1umXQ92t6H9Oq9/ulz
lB4ah205TkD+dshfb3LnzfrojKwHUsaBu11oHeA2NHbUQXu5jdCmRq1JMAjL
wfZUq9jTd4xFFaJC6KQwXY3HFOUc6Tt6+mrss+f0HCYm3Bk9wBxYO6tcOHfr
HXcOy5E1twe1OBJ1clxE9YB4dAqR/nITpKEnEN1eiNbK9Ju0PzgorNFiQfVn
1n2AHuk07EAa97svN0HE0uk2ScX+ix753yD1IPvtnvHZjHoMjhboUTythxnb
4Sjl78fIa42v7iIuaoR2TsrxxiovB223a1XdlpmDNohbD5y52DMgugdKCTQ2
m5eS4xo8Lpo8osGjY7q2eyJIA3c83YnuNtZjvTOO2R3SOtAl5S3a5kRJksyr
55g6HBzFSVfdTtS1aCyttYsrs+lqYqzunsUVE2m5KC1lv26T5hd4hj1XzRKx
nIKaP1qxDmF7Jtpqjf/BfXfbfm0vtht7xXNt/HsTLT/uJbaQhRyX7FUiqzfC
7YqKySgBHsyCgm+/vig4j007LKoIGjgTl/4PNrMRYQ==\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{266, 455},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->112730536],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{309, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->29216796],

Cell[TextData[{
 "Note that ",
 Cell[BoxData[
  ButtonBox["Row",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Row"]], "InlineFormula"],
 " does not take any options."
}], "Reference",
 CellID->1394307527]
}, Open  ]],

Cell[CellGroupData[{

Cell["Columns, then rows", "Subsection",
 CellID->667464371],

Cell["\<\
To remember the syntax for options, the most important step is knowing that \
specific values for the columns are specified first, and values for rows are \
specified second.\
\>", "Reference",
 CellID->927041632],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["opt", "TI"], "->", 
     StyleBox["val", "TI"]}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      StyleBox["val", "TI"]], "InlineFormula"],
     " for all items"
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      RowBox[{
       StyleBox["opt", "TI"], "->", 
       StyleBox["colspec", "TI"]}], ",", 
      StyleBox["rowspec", "TI"]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      StyleBox["colspec", "TI"]], "InlineFormula"],
     " for columns, ",
     Cell[BoxData[
      StyleBox["rowspec", "TI"]], "InlineFormula"],
     " for rows"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["opt", "TI"], "->", 
     RowBox[{"{", 
      StyleBox["colspec", "TI"], "}"}]}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      StyleBox["colspec", "TI"]], "InlineFormula"],
     " for columns, defaults for rows"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->221534826],

Cell[TextData[{
 "Option structure for ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["GraphicsGrid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsGrid"]], "InlineFormula"],
 "."
}], "Caption",
 CellID->1746660331],

Cell[TextData[{
 "To understand and remember this convention it is useful to examine how it \
relates to other precedents in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Reference",
 CellID->199604407],

Cell[TextData[{
 StyleBox["In Mathematica,",
  FontSlant->"Italic"],
 " options with a horizontal setting ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 " and a vertical setting ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " are specified as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["opt", "TI"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["h", "TI"], ",", 
     StyleBox["v", "TI"]}], "}"}]}]], "InlineFormula"],
 ". "
}], "Reference",
 CellID->1833968764],

Cell["\<\
In a grid, these horizontal and vertical settings correspond to values for \
the columns and rows, respectively. This is because columns are stacked \
horizontally, and so their properties\[LongDash]such as width and location\
\[LongDash]correspond to the horizontal dimension. Rows are stacked \
vertically, and their properties correspond to the vertical dimension.\
\>", "Reference",
 CellID->721448903],

Cell["A graphic that is twice as long as it is tall.", "MathCaption",
 CellID->680231157],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"100", ",", "50"}], "}"}]}], ",", 
   RowBox[{"Background", "\[Rule]", "Black"}]}], "]"}]], "Input",
 CellLabel->"In[37]:=",
 CellID->2052432992],

Cell[BoxData[
 GraphicsBox[{},
  Background->GrayLevel[0],
  ImageSize->{100, 50}]], "Output",
 ImageSize->{104, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[37]=",
 CellID->890324114]
}, Open  ]],

Cell["\<\
In the following grid each item is 2 \"ems\" wide and 1 \"ex\" tall.\
\>", "MathCaption",
 CellID->1589602718],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "2", ",", " ", "3"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"4", ",", " ", "5", ",", " ", "6"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"7", ",", " ", "8", ",", " ", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"ItemSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70489711],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "3"},
    {"4", "5", "6"},
    {"7", "8", "9"}
   },
   ColumnsEqual->False,
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{2}}, "Rows" -> {{1}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{110, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2059294423]
}, Open  ]],

Cell["\<\
Instead of a single width for all columns, a separate setting is given for \
each column.\
\>", "MathCaption",
 CellID->1164355293],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "2", ",", " ", "3"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"4", ",", " ", "5", ",", " ", "6"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"7", ",", " ", "8", ",", " ", "9"}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"ItemSize", " ", "->", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "1"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[29]:=",
 CellID->1699926103],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "3"},
    {"4", "5", "6"}
   },
   ColumnsEqual->False,
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {1, 2, 3}, "Rows" -> {{1}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{109, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]=",
 CellID->710304924]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "2", ",", " ", "3"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"4", ",", " ", "5", ",", " ", "6"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"7", ",", " ", "8", ",", " ", "9"}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"ItemSize", " ", "->", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", " ", "2", ",", " ", "3"}], "}"}]}], "}"}]}], ",", 
   " ", 
   RowBox[{"Frame", " ", "->", " ", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1714912309],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "3"},
    {"4", "5", "6"},
    {"7", "8", "9"}
   },
   ColumnsEqual->False,
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{1}}, "Rows" -> {1, 2, 3}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{71, 81},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1153150976]
}, Open  ]],

Cell["\<\
Similarly, a different background color can be given at successive horizontal \
positions.\
\>", "MathCaption",
 CellID->699041759],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "2", ",", " ", "3"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"4", ",", " ", "5", ",", " ", "6"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"7", ",", " ", "8", ",", " ", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"Background", " ", "->", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Red", ",", " ", "Green", ",", " ", "Blue"}], "}"}], ",", " ", 
      "Automatic"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->366228389],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "3"},
    {"4", "5", "6"},
    {"7", "8", "9"}
   },
   GridBoxBackground->{"Columns" -> {
       RGBColor[1, 0, 0], 
       RGBColor[0, 1, 0], 
       RGBColor[0, 0, 1]}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 ImageSize->{41, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->149119681]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Gutters", "Subsection",
 CellID->479682576],

Cell[TextData[{
 "Many ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " options deal with properties that can ultimately be associated with a \
column, row, or item in the grid."
}], "Reference",
 CellID->1368035365],

Cell["\<\
However there are also options that deal with gutters between rows and \
columns.\
\>", "Reference",
 CellID->1610454773],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Dividers",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Dividers"], Cell[
    "where to draw divider lines in the grid", "TableText"]},
   {
    ButtonBox["Spacings",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Spacings"], Cell[
    "horizontal and vertical spacings", "TableText"]}
  }]], "DefinitionBox",
 CellID->29483023],

Cell["Options for the gutters between rows and columns.", "Caption",
 CellID->1599928751],

Cell["\<\
 A line that is not associated with any single row or column.\
\>", "MathCaption",
 CellID->200142416],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", " ", 
     RowBox[{"{", "3", "}"}], ",", " ", 
     RowBox[{"{", "13", "}"}]}], "]"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", 
      RowBox[{"{", 
       RowBox[{"2", "\[Rule]", "True"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[85]:=",
 CellID->1359773970],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAw7AZibQkGIPs/kAXG
u///B9LIJBNQmAnIAtGcUHqo8hnBPmJghVD/wQDIYOAG0SzIQsNDhAkSg1Df
89KYZh4A20ZcXA6i3ESd3IhZ4hBDDiZ/jJZKo6XSaKk0WHITjUslUGSOlk2D
Lh2Olk2jZdPILZsYGAHX6hAY\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{187, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[85]=",
 CellID->94001]
}, Open  ]],

Cell["Compare this with a frame.", "MathCaption",
 CellID->1077774513],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", " ", 
     RowBox[{"{", "3", "}"}], ",", " ", 
     RowBox[{"{", "13", "}"}]}], "]"}], ",", " ", 
   RowBox[{"Frame", " ", "->", " ", 
    RowBox[{"{", 
     RowBox[{"None", ",", " ", 
      RowBox[{"{", 
       RowBox[{"2", " ", "->", " ", "True"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[86]:=",
 CellID->131677546],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwHAViXQkGIPs/kAXG
R///B9KYJCuQZAIqYILSnEOczwb2FZhkAfkbDIAM7mEqwg6m2KG+56UxzTEA
to20uByeORJX+QMqqoCAGREOB4EEI91EYa4cLKFFKZ8Vqy+ZBzRd01OEDav/
Wf7Tp8RiH4S2j/S4Hxk5nJrlI6RMxlli/x++tdRIa2uMthuHg8jIajcyMAIA
VMWB7Q==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{197, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[86]=",
 CellID->98908696]
}, Open  ]],

Cell[TextData[{
 "The syntax for ",
 Cell[BoxData[
  ButtonBox["Dividers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dividers"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Spacings",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Spacings"]], "InlineFormula"],
 " is exactly the same as for the other options. For a grid with ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " items in a particular direction, ",
 Cell[BoxData[
  ButtonBox["Dividers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dividers"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Spacings",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Spacings"]], "InlineFormula"],
 " can specify settings for the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "+1 gaps between elements, starting before the first elements and ending \
after the last element."
}], "Reference",
 CellID->319889223]
}, Open  ]],

Cell[CellGroupData[{

Cell["Items", "Subsection",
 CellID->1766595116],

Cell[TextData[{
 "The most granular level of description is the item. Each item in a grid can \
have its own value for options such as ",
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Alignment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alignment"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Frame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Frame"]], "InlineFormula"],
 "."
}], "Reference",
 CellID->883976926],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 " can be used to explicitly indicate the desired settings."
}], "MathCaption",
 CellID->1561618257],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Item", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Background", "\[Rule]", "Red"}]}], "]"}], ",", "b"}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[100]:=",
 CellID->1322066831],

Cell[BoxData[
 TagBox[GridBox[{
    {
     ItemBox["a",
      Background->RGBColor[1, 0, 0],
      StripOnInput->False], "b"},
    {"c", "d"}
   }],
  "Grid"]], "Output",
 ImageSize->{26, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[100]=",
 CellID->718551404]
}, Open  ]],

Cell[TextData[{
 "Alternatively, use the item's ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["i", "TI"], ",", 
    StyleBox["j", "TI"]}], "}"}]], "InlineFormula"],
 " index to assign it a value at the overall grid level."
}], "MathCaption",
 CellID->1720395412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "Red"}], "}"}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[101]:=",
 CellID->965866276],

Cell[BoxData[
 TagBox[GridBox[{
    {"a", "b"},
    {"c", "d"}
   },
   GridBoxBackground->{
    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}, 
     "ItemsIndexed" -> {{1, 1} -> RGBColor[1, 0, 0]}}],
  "Grid"]], "Output",
 ImageSize->{26, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[101]=",
 CellID->1392899947]
}, Open  ]],

Cell["A programmatically generated grid.", "MathCaption",
 CellID->750173282],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "5", "}"}], ",", 
     RowBox[{"{", "5", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic", ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"i", ",", "i"}], "}"}], "\[Rule]", "Red"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "5"}], "}"}]}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[103]:=",
 CellID->511916520],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9VssKwjAQ3D609YVXxYtH8QfEc0Hx4EcUEdqDKNr/j5tslKopTRMTIZ3d
tRt3dubgMa+K8yWvylO+3N/zW1GeHsvd9Y6lKACADM9hBhgzjMTJGEOk5xaf
Q16tRSE/mHEcSNTN+4gRe91BGIhboSd+EJj48MKIY1wv6VQShJgHMfGhy0Oa
XE4xacAUsSenigw7vPBwooBKa1W0xmiK0VAMaprZztxnfOOf7wW0OiMF1PtO
EOKfd0NioOGJlNE45A/zLm+cnKli6pOFzOZW2T94fPfpu62LDr/darc1+eX1
vdptel3eODlTxdQnY5mtrLJ/8NB1m50ObW5r84vabd26vHFypoq5awA2nSLb
eRtdJTb8XrXFrpsd1e6Hbzd17fDCw4kCKq3pHzgETx77tqA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{67, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[103]=",
 CellID->175037253]
}, Open  ]],

Cell["Give settings to an entire region of the grid.", "MathCaption",
 CellID->927268547],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "5", "}"}], ",", 
     RowBox[{"{", "5", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2", ",", "4"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "4"}], "}"}]}], "}"}], "\[Rule]", "Red"}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[105]:=",
 CellID->313643150],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwOAOxpwQDkP0fyAJj
5///gTQmyQSUZAKyQDQnlCaXzwg2kYEVQv0HAyCDgRtEsyALkSfCBHEx1DZe
AjQzGapp7naqhzaueOUBkrpAmosiHrJ9bECaGS4GoTkJ8Nn+Q0KWmFTCDqRZ
QCwWSJoFCwJDkrAIO5BiIZBaOIA0K9RVvGg0x3+IczBTDWm66OYnmsUKdVLN
aGobTW2jqW00tQ2P1Iarhh1tPw3P9hMDIwD0Ozod\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{67, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[105]=",
 CellID->70639977]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "5", "}"}], ",", 
     RowBox[{"{", "5", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "None", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2", ",", "4"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "4"}], "}"}]}], "}"}], "\[Rule]", "True"}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[109]:=",
 CellID->880500799],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x"}
   },
   GridBoxFrame->{
    "Columns" -> {{None}}, "Rows" -> {{None}}, 
     "ItemsIndexed" -> {{{2, 4}, {2, 4}} -> True}}],
  "Grid"]], "Output",
 ImageSize->{73, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[109]=",
 CellID->477681304]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dividers and Frames", "Section",
 CellID->1180142567],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides an extensive system for describing what dividers and frames \
should be drawn in a grid."
}], "Text",
 CellID->1566010054],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Dividers",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Dividers"], Cell[
    "draw dividers between columns or rows", "TableText"]},
   {
    ButtonBox["Frame",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Frame"], Cell[
    "put a frame around regions of the grid", "TableText"]},
   {
    ButtonBox["FrameStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrameStyle"], Cell[
    "use an overall style for the lines", "TableText"]}
  }]], "DefinitionBox",
 CellID->371399946],

Cell["Options for drawing dividers and frames.", "Caption",
 CellID->1531414240],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Frame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Frame"]], "InlineFormula"],
 " to put lines on all four sides of a region or set of regions."
}], "MathCaption",
 CellID->1962882457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[131]:=",
 CellID->756909504],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxFrame->{"ColumnsIndexed" -> {{{1, -1}, {1, -1}} -> True}}],
  "Grid"]], "Output",
 ImageSize->{111, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[131]=",
 CellID->895705225]
}, Open  ]],

Cell["Highlight specific columns or rows.", "MathCaption",
 CellID->555973744],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"2", "\[Rule]", "True"}], ",", 
      RowBox[{"3", "\[Rule]", "True"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[141]:=",
 CellID->1379549489],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxFrame->{
    "ColumnsIndexed" -> {2 -> True}, "RowsIndexed" -> {3 -> True}}],
  "Grid"]], "Output",
 ImageSize->{113, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[141]=",
 CellID->880083493]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Frame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Frame"]], "InlineFormula"],
 " always draws a line on all four faces of the enclosed region. ",
 Cell[BoxData[
  ButtonBox["Dividers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dividers"]], "InlineFormula"],
 " allows a finer level of control."
}], "Reference",
 CellID->884357299],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", "\[Rule]", "True"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[140]:=",
 CellID->850545873],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxDividers->{"ColumnsIndexed" -> {2 -> True}}],
  "Grid"]], "Output",
 ImageSize->{102, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[140]=",
 CellID->1822608843]
}, Open  ]],

Cell["\<\
One result is that when using dividers, the resulting lines run in only a \
single direction.\
\>", "Reference",
 CellID->791400608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"All", ",", "None"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[147]:=",
 CellID->360992124],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxDividers->{"Columns" -> {{True}}, "Rows" -> {{None}}}],
  "Grid"]], "Output",
 ImageSize->{117, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[147]=",
 CellID->109420920]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"All", ",", "None"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[146]:=",
 CellID->1355129248],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{None}}}],
  "Grid"]], "Output",
 ImageSize->{117, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[146]=",
 CellID->1997228911]
}, Open  ]],

Cell["This short form draws the center dividers.", "MathCaption",
 CellID->1310976635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", " ", 
     RowBox[{"{", "4", "}"}], ",", " ", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", " ", 
   RowBox[{"Dividers", " ", "->", " ", "Center"}]}], "]"}]], "Input",
 CellLabel->"In[150]:=",
 CellID->1703792785],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxDividers->{
    "Columns" -> {False, {True}, False}, "Rows" -> {False, {True}, False}}],
  "Grid"]], "Output",
 ImageSize->{107, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[150]=",
 CellID->565857593]
}, Open  ]],

Cell[CellGroupData[{

Cell["Styling dividers and frames", "Subsection",
 CellID->1184197524],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FrameStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameStyle"]], "InlineFormula"],
 " sets the base style used for both ",
 Cell[BoxData[
  ButtonBox["Frame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Frame"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Dividers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dividers"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->402086225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"All", ",", "None"}], "}"}]}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", "Red"}]}], "]"}]], "Input",
 CellLabel->"In[94]:=",
 CellID->1458861821],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   FrameStyle->RGBColor[1, 0, 0],
   GridBoxDividers->{"Columns" -> {{True}}, "Rows" -> {{None}}}],
  "Grid"]], "Output",
 ImageSize->{117, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[94]=",
 CellID->670047846]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"All", ",", "None"}], "}"}]}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", "Red"}]}], "]"}]], "Input",
 CellLabel->"In[95]:=",
 CellID->302476750],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   FrameStyle->RGBColor[1, 0, 0],
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{None}}}],
  "Grid"]], "Output",
 ImageSize->{117, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[95]=",
 CellID->89902854]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Frame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Frame"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Dividers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dividers"]], "InlineFormula"],
 " allow styles as values."
}], "MathCaption",
 CellID->1450981671],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Brown", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "\[Rule]", "Red"}], ",", 
          RowBox[{
           RowBox[{"-", "1"}], "\[Rule]", "Green"}]}], "}"}]}], "}"}], ",", 
      "None"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[50]:=",
 CellID->1972132812],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmr0OgjAQxw+K4KDOjryDky+gkw/REA0MRkFexqetV6wMhKkxIfdB0mt7
cPldm8u/HbjYvr7ebd9Utjx39lk31as8PTp0mQQAWmzHPeDY4WhorXO+N2jc
8MDOG/O+HcJ8++f5Bs03geWpKZoUXb8+985sjCLxdjW7MjPEwDgHKCY7khL+
Ip9dcxZ2ZD2JNwv7CwbZSqwnvuogSeOVqlSlxlD56p/E04zWfYNWthLria86
SNJ4pSpVqTFUvvon8TSjdd+gla3EeuKrDpI0XqlKVWoMla/+STzNaN03aGUr
sZ74qgN3jQ//iyQfDcqNzg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{113, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[50]=",
 CellID->722176183]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Brown", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "\[Rule]", "Red"}], ",", 
          RowBox[{
           RowBox[{"-", "1"}], "\[Rule]", "Green"}]}], "}"}]}], "}"}], ",", 
      "None"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[48]:=",
 CellID->1047796870],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxFrame->{"Columns" -> {{
        RGBColor[0.6, 0.4, 0.2]}}, 
     "ColumnsIndexed" -> {1 -> RGBColor[1, 0, 0], -1 -> RGBColor[0, 1, 0]}, 
     "Rows" -> {{None}}}],
  "Grid"]], "Output",
 ImageSize->{117, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[48]=",
 CellID->1048102585]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Precedence", "Subsection",
 CellID->340090734],

Cell[TextData[{
 "When conflicting styles are given, ",
 Cell[BoxData[
  ButtonBox["Dividers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dividers"]], "InlineFormula"],
 " has precedence over ",
 Cell[BoxData[
  ButtonBox["Frame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Frame"]], "InlineFormula"],
 ", and they have precedence over ",
 Cell[BoxData[
  ButtonBox["FrameStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameStyle"]], "InlineFormula"],
 "."
}], "Reference",
 CellID->2017085571],

Cell["Dividers and frames are added together.", "MathCaption",
 CellID->1416766816],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"2", "\[Rule]", "True"}], ",", 
      RowBox[{"3", "\[Rule]", "True"}]}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", 
      RowBox[{"4", "\[Rule]", "True"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[177]:=",
 CellID->625510853],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAw5ACxvQQDkP0fyALj
nP//gTSUZAADZpA4GDDwgQgkfjiQYBwEqpiABBOQC6PZQIIscHk0WU4q81mx
uokZ1Q1ABjuaX5gwVHDTTIQNqxtZoD7gQHMZM1Scl0iafQBMHwrhOxjT5WDK
w5ASRhBNPgIcpLQSZR3QOAHbhm7nAKddsN1gkhq5lYMGpg3G8BoM6YhWeSQb
KMBIUxtG8+Zo3hzNm4NfdDCE5GBMYaM5cnjnSEgPmIERAPvvHgM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{108, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[177]=",
 CellID->301079749]
}, Open  ]],

Cell["Styles from different sources are combined together.", "MathCaption",
 CellID->943687172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Item", "[", 
        RowBox[{"x", ",", 
         RowBox[{"Frame", "\[Rule]", "Green"}]}], "]"}], ",", "x", ",", "x", 
       ",", "x", ",", "x", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"2", "\[Rule]", "Red"}], ",", 
      RowBox[{"2", "\[Rule]", "Red"}]}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", "\[Rule]", "True"}], "}"}], ",", 
      RowBox[{"4", "\[Rule]", "Orange"}]}], "}"}]}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Dashing", "[", "2", "]"}], ",", 
      RowBox[{"Thickness", "[", "2", "]"}], ",", "Blue"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[185]:=",
 CellID->1201458272],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", 
     ItemBox["x",
      Frame->RGBColor[0, 1, 0],
      StripOnInput->False], "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   FrameStyle->Directive[
     Dashing[2], 
     Thickness[2], 
     RGBColor[0, 0, 1]],
   GridBoxDividers->{
    "ColumnsIndexed" -> {2 -> RGBColor[1, 0, 0]}, 
     "RowsIndexed" -> {2 -> RGBColor[1, 0, 0]}},
   GridBoxFrame->{
    "ColumnsIndexed" -> {1 -> True}, 
     "RowsIndexed" -> {4 -> RGBColor[1, 0.5, 0]}}],
  "Grid"]], "Output",
 ImageSize->{117, 71},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[185]=",
 CellID->2047237858]
}, Open  ]],

Cell[TextData[{
 "Styles specified in ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 " always override all others."
}], "MathCaption",
 CellID->1383566709],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Item", "[", 
        RowBox[{"x", ",", 
         RowBox[{"Frame", "\[Rule]", "Black"}]}], "]"}], ",", "x", ",", "x", 
       ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Item", "[", 
        RowBox[{"x", ",", 
         RowBox[{"Frame", "\[Rule]", "Green"}]}], "]"}], ",", "x", ",", "x", 
       ",", "x", ",", "x", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"2", "\[Rule]", "Red"}], ",", 
      RowBox[{"2", "\[Rule]", "Red"}]}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", "\[Rule]", "True"}], "}"}], ",", 
      RowBox[{"4", "\[Rule]", "Orange"}]}], "}"}]}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Dashing", "[", "2", "]"}], ",", 
      RowBox[{"Thickness", "[", "2", "]"}], ",", "Blue"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[186]:=",
 CellID->1396679853],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlV9uOgkAMLXeIMZJ92kf3Z9aHdb/A8EDMJvpgXFw/wD+f7QwdrsNFQCBK
gp12Zkpbzinjd3g9/JzC63EfrjeX8Pdw3P+tP88XNBkaAER4b94BxwxH4o4Y
49JgN2DiAh2HOg6eUYLIDrPFCxO+weQRPTbTU6LF7/lN6ACB0PiMT5Zdbp/J
NaDqoFw06F5P3Uqe7vDITI7MGI0AyxaWxUAWVwiXonKpNhbpK5LLBukl1bV7
enJyb8WatDZ2EovMaix0OHdht4j5tr1NgJ6JtjgD/nbn/avliwhhZ5GJssfh
rF+yxOunwXG5wzkUn1maeXSn47Xo26O8kqdVJw9z6PxFRNhUE2MUZNRhtQ7b
YCCJKRMdGHktS5FGvBS+7vZgotymUaAWKDTu8YMs2wpLfoey5jg7Xs3bfFcd
iqrM0ccxUvLHpWdLZrbjk1uxuy8rqysxRrdqOplWoWc4tNRhuYkLyDNIeZZ6
L8q4uJKStZyWX/F4JSMfM5EaSu3FM+dZ+ZRdUGGJMr/q9UXcyx4xTpecw7dZ
9rNup4tszaSnzicdxT8xh9aM3xWnOcXWYVWF7bb85zK7djfAbopA+wf4Hu7W
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{113, 71},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[186]=",
 CellID->366543198]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Alignment and Positioning", "Section",
 CellID->712604389],

Cell[TextData[{
 "Aesthetic grids often require use of alignment. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has considerable support for different kinds of alignment in grids."
}], "Text",
 CellID->430373609],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Alignment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alignment"]], "InlineFormula"],
 " option ",
 "can",
 " be passed to the overall grid."
}], "Text",
 CellID->1295044017],

Cell["Align contents to the right.", "MathCaption",
 CellID->1316263337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"100", ",", "1000"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10000", ",", "100000"}], "}"}]}], "}"}], ",", 
   RowBox[{"Alignment", "\[Rule]", "Right"}]}], "]"}]], "Input",
 CellLabel->"In[53]:=",
 CellID->1168705658],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "10"},
    {"100", "1000"},
    {"10000", "100000"}
   },
   GridBoxAlignment->{"Columns" -> {{Right}}}],
  "Grid"]], "Output",
 ImageSize->{95, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[53]=",
 CellID->1147375112]
}, Open  ]],

Cell["\<\
It is possible to give different horizontal alignments to different columns, \
and different vertical alignments to different rows.\
\>", "Text",
 CellID->1180333776],

Cell["Align first column to the right, second column to the left.", \
"MathCaption",
 CellID->1208857212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"100", ",", "1000"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10000", ",", "100000"}], "}"}]}], "}"}], ",", 
   RowBox[{"Alignment", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"Right", ",", "Left"}], "}"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[61]:=",
 CellID->355862606],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "10"},
    {"100", "1000"},
    {"10000", "100000"}
   },
   GridBoxAlignment->{"Columns" -> {Right, Left}}],
  "Grid"]], "Output",
 ImageSize->{95, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[61]=",
 CellID->240862147]
}, Open  ]],

Cell["\<\
It is also possible to give different alignments to the individual items in \
the grid.\
\>", "Text",
 CellID->163430034],

Cell[TextData[{
 "Set the ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "1"}], "}"}]], "InlineFormula"],
 " element to the left, the ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "2"}], "}"}]], "InlineFormula"],
 " element to the right."
}], "MathCaption",
 CellID->2067861464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "10"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"100", ",", " ", "1000"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"10000", ",", " ", "100000"}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"Alignment", " ", "->", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Right", ",", " ", "Left"}], "}"}], ",", "Automatic", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "Left"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "Right"}]}], "}"}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[62]:=",
 CellID->136996925],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "10"},
    {"100", "1000"},
    {"10000", "100000"}
   },
   GridBoxAlignment->{
    "Columns" -> {Right, Left}, "Rows" -> {{Automatic}}, 
     "ItemsIndexed" -> {{1, 1} -> {Left, Inherited}, {1, 2} -> {
        Right, Inherited}}}],
  "Grid"]], "Output",
 ImageSize->{95, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[62]=",
 CellID->404848891]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Alignment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alignment"]], "InlineFormula"],
 " can also be set with ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 ". The ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 "'s specification will take precedence."
}], "Text",
 CellID->523392663],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Item", "[", 
        RowBox[{"1", ",", 
         RowBox[{"Alignment", "\[Rule]", "Left"}]}], "]"}], ",", 
       RowBox[{"Item", "[", 
        RowBox[{"10", ",", 
         RowBox[{"Alignment", "\[Rule]", "Right"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"100", ",", "1000"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10000", ",", "100000"}], "}"}]}], "}"}], ",", 
   RowBox[{"Alignment", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"Right", ",", "Left"}], "}"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[63]:=",
 CellID->475413376],

Cell[BoxData[
 TagBox[GridBox[{
    {
     ItemBox["1",
      Alignment->Left,
      StripOnInput->False], 
     ItemBox["10",
      Alignment->Right,
      StripOnInput->False]},
    {"100", "1000"},
    {"10000", "100000"}
   },
   GridBoxAlignment->{"Columns" -> {Right, Left}}],
  "Grid"]], "Output",
 ImageSize->{95, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[63]=",
 CellID->1067117341]
}, Open  ]],

Cell["\<\
It is possible to align on a decimal point, or any character.\
\>", "Text",
 CellID->1405214090],

Cell["Align on \".\".", "MathCaption",
 CellID->1819766047],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1234.", ",", "123.4", ",", "12.34", ",", "1.234"}], "}"}], ",", 
   RowBox[{"Alignment", "\[Rule]", "\"\<.\>\""}]}], "]"}]], "Input",
 CellLabel->"In[65]:=",
 CellID->571686219],

Cell[BoxData[
 TagBox[GridBox[{
    {"1234.`"},
    {"123.4`"},
    {"12.34`"},
    {"1.234`"}
   },
   GridBoxAlignment->{"Columns" -> {{"."}}, "Rows" -> {{"."}}}],
  "Column"]], "Output",
 ImageSize->{60, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[65]=",
 CellID->1630347551]
}, Open  ]],

Cell[TextData[{
 "Positioning a grid within its enclosing environment can be achieved with ",
 Cell[BoxData[
  ButtonBox["BaselinePosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaselinePosition"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->1507437584],

Cell["Default position.", "MathCaption",
 CellID->345851355],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"Grid", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}]}], "}"}], "]"}], ",", "b"}], 
  "}"}]], "Input",
 CellLabel->"In[67]:=",
 CellID->1209545181],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   TagBox[GridBox[{
      {"1", "2"},
      {"3", "4"}
     }],
    "Grid"], ",", "b"}], "}"}]], "Output",
 ImageSize->{82, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[67]=",
 CellID->745654565]
}, Open  ]],

Cell["\<\
Align the bottom of the grid to the baseline of the enclosing expression.\
\>", "MathCaption",
 CellID->1632974703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"Grid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", "Bottom"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", "b"}], 
  "}"}]], "Input",
 CellLabel->"In[73]:=",
 CellID->427252141],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   TagBox[GridBox[{
      {"1", "2"},
      {"3", "4"}
     },
     BaselinePosition->Bottom,
     GridBoxFrame->{"ColumnsIndexed" -> {{{1, -1}, {1, -1}} -> True}}],
    "Grid"], ",", "b"}], "}"}]], "Output",
 ImageSize->{92, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[73]=",
 CellID->1570558057]
}, Open  ]],

Cell[TextData[{
 "Align the grid so that the baseline of the ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"2", ",", "1"}], "}"}]], "InlineFormula"],
 " element is at the overall baseline."
}], "MathCaption",
 CellID->564824661],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"Grid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", "b"}], 
  "}"}]], "Input",
 CellLabel->"In[74]:=",
 CellID->1414811116],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   TagBox[GridBox[{
      {"1", "2"},
      {"3", "4"}
     },
     BaselinePosition->{2, 1},
     GridBoxFrame->{"ColumnsIndexed" -> {{{1, -1}, {1, -1}} -> True}}],
    "Grid"], ",", "b"}], "}"}]], "Output",
 ImageSize->{92, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[74]=",
 CellID->1647758722]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Background and Style", "Section",
 CellID->360262780],

Cell[CellGroupData[{

Cell["Common cases", "Subsection",
 CellID->1144944047],

Cell[TextData[{
 "When working with a collection of elements, ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " provides a way to set them against a uniform background. "
}], "Text",
 CellID->475589992],

Cell["\<\
Though elements can have their own background, awkward gaps result when you \
just put them together.\
\>", "Reference",
 CellID->1980647432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{"a", ",", 
       RowBox[{"Background", "\[Rule]", "Brown"}]}], "]"}], ",", 
     RowBox[{"Style", "[", 
      RowBox[{"b", ",", 
       RowBox[{"Background", "\[Rule]", "Brown"}]}], "]"}]}], "}"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[193]:=",
 CellID->306861410],

Cell[BoxData[
 TagBox[GridBox[{
    {
     StyleBox["a",
      StripOnInput->False,
      Background->RGBColor[0.6, 0.4, 0.2]], 
     StyleBox["b",
      StripOnInput->False,
      Background->RGBColor[0.6, 0.4, 0.2]]}
   }],
  "Grid"]], "Output",
 ImageSize->{26, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[193]=",
 CellID->458984945]
}, Open  ]],

Cell["\<\
Grid and related functions place a background across the entire group of \
items in which the elements are contained.\
\>", "Reference",
 CellID->597377477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", "Brown"}]}], "]"}]], "Input",
 CellLabel->"In[194]:=",
 CellID->567979521],

Cell[BoxData[
 TagBox[GridBox[{
    {"a", "b"}
   },
   GridBoxBackground->{"Columns" -> {{
        RGBColor[0.6, 0.4, 0.2]}}}],
  "Grid"]], "Output",
 ImageSize->{26, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[194]=",
 CellID->398710591]
}, Open  ]],

Cell["\<\
With more sophisticated syntax, a variety of patterns is easy to achieve.\
\>", "Reference",
 CellID->1130357687],

Cell["Alternate the backgrounds.", "MathCaption",
 CellID->637206214],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", " ", 
     RowBox[{"{", "5", "}"}], ",", " ", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", " ", 
   RowBox[{"Background", " ", "->", " ", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"Brown", ",", " ", "None"}], "}"}], "}"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[195]:=",
 CellID->23891109],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxBackground->{"Columns" -> {{
        RGBColor[0.6, 0.4, 0.2], None}}}],
  "Grid"]], "Output",
 ImageSize->{101, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[195]=",
 CellID->979924297]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", " ", 
     RowBox[{"{", "5", "}"}], ",", " ", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", " ", 
   RowBox[{"Background", " ", "->", " ", 
    RowBox[{"{", 
     RowBox[{"None", ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"Brown", ",", " ", "None"}], "}"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[196]:=",
 CellID->632750702],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwJAKxpwQDkP0fyALj
xP//gTSUnJlmDCOZgJJMQBaI5oTStOIzgm1kYIVQQBLCYOAG0SzIQrQTYYL4
GuoiXhJpZiroHhT+p3usJ+IikdMlBgk2B8gCmwulacVnBNvIwAqh/oMBOHZA
NAuyEO1EmCC+hrqIl0SamQq6B4X/6R7rOFMh3rQ7WnaOlp2jZedo2Tlado6W
naNlJ1H+p3usY5aXDIwAo/TMZA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[196]=",
 CellID->168341686]
}, Open  ]],

Cell["Highlight a row and column that intersect.", "MathCaption",
 CellID->1843502978],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", " ", 
     RowBox[{"{", "5", "}"}], ",", " ", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", " ", 
   RowBox[{"Background", " ", "->", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"5", "\[Rule]", "Brown"}], ",", " ", 
      RowBox[{"4", "\[Rule]", "Brown"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[197]:=",
 CellID->1020378439],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxBackground->{
    "ColumnsIndexed" -> {5 -> RGBColor[0.6, 0.4, 0.2]}, 
     "RowsIndexed" -> {4 -> RGBColor[0.6, 0.4, 0.2]}}],
  "Grid"]], "Output",
 ImageSize->{101, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[197]=",
 CellID->1235076075]
}, Open  ]],

Cell["Embed the background with a particular item inside the grid.", \
"MathCaption",
 CellID->224392985],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"\"\<The \>\"", ",", "\"\<quick \>\"", ",", 
     RowBox[{"Item", "[", 
      RowBox[{"\"\<brown\>\"", ",", 
       RowBox[{"Background", "\[Rule]", "Brown"}]}], "]"}], ",", 
     "\"\< fox \>\"", ",", "\"\<jumps \>\"", ",", "\"\<over \>\"", ",", 
     "\"\<the \>\"", ",", " ", "\"\<lazy \>\"", ",", "\"\<dog.\>\""}], "}"}], 
   "}"}], "]"}]], "Input",
 CellLabel->"In[107]:=",
 CellID->1052407374],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"The \"\>", "\<\"quick \"\>", 
     ItemBox["\<\"brown\"\>",
      Background->RGBColor[0.6, 0.4, 0.2],
      StripOnInput->
       False], "\<\" fox \"\>", "\<\"jumps \"\>", "\<\"over \"\>", "\<\"the \
\"\>", "\<\"lazy \"\>", "\<\"dog.\"\>"}
   }],
  "Grid"]], "Output",
 ImageSize->{376, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[107]=",
 CellID->1979427333]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Precedence of overlapping background settings", "Subsection",
 CellID->1345165277],

Cell["\<\
Backgrounds given in the list syntax blend together upon intersection.\
\>", "MathCaption",
 CellID->2103074872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"Brown", ",", "None"}], "}"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"Green", ",", "None"}], "}"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[198]:=",
 CellID->665413170],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxBackground->{"Columns" -> {{
        RGBColor[0.6, 0.4, 0.2], None}}, "Rows" -> {{
        RGBColor[0, 1, 0], None}}}],
  "Grid"]], "Output",
 ImageSize->{101, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[198]=",
 CellID->346660623]
}, Open  ]],

Cell["\<\
Backgrounds specifically asserted using indices take precedence.\
\>", "MathCaption",
 CellID->946027731],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"Brown", ",", "None"}], "}"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "Green"}], ",", 
        RowBox[{"3", "\[Rule]", "Green"}]}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[199]:=",
 CellID->103853618],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxBackground->{"Columns" -> {{
        RGBColor[0.6, 0.4, 0.2], None}}, 
     "RowsIndexed" -> {1 -> RGBColor[0, 1, 0], 3 -> RGBColor[0, 1, 0]}}],
  "Grid"]], "Output",
 ImageSize->{101, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[199]=",
 CellID->201956450]
}, Open  ]],

Cell["Indexed columns take precedence over indexed rows.", "MathCaption",
 CellID->2066636176],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "Brown"}], ",", 
        RowBox[{"3", "\[Rule]", "Brown"}], ",", 
        RowBox[{"5", "\[Rule]", "Brown"}], ",", 
        RowBox[{"7", "\[Rule]", "Brown"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"Green", ",", "None"}], "}"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[200]:=",
 CellID->443916251],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztlk0KwjAQhadNUoMI3brs3qV30JWHCEVpF6LUXsbTxpefhdSq0DY0ixbS
b3gzhMwwGXJSbXW+qrYuVXFs1L2qy0dxuDWQWEJECmu3Jdgall1Ka9D9N8/L
Poecd7gG/3lTbJbCMsxABo/VPDOQeX+ouMSehIQD/s6gFchNupxc2tqqADcR
/D04VGzqquRPKkHhM5GgGKizgLtGXcdoum3MnRntxa3NO5zX+1FHeKzmmYG9
9Z4w7ucUMHPO9JO2n1GBLx0ZILZnCvhMJCgG6j1TYLJdo65jNN02622ca/os
b4HlLRBDHaPptjF3xr3AKXkBtK0QAA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[200]=",
 CellID->300752868]
}, Open  ]],

Cell[TextData[{
 "Backgrounds specified with ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 " have the highest precedence."
}], "MathCaption",
 CellID->1047308927],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Item", "[", 
        RowBox[{"x", ",", 
         RowBox[{"Background", "\[Rule]", "Red"}]}], "]"}], ",", "x", ",", 
       "x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "Brown"}], ",", 
        RowBox[{"3", "\[Rule]", "Brown"}], ",", 
        RowBox[{"5", "\[Rule]", "Brown"}], ",", 
        RowBox[{"7", "\[Rule]", "Brown"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"Green", ",", "None"}], "}"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[201]:=",
 CellID->1291273001],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNlksKwjAQhtPmYRChW5fdu/QOuvIQoSjtQpTay3ja+OeBSK0V2oakkH5h
ZgjJz2QmJ9XV56vqmkqVx1bd66Z6lIdbCxPNCCEKY7clmGvM7FBag+6/eV72
BcxFj2vwnzfHYjlmhgKk8FibpwCp94eKy+xOCHfA303ICmTmuIy4Y2trBZiJ
YJ/BoWJzp5LfqQS5P4kE+UQ7Dbhq0jomk21z7sxsL25t0WNc75eO8FibpwAH
9V4wbrQKmDpn8knbz1iBHxkZIHagCviTSJBPtA9UgcVWTVrHZLIt2m2ERCM1
IpLXaeYowJhvAdtK3j3F5JNpM0n0MK+QBBd8CwRZNWkdk8m2OXfGvcBJ9gLR
0Atr\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[201]=",
 CellID->152542255]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Spanning and Nesting", "Section",
 CellID->840324821],

Cell["\<\
Sophisticated partitioning of 2D space can be achieved by nested grid \
constructs and/or by using spanning elements.\
\>", "Text",
 CellID->2079212589],

Cell["\<\
As their name suggests, spanning elements allow an item to span multiple \
columns, rows, or both.\
\>", "Text",
 CellID->78353486],

Cell["Span \"a\" across the first two columns.", "MathCaption",
 CellID->519146746],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<a\>\"", ",", " ", "SpanFromLeft", ",", " ", "\"\<c\>\""}], 
      "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<d\>\"", ",", " ", "\"\<e\>\"", ",", " ", "\"\<f\>\""}], 
      "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<g\>\"", ",", " ", "\"\<h\>\"", ",", " ", "\"\<i\>\""}], 
      "}"}]}], "}"}], ",", " ", 
   RowBox[{"Frame", " ", "->", " ", "All"}]}], "]"}]], "Input",
 CellLabel->"In[709]:=",
 CellID->73302261],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"a\"\>", "\[SpanFromLeft]", "\<\"c\"\>"},
    {"\<\"d\"\>", "\<\"e\"\>", "\<\"f\"\>"},
    {"\<\"g\"\>", "\<\"h\"\>", "\<\"i\"\>"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{53, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[709]=",
 CellID->1482970896]
}, Open  ]],

Cell["Span \"a\" across the first two rows.", "MathCaption",
 CellID->596641990],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<a\>\"", ",", " ", "\"\<b\>\"", ",", " ", "\"\<c\>\""}], 
      "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"SpanFromAbove", ",", " ", "\"\<e\>\"", ",", " ", "\"\<f\>\""}],
       "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<g\>\"", ",", " ", "\"\<h\>\"", ",", " ", "\"\<i\>\""}], 
      "}"}]}], "}"}], ",", " ", 
   RowBox[{"Frame", " ", "->", " ", "All"}]}], "]"}]], "Input",
 CellLabel->"In[710]:=",
 CellID->1160778087],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"a\"\>", "\<\"b\"\>", "\<\"c\"\>"},
    {"\[SpanFromAbove]", "\<\"e\"\>", "\<\"f\"\>"},
    {"\<\"g\"\>", "\<\"h\"\>", "\<\"i\"\>"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{53, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[710]=",
 CellID->1455858861]
}, Open  ]],

Cell["Span \"a\" across the first two columns and rows.", "MathCaption",
 CellID->191202909],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<a\>\"", ",", " ", "SpanFromLeft", ",", " ", "\"\<c\>\""}], 
      "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
      "SpanFromAbove", ",", " ", "SpanFromBoth", ",", " ", "\"\<f\>\""}], 
      "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<g\>\"", ",", " ", "\"\<h\>\"", ",", " ", "\"\<i\>\""}], 
      "}"}]}], "}"}], ",", " ", 
   RowBox[{"Frame", " ", "->", " ", "All"}]}], "]"}]], "Input",
 CellLabel->"In[711]:=",
 CellID->911755651],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"a\"\>", "\[SpanFromLeft]", "\<\"c\"\>"},
    {"\[SpanFromAbove]", "\[SpanFromBoth]", "\<\"f\"\>"},
    {"\<\"g\"\>", "\<\"h\"\>", "\<\"i\"\>"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{53, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[711]=",
 CellID->1581405012]
}, Open  ]],

Cell["\<\
It is important to note that the spanning region must be rectangular; items \
that fail to fall within the rectangle will not be spanned, and will instead \
display the spanning character.\
\>", "Text",
 CellID->1416421412],

Cell["Spanning is only done in rectangular chunks.", "MathCaption",
 CellID->904622908],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<a\>\"", ",", " ", "SpanFromLeft", ",", " ", "\"\<c\>\""}], 
      "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
      "SpanFromAbove", ",", " ", "SpanFromBoth", ",", " ", "SpanFromLeft"}], 
      "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<g\>\"", ",", " ", "\"\<h\>\"", ",", " ", "\"\<i\>\""}], 
      "}"}]}], "}"}], ",", " ", 
   RowBox[{"Frame", " ", "->", " ", "All"}]}], "]"}]], "Input",
 CellLabel->"In[75]:=",
 CellID->1316623055],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"a\"\>", "\[SpanFromLeft]", "\<\"c\"\>"},
    {"\[SpanFromAbove]", "\[SpanFromBoth]", "\[SpanFromLeft]"},
    {"\<\"g\"\>", "\<\"h\"\>", "\<\"i\"\>"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{58, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[75]=",
 CellID->812186697]
}, Open  ]],

Cell["\<\
While many layouts can be achieved using spanning elements, it is sometimes \
faster or more convenient to simply nest grid constructs.\
\>", "Text",
 CellID->690672098],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Column", "[", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}], ",", 
    RowBox[{"Column", "[", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e"}], "}"}], "]"}], ",", "f"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[81]:=",
 CellID->221448842],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1U80OgjAMLtvwoGAkaAJ6gbPvoScfYiEmcjAa5P2xG+V3wA5Gkm3t1379
G7vJ8nF/yjLPZHIt5PuRZ5/k8ioQ4g4ApLjOEaBcoaRXWlV4mrvAnaPDUWtc
7a7ybz6UIe5svLXByYbOxFEZRavVVQSEeVrbjWJuLag7ZBp5vTaHovvGDBjF
COlkCz2Eoyr4331ZU1HPGsxHFjUKANMd9ViHySiMcvrEXdHcmHXCP9l6dbDB
nSmNStONbbS4H3HWGg3Jv2YL6iBamHtstQ3/V5tn95bMtwbOFwFZ1ng=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{33, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[81]=",
 CellID->200031664]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Grid", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"a", ",", "b"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "]"}], ",", "e"}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"f", ",", "g"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[84]:=",
 CellID->2071728250],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {"a", "b"},
        {"c", "d"}
       }],
      "Grid"], "e"},
    {"f", "g"}
   }],
  "Grid"]], "Output",
 ImageSize->{41, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[84]=",
 CellID->1807756773]
}, Open  ]],

Cell[TextData[{
 "Particularly with complex grids, it is often clearer to use ",
 Cell[BoxData[
  ButtonBox["Row",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Row"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Column",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Column"]], "InlineFormula"],
 " to create the specifically desired structures than to try to design a \
complicated system of spanning. "
}], "Text",
 CellID->960526072]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sizing and Spacing", "Section",
 CellID->796889411],

Cell[CellGroupData[{

Cell["Sizing in Grid", "Subsection",
 CellID->224259477],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " will typically not modify the size of its elements. Also, rows and columns \
are by default made as narrow as possible while accommodating the contents."
}], "Reference",
 CellID->687557352],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       GraphicsBox[DiskBox[{0., 0.}],
        ImageSize->{32.666666666665506`, Automatic}], ",", 
       GraphicsBox[RectangleBox[{0., 0.}],
        AspectRatio->Full,
        ImageSize->{21.333333333331076`, 44.666666666666664`}]}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[275]:=",
 CellID->1042654578],

Cell[BoxData[
 TagBox[GridBox[{
    {"a", "b"},
    {
     GraphicsBox[DiskBox[{0., 0.}],
      ImageSize->{32.666666666665506`, Automatic}], 
     GraphicsBox[RectangleBox[{0., 0.}],
      AspectRatio->Full,
      ImageSize->{21.333333333331076`, 44.666666666666664`}]}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{77, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[275]=",
 CellID->805295005]
}, Open  ]],

Cell["\<\
Notice in the above example that the second row is much taller than the \
first, the second column thinner than the first, and the sizes of the \
elements were not modified in any way.\
\>", "Reference",
 CellID->1647791508],

Cell["\<\
If elements in the grid are interactively or dynamically changed, the size of \
the entire grid will be adjusted appropriately.\
\>", "Reference",
 CellID->1427597182],

Cell[TextData[{
 "A useful exception is that ",
 Cell[BoxData[
  ButtonBox["Button",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Button"]], "InlineFormula"],
 " will by default expand to fill the available space."
}], "Reference",
 CellID->302340726],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Button", "[", "c", "]"}], ",", 
       GraphicsBox[RectangleBox[{0., 0.}],
        AspectRatio->Full,
        ImageSize->{21.333333333331076`, 44.666666666666664`}]}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[277]:=",
 CellID->1177663577],

Cell[BoxData[
 TagBox[GridBox[{
    {"a", "b"},
    {
     ButtonBox["c",
      Appearance->Automatic,
      ButtonData->"paclet:ref/c",
      ButtonFrame->"DialogBox",
      ButtonFunction:>{},
      Evaluator->None,
      Method->"Preemptive"], 
     GraphicsBox[RectangleBox[{0., 0.}],
      AspectRatio->Full,
      ImageSize->{21.333333333331076`, 44.666666666666664`}]}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{59, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[277]=",
 CellID->1633032464]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ItemSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ItemSize"]], "InlineFormula"],
 " can be used to override the default behavior."
}], "Reference",
 CellID->780908964],

Cell["Make all items the same size.", "MathCaption",
 CellID->1281304047],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Button", "[", "c", "]"}], ",", 
       GraphicsBox[RectangleBox[{0., 0.}],
        AspectRatio->Full,
        ImageSize->{21.333333333331076`, 44.666666666666664`}]}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"ItemSize", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[278]:=",
 CellID->1464391131],

Cell[BoxData[
 TagBox[GridBox[{
    {"a", "b"},
    {
     ButtonBox["c",
      Appearance->Automatic,
      ButtonData->"paclet:ref/c",
      ButtonFrame->"DialogBox",
      ButtonFunction:>{},
      Evaluator->None,
      Method->"Preemptive"], 
     GraphicsBox[RectangleBox[{0., 0.}],
      AspectRatio->Full,
      ImageSize->{21.333333333331076`, 44.666666666666664`}]}
   },
   ColumnsEqual->True,
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{},
   RowsEqual->True],
  "Grid"]], "Output",
 ImageSize->{65, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[278]=",
 CellID->1535613788]
}, Open  ]],

Cell["Specify widths and heights for individual columns and rows.", \
"MathCaption",
 CellID->903401503],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"ItemSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7"}], 
       "}"}], ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[256]:=",
 CellID->1601576718],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   ColumnsEqual->False,
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {1, 2, 3, 4, 5, 6, 7}, "Rows" -> {{1}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{423, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[256]=",
 CellID->1315099214]
}, Open  ]],

Cell[TextData[{
 "The units used for ",
 Cell[BoxData[
  ButtonBox["ItemSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ItemSize"]], "InlineFormula"],
 " are the typesetting units known as \"exs\" and \"ems\"."
}], "Reference",
 CellID->1938533590],

Cell[TextData[{
 "It is also possible to specify widths as a fraction of the enclosing area \
by using ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 "."
}], "Reference",
 CellID->1699814378],

Cell["Make the first two columns each .3 of the page width.", "MathCaption",
 CellID->2058589460],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"ItemSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Scaled", "[", ".3", "]"}], ",", 
        RowBox[{"Scaled", "[", ".3", "]"}], ",", "3", ",", "4", ",", "5", ",",
         "6", ",", "7"}], "}"}], ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[274]:=",
 CellID->1438452170],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   ColumnsEqual->False,
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {
       Scaled[0.3], 
       Scaled[0.3], 3, 4, 5, 6, 7}, "Rows" -> {{1}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{690, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[274]=",
 CellID->1842206911]
}, Open  ]],

Cell[CellGroupData[{

Cell["Line wrapping in Grid", "Subsubsection",
 CellID->470795355],

Cell["\<\
Textual items will line wrap if the columns are too narrow. Notice that this \
forces the rows to be taller that the minimum specified.\
\>", "Reference",
 CellID->355827595],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"xxxx", ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"ItemSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7"}], 
       "}"}], ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[266]:=",
 CellID->1714500359],

Cell[BoxData[
 TagBox[GridBox[{
    {"xxxx", "xxxx", "xxxx", "xxxx", "xxxx", "xxxx", "xxxx"},
    {"xxxx", "xxxx", "xxxx", "xxxx", "xxxx", "xxxx", "xxxx"},
    {"xxxx", "xxxx", "xxxx", "xxxx", "xxxx", "xxxx", "xxxx"}
   },
   ColumnsEqual->False,
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {1, 2, 3, 4, 5, 6, 7}, "Rows" -> {{1}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{423, 219},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[266]=",
 CellID->818160503]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ItemSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ItemSize"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", textual items are wrapped at the page width."
}], "MathCaption",
 CellID->485782180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"100", "!"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"200", "!"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"ItemSize", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[271]:=",
 CellID->1023416509],

Cell[BoxData[
 TagBox[GridBox[{
    {"933262154439441526816992388562667004907159682643816214685929638952175999\
932299156089414639761565182862536979208272237582511852109168640000000000000000\
00000000"},
    {"788657867364790503552363213932185062295135977687173263294742533244359449\
963403342920304284011984623904177212138919638830257642790242637105061926624952\
829931113462857270763317237396988943922445621451664240254033291864131227428294\
853277524242407573903240321257405579568660226031904170324062351700858796178922\
222789623703897374720000000000000000000000000000000000000000000000000"}
   },
   ColumnsEqual->False,
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{572, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[271]=",
 CellID->476604828]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ItemSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ItemSize"], "->", 
   ButtonBox["Full",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Full"]}]], "InlineFormula"],
 ", line breaking is prevented."
}], "MathCaption",
 CellID->727823981],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"100", "!"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"110", "!"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"ItemSize", "\[Rule]", "Full"}]}], "]"}]], "Input",
 CellLabel->"In[273]:=",
 CellID->1332832276],

Cell[BoxData[
 TagBox[GridBox[{
    {"933262154439441526816992388562667004907159682643816214685929638952175999\
932299156089414639761565182862536979208272237582511852109168640000000000000000\
00000000"},
    {"158824554152274294042537031270907728717244102344735632075817483184445671\
629481830309599601315176785204792436726381799902085211486234222668767576239112\
19200000000000000000000000000"}
   },
   ColumnsEqual->False,
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{All}}, "Rows" -> {{All}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{1393, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[273]=",
 CellID->1182967301]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sizing in GraphicsGrid", "Subsection",
 CellID->1480420842],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphicsGrid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsGrid"]], "InlineFormula"],
 " will by default return a grid whose items are all the same size."
}], "Reference",
 CellID->295229454],

Cell[BoxData[
 RowBox[{
  RowBox[{"randomgrid", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Circle", "[", "]"}], ",", " ", 
       RowBox[{"ImageSize", " ", "\[Rule]", " ", "Automatic"}], ",", " ", 
       "\n", "  ", 
       RowBox[{"AspectRatio", " ", "->", " ", 
        RowBox[{"RandomReal", "[", "]"}]}]}], "]"}], ",", " ", 
     RowBox[{"{", "3", "}"}], ",", " ", 
     RowBox[{"{", "5", "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[286]:=",
 CellID->2021953202],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"randomgrid", ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[289]:=",
 CellID->602465270],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[289]=",
 CellID->895976088]
}, Open  ]],

Cell["\<\
It will automatically choose an aspect ratio that is appropriate for the \
overall collection of elements.\
\>", "Reference",
 CellID->1804617922],

Cell[TextData[{
 "Compare this with the equivalent ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " example, which does not impose either an overall size or an aspect ratio."
}], "Reference",
 CellID->1940030075],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"randomgrid", ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[290]:=",
 CellID->965654002],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[CircleBox[{0, 0}],
      AspectRatio->0.4842406831632369,
      ImageSize->Automatic], 
     GraphicsBox[CircleBox[{0, 0}],
      AspectRatio->0.2402099478441817,
      ImageSize->Automatic], 
     GraphicsBox[CircleBox[{0, 0}],
      AspectRatio->0.4863533956587187,
      ImageSize->Automatic], 
     GraphicsBox[CircleBox[{0, 0}],
      AspectRatio->0.8543190674840531,
      ImageSize->Automatic], 
     GraphicsBox[CircleBox[{0, 0}],
      AspectRatio->0.43828315200358703`,
      ImageSize->Automatic]},
    {
     GraphicsBox[CircleBox[{0, 0}],
      AspectRatio->0.8373885253487876,
      ImageSize->Automatic], 
     GraphicsBox[CircleBox[{0, 0}],
      AspectRatio->0.15043806114283154`,
      ImageSize->Automatic], 
     GraphicsBox[CircleBox[{0, 0}],
      AspectRatio->0.8285163035204335,
      ImageSize->Automatic], 
     GraphicsBox[CircleBox[{0, 0}],
      AspectRatio->0.7238864248799839,
      ImageSize->Automatic], 
     GraphicsBox[CircleBox[{0, 0}],
      AspectRatio->0.6316441538725843,
      ImageSize->Automatic]},
    {
     GraphicsBox[CircleBox[{0, 0}],
      AspectRatio->0.0016001669157472698`,
      ImageSize->Automatic], 
     GraphicsBox[CircleBox[{0, 0}],
      AspectRatio->0.4906403048827863,
      ImageSize->Automatic], 
     GraphicsBox[CircleBox[{0, 0}],
      AspectRatio->0.5890612564859663,
      ImageSize->Automatic], 
     GraphicsBox[CircleBox[{0, 0}],
      AspectRatio->0.8605862180101187,
      ImageSize->Automatic], 
     GraphicsBox[CircleBox[{0, 0}],
      AspectRatio->0.7185547964864423,
      ImageSize->Automatic]}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{950, 481},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[290]=",
 CellID->1301868473]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphicsGrid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsGrid"]], "InlineFormula"],
 " does not support an ",
 Cell[BoxData[
  ButtonBox["ItemSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ItemSize"]], "InlineFormula"],
 " option, but it does support ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 "."
}], "Reference",
 CellID->841258124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"randomgrid", ",", 
   RowBox[{"ImageSize", "\[Rule]", "200"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[294]:=",
 CellID->1907887772],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{200, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[294]=",
 CellID->76931600]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Grids, Rows, and Columns in Mathematica - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 36, 56.7231762}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "", "status" -> "None", "summary" -> 
    "Mathematica provides a broad range of powerful constructs for laying out \
content on a screen or page. They are designed to be immediately useful for \
the beginner, yet also allow fine control over almost every aspect of their \
appearance. Grid, Column, and Row form the first family, referred to in this \
tutorial as the Grid family. The Grid family's defining characteristic is \
that it is a tightly integrated part of Mathematica's typesetting system. \
This means that any expression whatsoever can appear as content, and that the \
construct itself can respond to changes such as window width or even the size \
of its elements. Like other typesetting constructs, the Grid family's members \
are inert declarative descriptions and do not evaluate to some other form. \
\"Grid\"", "synonyms" -> {}, "title" -> 
    "Grids, Rows, and Columns in Mathematica", "type" -> "Tutorial", "uri" -> 
    "tutorial/GridsRowsAndColumns"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1888, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2513, 61, 129, 5, 70, "Title",
 CellID->509267359],
Cell[CellGroupData[{
Cell[2667, 70, 60, 1, 70, "Section",
 CellID->1091725847],
Cell[2730, 73, 330, 7, 70, "Text",
 CellID->344237187],
Cell[3063, 82, 323, 6, 70, "Reference",
 CellID->1493879423],
Cell[3389, 90, 961, 26, 70, "Text",
 CellID->2000928762],
Cell[CellGroupData[{
Cell[4375, 120, 1778, 52, 70, "Input",
 CellID->815991614],
Cell[6156, 174, 2738, 48, 70, "Output",
 Evaluatable->False,
 CellID->64652122]
}, {2}]],
Cell[8906, 225, 1088, 25, 70, "Text",
 CellID->207512326],
Cell[CellGroupData[{
Cell[10019, 254, 3047, 84, 70, "Input",
 CellID->1241370748],
Cell[13069, 340, 4126, 71, 70, "Output",
 Evaluatable->False,
 CellID->132625587]
}, {2}]],
Cell[17207, 414, 925, 26, 70, "Text",
 CellID->804197510],
Cell[CellGroupData[{
Cell[18157, 444, 3627, 98, 70, "Input",
 CellID->829809070],
Cell[21787, 544, 3010, 55, 70, "Output",
 Evaluatable->False,
 CellID->118334785]
}, {2}]],
Cell[24809, 602, 110, 3, 70, "Text",
 CellID->1338280749],
Cell[CellGroupData[{
Cell[24944, 609, 53, 1, 70, "Subsection",
 CellID->391204127],
Cell[25000, 612, 2638, 88, 70, "DefinitionBox",
 CellID->1410847087],
Cell[27641, 702, 84, 1, 70, "Caption",
 CellID->1740044682],
Cell[27728, 705, 63, 1, 70, "MathCaption",
 CellID->1639368631],
Cell[CellGroupData[{
Cell[27816, 710, 418, 12, 70, "Input",
 CellID->752842721],
Cell[28237, 724, 327, 11, 64, "Output",
 CellID->1888313412]
}, Open  ]],
Cell[28579, 738, 64, 1, 70, "MathCaption",
 CellID->653390207],
Cell[CellGroupData[{
Cell[28668, 743, 226, 7, 70, "Input",
 CellID->53963723],
Cell[28897, 752, 316, 13, 78, "Output",
 CellID->1150096445]
}, Open  ]],
Cell[29228, 768, 62, 1, 70, "MathCaption",
 CellID->1445321938],
Cell[CellGroupData[{
Cell[29315, 773, 187, 5, 28, "Input",
 CellID->730193427],
Cell[29505, 780, 848, 18, 36, "Output",
 Evaluatable->False,
 CellID->449254694]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30402, 804, 61, 1, 70, "Subsection",
 CellID->721792705],
Cell[30466, 807, 2311, 78, 70, "DefinitionBox",
 CellID->1237732552],
Cell[32780, 887, 96, 1, 70, "Caption",
 CellID->2044396622],
Cell[32879, 890, 79, 1, 70, "MathCaption",
 CellID->170644468],
Cell[CellGroupData[{
Cell[32983, 895, 485, 17, 70, "Input",
 CellID->464408655],
Cell[33471, 914, 941, 23, 140, "Output",
 CellID->2021127198]
}, Open  ]],
Cell[34427, 940, 82, 1, 70, "MathCaption",
 CellID->1130904931],
Cell[CellGroupData[{
Cell[34534, 945, 329, 11, 70, "Input",
 CellID->480907568],
Cell[34866, 958, 777, 20, 210, "Output",
 CellID->1709459933]
}, Open  ]],
Cell[35658, 981, 79, 1, 70, "MathCaption",
 CellID->1888899367],
Cell[CellGroupData[{
Cell[35762, 986, 327, 11, 70, "Input",
 CellID->1856864365],
Cell[36092, 999, 771, 20, 88, "Output",
 CellID->974882228]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[36912, 1025, 67, 1, 70, "Subsection",
 CellID->34871032],
Cell[36982, 1028, 1159, 36, 70, "DefinitionBox",
 CellID->1108212702],
Cell[38144, 1066, 158, 4, 70, "Caption",
 CellID->605212083],
Cell[38305, 1072, 95, 1, 70, "MathCaption",
 CellID->1692863033],
Cell[CellGroupData[{
Cell[38425, 1077, 654, 18, 70, "Input",
 CellID->391961076],
Cell[39082, 1097, 424, 15, 68, "Output",
 CellID->447956663]
}, Open  ]],
Cell[39521, 1115, 84, 1, 70, "MathCaption",
 CellID->2085640175],
Cell[CellGroupData[{
Cell[39630, 1120, 556, 16, 70, "Input",
 CellID->1357458983],
Cell[40189, 1138, 395, 12, 68, "Output",
 CellID->1877452306]
}, Open  ]],
Cell[40599, 1153, 81, 1, 70, "MathCaption",
 CellID->2126334891],
Cell[CellGroupData[{
Cell[40705, 1158, 557, 16, 70, "Input",
 CellID->2094345200],
Cell[41265, 1176, 396, 12, 72, "Output",
 CellID->1363681571]
}, Open  ]],
Cell[41676, 1191, 93, 1, 70, "MathCaption",
 CellID->1035143310],
Cell[CellGroupData[{
Cell[41794, 1196, 569, 17, 70, "Input",
 CellID->255318423],
Cell[42366, 1215, 408, 12, 72, "Output",
 CellID->1450683013]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42835, 1234, 64, 1, 70, "Section",
 CellID->1329116983],
Cell[42902, 1237, 387, 9, 70, "Reference",
 CellID->2045043897],
Cell[CellGroupData[{
Cell[43314, 1250, 137, 4, 22, "BulletedText",
 CellID->888586823],
Cell[43454, 1256, 1104, 22, 88, "Output",
 Evaluatable->False,
 CellID->115730928]
}, Open  ]],
Cell[CellGroupData[{
Cell[44595, 1283, 128, 3, 70, "BulletedText",
 CellID->877452923],
Cell[44726, 1288, 1887, 65, 104, "Output",
 CellID->1287429333]
}, Open  ]],
Cell[CellGroupData[{
Cell[46650, 1358, 96, 1, 22, "BulletedText",
 CellID->581072912],
Cell[46749, 1361, 1091, 21, 90, "Output",
 Evaluatable->False,
 CellID->193492714]
}, Open  ]],
Cell[CellGroupData[{
Cell[47877, 1387, 150, 4, 22, "BulletedText",
 CellID->1484289075],
Cell[48030, 1393, 1459, 27, 88, "Output",
 Evaluatable->False,
 CellID->5753551]
}, Open  ]],
Cell[CellGroupData[{
Cell[49526, 1425, 96, 1, 22, "BulletedText",
 CellID->2077523808],
Cell[49625, 1428, 2385, 43, 104, "Output",
 Evaluatable->False,
 CellID->161313004],
Cell[52013, 1473, 162, 4, 70, "Reference",
 CellID->369446055]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[52224, 1483, 53, 1, 70, "Section",
 CellID->371443994],
Cell[52280, 1486, 480, 8, 70, "Reference",
 CellID->1453167266],
Cell[52763, 1496, 1075, 38, 70, "Reference",
 CellID->1913355813],
Cell[53841, 1536, 1483, 54, 70, "DefinitionBox",
 CellID->1351018913],
Cell[55327, 1592, 63, 1, 70, "Caption",
 CellID->1230271060],
Cell[55393, 1595, 547, 15, 70, "Text",
 CellID->1193152104],
Cell[55943, 1612, 128, 3, 70, "MathCaption",
 CellID->1282256269],
Cell[CellGroupData[{
Cell[56096, 1619, 704, 21, 70, "Input",
 CellID->882715438],
Cell[56803, 1642, 413, 15, 64, "Output",
 CellID->803879320]
}, Open  ]],
Cell[57231, 1660, 122, 3, 70, "MathCaption",
 CellID->1708041672],
Cell[CellGroupData[{
Cell[57378, 1667, 605, 18, 70, "Input",
 CellID->742324325],
Cell[57986, 1687, 397, 15, 64, "Output",
 CellID->980107963]
}, Open  ]],
Cell[58398, 1705, 113, 3, 70, "Reference",
 CellID->1276731036],
Cell[CellGroupData[{
Cell[58536, 1712, 54, 1, 70, "Subsection",
 CellID->1918055409],
Cell[58593, 1715, 144, 4, 70, "Reference",
 CellID->361921228],
Cell[58740, 1721, 92, 1, 70, "MathCaption",
 CellID->1723097556],
Cell[CellGroupData[{
Cell[58857, 1726, 488, 16, 70, "Input",
 CellID->1283643897],
Cell[59348, 1744, 424, 15, 78, "Output",
 CellID->808254961]
}, Open  ]],
Cell[59787, 1762, 88, 1, 70, "MathCaption",
 CellID->227212960],
Cell[CellGroupData[{
Cell[59900, 1767, 479, 16, 70, "Input",
 CellID->2093483687],
Cell[60382, 1785, 425, 15, 78, "Output",
 CellID->1606122250]
}, Open  ]],
Cell[60822, 1803, 172, 4, 70, "Reference",
 CellID->477039903],
Cell[60997, 1809, 111, 3, 70, "MathCaption",
 CellID->14841573],
Cell[CellGroupData[{
Cell[61133, 1816, 556, 18, 28, "Input",
 CellID->1053195470],
Cell[61692, 1836, 530, 13, 78, "Output",
 Evaluatable->False,
 CellID->870947158]
}, Open  ]],
Cell[62237, 1852, 464, 15, 70, "Reference",
 CellID->334214359],
Cell[62704, 1869, 183, 7, 70, "MathCaption",
 CellID->169044342],
Cell[CellGroupData[{
Cell[62912, 1880, 461, 15, 28, "Input",
 CellID->542294354],
Cell[63376, 1897, 509, 12, 78, "Output",
 Evaluatable->False,
 CellID->745192205]
}, Open  ]],
Cell[63900, 1912, 287, 11, 70, "MathCaption",
 CellID->7391013],
Cell[CellGroupData[{
Cell[64212, 1927, 587, 19, 47, "Input",
 CellID->1814187612],
Cell[64802, 1948, 496, 12, 78, "Output",
 Evaluatable->False,
 CellID->99432816]
}, Open  ]],
Cell[65313, 1963, 254, 5, 70, "Reference",
 CellID->1240574307],
Cell[65570, 1970, 95, 1, 70, "MathCaption",
 CellID->413649026],
Cell[CellGroupData[{
Cell[65690, 1975, 866, 24, 65, "Input",
 CellID->2034987855],
Cell[66559, 2001, 513, 12, 78, "Output",
 Evaluatable->False,
 CellID->191615694]
}, Open  ]],
Cell[67087, 2016, 163, 4, 70, "Reference",
 CellID->794614643]
}, Open  ]],
Cell[CellGroupData[{
Cell[67287, 2025, 53, 1, 70, "Subsection",
 CellID->136845998],
Cell[67343, 2028, 190, 4, 70, "Reference",
 CellID->1908025176],
Cell[67536, 2034, 93, 1, 70, "MathCaption",
 CellID->928512228],
Cell[CellGroupData[{
Cell[67654, 2039, 489, 15, 47, "Input",
 CellID->1888836894],
Cell[68146, 2056, 591, 14, 78, "Output",
 Evaluatable->False,
 CellID->854084220]
}, Open  ]],
Cell[68752, 2073, 117, 3, 70, "Reference",
 CellID->1953316028],
Cell[68872, 2078, 92, 1, 70, "MathCaption",
 CellID->1857006039],
Cell[CellGroupData[{
Cell[68989, 2083, 465, 15, 28, "Input",
 CellID->1320655622],
Cell[69457, 2100, 513, 12, 78, "Output",
 Evaluatable->False,
 CellID->348386497]
}, Open  ]],
Cell[69985, 2115, 103, 2, 70, "Reference",
 CellID->799970907],
Cell[70091, 2119, 99, 1, 70, "MathCaption",
 CellID->894893885],
Cell[CellGroupData[{
Cell[70215, 2124, 514, 16, 28, "Input",
 CellID->1653545254],
Cell[70732, 2142, 558, 13, 78, "Output",
 Evaluatable->False,
 CellID->420381488]
}, Open  ]],
Cell[71305, 2158, 71, 1, 70, "MathCaption",
 CellID->1863403729],
Cell[CellGroupData[{
Cell[71401, 2163, 515, 16, 28, "Input",
 CellID->1472449102],
Cell[71919, 2181, 558, 13, 78, "Output",
 Evaluatable->False,
 CellID->600125041]
}, Open  ]],
Cell[72492, 2197, 70, 1, 70, "MathCaption",
 CellID->649762780],
Cell[CellGroupData[{
Cell[72587, 2202, 486, 15, 28, "Input",
 CellID->608698465],
Cell[73076, 2219, 549, 13, 78, "Output",
 Evaluatable->False,
 CellID->25078377]
}, Open  ]],
Cell[73640, 2235, 272, 5, 70, "Reference",
 CellID->588090713],
Cell[73915, 2242, 91, 1, 70, "MathCaption",
 CellID->802370369],
Cell[CellGroupData[{
Cell[74031, 2247, 505, 15, 47, "Input",
 CellID->1321899840],
Cell[74539, 2264, 505, 12, 78, "Output",
 Evaluatable->False,
 CellID->209080339]
}, Open  ]],
Cell[75059, 2279, 89, 1, 70, "MathCaption",
 CellID->1916389725],
Cell[CellGroupData[{
Cell[75173, 2284, 438, 14, 28, "Input",
 CellID->1101149882],
Cell[75614, 2300, 505, 12, 78, "Output",
 Evaluatable->False,
 CellID->671565046]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[76168, 2318, 53, 1, 70, "Subsection",
 CellID->2078971978],
Cell[76224, 2321, 226, 5, 70, "Reference",
 CellID->1881384116],
Cell[76453, 2328, 135, 4, 70, "MathCaption",
 CellID->564356657],
Cell[CellGroupData[{
Cell[76613, 2336, 687, 22, 47, "Input",
 CellID->105116242],
Cell[77303, 2360, 543, 13, 78, "Output",
 Evaluatable->False,
 CellID->383952544]
}, Open  ]],
Cell[77861, 2376, 97, 1, 70, "MathCaption",
 CellID->1854549047],
Cell[CellGroupData[{
Cell[77983, 2381, 565, 18, 28, "Input",
 CellID->828180371],
Cell[78551, 2401, 522, 13, 78, "Output",
 Evaluatable->False,
 CellID->296845443]
}, Open  ]],
Cell[79088, 2417, 6977, 242, 70, "DefinitionBox",
 CellID->160662587],
Cell[86068, 2661, 298, 13, 70, "Caption",
 CellID->869155430]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[86415, 2680, 72, 1, 70, "Section",
 CellID->318460735],
Cell[86490, 2683, 318, 8, 70, "Text",
 CellID->1486803875],
Cell[86811, 2693, 2857, 61, 70, "Text",
 CellID->1851162788],
Cell[89671, 2756, 60, 1, 70, "Caption",
 CellID->133908131],
Cell[89734, 2759, 354, 7, 70, "DefinitionBox",
 CellID->1226602520],
Cell[90091, 2768, 70, 1, 70, "Caption",
 CellID->1813026087],
Cell[90164, 2771, 1060, 34, 70, "Reference",
 CellID->898608130],
Cell[CellGroupData[{
Cell[91249, 2809, 62, 1, 70, "Subsection",
 CellID->936898809],
Cell[91314, 2812, 249, 5, 50, "Reference",
 CellID->957516544],
Cell[91566, 2819, 5652, 97, 476, "Output",
 Evaluatable->False,
 CellID->112730536],
Cell[97221, 2918, 2245, 40, 98, "Output",
 Evaluatable->False,
 CellID->29216796],
Cell[99469, 2960, 208, 8, 70, "Reference",
 CellID->1394307527]
}, Open  ]],
Cell[CellGroupData[{
Cell[99714, 2973, 60, 1, 70, "Subsection",
 CellID->667464371],
Cell[99777, 2976, 223, 5, 70, "Reference",
 CellID->927041632],
Cell[100003, 2983, 967, 36, 70, "DefinitionBox",
 CellID->221534826],
Cell[100973, 3021, 330, 13, 70, "Caption",
 CellID->1746660331],
Cell[101306, 3036, 218, 7, 70, "Reference",
 CellID->199604407],
Cell[101527, 3045, 495, 19, 70, "Reference",
 CellID->1833968764],
Cell[102025, 3066, 416, 7, 70, "Reference",
 CellID->721448903],
Cell[102444, 3075, 89, 1, 70, "MathCaption",
 CellID->680231157],
Cell[CellGroupData[{
Cell[102558, 3080, 293, 9, 70, "Input",
 CellID->2052432992],
Cell[102854, 3091, 226, 8, 71, "Output",
 CellID->890324114]
}, Open  ]],
Cell[103095, 3102, 120, 3, 70, "MathCaption",
 CellID->1589602718],
Cell[CellGroupData[{
Cell[103240, 3109, 544, 16, 70, "Input",
 CellID->70489711],
Cell[103787, 3127, 420, 15, 72, "Output",
 CellID->2059294423]
}, Open  ]],
Cell[104222, 3145, 141, 4, 70, "MathCaption",
 CellID->1164355293],
Cell[CellGroupData[{
Cell[104388, 3153, 622, 18, 70, "Input",
 CellID->1699926103],
Cell[105013, 3173, 403, 14, 56, "Output",
 CellID->710304924]
}, Open  ]],
Cell[CellGroupData[{
Cell[105453, 3192, 645, 19, 70, "Input",
 CellID->1714912309],
Cell[106101, 3213, 423, 15, 102, "Output",
 CellID->1153150976]
}, Open  ]],
Cell[106539, 3231, 141, 4, 70, "MathCaption",
 CellID->699041759],
Cell[CellGroupData[{
Cell[106705, 3239, 610, 18, 70, "Input",
 CellID->366228389],
Cell[107318, 3259, 397, 15, 64, "Output",
 CellID->149119681]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[107764, 3280, 49, 1, 70, "Subsection",
 CellID->479682576],
Cell[107816, 3283, 284, 9, 70, "Reference",
 CellID->1368035365],
Cell[108103, 3294, 131, 4, 70, "Reference",
 CellID->1610454773],
Cell[108237, 3300, 385, 12, 70, "DefinitionBox",
 CellID->29483023],
Cell[108625, 3314, 89, 1, 70, "Caption",
 CellID->1599928751],
Cell[108717, 3317, 112, 3, 70, "MathCaption",
 CellID->200142416],
Cell[CellGroupData[{
Cell[108854, 3324, 411, 13, 28, "Input",
 CellID->1359773970],
Cell[109268, 3339, 416, 11, 64, "Output",
 Evaluatable->False,
 CellID->94001]
}, Open  ]],
Cell[109699, 3353, 70, 1, 70, "MathCaption",
 CellID->1077774513],
Cell[CellGroupData[{
Cell[109794, 3358, 430, 14, 28, "Input",
 CellID->131677546],
Cell[110227, 3374, 464, 12, 66, "Output",
 Evaluatable->False,
 CellID->98908696]
}, Open  ]],
Cell[110706, 3389, 925, 30, 70, "Reference",
 CellID->319889223]
}, Open  ]],
Cell[CellGroupData[{
Cell[111668, 3424, 48, 1, 70, "Subsection",
 CellID->1766595116],
Cell[111719, 3427, 554, 19, 70, "Reference",
 CellID->883976926],
Cell[112276, 3448, 227, 7, 70, "MathCaption",
 CellID->1561618257],
Cell[CellGroupData[{
Cell[112528, 3459, 366, 13, 70, "Input",
 CellID->1322066831],
Cell[112897, 3474, 302, 13, 48, "Output",
 CellID->718551404]
}, Open  ]],
Cell[113214, 3490, 275, 9, 70, "MathCaption",
 CellID->1720395412],
Cell[CellGroupData[{
Cell[113514, 3503, 524, 18, 70, "Input",
 CellID->965866276],
Cell[114041, 3523, 361, 13, 48, "Output",
 CellID->1392899947]
}, Open  ]],
Cell[114417, 3539, 77, 1, 70, "MathCaption",
 CellID->750173282],
Cell[CellGroupData[{
Cell[114519, 3544, 595, 19, 47, "Input",
 CellID->511916520],
Cell[115117, 3565, 627, 14, 94, "Output",
 Evaluatable->False,
 CellID->175037253]
}, Open  ]],
Cell[115759, 3582, 89, 1, 70, "MathCaption",
 CellID->927268547],
Cell[CellGroupData[{
Cell[115873, 3587, 617, 20, 47, "Input",
 CellID->313643150],
Cell[116493, 3609, 496, 12, 94, "Output",
 Evaluatable->False,
 CellID->70639977]
}, Open  ]],
Cell[CellGroupData[{
Cell[117026, 3626, 603, 20, 70, "Input",
 CellID->880500799],
Cell[117632, 3648, 465, 16, 96, "Output",
 CellID->477681304]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[118158, 3671, 59, 1, 70, "Section",
 CellID->1180142567],
Cell[118220, 3674, 199, 6, 70, "Text",
 CellID->1566010054],
Cell[118422, 3682, 547, 17, 70, "DefinitionBox",
 CellID->371399946],
Cell[118972, 3701, 80, 1, 70, "Caption",
 CellID->1531414240],
Cell[119055, 3704, 243, 8, 70, "MathCaption",
 CellID->1962882457],
Cell[CellGroupData[{
Cell[119323, 3716, 282, 9, 70, "Input",
 CellID->756909504],
Cell[119608, 3727, 425, 13, 84, "Output",
 CellID->895705225]
}, Open  ]],
Cell[120048, 3743, 78, 1, 70, "MathCaption",
 CellID->555973744],
Cell[CellGroupData[{
Cell[120151, 3748, 403, 13, 70, "Input",
 CellID->1379549489],
Cell[120557, 3763, 443, 14, 86, "Output",
 CellID->880083493]
}, Open  ]],
Cell[121015, 3780, 389, 12, 70, "Reference",
 CellID->884357299],
Cell[CellGroupData[{
Cell[121429, 3796, 342, 11, 70, "Input",
 CellID->850545873],
Cell[121774, 3809, 412, 13, 78, "Output",
 CellID->1822608843]
}, Open  ]],
Cell[122201, 3825, 142, 4, 70, "Reference",
 CellID->791400608],
Cell[CellGroupData[{
Cell[122368, 3833, 338, 11, 70, "Input",
 CellID->360992124],
Cell[122709, 3846, 421, 13, 78, "Output",
 CellID->109420920]
}, Open  ]],
Cell[CellGroupData[{
Cell[123167, 3864, 336, 11, 70, "Input",
 CellID->1355129248],
Cell[123506, 3877, 419, 13, 84, "Output",
 CellID->1997228911]
}, Open  ]],
Cell[123940, 3893, 86, 1, 70, "MathCaption",
 CellID->1310976635],
Cell[CellGroupData[{
Cell[124051, 3898, 308, 9, 70, "Input",
 CellID->1703792785],
Cell[124362, 3909, 454, 14, 82, "Output",
 CellID->565857593]
}, Open  ]],
Cell[CellGroupData[{
Cell[124853, 3928, 70, 1, 70, "Subsection",
 CellID->1184197524],
Cell[124926, 3931, 464, 17, 70, "MathCaption",
 CellID->402086225],
Cell[CellGroupData[{
Cell[125415, 3952, 389, 12, 70, "Input",
 CellID->1458861821],
Cell[125807, 3966, 454, 14, 78, "Output",
 CellID->670047846]
}, Open  ]],
Cell[CellGroupData[{
Cell[126298, 3985, 385, 12, 70, "Input",
 CellID->302476750],
Cell[126686, 3999, 450, 14, 84, "Output",
 CellID->89902854]
}, Open  ]],
Cell[127151, 4016, 325, 12, 70, "MathCaption",
 CellID->1450981671],
Cell[CellGroupData[{
Cell[127501, 4032, 568, 19, 28, "Input",
 CellID->1972132812],
Cell[128072, 4053, 542, 13, 78, "Output",
 Evaluatable->False,
 CellID->722176183]
}, Open  ]],
Cell[CellGroupData[{
Cell[128651, 4071, 565, 19, 70, "Input",
 CellID->1047796870],
Cell[129219, 4092, 529, 16, 84, "Output",
 CellID->1048102585]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[129797, 4114, 52, 1, 70, "Subsection",
 CellID->340090734],
Cell[129852, 4117, 516, 18, 70, "Reference",
 CellID->2017085571],
Cell[130371, 4137, 83, 1, 70, "MathCaption",
 CellID->1416766816],
Cell[CellGroupData[{
Cell[130479, 4142, 539, 17, 28, "Input",
 CellID->625510853],
Cell[131021, 4161, 510, 12, 84, "Output",
 Evaluatable->False,
 CellID->301079749]
}, Open  ]],
Cell[131546, 4176, 95, 1, 70, "MathCaption",
 CellID->943687172],
Cell[CellGroupData[{
Cell[131666, 4181, 1328, 41, 70, "Input",
 CellID->1201458272],
Cell[132997, 4224, 750, 25, 92, "Output",
 CellID->2047237858]
}, Open  ]],
Cell[133762, 4252, 223, 8, 70, "MathCaption",
 CellID->1383566709],
Cell[CellGroupData[{
Cell[134010, 4264, 1431, 43, 101, "Input",
 CellID->1396679853],
Cell[135444, 4309, 824, 18, 92, "Output",
 Evaluatable->False,
 CellID->366543198]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[136329, 4334, 64, 1, 70, "Section",
 CellID->712604389],
Cell[136396, 4337, 221, 6, 70, "Text",
 CellID->430373609],
Cell[136620, 4345, 234, 10, 70, "Text",
 CellID->1295044017],
Cell[136857, 4357, 72, 1, 70, "MathCaption",
 CellID->1316263337],
Cell[CellGroupData[{
Cell[136954, 4362, 400, 13, 70, "Input",
 CellID->1168705658],
Cell[137357, 4377, 301, 12, 64, "Output",
 CellID->1147375112]
}, Open  ]],
Cell[137673, 4392, 176, 4, 70, "Text",
 CellID->1180333776],
Cell[137852, 4398, 105, 2, 70, "MathCaption",
 CellID->1208857212],
Cell[CellGroupData[{
Cell[137982, 4404, 480, 16, 70, "Input",
 CellID->355862606],
Cell[138465, 4422, 304, 12, 64, "Output",
 CellID->240862147]
}, Open  ]],
Cell[138784, 4437, 131, 4, 70, "Text",
 CellID->163430034],
Cell[138918, 4443, 295, 11, 70, "MathCaption",
 CellID->2067861464],
Cell[CellGroupData[{
Cell[139238, 4458, 826, 26, 70, "Input",
 CellID->136996925],
Cell[140067, 4486, 428, 15, 64, "Output",
 CellID->404848891]
}, Open  ]],
Cell[140510, 4504, 470, 17, 70, "Text",
 CellID->523392663],
Cell[CellGroupData[{
Cell[141005, 4525, 705, 22, 70, "Input",
 CellID->475413376],
Cell[141713, 4549, 436, 18, 64, "Output",
 CellID->1067117341]
}, Open  ]],
Cell[142164, 4570, 106, 3, 70, "Text",
 CellID->1405214090],
Cell[142273, 4575, 59, 1, 70, "MathCaption",
 CellID->1819766047],
Cell[CellGroupData[{
Cell[142357, 4580, 257, 7, 70, "Input",
 CellID->571686219],
Cell[142617, 4589, 321, 13, 78, "Output",
 CellID->1630347551]
}, Open  ]],
Cell[142953, 4605, 267, 8, 70, "Text",
 CellID->1507437584],
Cell[143223, 4615, 60, 1, 70, "MathCaption",
 CellID->345851355],
Cell[CellGroupData[{
Cell[143308, 4620, 323, 12, 70, "Input",
 CellID->1209545181],
Cell[143634, 4634, 287, 12, 48, "Output",
 CellID->745654565]
}, Open  ]],
Cell[143936, 4649, 125, 3, 70, "MathCaption",
 CellID->1632974703],
Cell[CellGroupData[{
Cell[144086, 4656, 454, 15, 70, "Input",
 CellID->427252141],
Cell[144543, 4673, 390, 14, 61, "Output",
 CellID->1570558057]
}, Open  ]],
Cell[144948, 4690, 227, 7, 70, "MathCaption",
 CellID->564824661],
Cell[CellGroupData[{
Cell[145200, 4701, 505, 17, 70, "Input",
 CellID->1414811116],
Cell[145708, 4720, 390, 14, 56, "Output",
 CellID->1647758722]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[146147, 4740, 59, 1, 70, "Section",
 CellID->360262780],
Cell[CellGroupData[{
Cell[146231, 4745, 55, 1, 70, "Subsection",
 CellID->1144944047],
Cell[146289, 4748, 269, 8, 70, "Text",
 CellID->475589992],
Cell[146561, 4758, 151, 4, 70, "Reference",
 CellID->1980647432],
Cell[CellGroupData[{
Cell[146737, 4766, 395, 13, 70, "Input",
 CellID->306861410],
Cell[147135, 4781, 379, 15, 36, "Output",
 CellID->458984945]
}, Open  ]],
Cell[147529, 4799, 166, 4, 70, "Reference",
 CellID->597377477],
Cell[CellGroupData[{
Cell[147720, 4807, 243, 8, 70, "Input",
 CellID->567979521],
Cell[147966, 4817, 282, 11, 36, "Output",
 CellID->398710591]
}, Open  ]],
Cell[148263, 4831, 123, 3, 70, "Reference",
 CellID->1130357687],
Cell[148389, 4836, 69, 1, 70, "MathCaption",
 CellID->637206214],
Cell[CellGroupData[{
Cell[148483, 4841, 424, 14, 70, "Input",
 CellID->23891109],
Cell[148910, 4857, 478, 15, 94, "Output",
 CellID->979924297]
}, Open  ]],
Cell[CellGroupData[{
Cell[149425, 4877, 457, 15, 28, "Input",
 CellID->632750702],
Cell[149885, 4894, 485, 12, 94, "Output",
 Evaluatable->False,
 CellID->168341686]
}, Open  ]],
Cell[150385, 4909, 86, 1, 70, "MathCaption",
 CellID->1843502978],
Cell[CellGroupData[{
Cell[150496, 4914, 435, 13, 70, "Input",
 CellID->1020378439],
Cell[150934, 4929, 534, 16, 94, "Output",
 CellID->1235076075]
}, Open  ]],
Cell[151483, 4948, 105, 2, 70, "MathCaption",
 CellID->224392985],
Cell[CellGroupData[{
Cell[151613, 4954, 481, 12, 70, "Input",
 CellID->1052407374],
Cell[152097, 4968, 446, 14, 36, "Output",
 CellID->1979427333]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[152592, 4988, 88, 1, 70, "Subsection",
 CellID->1345165277],
Cell[152683, 4991, 122, 3, 70, "MathCaption",
 CellID->2103074872],
Cell[CellGroupData[{
Cell[152830, 4998, 520, 18, 70, "Input",
 CellID->665413170],
Cell[153353, 5018, 444, 14, 64, "Output",
 CellID->346660623]
}, Open  ]],
Cell[153812, 5035, 115, 3, 70, "MathCaption",
 CellID->946027731],
Cell[CellGroupData[{
Cell[153952, 5042, 562, 19, 70, "Input",
 CellID->103853618],
Cell[154517, 5063, 469, 14, 64, "Output",
 CellID->201956450]
}, Open  ]],
Cell[155001, 5080, 94, 1, 70, "MathCaption",
 CellID->2066636176],
Cell[CellGroupData[{
Cell[155120, 5085, 660, 21, 47, "Input",
 CellID->443916251],
Cell[155783, 5108, 550, 13, 64, "Output",
 Evaluatable->False,
 CellID->300752868]
}, Open  ]],
Cell[156348, 5124, 231, 8, 70, "MathCaption",
 CellID->1047308927],
Cell[CellGroupData[{
Cell[156604, 5136, 1057, 33, 65, "Input",
 CellID->1291273001],
Cell[157664, 5171, 583, 14, 64, "Output",
 Evaluatable->False,
 CellID->152542255]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[158308, 5192, 59, 1, 70, "Section",
 CellID->840324821],
Cell[158370, 5195, 162, 4, 70, "Text",
 CellID->2079212589],
Cell[158535, 5201, 141, 4, 70, "Text",
 CellID->78353486],
Cell[158679, 5207, 83, 1, 70, "MathCaption",
 CellID->519146746],
Cell[CellGroupData[{
Cell[158787, 5212, 554, 16, 70, "Input",
 CellID->73302261],
Cell[159344, 5230, 395, 12, 68, "Output",
 CellID->1482970896]
}, Open  ]],
Cell[159754, 5245, 80, 1, 70, "MathCaption",
 CellID->596641990],
Cell[CellGroupData[{
Cell[159859, 5250, 557, 16, 70, "Input",
 CellID->1160778087],
Cell[160419, 5268, 396, 12, 72, "Output",
 CellID->1455858861]
}, Open  ]],
Cell[160830, 5283, 92, 1, 70, "MathCaption",
 CellID->191202909],
Cell[CellGroupData[{
Cell[160947, 5288, 569, 17, 70, "Input",
 CellID->911755651],
Cell[161519, 5307, 408, 12, 72, "Output",
 CellID->1581405012]
}, Open  ]],
Cell[161942, 5322, 233, 5, 70, "Text",
 CellID->1416421412],
Cell[162178, 5329, 87, 1, 70, "MathCaption",
 CellID->904622908],
Cell[CellGroupData[{
Cell[162290, 5334, 572, 17, 70, "Input",
 CellID->1316623055],
Cell[162865, 5353, 412, 12, 72, "Output",
 CellID->812186697]
}, Open  ]],
Cell[163292, 5368, 179, 4, 70, "Text",
 CellID->690672098],
Cell[CellGroupData[{
Cell[163496, 5376, 346, 12, 28, "Input",
 CellID->221448842],
Cell[163845, 5390, 512, 12, 64, "Output",
 Evaluatable->False,
 CellID->200031664]
}, Open  ]],
Cell[CellGroupData[{
Cell[164394, 5407, 470, 17, 70, "Input",
 CellID->2071728250],
Cell[164867, 5426, 306, 15, 64, "Output",
 CellID->1807756773]
}, Open  ]],
Cell[165188, 5444, 455, 14, 70, "Text",
 CellID->960526072]
}, Open  ]],
Cell[CellGroupData[{
Cell[165680, 5463, 57, 1, 70, "Section",
 CellID->796889411],
Cell[CellGroupData[{
Cell[165762, 5468, 56, 1, 70, "Subsection",
 CellID->224259477],
Cell[165821, 5471, 320, 8, 70, "Reference",
 CellID->687557352],
Cell[CellGroupData[{
Cell[166166, 5483, 540, 17, 70, "Input",
 CellID->1042654578],
Cell[166709, 5502, 493, 16, 90, "Output",
 CellID->805295005]
}, Open  ]],
Cell[167217, 5521, 234, 5, 70, "Reference",
 CellID->1647791508],
Cell[167454, 5528, 177, 4, 70, "Reference",
 CellID->1427597182],
Cell[167634, 5534, 255, 8, 70, "Reference",
 CellID->302340726],
Cell[CellGroupData[{
Cell[167914, 5546, 490, 16, 70, "Input",
 CellID->1177663577],
Cell[168407, 5564, 599, 21, 70, "Output",
 CellID->1633032464]
}, Open  ]],
Cell[169021, 5588, 221, 7, 70, "Reference",
 CellID->780908964],
Cell[169245, 5597, 73, 1, 70, "MathCaption",
 CellID->1281304047],
Cell[CellGroupData[{
Cell[169343, 5602, 539, 17, 70, "Input",
 CellID->1464391131],
Cell[169885, 5621, 667, 24, 70, "Output",
 CellID->1535613788]
}, Open  ]],
Cell[170567, 5648, 104, 2, 70, "MathCaption",
 CellID->903401503],
Cell[CellGroupData[{
Cell[170696, 5654, 501, 16, 70, "Input",
 CellID->1601576718],
Cell[171200, 5672, 498, 15, 72, "Output",
 CellID->1315099214]
}, Open  ]],
Cell[171713, 5690, 256, 8, 70, "Reference",
 CellID->1938533590],
Cell[171972, 5700, 263, 9, 70, "Reference",
 CellID->1699814378],
Cell[172238, 5711, 97, 1, 70, "MathCaption",
 CellID->2058589460],
Cell[CellGroupData[{
Cell[172360, 5716, 574, 17, 70, "Input",
 CellID->1438452170],
Cell[172937, 5735, 534, 17, 72, "Output",
 CellID->1842206911]
}, Open  ]],
Cell[CellGroupData[{
Cell[173508, 5757, 66, 1, 70, "Subsubsection",
 CellID->470795355],
Cell[173577, 5760, 184, 4, 70, "Reference",
 CellID->355827595],
Cell[CellGroupData[{
Cell[173786, 5768, 504, 16, 70, "Input",
 CellID->1714500359],
Cell[174293, 5786, 561, 15, 240, "Output",
 CellID->818160503]
}, Open  ]],
Cell[174869, 5804, 346, 12, 70, "MathCaption",
 CellID->485782180],
Cell[CellGroupData[{
Cell[175240, 5820, 366, 12, 70, "Input",
 CellID->1023416509],
Cell[175609, 5834, 940, 20, 184, "Output",
 CellID->476604828]
}, Open  ]],
Cell[176564, 5857, 319, 12, 70, "MathCaption",
 CellID->727823981],
Cell[CellGroupData[{
Cell[176908, 5873, 361, 12, 70, "Input",
 CellID->1332832276],
Cell[177272, 5887, 729, 18, 56, "Output",
 CellID->1182967301]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[178062, 5912, 65, 1, 70, "Subsection",
 CellID->1480420842],
Cell[178130, 5915, 248, 7, 70, "Reference",
 CellID->295229454],
Cell[178381, 5924, 537, 15, 70, "Input",
 CellID->2021953202],
Cell[CellGroupData[{
Cell[178943, 5943, 178, 5, 28, "Input",
 CellID->602465270],
Cell[179124, 5950, 5110, 88, 81, "Output",
 Evaluatable->False,
 CellID->895976088]
}, Open  ]],
Cell[184249, 6041, 156, 4, 70, "Reference",
 CellID->1804617922],
Cell[184408, 6047, 280, 8, 70, "Reference",
 CellID->1940030075],
Cell[CellGroupData[{
Cell[184713, 6059, 170, 5, 70, "Input",
 CellID->965654002],
Cell[184886, 6066, 1857, 57, 502, "Output",
 CellID->1301868473]
}, Open  ]],
Cell[186758, 6126, 484, 17, 70, "Reference",
 CellID->841258124],
Cell[CellGroupData[{
Cell[187267, 6147, 229, 6, 28, "Input",
 CellID->1907887772],
Cell[187499, 6155, 5467, 94, 88, "Output",
 Evaluatable->False,
 CellID->76931600]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[193017, 6255, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

