(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     41248,        957]
NotebookOptionsPosition[     36253,        812]
NotebookOutlinePosition[     39360,        888]
CellTagsIndexPosition[     39268,        882]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Files and External Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FilesAndExternalOperationsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Files and External Operations\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Export" :> Documentation`HelpLookup["paclet:ref/Export"], 
          "Import" :> Documentation`HelpLookup["paclet:ref/Import"], 
          "$ExportFormats" :> 
          Documentation`HelpLookup["paclet:ref/$ExportFormats"], 
          "$ImportFormats" :> 
          Documentation`HelpLookup["paclet:ref/$ImportFormats"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Export\"\>", 2->"\<\"Import\"\>", 
       3->"\<\"$ExportFormats\"\>", 
       4->"\<\"$ImportFormats\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Importing and Exporting Data", "Title",
 CellTags->{"S1.11.3", "3.1"},
 CellID->21778],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Import",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<Table\>\"", "]"}], Cell[
    "import a table of data from a file", "TableText"]},
   {
    RowBox[{
     ButtonBox["Export",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Export"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     StyleBox["list", "TI"], ",", "\"\<Table\>\"", "]"}], Cell[TextData[{
     "export ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " to a file as a table of data"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->27440],

Cell["Importing and exporting tabular data. ", "Caption",
 CellID->18456],

Cell[TextData[{
 "This exports an array of numbers to the file ",
 Cell[BoxData[
  RowBox[{"out", ".", "dat"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->22148],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<out.dat\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5.7", ",", "4.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.2"}], ",", "7.8"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29444],

Cell[BoxData["\<\"out.dat\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->273680154]
}, Open  ]],

Cell[TextData[{
 "Here are the contents of the file ",
 Cell[BoxData[
  RowBox[{"out", ".", "dat"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->16125],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<out.dat\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7210],

Cell["\<\
5.7   4.3
-1.2   7.8\
\>", "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->311913267]
}, Open  ]],

Cell[TextData[{
 "This imports the contents of ",
 Cell[BoxData[
  RowBox[{"out", ".", "dat"}]], "InlineFormula"],
 " as a table of data. "
}], "MathCaption",
 CellID->25616],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<out.dat\>\"", ",", "\"\<Table\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->31180],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5.7`", ",", "4.299999999999999`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.2`"}], ",", "7.799999999999999`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->24815]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    ButtonBox["\"\<Table\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/Table"]}], "]"}]], "InlineFormula"],
 " will handle many kinds of tabular data, automatically deducing the details \
of the format whenever possible. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    StyleBox["list", "TI"], ",", 
    ButtonBox["\"\<Table\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/Table"]}], "]"}]], "InlineFormula"],
 " writes out data separated by spaces, with numbers given in C or Fortran\
\[Hyphen]like form, as in ",
 Cell[BoxData[
  RowBox[{"2.3", "E5"}]], "InlineFormula"],
 " and so on. "
}], "Text",
 CellID->6064],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Import",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\)\>\"", "]"}], Cell[
    "import data assuming a format deduced from the file name", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["Export",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Export"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\)\>\"", ",", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "export data in a format deduced from the file name", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->16226],

Cell["Importing and exporting general data. ", "Caption",
 CellID->29472],

Cell[BoxData[GridBox[{
   {Cell["table formats", "TableText"], Cell[
    "\"CSV\", \"TSV\", \"XLS\"", "TableText"]},
   {Cell["matrix formats", "TableText"], Cell[
    "\"HarwellBoeing\", \"MAT\", \"MTX\"", "TableText"]},
   {Cell["specialized data formats", "TableText"], Cell[
    "\"DIF\", \"FITS\", \"HDF5\", \"MPS\", \"SDTS\", etc.", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->27479],

Cell["Some common formats for tabular data. ", "Caption",
 CellID->19593],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " can handle not only tabular data, but also data corresponding to graphics, \
sounds, expressions and even whole documents. ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " can often deduce the appropriate format for data simply by looking at the \
extension of the file name for the file in which the data is being stored. \
\"",
 ButtonBox["Exporting Graphics and Sounds\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ExportingGraphicsAndSounds"],
 " and \"",
 ButtonBox["Importing and Exporting Files\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ImportingAndExportingFiles"],
 " discuss in more detail how ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " work. Note that you can also use ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " to manipulate raw files of binary data. "
}], "Text",
 CellID->32482],

Cell["This imports a graphic in JPEG format. ", "MathCaption",
 CellID->3005],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/turtle.jpg\>\"", "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->18536],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJxlvAd0o9d1Lurc99a766771stayU2uc1N8HTuxbPXRdE4jh72DJAiQAEES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   "], {{0, 0}, {200, 119}}, {0, 255},
   ColorFunction->GrayLevel],
  ImageSize->{201, 120},
  PlotRange->{{0, 200}, {0, 119}}]], "Output",
 ImageSize->{205, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->15333]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    ButtonBox["$ImportFormats",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$ImportFormats"], Cell[
    "import formats supported on your system", "TableText"]},
   {
    ButtonBox["$ExportFormats",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$ExportFormats"], Cell[
    "export formats supported on your system", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->11105],

Cell["\<\
Finding the complete list of supported import and export formats. \
\>", "Caption",
 CellID->27587],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->295432803],

Cell[TextData[ButtonBox["Files and External Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FilesAndExternalOperationsOverview"]], "RelatedTutorials",
 CellID->16088632]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->246539207],

Cell[TextData[{
 ButtonBox["M101: A First Course in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->529213904]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Importing and Exporting Data - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Files and External Operations", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/FilesAndExternalOperationsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/FindingAndManipulatingFiles"],
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ExportingGraphicsAndSounds"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 37, 3.9108602}", "context" -> "", 
    "keywords" -> {
     "astronomical data", "comma-separated values", "CSV format", 
      "ddf format", "DIF format", "excel format", "export", "external data", 
      "files", "FITS format", "flexible image transport system", 
      "foreign data", "formats", "GIS data", "HarwellBoeing format", "HDF", 
      "hierarchical Data Format", "import", "lotus 1-2-3 format", 
      "MAT format", "matrices", "matrix market format", "MTX format", 
      "reading files", "SDTS importing", "spreadsheets", "tab-delimited data",
       "tabular data", "terrain data", "TSV format", "writing", "XLS format", 
      "$ExportFormats", "$ImportFormats"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Importing and exporting tabular data. This exports an array of numbers \
to the file out.dat. Here are the contents of the file out.dat. ", 
    "synonyms" -> {"1.11.3"}, "title" -> "Importing and Exporting Data", 
    "type" -> "Tutorial", "uri" -> "tutorial/ImportingAndExportingData"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.11.3"->{
  Cell[2177, 65, 92, 2, 70, "Title",
   CellTags->{"S1.11.3", "3.1"},
   CellID->21778]},
 "3.1"->{
  Cell[2177, 65, 92, 2, 70, "Title",
   CellTags->{"S1.11.3", "3.1"},
   CellID->21778]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.11.3", 39055, 871},
 {"3.1", 39155, 875}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1552, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2177, 65, 92, 2, 70, "Title",
 CellTags->{"S1.11.3", "3.1"},
 CellID->21778],
Cell[2272, 69, 971, 28, 70, "DefinitionBox",
 CellID->27440],
Cell[3246, 99, 73, 1, 70, "Caption",
 CellID->18456],
Cell[3322, 102, 171, 6, 70, "MathCaption",
 CellID->22148],
Cell[CellGroupData[{
Cell[3518, 112, 321, 11, 28, "Input",
 CellID->29444],
Cell[3842, 125, 172, 5, 36, "Output",
 CellID->273680154]
}, Open  ]],
Cell[4029, 133, 160, 6, 70, "MathCaption",
 CellID->16125],
Cell[CellGroupData[{
Cell[4214, 143, 114, 3, 70, "Input",
 CellID->7210],
Cell[4331, 148, 109, 5, 70, "Print",
 CellID->311913267]
}, Open  ]],
Cell[4455, 156, 174, 6, 70, "MathCaption",
 CellID->25616],
Cell[CellGroupData[{
Cell[4654, 166, 148, 4, 70, "Input",
 CellID->31180],
Cell[4805, 172, 363, 13, 36, "Output",
 CellID->24815]
}, Open  ]],
Cell[5183, 188, 988, 30, 70, "Text",
 CellID->6064],
Cell[6174, 220, 944, 27, 70, "DefinitionBox",
 CellID->16226],
Cell[7121, 249, 73, 1, 70, "Caption",
 CellID->29472],
Cell[7197, 252, 687, 15, 70, "DefinitionBox",
 CellID->27479],
Cell[7887, 269, 73, 1, 70, "Caption",
 CellID->19593],
Cell[7963, 272, 1678, 53, 70, "Text",
 CellID->32482],
Cell[9644, 327, 77, 1, 70, "MathCaption",
 CellID->3005],
Cell[CellGroupData[{
Cell[9746, 332, 128, 3, 70, "Input",
 CellID->18536],
Cell[9877, 337, 24669, 410, 141, "Output",
 CellID->15333]
}, Open  ]],
Cell[34561, 750, 687, 19, 70, "DefinitionBox",
 CellID->11105],
Cell[35251, 771, 109, 3, 70, "Caption",
 CellID->27587],
Cell[CellGroupData[{
Cell[35385, 778, 72, 1, 70, "RelatedTutorialsSection",
 CellID->295432803],
Cell[35460, 781, 187, 4, 70, "RelatedTutorials",
 CellID->16088632]
}, Open  ]],
Cell[CellGroupData[{
Cell[35684, 790, 98, 1, 70, "TutorialRelatedLinksSection",
 CellID->246539207],
Cell[35785, 793, 414, 13, 70, "TutorialRelatedLinks",
 CellID->529213904]
}, Open  ]]
}, Open  ]],
Cell[36226, 810, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

