(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23765,        855]
NotebookOptionsPosition[     17250,        641]
NotebookOutlinePosition[     20023,        712]
CellTagsIndexPosition[     19931,        706]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Files and Streams" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FilesAndStreamsOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Files and Streams\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Export" :> Documentation`HelpLookup["paclet:ref/Export"], 
          "Import" :> Documentation`HelpLookup["paclet:ref/Import"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Export\"\>", 
       2->"\<\"Import\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Importing and Exporting Files", "Title",
 CellTags->{"S2.12.7", "7.1"},
 CellID->30732],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Import",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<List\>\"", "]"}], Cell["\<\
import a one\[Hyphen]dimensional list of data from a file\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["Export",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Export"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     StyleBox["list", "TI"], ",", "\"\<List\>\"", "]"}], Cell[TextData[{
     "export ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " to a file as a one\[Hyphen]dimensional list of data"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Import",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<Table\>\"", "]"}], Cell["\<\
import a two\[Hyphen]dimensional table of data from a file\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["Export",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Export"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     StyleBox["list", "TI"], ",", "\"\<Table\>\"", "]"}], Cell[TextData[{
     "export ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " to a file as a two\[Hyphen]dimensional table of data"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Import",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<CSV\>\"", "]"}], Cell["\<\
import data in comma\[Hyphen]separated format\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["Export",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Export"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     StyleBox["list", "TI"], ",", "\"\<CSV\>\"", "]"}], Cell["\<\
export data in comma\[Hyphen]separated format\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, True, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->15638],

Cell["Importing and exporting lists and tables of data. ", "Caption",
 CellID->31165],

Cell[TextData[{
 "This exports a list of data to the file ",
 Cell[BoxData["out1"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->1064],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<out1\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"6.7", ",", "8.5", ",", 
     RowBox[{"-", "5.3"}]}], "}"}], ",", "\"\<List\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14518],

Cell[BoxData["\<\"out1.dat\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->179273294]
}, Open  ]],

Cell["Here are the contents of the file. ", "MathCaption",
 CellID->5032],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<out1\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17508],

Cell["\<\
6.7
8.5
-5.3\
\>", "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->350876273]
}, Open  ]],

Cell[TextData[{
 "This imports the contents back into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "MathCaption",
 CellID->13438],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<out1\>\"", ",", "\"\<List\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->23978],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6.7`", ",", "8.5`", ",", 
   RowBox[{"-", "5.3`"}]}], "}"}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->97273978]
}, Open  ]],

Cell[TextData[{
 "If you want to use data purely within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", then the best way to keep it in a file is usually as a complete ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression, with all its structure preserved, as discussed in\
\[NonBreakingSpace]\"",
 ButtonBox["Reading and Writing ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"],
  FontSlant->"Italic"],
 ButtonBox[" Files: Files and Streams\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"],
 ". But if you want to exchange data with other programs, it is often more \
convenient to have the data in a simple list or table format. "
}], "Text",
 CellID->8245],

Cell["\<\
This exports a two\[Hyphen]dimensional array of data. \
\>", "MathCaption",
 CellID->4059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<out2.dat\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"5.6", " ", 
        RowBox[{"10", "^", "12"}]}], ",", 
       RowBox[{"7.2", " ", 
        RowBox[{"10", "^", "12"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "5"}], "}"}]}], "}"}], ",", "\"\<Table\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->24169],

Cell[BoxData["\<\"out2.dat\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->87069197]
}, Open  ]],

Cell["\<\
When necessary, numbers are written in C or Fortran\[Hyphen]like \"E\" \
notation. \
\>", "MathCaption",
 CellID->27362],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<out2.dat\>\"", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->24769],

Cell["\<\
5.6e+12   7.2e+12
3   5\
\>", "Print",
 CellLabel->"During evaluation of In[5]:=",
 CellID->222528597]
}, Open  ]],

Cell[TextData[{
 "This imports the array back into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "MathCaption",
 CellID->26518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<out2.dat\>\"", ",", "\"\<Table\>\""}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->16467],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5.6`*^12", ",", "7.2`*^12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}]}], "}"}]], "Output",
 ImageSize->{208, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->397092147]
}, Open  ]],

Cell[TextData[{
 "If you have a file in which each line consists of a single number, then you \
can use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    ButtonBox["\"\<List\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/List"]}], "]"}]], "InlineFormula"],
 " to import the contents of the file as a list of numbers. If each line \
consists of a sequence of numbers separated by tabs or spaces, then ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    ButtonBox["\"\<Table\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/Table"]}], "]"}]], "InlineFormula"],
 " will yield a list of lists of numbers. If the file contains items that are \
not numbers, then these are returned as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " strings. "
}], "Text",
 CellID->32143],

Cell["This exports a mixture of textual and numerical data. ", "MathCaption",
 CellID->23061],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<out3.dat\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<first\>\"", ",", "3.4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<second\>\"", ",", "7.8"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->25603],

Cell[BoxData["\<\"out3.dat\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->262616217]
}, Open  ]],

Cell["Here is the exported data. ", "MathCaption",
 CellID->22186],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<out3.dat\>\"", "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->1226],

Cell["\<\
first   3.4
second   7.8\
\>", "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->70014303]
}, Open  ]],

Cell[TextData[{
 "This imports the data back into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "MathCaption",
 CellID->17004],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<out3.dat\>\"", ",", "\"\<Table\>\""}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->21300],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"first\"\>", ",", "3.4`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"second\"\>", ",", "7.8`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{199, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->164561784]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ", you can explicitly see the strings. "
}], "MathCaption",
 CellID->423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->31347],

Cell["{{\"first\", 3.4}, {\"second\", 7.8}}", "Output",
 ImageSize->{231, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]//InputForm=",
 CellID->7845134]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Import",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<List\>\"", "]"}], Cell[
    "treat each line as a separate numerical or other data item", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["Import",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<Table\>\"", "]"}], Cell["\<\
treat each element on each line as a separate numerical or other data item\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["Import",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<String\>\"", "]"}], Cell[
    "treat the whole file as a single character string", "TableText"]},
   {
    RowBox[{
     ButtonBox["Import",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<Text\>\"", "]"}], Cell[
    "treat the whole file as a single string of text", "TableText"]},
   {
    RowBox[{
     ButtonBox["Import",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Import"], "[", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"\"\<Text\>\"", ",", "\"\<Lines\>\""}], "}"}]}], "]"}], Cell[
    "treat each line as a string of text", "TableText"]},
   {
    RowBox[{
     ButtonBox["Import",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Import"], "[", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"\"\<Text\>\"", ",", "\"\<Words\>\""}], "}"}]}], "]"}], Cell[
    "treat each separated word as a string of text", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, True, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->4566],

Cell["Importing files in different formats. ", "Caption",
 CellID->25230],

Cell["This creates a file with two lines of text. ", "MathCaption",
 CellID->21665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<out4.txt\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<The first line.\>\"", ",", "\"\<The second line.\>\""}], 
    "}"}], ",", 
   StyleBox[
    RowBox[{"{", 
     RowBox[{"\"\<Text\>\"", ",", "\"\<Lines\>\""}], "}"}],
    ShowStringCharacters->True]}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->26152],

Cell[BoxData["\<\"out4.dat\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->387634356]
}, Open  ]],

Cell["Here are the contents of the file. ", "MathCaption",
 CellID->3617],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<out4.txt\>\"", "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->29173],

Cell["\<\
The first line.
The second line.\
\>", "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->50543864]
}, Open  ]],

Cell["This imports the whole file as a single string. ", "MathCaption",
 CellID->10668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Import", "[", 
   RowBox[{"\"\<out4.txt\>\"", ",", "\"\<Text\>\""}], "]"}], "//", 
  "InputForm"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->31597],

Cell["\"The first line.\\nThe second line.\"", "Output",
 ImageSize->{245, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]//InputForm=",
 CellID->212366956]
}, Open  ]],

Cell["This imports the file as a list of lines of text. ", "MathCaption",
 CellID->26224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Import", "[", 
   RowBox[{"\"\<out4.txt\>\"", ",", 
    StyleBox[
     RowBox[{"{", 
      RowBox[{"\"\<Text\>\"", ",", "\"\<Lines\>\""}], "}"}],
     ShowStringCharacters->True]}], "]"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->17728],

Cell["{\"The first line.\", \"The second line.\"}", "Output",
 ImageSize->{273, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]//InputForm=",
 CellID->248347567]
}, Open  ]],

Cell["\<\
This imports the file as a list of words separated by white space. \
\>", "MathCaption",
 CellID->12158],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Import", "[", 
   RowBox[{"\"\<out4.txt\>\"", ",", 
    StyleBox[
     RowBox[{"{", 
      RowBox[{"\"\<Text\>\"", ",", "\"\<Words\>\""}], "}"}],
     ShowStringCharacters->True]}], "]"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->23425],

Cell["{\"The\", \"first\", \"line.\", \"The\", \"second\", \"line.\"}", \
"Output",
 ImageSize->{357, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]//InputForm=",
 CellID->318182056]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->56697140],

Cell[TextData[ButtonBox["Files and Streams",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FilesAndStreamsOverview"]], "RelatedTutorials",
 CellID->107813958]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Importing and Exporting Files - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Files and Streams", "OverviewNavText"], BaseStyle -> "Link",
         ButtonData -> "paclet:tutorial/FilesAndStreamsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ManipulatingFilesAndDirectories"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ReadingTextualData"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 37, 4.7858826}", "context" -> "", 
    "keywords" -> {
     "arrays", "comma-separated values", "CSV format", "excel format", 
      "export", "external data", "files", "foreign data", "import", 
      "lines of text", "lists", "lotus 1-2-3 format", "reading files", 
      "spreadsheets", "strings", "tab-delimited data", "tables", 
      "tabular data", "text", "words", "writing"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Importing and exporting lists and tables of data. This exports a list of \
data to the file out1. Here are the contents of the file. ", 
    "synonyms" -> {"2.12.7"}, "title" -> "Importing and Exporting Files", 
    "type" -> "Tutorial", "uri" -> "tutorial/ImportingAndExportingFiles"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.12.7"->{
  Cell[1880, 59, 93, 2, 70, "Title",
   CellTags->{"S2.12.7", "7.1"},
   CellID->30732]},
 "7.1"->{
  Cell[1880, 59, 93, 2, 70, "Title",
   CellTags->{"S2.12.7", "7.1"},
   CellID->30732]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.12.7", 19718, 695},
 {"7.1", 19818, 699}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1255, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1880, 59, 93, 2, 70, "Title",
 CellTags->{"S2.12.7", "7.1"},
 CellID->30732],
Cell[1976, 63, 2313, 67, 70, "DefinitionBox",
 CellID->15638],
Cell[4292, 132, 85, 1, 70, "Caption",
 CellID->31165],
Cell[4380, 135, 141, 5, 70, "MathCaption",
 CellID->1064],
Cell[CellGroupData[{
Cell[4546, 144, 239, 7, 28, "Input",
 CellID->14518],
Cell[4788, 153, 173, 5, 36, "Output",
 CellID->179273294]
}, Open  ]],
Cell[4976, 161, 73, 1, 70, "MathCaption",
 CellID->5032],
Cell[CellGroupData[{
Cell[5074, 166, 112, 3, 70, "Input",
 CellID->17508],
Cell[5189, 171, 101, 6, 70, "Print",
 CellID->350876273]
}, Open  ]],
Cell[5305, 180, 146, 6, 70, "MathCaption",
 CellID->13438],
Cell[CellGroupData[{
Cell[5476, 190, 143, 4, 70, "Input",
 CellID->23978],
Cell[5622, 196, 241, 8, 36, "Output",
 CellID->97273978]
}, Open  ]],
Cell[5878, 207, 888, 22, 70, "Text",
 CellID->8245],
Cell[6769, 231, 100, 3, 70, "MathCaption",
 CellID->4059],
Cell[CellGroupData[{
Cell[6894, 238, 438, 15, 70, "Input",
 CellID->24169],
Cell[7335, 255, 172, 5, 36, "Output",
 CellID->87069197]
}, Open  ]],
Cell[7522, 263, 130, 4, 70, "MathCaption",
 CellID->27362],
Cell[CellGroupData[{
Cell[7677, 271, 116, 3, 70, "Input",
 CellID->24769],
Cell[7796, 276, 112, 5, 70, "Print",
 CellID->222528597]
}, Open  ]],
Cell[7923, 284, 143, 6, 70, "MathCaption",
 CellID->26518],
Cell[CellGroupData[{
Cell[8091, 294, 148, 4, 70, "Input",
 CellID->16467],
Cell[8242, 300, 316, 11, 39, "Output",
 CellID->397092147]
}, Open  ]],
Cell[8573, 314, 1080, 31, 70, "Text",
 CellID->32143],
Cell[9656, 347, 93, 1, 70, "MathCaption",
 CellID->23061],
Cell[CellGroupData[{
Cell[9774, 352, 323, 11, 70, "Input",
 CellID->25603],
Cell[10100, 365, 173, 5, 36, "Output",
 CellID->262616217]
}, Open  ]],
Cell[10288, 373, 66, 1, 70, "MathCaption",
 CellID->22186],
Cell[CellGroupData[{
Cell[10379, 378, 115, 3, 70, "Input",
 CellID->1226],
Cell[10497, 383, 112, 5, 70, "Print",
 CellID->70014303]
}, Open  ]],
Cell[10624, 391, 142, 6, 70, "MathCaption",
 CellID->17004],
Cell[CellGroupData[{
Cell[10791, 401, 148, 4, 70, "Input",
 CellID->21300],
Cell[10942, 407, 333, 11, 36, "Output",
 CellID->164561784]
}, Open  ]],
Cell[11290, 421, 221, 8, 70, "MathCaption",
 CellID->423],
Cell[CellGroupData[{
Cell[11536, 433, 102, 3, 70, "Input",
 CellID->31347],
Cell[11641, 438, 196, 5, 50, "Output",
 CellID->7845134]
}, Open  ]],
Cell[11852, 446, 2167, 60, 70, "DefinitionBox",
 CellID->4566],
Cell[14022, 508, 73, 1, 70, "Caption",
 CellID->25230],
Cell[14098, 511, 83, 1, 70, "MathCaption",
 CellID->21665],
Cell[CellGroupData[{
Cell[14206, 516, 366, 11, 70, "Input",
 CellID->26152],
Cell[14575, 529, 174, 5, 36, "Output",
 CellID->387634356]
}, Open  ]],
Cell[14764, 537, 73, 1, 70, "MathCaption",
 CellID->3617],
Cell[CellGroupData[{
Cell[14862, 542, 117, 3, 70, "Input",
 CellID->29173],
Cell[14982, 547, 121, 5, 70, "Print",
 CellID->50543864]
}, Open  ]],
Cell[15118, 555, 87, 1, 70, "MathCaption",
 CellID->10668],
Cell[CellGroupData[{
Cell[15230, 560, 184, 6, 70, "Input",
 CellID->31597],
Cell[15417, 568, 199, 5, 50, "Output",
 CellID->212366956]
}, Open  ]],
Cell[15631, 576, 89, 1, 70, "MathCaption",
 CellID->26224],
Cell[CellGroupData[{
Cell[15745, 581, 294, 9, 70, "Input",
 CellID->17728],
Cell[16042, 592, 204, 5, 50, "Output",
 CellID->248347567]
}, Open  ]],
Cell[16261, 600, 114, 3, 70, "MathCaption",
 CellID->12158],
Cell[CellGroupData[{
Cell[16400, 607, 294, 9, 70, "Input",
 CellID->23425],
Cell[16697, 618, 226, 6, 50, "Output",
 CellID->318182056]
}, Open  ]],
Cell[CellGroupData[{
Cell[16960, 629, 71, 1, 70, "RelatedTutorialsSection",
 CellID->56697140],
Cell[17034, 632, 162, 3, 70, "RelatedTutorials",
 CellID->107813958]
}, Open  ]]
}, Open  ]],
Cell[17223, 639, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

