(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     56988,       2138]
NotebookOptionsPosition[     45744,       1781]
NotebookOutlinePosition[     50284,       1904]
CellTagsIndexPosition[     49940,       1888]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Incompatible Changes since ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Version 1"
}], "Title",
 CellID->400473147],

Cell[CellGroupData[{

Cell["Introduction", "Section",
 CellTags->{"SA.14.1", "1.1"},
 CellID->12425],

Cell[TextData[{
 "Every new version of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " contains many new features. But careful design from the outset has allowed \
nearly total compatibility to be maintained between all versions. As a \
result, almost any program written, say, for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Version 1 in 1988 should be able to run without change in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Version 6\[LongDash]though it will often run considerably faster. "
}], "Text",
 CellID->26896],

Cell[TextData[{
 "One inevitable problem, however, is that if a program uses names that begin \
with upper\[Hyphen]case letters, then it is possible that since the version \
when the program was first written, built\[Hyphen]in functions may have been \
added to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " whose names conflict with those used in the program. "
}], "Text",
 CellID->27769],

Cell[TextData[{
 "In addition, to maintain the overall coherence of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " a few functions that existed in earlier versions have gradually been \
dropped\[LongDash]first becoming undocumented, and later generating warning \
messages if used. Furthermore, it has in a few rare cases been necessary to \
makes changes to particular functions that are not compatible with their \
earlier operation. "
}], "Text",
 CellID->25331]
}, Open  ]],

Cell[CellGroupData[{

Cell["Between Versions 1 and 2", "Section",
 CellTags->{"SA.14.2", "2.1"},
 CellID->15469],

Cell["\<\
260 new built\[Hyphen]in objects have been added, some of whose names may \
conflict with names already being used. \
\>", "Notes",
 CellID->22912],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Accumulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Accumulate"]], "InlineFormula"],
 " has been superseded by ",
 Cell[BoxData[
  ButtonBox["FoldList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FoldList"]], "InlineFormula"],
 "; ",
 Cell[BoxData[
  ButtonBox["Fold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fold"]], "InlineFormula"],
 " has been added."
}], "Notes",
 CellID->165858134],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Condition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Condition"]], "InlineFormula"],
 " (",
 Cell[BoxData["/;"], "InlineFormula"],
 ") can now be used in individual patterns as well as in complete rules, and \
does not evaluate by default."
}], "Notes",
 CellID->231236432],

Cell[TextData[{
 "The functionality of ",
 Cell[BoxData[
  ButtonBox["Release",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Release"]], "InlineFormula"],
 " has been split between ",
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ReleaseHold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReleaseHold"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->774234571],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Compose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Compose"]], "InlineFormula"],
 " has been superseded by ",
 Cell[BoxData[
  ButtonBox["Composition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Composition"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->142303445],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Debug",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Debug"]], "InlineFormula"],
 " has been superseded by ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " and related functions."
}], "Notes",
 CellID->214227114],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Power",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Power"]], "InlineFormula"],
 " no longer automatically makes transformations such as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Sqrt",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Sqrt"], "[", 
    RowBox[{
     StyleBox["x", "TI"], "^", "2"}], "]"}], "\[Rule]", 
   StyleBox["x", "TI"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->61073199],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Limit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Limit"]], "InlineFormula"],
 " now by default remains unevaluated if it encounters an unknown function."
}], "Notes",
 CellID->169324537],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Mod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mod"]], "InlineFormula"],
 " now handles only numbers; ",
 Cell[BoxData[
  ButtonBox["PolynomialMod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialMod"]], "InlineFormula"],
 " handles polynomials."
}], "Notes",
 CellID->253808079],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CellArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellArray"]], "InlineFormula"],
 " has been superseded by ",
 Cell[BoxData[
  ButtonBox["Raster",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Raster"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RasterArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RasterArray"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->56017376],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FontForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontForm"]], "InlineFormula"],
 " takes a slightly different form of font specification."
}], "Notes",
 CellID->84929205],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Framed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Framed"]], "InlineFormula"],
 " has been superseded by ",
 Cell[BoxData[
  ButtonBox["Frame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Frame"]], "InlineFormula"],
 " and related options."
}], "Notes",
 CellID->114864545],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ContourLevels",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourLevels"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ContourSpacing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourSpacing"]], "InlineFormula"],
 " have been superseded by ",
 Cell[BoxData[
  ButtonBox["Contours",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Contours"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->299464126],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Plot3Matrix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot3Matrix"]], "InlineFormula"],
 " has been superseded by ",
 Cell[BoxData[
  ButtonBox["ViewCenter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewCenter"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ViewVertical",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewVertical"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->135427168],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FromASCII",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FromASCII"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ToASCII",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToASCII"]], "InlineFormula"],
 " have been superseded by ",
 Cell[BoxData[
  ButtonBox["FromCharacterCode",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FromCharacterCode"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ToCharacterCode",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToCharacterCode"]], "InlineFormula"],
 " respectively."
}], "Notes",
 CellID->818263501],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Alias",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alias"]], "InlineFormula"],
 " has been superseded by ",
 Cell[BoxData[
  ButtonBox["$PreRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$PreRead"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->3069474],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ResetMedium",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ResetMedium"]], "InlineFormula"],
 " has been subsumed in ",
 Cell[BoxData[
  ButtonBox["SetOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetOptions"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["$$Media",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$$Media"]], "InlineFormula"],
 " has been superseded by ",
 Cell[BoxData[
  ButtonBox["Streams",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Streams"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->232790285],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StartProcess",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StartProcess"]], "InlineFormula"],
 " has been superseded by ",
 Cell[BoxData[
  ButtonBox["Install",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Install"]], "InlineFormula"],
 " and by ",
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"],
  FontSlant->"Italic"],
 "."
}], "Notes",
 CellID->7019813]
}, Open  ]],

Cell[CellGroupData[{

Cell["Between Versions 2 and 3", "Section",
 CellTags->{"SA.14.3", "3.1"},
 CellID->8146],

Cell["\<\
259 new built\[Hyphen]in objects have been added, some of whose names may \
conflict with names already being used.\
\>", "Notes",
 CellID->30693],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " now always tries to give ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " digits of precision if possible, rather than simply starting with ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " digits of precision."
}], "Notes",
 CellID->223690454],

Cell["\<\
All expressions containing only numeric functions and numerical constants are \
now converted to approximate numerical form whenever they contain any \
approximate numbers.\
\>", "Notes",
 CellID->9091],

Cell[TextData[{
 "Many expressions involving exact numbers that used to remain unevaluated \
are now evaluated. Example: ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Floor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Floor"], "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"7", "/", "3"}], ")"}], "^", "20"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->30540515],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 " now apply built\[Hyphen]in rules before user\[Hyphen]defined ones, so it \
is no longer possible to make definitions such as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"2", "+", "2"}], "=", "5"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->21514140],

Cell[TextData[{
 "The operator precedence for ",
 Cell[BoxData["."], "InlineFormula"],
 " and ",
 Cell[BoxData["**"], "InlineFormula"],
 " has been changed so as to be below ",
 Cell[BoxData["^"], "InlineFormula"],
 ". This has the consequence that expressions previously written in ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " as ",
 Cell[BoxData[
  RowBox[{"a", ".", 
   RowBox[{"b", "^", "n"}]}]], "InlineFormula"],
 " must now be written as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", ".", "b"}], ")"}], "^", "n"}]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{"V2Get", "[", 
   StyleBox["file", "TI"], "]"}]], "InlineFormula"],
 " will read a file using old operator precedences."
}], "Notes",
 CellID->613740723],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"\[Backslash]", "^"}]], "InlineFormula"],
 " is now an operator used to generate a superscript. Raw octal codes must be \
used instead of ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{"^", "A"}]}]], "InlineFormula"],
 " for inputting control characters."
}], "Notes",
 CellID->77532949],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebooks, several built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions are now output by default using special characters. Example: ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "->", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 " is output as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "\[Rule]", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->393744258],

Cell[TextData[{
 "More sophisticated definite integrals now yield explicit ",
 Cell[BoxData[
  ButtonBox["If",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/If"]], "InlineFormula"],
 " constructs unless the option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GenerateConditions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GenerateConditions"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " is used."
}], "Notes",
 CellID->172086074],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["HeldPart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HeldPart"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["i", "TI"], ",", 
    StyleBox["j", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " has been superseded by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Extract",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Extract"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      StyleBox["j", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    ButtonBox["Hold",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Hold"]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->410349155],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Literal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Literal"], "[", 
   StyleBox["pattern", "TI"], "]"}]], "InlineFormula"],
 " has been replaced by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["HoldPattern",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldPattern"], "[", 
   StyleBox["pattern", "TI"], "]"}]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Verbatim",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Verbatim"], "[", 
   StyleBox["pattern", "TI"], "]"}]], "InlineFormula"],
 " has been introduced. Functions like ",
 Cell[BoxData[
  ButtonBox["DownValues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DownValues"]], "InlineFormula"],
 " return their results wrapped in ",
 Cell[BoxData[
  ButtonBox["HoldPattern",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldPattern"]], "InlineFormula"],
 " rather than ",
 Cell[BoxData[
  ButtonBox["Literal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Literal"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->545213925],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ReplaceHeldPart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplaceHeldPart"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["new", "TI"], ",", 
    StyleBox["pos", "TI"]}], "]"}]], "InlineFormula"],
 " has been superseded by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ReplacePart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplacePart"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     ButtonBox["Hold",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hold"], "[", 
     StyleBox["new", "TI"], "]"}], ",", 
    StyleBox["pos", "TI"], ",", "1"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->951599230],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ToHeldExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToHeldExpression"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " has been superseded by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToExpression"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["form", "TI"], ",", 
    ButtonBox["Hold",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Hold"]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->91067417],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Trig",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trig"]], "InlineFormula"],
 " as an option to algebraic manipulation functions has been superseded by \
the explicit functions ",
 Cell[BoxData[
  ButtonBox["TrigExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigExpand"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["TrigFactor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigFactor"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TrigReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigReduce"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->232488121],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AlgebraicRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicRules"]], "InlineFormula"],
 " has been superseded by ",
 Cell[BoxData[
  ButtonBox["PolynomialReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialReduce"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->425621929],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["LegendreType",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LegendreType"]], "InlineFormula"],
 " has been superseded by an additional optional argument to ",
 Cell[BoxData[
  ButtonBox["LegendreP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LegendreP"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["LegendreQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LegendreQ"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->449416990],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["WeierstrassP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WeierstrassP"], "[", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["3", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " now takes ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["g", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["g", "TI"], 
   StyleBox["3", "TR"]]], "InlineFormula"],
 " in a list."
}], "Notes",
 CellID->143341143],

Cell[TextData[{
 Cell[BoxData["$Letters"], "InlineFormula"],
 " and ",
 Cell[BoxData["$StringOrder"], "InlineFormula"],
 " now have built\[Hyphen]in values only, but these handle all possible ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " characters."
}], "Notes",
 CellID->92904535],

Cell[TextData[{
 Cell[BoxData["StringByteCount"], "InlineFormula"],
 " is no longer supported."
}], "Notes",
 CellID->423169130],

Cell[TextData[{
 "Arbitrary\[Hyphen]precision approximate real numbers are now given by \
default as ",
 Cell[BoxData[
  StyleBox["digits`prec", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ". This behavior is controlled by ",
 Cell[BoxData[
  ButtonBox["$NumberMarks",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$NumberMarks"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->45364520],

Cell[TextData[{
 "Large approximate real numbers are now given by default as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["digits", "TI"], "*", 
   RowBox[{"^", 
    StyleBox["exponent", "TI"]}]}]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->190396486],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["HomeDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HomeDirectory"], "[", " ", "]"}]], 
  "InlineFormula"],
 " has been replaced by ",
 Cell[BoxData[
  ButtonBox["$HomeDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$HomeDirectory"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->340428793],

Cell[TextData[{
 "Dump has been superseded by ",
 Cell[BoxData[
  ButtonBox["DumpSave",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DumpSave"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->223514219],

Cell[TextData[{
 Cell[BoxData["$PipeSupported"], "InlineFormula"],
 " and ",
 Cell[BoxData["$LinkSupported"], "InlineFormula"],
 " are now obsolete, since all computer systems support pipes and links."
}], "Notes",
 CellID->244558642],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinkOpen",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkOpen"]], "InlineFormula"],
 " has been superseded by ",
 Cell[BoxData[
  ButtonBox["LinkCreate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkCreate"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["LinkConnect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkConnect"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["LinkLaunch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkLaunch"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->28336028],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Subscripted",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Subscripted"]], "InlineFormula"],
 " has been superseded by ",
 Cell[BoxData[
  ButtonBox["RowBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RowBox"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["SubscriptBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SubscriptBox"]], "InlineFormula"],
 ", etc."
}], "Notes",
 CellID->473364],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Subscript",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Subscript"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Superscript",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Superscript"]], "InlineFormula"],
 " now represent complete subscripted and superscripted quantities, not just \
subscripts and superscripts."
}], "Notes",
 CellID->999180233],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FontForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["DefaultFont",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DefaultFont"]], "InlineFormula"],
 " have been superseded by ",
 Cell[BoxData[
  ButtonBox["StyleForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StyleForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TextStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TextStyle"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->207046468],

Cell["In the notebook front end, changes that were made include:", "Text",
 CellID->9815],

Cell["\<\
The file format for notebooks has been completely changed in order to support \
new notebook capabilities. \
\>", "Notes",
 CellID->26949],

Cell["\<\
Notebook files are now by default given .nb rather than .ma extensions; .mb \
files are now superfluous.\
\>", "Notes",
 CellID->22779228],

Cell["\<\
The front end will automatically ask to convert any old notebook that you \
tell it to open.\
\>", "Notes",
 CellID->560764201],

Cell[TextData[{
 "The kernel command ",
 Cell[BoxData[
  ButtonBox["NotebookConvert",
   BaseStyle->"Link",
   ButtonData->"paclet:Developer/ref/NotebookConvert"]], "InlineFormula"],
 " can be used to convert notebook files from Version 2 to Version 3 format."
}], "Notes",
 CellID->423853654],

Cell[TextData[{
 "The default format type for input cells is now ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " rather than ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->302001149],

Cell["\<\
The organization of stylesheets, as well as the settings for some default \
styles, have been changed.\
\>", "Notes",
 CellID->88018712],

Cell["\<\
Some command key equivalents for menu items have been rearranged.\
\>", "Notes",
 CellID->3365972]
}, Open  ]],

Cell[CellGroupData[{

Cell["Between Versions 3 and 4", "Section",
 CellTags->{"SA.14.4", "4.1"},
 CellID->26857],

Cell["\<\
61 new built\[Hyphen]in objects have been added, some of whose names may \
conflict with names already being used.\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", "0", "]"}]], "InlineFormula"],
 " now yields a machine\[Hyphen]precision zero rather than an exact zero."
}], "Notes",
 CellID->239864212],

Cell[TextData[{
 Cell[BoxData["FullOptions"], "InlineFormula"],
 " has been superseded by ",
 Cell[BoxData[
  ButtonBox["AbsoluteOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteOptions"]], "InlineFormula"],
 ", which yields results in the same form as ",
 Cell[BoxData[
  ButtonBox["Options",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Options"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->269240647],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Element",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Element"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "\[Element]", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 " now has built\[Hyphen]in evaluation rules."
}], "Notes",
 CellID->151026186],

Cell[TextData[{
 "The symbols ",
 Cell[BoxData[
  ButtonBox["I",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["E",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/E"]], "InlineFormula"],
 " are now output in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " as ",
 Cell[BoxData[
  FormBox["\[ImaginaryI]", TraditionalForm]], "InlineMath"],
 " (",
 Cell[BoxData["\\[ImaginaryI]"], "InlineCharacterName"],
 ") and ",
 Cell[BoxData[
  FormBox["\[ExponentialE]", TraditionalForm]], "InlineMath"],
 " (",
 Cell[BoxData["\\[ExponentialE]"], "InlineCharacterName"],
 ") respectively."
}], "Notes",
 CellID->82159696],

Cell[TextData[{
 "A new second argument has been added to ",
 Cell[BoxData[
  ButtonBox["CompiledFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CompiledFunction"]], "InlineFormula"],
 " to allow easier manipulation and composition of compiled functions."
}], "Notes",
 CellID->22336785]
}, Open  ]],

Cell[CellGroupData[{

Cell["Between Versions 4 and 5", "Section",
 CellTags->{"SA.14.5", "5.1"},
 CellID->26052],

Cell["\<\
44 completely new built\[Hyphen]in objects have been added, some of whose \
names may conflict with names already being used.\
\>", "Notes",
 CellID->236],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Precision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Precision"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Accuracy",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Accuracy"]], "InlineFormula"],
 " now return exact measures of uncertainty in numbers, not just estimates of \
integer numbers of digits."
}], "Notes",
 CellID->61333950],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Precision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Precision"]], "InlineFormula"],
 " now returns the symbol ",
 Cell[BoxData[
  ButtonBox["MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MachinePrecision"]], "InlineFormula"],
 " for machine numbers, rather than the numerical value ",
 Cell[BoxData[
  ButtonBox["$MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachinePrecision"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->775417285],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    ButtonBox["MachinePrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MachinePrecision"]}], "]"}]], "InlineFormula"],
 " is now used for numerical evaluation with machine numbers; ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    ButtonBox["$MachinePrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$MachinePrecision"]}], "]"}]], "InlineFormula"],
 " generates arbitrary\[Hyphen]precision numbers."
}], "Notes",
 CellID->189044058],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ConstrainedMin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ConstrainedMin"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ConstrainedMax",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ConstrainedMax"]], "InlineFormula"],
 " have been superseded by ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["NMaximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMaximize"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->181545904],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SingularValues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SingularValues"]], "InlineFormula"],
 " has been superseded by ",
 Cell[BoxData[
  ButtonBox["SingularValueList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SingularValueList"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["SingularValueDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SingularValueDecomposition"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["SingularValueDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SingularValueDecomposition"]], "InlineFormula"],
 " uses a different and more complete definition."
}], "Notes",
 CellID->159128204],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LUBackSubstitution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LUBackSubstitution"]], "InlineFormula"],
 " has been superseded by the use of the more general ",
 Cell[BoxData[
  ButtonBox["LinearSolveFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolveFunction"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->23190670],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FindRoot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindRoot"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["0", "TR"]], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]]}], "}"}]}], "}"}]}], "]"}]], "InlineFormula"],
 " is now used to specify a starting vector value for ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", rather than a pair of values. The same is true for ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->49486555],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DSolveConstants",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolveConstants"]], "InlineFormula"],
 " has been superseded by the more general option ",
 Cell[BoxData[
  ButtonBox["GeneratedParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GeneratedParameters"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->32527646],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TensorRank",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TensorRank"]], "InlineFormula"],
 " has been replaced by ",
 Cell[BoxData[
  ButtonBox["ArrayDepth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayDepth"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->209457160],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$TopDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$TopDirectory"]], "InlineFormula"],
 " has been superseded by ",
 Cell[BoxData[
  ButtonBox["$InstallationDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$InstallationDirectory"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->560404001],

Cell[TextData[{
 "The default setting for the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  ButtonBox["LinkProtocol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkProtocol"]], "InlineFormula"],
 " option when connecting different computer systems is now ",
 Cell[BoxData["\"\<TCPIP\>\""], "InlineFormula"],
 " rather than ",
 Cell[BoxData["\"\<TCP\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->197671761]
}, Open  ]],

Cell[CellGroupData[{

Cell["Between Versions 5 and 6", "Section",
 CellTags->{"SA.14.6", "6.1"},
 CellID->8551],

Cell[TextData[{
 "The graphics functionality has significantly changed. For compatibility \
purposes, use ",
 Cell[BoxData[
  RowBox[{"<<", "Version5`Graphics`"}]], "InlineFormula"],
 " to restore graphics capabilities from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 5. To restore the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6 graphics capabilities, use ",
 Cell[BoxData[
  RowBox[{"<<", "Version6`Graphics`"}]], "InlineFormula"],
 "."
}], "Text",
 CellID->9487],

Cell[TextData[{
 "The output form of a ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " object is now the rendered graphic rather than an output such as ",
 Cell[BoxData[
 "\[SkeletonIndicator]Graphics\[SkeletonIndicator]"], "InlineFormula"],
 "."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$DisplayFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$DisplayFunction"]], "InlineFormula"],
 " is now set to ",
 Cell[BoxData[
  ButtonBox["Identity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Identity"]], "InlineFormula"],
 ", so that no side effect happens by default when evaluating a graphic. To \
produce a side effect similar to Version 5 output, you can use the ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " function to print the graphic."
}], "Notes",
 CellID->678712350],

Cell["\<\
The default font in graphics has changed from Courier to Times.\
\>", "Notes",
 CellID->440913311],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphicsArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsArray"]], "InlineFormula"],
 " has been superseded by ",
 Cell[BoxData[
  ButtonBox["GraphicsGrid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsGrid"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->116871580],

Cell[TextData[{
 "The default for ",
 Cell[BoxData[
  ButtonBox["AspectRatio",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AspectRatio"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ParametricPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot"]], "InlineFormula"],
 " is now ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->18450110],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["PlotDivision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotDivision"]], "InlineFormula"],
 " option for ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " has been superseded by ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->98739712],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["PlotJoined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotJoined"]], "InlineFormula"],
 " option for ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 " has been superseded by ",
 Cell[BoxData[
  ButtonBox["ListLinePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLinePlot"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->211193590],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Plot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plot3D"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      StyleBox["s", "TI"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["y", "TI"], ",", 
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 ": the shading specification ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " has been superseded by ",
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->719867331],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["HiddenSurface",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HiddenSurface"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " has been superseded by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlotStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotStyle"], " ", "->", " ", 
   RowBox[{
    ButtonBox["FaceForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FaceForm"], "[", " ", "]"}]}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->110256775],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ContourGraphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourGraphics"]], "InlineFormula"],
 " has been superseded by ",
 Cell[BoxData[
  ButtonBox["ListContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListContourPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->696132230],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DensityGraphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DensityGraphics"]], "InlineFormula"],
 " has been superseded by ",
 Cell[BoxData[
  ButtonBox["ListDensityPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListDensityPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->678226373],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Plot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot3D"]], "InlineFormula"],
 " and other 3D plotting functions now emit ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 " rather than a raw list of ",
 Cell[BoxData[
  ButtonBox["Polygon",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
 " primitives."
}], "Notes",
 CellID->185404696],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 " now aggregates lists of points into a single ",
 Cell[BoxData[
  ButtonBox["Point",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Point"]], "InlineFormula"],
 " primitive."
}], "Notes",
 CellID->74105813],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["MeshRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshRange"]], "InlineFormula"],
 " option has been superseded by ",
 Cell[BoxData[
  ButtonBox["DataRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DataRange"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->133894169],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DensityPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DensityPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ListDensityPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListDensityPlot"]], "InlineFormula"],
 " by default now do not draw meshes."
}], "Notes",
 CellID->363174723],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlot3D"], "[", 
   RowBox[{
    StyleBox["array", "TI"], ",", 
    StyleBox["shades", "TI"]}], "]"}]], "InlineFormula"],
 " has been superseded by ",
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->245499864],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SurfaceColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SurfaceColor"]], "InlineFormula"],
 " in 3D graphics has been superseded by explicit color, ",
 Cell[BoxData[
  ButtonBox["Specularity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Specularity"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Glow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Glow"]], "InlineFormula"],
 " directives."
}], "Notes",
 CellID->585512063],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Lighting",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Lighting"]], "InlineFormula"],
 " now supports a syntax for specifying different kinds of light sources, \
including spotlights, point light sources, directional lighting and ambient \
lighting."
}], "Notes",
 CellID->564867897],

Cell[TextData[{
 "The graphics primitive ",
 Cell[BoxData["PostScript"], "InlineFormula"],
 " is no longer supported."
}], "Notes",
 CellID->341471785],

Cell[TextData[{
 "The options ",
 Cell[BoxData[
  ButtonBox["RenderAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RenderAll"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PolygonIntersections",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolygonIntersections"]], "InlineFormula"],
 " are no longer supported."
}], "Notes",
 CellID->36464652],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rectangle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rectangle"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["min", "TI"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]], ",", 
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["max", "TI"]]}], "}"}], ",", 
    StyleBox["graphics", "TI"]}], "]"}]], "InlineFormula"],
 " has been superseded by ",
 Cell[BoxData[
  ButtonBox["Inset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inset"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->811083811],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StyleForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StyleForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["StylePrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StylePrint"]], "InlineFormula"],
 " have been superseded by ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->81151676],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TextStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TextStyle"]], "InlineFormula"],
 " has been superseded by the general ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " mechanism."
}], "Notes",
 CellID->430035135],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SequenceForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SequenceForm"]], "InlineFormula"],
 " has been superseded by ",
 Cell[BoxData[
  ButtonBox["Row",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Row"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->7650204]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Incompatible Changes since Mathematica Version 1 - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 37, 15.2236498}", "context" -> "", 
    "keywords" -> {
     "accumulate (Version 1 function)", "alias (Version 1 function)", 
      "CellArray (Version 1 function)", "changes", 
      "compose (Version 1 function)", "ContourLevels (Version 1 option)", 
      "converting", "debug (Version 1 function)", "edition", "file format", 
      "framed (Version 1 option)", "FromASCII (Version 1 function)", 
      "incompatibilities", "NotebookConvert", 
      "Plot3Matrix (Version 1 option)", "release (Version 1 function)", 
      "ResetMedium (Version 1 function)", "revisions", 
      "ToASCII (Version 1 function)", "updates", "upgrading"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Every new version of Mathematica contains many new features. But careful \
design from the outset has allowed nearly total compatibility to be \
maintained between all versions. As a result, almost any program written, \
say, for Mathematica Version 1 in 1988 should be able to run without change \
in Mathematica Version 6--though it will often run considerably faster. One \
inevitable problem, however, is that if a program uses names that begin with \
upper-case letters, then it is possible that since the version when the \
program was first written, built-in functions may have been added to \
Mathematica whose names conflict with those used in the program. In addition, \
to maintain the overall coherence of Mathematica a few functions that existed \
in earlier versions have gradually been dropped--first becoming undocumented, \
and later generating warning messages if used. Furthermore, it has in a few \
rare cases been necessary to makes changes to particular functions that are \
not compatible with their earlier operation. ", 
    "synonyms" -> {"A.13.1", "A.13.2", "A.13.3", "A.13.4", "A.13.5"}, "title" -> 
    "Incompatible Changes since Mathematica Version 1", "type" -> "Tutorial", 
    "uri" -> "tutorial/IncompatibleChanges"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "SA.14.1"->{
  Cell[896, 39, 78, 2, 70, "Section",
   CellTags->{"SA.14.1", "1.1"},
   CellID->12425]},
 "1.1"->{
  Cell[896, 39, 78, 2, 70, "Section",
   CellTags->{"SA.14.1", "1.1"},
   CellID->12425]},
 "SA.14.2"->{
  Cell[2444, 85, 90, 2, 70, "Section",
   CellTags->{"SA.14.2", "2.1"},
   CellID->15469]},
 "2.1"->{
  Cell[2444, 85, 90, 2, 70, "Section",
   CellTags->{"SA.14.2", "2.1"},
   CellID->15469]},
 "SA.14.3"->{
  Cell[9686, 380, 89, 2, 70, "Section",
   CellTags->{"SA.14.3", "3.1"},
   CellID->8146]},
 "3.1"->{
  Cell[9686, 380, 89, 2, 70, "Section",
   CellTags->{"SA.14.3", "3.1"},
   CellID->8146]},
 "SA.14.4"->{
  Cell[24994, 975, 90, 2, 70, "Section",
   CellTags->{"SA.14.4", "4.1"},
   CellID->26857]},
 "4.1"->{
  Cell[24994, 975, 90, 2, 70, "Section",
   CellTags->{"SA.14.4", "4.1"},
   CellID->26857]},
 "SA.14.5"->{
  Cell[27466, 1072, 90, 2, 70, "Section",
   CellTags->{"SA.14.5", "5.1"},
   CellID->26052]},
 "5.1"->{
  Cell[27466, 1072, 90, 2, 70, "Section",
   CellTags->{"SA.14.5", "5.1"},
   CellID->26052]},
 "SA.14.6"->{
  Cell[33924, 1312, 89, 2, 70, "Section",
   CellTags->{"SA.14.6", "6.1"},
   CellID->8551]},
 "6.1"->{
  Cell[33924, 1312, 89, 2, 70, "Section",
   CellTags->{"SA.14.6", "6.1"},
   CellID->8551]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"SA.14.1", 48671, 1837},
 {"1.1", 48772, 1841},
 {"SA.14.2", 48877, 1845},
 {"2.1", 48979, 1849},
 {"SA.14.3", 49085, 1853},
 {"3.1", 49187, 1857},
 {"SA.14.4", 49293, 1861},
 {"4.1", 49397, 1865},
 {"SA.14.5", 49505, 1869},
 {"5.1", 49610, 1873},
 {"SA.14.6", 49719, 1877},
 {"6.1", 49823, 1881}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 103, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[728, 29, 143, 6, 70, "Title",
 CellID->400473147],
Cell[CellGroupData[{
Cell[896, 39, 78, 2, 70, "Section",
 CellTags->{"SA.14.1", "1.1"},
 CellID->12425],
Cell[977, 43, 552, 14, 70, "Text",
 CellID->26896],
Cell[1532, 59, 399, 9, 70, "Text",
 CellID->27769],
Cell[1934, 70, 473, 10, 70, "Text",
 CellID->25331]
}, Open  ]],
Cell[CellGroupData[{
Cell[2444, 85, 90, 2, 70, "Section",
 CellTags->{"SA.14.2", "2.1"},
 CellID->15469],
Cell[2537, 89, 157, 4, 70, "Notes",
 CellID->22912],
Cell[2697, 95, 457, 17, 70, "Notes",
 CellID->165858134],
Cell[3157, 114, 325, 10, 70, "Notes",
 CellID->231236432],
Cell[3485, 126, 479, 18, 70, "Notes",
 CellID->774234571],
Cell[3967, 146, 324, 12, 70, "Notes",
 CellID->142303445],
Cell[4294, 160, 330, 12, 70, "Notes",
 CellID->214227114],
Cell[4627, 174, 467, 17, 70, "Notes",
 CellID->61073199],
Cell[5097, 193, 238, 7, 70, "Notes",
 CellID->169324537],
Cell[5338, 202, 343, 12, 70, "Notes",
 CellID->253808079],
Cell[5684, 216, 452, 17, 70, "Notes",
 CellID->56017376],
Cell[6139, 235, 225, 7, 70, "Notes",
 CellID->84929205],
Cell[6367, 244, 330, 12, 70, "Notes",
 CellID->114864545],
Cell[6700, 258, 472, 17, 70, "Notes",
 CellID->299464126],
Cell[7175, 277, 467, 17, 70, "Notes",
 CellID->135427168],
Cell[7645, 296, 624, 22, 70, "Notes",
 CellID->818263501],
Cell[8272, 320, 312, 12, 70, "Notes",
 CellID->3069474],
Cell[8587, 334, 602, 22, 70, "Notes",
 CellID->232790285],
Cell[9192, 358, 457, 17, 70, "Notes",
 CellID->7019813]
}, Open  ]],
Cell[CellGroupData[{
Cell[9686, 380, 89, 2, 70, "Section",
 CellTags->{"SA.14.3", "3.1"},
 CellID->8146],
Cell[9778, 384, 156, 4, 70, "Notes",
 CellID->30693],
Cell[9937, 390, 495, 17, 70, "Notes",
 CellID->223690454],
Cell[10435, 409, 212, 5, 70, "Notes",
 CellID->9091],
Cell[10650, 416, 380, 13, 70, "Notes",
 CellID->30540515],
Cell[11033, 431, 502, 17, 70, "Notes",
 CellID->21514140],
Cell[11538, 450, 825, 27, 70, "Notes",
 CellID->613740723],
Cell[12366, 479, 337, 10, 70, "Notes",
 CellID->77532949],
Cell[12706, 491, 642, 24, 70, "Notes",
 CellID->393744258],
Cell[13351, 517, 517, 17, 70, "Notes",
 CellID->172086074],
Cell[13871, 536, 798, 29, 70, "Notes",
 CellID->410349155],
Cell[14672, 567, 1082, 38, 70, "Notes",
 CellID->545213925],
Cell[15757, 607, 733, 26, 70, "Notes",
 CellID->951599230],
Cell[16493, 635, 589, 21, 70, "Notes",
 CellID->91067417],
Cell[17085, 658, 653, 23, 70, "Notes",
 CellID->232488121],
Cell[17741, 683, 348, 12, 70, "Notes",
 CellID->425621929],
Cell[18092, 697, 512, 18, 70, "Notes",
 CellID->449416990],
Cell[18607, 717, 691, 28, 70, "Notes",
 CellID->143341143],
Cell[19301, 747, 291, 9, 70, "Notes",
 CellID->92904535],
Cell[19595, 758, 128, 4, 70, "Notes",
 CellID->423169130],
Cell[19726, 764, 502, 17, 70, "Notes",
 CellID->45364520],
Cell[20231, 783, 380, 14, 70, "Notes",
 CellID->190396486],
Cell[20614, 799, 374, 14, 70, "Notes",
 CellID->340428793],
Cell[20991, 815, 205, 8, 70, "Notes",
 CellID->223514219],
Cell[21199, 825, 234, 6, 70, "Notes",
 CellID->244558642],
Cell[21436, 833, 588, 22, 70, "Notes",
 CellID->28336028],
Cell[22027, 857, 458, 17, 70, "Notes",
 CellID->473364],
Cell[22488, 876, 413, 13, 70, "Notes",
 CellID->999180233],
Cell[22904, 891, 589, 22, 70, "Notes",
 CellID->207046468],
Cell[23496, 915, 89, 1, 70, "Text",
 CellID->9815],
Cell[23588, 918, 148, 4, 70, "Notes",
 CellID->26949],
Cell[23739, 924, 148, 4, 70, "Notes",
 CellID->22779228],
Cell[23890, 930, 137, 4, 70, "Notes",
 CellID->560764201],
Cell[24030, 936, 293, 8, 70, "Notes",
 CellID->423853654],
Cell[24326, 946, 371, 13, 70, "Notes",
 CellID->302001149],
Cell[24700, 961, 146, 4, 70, "Notes",
 CellID->88018712],
Cell[24849, 967, 108, 3, 70, "Notes",
 CellID->3365972]
}, Open  ]],
Cell[CellGroupData[{
Cell[24994, 975, 90, 2, 70, "Section",
 CellTags->{"SA.14.4", "4.1"},
 CellID->26857],
Cell[25087, 979, 155, 4, 70, "Notes",
 CellID->20640],
Cell[25245, 985, 259, 8, 70, "Notes",
 CellID->239864212],
Cell[25507, 995, 428, 14, 70, "Notes",
 CellID->269240647],
Cell[25938, 1011, 428, 16, 70, "Notes",
 CellID->151026186],
Cell[26369, 1029, 758, 28, 70, "Notes",
 CellID->82159696],
Cell[27130, 1059, 299, 8, 70, "Notes",
 CellID->22336785]
}, Open  ]],
Cell[CellGroupData[{
Cell[27466, 1072, 90, 2, 70, "Section",
 CellTags->{"SA.14.5", "5.1"},
 CellID->26052],
Cell[27559, 1076, 164, 4, 70, "Notes",
 CellID->236],
Cell[27726, 1082, 405, 13, 70, "Notes",
 CellID->61333950],
Cell[28134, 1097, 534, 17, 70, "Notes",
 CellID->775417285],
Cell[28671, 1116, 740, 24, 70, "Notes",
 CellID->189044058],
Cell[29414, 1142, 859, 32, 70, "Notes",
 CellID->181545904],
Cell[30276, 1176, 723, 22, 70, "Notes",
 CellID->159128204],
Cell[31002, 1200, 389, 12, 70, "Notes",
 CellID->23190670],
Cell[31394, 1214, 833, 29, 70, "Notes",
 CellID->49486555],
Cell[32230, 1245, 379, 12, 70, "Notes",
 CellID->32527646],
Cell[32612, 1259, 326, 12, 70, "Notes",
 CellID->209457160],
Cell[32941, 1273, 499, 17, 70, "Notes",
 CellID->560404001],
Cell[33443, 1292, 444, 15, 70, "Notes",
 CellID->197671761]
}, Open  ]],
Cell[CellGroupData[{
Cell[33924, 1312, 89, 2, 70, "Section",
 CellTags->{"SA.14.6", "6.1"},
 CellID->8551],
Cell[34016, 1316, 489, 16, 70, "Text",
 CellID->9487],
Cell[34508, 1334, 484, 16, 70, "Notes",
 CellID->31226],
Cell[34995, 1352, 618, 18, 70, "Notes",
 CellID->678712350],
Cell[35616, 1372, 108, 3, 70, "Notes",
 CellID->440913311],
Cell[35727, 1377, 459, 17, 70, "Notes",
 CellID->116871580],
Cell[36189, 1396, 601, 23, 70, "Notes",
 CellID->18450110],
Cell[36793, 1421, 472, 18, 70, "Notes",
 CellID->98739712],
Cell[37268, 1441, 477, 18, 70, "Notes",
 CellID->211193590],
Cell[37748, 1461, 1046, 39, 70, "Notes",
 CellID->719867331],
Cell[38797, 1502, 609, 23, 70, "Notes",
 CellID->110256775],
Cell[39409, 1527, 491, 17, 70, "Notes",
 CellID->696132230],
Cell[39903, 1546, 491, 17, 70, "Notes",
 CellID->678226373],
Cell[40397, 1565, 508, 17, 70, "Notes",
 CellID->185404696],
Cell[40908, 1584, 345, 12, 70, "Notes",
 CellID->74105813],
Cell[41256, 1598, 340, 13, 70, "Notes",
 CellID->133894169],
Cell[41599, 1613, 355, 12, 70, "Notes",
 CellID->363174723],
Cell[41957, 1627, 436, 16, 70, "Notes",
 CellID->245499864],
Cell[42396, 1645, 497, 17, 70, "Notes",
 CellID->585512063],
Cell[42896, 1664, 332, 9, 70, "Notes",
 CellID->564867897],
Cell[43231, 1675, 151, 5, 70, "Notes",
 CellID->341471785],
Cell[43385, 1682, 367, 13, 70, "Notes",
 CellID->36464652],
Cell[43755, 1697, 815, 31, 70, "Notes",
 CellID->811083811],
Cell[44573, 1730, 449, 17, 70, "Notes",
 CellID->81151676],
Cell[45025, 1749, 346, 12, 70, "Notes",
 CellID->430035135],
Cell[45374, 1763, 316, 12, 70, "Notes",
 CellID->7650204]
}, Open  ]]
}, Open  ]],
Cell[45717, 1779, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

