(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23525,        918]
NotebookOptionsPosition[     16517,        696]
NotebookOutlinePosition[     19859,        775]
CellTagsIndexPosition[     19768,        769]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Calculus" :> 
         Documentation`HelpLookup["paclet:tutorial/CalculusOverview"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Calculus\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Indefinite Integrals", "Title",
 CellTags->{"S3.5.6", "6.1"},
 CellID->6667],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Integrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integrate"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " gives you the ",
 StyleBox["indefinite integral",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Integral]", "f", " ", "d", "x"}], TraditionalForm]], 
  "InlineMath"],
 ". You can think of the operation of indefinite integration as being an \
inverse of differentiation. If you take the result from ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Integrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integrate"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 ", and then differentiate it, you always get a result that is mathematically \
equal to the original expression ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->21717],

Cell[TextData[{
 "In general, however, there is a whole family of results which have the \
property that their derivative is ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Integrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integrate"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " gives you ",
 StyleBox["an",
  FontSlant->"Italic"],
 " expression whose derivative is ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ". You can get other expressions by adding an arbitrary constant of \
integration, or indeed by adding any function that is constant except at \
discrete points."
}], "Text",
 CellID->15928],

Cell["\<\
If you fill in explicit limits for your integral, any such constants of \
integration must cancel out. But even though the indefinite integral can have \
arbitrary constants added, it is still often very convenient to manipulate it \
without filling in the limits. \
\>", "Text",
 CellID->17590],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " applies standard rules to find indefinite integrals. "
}], "MathCaption",
 CellID->31099],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->4580],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["x", "3"], "3"]], "Output",
 ImageSize->{21, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->13870]
}, Open  ]],

Cell[TextData[{
 "You can add an arbitrary constant to the indefinite integral, and still get \
the same derivative. ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " simply gives you ",
 StyleBox["an",
  FontSlant->"Italic"],
 " expression with the required derivative. "
}], "MathCaption",
 CellID->2990],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"%", "+", "c"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->25412],

Cell[BoxData[
 SuperscriptBox["x", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->14000]
}, Open  ]],

Cell[TextData[{
 "This gives the indefinite integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Integral]", 
    FractionBox[
     StyleBox[
      RowBox[{"d", "x"}], "TI"], 
     RowBox[{
      SuperscriptBox["x", "2"], "-", "1"}]]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "MathCaption",
 CellID->18064],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "1"}], ")"}]}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->28275],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x"}], "]"}]}]}]], "Output",
 ImageSize->{176, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->20084]
}, Open  ]],

Cell["\<\
Differentiating should give the original function back again. \
\>", "MathCaption",
 CellID->19682],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"%", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->17911],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}]}]], "-", 
  FractionBox["1", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}]}]]}]], "Output",
 ImageSize->{134, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->20106]
}, Open  ]],

Cell["\<\
You need to manipulate it to get it back into the original form. \
\>", "MathCaption",
 CellID->9868],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->8644],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   SuperscriptBox["x", "2"]}]]], "Output",
 ImageSize->{48, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->23826]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " function assumes that any object that does not explicitly contain the \
integration variable is independent of it, and can be treated as a constant. \
As a result, ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " is like an inverse of the ",
 StyleBox["partial differentiation",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]], "InlineFormula"],
 "."
}], "Text",
 CellID->16436],

Cell[TextData[{
 "The variable ",
 Cell[BoxData["a"], "InlineFormula"],
 " is assumed to be independent of ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->17366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"a", " ", 
    RowBox[{"x", "^", "2"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->11592],

Cell[BoxData[
 FractionBox[
  RowBox[{"a", " ", 
   SuperscriptBox["x", "3"]}], "3"]], "Output",
 ImageSize->{31, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->24988]
}, Open  ]],

Cell["\<\
The integration variable can be any expression that does not involve explicit \
mathematical operations.\
\>", "MathCaption",
 CellID->18838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{
     RowBox[{"b", "[", "x", "]"}], "^", "2"}]}], ",", 
   RowBox[{"b", "[", "x", "]"}]}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->15865],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "3"], " ", "x", " ", 
  SuperscriptBox[
   RowBox[{"b", "[", "x", "]"}], "3"]}]], "Output",
 ImageSize->{62, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->27212]
}, Open  ]],

Cell[TextData[{
 "Another assumption that ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " implicitly makes is that all the symbolic quantities in your integrand \
have \[OpenCurlyDoubleQuote]generic\[CloseCurlyDoubleQuote] values. Thus, for \
example, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will tell you that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Integral]", 
    SuperscriptBox["x", "n"], "\[DifferentialD]", "x"}], TraditionalForm]], 
  "InlineMath"],
 " is ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    SuperscriptBox["x", 
     RowBox[{"n", "+", "1"}]], 
    RowBox[{"n", "+", "1"}]], TraditionalForm]], "InlineMath"],
 " even though this is not true in the special case ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "=", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->23947],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " gives the standard result for this integral, implicitly assuming that ",
 Cell[BoxData["n"], "InlineFormula"],
 " is not equal to ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->7446],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", "^", "n"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->19659],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["x", 
   RowBox[{"1", "+", "n"}]], 
  RowBox[{"1", "+", "n"}]]], "Output",
 ImageSize->{35, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->1052]
}, Open  ]],

Cell[TextData[{
 "If you specifically give an exponent of ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " produces a different result. "
}], "MathCaption",
 CellID->5771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", "^", 
    RowBox[{"-", "1"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->21256],

Cell[BoxData[
 RowBox[{"Log", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->11110]
}, Open  ]],

Cell[TextData[{
 "You should realize that the result for any particular integral can often be \
written in many different forms. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " tries to give you the most convenient form, following principles such as \
avoiding explicit complex numbers unless your input already contains them. "
}], "Text",
 CellID->32057],

Cell[TextData[{
 "This integral is given in terms of ",
 Cell[BoxData[
  ButtonBox["ArcTan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcTan"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->10666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"a", " ", 
       RowBox[{"x", "^", "2"}]}]}], ")"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->26250],

Cell[BoxData[
 FractionBox[
  RowBox[{"ArcTan", "[", 
   RowBox[{
    SqrtBox["a"], " ", "x"}], "]"}], 
  SqrtBox["a"]]], "Output",
 ImageSize->{98, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->12670]
}, Open  ]],

Cell[TextData[{
 "This integral is given in terms of ",
 Cell[BoxData[
  ButtonBox["ArcTanh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcTanh"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->13145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"b", " ", 
       RowBox[{"x", "^", "2"}]}]}], ")"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->3925],

Cell[BoxData[
 FractionBox[
  RowBox[{"ArcTanh", "[", 
   RowBox[{
    SqrtBox["b"], " ", "x"}], "]"}], 
  SqrtBox["b"]]], "Output",
 ImageSize->{105, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->31148]
}, Open  ]],

Cell["\<\
This is mathematically equal to the first integral, but is given in a \
somewhat different form. \
\>", "MathCaption",
 CellID->5874],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"b", "->", 
   RowBox[{"-", "a"}]}]}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->25774],

Cell[BoxData[
 FractionBox[
  RowBox[{"ArcTanh", "[", 
   RowBox[{
    SqrtBox[
     RowBox[{"-", "a"}]], " ", "x"}], "]"}], 
  SqrtBox[
   RowBox[{"-", "a"}]]]], "Output",
 ImageSize->{113, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->7043]
}, Open  ]],

Cell["The derivative is still correct. ", "MathCaption",
 CellID->9429],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"%", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->5536],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", 
   RowBox[{"a", " ", 
    SuperscriptBox["x", "2"]}]}]]], "Output",
 ImageSize->{51, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->6763]
}, Open  ]],

Cell[TextData[{
 "Even though they look quite different, both ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArcTan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcTan"], "[", "x", "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"-", 
   RowBox[{
    ButtonBox["ArcTan",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ArcTan"], "[", 
    RowBox[{"1", "/", "x"}], "]"}]}]], "InlineFormula"],
 " are indefinite integrals of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}], ")"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->20016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"ArcTan", "[", "x", "]"}], ",", 
      RowBox[{"-", 
       RowBox[{"ArcTan", "[", 
        RowBox[{"1", "/", "x"}], "]"}]}]}], "}"}], ",", "x"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->21858],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"]}]], ",", 
   FractionBox["1", 
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"]}]]}], "}"}]], "Output",
 ImageSize->{102, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->23934]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " chooses to use the simpler of the two forms. "
}], "MathCaption",
 CellID->7301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"x", "^", "2"}]}], ")"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->2061],

Cell[BoxData[
 RowBox[{"ArcTan", "[", "x", "]"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->32655]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->7749397],

Cell[TextData[ButtonBox["Calculus",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CalculusOverview"]], "RelatedTutorials",
 CellID->808424779]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Indefinite Integrals - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Calculus", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/CalculusOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DefiningDerivatives"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/IntegralsThatCanAndCannotBeDone"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 37, 16.4736818}", "context" -> "", 
    "keywords" -> {
     "antiderivative", "calculus", "constants of integration", "genericity", 
      "Integrate", "integration", "quadrature"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "The Mathematica function Integrate[f,x] gives you the indefinite \
integral \\[Integral]f dx. You can think of the operation of indefinite \
integration as being an inverse of differentiation. If you take the result \
from Integrate[f,x], and then differentiate it, you always get a result that \
is mathematically equal to the original expression f. In general, however, \
there is a whole family of results which have the property that their \
derivative is f. Integrate[f,x] gives you an expression whose derivative is \
f. You can get other expressions by adding an arbitrary constant of \
integration, or indeed by adding any function that is constant except at \
discrete points. If you fill in explicit limits for your integral, any such \
constants of integration must cancel out. But even though the indefinite \
integral can have arbitrary constants added, it is still often very \
convenient to manipulate it without filling in the limits. ", 
    "synonyms" -> {"3.5.6"}, "title" -> "Indefinite Integrals", "type" -> 
    "Tutorial", "uri" -> "tutorial/IndefiniteIntegrals"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.5.6"->{
  Cell[1215, 42, 82, 2, 70, "Title",
   CellTags->{"S3.5.6", "6.1"},
   CellID->6667]},
 "6.1"->{
  Cell[1215, 42, 82, 2, 70, "Title",
   CellTags->{"S3.5.6", "6.1"},
   CellID->6667]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.5.6", 19559, 758},
 {"6.1", 19657, 762}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 590, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1215, 42, 82, 2, 70, "Title",
 CellTags->{"S3.5.6", "6.1"},
 CellID->6667],
Cell[1300, 46, 1059, 37, 70, "Text",
 CellID->21717],
Cell[2362, 85, 751, 24, 70, "Text",
 CellID->15928],
Cell[3116, 111, 305, 6, 70, "Text",
 CellID->17590],
Cell[3424, 119, 157, 5, 70, "MathCaption",
 CellID->31099],
Cell[CellGroupData[{
Cell[3606, 128, 148, 5, 28, "Input",
 CellID->4580],
Cell[3757, 135, 199, 7, 54, "Output",
 CellID->13870]
}, Open  ]],
Cell[3971, 145, 383, 12, 70, "MathCaption",
 CellID->2990],
Cell[CellGroupData[{
Cell[4379, 161, 141, 5, 28, "Input",
 CellID->25412],
Cell[4523, 168, 178, 6, 36, "Output",
 CellID->14000]
}, Open  ]],
Cell[4716, 177, 313, 13, 70, "MathCaption",
 CellID->18064],
Cell[CellGroupData[{
Cell[5054, 194, 230, 9, 70, "Input",
 CellID->28275],
Cell[5287, 205, 401, 15, 51, "Output",
 CellID->20084]
}, Open  ]],
Cell[5703, 223, 109, 3, 70, "MathCaption",
 CellID->19682],
Cell[CellGroupData[{
Cell[5837, 230, 117, 4, 70, "Input",
 CellID->17911],
Cell[5957, 236, 392, 15, 53, "Output",
 CellID->20106]
}, Open  ]],
Cell[6364, 254, 111, 3, 70, "MathCaption",
 CellID->9868],
Cell[CellGroupData[{
Cell[6500, 261, 100, 3, 70, "Input",
 CellID->8644],
Cell[6603, 266, 242, 9, 52, "Output",
 CellID->23826]
}, Open  ]],
Cell[6860, 278, 682, 23, 70, "Text",
 CellID->16436],
Cell[7545, 303, 188, 7, 70, "MathCaption",
 CellID->17366],
Cell[CellGroupData[{
Cell[7758, 314, 174, 6, 70, "Input",
 CellID->11592],
Cell[7935, 322, 223, 8, 54, "Output",
 CellID->24988]
}, Open  ]],
Cell[8173, 333, 151, 4, 70, "MathCaption",
 CellID->18838],
Cell[CellGroupData[{
Cell[8349, 341, 234, 8, 70, "Input",
 CellID->15865],
Cell[8586, 351, 261, 9, 51, "Output",
 CellID->27212]
}, Open  ]],
Cell[8862, 363, 922, 31, 70, "Text",
 CellID->23947],
Cell[9787, 396, 296, 10, 70, "MathCaption",
 CellID->7446],
Cell[CellGroupData[{
Cell[10108, 410, 149, 5, 70, "Input",
 CellID->19659],
Cell[10260, 417, 245, 9, 54, "Output",
 CellID->1052]
}, Open  ]],
Cell[10520, 429, 240, 9, 70, "MathCaption",
 CellID->5771],
Cell[CellGroupData[{
Cell[10785, 442, 169, 6, 70, "Input",
 CellID->21256],
Cell[10957, 450, 184, 6, 36, "Output",
 CellID->11110]
}, Open  ]],
Cell[11156, 459, 363, 8, 70, "Text",
 CellID->32057],
Cell[11522, 469, 211, 8, 70, "MathCaption",
 CellID->10666],
Cell[CellGroupData[{
Cell[11758, 481, 256, 9, 70, "Input",
 CellID->26250],
Cell[12017, 492, 259, 10, 64, "Output",
 CellID->12670]
}, Open  ]],
Cell[12291, 505, 213, 8, 70, "MathCaption",
 CellID->13145],
Cell[CellGroupData[{
Cell[12529, 517, 255, 9, 70, "Input",
 CellID->3925],
Cell[12787, 528, 261, 10, 64, "Output",
 CellID->31148]
}, Open  ]],
Cell[13063, 541, 143, 4, 70, "MathCaption",
 CellID->5874],
Cell[CellGroupData[{
Cell[13231, 549, 134, 5, 70, "Input",
 CellID->25774],
Cell[13368, 556, 300, 12, 64, "Output",
 CellID->7043]
}, Open  ]],
Cell[13683, 571, 71, 1, 70, "MathCaption",
 CellID->9429],
Cell[CellGroupData[{
Cell[13779, 576, 117, 4, 70, "Input",
 CellID->5536],
Cell[13899, 582, 248, 9, 53, "Output",
 CellID->6763]
}, Open  ]],
Cell[14162, 594, 655, 24, 70, "MathCaption",
 CellID->20016],
Cell[CellGroupData[{
Cell[14842, 622, 334, 12, 70, "Input",
 CellID->21858],
Cell[15179, 636, 350, 13, 52, "Output",
 CellID->23934]
}, Open  ]],
Cell[15544, 652, 220, 7, 70, "MathCaption",
 CellID->7301],
Cell[CellGroupData[{
Cell[15789, 663, 227, 8, 70, "Input",
 CellID->2061],
Cell[16019, 673, 188, 6, 36, "Output",
 CellID->32655]
}, Open  ]],
Cell[CellGroupData[{
Cell[16244, 684, 70, 1, 70, "RelatedTutorialsSection",
 CellID->7749397],
Cell[16317, 687, 146, 3, 70, "RelatedTutorials",
 CellID->808424779]
}, Open  ]]
}, Open  ]],
Cell[16490, 694, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

