(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27232,        897]
NotebookOptionsPosition[     20455,        699]
NotebookOutlinePosition[     24213,        784]
CellTagsIndexPosition[     24122,        778]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/NumbersOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Numbers\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ComplexInfinity" :> 
          Documentation`HelpLookup["paclet:ref/ComplexInfinity"], 
          "DirectedInfinity" :> 
          Documentation`HelpLookup["paclet:ref/DirectedInfinity"], 
          "Indeterminate" :> 
          Documentation`HelpLookup["paclet:ref/Indeterminate"], "Infinity" :> 
          Documentation`HelpLookup["paclet:ref/Infinity"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ComplexInfinity\"\>", 
       2->"\<\"DirectedInfinity\"\>", 3->"\<\"Indeterminate\"\>", 
       4->"\<\"Infinity\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Indeterminate and Infinite Results", "Title",
 CellTags->{"S3.1.8", "8.1"},
 CellID->3815],

Cell[TextData[{
 "If you type in an expression like ",
 Cell[BoxData[
  RowBox[{"0", "/", "0"}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " prints a message, and returns the result ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21174],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"0", "/", "0"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30582],

Cell[BoxData[
 RowBox[{
  RowBox[{"Power", "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"Infinite expression \\!\\(1\\/0\\) encountered. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/infy\\\", \
ButtonNote -> \\\"Power::infy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[1]:=",
 CellID->121720410],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Infinity]", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"Indeterminate expression \\!\\(0\\\\ ComplexInfinity\\) \
encountered. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/indet\\\", ButtonNote -> \
\\\"Infinity::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[1]:=",
 CellID->535920986],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3810381]
}, Open  ]],

Cell[TextData[{
 "An expression like ",
 Cell[BoxData[
  RowBox[{"0", "/", "0"}]], "InlineFormula"],
 " is an example of an ",
 StyleBox["indeterminate numerical result",
  FontSlant->"Italic"],
 ". If you type in ",
 Cell[BoxData[
  RowBox[{"0", "/", "0"}]], "InlineFormula"],
 ", there is no way for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to know what answer you want. If you got ",
 Cell[BoxData[
  RowBox[{"0", "/", "0"}]], "InlineFormula"],
 " by taking the limit of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "/", "x"}], TraditionalForm]], "InlineMath"],
 " as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[Rule]", "0"}], TraditionalForm]], "InlineMath"],
 ", then you might want the answer ",
 Cell[BoxData["1"], "InlineFormula"],
 ". On the other hand, if you got ",
 Cell[BoxData[
  RowBox[{"0", "/", "0"}]], "InlineFormula"],
 " instead as the limit of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "x", "/", "x"}], TraditionalForm]], "InlineMath"],
 ", then you probably want the answer ",
 Cell[BoxData["2"], "InlineFormula"],
 ". The expression ",
 Cell[BoxData[
  RowBox[{"0", "/", "0"}]], "InlineFormula"],
 " on its own does not contain enough information to choose between these and \
other cases. As a result, its value must be considered indeterminate."
}], "Text",
 CellID->20900],

Cell[TextData[{
 "Whenever an indeterminate result is produced in an arithmetic computation, \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " prints a warning message, and then returns ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 " as the result of the computation. If you ever try to use ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 " in an arithmetic computation, you always get the result ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 ". A single indeterminate expression effectively \
\[OpenCurlyDoubleQuote]poisons\[CloseCurlyDoubleQuote] any arithmetic \
computation. (The symbol ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 " plays a role in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " similar to the \[OpenCurlyDoubleQuote]not a number\[CloseCurlyDoubleQuote] \
object in the IEEE Floating Point Standard.)"
}], "Text",
 CellID->1575],

Cell[TextData[{
 "The usual laws of arithmetic simplification are suspended in the case of ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->19337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Indeterminate", "-", "Indeterminate"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15376],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->259706608]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 " \[OpenCurlyDoubleQuote]poisons\[CloseCurlyDoubleQuote] any arithmetic \
computation, and leads to an indeterminate result. "
}], "MathCaption",
 CellID->19424],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "Indeterminate"}], "-", "7"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->15864],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->705472665]
}, Open  ]],

Cell[TextData[{
 "When you do arithmetic computations inside ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programs, it is often important to be able to tell whether indeterminate \
results were generated in the computations. You can do this by using the \
function ",
 Cell[BoxData[
  ButtonBox["Check",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Check"]], "InlineFormula"],
 " discussed in\[NonBreakingSpace]\"",
 ButtonBox["Messages\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/Messages"],
 " to test whether any warning messages associated with indeterminate results \
were produced. "
}], "Text",
 CellID->2695],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Check",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Check"]], "InlineFormula"],
 " inside a program to test whether warning messages are generated in a \
computation. "
}], "MathCaption",
 CellID->18525],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Check", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"7", "-", "7"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"8", "-", "8"}], ")"}]}], ",", "meaningless"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->18629],

Cell[BoxData[
 RowBox[{
  RowBox[{"Power", "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"Infinite expression \\!\\(1\\/0\\) encountered. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/infy\\\", \
ButtonNote -> \\\"Power::infy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[4]:=",
 CellID->55756913],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Infinity]", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"Indeterminate expression \\!\\(0\\\\ ComplexInfinity\\) \
encountered. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/indet\\\", ButtonNote -> \
\\\"Infinity::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[4]:=",
 CellID->27774234],

Cell[BoxData["meaningless"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->903220409]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Indeterminate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Indeterminate"], Cell[
    "an indeterminate numerical result", "TableText"]},
   {
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[
    "a positive infinite quantity", "TableText"]},
   {
    RowBox[{"-", 
     ButtonBox["Infinity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Infinity"]}], Cell[TextData[{
     "a negative infinite quantity (",
     Cell[BoxData[
      RowBox[{
       ButtonBox["DirectedInfinity",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DirectedInfinity"], "[", "-", "1", "]"}]], 
      "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["DirectedInfinity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DirectedInfinity"], "[", 
     StyleBox["r", "TI"], "]"}], Cell[TextData[{
     "an infinite quantity with complex direction ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    ButtonBox["ComplexInfinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ComplexInfinity"], Cell[
    "an infinite quantity with an undetermined direction", "TableText"]},
   {
    RowBox[{
     ButtonBox["DirectedInfinity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DirectedInfinity"], "[", "]"}], Cell[TextData[{
     "equivalent to ",
     Cell[BoxData[
      ButtonBox["ComplexInfinity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ComplexInfinity"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->31744],

Cell["Indeterminate and infinite quantities. ", "Caption",
 CellID->21706],

Cell[TextData[{
 "There are many situations where it is convenient to be able to do \
calculations with infinite quantities. The symbol ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 " in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " represents a positive infinite quantity. You can use it to specify such \
things as limits of sums and integrals. You can also do some arithmetic \
calculations with it. "
}], "Text",
 CellID->10075],

Cell["Here is an integral with an infinite limit. ", "MathCaption",
 CellID->16071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"x", "^", "3"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->6490],

Cell[BoxData[
 FractionBox["1", "2"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->761750524]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " knows that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "\[Infinity]", "=", "0"}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "MathCaption",
 CellID->14819],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", "Infinity"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->19979],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->104750908]
}, Open  ]],

Cell["\<\
If you try to find the difference between two infinite quantities, you get an \
indeterminate result. \
\>", "MathCaption",
 CellID->5158],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Infinity", "-", "Infinity"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->16807],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Infinity]", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"Indeterminate expression \\!\\(\\(\\(-\[Infinity]\\)\\) + \
\[Infinity]\\) encountered. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/indet\\\", ButtonNote -> \
\\\"Infinity::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[7]:=",
 CellID->17327881],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->889870049]
}, Open  ]],

Cell[TextData[{
 "There are a number of subtle points that arise in handling infinite \
quantities. One of them concerns the \[OpenCurlyDoubleQuote]direction\
\[CloseCurlyDoubleQuote] of an infinite quantity. When you do an infinite \
integral, you typically think of performing the integration along a path in \
the complex plane that goes to infinity in some direction. In this case, it \
is important to distinguish different versions of infinity that correspond to \
different directions in the complex plane. ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " are two examples, but for some purposes one also needs ",
 Cell[BoxData[
  FormBox[
   RowBox[{"i", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " and so on."
}], "Text",
 CellID->17438],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", infinite quantities can have a \[OpenCurlyDoubleQuote]direction\
\[CloseCurlyDoubleQuote], specified by a complex number. When you type in the \
symbol ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 ", representing a positive infinite quantity, this is converted internally \
to the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DirectedInfinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectedInfinity"], "[", "1", "]"}]], 
  "InlineFormula"],
 ", which represents an infinite quantity in the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "1"}], TraditionalForm]], "InlineMath"],
 " direction. Similarly, ",
 Cell[BoxData[
  RowBox[{"-", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 " becomes ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DirectedInfinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectedInfinity"], "[", 
   RowBox[{"-", "1"}], "]"}]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["I",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/I"], 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 " becomes ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DirectedInfinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectedInfinity"], "[", 
   ButtonBox["I",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/I"], "]"}]], "InlineFormula"],
 ". Although the ",
 Cell[BoxData[
  ButtonBox["DirectedInfinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DirectedInfinity"]], "InlineFormula"],
 " form is always used internally, the standard output format for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DirectedInfinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectedInfinity"], "[", 
   StyleBox["r", "TI"], "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   StyleBox["r", "TI"], " ", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 "."
}], "Text",
 CellID->21156],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 " is converted internally to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DirectedInfinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectedInfinity"], "[", "1", "]"}]], 
  "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->14820],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Infinity", "//", "FullForm"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->30432],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"DirectedInfinity", "[", "1", "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]//FullForm=",
 CellID->187598924]
}, Open  ]],

Cell[TextData[{
 "Although the notion of a \[OpenCurlyDoubleQuote]directed infinity\
\[CloseCurlyDoubleQuote] is often useful, it is not always available. If you \
type in ",
 Cell[BoxData[
  RowBox[{"1", "/", "0"}]], "InlineFormula"],
 ", you get an infinite result, but there is no way to determine the \
\[OpenCurlyDoubleQuote]direction\[CloseCurlyDoubleQuote] of the infinity. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " represents the result of ",
 Cell[BoxData[
  RowBox[{"1", "/", "0"}]], "InlineFormula"],
 " as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DirectedInfinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectedInfinity"], "[", "]"}]], 
  "InlineFormula"],
 ". In standard output form, this undirected infinity is printed out as ",
 Cell[BoxData[
  ButtonBox["ComplexInfinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexInfinity"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->27222],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"1", "/", "0"}]], "InlineFormula"],
 " gives an undirected form of infinity. "
}], "MathCaption",
 CellID->22957],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", "0"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->553],

Cell[BoxData[
 RowBox[{
  RowBox[{"Power", "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"Infinite expression \\!\\(1\\/0\\) encountered. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/infy\\\", \
ButtonNote -> \\\"Power::infy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[9]:=",
 CellID->356182433],

Cell[BoxData["ComplexInfinity"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->19461647]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->575310796],

Cell[TextData[ButtonBox["Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumbersOverview"]], "RelatedTutorials",
 CellID->54483688]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Indeterminate and Infinite Results - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numbers", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/NumbersOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/IntervalArithmetic"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ControllingNumericalEvaluation"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 37, 17.3330788}", "context" -> "", 
    "keywords" -> {
     "check", "ComplexInfinity", "complex infinity", "complex numbers", 
      "DirectedInfinity", "directed infinity", "division", "errors", 
      "exceptions", "IEEE Floating Point Standard", "indeterminate", 
      "indeterminate results", "infinite results", "infinity", "limits", 
      "NaN", "overflow"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "If you type in an expression like 0/0, Mathematica prints a message, and \
returns the result Indeterminate. An expression like 0/0 is an example of an \
indeterminate numerical result. If you type in 0/0, there is no way for \
Mathematica to know what answer you want. If you got 0/0 by taking the limit \
of x/x as x->0, then you might want the answer 1. On the other hand, if you \
got 0/0 instead as the limit of 2x/x, then you probably want the answer 2. \
The expression 0/0 on its own does not contain enough information to choose \
between these and other cases. As a result, its value must be considered \
indeterminate. Whenever an indeterminate result is produced in an arithmetic \
computation, Mathematica prints a warning message, and then returns \
Indeterminate as the result of the computation. If you ever try to use \
Indeterminate in an arithmetic computation, you always get the result \
Indeterminate. A single indeterminate expression effectively 'poisons' any \
arithmetic computation. (The symbol Indeterminate plays a role in Mathematica \
similar to the 'not a number' object in the IEEE Floating Point Standard.)", 
    "synonyms" -> {"3.1.8"}, "title" -> "Indeterminate and Infinite Results", 
    "type" -> "Tutorial", "uri" -> 
    "tutorial/IndeterminateAndInfiniteResults"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.1.8"->{
  Cell[2148, 64, 96, 2, 70, "Title",
   CellTags->{"S3.1.8", "8.1"},
   CellID->3815]},
 "8.1"->{
  Cell[2148, 64, 96, 2, 70, "Title",
   CellTags->{"S3.1.8", "8.1"},
   CellID->3815]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.1.8", 23913, 767},
 {"8.1", 24011, 771}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1523, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2148, 64, 96, 2, 70, "Title",
 CellTags->{"S3.1.8", "8.1"},
 CellID->3815],
Cell[2247, 68, 388, 14, 70, "MathCaption",
 CellID->21174],
Cell[CellGroupData[{
Cell[2660, 86, 88, 3, 70, "Input",
 CellID->30582],
Cell[2751, 91, 411, 8, 70, "Message",
 CellID->121720410],
Cell[3165, 101, 446, 9, 19, "Message",
 CellID->535920986],
Cell[3614, 112, 168, 5, 36, "Output",
 CellID->3810381]
}, Open  ]],
Cell[3797, 120, 1319, 41, 70, "Text",
 CellID->20900],
Cell[5119, 163, 1212, 33, 70, "Text",
 CellID->1575],
Cell[6334, 198, 263, 8, 70, "MathCaption",
 CellID->19337],
Cell[CellGroupData[{
Cell[6622, 210, 112, 3, 28, "Input",
 CellID->15376],
Cell[6737, 215, 170, 5, 36, "Output",
 CellID->259706608]
}, Open  ]],
Cell[6922, 223, 307, 8, 70, "MathCaption",
 CellID->19424],
Cell[CellGroupData[{
Cell[7254, 235, 123, 4, 70, "Input",
 CellID->15864],
Cell[7380, 241, 170, 5, 36, "Output",
 CellID->705472665]
}, Open  ]],
Cell[7565, 249, 642, 18, 70, "Text",
 CellID->2695],
Cell[8210, 269, 269, 9, 70, "MathCaption",
 CellID->18525],
Cell[CellGroupData[{
Cell[8504, 282, 256, 9, 70, "Input",
 CellID->18629],
Cell[8763, 293, 410, 8, 70, "Message",
 CellID->55756913],
Cell[9176, 303, 445, 9, 70, "Message",
 CellID->27774234],
Cell[9624, 314, 168, 5, 36, "Output",
 CellID->903220409]
}, Open  ]],
Cell[9807, 322, 1969, 60, 70, "DefinitionBox",
 CellID->31744],
Cell[11779, 384, 74, 1, 70, "Caption",
 CellID->21706],
Cell[11856, 387, 518, 14, 70, "Text",
 CellID->10075],
Cell[12377, 403, 83, 1, 70, "MathCaption",
 CellID->16071],
Cell[CellGroupData[{
Cell[12485, 408, 238, 8, 70, "Input",
 CellID->6490],
Cell[12726, 418, 178, 6, 51, "Output",
 CellID->761750524]
}, Open  ]],
Cell[12919, 427, 233, 10, 70, "MathCaption",
 CellID->14819],
Cell[CellGroupData[{
Cell[13177, 441, 95, 3, 70, "Input",
 CellID->19979],
Cell[13275, 446, 158, 5, 36, "Output",
 CellID->104750908]
}, Open  ]],
Cell[13448, 454, 148, 4, 70, "MathCaption",
 CellID->5158],
Cell[CellGroupData[{
Cell[13621, 462, 102, 3, 70, "Input",
 CellID->16807],
Cell[13726, 467, 462, 9, 70, "Message",
 CellID->17327881],
Cell[14191, 478, 170, 5, 36, "Output",
 CellID->889870049]
}, Open  ]],
Cell[14376, 486, 909, 21, 70, "Text",
 CellID->17438],
Cell[15288, 509, 2202, 75, 70, "Text",
 CellID->21156],
Cell[17493, 586, 377, 14, 70, "MathCaption",
 CellID->14820],
Cell[CellGroupData[{
Cell[17895, 604, 103, 3, 70, "Input",
 CellID->30432],
Cell[18001, 609, 334, 12, 50, "Output",
 CellID->187598924]
}, Open  ]],
Cell[18350, 624, 939, 27, 70, "Text",
 CellID->27222],
Cell[19292, 653, 154, 5, 70, "MathCaption",
 CellID->22957],
Cell[CellGroupData[{
Cell[19471, 662, 86, 3, 70, "Input",
 CellID->553],
Cell[19560, 667, 411, 8, 70, "Message",
 CellID->356182433],
Cell[19974, 677, 172, 5, 36, "Output",
 CellID->19461647]
}, Open  ]],
Cell[CellGroupData[{
Cell[20183, 687, 72, 1, 70, "RelatedTutorialsSection",
 CellID->575310796],
Cell[20258, 690, 143, 3, 70, "RelatedTutorials",
 CellID->54483688]
}, Open  ]]
}, Open  ]],
Cell[20428, 697, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

