(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     57207,       2032]
NotebookOptionsPosition[     47505,       1702]
NotebookOutlinePosition[     50462,       1778]
CellTagsIndexPosition[     50369,       1772]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Equations and Inequalities" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Manipulating Equations and Inequalities\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FindInstance" :> 
          Documentation`HelpLookup["paclet:ref/FindInstance"], "Reduce" :> 
          Documentation`HelpLookup["paclet:ref/Reduce"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"FindInstance\"\>", 
       2->"\<\"Reduce\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Inequalities", "Title",
 CellTags->{"S3.4.8", "8.1"},
 CellID->9389],

Cell[TextData[{
 "Just as the ",
 StyleBox["equation",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"3", "x"}]}], "==", "2"}]], "InlineFormula"],
 " asserts that ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"3", "x"}]}]], "InlineFormula"],
 " is equal to ",
 Cell[BoxData["2"], "InlineFormula"],
 ", so also the ",
 StyleBox["inequality",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"3", "x"}]}], ">", "2"}]], "InlineFormula"],
 " asserts that ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"3", "x"}]}]], "InlineFormula"],
 " is greater than ",
 Cell[BoxData["2"], "InlineFormula"],
 ". In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " works not only on equations, but also on inequalities."
}], "Text",
 CellID->27625],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Reduce",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Reduce"], "[", "{", 
     SubscriptBox[
      StyleBox["ineq", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["ineq", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "reduce a collection of inequalities in ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->8029],

Cell["Manipulating univariate inequalities. ", "Caption",
 CellID->3128],

Cell["This pair of inequalities reduces to a single inequality. ", \
"MathCaption",
 CellID->2039],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0", "<", "x", "<", "2"}], ",", 
     RowBox[{"1", "<", "x", "<", "4"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1527],

Cell[BoxData[
 RowBox[{"1", "<", "x", "<", "2"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->69771236]
}, Open  ]],

Cell["These inequalities can never simultaneously be satisfied. ", \
"MathCaption",
 CellID->8490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "<", "1"}], ",", 
     RowBox[{"x", ">", "3"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29648],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->55132239]
}, Open  ]],

Cell[TextData[{
 "When applied to an equation, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"], "[", 
   RowBox[{
    StyleBox["eqn", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " tries to get a result consisting of simple equations for ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "=="}]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "1"], TraditionalForm]], "InlineMath"],
 ", \[Ellipsis]",
 Cell[BoxData[""], "InlineFormula"],
 ". When applied to an inequality, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"], "[", 
   RowBox[{
    StyleBox["ineq", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " does the exactly analogous thing, and tries to get a result consisting of \
simple inequalities for ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " of the form ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["l", "1"], TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  RowBox[{"<", 
   StyleBox["x", "TI"], "<"}]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "1"], TraditionalForm]], "InlineMath"],
 ", \[Ellipsis]",
 Cell[BoxData[""], "InlineFormula"],
 ". "
}], "Text",
 CellID->5517],

Cell[TextData[{
 "This reduces a quadratic equation to two simple equations for ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->24192],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"3", "x"}]}], "==", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->32530],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "-", 
      SqrtBox["17"]}], ")"}]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", 
      SqrtBox["17"]}], ")"}]}]}]}]], "Output",
 ImageSize->{245, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->588187597]
}, Open  ]],

Cell[TextData[{
 "This reduces a quadratic inequality to two simple inequalities for ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->3148],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"3", "x"}]}], ">", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->24056],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "<", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "-", 
      SqrtBox["17"]}], ")"}]}]}], "||", 
  RowBox[{"x", ">", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", 
      SqrtBox["17"]}], ")"}]}]}]}]], "Output",
 ImageSize->{239, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->126580371]
}, Open  ]],

Cell[TextData[{
 "You can think of the result generated by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"], "[", 
   RowBox[{
    StyleBox["ineq", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " as representing a series of intervals, described by inequalities. Since \
the graph of a polynomial of degree ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " can go up and down as many as ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " times, a polynomial inequality of degree ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " can give rise to as many as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "/", "2", "+", "1"}], TraditionalForm]], "InlineMath"],
 " distinct intervals. "
}], "Text",
 CellID->2282],

Cell["This inequality yields three distinct intervals. ", "MathCaption",
 CellID->29743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"x", "-", "2"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"x", "-", "3"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"x", "-", "4"}], ")"}]}], ">", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->26439],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "<", "1"}], "||", 
  RowBox[{"2", "<", "x", "<", "3"}], "||", 
  RowBox[{"x", ">", "4"}]}]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->185603014]
}, Open  ]],

Cell["The ends of the intervals are at roots and poles. ", "MathCaption",
 CellID->21493],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"1", "<", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"3", "x"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"x", "+", "1"}], ")"}]}], "<", "2"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1927],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "-", 
    SqrtBox["2"]}], "<", "x", "<", 
   RowBox[{"-", "2"}]}], "||", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SqrtBox["2"]}], "<", "x", "<", "1"}]}]], "Output",
 ImageSize->{218, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->645372781]
}, Open  ]],

Cell[TextData[{
 "Solving this inequality requires introducing ",
 Cell[BoxData[
  ButtonBox["ProductLog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ProductLog"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->30393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "-", "2"}], "<", 
    RowBox[{"Log", "[", "x", "]"}], "<", "x"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->21033],

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "::", "\<\"ztest\"\>"}], ":", 
  " ", "\<\"Unable to decide whether numeric quantities \\!\\({\\(\\(\\(\\(-2\
\\)\\) - \\(\\(Log[\\(\\(-\\(\\(ProductLog[\\(\\(-\\(\\(Power[\\(\\(\
\[LeftSkeleton] 2 \[RightSkeleton]\\)\\)]\\)\\)\\)\\)]\\)\\)\\)\\)]\\)\\) - \
\\(\\(ProductLog[\\(\\(-\\(\\(1\\/\[ExponentialE]\\^2\\)\\)\\)\\)]\\)\\)\\)\\)\
, \\(\\(\\(\\(-2\\)\\) - \
\\(\\(Log[\\(\\(-\\(\\(ProductLog[\\(\\(\\(\\(-1\\)\\), \
\\(\\(-\\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\)\\)\\)\\)\\)]\\)\\)\\)\\)]\\)\\) - \
\\(\\(ProductLog[\\(\\(\\(\\(-1\\)\\), \
\\(\\(-\\(\\(1\\/\[ExponentialE]\\^2\\)\\)\\)\\)\\)\\)]\\)\\)\\)\\)}\\) are \
equal to zero. Assuming they are.\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[7]:=",
 CellID->500455932],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"ProductLog", "[", 
    RowBox[{"-", 
     FractionBox["1", 
      SuperscriptBox["\[ExponentialE]", "2"]]}], "]"}]}], "<", "x", "<", 
  RowBox[{"-", 
   RowBox[{"ProductLog", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       SuperscriptBox["\[ExponentialE]", "2"]]}]}], "]"}]}]}]], "Output",
 ImageSize->{297, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->974563338]
}, Open  ]],

Cell[TextData[{
 "Transcendental functions like ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", 
    RowBox[{"(", "x", ")"}]}], TraditionalForm]], "InlineMath"],
 " have graphs that go up and down infinitely many times, so that infinitely \
many intervals can be generated. "
}], "Text",
 CellID->19026],

Cell["The second inequality allows only finitely many intervals. ", \
"MathCaption",
 CellID->5842],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], ">", "0"}], ",", 
     RowBox[{"0", "<", "x", "<", "20"}]}], "}"}], ",", "x"}], "]"}]], "Input",\

 CellLabel->"In[8]:=",
 CellID->19080],

Cell[BoxData[
 RowBox[{
  RowBox[{"0", "<", "x", "<", "\[Pi]"}], "||", 
  RowBox[{
   RowBox[{"2", " ", "\[Pi]"}], "<", "x", "<", 
   RowBox[{"3", " ", "\[Pi]"}]}], "||", 
  RowBox[{
   RowBox[{"4", " ", "\[Pi]"}], "<", "x", "<", 
   RowBox[{"5", " ", "\[Pi]"}]}], "||", 
  RowBox[{
   RowBox[{"6", " ", "\[Pi]"}], "<", "x", "<", "20"}]}]], "Output",
 ImageSize->{322, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->637610912]
}, Open  ]],

Cell[TextData[{
 "This is how ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " represents infinitely many intervals. "
}], "MathCaption",
 CellID->4961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], ">", "0"}], ",", 
     RowBox[{"0", "<", "x"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->28717],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0", "<", "x", "<", "\[Pi]"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "\[GreaterEqual]", "1"}], "&&", 
      RowBox[{
       RowBox[{"2", " ", "\[Pi]", " ", 
        RowBox[{"C", "[", "1", "]"}]}], "<", "x", "<", 
       RowBox[{"\[Pi]", "+", 
        RowBox[{"2", " ", "\[Pi]", " ", 
         RowBox[{"C", "[", "1", "]"}]}]}]}]}], ")"}]}], ")"}]}]], "Output",
 ImageSize->{442, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->18318334]
}, Open  ]],

Cell["Fairly simple inputs can give fairly complicated results. ", \
"MathCaption",
 CellID->5920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], "+", 
       RowBox[{"Sin", "[", 
        RowBox[{"3", "x"}], "]"}]}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", "2"}], "<", "20"}]}], "}"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->13245],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", "3"}], " ", 
    SqrtBox["2"]}], "<", "x", "<", 
   RowBox[{"-", "\[Pi]"}]}], "||", 
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "4"}], "-", 
        SqrtBox["7"]}], ")"}]}], "]"}]}], "<", "x", "<", 
   RowBox[{"2", " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "4"}], "+", 
        SqrtBox["7"]}], ")"}]}], "]"}]}]}], "||", 
  RowBox[{"0", "<", "x", "<", 
   FractionBox["\[Pi]", "2"]}], "||", 
  RowBox[{
   FractionBox["\[Pi]", "2"], "<", "x", "<", "\[Pi]"}], "||", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", "\[Pi]"}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"ArcTan", "[", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "4"}], "-", 
         SqrtBox["7"]}], ")"}]}], "]"}]}]}], "<", "x", "<", 
   RowBox[{"3", " ", 
    SqrtBox["2"]}]}]}]], "Output",
 ImageSize->{459, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->24046281]
}, Open  ]],

Cell[TextData[{
 "If you have inequalities that involve ",
 Cell[BoxData["<="], "InlineFormula"],
 " as well as ",
 Cell[BoxData["<"], "InlineFormula"],
 ", there may be isolated points where the inequalities can be satisfied. ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " represents such points by giving equations. "
}], "Text",
 CellID->30121],

Cell["\<\
This inequality can be satisfied at just two isolated points. \
\>", "MathCaption",
 CellID->27782],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", 
       RowBox[{"3", "x"}], "+", "1"}], ")"}], "^", "2"}], "<=", "0"}], ",", 
   "x"}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->2782],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"3", "-", 
      SqrtBox["5"]}], ")"}]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"3", "+", 
      SqrtBox["5"]}], ")"}]}]}]}]], "Output",
 ImageSize->{215, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->331052878]
}, Open  ]],

Cell["This yields both intervals and isolated points. ", "MathCaption",
 CellID->6491],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Max", "[", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"2", "x"}], "]"}], ",", 
        RowBox[{"Cos", "[", 
         RowBox[{"3", "x"}], "]"}]}], "]"}], "<=", "0"}], ",", 
     RowBox[{"0", "<", "x", "<", "10"}]}], "}"}], ",", "x"}], "]"}]], "Input",\

 CellLabel->"In[12]:=",
 CellID->31870],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   FractionBox["\[Pi]", "2"]}], "||", 
  RowBox[{
   FractionBox[
    RowBox[{"5", " ", "\[Pi]"}], "6"], "\[LessEqual]", "x", "\[LessEqual]", 
   "\[Pi]"}], "||", 
  RowBox[{
   FractionBox[
    RowBox[{"3", " ", "\[Pi]"}], "2"], "\[LessEqual]", "x", "\[LessEqual]", 
   FractionBox[
    RowBox[{"11", " ", "\[Pi]"}], "6"]}], "||", 
  RowBox[{"x", "\[Equal]", 
   FractionBox[
    RowBox[{"5", " ", "\[Pi]"}], "2"]}], "||", 
  RowBox[{
   FractionBox[
    RowBox[{"17", " ", "\[Pi]"}], "6"], "\[LessEqual]", "x", "\[LessEqual]", 
   RowBox[{"3", " ", "\[Pi]"}]}]}]], "Output",
 ImageSize->{399, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->255052314]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Reduce",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Reduce"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["ineq", "TI"], "1"], ",", 
        SubscriptBox[
         StyleBox["ineq", "TI"], "2"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], "1"], Cell[", ", "TableText"], 
        SubscriptBox[
         StyleBox["x", "TI"], "2"], Cell[", \[Ellipsis] }]", "TableText"], 
        StyleBox[" ", "TR"]}]}]}]}], Cell[
    "reduce a collection of inequalities in several variables", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->22195],

Cell["Multivariate inequalities. ", "Caption",
 CellID->13143],

Cell[TextData[{
 "For inequalities involving several variables, ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " in effect yields nested collections of interval specifications, in which \
later variables have bounds that depend on earlier variables. "
}], "Text",
 CellID->11763],

Cell[TextData[{
 "This represents the unit disk as nested inequalities for ",
 Cell[BoxData["x"], "InlineFormula"],
 " and ",
 Cell[BoxData["y"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->14771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->23592],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "1"}], "<", "x", "<", "1"}], "&&", 
  RowBox[{
   RowBox[{"-", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}]]}], "<", "y", "<", 
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"]}]]}]}]], "Output",
 ImageSize->{225, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->15970362]
}, Open  ]],

Cell[TextData[{
 "In geometrical terms, any linear inequality divides space into two halves. \
Lists of linear inequalities thus define polyhedra, sometimes bounded, \
sometimes not. ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " represents such polyhedra in terms of nested inequalities. The corners of \
the polyhedra always appear among the endpoints of these inequalities. "
}], "Text",
 CellID->19217],

Cell["This defines a triangular region in the plane. ", "MathCaption",
 CellID->25412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", ">", "0"}], ",", 
     RowBox[{"y", ">", "0"}], ",", 
     RowBox[{
      RowBox[{"x", "+", "y"}], "<", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->5881],

Cell[BoxData[
 RowBox[{
  RowBox[{"0", "<", "x", "<", "1"}], "&&", 
  RowBox[{"0", "<", "y", "<", 
   RowBox[{"1", "-", "x"}]}]}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->898468420]
}, Open  ]],

Cell["\<\
Even a single triangle may need to be described as two components. \
\>", "MathCaption",
 CellID->26721],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", ">", 
      RowBox[{"y", "-", "1"}]}], ",", 
     RowBox[{"y", ">", "0"}], ",", 
     RowBox[{
      RowBox[{"x", "+", "y"}], "<", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->16952],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "<", "x", "\[LessEqual]", "0"}], "&&", 
    RowBox[{"0", "<", "y", "<", 
     RowBox[{"1", "+", "x"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0", "<", "x", "<", "1"}], "&&", 
    RowBox[{"0", "<", "y", "<", 
     RowBox[{"1", "-", "x"}]}]}], ")"}]}]], "Output",
 ImageSize->{334, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->233515405]
}, Open  ]],

Cell["\<\
Lists of inequalities in general represent regions of overlap between \
geometrical objects. Often the description of these can be quite complicated. \
\
\>", "Text",
 CellID->1828],

Cell["\<\
This represents the part of the unit disk on one side of a line. \
\>", "MathCaption",
 CellID->18230],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"3", "y"}]}], ">", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->429],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    FractionBox["1", "10"], " ", 
    RowBox[{"(", 
     RowBox[{"2", "-", 
      RowBox[{"3", " ", 
       SqrtBox["6"]}]}], ")"}]}], "<", "x", "<", 
   RowBox[{
    FractionBox["1", "10"], " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", 
      RowBox[{"3", " ", 
       SqrtBox["6"]}]}], ")"}]}]}], "&&", 
  RowBox[{
   FractionBox[
    RowBox[{"2", "-", "x"}], "3"], "<", "y", "<", 
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"]}]]}]}]], "Output",
 ImageSize->{353, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->305326070]
}, Open  ]],

Cell["Here is the intersection between two disks. ", "MathCaption",
 CellID->17699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "2"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->14153],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "-", 
      SqrtBox["2"]}], "<", "x", "\[LessEqual]", 
     FractionBox["1", "2"]}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "x"}], "-", 
        SuperscriptBox["x", "2"]}]]}], "<", "y", "<", 
     SqrtBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "x"}], "-", 
       SuperscriptBox["x", "2"]}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], "<", "x", "<", 
     SqrtBox["2"]}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"2", "-", 
        SuperscriptBox["x", "2"]}]]}], "<", "y", "<", 
     SqrtBox[
      RowBox[{"2", "-", 
       SuperscriptBox["x", "2"]}]]}]}], ")"}]}]], "Output",
 ImageSize->{348, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->6639195]
}, Open  ]],

Cell["If the disks are too far apart, there is no intersection. ", \
"MathCaption",
 CellID->31794],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "4"}], ")"}], "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "2"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->5041],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->107290814]
}, Open  ]],

Cell["Here is an example involving a transcendental inequality. ", \
"MathCaption",
 CellID->8383],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"x", " ", "y"}], "]"}], ">", 
      RowBox[{"1", "/", "2"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", 
      RowBox[{"3", "/", "2"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->8720],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        FractionBox["3", "4"], "+", 
        RowBox[{
         FractionBox["1", "12"], " ", 
         SqrtBox[
          RowBox[{"81", "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["\[Pi]", "2"]}]}]]}]}]]}], "<", "x", "<", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", 
      SqrtBox[
       RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{"(", 
         RowBox[{"9", "-", 
          SqrtBox[
           RowBox[{"81", "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["\[Pi]", "2"]}]}]]}], ")"}]}]]}]}], "&&", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       SqrtBox[
        RowBox[{"3", "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["x", "2"]}]}]], 
       SqrtBox["2"]]}], "<", "y", "<", 
     FractionBox["\[Pi]", 
      RowBox[{"6", " ", "x"}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      SqrtBox[
       RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{"(", 
         RowBox[{"9", "-", 
          SqrtBox[
           RowBox[{"81", "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["\[Pi]", "2"]}]}]]}], ")"}]}]]}], "<", "x", "<", 
     SqrtBox[
      RowBox[{
       FractionBox["3", "4"], "+", 
       RowBox[{
        FractionBox["1", "12"], " ", 
        SqrtBox[
         RowBox[{"81", "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["\[Pi]", "2"]}]}]]}]}]]}], "&&", 
    RowBox[{
     FractionBox["\[Pi]", 
      RowBox[{"6", " ", "x"}]], "<", "y", "<", 
     FractionBox[
      SqrtBox[
       RowBox[{"3", "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}]}]], 
      SqrtBox["2"]]}]}], ")"}]}]], "Output",
 ImageSize->{519, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->318922815]
}, Open  ]],

Cell[TextData[{
 "If you have inequalities that involve parameters, ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " automatically handles the different cases that can occur, just as it does \
for equations. "
}], "Text",
 CellID->30388],

Cell[TextData[{
 "The form of the intervals depends on the value of ",
 Cell[BoxData["a"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->14077],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"x", "-", "a"}], ")"}]}], ">", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->18213],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[LessEqual]", "1"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "<", "a"}], "||", 
      RowBox[{"x", ">", "1"}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", ">", "1"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "<", "1"}], "||", 
      RowBox[{"x", ">", "a"}]}], ")"}]}], ")"}]}]], "Output",
 ImageSize->{327, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->166347194]
}, Open  ]],

Cell[TextData[{
 "One gets a hyperbolic or an elliptical region, depending on the value of ",
 Cell[BoxData["a"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->8658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"a", " ", 
      RowBox[{"y", "^", "2"}]}]}], "<", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->4202],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "\[Element]", "Reals"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "<", "0"}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"x", "\[LessEqual]", 
           RowBox[{"-", "1"}]}], "&&", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"y", "<", 
             RowBox[{"-", 
              SqrtBox[
               FractionBox[
                RowBox[{"1", "-", 
                 SuperscriptBox["x", "2"]}], "a"]]}]}], "||", 
            RowBox[{"y", ">", 
             SqrtBox[
              FractionBox[
               RowBox[{"1", "-", 
                SuperscriptBox["x", "2"]}], "a"]]}]}], ")"}]}], ")"}], "||", 
        RowBox[{
         RowBox[{"-", "1"}], "<", "x", "<", "1"}], "||", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"x", "\[GreaterEqual]", "1"}], "&&", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"y", "<", 
             RowBox[{"-", 
              SqrtBox[
               FractionBox[
                RowBox[{"1", "-", 
                 SuperscriptBox["x", "2"]}], "a"]]}]}], "||", 
            RowBox[{"y", ">", 
             SqrtBox[
              FractionBox[
               RowBox[{"1", "-", 
                SuperscriptBox["x", "2"]}], "a"]]}]}], ")"}]}], ")"}]}], 
       ")"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "\[Equal]", "0"}], "&&", 
      RowBox[{
       RowBox[{"-", "1"}], "<", "x", "<", "1"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", ">", "0"}], "&&", 
      RowBox[{
       RowBox[{"-", "1"}], "<", "x", "<", "1"}], "&&", 
      RowBox[{
       RowBox[{"-", 
        SqrtBox[
         FractionBox[
          RowBox[{"1", "-", 
           SuperscriptBox["x", "2"]}], "a"]]}], "<", "y", "<", 
       SqrtBox[
        FractionBox[
         RowBox[{"1", "-", 
          SuperscriptBox["x", "2"]}], "a"]]}]}], ")"}]}], ")"}]}]], "Output",
 ImageSize->{466, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->58861167]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " tries to give you a complete description of the region defined by a set of \
inequalities. Sometimes, however, you may just want to find individual \
instances of values of variables that satisfy the inequalities. You can do \
this using ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 "."
}], "Text",
 CellID->22249],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FindInstance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FindInstance"], "[", 
     StyleBox["ineqs", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "try to find an instance of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " satisfying ",
     Cell[BoxData[
      StyleBox["ineqs", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FindInstance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FindInstance"], "[", 
     StyleBox["ineqs", "TI"], ",", 
     StyleBox["vars", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "try to find ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " instances"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->5058],

Cell["Finding individual points that satisfy inequalities. ", "Caption",
 CellID->16575],

Cell["\<\
This finds a specific instance that satisfies the inequalities. \
\>", "MathCaption",
 CellID->8090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"x", " ", "y"}], "]"}], ">", 
      RowBox[{"1", "/", "2"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", 
      RowBox[{"3", "/", "2"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->24638],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["88", "151"]}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["543", "566"]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{155, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->392697615]
}, Open  ]],

Cell["\<\
This shows that there is no way to satisfy the inequalities. \
\>", "MathCaption",
 CellID->31395],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"x", " ", "y"}], "]"}], ">", 
      RowBox[{"1", "/", "2"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", 
      RowBox[{"1", "/", "4"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->24701],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->437361661]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " is in some ways an analog for inequalities of ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " for equations. For like ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 ", it returns a list of rules giving specific values for variables. But \
while for equations these values can generically give an accurate \
representation of all solutions, for inequalities they can only correspond to \
isolated sample points within the regions described by the inequalities. "
}], "Text",
 CellID->11558],

Cell[TextData[{
 "Every time you call ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " with specific input, it will give the same output. And when there are \
instances that correspond to special, limiting, points of some kind, it will \
preferentially return these. But in general, the distribution of instances \
returned by ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " will typically seem somewhat random. Each instance is, however, in effect \
a constructive proof that the inequalities you have given can in fact be \
satisfied. "
}], "Text",
 CellID->3123],

Cell[TextData[{
 "If you ask for one point in the unit disk, ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " gives the origin. "
}], "MathCaption",
 CellID->24287],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "<=", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->1041],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "0"}], ",", 
    RowBox[{"y", "\[Rule]", "0"}]}], "}"}], "}"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->289264303]
}, Open  ]],

Cell["This finds 500 points in the unit disk. ", "MathCaption",
 CellID->2530],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<=", "1"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "500"}], "]"}], ";"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->6209],

Cell["Their distribution seems somewhat random. ", "MathCaption",
 CellID->14820],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], "/.", "%"}], ",", 
   RowBox[{"AspectRatio", "->", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->935],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->2221911]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->19141326],

Cell[TextData[ButtonBox["Manipulating Equations and Inequalities",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"]], \
"RelatedTutorials",
 CellID->6804882]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Inequalities - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Manipulating Equations and Inequalities", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/SolvingLogicalCombinationsOfEquations"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/EquationsAndInequalitiesOverDomains"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 37, 18.1924758}", "context" -> "", 
    "keywords" -> {
     "constructive solid geometry", "disk", "FindInstance", "geometry", 
      "inequalities", "polynomials", "reducing inequalities", "regions", 
      "sample points", "Satisfiability", "transcendental functions", 
      "triangle", "witnesses"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Just as the equation x^2+3x==2 asserts that x^2+3x is equal to 2, so \
also the inequality x^2+3x>2 asserts that x^2+3x is greater than 2. In \
Mathematica, Reduce works not only on equations, but also on inequalities. \
Manipulating univariate inequalities. This pair of inequalities reduces to a \
single inequality. ", "synonyms" -> {"3.4.8"}, "title" -> "Inequalities", 
    "type" -> "Tutorial", "uri" -> 
    "tutorial/Inequalities-ManipulatingEquationsAndInequalities"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.4.8"->{
  Cell[1969, 61, 74, 2, 70, "Title",
   CellTags->{"S3.4.8", "8.1"},
   CellID->9389]},
 "8.1"->{
  Cell[1969, 61, 74, 2, 70, "Title",
   CellTags->{"S3.4.8", "8.1"},
   CellID->9389]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.4.8", 50160, 1761},
 {"8.1", 50258, 1765}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1344, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1969, 61, 74, 2, 70, "Title",
 CellTags->{"S3.4.8", "8.1"},
 CellID->9389],
Cell[2046, 65, 1048, 43, 70, "Text",
 CellID->27625],
Cell[3097, 110, 811, 24, 70, "DefinitionBox",
 CellID->8029],
Cell[3911, 136, 72, 1, 70, "Caption",
 CellID->3128],
Cell[3986, 139, 98, 2, 70, "MathCaption",
 CellID->2039],
Cell[CellGroupData[{
Cell[4109, 145, 241, 8, 28, "Input",
 CellID->1527],
Cell[4353, 155, 189, 6, 36, "Output",
 CellID->69771236]
}, Open  ]],
Cell[4557, 164, 98, 2, 70, "MathCaption",
 CellID->8490],
Cell[CellGroupData[{
Cell[4680, 170, 222, 8, 28, "Input",
 CellID->29648],
Cell[4905, 180, 161, 5, 36, "Output",
 CellID->55132239]
}, Open  ]],
Cell[5081, 188, 1397, 49, 70, "Text",
 CellID->5517],
Cell[6481, 239, 161, 5, 70, "MathCaption",
 CellID->24192],
Cell[CellGroupData[{
Cell[6667, 248, 218, 8, 70, "Input",
 CellID->32530],
Cell[6888, 258, 516, 20, 51, "Output",
 CellID->588187597]
}, Open  ]],
Cell[7419, 281, 165, 5, 70, "MathCaption",
 CellID->3148],
Cell[CellGroupData[{
Cell[7609, 290, 217, 8, 70, "Input",
 CellID->24056],
Cell[7829, 300, 502, 20, 51, "Output",
 CellID->126580371]
}, Open  ]],
Cell[8346, 323, 851, 26, 70, "Text",
 CellID->2282],
Cell[9200, 351, 88, 1, 70, "MathCaption",
 CellID->29743],
Cell[CellGroupData[{
Cell[9313, 356, 390, 15, 70, "Input",
 CellID->26439],
Cell[9706, 373, 272, 9, 36, "Output",
 CellID->185603014]
}, Open  ]],
Cell[9993, 385, 89, 1, 70, "MathCaption",
 CellID->21493],
Cell[CellGroupData[{
Cell[10107, 390, 339, 13, 70, "Input",
 CellID->1927],
Cell[10449, 405, 383, 15, 38, "Output",
 CellID->645372781]
}, Open  ]],
Cell[10847, 423, 229, 8, 70, "MathCaption",
 CellID->30393],
Cell[CellGroupData[{
Cell[11101, 435, 212, 7, 70, "Input",
 CellID->21033],
Cell[11316, 444, 821, 15, 70, "Message",
 CellID->500455932],
Cell[12140, 461, 524, 18, 52, "Output",
 CellID->974563338]
}, Open  ]],
Cell[12679, 482, 302, 9, 70, "Text",
 CellID->19026],
Cell[12984, 493, 99, 2, 70, "MathCaption",
 CellID->5842],
Cell[CellGroupData[{
Cell[13108, 499, 269, 10, 70, "Input",
 CellID->19080],
Cell[13380, 511, 481, 15, 36, "Output",
 CellID->637610912]
}, Open  ]],
Cell[13876, 529, 224, 8, 70, "MathCaption",
 CellID->4961],
Cell[CellGroupData[{
Cell[14125, 541, 256, 9, 70, "Input",
 CellID->28717],
Cell[14384, 552, 685, 21, 36, "Output",
 CellID->18318334]
}, Open  ]],
Cell[15084, 576, 98, 2, 70, "MathCaption",
 CellID->5920],
Cell[CellGroupData[{
Cell[15207, 582, 432, 16, 70, "Input",
 CellID->13245],
Cell[15642, 600, 1237, 45, 81, "Output",
 CellID->24046281]
}, Open  ]],
Cell[16894, 648, 421, 12, 70, "Text",
 CellID->30121],
Cell[17318, 662, 109, 3, 70, "MathCaption",
 CellID->27782],
Cell[CellGroupData[{
Cell[17452, 669, 289, 11, 70, "Input",
 CellID->2782],
Cell[17744, 682, 471, 18, 51, "Output",
 CellID->331052878]
}, Open  ]],
Cell[18230, 703, 86, 1, 70, "MathCaption",
 CellID->6491],
Cell[CellGroupData[{
Cell[18341, 708, 421, 15, 70, "Input",
 CellID->31870],
Cell[18765, 725, 760, 24, 51, "Output",
 CellID->255052314]
}, Open  ]],
Cell[19540, 752, 1041, 30, 70, "DefinitionBox",
 CellID->22195],
Cell[20584, 784, 62, 1, 70, "Caption",
 CellID->13143],
Cell[20649, 787, 351, 9, 70, "Text",
 CellID->11763],
Cell[21003, 798, 204, 7, 70, "MathCaption",
 CellID->14771],
Cell[CellGroupData[{
Cell[21232, 809, 272, 10, 70, "Input",
 CellID->23592],
Cell[21507, 821, 419, 16, 45, "Output",
 CellID->15970362]
}, Open  ]],
Cell[21941, 840, 480, 11, 70, "Text",
 CellID->19217],
Cell[22424, 853, 86, 1, 70, "MathCaption",
 CellID->25412],
Cell[CellGroupData[{
Cell[22535, 858, 334, 12, 70, "Input",
 CellID->5881],
Cell[22872, 872, 273, 9, 36, "Output",
 CellID->898468420]
}, Open  ]],
Cell[23160, 884, 114, 3, 70, "MathCaption",
 CellID->26721],
Cell[CellGroupData[{
Cell[23299, 891, 362, 13, 70, "Input",
 CellID->16952],
Cell[23664, 906, 503, 17, 36, "Output",
 CellID->233515405]
}, Open  ]],
Cell[24182, 926, 191, 5, 70, "Text",
 CellID->1828],
Cell[24376, 933, 112, 3, 70, "MathCaption",
 CellID->18230],
Cell[CellGroupData[{
Cell[24513, 940, 403, 15, 70, "Input",
 CellID->429],
Cell[24919, 957, 647, 25, 52, "Output",
 CellID->305326070]
}, Open  ]],
Cell[25581, 985, 83, 1, 70, "MathCaption",
 CellID->17699],
Cell[CellGroupData[{
Cell[25689, 990, 497, 18, 70, "Input",
 CellID->14153],
Cell[26189, 1010, 942, 35, 84, "Output",
 CellID->6639195]
}, Open  ]],
Cell[27146, 1048, 99, 2, 70, "MathCaption",
 CellID->31794],
Cell[CellGroupData[{
Cell[27270, 1054, 496, 18, 70, "Input",
 CellID->5041],
Cell[27769, 1074, 163, 5, 36, "Output",
 CellID->107290814]
}, Open  ]],
Cell[27947, 1082, 98, 2, 70, "MathCaption",
 CellID->8383],
Cell[CellGroupData[{
Cell[28070, 1088, 470, 17, 70, "Input",
 CellID->8720],
Cell[28543, 1107, 1992, 73, 121, "Output",
 CellID->318922815]
}, Open  ]],
Cell[30550, 1183, 309, 9, 70, "Text",
 CellID->30388],
Cell[30862, 1194, 149, 5, 70, "MathCaption",
 CellID->14077],
Cell[CellGroupData[{
Cell[31036, 1203, 275, 11, 70, "Input",
 CellID->18213],
Cell[31314, 1216, 552, 20, 36, "Output",
 CellID->166347194]
}, Open  ]],
Cell[31881, 1239, 171, 5, 70, "MathCaption",
 CellID->8658],
Cell[CellGroupData[{
Cell[32077, 1248, 298, 11, 70, "Input",
 CellID->4202],
Cell[32378, 1261, 2148, 70, 158, "Output",
 CellID->58861167]
}, Open  ]],
Cell[34541, 1334, 534, 15, 70, "Text",
 CellID->22249],
Cell[35078, 1351, 1322, 42, 70, "DefinitionBox",
 CellID->5058],
Cell[36403, 1395, 88, 1, 70, "Caption",
 CellID->16575],
Cell[36494, 1398, 110, 3, 70, "MathCaption",
 CellID->8090],
Cell[CellGroupData[{
Cell[36629, 1405, 477, 17, 70, "Input",
 CellID->24638],
Cell[37109, 1424, 390, 14, 51, "Output",
 CellID->392697615]
}, Open  ]],
Cell[37514, 1441, 108, 3, 70, "MathCaption",
 CellID->31395],
Cell[CellGroupData[{
Cell[37647, 1448, 477, 17, 70, "Input",
 CellID->24701],
Cell[38127, 1467, 176, 6, 36, "Output",
 CellID->437361661]
}, Open  ]],
Cell[38318, 1476, 776, 20, 70, "Text",
 CellID->11558],
Cell[39097, 1498, 734, 18, 70, "Text",
 CellID->3123],
Cell[39834, 1518, 248, 8, 70, "MathCaption",
 CellID->24287],
Cell[CellGroupData[{
Cell[40107, 1530, 278, 10, 70, "Input",
 CellID->1041],
Cell[40388, 1542, 291, 10, 36, "Output",
 CellID->289264303]
}, Open  ]],
Cell[40694, 1555, 78, 1, 70, "MathCaption",
 CellID->2530],
Cell[40775, 1558, 315, 11, 70, "Input",
 CellID->6209],
Cell[41093, 1571, 81, 1, 70, "MathCaption",
 CellID->14820],
Cell[CellGroupData[{
Cell[41199, 1576, 241, 8, 28, "Input",
 CellID->935],
Cell[41443, 1586, 5689, 97, 197, "Output",
 Evaluatable->False,
 CellID->2221911]
}, Open  ]],
Cell[CellGroupData[{
Cell[47169, 1688, 71, 1, 70, "RelatedTutorialsSection",
 CellID->19141326],
Cell[47243, 1691, 208, 5, 70, "RelatedTutorials",
 CellID->6804882]
}, Open  ]]
}, Open  ]],
Cell[47478, 1700, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

