(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14667,        521]
NotebookOptionsPosition[     10481,        390]
NotebookOutlinePosition[     12990,        458]
CellTagsIndexPosition[     12899,        452]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbolic Mathematics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SymbolicMathematicsOverview"], 
          "Complex Polynomial Systems" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ComplexPolynomialSystems"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Symbolic Mathematics\"\>", 
       2->"\<\"Complex Polynomial Systems\"\>"}, "\<\"related tutorials\"\>", 
       
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FindInstance" :> 
          Documentation`HelpLookup["paclet:ref/FindInstance"], "Maximize" :> 
          Documentation`HelpLookup["paclet:ref/Maximize"], "Minimize" :> 
          Documentation`HelpLookup["paclet:ref/Minimize"], "Reduce" :> 
          Documentation`HelpLookup["paclet:ref/Reduce"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"FindInstance\"\>", 2->"\<\"Maximize\"\>", 
       3->"\<\"Minimize\"\>", 4->"\<\"Reduce\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Inequalities", "Title",
 CellTags->{"S1.5.8", "8.1"},
 CellID->12531],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Reduce",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Reduce"], "[", 
     RowBox[{
      StyleBox["ineqs", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], Cell[
    "reduce a collection of inequalities", "TableText"]},
   {
    RowBox[{
     ButtonBox["FindInstance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FindInstance"], "[", 
     RowBox[{
      StyleBox["ineqs", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], Cell[TextData[{
     "find an instance thatr satisfies the ",
     Cell[BoxData[
      StyleBox["ineqs", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->2096742444],

Cell["Handling inequalities. ", "Caption",
 CellID->3902],

Cell["This finds a reduced form for the inequalities. ", "MathCaption",
 CellID->8100],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "+", "y"}], "<", "1"}], "&&", 
    RowBox[{"y", ">", "x", ">", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->23071],

Cell[BoxData[
 RowBox[{
  RowBox[{"0", "<", "x", "<", 
   FractionBox["1", "2"]}], "&&", 
  RowBox[{"x", "<", "y", "<", 
   RowBox[{"1", "-", "x"}]}]}]], "Output",
 ImageSize->{146, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->18775]
}, Open  ]],

Cell["These inequalities can never be satisfied. ", "MathCaption",
 CellID->15009],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "+", "y"}], "<", "1"}], "&&", 
    RowBox[{"y", ">", "x", ">", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->6430],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->22794]
}, Open  ]],

Cell["It is easy to end up with rather complicated results. ", "MathCaption",
 CellID->28622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "+", "y"}], "<", "1"}], "&&", 
    RowBox[{
     RowBox[{"y", "^", "2"}], ">", "x", ">", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->11736],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0", "<", "x", "<", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"3", "-", 
        SqrtBox["5"]}], ")"}]}]}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "<", 
       RowBox[{"-", 
        SqrtBox["x"]}]}], "||", 
      RowBox[{
       SqrtBox["x"], "<", "y", "<", 
       RowBox[{"1", "-", "x"}]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"3", "-", 
        SqrtBox["5"]}], ")"}]}], "\[LessEqual]", "x", "<", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        SqrtBox["5"]}], ")"}]}]}], "&&", 
    RowBox[{"y", "<", 
     RowBox[{"-", 
      SqrtBox["x"]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[GreaterEqual]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        SqrtBox["5"]}], ")"}]}]}], "&&", 
    RowBox[{"y", "<", 
     RowBox[{"1", "-", "x"}]}]}], ")"}]}]], "Output",
 ImageSize->{469, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->6890]
}, Open  ]],

Cell[TextData[{
 "Equations can often be solved to give definite values of variables. But \
inequalities typically just define regions that can only be specified by \
other inequalities. You can use ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " to find definite values of variables that satisfy a particular set of \
inequalities. "
}], "Text",
 CellID->5015],

Cell["\<\
This finds a point in the region specified by the inequalities. \
\>", "MathCaption",
 CellID->2452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "+", "y"}], "<", "1"}], "&&", 
    RowBox[{
     RowBox[{"y", "^", "2"}], ">", "x", ">", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->26754],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     FractionBox["7", "2"]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", "3"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{115, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->9782]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Minimize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Minimize"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["ineq", "TI"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], Cell[TextData[{
     "minimize ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " while satisfying ",
     Cell[BoxData[
      StyleBox["ineqs", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Maximize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Maximize"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["ineq", "TI"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], Cell[TextData[{
     "maximize ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " while satisfying ",
     Cell[BoxData[
      StyleBox["ineqs", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->791048170],

Cell["Constrained minimization and maximization. ", "Caption",
 CellID->25188],

Cell["This gives the maximum, together with where it occurs. ", "MathCaption",
 CellID->17855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", "y"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<=", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->11960],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["5", "4"], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SqrtBox["3"], "2"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["1", "2"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{159, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->17945]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->130354267],

Cell[TextData[ButtonBox["Symbolic Mathematics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SymbolicMathematicsOverview"]], "RelatedTutorials",
 CellID->391267452],

Cell[TextData[ButtonBox["Complex Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ComplexPolynomialSystems"]], "RelatedTutorials",\

 CellID->65437048]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Inequalities - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Symbolic Mathematics", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> "paclet:tutorial/SymbolicMathematicsOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/SolvingEquations"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DifferentialEquations-Basics"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 37, 18.9268696}", "context" -> "", 
    "keywords" -> {
     "constrained optimization", "inequalities", "linear programming", 
      "maximize", "minimize", "reduce"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Handling inequalities. This finds a reduced form for the inequalities. \
These inequalities can never be satisfied. ", "synonyms" -> {"1.5.8"}, 
    "title" -> "Inequalities", "type" -> "Tutorial", "uri" -> 
    "tutorial/Inequalities-SymbolicMathematics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.5.8"->{
  Cell[2298, 66, 75, 2, 70, "Title",
   CellTags->{"S1.5.8", "8.1"},
   CellID->12531]},
 "8.1"->{
  Cell[2298, 66, 75, 2, 70, "Title",
   CellTags->{"S1.5.8", "8.1"},
   CellID->12531]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.5.8", 12688, 441},
 {"8.1", 12787, 445}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1673, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2298, 66, 75, 2, 70, "Title",
 CellTags->{"S1.5.8", "8.1"},
 CellID->12531],
Cell[2376, 70, 951, 31, 70, "DefinitionBox",
 CellID->2096742444],
Cell[3330, 103, 57, 1, 70, "Caption",
 CellID->3902],
Cell[3390, 106, 86, 1, 70, "MathCaption",
 CellID->8100],
Cell[CellGroupData[{
Cell[3501, 111, 282, 10, 28, "Input",
 CellID->23071],
Cell[3786, 123, 291, 10, 51, "Output",
 CellID->18775]
}, Open  ]],
Cell[4092, 136, 82, 1, 70, "MathCaption",
 CellID->15009],
Cell[CellGroupData[{
Cell[4199, 141, 281, 10, 28, "Input",
 CellID->6430],
Cell[4483, 153, 159, 5, 36, "Output",
 CellID->22794]
}, Open  ]],
Cell[4657, 161, 93, 1, 70, "MathCaption",
 CellID->28622],
Cell[CellGroupData[{
Cell[4775, 166, 308, 11, 28, "Input",
 CellID->11736],
Cell[5086, 179, 1264, 48, 81, "Output",
 CellID->6890]
}, Open  ]],
Cell[6365, 230, 446, 11, 70, "Text",
 CellID->5015],
Cell[6814, 243, 110, 3, 70, "MathCaption",
 CellID->2452],
Cell[CellGroupData[{
Cell[6949, 250, 314, 11, 70, "Input",
 CellID->26754],
Cell[7266, 263, 331, 12, 51, "Output",
 CellID->9782]
}, Open  ]],
Cell[7612, 278, 1337, 46, 70, "DefinitionBox",
 CellID->791048170],
Cell[8952, 326, 78, 1, 70, "Caption",
 CellID->25188],
Cell[9033, 329, 94, 1, 70, "MathCaption",
 CellID->17855],
Cell[CellGroupData[{
Cell[9152, 334, 385, 14, 70, "Input",
 CellID->11960],
Cell[9540, 350, 427, 16, 56, "Output",
 CellID->17945]
}, Open  ]],
Cell[CellGroupData[{
Cell[10004, 371, 72, 1, 70, "RelatedTutorialsSection",
 CellID->130354267],
Cell[10079, 374, 172, 4, 70, "RelatedTutorials",
 CellID->391267452],
Cell[10254, 380, 173, 4, 70, "RelatedTutorials",
 CellID->65437048]
}, Open  ]]
}, Open  ]],
Cell[10454, 388, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

