(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     54842,       1875]
NotebookOptionsPosition[     45962,       1591]
NotebookOutlinePosition[     49523,       1674]
CellTagsIndexPosition[     49428,       1668]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calculus" :> 
          Documentation`HelpLookup["paclet:tutorial/CalculusOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Calculus\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FourierCosTransform" :> 
          Documentation`HelpLookup["paclet:ref/FourierCosTransform"], 
          "FourierSinTransform" :> 
          Documentation`HelpLookup["paclet:ref/FourierSinTransform"], 
          "FourierTransform" :> 
          Documentation`HelpLookup["paclet:ref/FourierTransform"], 
          "InverseFourierCosTransform" :> 
          Documentation`HelpLookup["paclet:ref/InverseFourierCosTransform"], 
          "InverseFourierSinTransform" :> 
          Documentation`HelpLookup["paclet:ref/InverseFourierSinTransform"], 
          "InverseFourierTransform" :> 
          Documentation`HelpLookup["paclet:ref/InverseFourierTransform"], 
          "InverseLaplaceTransform" :> 
          Documentation`HelpLookup["paclet:ref/InverseLaplaceTransform"], 
          "InverseZTransform" :> 
          Documentation`HelpLookup["paclet:ref/InverseZTransform"], 
          "LaplaceTransform" :> 
          Documentation`HelpLookup["paclet:ref/LaplaceTransform"], 
          "ZTransform" :> 
          Documentation`HelpLookup["paclet:ref/ZTransform"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FourierCosTransform\"\>", 
       2->"\<\"FourierSinTransform\"\>", 3->"\<\"FourierTransform\"\>", 
       4->"\<\"InverseFourierCosTransform\"\>", 
       5->"\<\"InverseFourierSinTransform\"\>", 
       6->"\<\"InverseFourierTransform\"\>", 
       7->"\<\"InverseLaplaceTransform\"\>", 8->"\<\"InverseZTransform\"\>", 
       9->"\<\"LaplaceTransform\"\>", 
       10->"\<\"ZTransform\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Integral Transforms and Related Operations", "Title",
 CellTags->{"S3.5.12", "12.1"},
 CellID->26017],

Cell[CellGroupData[{

Cell["Laplace Transforms", "Section",
 CellID->14932],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["LaplaceTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LaplaceTransform"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["t", "TI"], ",", 
     StyleBox["s", "TI"], "]"}], Cell[TextData[{
     "the Laplace transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["InverseLaplaceTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseLaplaceTransform"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["s", "TI"], ",", 
     StyleBox["t", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "the inverse Laplace transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->14948],

Cell["\<\
One\[Hyphen]dimensional Laplace transforms. \
\>", "Caption",
 CellID->31210],

Cell[TextData[{
 "The Laplace transform of a function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "t", ")"}], TraditionalForm]], "InlineMath"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
    RowBox[{
     RowBox[{"f", "(", "t", ")"}], 
     SuperscriptBox["e", 
      RowBox[{"-", "s", "t"}]], 
     RowBox[{"\[DifferentialD]", "t"}]}]}], TraditionalForm]], "InlineMath"],
 ". The inverse Laplace transform of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "(", "s", ")"}], TraditionalForm]], "InlineMath"],
 " is given for suitable ",
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]], "InlineMath"],
 " by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", "\[Pi]", "i"}]], 
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"\[Gamma]", "-", "i", "\[Infinity]"}], 
      RowBox[{"\[Gamma]", "+", "i", "\[Infinity]"}]], 
     RowBox[{
      RowBox[{"F", "(", "s", ")"}], 
      SuperscriptBox["e", 
       RowBox[{"s", "\[InvisibleSpace]", "t"}]], 
      RowBox[{"\[DifferentialD]", "s"}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Text",
 CellID->3495],

Cell["Here is a simple Laplace transform. ", "MathCaption",
 CellID->26419],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"t", "^", "4"}], " ", 
    RowBox[{"Sin", "[", "t", "]"}]}], ",", "t", ",", "s"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->14648],

Cell[BoxData[
 FractionBox[
  RowBox[{"24", " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"10", " ", 
      SuperscriptBox["s", "2"]}], "+", 
     RowBox[{"5", " ", 
      SuperscriptBox["s", "4"]}]}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox["s", "2"]}], ")"}], "5"]]], "Output",
 ImageSize->{124, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->4189]
}, Open  ]],

Cell["Here is the inverse. ", "MathCaption",
 CellID->10171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{"%", ",", "s", ",", "t"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->15851],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["t", "4"], " ", 
  RowBox[{"Sin", "[", "t", "]"}]}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->3695]
}, Open  ]],

Cell["Even simple transforms often involve special functions. ", "MathCaption",
 CellID->11223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"t", "^", "2"}]}], ")"}]}], ",", "t", ",", "s"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->3637],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CosIntegral", "[", "s", "]"}], " ", 
   RowBox[{"Sin", "[", "s", "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"Cos", "[", "s", "]"}], " ", 
   RowBox[{"(", 
    RowBox[{"\[Pi]", "-", 
     RowBox[{"2", " ", 
      RowBox[{"SinIntegral", "[", "s", "]"}]}]}], ")"}]}]}]], "Output",
 ImageSize->{362, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->16649]
}, Open  ]],

Cell["Here the result involves a Meijer G function. ", "MathCaption",
 CellID->15800],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"t", "^", "3"}]}], ")"}]}], ",", "t", ",", "s"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->24407],

Cell[BoxData[
 FractionBox[
  RowBox[{"MeijerG", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       FractionBox["2", "3"], "}"}], ",", 
      RowBox[{"{", "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        FractionBox["1", "3"], ",", 
        FractionBox["2", "3"], ",", 
        FractionBox["2", "3"]}], "}"}], ",", 
      RowBox[{"{", "}"}]}], "}"}], ",", 
    FractionBox[
     SuperscriptBox["s", "3"], "27"]}], "]"}], 
  RowBox[{"2", " ", 
   SqrtBox["3"], " ", "\[Pi]"}]]], "Output",
 ImageSize->{296, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->57068970]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseLaplaceTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseLaplaceTransform"]], "InlineFormula"],
 " returns the original function."
}], "MathCaption",
 CellID->26480321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{"%", ",", "s", ",", "t"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->624646011],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", 
   SuperscriptBox["t", "3"]}]]], "Output",
 ImageSize->{41, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1463698310]
}, Open  ]],

Cell["\<\
The Laplace transform of this Bessel function just involves elementary \
functions. \
\>", "MathCaption",
 CellID->30884],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"n", ",", "t"}], "]"}], ",", "t", ",", "s"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->17177],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"s", "+", 
     SqrtBox[
      RowBox[{"1", "+", 
       SuperscriptBox["s", "2"]}]]}], ")"}], 
   RowBox[{"-", "n"}]], 
  SqrtBox[
   RowBox[{"1", "+", 
    SuperscriptBox["s", "2"]}]]]], "Output",
 ImageSize->{104, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->14812]
}, Open  ]],

Cell["\<\
Laplace transforms have the property that they turn integration and \
differentiation into essentially algebraic operations. They are therefore \
commonly used in studying systems governed by differential equations. \
\>", "Text",
 CellID->20641],

Cell[TextData[{
 "Integration becomes multiplication by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "s"}], TraditionalForm]], "InlineMath"],
 " when one does a Laplace transform. "
}], "MathCaption",
 CellID->25304],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"f", "[", "u", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", "t"}], "}"}]}], "]"}], ",", "t", ",", "s"}],
   "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->4496],

Cell[BoxData[
 FractionBox[
  RowBox[{"LaplaceTransform", "[", 
   RowBox[{
    RowBox[{"f", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}], "s"]], "Output",\

 ImageSize->{199, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->23162]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["LaplaceTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LaplaceTransform"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "the multidimensional Laplace transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["InverseLaplaceTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseLaplaceTransform"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "the multidimensional inverse Laplace transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->12537],

Cell["Multidimensional Laplace transforms. ", "Caption",
 CellID->18551]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fourier Transforms", "Section",
 CellID->25851],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FourierTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FourierTransform"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["t", "TI"], ",", "\[Omega]", "]"}], Cell[TextData[{
     "the Fourier transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["InverseFourierTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseFourierTransform"], "[", 
     StyleBox["expr", "TI"], ",", "\[Omega]", ",", 
     StyleBox["t", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "the inverse Fourier transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->2732],

Cell["\<\
One\[Hyphen]dimensional Fourier transforms. \
\>", "Caption",
 CellID->31565],

Cell[TextData[{
 "Integral transforms can produce results that involve \"",
 ButtonBox["generalized functions\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GeneralizedFunctionsAndRelatedObjects"],
 " such as ",
 Cell[BoxData[
  ButtonBox["HeavisideTheta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HeavisideTheta"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->18938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"t", "^", "4"}]}], ")"}]}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->27445],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    FractionBox["1", "4"], "+", 
    FractionBox["\[ImaginaryI]", "4"]}], ")"}], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", "\[Omega]"}], 
     SqrtBox["2"]]}]], " ", 
  SqrtBox["\[Pi]"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       SqrtBox["2"], " ", "\[Omega]"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["2"], " ", "\[Omega]"}]]}], ")"}], " ", 
     RowBox[{"HeavisideTheta", "[", 
      RowBox[{"-", "\[Omega]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["2"], " ", "\[Omega]"}]]}]}], ")"}], " ", 
     RowBox[{"HeavisideTheta", "[", "\[Omega]", "]"}]}]}], ")"}]}]], "Output",\

 ImageSize->{498, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->21228]
}, Open  ]],

Cell["This finds the inverse. ", "MathCaption",
 CellID->8194],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{"%", ",", "\[Omega]", ",", "t"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->14526],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", 
   SuperscriptBox["t", "4"]}]]], "Output",
 ImageSize->{41, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->2178]
}, Open  ]],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " the Fourier transform of a function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "t", ")"}], TraditionalForm]], "InlineMath"],
 " is by default defined to be ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", 
     SqrtBox[
      RowBox[{"2", "\[Pi]"}]]], 
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
     RowBox[{
      RowBox[{"f", "(", "t", ")"}], " ", 
      SuperscriptBox["e", 
       RowBox[{"i", "\[Omega]", "t"}]], 
      RowBox[{"\[DifferentialD]", "t"}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". The inverse Fourier transform of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "(", "\[Omega]", ")"}], TraditionalForm]], "InlineMath"],
 " is similarly defined as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", 
     SqrtBox[
      RowBox[{"2", "\[Pi]"}]]], 
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
     RowBox[{
      RowBox[{"F", "(", "\[Omega]", ")"}], " ", 
      SuperscriptBox["e", 
       RowBox[{"-", "i", "\[Omega]", "t"}]], 
      RowBox[{"\[DifferentialD]", "\[Omega]"}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Text",
 CellID->15745],

Cell[TextData[{
 "In different scientific and technical fields different conventions are \
often used for defining Fourier transforms. The option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 " in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to choose any of these conventions you want. "
}], "Text",
 CellID->6928],

Cell[BoxData[GridBox[{
   {Cell[TextData[StyleBox["common convention",
     FontSlant->"Italic"]], "TableText"], Cell[TextData[StyleBox["setting",
     FontSlant->"Italic"]], "TableText"], Cell[TextData[StyleBox[
    "Fourier transform",
     FontSlant->"Italic"]], "TableText"], Cell[TextData[StyleBox[
    "inverse Fourier transform",
     FontSlant->"Italic"]], "TableText"]},
   {Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " default"
    }], "TableText"], Cell[TextData[Cell[BoxData[
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]], "InlineFormula"]], "TableText"], Cell[
    TextData[Cell[BoxData[
     FormBox[
      RowBox[{
       FractionBox["1", 
        SqrtBox[
         RowBox[{"2", "\[Pi]"}]]], 
       RowBox[{
        SubsuperscriptBox["\[Integral]", 
         RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
        RowBox[{
         RowBox[{"f", "(", "t", ")"}], " ", 
         SuperscriptBox["e", 
          RowBox[{"i", "\[Omega]", "t"}]], 
         RowBox[{"\[DifferentialD]", "t"}]}]}]}], TraditionalForm]], 
     "InlineMath"]], "TableText"], Cell[TextData[Cell[BoxData[
     FormBox[
      RowBox[{
       FractionBox["1", 
        SqrtBox[
         RowBox[{"2", "\[Pi]"}]]], 
       RowBox[{
        SubsuperscriptBox["\[Integral]", 
         RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
        RowBox[{
         RowBox[{"F", "(", "\[Omega]", ")"}], " ", 
         SuperscriptBox["e", 
          RowBox[{"-", "i", "\[Omega]", "t"}]], 
         RowBox[{"\[DifferentialD]", "\[Omega]"}]}]}]}], TraditionalForm]], 
     "InlineMath"]], "TableText"]},
   {Cell["pure mathematics", "TableText"], Cell[TextData[Cell[BoxData[
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}]}], "}"}]], "InlineFormula"]], "TableText"], Cell[
    TextData[Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox["\[Integral]", 
        RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
       RowBox[{
        RowBox[{"f", "(", "t", ")"}], " ", 
        SuperscriptBox["e", 
         RowBox[{"-", "i", "\[Omega]", "t"}]], 
        RowBox[{"\[DifferentialD]", "t"}]}]}], TraditionalForm]], 
     "InlineMath"]], "TableText"], Cell[TextData[Cell[BoxData[
     FormBox[
      RowBox[{
       FractionBox["1", 
        RowBox[{"2", "\[Pi]"}]], 
       RowBox[{
        SubsuperscriptBox["\[Integral]", 
         RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
        RowBox[{
         RowBox[{"F", "(", "\[Omega]", ")"}], " ", 
         SuperscriptBox["e", 
          RowBox[{"i", "\[Omega]", "t"}]], 
         RowBox[{"\[DifferentialD]", "\[Omega]"}]}]}]}], TraditionalForm]], 
     "InlineMath"]], "TableText"]},
   {Cell["classical physics", "TableText"], Cell[TextData[Cell[BoxData[
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}]], "InlineFormula"]], 
     "TableText"], Cell[TextData[Cell[BoxData[
     FormBox[
      RowBox[{
       FractionBox["1", 
        RowBox[{"2", "\[Pi]"}]], 
       RowBox[{
        SubsuperscriptBox["\[Integral]", 
         RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
        RowBox[{
         RowBox[{"f", "(", "t", ")"}], " ", 
         SuperscriptBox["e", 
          RowBox[{"i", "\[Omega]", "t"}]], 
         RowBox[{"\[DifferentialD]", "t"}]}]}]}], TraditionalForm]], 
     "InlineMath"]], "TableText"], Cell[TextData[Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox["\[Integral]", 
        RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
       RowBox[{
        RowBox[{"F", "(", "\[Omega]", ")"}], " ", 
        SuperscriptBox["e", 
         RowBox[{"-", "i", "\[Omega]", "t"}]], 
        RowBox[{"\[DifferentialD]", "\[Omega]"}]}]}], TraditionalForm]], 
     "InlineMath"]], "TableText"]},
   {Cell["modern physics", "TableText"], Cell[TextData[Cell[BoxData[
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]], "InlineFormula"]], "TableText"], Cell[
    TextData[Cell[BoxData[
     FormBox[
      RowBox[{
       FractionBox["1", 
        SqrtBox[
         RowBox[{"2", "\[Pi]"}]]], 
       RowBox[{
        SubsuperscriptBox["\[Integral]", 
         RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
        RowBox[{
         RowBox[{"f", "(", "t", ")"}], " ", 
         SuperscriptBox["e", 
          RowBox[{"i", "\[Omega]", "t"}]], 
         RowBox[{"\[DifferentialD]", "t"}]}]}]}], TraditionalForm]], 
     "InlineMath"]], "TableText"], Cell[TextData[Cell[BoxData[
     FormBox[
      RowBox[{
       FractionBox["1", 
        SqrtBox[
         RowBox[{"2", "\[Pi]"}]]], 
       RowBox[{
        SubsuperscriptBox["\[Integral]", 
         RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
        RowBox[{
         RowBox[{"F", "(", "\[Omega]", ")"}], " ", 
         SuperscriptBox["e", 
          RowBox[{"-", "i", "\[Omega]", "t"}]], 
         RowBox[{"\[DifferentialD]", "\[Omega]"}]}]}]}], TraditionalForm]], 
     "InlineMath"]], "TableText"]},
   {Cell["systems engineering", "TableText"], Cell[TextData[Cell[BoxData[
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}]}], "}"}]], "InlineFormula"]], "TableText"], Cell[
    TextData[Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox["\[Integral]", 
        RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
       RowBox[{
        RowBox[{"f", "(", "t", ")"}], " ", 
        SuperscriptBox["e", 
         RowBox[{"-", "i", "\[Omega]", "t"}]], 
        RowBox[{"\[DifferentialD]", "t"}]}]}], TraditionalForm]], 
     "InlineMath"]], "TableText"], Cell[TextData[Cell[BoxData[
     FormBox[
      RowBox[{
       FractionBox["1", 
        RowBox[{"2", "\[Pi]"}]], 
       RowBox[{
        SubsuperscriptBox["\[Integral]", 
         RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
        RowBox[{
         RowBox[{"F", "(", "\[Omega]", ")"}], " ", 
         SuperscriptBox["e", 
          RowBox[{"i", "\[Omega]", "t"}]], 
         RowBox[{"\[DifferentialD]", "\[Omega]"}]}]}]}], TraditionalForm]], 
     "InlineMath"]], "TableText"]},
   {Cell["signal processing", "TableText"], Cell[TextData[Cell[BoxData[
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{
        RowBox[{"-", "2"}], 
        ButtonBox["Pi",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Pi"]}]}], "}"}]], "InlineFormula"]], 
     "TableText"], Cell[TextData[Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox["\[Integral]", 
        RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
       RowBox[{
        RowBox[{"f", "(", "t", ")"}], " ", 
        SuperscriptBox["e", 
         RowBox[{"-", "2", "\[Pi]", "i", "\[Omega]", "t"}]], 
        RowBox[{"\[DifferentialD]", "t"}]}]}], TraditionalForm]], 
     "InlineMath"]], "TableText"], Cell[TextData[Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox["\[Integral]", 
        RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
       RowBox[{
        RowBox[{"F", "(", "\[Omega]", ")"}], " ", 
        SuperscriptBox["e", 
         RowBox[{"2", "\[Pi]", "i", "\[Omega]", "t"}]], 
        RowBox[{"\[DifferentialD]", "\[Omega]"}]}]}], TraditionalForm]], 
     "InlineMath"]], "TableText"]},
   {Cell["general case", "TableText"], Cell[TextData[Cell[BoxData[
     RowBox[{"{", 
      RowBox[{
       StyleBox["a", "TI"], ",", 
       StyleBox["b", "TI"]}], "}"}]], "InlineFormula"]], "TableText"], Cell[
    TextData[Cell[BoxData[
     FormBox[
      RowBox[{
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"\[VerticalSeparator]", "b", "\[VerticalSeparator]"}], 
          ")"}], "/", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"2", "\[Pi]"}], ")"}], 
          RowBox[{"1", "-", "a"}]]}]], 
       RowBox[{
        SubsuperscriptBox["\[Integral]", 
         RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
        RowBox[{
         RowBox[{"f", "(", "t", ")"}], " ", 
         SuperscriptBox["e", 
          RowBox[{"i", "b", "\[Omega]", "t"}]], 
         RowBox[{"\[DifferentialD]", "t"}]}]}]}], TraditionalForm]], 
     "InlineMath"]], "TableText"], Cell[TextData[Cell[BoxData[
     FormBox[
      RowBox[{
       SqrtBox[
        FractionBox[
         RowBox[{"\[VerticalSeparator]", "b", "\[VerticalSeparator]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"2", "\[Pi]"}], ")"}], 
          RowBox[{"1", "+", "a"}]]]], 
       RowBox[{
        SubsuperscriptBox["\[Integral]", 
         RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
        RowBox[{
         RowBox[{"F", "(", "\[Omega]", ")"}], " ", 
         SuperscriptBox["e", 
          RowBox[{"-", "i", "b", "\[Omega]", "t"}]], 
         RowBox[{"\[DifferentialD]", "\[Omega]"}]}]}]}], TraditionalForm]], 
     "InlineMath"]], "TableText"]}
  }]], "DefinitionBox4Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, False, False, False, {False}, False},
    "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.25], 
     Scaled[0.2], 
     Scaled[0.25], {
      Scaled[0.3]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->651425130],

Cell[TextData[{
 "Typical settings for ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 " with various conventions. "
}], "Caption",
 CellID->15149],

Cell[TextData[{
 "  ",
 Cell[BoxData[Cell["", "TableText"]],
  GridBoxOptions->{
  GridBoxDividers->{
   "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {
     False, True, False, False, False, False, False, {False}, False}, 
    "RowsIndexed" -> {}},
  GridBoxItemSize->{"Columns" -> {
      Scaled[0.25], 
      Scaled[0.2], 
      Scaled[0.25], {
       Scaled[0.3]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 "  "
}], "Text",
 CellID->164699050],

Cell["\<\
Here is a Fourier transform with the default choice of parameters. \
\>", "MathCaption",
 CellID->15257],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"t", "^", "2"}]}], "]"}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->5312],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["\[Omega]", "2"], "4"]}]], 
  SqrtBox["2"]]], "Output",
 ImageSize->{35, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->9401]
}, Open  ]],

Cell["\<\
Here is the same Fourier transform with the choice of parameters typically \
used in signal processing. \
\>", "MathCaption",
 CellID->25199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"t", "^", "2"}]}], "]"}], ",", "t", ",", "\[Omega]", ",", 
   RowBox[{"FourierParameters", "->", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{
       RowBox[{"-", "2"}], " ", "Pi"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->24727],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["\[Pi]", "2"]}], " ", 
    SuperscriptBox["\[Omega]", "2"]}]], " ", 
  SqrtBox["\[Pi]"]}]], "Output",
 ImageSize->{69, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->32692]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FourierSinTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FourierSinTransform"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      StyleBox["t", "TI"], ",", 
      StyleBox["\[Omega]", "TR"]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell["Fourier sine transform", "TableText"]},
   {
    RowBox[{
     ButtonBox["FourierCosTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FourierCosTransform"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      StyleBox["t", "TI"], ",", 
      StyleBox["\[Omega]", "TR"]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell["Fourier cosine transform", "TableText"]},
   {
    RowBox[{
     ButtonBox["InverseFourierSinTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseFourierSinTransform"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      StyleBox["\[Omega]", "TR"], ",", 
      StyleBox["t", "TI"]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell["inverse Fourier sine transform", "TableText"]},
   {
    RowBox[{
     ButtonBox["InverseFourierCosTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseFourierCosTransform"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      StyleBox["\[Omega]", "TR"], ",", 
      StyleBox["t", "TI"]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell["inverse Fourier cosine transform", "TableText"]}
  }]], "DefinitionBox",
 CellID->22353],

Cell["Fourier sine and cosine transforms. ", "Caption",
 CellID->27795],

Cell[TextData[{
 "In some applications of Fourier transforms, it is convenient to avoid ever \
introducing complex exponentials. Fourier sine and cosine transforms \
correspond to integrating respectively with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", "(", 
    RowBox[{"\[Omega]", "t"}], ")"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"cos", "(", 
    RowBox[{"\[Omega]", "t"}], ")"}], TraditionalForm]], "InlineMath"],
 " instead of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"exp", "(", 
    RowBox[{"i", "\[Omega]", "t"}], ")"}], TraditionalForm]], "InlineMath"],
 ", and using limits 0 and ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 " rather than ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->26542],

Cell[TextData[{
 "Here are the Fourier sine and cosine transforms of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["e", 
    RowBox[{"-", "t"}]], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->22567],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"FourierSinTransform", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{"-", "t"}], "]"}], ",", "t", ",", "\[Omega]"}], "]"}], ",", 
   RowBox[{"FourierCosTransform", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{"-", "t"}], "]"}], ",", "t", ",", "\[Omega]"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->27149],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     SqrtBox[
      FractionBox["2", "\[Pi]"]], " ", "\[Omega]"}], 
    RowBox[{"1", "+", 
     SuperscriptBox["\[Omega]", "2"]}]], ",", 
   FractionBox[
    SqrtBox[
     FractionBox["2", "\[Pi]"]], 
    RowBox[{"1", "+", 
     SuperscriptBox["\[Omega]", "2"]}]]}], "}"}]], "Output",
 ImageSize->{110, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->12376]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FourierTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FourierTransform"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["\[Omega]", "TR"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["\[Omega]", "TR"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "the multidimensional Fourier transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["InverseFourierTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseFourierTransform"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["\[Omega]", "TR"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["\[Omega]", "TR"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "the multidimensional inverse Fourier transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      RowBox[{
       ButtonBox["FourierSinTransform",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FourierSinTransform"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["\[Omega]", "TR"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["\[Omega]", "TR"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], Cell[
      ",", "TableText"]}], "\n", 
     RowBox[{
      ButtonBox["FourierCosTransform",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FourierCosTransform"], "[", 
      RowBox[{
       StyleBox["expr", "TI"], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["t", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["t", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["\[Omega]", "TR"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["\[Omega]", "TR"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "the multidimensional sine and cosine Fourier transforms of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      RowBox[{
       ButtonBox["InverseFourierSinTransform",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InverseFourierSinTransform"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["\[Omega]", "TR"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["\[Omega]", "TR"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], Cell[
      ",", "TableText"]}], "\n", 
     RowBox[{
      ButtonBox["InverseFourierCosTransform",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/InverseFourierCosTransform"], "[", 
      RowBox[{
       StyleBox["expr", "TI"], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["\[Omega]", "TR"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["\[Omega]", "TR"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["t", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["t", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "the multidimensional inverse Fourier sine and cosine transforms of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->14255],

Cell["Multidimensional Fourier transforms. ", "Caption",
 CellID->26742],

Cell["\<\
This evaluates a two\[Hyphen]dimensional Fourier transform. \
\>", "MathCaption",
 CellID->16748],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"u", " ", "v"}], ")"}], "^", "2"}], " ", 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"u", "^", "2"}]}], "-", 
      RowBox[{"v", "^", "2"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "v"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->30103],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "32"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    SuperscriptBox["a", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    SuperscriptBox["b", "2"]}], ")"}], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["a", "2"], "4"]}], "-", 
    FractionBox[
     SuperscriptBox["b", "2"], "4"]}]]}]], "Output",
 ImageSize->{184, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->22815]
}, Open  ]],

Cell["This inverts the transform. ", "MathCaption",
 CellID->14047],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "v"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->11073],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["u", "2"]}], "-", 
    SuperscriptBox["v", "2"]}]], " ", 
  SuperscriptBox["u", "2"], " ", 
  SuperscriptBox["v", "2"]}]], "Output",
 ImageSize->{74, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->28965]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Z Transforms", "Section",
 CellID->4749],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ZTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ZTransform"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["n", "TI"], ",", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "Z transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["InverseZTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseZTransform"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["z", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "inverse Z transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->137],

Cell["Z transforms. ", "Caption",
 CellID->32169],

Cell[TextData[{
 "The Z transform of a function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "n", ")"}], TraditionalForm]], "InlineMath"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"n", "=", "0"}], "\[Infinity]",
     LimitsPositioning->True], 
    RowBox[{
     RowBox[{"f", "(", "n", ")"}], 
     SuperscriptBox["z", 
      RowBox[{"-", "n"}]]}]}], TraditionalForm]], "InlineMath"],
 ". The inverse Z transform of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "(", "z", ")"}], TraditionalForm]], "InlineMath"],
 " is given by the contour integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", "\[Pi]", "i"}]], 
    RowBox[{"\[ContourIntegral]", 
     RowBox[{
      RowBox[{"F", "(", "z", ")"}], 
      SuperscriptBox["z", 
       RowBox[{"n", "-", "1"}]], 
      RowBox[{"\[DifferentialD]", "z"}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". Z transforms are effectively discrete analogs of Laplace transforms. They \
are widely used for solving difference equations, especially in digital \
signal processing and control theory. They can be thought of as producing \
generating functions, of the kind commonly used in combinatorics and number \
theory. "
}], "Text",
 CellID->14331],

Cell[TextData[{
 "This computes the Z transform of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["2", 
    RowBox[{"-", "n"}]], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->7970],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{"2", "^", 
    RowBox[{"-", "n"}]}], ",", "n", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->26053],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "z"}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{"2", " ", "z"}]}]]], "Output",
 ImageSize->{53, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->8768]
}, Open  ]],

Cell["Here is the inverse Z transform. ", "MathCaption",
 CellID->28052],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{"%", ",", "z", ",", "n"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->13178],

Cell[BoxData[
 SuperscriptBox["2", 
  RowBox[{"-", "n"}]]], "Output",
 ImageSize->{22, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->11156]
}, Open  ]],

Cell[TextData[{
 "The generating function for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "n", "!"}], TraditionalForm]], "InlineMath"],
 " is an exponential function."
}], "MathCaption",
 CellID->24981],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"n", "!"}]}], ",", "n", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->12695],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  FractionBox["1", "z"]]], "Output",
 ImageSize->{20, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->17586]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->40397994],

Cell[TextData[ButtonBox["Calculus",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CalculusOverview"]], "RelatedTutorials",
 CellID->808424779]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Integral Transforms and Related Operations - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Calculus", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/CalculusOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DifferentialEquations"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/IntegralTransformsAndRelatedOperations"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 37, 39.2867658}", "context" -> "", 
    "keywords" -> {
     "Bromwich integral", "chirp Z transform", "control theory", 
      "cosine transform", "Dirichlet series", "discrete Laplace transform", 
      "formal power series", "FourierCosTransform", "FourierSinTransform", 
      "FourierTransform", "Fourier transforms", "frequency dimension", 
      "frequency spectrum", "generating functions", "HeavisideTheta", 
      "integral transforms", "InverseFourierCosTransform", 
      "InverseFourierSinTransform", "InverseFourierTransform", 
      "InverseLaplaceTransform", "InverseZTransform", "Laplace transform", 
      "LaplaceTransform", "operational calculus", "power series", 
      "power spectrum", "signal processing", "sine transform", "spectrum", 
      "time domain", "transfer function", "transform", "transient analysis"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "One-dimensional Laplace transforms. The Laplace transform of a function \
f(t) is given by SubsuperscriptBox[\\[Integral], 0, Infinity]f(t)e^-stdt. The \
inverse Laplace transform of F(s) is given for suitable \\[Gamma] by \
FractionBox[1, RowBox[{2, \\[Pi], i}]]SubsuperscriptBox[\\[Integral], \
RowBox[{\\[Gamma], -, i, Infinity}], RowBox[{\\[Gamma], +, i, \
Infinity}]]F(s)e^stds. Here is a simple Laplace transform. ", 
    "synonyms" -> {"3.5.12"}, "title" -> 
    "Integral Transforms and Related Operations", "type" -> "Tutorial", "uri" -> 
    "tutorial/IntegralTransformsAndRelatedOperations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.5.12"->{
  Cell[3136, 82, 107, 2, 70, "Title",
   CellTags->{"S3.5.12", "12.1"},
   CellID->26017]},
 "12.1"->{
  Cell[3136, 82, 107, 2, 70, "Title",
   CellTags->{"S3.5.12", "12.1"},
   CellID->26017]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.5.12", 49210, 1657},
 {"12.1", 49313, 1661}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2511, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3136, 82, 107, 2, 70, "Title",
 CellTags->{"S3.5.12", "12.1"},
 CellID->26017],
Cell[CellGroupData[{
Cell[3268, 88, 53, 1, 70, "Section",
 CellID->14932],
Cell[3324, 91, 1314, 38, 70, "DefinitionBox",
 CellID->14948],
Cell[4641, 131, 87, 3, 70, "Caption",
 CellID->31210],
Cell[4731, 136, 1192, 40, 70, "Text",
 CellID->3495],
Cell[5926, 178, 75, 1, 70, "MathCaption",
 CellID->26419],
Cell[CellGroupData[{
Cell[6026, 183, 223, 7, 28, "Input",
 CellID->14648],
Cell[6252, 192, 467, 17, 63, "Output",
 CellID->4189]
}, Open  ]],
Cell[6734, 212, 60, 1, 70, "MathCaption",
 CellID->10171],
Cell[CellGroupData[{
Cell[6819, 217, 149, 4, 28, "Input",
 CellID->15851],
Cell[6971, 223, 230, 8, 36, "Output",
 CellID->3695]
}, Open  ]],
Cell[7216, 234, 95, 1, 70, "MathCaption",
 CellID->11223],
Cell[CellGroupData[{
Cell[7336, 239, 246, 9, 70, "Input",
 CellID->3637],
Cell[7585, 250, 478, 16, 51, "Output",
 CellID->16649]
}, Open  ]],
Cell[8078, 269, 85, 1, 70, "MathCaption",
 CellID->15800],
Cell[CellGroupData[{
Cell[8188, 274, 247, 9, 70, "Input",
 CellID->24407],
Cell[8438, 285, 703, 25, 66, "Output",
 CellID->57068970]
}, Open  ]],
Cell[9156, 313, 237, 7, 70, "MathCaption",
 CellID->26480321],
Cell[CellGroupData[{
Cell[9418, 324, 152, 4, 70, "Input",
 CellID->624646011],
Cell[9573, 330, 227, 8, 52, "Output",
 CellID->1463698310]
}, Open  ]],
Cell[9815, 341, 131, 4, 70, "MathCaption",
 CellID->30884],
Cell[CellGroupData[{
Cell[9971, 349, 202, 6, 70, "Input",
 CellID->17177],
Cell[10176, 357, 401, 16, 80, "Output",
 CellID->14812]
}, Open  ]],
Cell[10592, 376, 256, 5, 70, "Text",
 CellID->20641],
Cell[10851, 383, 221, 7, 70, "MathCaption",
 CellID->25304],
Cell[CellGroupData[{
Cell[11097, 394, 300, 10, 70, "Input",
 CellID->4496],
Cell[11400, 406, 285, 10, 51, "Output",
 CellID->23162]
}, Open  ]],
Cell[11700, 419, 1907, 62, 70, "DefinitionBox",
 CellID->12537],
Cell[13610, 483, 72, 1, 70, "Caption",
 CellID->18551]
}, Open  ]],
Cell[CellGroupData[{
Cell[13719, 489, 53, 1, 70, "Section",
 CellID->25851],
Cell[13775, 492, 828, 25, 70, "DefinitionBox",
 CellID->2732],
Cell[14606, 519, 87, 3, 70, "Caption",
 CellID->31565],
Cell[14696, 524, 391, 12, 70, "MathCaption",
 CellID->18938],
Cell[CellGroupData[{
Cell[15112, 540, 254, 9, 70, "Input",
 CellID->27445],
Cell[15369, 551, 1263, 41, 98, "Output",
 CellID->21228]
}, Open  ]],
Cell[16647, 595, 62, 1, 70, "MathCaption",
 CellID->8194],
Cell[CellGroupData[{
Cell[16734, 600, 156, 4, 70, "Input",
 CellID->14526],
Cell[16893, 606, 222, 8, 52, "Output",
 CellID->2178]
}, Open  ]],
Cell[17130, 617, 1304, 46, 70, "Text",
 CellID->15745],
Cell[18437, 665, 431, 12, 70, "Text",
 CellID->6928],
Cell[18871, 679, 9134, 245, 70, "DefinitionBox4Col",
 CellID->651425130],
Cell[28008, 926, 240, 8, 70, "Caption",
 CellID->15149],
Cell[28251, 936, 495, 17, 70, "Text",
 CellID->164699050],
Cell[28749, 955, 114, 3, 70, "MathCaption",
 CellID->15257],
Cell[CellGroupData[{
Cell[28888, 962, 228, 8, 70, "Input",
 CellID->5312],
Cell[29119, 972, 300, 11, 68, "Output",
 CellID->9401]
}, Open  ]],
Cell[29434, 986, 151, 4, 70, "MathCaption",
 CellID->25199],
Cell[CellGroupData[{
Cell[29610, 994, 379, 12, 70, "Input",
 CellID->24727],
Cell[29992, 1008, 339, 12, 40, "Output",
 CellID->32692]
}, Open  ]],
Cell[30346, 1023, 1469, 42, 70, "DefinitionBox",
 CellID->22353],
Cell[31818, 1067, 71, 1, 70, "Caption",
 CellID->27795],
Cell[31892, 1070, 943, 30, 70, "Text",
 CellID->26542],
Cell[32838, 1102, 221, 8, 70, "MathCaption",
 CellID->22567],
Cell[CellGroupData[{
Cell[33084, 1114, 403, 13, 70, "Input",
 CellID->27149],
Cell[33490, 1129, 481, 18, 77, "Output",
 CellID->12376]
}, Open  ]],
Cell[33986, 1150, 5645, 178, 70, "DefinitionBox",
 CellID->14255],
Cell[39634, 1330, 72, 1, 70, "Caption",
 CellID->26742],
Cell[39709, 1333, 107, 3, 70, "MathCaption",
 CellID->16748],
Cell[CellGroupData[{
Cell[39841, 1340, 477, 17, 70, "Input",
 CellID->30103],
Cell[40321, 1359, 590, 22, 55, "Output",
 CellID->22815]
}, Open  ]],
Cell[40926, 1384, 67, 1, 70, "MathCaption",
 CellID->14047],
Cell[CellGroupData[{
Cell[41018, 1389, 247, 8, 70, "Input",
 CellID->11073],
Cell[41268, 1399, 370, 13, 40, "Output",
 CellID->28965]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[41687, 1418, 46, 1, 70, "Section",
 CellID->4749],
Cell[41736, 1421, 785, 26, 70, "DefinitionBox",
 CellID->137],
Cell[42524, 1449, 49, 1, 70, "Caption",
 CellID->32169],
Cell[42576, 1452, 1289, 39, 70, "Text",
 CellID->14331],
Cell[43868, 1493, 202, 8, 70, "MathCaption",
 CellID->7970],
Cell[CellGroupData[{
Cell[44095, 1505, 180, 6, 70, "Input",
 CellID->26053],
Cell[44278, 1513, 263, 10, 52, "Output",
 CellID->8768]
}, Open  ]],
Cell[44556, 1526, 72, 1, 70, "MathCaption",
 CellID->28052],
Cell[CellGroupData[{
Cell[44653, 1531, 143, 4, 70, "Input",
 CellID->13178],
Cell[44799, 1537, 196, 7, 36, "Output",
 CellID->11156]
}, Open  ]],
Cell[45010, 1547, 208, 7, 70, "MathCaption",
 CellID->24981],
Cell[CellGroupData[{
Cell[45243, 1558, 180, 6, 70, "Input",
 CellID->12695],
Cell[45426, 1566, 213, 7, 43, "Output",
 CellID->17586]
}, Open  ]],
Cell[CellGroupData[{
Cell[45676, 1578, 71, 1, 70, "RelatedTutorialsSection",
 CellID->40397994],
Cell[45750, 1581, 146, 3, 70, "RelatedTutorials",
 CellID->808424779]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[45935, 1589, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

