(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23057,        873]
NotebookOptionsPosition[     16829,        671]
NotebookOutlinePosition[     19752,        744]
CellTagsIndexPosition[     19661,        738]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbolic Mathematics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SymbolicMathematicsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Symbolic Mathematics\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integrate" :> 
          Documentation`HelpLookup["paclet:ref/Integrate"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integrate\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Integration", "Title",
 CellTags->{"S1.5.3", "3.1"},
 CellID->26107],

Cell[TextData[{
 "Here is the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Integral]", 
    SuperscriptBox["x", "n"], " ", "d", "x"}], TraditionalForm]], 
  "InlineMath"],
 " in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "MathCaption",
 CellID->12205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", "^", "n"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->22599],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["x", 
   RowBox[{"1", "+", "n"}]], 
  RowBox[{"1", "+", "n"}]]], "Output",
 ImageSize->{35, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->788]
}, Open  ]],

Cell["Here is a slightly more complicated example. ", "MathCaption",
 CellID->13261],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "4"}], "-", 
      RowBox[{"a", "^", "4"}]}], ")"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->29045],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox["x", "a"], "]"}], 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"]}]]}], "+", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{"a", "-", "x"}], "]"}], 
   RowBox[{"4", " ", 
    SuperscriptBox["a", "3"]}]], "-", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{"a", "+", "x"}], "]"}], 
   RowBox[{"4", " ", 
    SuperscriptBox["a", "3"]}]]}]], "Output",
 ImageSize->{239, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->24435]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " knows how to do almost any integral that can be done in terms of standard \
mathematical functions. But you should realize that even though an integrand \
may contain only fairly simple functions, its integral may involve much more \
complicated functions\[LongDash]or may not be expressible at all in terms of \
standard mathematical functions."
}], "Text",
 CellID->7492],

Cell["Here is a fairly straightforward integral. ", "MathCaption",
 CellID->5732],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", 
     RowBox[{"x", "^", "2"}]}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->30076],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "2"}], " ", "x"}], "-", 
  RowBox[{"Log", "[", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], "]"}], "+", 
  RowBox[{"Log", "[", 
   RowBox[{"1", "+", "x"}], "]"}], "+", 
  RowBox[{"x", " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"]}], "]"}]}]}]], "Output",
 ImageSize->{275, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->4667]
}, Open  ]],

Cell["\<\
This integral can be done only in terms of a dilogarithm function. \
\>", "MathCaption",
 CellID->403],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", 
      RowBox[{"x", "^", "2"}]}], "]"}], "/", "x"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->18367],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "2"]}], " ", 
  RowBox[{"PolyLog", "[", 
   RowBox[{"2", ",", 
    SuperscriptBox["x", "2"]}], "]"}]}]], "Output",
 ImageSize->{120, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->18899]
}, Open  ]],

Cell[TextData[{
 "This integral involves ",
 Cell[BoxData[
  ButtonBox["Erf",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Erf"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21054],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"1", "-", 
     RowBox[{"x", "^", "2"}]}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->10167],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "\[ExponentialE]", " ", 
  SqrtBox["\[Pi]"], " ", 
  RowBox[{"Erf", "[", "x", "]"}]}]], "Output",
 ImageSize->{98, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->19212]
}, Open  ]],

Cell["And this one involves a Fresnel function. ", "MathCaption",
 CellID->26114],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->30129],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   FractionBox["\[Pi]", "2"]], " ", 
  RowBox[{"FresnelS", "[", 
   RowBox[{
    SqrtBox[
     FractionBox["2", "\[Pi]"]], " ", "x"}], "]"}]}]], "Output",
 ImageSize->{151, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->5793]
}, Open  ]],

Cell["Even this integral requires a hypergeometric function. ", "MathCaption",
 CellID->11977],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"x", "^", "2"}]}], ")"}], "^", "n"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->29854],

Cell[BoxData[
 RowBox[{"x", " ", 
  RowBox[{"Hypergeometric2F1", "[", 
   RowBox[{
    FractionBox["1", "2"], ",", 
    RowBox[{"-", "n"}], ",", 
    FractionBox["3", "2"], ",", 
    SuperscriptBox["x", "2"]}], "]"}]}]], "Output",
 ImageSize->{230, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->15012]
}, Open  ]],

Cell[TextData[{
 "This integral simply cannot be done in terms of standard mathematical \
functions. As a result, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " just leaves it undone. "
}], "MathCaption",
 CellID->6831],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", "^", "x"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->14889],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 ImageSize->{47, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->23326]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Integrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integrate"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "the indefinite integral ",
     Cell[BoxData[
      RowBox[{"\[Integral]", 
       StyleBox["f", "TI"], " ", 
       StyleBox["d", "TI"], 
       StyleBox["x", "TI"]}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Integrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integrate"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "]"}], Cell[TextData[{
     "the multiple integral ",
     Cell[BoxData[
      RowBox[{"\[Integral]", 
       StyleBox["d", "TI"], 
       StyleBox["x", "TI"], " ", 
       StyleBox["d", "TI"], 
       StyleBox["y", "TI"], " ", 
       StyleBox["f", "TI"]}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Integrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integrate"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], Cell[TextData[{
     "the definite integral ",
     Cell[BoxData[
      RowBox[{
       SubsuperscriptBox["\[Integral]", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["min", "TI"]], 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["max", "TI"]]], 
       StyleBox["f", "TI"], " ", 
       StyleBox["d", "TI"], 
       StyleBox["x", "TI"]}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Integrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integrate"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]], "}", ",", "{", 
     StyleBox["y", "TI"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "the multiple integral ",
     Cell[BoxData[
      RowBox[{
       SubsuperscriptBox["\[Integral]", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["min", "TI"]], 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["max", "TI"]]], 
       StyleBox["d", "TI"], 
       StyleBox["x", "TI"], 
       SubsuperscriptBox["\[Integral]", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["min", "TI"]], 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["max", "TI"]]], 
       StyleBox["d", "TI"], 
       StyleBox["y", "TI"], " ", 
       StyleBox["f", "TI"]}]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->32647],

Cell["Integration. ", "Caption",
 CellID->11299],

Cell[TextData[{
 "Here is the definite integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", "a", "b"], 
    SuperscriptBox["sin", "2"], 
    RowBox[{"(", "x", ")"}], " ", "d", "x"}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "MathCaption",
 CellID->2489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "a", ",", "b"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->29674],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "a"}], "+", "b", "+", 
    RowBox[{
     RowBox[{"Cos", "[", "a", "]"}], " ", 
     RowBox[{"Sin", "[", "a", "]"}]}], "-", 
    RowBox[{
     RowBox[{"Cos", "[", "b", "]"}], " ", 
     RowBox[{"Sin", "[", "b", "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{266, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->25836]
}, Open  ]],

Cell["Here is another definite integral. ", "MathCaption",
 CellID->6612],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"x", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->24387],

Cell[BoxData[
 FractionBox[
  SqrtBox["\[Pi]"], "2"]], "Output",
 ImageSize->{33, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->11957]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " cannot give you a formula for this definite integral. "
}], "MathCaption",
 CellID->15503],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", "^", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->19491],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "1"], 
  RowBox[{
   SuperscriptBox["x", "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 ImageSize->{53, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->10482]
}, Open  ]],

Cell["You can still get a numerical result, though. ", "MathCaption",
 CellID->2829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->27027],

Cell[BoxData["0.783430510715466`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->13361]
}, Open  ]],

Cell[TextData[{
 "This evaluates the multiple integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "1"], "d", "x", 
    SubsuperscriptBox["\[Integral]", "0", "x"], "d", "y", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], ")"}]}], TraditionalForm]], "InlineMath"],
 ". The range of the outermost integration variable appears first. "
}], "MathCaption",
 CellID->952],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "x"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->8496],

Cell[BoxData[
 FractionBox["1", "3"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->5646]
}, Open  ]],

Cell[TextData[{
 "This integrates ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "10"], TraditionalForm]], "InlineMath"],
 " over a circular region. "
}], "MathCaption",
 CellID->15183],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "10"}], " ", 
    RowBox[{"Boole", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<=", "1"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->15597],

Cell[BoxData[
 FractionBox[
  RowBox[{"21", " ", "\[Pi]"}], "512"]], "Output",
 ImageSize->{34, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->11554]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->174031652],

Cell[TextData[ButtonBox["Symbolic Mathematics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SymbolicMathematicsOverview"]], "RelatedTutorials",
 CellID->391267452]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Integration - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Symbolic Mathematics", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> "paclet:tutorial/SymbolicMathematicsOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/SymbolicMathematics-BasicOperations"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/SumsAndProducts"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 37, 41.2243154}", "context" -> "", 
    "keywords" -> {
     "area", "areas", "calculus", "integrals", "Integrate", "integration", 
      "multiple integrals", "numerical integration", "quadrature", 
      "region integrals", "surface integrals", "volume integrals"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Here is the integral \\[Integral]x^n dx in Mathematica. Here is a \
slightly more complicated example. Mathematica knows how to do almost any \
integral that can be done in terms of standard mathematical functions. But \
you should realize that even though an integrand may contain only fairly \
simple functions, its integral may involve much more complicated \
functions--or may not be expressible at all in terms of standard mathematical \
functions.", "synonyms" -> {"1.5.3"}, "title" -> "Integration", "type" -> 
    "Tutorial", "uri" -> "tutorial/Integration"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.5.3"->{
  Cell[1819, 59, 74, 2, 70, "Title",
   CellTags->{"S1.5.3", "3.1"},
   CellID->26107]},
 "3.1"->{
  Cell[1819, 59, 74, 2, 70, "Title",
   CellTags->{"S1.5.3", "3.1"},
   CellID->26107]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.5.3", 19450, 727},
 {"3.1", 19549, 731}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1194, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1819, 59, 74, 2, 70, "Title",
 CellTags->{"S1.5.3", "3.1"},
 CellID->26107],
Cell[1896, 63, 277, 12, 70, "MathCaption",
 CellID->12205],
Cell[CellGroupData[{
Cell[2198, 79, 149, 5, 28, "Input",
 CellID->22599],
Cell[2350, 86, 244, 9, 54, "Output",
 CellID->788]
}, Open  ]],
Cell[2609, 98, 84, 1, 70, "MathCaption",
 CellID->13261],
Cell[CellGroupData[{
Cell[2718, 103, 254, 9, 28, "Input",
 CellID->29045],
Cell[2975, 114, 593, 22, 61, "Output",
 CellID->24435]
}, Open  ]],
Cell[3583, 139, 441, 9, 70, "Text",
 CellID->7492],
Cell[4027, 150, 81, 1, 70, "MathCaption",
 CellID->5732],
Cell[CellGroupData[{
Cell[4133, 155, 207, 7, 28, "Input",
 CellID->30076],
Cell[4343, 164, 473, 17, 39, "Output",
 CellID->4667]
}, Open  ]],
Cell[4831, 184, 112, 3, 70, "MathCaption",
 CellID->403],
Cell[CellGroupData[{
Cell[4968, 191, 237, 9, 70, "Input",
 CellID->18367],
Cell[5208, 202, 302, 11, 51, "Output",
 CellID->18899]
}, Open  ]],
Cell[5525, 216, 193, 8, 70, "MathCaption",
 CellID->21054],
Cell[CellGroupData[{
Cell[5743, 228, 207, 7, 70, "Input",
 CellID->10167],
Cell[5953, 237, 278, 9, 51, "Output",
 CellID->19212]
}, Open  ]],
Cell[6246, 249, 81, 1, 70, "MathCaption",
 CellID->26114],
Cell[CellGroupData[{
Cell[6352, 254, 181, 6, 70, "Input",
 CellID->30129],
Cell[6536, 262, 316, 12, 61, "Output",
 CellID->5793]
}, Open  ]],
Cell[6867, 277, 94, 1, 70, "MathCaption",
 CellID->11977],
Cell[CellGroupData[{
Cell[6986, 282, 230, 9, 70, "Input",
 CellID->29854],
Cell[7219, 293, 358, 12, 51, "Output",
 CellID->15012]
}, Open  ]],
Cell[7592, 308, 227, 7, 70, "MathCaption",
 CellID->6831],
Cell[CellGroupData[{
Cell[7844, 319, 149, 5, 70, "Input",
 CellID->14889],
Cell[7996, 326, 259, 9, 50, "Output",
 CellID->23326]
}, Open  ]],
Cell[8270, 338, 3523, 115, 70, "DefinitionBox",
 CellID->32647],
Cell[11796, 455, 48, 1, 70, "Caption",
 CellID->11299],
Cell[11847, 458, 293, 11, 70, "MathCaption",
 CellID->2489],
Cell[CellGroupData[{
Cell[12165, 473, 240, 8, 70, "Input",
 CellID->29674],
Cell[12408, 483, 468, 16, 51, "Output",
 CellID->25836]
}, Open  ]],
Cell[12891, 502, 73, 1, 70, "MathCaption",
 CellID->6612],
Cell[CellGroupData[{
Cell[12989, 507, 269, 9, 70, "Input",
 CellID->24387],
Cell[13261, 518, 192, 7, 56, "Output",
 CellID->11957]
}, Open  ]],
Cell[13468, 528, 158, 5, 70, "MathCaption",
 CellID->15503],
Cell[CellGroupData[{
Cell[13651, 537, 209, 7, 70, "Input",
 CellID->19491],
Cell[13863, 546, 292, 10, 51, "Output",
 CellID->10482]
}, Open  ]],
Cell[14170, 559, 84, 1, 70, "MathCaption",
 CellID->2829],
Cell[CellGroupData[{
Cell[14279, 564, 95, 3, 70, "Input",
 CellID->27027],
Cell[14377, 569, 173, 5, 36, "Output",
 CellID->13361]
}, Open  ]],
Cell[14565, 577, 467, 13, 70, "MathCaption",
 CellID->952],
Cell[CellGroupData[{
Cell[15057, 594, 327, 11, 70, "Input",
 CellID->8496],
Cell[15387, 607, 175, 6, 51, "Output",
 CellID->5646]
}, Open  ]],
Cell[15577, 616, 190, 7, 70, "MathCaption",
 CellID->15183],
Cell[CellGroupData[{
Cell[15792, 627, 490, 17, 70, "Input",
 CellID->15597],
Cell[16285, 646, 206, 7, 51, "Output",
 CellID->11554]
}, Open  ]],
Cell[CellGroupData[{
Cell[16528, 658, 72, 1, 70, "RelatedTutorialsSection",
 CellID->174031652],
Cell[16603, 661, 172, 4, 70, "RelatedTutorials",
 CellID->391267452]
}, Open  ]]
}, Open  ]],
Cell[16802, 669, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

