(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     75950,       1394]
NotebookOptionsPosition[     71957,       1270]
NotebookOutlinePosition[     73446,       1310]
CellTagsIndexPosition[     73403,       1307]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Editing Mathematica Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/InteractiveGraphicsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Editing Mathematica Graphics\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Interactivity & Drawing" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsInteractivityAndDrawing"], 
          "Annotating & Combining Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/AnnotatingAndCombiningGraphics"], 
          "Combining Graphics" :> 
          Documentation`HelpLookup["paclet:guide/CombiningGraphics"], 
          "Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"], 
          "Graphics Options & Styling" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsOptionsAndStyling"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup[
           "paclet:guide/SymbolicGraphicsLanguage"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graphics Interactivity & Drawing\"\>", 
       2->"\<\"Annotating & Combining Graphics\"\>", 
       3->"\<\"Combining Graphics\"\>", 
       4->"\<\"Graphics Annotation & Appearance\"\>", 
       5->"\<\"Graphics Options & Styling\"\>", 
       6->"\<\"Symbolic Graphics Language\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Resizing, Cropping, and Adding Margins to Graphics", "Title",
 CellID->509267359],

Cell[CellGroupData[{

Cell["Changing the AspectRatio", "Section",
 CellID->13473268],

Cell["\<\
The following sequence shows how to change the aspect ratio of a plot.\
\>", "Text",
 CellID->32004648],

Cell["Using the Selection tool, click to select the graphic. ", "MathCaption",
 CellID->98065392],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "+", 
    RowBox[{"1", "/", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"3", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellID->452195786],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    GraphicsBox[LineBox[CompressedData["
1:eJxFVAk0lWkYRlz3IpXQvZK4hUraJo2pxvuW0kb7ZCs1VCJLTZtRqEwq+zKW
Ug2D0jJK5yChj7Ikh8oWwo+SOiR1c/8kzPer9J/znf+857zL9z3v8zx6jp4b
d8nJyMjsoYf7S4tdm87YnTeTGf4+gbHDTJWIqtMQuung1NghFpaa7q6Pyo+B
SVder5xF4+z9QX3ZiYlg25vdEDjAAjNO41p80BWgyeG+/SwsXrfYWZmfDjRZ
b0DKgoHmp0CPvEwouXsnhNfDgrGZQr4XLw9yX6hPKm1nocZ8/l3/ugKYcXX8
k2V1LKTUhN8pqSyB80cu/Dslm4VROxb7BwyWw/6Jo1uMw1lYX+LEm/HiKaQm
r8Xxv7Ow8lUECL3qYPpwvRTkdm1K65nFwOe3nfm/TJHCuZ41A7lX20AQONmp
264X9hpJY5ui3kDtlq7ZOYYS+Om3OXS0BAq0f/X1rOoE2WY5mtoHp0bp2ebL
t4COpquVJHQIDNDK2L4zB37+dH/ntRY5DHSwSG+sfEQmGGxSSIqUx+JRjy5v
ba0hy+t6Pq62VUCVW2Frt/XVkce7azpcjXhYo+pnVZv6nLyuv/F561se7inL
VreObiK3VfbfCLJXxNdXVbNFHs1k+Jr3FTG8obB0QJUhm16kxBfq8vGhbV2V
qh9Dbuq/9L9kxcf3Gc4x8qkMWcXhfJiPOTUHKvuLGZJjOEY54zIf3T0s19m0
MeS6mbV9OuHjrVEdwdPeMiSuKer0qQY+Jjw49qeslPaP0Qs99J6PS1RXx7n0
0/pVKnJGigL8ijtDbGh1l44Av/KjhUwvG1ty11SA1tE+1vJDDAkKfflh8kbB
SL3PJFPnZS6Ckf7zXqXRGwvwiMZG3410vn0V3fxFwcj9MjX6y7pLBahy3WuK
5CFDzM04hATYOGv+M5dkhixf8UffGBcl1LkxdCBuNkNkjU5r1lcoYaV1+O6Z
55tJO9f+kjLamJVJWrobiWCP2M3LWwW7wuNbeccavr1HFRlurU7V5GnE1kFz
7zG4SKStf7OilIzliGkxDs/1Ok4zbMgDbh3PX6uhw0UnlHq3gJdNqkn5UXWs
17+WxcvsAmuftEzHIQ108ew5VbpZAhcdOEQ0kUtbtLYX1NShuNFkAl5/XEMZ
JoXOtgVa+fETcLtihWhDgxQCrlg/micvRBpMPEb5O5y2SIgWf0t52+NYWHNZ
yUL/kBBX2waY1haxELVQ1uqvECEmLs+UDFRT/e0V9CVcEWLKTHPtzjaqDy/l
qdPuCXF4zV0s+LeVxOXUCpFTQ89HFhI+zX2V1i5E32CukoUzH58/OyERYrR5
kFsH1Wux+/zjWTIifDQ8gAXJ5ErP7YoipCx1LxpkoXRzQWqyqgi/6//oAsqo
iSL87hcmx7PwpPhHPH1r2P3eaT/iORwhTX7UP0if5ZG05Me8r7iJkNejuXL9
Fxb4HEz2Inxnym2eBWoCX04fFGHz/kDKNBa45/oGi9Aw4eyt1jcsbNjLOQXt
X9oOyQwLp+wowapF2HJhXEpeAQvdnA0oaaFk2NBYOLtkR/sTRy3kVBpgykJS
JAW4UAvDhoGifjFDGF19diIOVnu9MZjbC/JbVI1vb9NGceghakESCIn1UPOX
0cFk2VwFNfVOCKBsZKMmY5Zy+SEtlyboPJCh0R+ki8tClkba5mXBzRWt3urd
urhwbKSCZcttosTx004P3Tv6r76vLCch3Fry9TD4bHlJRmItmWS3cxHzTg/d
fCKexByoJ23e6mkr9MTovDa2qPDVc1J6+N4/WuvEGCVjkuH2XxP5wO3LWYzb
OTtybSb7OFqeEKOdpZtZ2uhvfhEixoqX8VRyVG+OfvW/nhNj2F7zIlPqJ64c
sMlitOhMdT1J/YSyf4/MTTHWauvGJZUwpNpol6jtjhhtOoThec0MSeFs94EY
iwO1LB/0MMSvf+G+iodifLahRn4Dy5DDnFGX03lzdY/mUT/47Ouae7BKjOH+
arsbqJ9w8vGrF4/4yf80LiqE
      "]],
     AspectRatio->0.618033988749895,
     Axes->Automatic], {0.010937, 0.0036458}, {
    Left, Bottom}, {1, 0.61803}], {
    {EdgeForm[{RGBColor[1., 0.501960784313725, 0.], Thickness[0.001]}], 
     FaceForm[None], RectangleBox[{0, 0}, {1.05, 0.61803}]}, 
    {EdgeForm[None], FaceForm[None], RectangleBox[{0, 0}, {1.1, 0.61803}]}, 
    {RGBColor[1., 0.501960784313725, 0.], 
     RectangleBox[{0, 0}, {0.0105, 0.0105}], 
     RectangleBox[{1.0395, 0.60753}, {1.05, 0.61803}], 
     RectangleBox[{0, 0.60753}, {0.0105, 0.61803}], 
     RectangleBox[{1.0395, 0}, {1.05, 0.0105}], 
     RectangleBox[{0, 0.30377}, {0.0105, 0.31427}], 
     RectangleBox[{0.51975, 0.60753}, {0.53025, 0.61803}], 
     RectangleBox[{1.0395, 0.30377}, {1.05, 0.31427}], 
     RectangleBox[{0.51975, 0}, {0.53025, 0.0105}]}}, 
   RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 
    1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 1}, {1, 
    1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 
    1}, {0, 1}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
    1}, {1, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 
    1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
    1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
    1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 
    1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 
    1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 
    1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}}, {
    Offset[{0.5, -21.5}, {0.8554, 0.5071}], 
     Offset[{21.5, -0.5}, {0.8554, 0.5071}]}]}]], "Input",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellID->170363190],

Cell[TextData[{
 StyleBox["Shift", "KeyEvent"],
 "-drag a handle to change the aspect ratio. "
}], "MathCaption",
 CellID->177305432],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    GraphicsBox[{
      {GrayLevel[0.8], LineBox[CompressedData["
1:eJxFVAtUTWkUvnVPNVa6Pe7VKnVT8h4xERNGexN5MyUqbxlUyiuG6DXuEjXS
a1IUS2T0IK8hqfyUSqWkF3Lr3NJ4TElU90jK/Oci/1rnnLXX+ffe///t7/ss
3Lc5bVQXCAQe9OG/TrHZszcNirUTqNYHeBRc0yrXlcHRpbuGxX3mwN/95Bh2
YjRIz7+aO47GC/5jbPQnJ4JbV1ZdWC8H+nlnwy1rzwDdHBnYw8GyuynJizEd
6GaLXiUHeg6tYrS+CkW3boZrtnOQELHFvsA2E3KeS6TF/3IQPXTChabwHBiT
Kq6Y9YQD19bx2SN18+HEnsQzllkcuMQGuDCfi2CHiY7CKpLGK6+Q1lMPgO8i
Xs8Bq2V+PTSmCkar8pWwraDv6v73T+Djm5Y7UyyV4Nc2fdVOeT0MCBuyoW1F
F8hsNjza9Xsz1C7nG3VA0oS+gMKDbXDXdHrgtqoWWJ9f9eNG4044KLRwu8Mo
wNcj6o0/dMMIXGS1siUbQmxrC3xs+iBsjcMVeWUJOehfcc1ttwALhSV/r2qs
IZKMOY37JGo48HLE4tXdT4jls+5Arxw1rBEFLapNeUaCR+SFnHdRR4/SLIlL
bD3Z0a37OvOSOr5KFWUZb20gnw51PnusJsTIunvFvSKWZAxvlp1aJMT7bk+q
REEscTpmcXT3DiG+u775GJPCEnZJeNzWaCFm1/hW9hSy5F3nfLeQm0L02bpw
iWsTSx6olhAvC18eGfWGJarrNQnxdL6/n5qSJRRk2lKIM0Tz4z17WLJ5lue2
dg0Ghet+kYX0seSt4dxfPxkx+IUfCsIURFjvsWLwy1xYokjUP5c7g+nP/5D3
W9o6Z6a/fltx/syLngzuGeQU6ET7lybNvtERwPSfb6uB7E5JEoMD0/dadtxn
ibue65R/7jMoH2fz2DOZJeFZWwZ0m2ug2YXPvvHj6X5+vjs1sNIlctPYEw0k
yCtnV4yRJrralXYo2uRkzNTo0qD7mtgamdCo6V/39T4/IKvOM6CaRJ3+YP1i
3ACcZmw6/FJ5MeFZCMnaeLzLfdTIulxIKVzwc+gMEa45uQGV+xTQoMrTw6fD
0zI1b7TC6Dc6t386ro+06sFi5w5wT6q1eWtrgK4pk8qmLe6CXuVuRWKUAaY/
rKEMU37Jf26Aa7XKjR3rlNDpvTwgY7IYaWDiT/nruIUy3V2MDn8pNdfGc+DM
yy5SjHSKlGkceDXsCDuaLEYett5qDtptZ8/ZmSXGc2PtTVuaOFgjdxDuLRWj
nUoYHPjyhVgx8mpo7+Rg7a15A9VbxBh4hAfyq36VYoy1/9P7JdVr2gHHeScF
EixRNeDgC14SvPBxlU9BHwcPD1c2KLQl+E3/PNqMoQS/+UU5t/T5OZPv8fZy
mmD+PX40lApgzPd8IkqceMbme78o3X2T0+0kqNnOE42D9c5OI0/Pk+Bb/p70
vDGp9ICrJcjD0Pye4kN/h26XIH1fbnzNgY9NcCYeoPX5MbIcVPD90iSo4uVd
Ds6ocJNgh8rQOMBk9rbIdBC28zqx5UAFg+cgjOB5kaEE3nU+aRliX/Xe1yOs
u2Apr7crhjiUqs5EpwOo2gxkAiNMVsvRMJC0wOENq+UO9saYqV22e7BnPdjz
xuM3GGeFz4x2y80EWVNRfLahCU7Vi9ZYqLhKtvAA3jNBn5c9qe8qy8gc4V7t
YR6meCS0rOh6Ui1Rye2aKXoHRFUc831K6HSCR6hLcfPiuIJ7L54Rv6LRU6MX
SDFGMOm698V6oqLRTimu5e3Iq4EM4+WcIMUVC73tMnRYslxkdfXkJSmWNydQ
ybFkKV8vT4oqG6Z+In/8h69DtRQdWlK8DlA/kYf1buSapVhrah5/tojGvH11
StH1pVFkbgNLlHH1MYc0zLAwbPDC/HaWqHgvMsPHjjWMI8cSK4shnd6GZlhu
bb4/l/pBsdb0hGVDzDBSZrCpjvrJ6FUReV2jzPr95H/Yri7M
        "]]}, LineBox[CompressedData["
1:eJxFVAk0lWkYRlz3IpXQvZK4hUraJo2pxvuW0kb7ZCs1VCJLTZtRqEwq+zKW
Ug2D0jJK5yChj7Ikh8oWwo+SOiR1c/8kzPer9J/znf+857zL9z3v8zx6jp4b
d8nJyMjsoYf7S4tdm87YnTeTGf4+gbHDTJWIqtMQuung1NghFpaa7q6Pyo+B
SVder5xF4+z9QX3ZiYlg25vdEDjAAjNO41p80BWgyeG+/SwsXrfYWZmfDjRZ
b0DKgoHmp0CPvEwouXsnhNfDgrGZQr4XLw9yX6hPKm1nocZ8/l3/ugKYcXX8
k2V1LKTUhN8pqSyB80cu/Dslm4VROxb7BwyWw/6Jo1uMw1lYX+LEm/HiKaQm
r8Xxv7Ow8lUECL3qYPpwvRTkdm1K65nFwOe3nfm/TJHCuZ41A7lX20AQONmp
264X9hpJY5ui3kDtlq7ZOYYS+Om3OXS0BAq0f/X1rOoE2WY5mtoHp0bp2ebL
t4COpquVJHQIDNDK2L4zB37+dH/ntRY5DHSwSG+sfEQmGGxSSIqUx+JRjy5v
ba0hy+t6Pq62VUCVW2Frt/XVkce7azpcjXhYo+pnVZv6nLyuv/F561se7inL
VreObiK3VfbfCLJXxNdXVbNFHs1k+Jr3FTG8obB0QJUhm16kxBfq8vGhbV2V
qh9Dbuq/9L9kxcf3Gc4x8qkMWcXhfJiPOTUHKvuLGZJjOEY54zIf3T0s19m0
MeS6mbV9OuHjrVEdwdPeMiSuKer0qQY+Jjw49qeslPaP0Qs99J6PS1RXx7n0
0/pVKnJGigL8ijtDbGh1l44Av/KjhUwvG1ty11SA1tE+1vJDDAkKfflh8kbB
SL3PJFPnZS6Ckf7zXqXRGwvwiMZG3410vn0V3fxFwcj9MjX6y7pLBahy3WuK
5CFDzM04hATYOGv+M5dkhixf8UffGBcl1LkxdCBuNkNkjU5r1lcoYaV1+O6Z
55tJO9f+kjLamJVJWrobiWCP2M3LWwW7wuNbeccavr1HFRlurU7V5GnE1kFz
7zG4SKStf7OilIzliGkxDs/1Ok4zbMgDbh3PX6uhw0UnlHq3gJdNqkn5UXWs
17+WxcvsAmuftEzHIQ108ew5VbpZAhcdOEQ0kUtbtLYX1NShuNFkAl5/XEMZ
JoXOtgVa+fETcLtihWhDgxQCrlg/micvRBpMPEb5O5y2SIgWf0t52+NYWHNZ
yUL/kBBX2waY1haxELVQ1uqvECEmLs+UDFRT/e0V9CVcEWLKTHPtzjaqDy/l
qdPuCXF4zV0s+LeVxOXUCpFTQ89HFhI+zX2V1i5E32CukoUzH58/OyERYrR5
kFsH1Wux+/zjWTIifDQ8gAXJ5ErP7YoipCx1LxpkoXRzQWqyqgi/6//oAsqo
iSL87hcmx7PwpPhHPH1r2P3eaT/iORwhTX7UP0if5ZG05Me8r7iJkNejuXL9
Fxb4HEz2Inxnym2eBWoCX04fFGHz/kDKNBa45/oGi9Aw4eyt1jcsbNjLOQXt
X9oOyQwLp+wowapF2HJhXEpeAQvdnA0oaaFk2NBYOLtkR/sTRy3kVBpgykJS
JAW4UAvDhoGifjFDGF19diIOVnu9MZjbC/JbVI1vb9NGceghakESCIn1UPOX
0cFk2VwFNfVOCKBsZKMmY5Zy+SEtlyboPJCh0R+ki8tClkba5mXBzRWt3urd
urhwbKSCZcttosTx004P3Tv6r76vLCch3Fry9TD4bHlJRmItmWS3cxHzTg/d
fCKexByoJ23e6mkr9MTovDa2qPDVc1J6+N4/WuvEGCVjkuH2XxP5wO3LWYzb
OTtybSb7OFqeEKOdpZtZ2uhvfhEixoqX8VRyVG+OfvW/nhNj2F7zIlPqJ64c
sMlitOhMdT1J/YSyf4/MTTHWauvGJZUwpNpol6jtjhhtOoThec0MSeFs94EY
iwO1LB/0MMSvf+G+iodifLahRn4Dy5DDnFGX03lzdY/mUT/47Ouae7BKjOH+
arsbqJ9w8vGrF4/4yf80LiqE
       "]]},
     AspectRatio->0.412022659,
     Axes->Automatic], {0, 0}, {Left, Bottom}, {1.5, 0.61803}], {
    {EdgeForm[{RGBColor[1., 0.501960784313725, 0.], Thickness[0.001], 
     Dashing[{}]}], FaceForm[None], RectangleBox[{0, 0}, {1.5, 0.61803}]}, 
    {EdgeForm[None], FaceForm[None], RectangleBox[{0, 0}, {1.55, 0.61803}]}, 
    {RGBColor[1., 0.501960784313725, 0.], 
     RectangleBox[{0, 0}, {0.012, 0.012}], 
     RectangleBox[{1.488, 0.60603}, {1.5, 0.61803}], 
     RectangleBox[{0, 0.60603}, {0.012, 0.61803}], 
     RectangleBox[{1.488, 0}, {1.5, 0.012}], 
     RectangleBox[{0, 0.30302}, {0.012, 0.31502}], 
     RectangleBox[{0.744, 0.60603}, {0.756, 0.61803}], 
     RectangleBox[{1.488, 0.30302}, {1.5, 0.31502}], 
     RectangleBox[{0.744, 0}, {0.756, 0.012}]}}, 
   RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 
    1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 
    1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {1, 1}, {0, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {0, 1}, {1, 1}, {0, 
    0}, {0, 0}}, {{0, 0}, {1, 1}, {0, 1}, {0, 1}, {0, 1}, {1, 1}, {1, 1}, {1, 
    1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 
    1}, {0, 1}, {0, 1}, {1, 1}, {0, 0}}, {{1, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 
    1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 
    1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {1, 1}}, {{0, 0}, {1, 
    1}, {0, 1}, {0, 1}, {0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
    1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 1}, {0, 1}, {1, 
    1}, {0, 0}}, {{0, 0}, {0, 0}, {1, 1}, {0, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 
    1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 
    1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}}, {
    Offset[{0.5, -21.5}, {1.4545, 0.34891}], 
     Offset[{21.5, -0.5}, {1.4545, 0.34891}]}]},
  AspectRatio->0.446431303346847,
  ImageSize->{319., 141.661758422852}]], "Input",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellID->78698362]
}, Open  ]],

Cell[CellGroupData[{

Cell["Cropping", "Section",
 CellID->657801144],

Cell["\<\
The following sequence shows how to crop a portion of a plot.\
\>", "Text",
 CellID->284936891],

Cell["Using the Selection tool, click a graphic to select it. ", "MathCaption",
 CellID->270395888],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"ChebyshevU", "[", 
    RowBox[{"6", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellID->356551752],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    GraphicsBox[LineBox[CompressedData["
1:eJw1lnk41OsbxoWs5ZyQsaVNi60MlVaPiFCRTiTppLJ1SkVKVFqOQeGkEicl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      "]],
     AspectRatio->0.618033988749895,
     Axes->Automatic], {0, 0}, {Left, Bottom}, {1, 0.61803}], {
    {EdgeForm[None], FaceForm[None], RectangleBox[{0, 0}, {1.1, 0.61803}]}, 
    {Dashing[{}], EdgeForm[{RGBColor[1., 0.501960784313725, 0.], Thickness[
     0.001], Dashing[{}]}], FaceForm[None], 
     RectangleBox[{0, 0}, {1, GoldenRatio^(-1)}]}, 
    {RGBColor[1., 0.501960784313725, 0.], 
     RectangleBox[{0, 0}, {0.015, 0.015}], 
     RectangleBox[{0.99, 0.60803}, {1, GoldenRatio^(-1)}], 
     RectangleBox[{0, 0.60803}, {0.01, GoldenRatio^(-1)}], 
     RectangleBox[{0.99, 0}, {1, 0.01}], 
     RectangleBox[{0, 0.30402}, {0.01, 0.31402}], 
     RectangleBox[{0.495, 0.60803}, {0.505, GoldenRatio^(-1)}], 
     RectangleBox[{0.99, 0.30402}, {1, 0.31402}], 
     RectangleBox[{0.495, 0}, {0.505, 0.01}]}}, 
   RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 
    1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 1}, {1, 
    1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 
    1}, {0, 1}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
    1}, {1, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 
    1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
    1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
    1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 
    1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 
    1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 
    1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}}, {
    Offset[{0.5, -21.5}, {0.8323, 0.4741}], 
     Offset[{21.5, -0.5}, {0.8323, 0.4741}]}]}]], "Input",
 CellID->234562728],

Cell[TextData[{
 StyleBox["Control", "KeyEvent"],
 "-drag a handle to crop the plot."
}], "MathCaption",
 CellID->936148805],

Cell[BoxData[
 GraphicsBox[{
   {Dashing[{}], EdgeForm[None], InsetBox[
     GraphicsBox[LineBox[CompressedData["
1:eJw1lnk41OsbxoWs5ZyQsaVNi60MlVaPiFCRTiTppLJ1SkVKVFqOQeGkEicl
SyR1HESypIdOipCYrDP2ZeY7xsx8KWPG0plzXb/fH+/1Xvf1PNf7Pv987vtZ
euzMPh9pKSmpJ5Lz3y1dZU3/8YOPTilP42Z+6FjZDMnMve/DxwLV8u0qoG61
MV/bKOgNDw17KSfaApWsxrfQEtoVeShnrtyrpjsDcqdCiw76jWKJHuaorGJD
Zdan7UovuXjs/A+/vXH/4N8vchoVXbn4D7HmeGFsLz6Li7+sIRhB3WH/kydm
OagjtXVh1t0RjC7UcX7kTaKLZ42p19YRFNXMdhVYf8MH1JwcguDgPnV+sYXf
BG6k+F/QrOAgEVVH1T8gRMVNsbrhdznoJBNAjaRMYqSBfu2C3zhofdFB92Te
JK5PObVobBsHZ3a6CGrWifA+TXZ5y0IO/pJh4PjzXRHq7GkPTRIQ6NVqODDR
JEIKx7KQ3kGg28cFUoU8EU4GZDw++p7AtESPwTZpMXrUzVuxpIDAt35Xew/9
JMbk2NaPux4RWOlgZKxHEWNF9d5dQXcIXKs6aN6iKcbiP7fH36QRePXx0yCO
RH+V07PRDiXw5TJrYzlJv/XllsPhAQTmdeonXFAT46smQ5NidwInHlqOtSuI
Edf1DJ62JrB9zo2Gu0IRDq5wb/A2IXCTg8EVep8I82Xskke1CHQE+ev6tSJs
IoYVukfZ2Mz2uVtyXYT+32/frUpho9tkMsuvfhKX/va1Z3w/G8dKdLJfjAvR
aPh9zkN5Nm47PHu2smsC7WmmM5klw3jOcOCaUpQArzF+WJiED+GDsoGXZ6/1
4wVZ8dr0wX4UZ5yISKpphfR7uZTumD6Uka4wCVjFghwLf5OI7l7kbXPYvjB3
BOYO8JtFl3tx+YKynqiPo6CYVbB5cEkvpllYavwdwof6jGMWq/7sQYZOZhT3
qACOOoXE7Ojtxl9L+6v2jgnA951cof6mbnS9fn7JfVcSBjifohm8LtStYq2W
u0iCvDR5dX5qFwbxQgODEknYaEO/pRTUhbI6GmtSM0mY3KZfS9h34btna9SL
8kiIzhB6aS7uQssGLceVpSS06ghT900yUSbkbKxdJQlVA1NCpzomarLoCkkf
SJifI35wq5CJ13/s3qVeS4K6e5hgazITleU4Oyl1JFwvr1fXuMFEreRDxr71
JFgk3ll9+CQTra48WKjRQEIIxddzxIqJQ05VykJJvW0Rx6FcjYnUWDfX1k8k
7HCP+TQ9zcAObmnjTA0JZusuaKkMMpBS817NS/I/Tmnzhl4zkHaxqGCzZL77
jvOPlP3BQEF03vT7EhIUHJKd3lEZGL1HM4GRToLNb/vnbf7ciYzY4AyDayT4
hhso0ymdKKe2vynCkIQOkU6zw5kOpJ87nj1eKYCGzoPJymNt2O1Ka1o2wYOo
Gm1nMr0VXx3mhtjJcGHFjZqL7ttaUEpoeSRrBxsy/Kvf5a3+gkdHWZ6ZB+rh
2+Uwb8er1TjxOe3gkmfteFD+gYU9rRLtDpe8tmEPIPOVdH6uXzm2ZJw9bhLN
wnOm/ZZzjYox6atCsOcxDsY+sVs2dywf9/nmU7XyuPjX60vtBrf+wnsC/aFT
T0ZxxZzO43r4FGMNTNPCw3novLo8oPiPJ6hr/baW1s/D944eTcLHafirc/JQ
NJWPhrcUN/a/eYgCtS8FlLN8lOPdkRfm38fiNM8tRDYfAzf7u8XbxONKw6yx
wM981DJiHao6Folh3uqjEWw+/tygyzGuvYZe427368b46L3dy2euRwiqfwvf
+UjExxRzqdxVRYHYV9/66ZdpPkpm/NVA1w8X7mgOPjPLR6vgO1zDUgoubwpN
/M9XF4xGf5Vf7g2mBioDjZJ6hUvFrtqscyDsnjMnbIqPSdXBa6YNwmE568Cg
23c+rp5pcvBMjQDrTFU7VS4fAyLt4x9/i4OV70NzhC18TDgY07BSIwFoH/tc
g4r4OOu04ozL8wfQJphvVhkheb/h0sNd6amgQ8u7Km3LR+uo+3kXTLNgf9IV
qTUFPGx2qzCStX0BVh+UBm62jeIcxXPUjuv5oGRRUUTv4GLQW4/vDv2vwIy1
zlw1koMKMdkvnuythAXWCZsTTAcxxT1HZci2Gp4/k+X2eHfgi9+fXdJhNELf
k9kwOr8GEo/stZOWbQHTwjcO1iksoFv+5Oic1gZRWz98NtjDg9VixuJqr3bw
jygNXlzHB554xCid0gE+azWpJ68J4Berlprcug6wD/o7cnBGAJw4l5z2051Q
Haty3PgACZH95dy4yk7w3MPT/Bwm4TUr9tiQJgMYikEb9iVLNHfBG6dTDIgJ
GJ5nU0DCyqiiMelSBugNtJ30l/CT7OvrvHGAAd1l9Sw7CV89OzznPFRigq+l
OGO1hMfXwo/9TeuZ4JHjN50u4fWM+ZxsZScmuFz2uGkm4ZlQK/Ff7M2EPj96
L1Wije3VbRPjmXAhhnEqT+IHmQHN1KIcJnS5rrwhkPhFee7CVbxKJrzlJabj
RxLO36yqiB1hQsAiv86d70hQnElX+qzZBXs5jyJOlJFwr0//Bu14F5zOl6l7
84wEQ/P1z+SKusDRLI+uc5sEz9la3VzbbthtpkJf60xC6TX9n/rHusG2y2b3
0SEBhPk0MB/d6QF6CI1T4CeAvx5pnE0N7IVjU/LCZikerG0WWT5U6YOxjA1b
fGgcWKeq390Y1A8KfUG7s516QP/GkjiG6hBErkgfr6voxOkPUebPTwyD0EJW
R3RzFFMumi5aqseCpm7Gu/AXYxgUdsRAs4sF0/Ng6JDZBJobaS7zWMuG8rQD
Hk5BQpy4Z2SRG8UGKXWtjym3J/E8y1HTtYwNJk1qi1zVRZg6K63/J5sN1LQN
TR9CRBj6UjGwY5YN3GzZ2repIkwz0ZvRpBBQuahkoVm1CMVS6S9bTQgI1Xs1
4tYvQtrBu5RNNgQ0yA1VOkyKMIGZqG/kTsDyqfrIq5L8NDBr6a85TQCjFJ6T
knxVbj6n5PY7Aem3nY3KJHkcfFIR1ycSoD7loWEn0VSbkPUlzwmQUn2c5aUq
xnvZ53mmVQT0rCFn7eaK0ch+v19kPQHtxl+0RVMiTGq/tCK7nYCJO68Pi/gi
3CC/1SGCR4CC1y5t1lcRpsyPVN2ixYHmRvX1BjEiTGa4yKZu5wA1RXx11FCE
9OJHp7fHcUDAMaN3Gk/iE39H7XgmB+I9djk1v5zADr+KCNJ8BMp+TmoMuP4N
V5r41lFvj4D34Nue3TQS/1hF0osGR+ALtaHdSJGLbz77jF++woVXSs1RCufb
UIXfcmhg6Shs3fR0/dGJNliVnaqQ0jgKGVvibQOjJ4D0HjTdE8cD+0nzS7by
8lZRsU3K3cN88HaP+j6ZqW31v/0Q/r8f/guPIZXr
       "]],
      AspectRatio->0.618033988749895,
      Axes->Automatic], {-0.027448, 0.14354}, {
     Left, Bottom}, {1, 0.61803}]}, {
    {EdgeForm[None], FaceForm[None], RectangleBox[{0, 0}, {1.1, 0.61803}]}, 
    {EdgeForm[{RGBColor[1., 0.501960784313725, 0.], Thickness[0.001]}], 
     FaceForm[None], 
     RectangleBox[{-0.027448, 0.14354}, {0.84792, 0.78136}]}, 
    {RGBColor[1., 0.501960784313725, 0.], 
     RectangleBox[{-0.027448, 0.14354}, {-0.011967, 0.15902}], 
     RectangleBox[{0.8376, 0.76991}, {0.84792, 0.78023}], 
     RectangleBox[{-0.027448, 0.77104}, {-0.017128, 0.78136}], 
     RectangleBox[{0.83743, 0.14241}, {0.84775, 0.15273}], 
     RectangleBox[{-0.027448, 0.4573}, {-0.017128, 0.46762}], 
     RectangleBox[{0.38681, 0.77104}, {0.39713, 0.78136}], 
     RectangleBox[{0.8372, 0.4609}, {0.84613, 0.47196}], 
     RectangleBox[{0.38567, 0.14468}, {0.396, 0.155}]}}, 
   {Opacity[0.1], EdgeForm[None], FaceForm[{GrayLevel[1], Opacity[0.9]}], 
    RectangleBox[{0.84892, 0.78368}, {0.99538, 0.15364}]}, 
   RectangleBox[{0.23916, 0.78732}, {0.23916, 0.77742}], 
   RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 
    1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 
    1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {1, 1}, {0, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {0, 1}, {1, 1}, {0, 
    0}, {0, 0}}, {{0, 0}, {1, 1}, {0, 1}, {0, 1}, {0, 1}, {1, 1}, {1, 1}, {1, 
    1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 
    1}, {0, 1}, {0, 1}, {1, 1}, {0, 0}}, {{1, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 
    1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 
    1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {1, 1}}, {{0, 0}, {1, 
    1}, {0, 1}, {0, 1}, {0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
    1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 1}, {0, 1}, {1, 
    1}, {0, 0}}, {{0, 0}, {0, 0}, {1, 1}, {0, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 
    1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 
    1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}}, {
    Offset[{0.51601, -22.188}, {0.80299, 0.50362}], 
     Offset[{22.188, -0.51601}, {0.80299, 0.50362}]}]},
  AspectRatio->0.7385585090289408,
  ImageMargins->0.,
  ImageSize->{236., 176.}]], "Input",
 CellID->945200439]
}, Open  ]],

Cell[CellGroupData[{

Cell["Setting Margins", "Section",
 CellID->27684169],

Cell["\<\
The following sequence shows how to set margins of a graphic.\
\>", "Text",
 CellID->14529299],

Cell["Click to select the graphic. ", "MathCaption",
 CellID->3416789],

Cell[BoxData[
 GraphicsBox[{
   {Dashing[{}], EdgeForm[None], InsetBox[
     GraphicsBox[
      LineBox[{{-6.2832, 1}, {-6.2677, 0.99988}, {-6.2536, 0.99956}, {-6.2373,
         0.99895}, {-6.2219, 0.99812}, {-6.1945, 0.99607}, {-6.1647, 
        0.99299}, {-6.132, 0.98859}, {-6.0973, 0.98277}, {-6.035, 
        0.96937}, {-5.9105, 0.93136}, {-5.7734, 0.87285}, {-5.4864, 
        0.69898}, {-5.2174, 
        0.48386}, {-4.7059, -0.0065251}, {-4.1619, -0.52309}, {-3.8902, \
-0.73262}, {-3.7579, -0.816}, {-3.638, -0.87931}, {-3.5124, -0.93204}, \
{-3.3941, -0.9683}, {-3.329, -0.98249}, {-3.2692, -0.99188}, {-3.2378, \
-0.99537}, {-3.2198, -0.99694}, {-3.2034, -0.99809}, {-3.1861, -0.99901}, \
{-3.1766, -0.99939}, {-3.1675, -0.99966}, {-3.1515, -0.99995}, {-3.1424, -1}, \
{-3.134, -0.99997}, {-3.1185, -0.99973}, {-3.1021, -0.99922}, {-3.0882, \
-0.99857}, {-3.0729, -0.99764}, {-3.0388, -0.99472}, {-3.007, -0.99096}, \
{-2.9494, -0.98158}, {-2.8878, -0.96796}, {-2.8145, -0.94698}, {-2.7453, \
-0.92251}, {-2.6159, -0.86499}, {-2.3519, -0.70403}, {-2.1084, -0.51206}, \
{-1.5885, -0.017669}, {-1.0886, 0.46377}, {-0.81042, 0.68919}, {-0.55628, 
        0.84922}, {-0.43055, 0.90874}, {-0.36417, 0.93442}, {-0.29349, 
        0.95724}, {-0.22555, 0.97467}, {-0.16404, 0.98658}, {-0.13431, 
        0.99099}, {-0.10219, 0.99478}, {-0.08744, 0.99618}, {-0.071873, 
        0.99742}, {-0.057392, 0.99835}, {-0.044012, 0.99903}, {-0.027848, 
        0.99961}, {-0.019327, 0.99981}, {-0.010287, 0.99995}, {0.0048892, 
        0.99999}, {0.021619, 0.99977}, {0.036472, 0.99933}, {0.052463, 
        0.99862}, {0.067558, 0.99772}, {0.081381, 0.99669}, {0.11266, 
        0.99366}, {0.14682, 0.98924}, {0.21563, 0.97684}, {0.27634, 
        0.96206}, {0.34111, 0.94238}, {0.4577, 0.89707}, {0.5932, 0.82916}, {
        0.73989, 0.73854}, {1.0059, 0.53529}, {1.5465, 0.024254}, {
        2.0671, -0.47621}, {2.3289, -0.68754}, {2.5677, -0.83982}, {
        2.6997, -0.90395}, {2.8249, -0.95026}, {2.8934, -0.96936}, {
        2.9569, -0.983}, {2.99, -0.98854}, {3.0266, -0.9934}, {
        3.045, -0.99534}, {3.0648, -0.99705}, {3.0835, -0.99831}, {
        3.1007, -0.99916}, {3.1175, -0.99971}, {3.1334, -0.99997}, {
        3.1476, -0.99998}, {3.1631, -0.99977}, {3.18, -0.99926}, {
        3.1885, -0.9989}, {3.1978, -0.99842}, {3.2145, -0.99734}, {
        3.2298, -0.99611}, {3.2598, -0.99303}, {3.2919, -0.98872}, {
        3.3501, -0.97834}, {3.417, -0.9623}, {3.4901, -0.93989}, {
        3.6231, -0.8863}, {3.8829, -0.7376}, {4.1597, -0.525}, {
        4.7086, -0.0037925}, {5.2375, 0.50133}, {5.4802, 0.69457}, {5.6179, 
        0.78676}, {5.7465, 0.85938}, {5.8725, 0.91684}, {5.9372, 0.94073}, {
        6.0075, 0.96224}, {6.046, 0.972}, {6.0816, 0.97975}, {6.115, 
        0.98588}, {6.1517, 0.99137}, {6.1846, 0.99515}, {6.2155, 0.99771}, {
        6.2325, 0.99872}, {6.2481, 0.99938}, {6.2652, 0.99984}, {6.2738, 
        0.99996}, {6.2832, 1}}],
      AspectRatio->0.618033988749895,
      Axes->Automatic], {0, 0}, {Left, Bottom}, {1, 0.61803}]}, {
    {Dashing[{}], EdgeForm[{RGBColor[1., 0.501960784313725, 0.], Thickness[
     0.001], Dashing[{}]}], FaceForm[None], 
     RectangleBox[{0, 0}, {1, 0.61803}]}, 
    {RGBColor[1., 0.501960784313725, 0.], 
     RectangleBox[{0, 0}, {0.012, 0.012}], 
     RectangleBox[{0.988, 0.60603}, {1, 0.61803}], 
     RectangleBox[{0, 0.60603}, {0.012, 0.61803}], 
     RectangleBox[{0.988, 0}, {1, 0.012}], 
     RectangleBox[{0, 0.30302}, {0.012, 0.31502}], 
     RectangleBox[{0.494, 0.60603}, {0.506, 0.61803}], 
     RectangleBox[{0.988, 0.30302}, {1, 0.31502}], 
     RectangleBox[{0.494, 0}, {0.506, 0.012}]}}, 
   RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 
    1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 1}, {1, 
    1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 
    1}, {0, 1}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
    1}, {1, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 
    1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
    1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
    1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 
    1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 
    1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 
    1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}}, {
    Offset[{0.5, -21.5}, {1.0036, 0.47835}], 
     Offset[{21.5, -0.5}, {1.0036, 0.47835}]}]},
  AspectRatio->0.65069090687668,
  ImageSize->{377., 245.310501098633}]], "Input",
 CellID->11614527],

Cell["Drag the frame (not a handle) to push out the margins.", "MathCaption",
 CellID->913627436],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    GraphicsBox[
     LineBox[{{-6.2832, 1}, {-6.2677, 0.99988}, {-6.2536, 0.99956}, {-6.2373, 
       0.99895}, {-6.2219, 0.99812}, {-6.1945, 0.99607}, {-6.1647, 
       0.99299}, {-6.132, 0.98859}, {-6.0973, 0.98277}, {-6.035, 
       0.96937}, {-5.9105, 0.93136}, {-5.7734, 0.87285}, {-5.4864, 
       0.69898}, {-5.2174, 
       0.48386}, {-4.7059, -0.0065251}, {-4.1619, -0.52309}, {-3.8902, \
-0.73262}, {-3.7579, -0.816}, {-3.638, -0.87931}, {-3.5124, -0.93204}, \
{-3.3941, -0.9683}, {-3.329, -0.98249}, {-3.2692, -0.99188}, {-3.2378, \
-0.99537}, {-3.2198, -0.99694}, {-3.2034, -0.99809}, {-3.1861, -0.99901}, \
{-3.1766, -0.99939}, {-3.1675, -0.99966}, {-3.1515, -0.99995}, {-3.1424, -1}, \
{-3.134, -0.99997}, {-3.1185, -0.99973}, {-3.1021, -0.99922}, {-3.0882, \
-0.99857}, {-3.0729, -0.99764}, {-3.0388, -0.99472}, {-3.007, -0.99096}, \
{-2.9494, -0.98158}, {-2.8878, -0.96796}, {-2.8145, -0.94698}, {-2.7453, \
-0.92251}, {-2.6159, -0.86499}, {-2.3519, -0.70403}, {-2.1084, -0.51206}, \
{-1.5885, -0.017669}, {-1.0886, 0.46377}, {-0.81042, 0.68919}, {-0.55628, 
       0.84922}, {-0.43055, 0.90874}, {-0.36417, 0.93442}, {-0.29349, 
       0.95724}, {-0.22555, 0.97467}, {-0.16404, 0.98658}, {-0.13431, 
       0.99099}, {-0.10219, 0.99478}, {-0.08744, 0.99618}, {-0.071873, 
       0.99742}, {-0.057392, 0.99835}, {-0.044012, 0.99903}, {-0.027848, 
       0.99961}, {-0.019327, 0.99981}, {-0.010287, 0.99995}, {0.0048892, 
       0.99999}, {0.021619, 0.99977}, {0.036472, 0.99933}, {0.052463, 
       0.99862}, {0.067558, 0.99772}, {0.081381, 0.99669}, {0.11266, 
       0.99366}, {0.14682, 0.98924}, {0.21563, 0.97684}, {0.27634, 0.96206}, {
       0.34111, 0.94238}, {0.4577, 0.89707}, {0.5932, 0.82916}, {0.73989, 
       0.73854}, {1.0059, 0.53529}, {1.5465, 0.024254}, {2.0671, -0.47621}, {
       2.3289, -0.68754}, {2.5677, -0.83982}, {2.6997, -0.90395}, {
       2.8249, -0.95026}, {2.8934, -0.96936}, {2.9569, -0.983}, {
       2.99, -0.98854}, {3.0266, -0.9934}, {3.045, -0.99534}, {
       3.0648, -0.99705}, {3.0835, -0.99831}, {3.1007, -0.99916}, {
       3.1175, -0.99971}, {3.1334, -0.99997}, {3.1476, -0.99998}, {
       3.1631, -0.99977}, {3.18, -0.99926}, {3.1885, -0.9989}, {
       3.1978, -0.99842}, {3.2145, -0.99734}, {3.2298, -0.99611}, {
       3.2598, -0.99303}, {3.2919, -0.98872}, {3.3501, -0.97834}, {
       3.417, -0.9623}, {3.4901, -0.93989}, {3.6231, -0.8863}, {
       3.8829, -0.7376}, {4.1597, -0.525}, {4.7086, -0.0037925}, {5.2375, 
       0.50133}, {5.4802, 0.69457}, {5.6179, 0.78676}, {5.7465, 0.85938}, {
       5.8725, 0.91684}, {5.9372, 0.94073}, {6.0075, 0.96224}, {6.046, 
       0.972}, {6.0816, 0.97975}, {6.115, 0.98588}, {6.1517, 0.99137}, {
       6.1846, 0.99515}, {6.2155, 0.99771}, {6.2325, 0.99872}, {6.2481, 
       0.99938}, {6.2652, 0.99984}, {6.2738, 0.99996}, {6.2832, 1}}],
     AspectRatio->0.618033988749895,
     Axes->Automatic], {0.042983, -0.5053}, {Left, Bottom}, {1, 0.61803}], 
   {EdgeForm[{RGBColor[1., 0.501960784313725, 0.], Thickness[0.001]}], 
    FaceForm[None], RectangleBox[{-0.17641, -0.53316}, {1.0662, 0.58759}]}, 
   {RGBColor[1., 0.501960784313725, 0.], 
    RectangleBox[{-0.17641, -0.53316}, {-0.16398, -0.52073}], 
    RectangleBox[{1.0538, 0.57516}, {1.0662, 0.58759}], 
    RectangleBox[{-0.17641, 0.57516}, {-0.16398, 0.58759}], 
    RectangleBox[{1.0538, -0.53316}, {1.0662, -0.52073}], 
    RectangleBox[{-0.17641, 0.021002}, {-0.16398, 0.033428}], 
    RectangleBox[{0.43868, 0.57516}, {0.45111, 0.58759}], 
    RectangleBox[{1.0538, 0.021002}, {1.0662, 0.033428}], 
    RectangleBox[{0.43868, -0.53316}, {0.45111, -0.52073}]}, 
   {EdgeForm[{RGBColor[1., 0.501960784313725, 0.], Thickness[0.001]}], 
    FaceForm[None], RectangleBox[{0.042872, -0.50545}, {1.0429, 0.11259}]}, 
   {RGBColor[1., 0.501960784313725, 0.], 
    RectangleBox[{0.042872, -0.50545}, {0.052872, -0.49545}], 
    RectangleBox[{1.0329, 0.10259}, {1.0429, 0.11259}], 
    RectangleBox[{0.042872, 0.10259}, {0.052872, 0.11259}], 
    RectangleBox[{1.0329, -0.50545}, {1.0429, -0.49545}], 
    RectangleBox[{0.042872, -0.20143}, {0.052872, -0.19143}], 
    RectangleBox[{0.53787, 0.10259}, {0.54788, 0.11259}], 
    RectangleBox[{1.0329, -0.20143}, {1.0429, -0.19143}], 
    RectangleBox[{0.53787, -0.50545}, {0.54788, -0.49545}]}, InsetBox[
    GraphicsBox[RasterBox[CompressedData["
1:eJzt1ksKhEAMRdGIG2m35BJcgL3/UYsgqINAVUeTlN6CAw78FO9JdJi+49yL
yGezHksHAAAAAHn9ZBe9l7c4ZX5YdOGfubbowj9zbdGF3THDkvlD5v9lW32+
kv8dz30SS4ZR17auZJ5rM8Qyf0qu1e4TnZlH5pnX27rg/ffB/M+D/5/8LPMn
eu+tuurbTRd2tV2QuX8XZB7cRYL9AAAAAK1YAJegy9o=
      "], {{0, 0}, {32, 32}}, {0, 255},
      ColorFunction->RGBColor],
     DisplayFunction->Identity,
     ImageSize->{17., 21.},
     PlotRange->{{0, 32}, {0, 32}},
     PlotRegion->{{-0.4117647058823535, 
      1.4705882352941175`}, {-0.2857142857142861, 1.2380952380952381`}}], {1.0870030786793898`, -0.06624117767250935},
     Center, {0.05376457743915505, 0.063858105148887}, {{
    0.8571428571428571, -1.1102230246251565`*^-16}, {0., 
    0.9999999999999999}}]},
  AspectRatio->0.88895726366108,
  ImageMargins->{{2., 77.}, {23., 3.}},
  ImageSize->{477., 401.},
  PlotRegion->{{-0.0168030112981796, 0.903316140174866}, {-0.332459837198257, 
   1.33964574337006}}]], "Input",
 CellID->70800071],

Cell["To change a margin directly, drag a margin frame handle. ", \
"MathCaption",
 CellID->89045412],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    GraphicsBox[
     LineBox[{{-6.2832, 1}, {-6.2677, 0.99988}, {-6.2536, 0.99956}, {-6.2373, 
       0.99895}, {-6.2219, 0.99812}, {-6.1945, 0.99607}, {-6.1647, 
       0.99299}, {-6.132, 0.98859}, {-6.0973, 0.98277}, {-6.035, 
       0.96937}, {-5.9105, 0.93136}, {-5.7734, 0.87285}, {-5.4864, 
       0.69898}, {-5.2174, 
       0.48386}, {-4.7059, -0.0065251}, {-4.1619, -0.52309}, {-3.8902, \
-0.73262}, {-3.7579, -0.816}, {-3.638, -0.87931}, {-3.5124, -0.93204}, \
{-3.3941, -0.9683}, {-3.329, -0.98249}, {-3.2692, -0.99188}, {-3.2378, \
-0.99537}, {-3.2198, -0.99694}, {-3.2034, -0.99809}, {-3.1861, -0.99901}, \
{-3.1766, -0.99939}, {-3.1675, -0.99966}, {-3.1515, -0.99995}, {-3.1424, -1}, \
{-3.134, -0.99997}, {-3.1185, -0.99973}, {-3.1021, -0.99922}, {-3.0882, \
-0.99857}, {-3.0729, -0.99764}, {-3.0388, -0.99472}, {-3.007, -0.99096}, \
{-2.9494, -0.98158}, {-2.8878, -0.96796}, {-2.8145, -0.94698}, {-2.7453, \
-0.92251}, {-2.6159, -0.86499}, {-2.3519, -0.70403}, {-2.1084, -0.51206}, \
{-1.5885, -0.017669}, {-1.0886, 0.46377}, {-0.81042, 0.68919}, {-0.55628, 
       0.84922}, {-0.43055, 0.90874}, {-0.36417, 0.93442}, {-0.29349, 
       0.95724}, {-0.22555, 0.97467}, {-0.16404, 0.98658}, {-0.13431, 
       0.99099}, {-0.10219, 0.99478}, {-0.08744, 0.99618}, {-0.071873, 
       0.99742}, {-0.057392, 0.99835}, {-0.044012, 0.99903}, {-0.027848, 
       0.99961}, {-0.019327, 0.99981}, {-0.010287, 0.99995}, {0.0048892, 
       0.99999}, {0.021619, 0.99977}, {0.036472, 0.99933}, {0.052463, 
       0.99862}, {0.067558, 0.99772}, {0.081381, 0.99669}, {0.11266, 
       0.99366}, {0.14682, 0.98924}, {0.21563, 0.97684}, {0.27634, 0.96206}, {
       0.34111, 0.94238}, {0.4577, 0.89707}, {0.5932, 0.82916}, {0.73989, 
       0.73854}, {1.0059, 0.53529}, {1.5465, 0.024254}, {2.0671, -0.47621}, {
       2.3289, -0.68754}, {2.5677, -0.83982}, {2.6997, -0.90395}, {
       2.8249, -0.95026}, {2.8934, -0.96936}, {2.9569, -0.983}, {
       2.99, -0.98854}, {3.0266, -0.9934}, {3.045, -0.99534}, {
       3.0648, -0.99705}, {3.0835, -0.99831}, {3.1007, -0.99916}, {
       3.1175, -0.99971}, {3.1334, -0.99997}, {3.1476, -0.99998}, {
       3.1631, -0.99977}, {3.18, -0.99926}, {3.1885, -0.9989}, {
       3.1978, -0.99842}, {3.2145, -0.99734}, {3.2298, -0.99611}, {
       3.2598, -0.99303}, {3.2919, -0.98872}, {3.3501, -0.97834}, {
       3.417, -0.9623}, {3.4901, -0.93989}, {3.6231, -0.8863}, {
       3.8829, -0.7376}, {4.1597, -0.525}, {4.7086, -0.0037925}, {5.2375, 
       0.50133}, {5.4802, 0.69457}, {5.6179, 0.78676}, {5.7465, 0.85938}, {
       5.8725, 0.91684}, {5.9372, 0.94073}, {6.0075, 0.96224}, {6.046, 
       0.972}, {6.0816, 0.97975}, {6.115, 0.98588}, {6.1517, 0.99137}, {
       6.1846, 0.99515}, {6.2155, 0.99771}, {6.2325, 0.99872}, {6.2481, 
       0.99938}, {6.2652, 0.99984}, {6.2738, 0.99996}, {6.2832, 1}}],
     AspectRatio->0.618033988749895,
     Axes->Automatic], {0.042983, -0.5053}, {Left, Bottom}, {1, 0.61803}], 
   {EdgeForm[{RGBColor[1., 0.501960784313725, 0.], Thickness[0.001]}], 
    FaceForm[None], RectangleBox[{-0.17641, -0.53316}, {1.2, 0.58759}]}, 
   {RGBColor[1., 0.501960784313725, 0.], 
    RectangleBox[{-0.17641, -0.53316}, {-0.16265, -0.5194}], 
    RectangleBox[{1.1862, 0.57383}, {1.2, 0.58759}], 
    RectangleBox[{-0.17641, 0.57383}, {-0.16265, 0.58759}], 
    RectangleBox[{1.1862, -0.53316}, {1.2, -0.5194}], 
    RectangleBox[{-0.17641, 0.020333}, {-0.16265, 0.034097}], 
    RectangleBox[{0.50491, 0.57383}, {0.51868, 0.58759}], 
    RectangleBox[{1.1862, 0.020333}, {1.2, 0.034097}], 
    RectangleBox[{0.50491, -0.53316}, {0.51868, -0.5194}]}, 
   {EdgeForm[{GrayLevel[0.6666666], Thickness[0.001], 
    Dashing[{0.005, 0.01}]}], FaceForm[None], 
    RectangleBox[{-0.17641, -0.53316}, {1.0662, 0.58759}]}, 
   {EdgeForm[{RGBColor[1., 0.501960784313725, 0.], Thickness[0.001]}], 
    FaceForm[None], RectangleBox[{0.042872, -0.50545}, {1.0429, 0.11259}]}, 
   {RGBColor[1., 0.501960784313725, 0.], 
    RectangleBox[{0.042872, -0.50545}, {0.052872, -0.49545}], 
    RectangleBox[{1.0329, 0.10259}, {1.0429, 0.11259}], 
    RectangleBox[{0.042872, 0.10259}, {0.052872, 0.11259}], 
    RectangleBox[{1.0329, -0.50545}, {1.0429, -0.49545}], 
    RectangleBox[{0.042872, -0.20143}, {0.052872, -0.19143}], 
    RectangleBox[{0.53787, 0.10259}, {0.54788, 0.11259}], 
    RectangleBox[{1.0329, -0.20143}, {1.0429, -0.19143}], 
    RectangleBox[{0.53787, -0.50545}, {0.54788, -0.49545}]}, 
   RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 
    1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 
    1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {1, 1}, {0, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {0, 1}, {1, 1}, {0, 
    0}, {0, 0}}, {{0, 0}, {1, 1}, {0, 1}, {0, 1}, {0, 1}, {1, 1}, {1, 1}, {1, 
    1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 
    1}, {0, 1}, {0, 1}, {1, 1}, {0, 0}}, {{1, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 
    1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 
    1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {1, 1}}, {{0, 0}, {1, 
    1}, {0, 1}, {0, 1}, {0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
    1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 1}, {0, 1}, {1, 
    1}, {0, 0}}, {{0, 0}, {0, 0}, {1, 1}, {0, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 
    1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 
    1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}}, {
    Offset[{0.5, -21.5}, {1.1697, 0.056446}], 
     Offset[{21.5, -0.5}, {1.1697, 0.056446}]}]},
  AspectRatio->0.88895726366108,
  ImageMargins->{{2., 15.}, {23., 3.}},
  ImageSize->{577., 444.},
  PlotRegion->{{-0.0155330151319504, 0.835042297840118}, {-0.383477449417114, 
   1.35265040397644}}]], "Input",
 CellID->400698899],

Cell[TextData[{
 "To keep the margins equal, ",
 StyleBox["Shift-", "KeyEvent"],
 "drag the frame. "
}], "MathCaption",
 CellID->56669149],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    GraphicsBox[
     LineBox[{{-6.2832, 1}, {-6.2677, 0.99988}, {-6.2536, 0.99956}, {-6.2373, 
       0.99895}, {-6.2219, 0.99812}, {-6.1945, 0.99607}, {-6.1647, 
       0.99299}, {-6.132, 0.98859}, {-6.0973, 0.98277}, {-6.035, 
       0.96937}, {-5.9105, 0.93136}, {-5.7734, 0.87285}, {-5.4864, 
       0.69898}, {-5.2174, 
       0.48386}, {-4.7059, -0.0065251}, {-4.1619, -0.52309}, {-3.8902, \
-0.73262}, {-3.7579, -0.816}, {-3.638, -0.87931}, {-3.5124, -0.93204}, \
{-3.3941, -0.9683}, {-3.329, -0.98249}, {-3.2692, -0.99188}, {-3.2378, \
-0.99537}, {-3.2198, -0.99694}, {-3.2034, -0.99809}, {-3.1861, -0.99901}, \
{-3.1766, -0.99939}, {-3.1675, -0.99966}, {-3.1515, -0.99995}, {-3.1424, -1}, \
{-3.134, -0.99997}, {-3.1185, -0.99973}, {-3.1021, -0.99922}, {-3.0882, \
-0.99857}, {-3.0729, -0.99764}, {-3.0388, -0.99472}, {-3.007, -0.99096}, \
{-2.9494, -0.98158}, {-2.8878, -0.96796}, {-2.8145, -0.94698}, {-2.7453, \
-0.92251}, {-2.6159, -0.86499}, {-2.3519, -0.70403}, {-2.1084, -0.51206}, \
{-1.5885, -0.017669}, {-1.0886, 0.46377}, {-0.81042, 0.68919}, {-0.55628, 
       0.84922}, {-0.43055, 0.90874}, {-0.36417, 0.93442}, {-0.29349, 
       0.95724}, {-0.22555, 0.97467}, {-0.16404, 0.98658}, {-0.13431, 
       0.99099}, {-0.10219, 0.99478}, {-0.08744, 0.99618}, {-0.071873, 
       0.99742}, {-0.057392, 0.99835}, {-0.044012, 0.99903}, {-0.027848, 
       0.99961}, {-0.019327, 0.99981}, {-0.010287, 0.99995}, {0.0048892, 
       0.99999}, {0.021619, 0.99977}, {0.036472, 0.99933}, {0.052463, 
       0.99862}, {0.067558, 0.99772}, {0.081381, 0.99669}, {0.11266, 
       0.99366}, {0.14682, 0.98924}, {0.21563, 0.97684}, {0.27634, 0.96206}, {
       0.34111, 0.94238}, {0.4577, 0.89707}, {0.5932, 0.82916}, {0.73989, 
       0.73854}, {1.0059, 0.53529}, {1.5465, 0.024254}, {2.0671, -0.47621}, {
       2.3289, -0.68754}, {2.5677, -0.83982}, {2.6997, -0.90395}, {
       2.8249, -0.95026}, {2.8934, -0.96936}, {2.9569, -0.983}, {
       2.99, -0.98854}, {3.0266, -0.9934}, {3.045, -0.99534}, {
       3.0648, -0.99705}, {3.0835, -0.99831}, {3.1007, -0.99916}, {
       3.1175, -0.99971}, {3.1334, -0.99997}, {3.1476, -0.99998}, {
       3.1631, -0.99977}, {3.18, -0.99926}, {3.1885, -0.9989}, {
       3.1978, -0.99842}, {3.2145, -0.99734}, {3.2298, -0.99611}, {
       3.2598, -0.99303}, {3.2919, -0.98872}, {3.3501, -0.97834}, {
       3.417, -0.9623}, {3.4901, -0.93989}, {3.6231, -0.8863}, {
       3.8829, -0.7376}, {4.1597, -0.525}, {4.7086, -0.0037925}, {5.2375, 
       0.50133}, {5.4802, 0.69457}, {5.6179, 0.78676}, {5.7465, 0.85938}, {
       5.8725, 0.91684}, {5.9372, 0.94073}, {6.0075, 0.96224}, {6.046, 
       0.972}, {6.0816, 0.97975}, {6.115, 0.98588}, {6.1517, 0.99137}, {
       6.1846, 0.99515}, {6.2155, 0.99771}, {6.2325, 0.99872}, {6.2481, 
       0.99938}, {6.2652, 0.99984}, {6.2738, 0.99996}, {6.2832, 1}}],
     AspectRatio->0.618033988749895,
     Axes->Automatic], {-0.0085011, -0.13298}, {
    Left, Bottom}, {1, 0.61803}], 
   {GrayLevel[1], EdgeForm[{GrayLevel[1], Thickness[0.001]}], FaceForm[None], 
    RectangleBox[{-0.16932, -0.23316}, {1.4461, 0.58759}]}, 
   {EdgeForm[{RGBColor[1., 0.501960784313725, 0.], Thickness[0.001]}], 
    FaceForm[None], RectangleBox[{-0.16932, -0.23316}, {1.1461, 0.58759}]}, 
   {RGBColor[1., 0.501960784313725, 0.], 
    RectangleBox[{-0.16932, -0.23316}, {-0.16143, -0.22527}], 
    RectangleBox[{1.1382, 0.5797}, {1.1461, 0.58759}], 
    RectangleBox[{-0.16932, 0.5797}, {-0.16143, 0.58759}], 
    RectangleBox[{1.1382, -0.23316}, {1.1461, -0.22527}], 
    RectangleBox[{-0.16932, 0.17327}, {-0.16143, 0.18116}], 
    RectangleBox[{0.48444, 0.5797}, {0.49234, 0.58759}], 
    RectangleBox[{1.1382, 0.17327}, {1.1461, 0.18116}], 
    RectangleBox[{0.48444, -0.23316}, {0.49234, -0.22527}]}, 
   {EdgeForm[{RGBColor[1., 0.501960784313725, 0.], Thickness[0.001]}], 
    FaceForm[None], 
    RectangleBox[{-0.0056211, -0.1301}, {0.99439, 0.48794}]}, 
   {RGBColor[1., 0.501960784313725, 0.], 
    RectangleBox[{-0.0056211, -0.1301}, {0.0043789, -0.1201}], 
    RectangleBox[{0.98439, 0.47794}, {0.99439, 0.48794}], 
    RectangleBox[{-0.0056211, 0.47794}, {0.0043789, 0.48794}], 
    RectangleBox[{0.98439, -0.1301}, {0.99439, -0.1201}], 
    RectangleBox[{-0.0056211, 0.17392}, {0.0043789, 0.18392}], 
    RectangleBox[{0.48938, 0.47794}, {0.49939, 0.48794}], 
    RectangleBox[{0.98439, 0.17392}, {0.99439, 0.18392}], 
    RectangleBox[{0.48938, -0.1301}, {0.49939, -0.1201}]}, InsetBox[
    GraphicsBox[RasterBox[CompressedData["
1:eJzt1ksKhEAMRdGIG2m35BJcgL3/UYsgqINAVUeTlN6CAw78FO9JdJi+49yL
yGezHksHAAAAAHn9ZBe9l7c4ZX5YdOGfubbowj9zbdGF3THDkvlD5v9lW32+
kv8dz30SS4ZR17auZJ5rM8Qyf0qu1e4TnZlH5pnX27rg/ffB/M+D/5/8LPMn
eu+tuurbTRd2tV2QuX8XZB7cRYL9AAAAAK1YAJegy9o=
      "], {{0, 0}, {32, 32}}, {0, 255},
      ColorFunction->RGBColor],
     DisplayFunction->Identity,
     ImageSize->{17., 21.},
     PlotRange->{{0, 32}, {0, 32}},
     PlotRegion->{{-0.4117647058823535, 
      1.4705882352941175`}, {-0.2857142857142861, 1.2380952380952381`}}], {1.026092473023047, 0.03227740358594633},
     Center, {0.05389537337574924, 0.05750281344172681}, {{0.9047619047619047,
     0.}, {0., 1.}}]},
  AspectRatio->0.543732981913153,
  ImageMargins->{{1., 1.}, {1., 0.}},
  ImageSize->{635., 371.},
  PlotRegion->{{-0.0170890241861343, 0.918691694736481}, {-0.293041735887527, 
   1.18081068992615}}]], "Input",
 CellID->488993760],

Cell[TextData[{
 "To get rid of the margins, ",
 StyleBox["Shift", "KeyEvent"],
 "-drag the graphics frame to the top left corner. "
}], "MathCaption",
 CellID->294869762],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    GraphicsBox[
     LineBox[{{-6.2832, 1}, {-6.2677, 0.99988}, {-6.2536, 0.99956}, {-6.2373, 
       0.99895}, {-6.2219, 0.99812}, {-6.1945, 0.99607}, {-6.1647, 
       0.99299}, {-6.132, 0.98859}, {-6.0973, 0.98277}, {-6.035, 
       0.96937}, {-5.9105, 0.93136}, {-5.7734, 0.87285}, {-5.4864, 
       0.69898}, {-5.2174, 
       0.48386}, {-4.7059, -0.0065251}, {-4.1619, -0.52309}, {-3.8902, \
-0.73262}, {-3.7579, -0.816}, {-3.638, -0.87931}, {-3.5124, -0.93204}, \
{-3.3941, -0.9683}, {-3.329, -0.98249}, {-3.2692, -0.99188}, {-3.2378, \
-0.99537}, {-3.2198, -0.99694}, {-3.2034, -0.99809}, {-3.1861, -0.99901}, \
{-3.1766, -0.99939}, {-3.1675, -0.99966}, {-3.1515, -0.99995}, {-3.1424, -1}, \
{-3.134, -0.99997}, {-3.1185, -0.99973}, {-3.1021, -0.99922}, {-3.0882, \
-0.99857}, {-3.0729, -0.99764}, {-3.0388, -0.99472}, {-3.007, -0.99096}, \
{-2.9494, -0.98158}, {-2.8878, -0.96796}, {-2.8145, -0.94698}, {-2.7453, \
-0.92251}, {-2.6159, -0.86499}, {-2.3519, -0.70403}, {-2.1084, -0.51206}, \
{-1.5885, -0.017669}, {-1.0886, 0.46377}, {-0.81042, 0.68919}, {-0.55628, 
       0.84922}, {-0.43055, 0.90874}, {-0.36417, 0.93442}, {-0.29349, 
       0.95724}, {-0.22555, 0.97467}, {-0.16404, 0.98658}, {-0.13431, 
       0.99099}, {-0.10219, 0.99478}, {-0.08744, 0.99618}, {-0.071873, 
       0.99742}, {-0.057392, 0.99835}, {-0.044012, 0.99903}, {-0.027848, 
       0.99961}, {-0.019327, 0.99981}, {-0.010287, 0.99995}, {0.0048892, 
       0.99999}, {0.021619, 0.99977}, {0.036472, 0.99933}, {0.052463, 
       0.99862}, {0.067558, 0.99772}, {0.081381, 0.99669}, {0.11266, 
       0.99366}, {0.14682, 0.98924}, {0.21563, 0.97684}, {0.27634, 0.96206}, {
       0.34111, 0.94238}, {0.4577, 0.89707}, {0.5932, 0.82916}, {0.73989, 
       0.73854}, {1.0059, 0.53529}, {1.5465, 0.024254}, {2.0671, -0.47621}, {
       2.3289, -0.68754}, {2.5677, -0.83982}, {2.6997, -0.90395}, {
       2.8249, -0.95026}, {2.8934, -0.96936}, {2.9569, -0.983}, {
       2.99, -0.98854}, {3.0266, -0.9934}, {3.045, -0.99534}, {
       3.0648, -0.99705}, {3.0835, -0.99831}, {3.1007, -0.99916}, {
       3.1175, -0.99971}, {3.1334, -0.99997}, {3.1476, -0.99998}, {
       3.1631, -0.99977}, {3.18, -0.99926}, {3.1885, -0.9989}, {
       3.1978, -0.99842}, {3.2145, -0.99734}, {3.2298, -0.99611}, {
       3.2598, -0.99303}, {3.2919, -0.98872}, {3.3501, -0.97834}, {
       3.417, -0.9623}, {3.4901, -0.93989}, {3.6231, -0.8863}, {
       3.8829, -0.7376}, {4.1597, -0.525}, {4.7086, -0.0037925}, {5.2375, 
       0.50133}, {5.4802, 0.69457}, {5.6179, 0.78676}, {5.7465, 0.85938}, {
       5.8725, 0.91684}, {5.9372, 0.94073}, {6.0075, 0.96224}, {6.046, 
       0.972}, {6.0816, 0.97975}, {6.115, 0.98588}, {6.1517, 0.99137}, {
       6.1846, 0.99515}, {6.2155, 0.99771}, {6.2325, 0.99872}, {6.2481, 
       0.99938}, {6.2652, 0.99984}, {6.2738, 0.99996}, {6.2832, 1}}],
     AspectRatio->0.618033988749895,
     Axes->Automatic,
     AxesLabel->None], {-0.16835, -0.034291}, {Left, Bottom}, {1, 0.61803}], 
   {GrayLevel[1], EdgeForm[{GrayLevel[1], Thickness[0.001]}], FaceForm[None], 
    RectangleBox[{-0.16932, -0.23316}, {1.4461, 0.58759}]}, 
   {EdgeForm[{GrayLevel[0.6666666], Thickness[0.001], 
    Dashing[{0.005, 0.01}]}], FaceForm[None], 
    RectangleBox[{-0.16932, -0.23316}, {1.1461, 0.58759}]}, 
   {EdgeForm[{RGBColor[1., 0.501960784313725, 0.], Thickness[0.001]}], 
    FaceForm[None], 
    RectangleBox[{-0.16547, -0.031411}, {0.83454, 0.58663}]}, 
   {RGBColor[1., 0.501960784313725, 0.], 
    RectangleBox[{-0.16547, -0.031411}, {-0.15547, -0.021411}], 
    RectangleBox[{0.82454, 0.57663}, {0.83454, 0.58663}], 
    RectangleBox[{-0.16547, 0.57663}, {-0.15547, 0.58663}], 
    RectangleBox[{0.82454, -0.031411}, {0.83454, -0.021411}], 
    RectangleBox[{-0.16547, 0.27261}, {-0.15547, 0.28261}], 
    RectangleBox[{0.32953, 0.57663}, {0.33954, 0.58663}], 
    RectangleBox[{0.82454, 0.27261}, {0.83454, 0.28261}], 
    RectangleBox[{0.32953, -0.031411}, {0.33954, -0.021411}]}, InsetBox[
    GraphicsBox[RasterBox[CompressedData["
1:eJzt1ksKhEAMRdGIG2m35BJcgL3/UYsgqINAVUeTlN6CAw78FO9JdJi+49yL
yGezHksHAAAAAHn9ZBe9l7c4ZX5YdOGfubbowj9zbdGF3THDkvlD5v9lW32+
kv8dz30SS4ZR17auZJ5rM8Qyf0qu1e4TnZlH5pnX27rg/ffB/M+D/5/8LPMn
eu+tuurbTRd2tV2QuX8XZB7cRYL9AAAAAK1YAJegy9o=
      "], {{0, 0}, {32, 32}}, {0, 255},
      ColorFunction->RGBColor],
     DisplayFunction->Identity,
     ImageSize->{17., 21.},
     PlotRange->{{0, 32}, {0, 32}},
     PlotRegion->{{-0.4117647058823535, 
      1.4705882352941175`}, {-0.2857142857142861, 1.2380952380952381`}}], {0.8672429514945235, 0.44575001452407736`},
     Center, {0.05389537337574924, 0.05750281344172681}, {{0.9047619047619047,
     0.}, {0., 1.}}]},
  AspectRatio->0.543732981913153,
  ImageMargins->{{1., 1.}, {1., 0.}},
  ImageSize->{635., 371.},
  PlotRegion->{{-0.0170890241861343, 0.918691694736481}, {-0.293041735887527, 
   1.18081068992615}}]], "Input",
 CellID->536949643],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->13497419],

Cell[TextData[ButtonBox["Graphics Interactivity & Drawing",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GraphicsInteractivityAndDrawing"]], "TutorialMoreAbout",
 CellID->47647152],

Cell[TextData[ButtonBox["Annotating & Combining Graphics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/AnnotatingAndCombiningGraphics"]], "TutorialMoreAbout",
 CellID->39409291],

Cell[TextData[ButtonBox["Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CombiningGraphics"]], "TutorialMoreAbout",
 CellID->4750463],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GraphicsAnnotationAndAppearance"]], "TutorialMoreAbout",
 CellID->71032073],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "TutorialMoreAbout",
 CellID->113160759],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "TutorialMoreAbout",
 CellID->42656734]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->111016757],

Cell[TextData[{
 ButtonBox["Editing ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InteractiveGraphicsOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InteractiveGraphicsOverview"],
  FontSlant->"Italic"],
 ButtonBox[" Graphics",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InteractiveGraphicsOverview"]
}], "RelatedTutorials",
 CellID->683270035]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Resizing, Cropping, and Adding Margins to Graphics - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 37, 43.3181190}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The following sequence shows how to change the aspect ratio of a plot. \
Using the Selection tool, click to select the graphic. Shift-drag a handle to \
change the aspect ratio. ", "synonyms" -> {}, "title" -> 
    "Resizing, Cropping, and Adding Margins to Graphics", "type" -> 
    "Tutorial", "uri" -> "tutorial/InteractiveGraphicsLayout"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2187, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2812, 78, 87, 1, 70, "Title",
 CellID->509267359],
Cell[CellGroupData[{
Cell[2924, 83, 62, 1, 70, "Section",
 CellID->13473268],
Cell[2989, 86, 113, 3, 70, "Text",
 CellID->32004648],
Cell[3105, 91, 97, 1, 70, "MathCaption",
 CellID->98065392],
Cell[3205, 94, 262, 9, 70, "Input",
 CellID->452195786],
Cell[3470, 105, 6939, 107, 70, "Input",
 CellID->170363190],
Cell[10412, 214, 133, 4, 70, "MathCaption",
 CellID->177305432],
Cell[10548, 220, 9051, 143, 70, "Input",
 CellID->78698362]
}, Open  ]],
Cell[CellGroupData[{
Cell[19636, 368, 47, 1, 70, "Section",
 CellID->657801144],
Cell[19686, 371, 105, 3, 70, "Text",
 CellID->284936891],
Cell[19794, 376, 99, 1, 70, "MathCaption",
 CellID->270395888],
Cell[19896, 379, 243, 8, 70, "Input",
 CellID->356551752],
Cell[20142, 389, 8320, 128, 70, "Input",
 CellID->234562728],
Cell[28465, 519, 124, 4, 70, "MathCaption",
 CellID->936148805],
Cell[28592, 525, 8719, 136, 70, "Input",
 CellID->945200439]
}, Open  ]],
Cell[CellGroupData[{
Cell[37348, 666, 53, 1, 70, "Section",
 CellID->27684169],
Cell[37404, 669, 104, 3, 70, "Text",
 CellID->14529299],
Cell[37511, 674, 70, 1, 70, "MathCaption",
 CellID->3416789],
Cell[37584, 677, 7704, 113, 70, "Input",
 CellID->11614527],
Cell[45291, 792, 97, 1, 70, "MathCaption",
 CellID->913627436],
Cell[45391, 795, 5334, 87, 70, "Input",
 CellID->70800071],
Cell[50728, 884, 101, 2, 70, "MathCaption",
 CellID->89045412],
Cell[50832, 888, 8658, 127, 70, "Input",
 CellID->400698899],
Cell[59493, 1017, 138, 5, 70, "MathCaption",
 CellID->56669149],
Cell[59634, 1024, 5442, 90, 70, "Input",
 CellID->488993760],
Cell[65079, 1116, 171, 5, 70, "MathCaption",
 CellID->294869762],
Cell[65253, 1123, 4959, 82, 70, "Input",
 CellID->536949643],
Cell[CellGroupData[{
Cell[70237, 1209, 65, 1, 70, "TutorialMoreAboutSection",
 CellID->13497419],
Cell[70305, 1212, 185, 4, 70, "TutorialMoreAbout",
 CellID->47647152],
Cell[70493, 1218, 183, 4, 70, "TutorialMoreAbout",
 CellID->39409291],
Cell[70679, 1224, 153, 3, 70, "TutorialMoreAbout",
 CellID->4750463],
Cell[70835, 1229, 185, 4, 70, "TutorialMoreAbout",
 CellID->71032073],
Cell[71023, 1235, 171, 3, 70, "TutorialMoreAbout",
 CellID->113160759],
Cell[71197, 1240, 169, 3, 70, "TutorialMoreAbout",
 CellID->42656734]
}, Open  ]],
Cell[CellGroupData[{
Cell[71403, 1248, 72, 1, 70, "RelatedTutorialsSection",
 CellID->111016757],
Cell[71478, 1251, 413, 12, 70, "RelatedTutorials",
 CellID->683270035]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[71930, 1268, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

