(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    250094,       4586]
NotebookOptionsPosition[    240691,       4286]
NotebookOutlinePosition[    243815,       4372]
CellTagsIndexPosition[    243705,       4366]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Editing Mathematica Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/InteractiveGraphicsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Editing Mathematica Graphics\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Interactivity & Drawing" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsInteractivityAndDrawing"], 
          "Annotating & Combining Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/AnnotatingAndCombiningGraphics"], 
          "Combining Graphics" :> 
          Documentation`HelpLookup["paclet:guide/CombiningGraphics"], 
          "Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"], 
          "Graphics Options & Styling" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsOptionsAndStyling"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup[
           "paclet:guide/SymbolicGraphicsLanguage"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graphics Interactivity & Drawing\"\>", 
       2->"\<\"Annotating & Combining Graphics\"\>", 
       3->"\<\"Combining Graphics\"\>", 
       4->"\<\"Graphics Annotation & Appearance\"\>", 
       5->"\<\"Graphics Options & Styling\"\>", 
       6->"\<\"Symbolic Graphics Language\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Drawing Tools", "Title",
 CellID->509267359],

Cell[CellGroupData[{

Cell["To open the graphics palette:", "Section",
 CellID->397412324],

Cell[TextData[{
 "Type ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["D", "KeyEvent"],
 " or choose ",
 StyleBox[ButtonBox["Graphics",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/GraphicsMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Drawing Tools",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/DrawingTools"], "MenuName"],
 "."
}], "MathCaption",
 CellID->1534169418],

Cell["\<\
For more information on each tool, click the words pointing into the palette.\
\
\>", "MathCaption",
 CellTags->"2dpalette:01",
 CellID->51009339],

Cell[BoxData[
 GraphicsBox[{InsetBox[Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Graphics",
     ImageSize->{102, 263},
     ImageMargins->0], {5., 5.000000000000001}, 
    Center, {2.2737306843267104`, 7.17032967032967}], {{GraphicsGroupBox[{
       StyleBox[InsetBox[
         ButtonBox[Cell["Line"],
          BaseStyle->"Link",
          
          ButtonData->
           "paclet:tutorial/InteractiveGraphicsPalette#236508825"], {2.32638454746135, 5.508893406593369},
          ImageScaled[{0.5, 0.5}]],
        FontSize->12], 
       StyleBox[InsetBox[
         ButtonBox[Cell["(l)"],
          BaseStyle->"Link",
          
          ButtonData->
           "paclet:tutorial/InteractiveGraphicsPalette#236508825"], {2.8005253863134554`, 5.508893406593369},
          ImageScaled[{0.5, 0.5}]],
        FontSize->12]}], {
      StyleBox[InsetBox[
        ButtonBox[Cell["segmented Line"],
         BaseStyle->"Link",
         ButtonData->
          "paclet:tutorial/InteractiveGraphicsPalette#651477065"], {7.908346136865314, 5.508893406593366},
         ImageScaled[{0.5, 0.5}]],
       FontSize->12], 
      StyleBox[InsetBox[
        ButtonBox[Cell["(s)"],
         BaseStyle->"Link",
         ButtonData->
          "paclet:tutorial/InteractiveGraphicsPalette#651477065"], {6.855759602648993, 5.508893406593369},
         ImageScaled[{0.5, 0.5}]],
       FontSize->12]}}, {{
      StyleBox[InsetBox[
        ButtonBox[Cell["freehand Line"],
         BaseStyle->"Link",
         ButtonData->"paclet:tutorial/InteractiveGraphicsPalette#40012893"], {7.8140123620308835`, 6.464620214797755},
         ImageScaled[{0.5, 0.5}]],
       FontSize->12], 
      StyleBox[InsetBox[
        ButtonBox[Cell["(f)"],
         BaseStyle->"Link",
         ButtonData->"paclet:tutorial/InteractiveGraphicsPalette#40012893"], {6.855759602648993, 6.4646202147977565`},
         ImageScaled[{0.5, 0.5}]],
       FontSize->12]}, GraphicsGroupBox[{
       StyleBox[InsetBox[
         ButtonBox[Cell["Point"],
          BaseStyle->"Link",
          ButtonData->
           "paclet:tutorial/InteractiveGraphicsPalette#132835900"], {2.262974137710514, 6.4646202147977565`},
          ImageScaled[{0.5, 0.5}]],
        FontSize->12], 
       StyleBox[InsetBox[
         ButtonBox[Cell["(p)"],
          BaseStyle->"Link",
          
          ButtonData->
           "paclet:tutorial/InteractiveGraphicsPalette#132835900"], {2.8005253863134567`, 6.4646202147977565`},
          ImageScaled[{0.5, 0.5}]],
        FontSize->12]}]}}, {{{
      StyleBox[InsetBox[
        ButtonBox[Cell["(t)"],
         BaseStyle->"Link",
         ButtonData->"paclet:tutorial/InteractiveGraphicsPalette#9065006"], {6.855759602648993, 2.8976251923076517`},
         ImageScaled[{0.5, 0.5}]],
       FontSize->12], 
      StyleBox[InsetBox[
        ButtonBox[Cell["Text"],
         BaseStyle->"Link",
         ButtonData->"paclet:tutorial/InteractiveGraphicsPalette#9065006"], {7.35512251655627, 2.897625192307651},
         ImageScaled[{0.5, 0.5}]],
       FontSize->12]}, GraphicsGroupBox[{
       StyleBox[InsetBox[
         ButtonBox[Cell["(m)"],
          BaseStyle->"Link",
          
          ButtonData->
           "paclet:tutorial/InteractiveGraphicsPalette#25770655"], {2.8005253863134567`, 2.8976251923076517`},
          ImageScaled[{0.5, 0.5}]],
        FontSize->12], 
       StyleBox[InsetBox[
         ButtonBox[Cell["TraditionalForm Text"],
          BaseStyle->"Link",
          
          ButtonData->
           "paclet:tutorial/InteractiveGraphicsPalette#25770655"], {1.4048046909492107`, 2.8976251923076517`},
          ImageScaled[{0.5, 0.5}]],
        FontSize->12]}]}, {GraphicsGroupBox[{
       StyleBox[InsetBox[
         ButtonBox[Cell["Arrow"],
          BaseStyle->"Link",
          
          ButtonData->
           "paclet:tutorial/InteractiveGraphicsPalette#78894757"], {2.17300620860925, 4.683883791208743},
          ImageScaled[{0.5, 0.5}]],
        FontSize->12], 
       StyleBox[InsetBox[
         ButtonBox[Cell["(a)"],
          BaseStyle->"Link",
          
          ButtonData->
           "paclet:tutorial/InteractiveGraphicsPalette#78894757"], {2.800525386313456, 4.683883791208741},
          ImageScaled[{0.5, 0.5}]],
        FontSize->12]}], {
      StyleBox[InsetBox[
        ButtonBox[Cell["(g)"],
         BaseStyle->"Link",
         ButtonData->
          "paclet:tutorial/InteractiveGraphicsPalette#120316707"], {6.855759602648993, 4.683883791208741},
         ImageScaled[{0.5, 0.5}]],
       FontSize->12], 
      StyleBox[InsetBox[
        ButtonBox[Cell["Polygon"],
         BaseStyle->"Link",
         ButtonData->
          "paclet:tutorial/InteractiveGraphicsPalette#120316707"], {7.540000068310395, 4.683883791208739},
         ImageScaled[{0.5, 0.5}]],
       FontSize->12]}}, {{
      StyleBox[InsetBox[
        ButtonBox[Cell["(q)"],
         BaseStyle->"Link",
         ButtonData->
          "paclet:tutorial/InteractiveGraphicsPalette#389836818"], {6.855759602648992, 3.7778138562586534`},
         ImageScaled[{0.5, 0.5}]],
       FontSize->12], 
      StyleBox[InsetBox[
        ButtonBox[Cell["Rectangle"],
         BaseStyle->"Link",
         ButtonData->
          "paclet:tutorial/InteractiveGraphicsPalette#389836818"], {7.615056291390707, 3.7778138562586525`},
         ImageScaled[{0.5, 0.5}]],
       FontSize->12]}, GraphicsGroupBox[{
       StyleBox[InsetBox[
         ButtonBox[Cell["(c)"],
          BaseStyle->"Link",
          
          ButtonData->
           "paclet:tutorial/InteractiveGraphicsPalette#54243372"], {2.800525386313456, 3.7778138562586534`},
          ImageScaled[{0.5, 0.5}]],
        FontSize->12], 
       StyleBox[InsetBox[
         ButtonBox[Cell["Disk/Circle"],
          BaseStyle->"Link",
          
          ButtonData->
           "paclet:tutorial/InteractiveGraphicsPalette#54243372"], {1.9439744309963993`, 3.7778138562586534`},
          ImageScaled[{0.5, 0.5}]],
        FontSize->12]}]}}, {GraphicsGroupBox[{
      StyleBox[InsetBox[
        ButtonBox[Cell[TextData[{
          "(",
          StyleBox["Ctrl", "KeyEvent"],
          StyleBox["+", "KeyEventDelimiter"],
          StyleBox["1", "KeyEvent"],
          ")"
         }]],
         BaseStyle->"Link",
         ButtonData->
          "paclet:tutorial/InteractiveGraphicsPalette#206068702"], {3.1102849889624666`, 7.339205019997092},
         ImageScaled[{0.5, 0.5}]],
       FontSize->12], 
      StyleBox[InsetBox[
        ButtonBox[Cell["New Graphic/Inset"],
         BaseStyle->"Link",
         ButtonData->
          "paclet:tutorial/InteractiveGraphicsPalette#206068702"], {1.5144810122751646`, 7.339205019997092},
         ImageScaled[{0.5, 0.5}]],
       FontSize->12]}], {
     StyleBox[InsetBox[
       ButtonBox[Cell["(o)"],
        BaseStyle->"Link",
        ButtonData->"paclet:tutorial/InteractiveGraphicsPalette#338102806"], {6.855759602648992, 7.339205019997092},
        ImageScaled[{0.5, 0.5}]],
      FontSize->12], 
     StyleBox[InsetBox[
       ButtonBox[Cell["select/move/resize"],
        BaseStyle->"Link",
        ButtonData->"paclet:tutorial/InteractiveGraphicsPalette#338102806"], {8.09827315673286, 7.339205019997086},
        ImageScaled[{0.5, 0.5}]],
      FontSize->12]}}, {
    LineBox[{{5.8315226967983325`, 7.364964709174726}, {6.580937173377933, 
     7.364964709174726}}], 
    LineBox[{{5.831522696798331, 2.914415258625276}, {6.580937173377931, 
     2.914415258625276}}], 
    LineBox[{{5.831522696798331, 3.821008665218681}, {6.580937173377931, 
     3.821008665218681}}], 
    LineBox[{{5.831522696798331, 4.672657016867031}, {6.580937173377931, 
     4.672657016867031}}], 
    LineBox[{{5.831522696798331, 5.524305368515384}, {6.580937173377931, 
     5.524305368515384}}], 
    LineBox[{{5.831522696798327, 6.430898775108785}, {6.580937173377928, 
     6.430898775108785}}]}, {
    LineBox[{{3.6236899903349493`, 7.3647593550684824`}, {4.306979660157525, 
     7.3647593550684824`}}], 
    LineBox[{{3.030608189564945, 2.914415258625274}, {4.309021120200733, 
     2.914415258625274}}], 
    LineBox[{{3.030608189564945, 3.821008665218679}, {4.309021120200733, 
     3.821008665218679}}], 
    LineBox[{{3.030608189564945, 4.672657016867028}, {4.309021120200733, 
     4.672657016867028}}], 
    LineBox[{{3.030608189564945, 5.52430536851538}, {4.309021120200733, 
     5.52430536851538}}], 
    LineBox[{{3.0306081895649433`, 6.430898775108782}, {4.30902112020073, 
     6.430898775108782}}]}, 
   StyleBox[InsetBox[
     ButtonBox[Cell["Graphics Inspector"],
      BaseStyle->"Link",
      ButtonData->"paclet:tutorial/InteractiveGraphicsPalette"], {7.774548565121388, 1.93608673076919},
      ImageScaled[{0.5, 0.5}]],
    FontSize->12], 
   LineBox[{{5.875454682040546, 1.9527398943493224`}, {6.580785954115465, 
    1.9527398943493224`}}]},
  AspectRatio->0.803532008830022,
  ImageSize->{453., 400.},
  PlotRange->{{0, 10}, {0, 10}}]], "Input",
 CellID->454629851]
}, Open  ]],

Cell[CellGroupData[{

Cell["To select a tool:", "Section",
 CellID->119334373],

Cell["Do one of the following:", "Text",
 CellID->570315133],

Cell["Click a tool icon on the palette", "BulletedText",
 CellTags->"2dpalette:02",
 CellID->3752896],

Cell[TextData[{
 "With",
 " ",
 "a graphic selected, type one of the letters: \n",
 StyleBox["o", "KeyEvent"],
 ", ",
 StyleBox["p", "KeyEvent"],
 ", ",
 StyleBox["f", "KeyEvent"],
 ", ",
 StyleBox["l", "KeyEvent"],
 ", ",
 StyleBox["s", "KeyEvent"],
 ", ",
 StyleBox["a", "KeyEvent"],
 ", ",
 StyleBox["g", "KeyEvent"],
 ", ",
 StyleBox["c", "KeyEvent"],
 ", ",
 StyleBox["q", "KeyEvent"],
 ", ",
 StyleBox["m", "KeyEvent"],
 ", ",
 StyleBox["t", "KeyEvent"]
}], "BulletedText",
 CellTags->"2dpalette:02",
 CellID->1746198164]
}, Open  ]],

Cell[CellGroupData[{

Cell["Persistence of tools", "Section",
 CellID->137752276],

Cell["Do one of the following:", "Text",
 CellID->17048901],

Cell[TextData[{
 "Click a tool button to use a tool once. \nAfter the single use, the tool \
will automatically revert to the ",
 StyleBox["Selection", "DialogElementName"],
 StyleBox[" ", "SR"],
 "tool."
}], "BulletedText",
 CellTags->"2dpalette:02",
 CellID->198101575],

Cell["Double-click a tool button to keep using the tool.", "BulletedText",
 CellTags->"2dpalette:02",
 CellID->153876251]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tools", "Section",
 CellID->373843469],

Cell[CellGroupData[{

Cell[TextData[{
 "New Graphic Tool ",
 Cell[BoxData[
  GraphicsBox[RasterBox[CompressedData["
1:eJztm39ojWEUx29IS5KWltaiSayWlj+0pPWGpCyJlaSltShJ4w9RI5K0pCWJ
hViS/CN/SEK65A+UQvaHlpaWuLu7PyZiScp939ul3tN3957uOZ73buet9ZGd
neec5znf932e932e+s59W3ZNj8Vidbmf+tyP/++521befXHws2c0GoszQHzM
aJzUlNLFy2vr7n37nTYaK4rauvjR0H7m6fcRwgtrT+9N/EoS7lz1YVNv3ygh
1z4fF2XLrHfX97dQavuXyotrL+WHm1el9P/VsZvPWpuThNq6QPHnf58qm7fq
tudSLJ2u/Luyj1q7Ucur49ObRe9/jhJq6wK1u3R5VS60NOGheH9t0xBlTOg6
PO/2+uHutBcmigfZc4ny4rYbtXxRXlyieKTGHbXrz14a2lOE2rpA+kVxLjyZ
2nx/QYZQqn+Qf20+b20+tbqDkusnavmivLjUHnfU7sTzBT1doPtA9oi3YsfD
DGFyiW+QJZTqH7um5oXqCtWnK11cuuhfGUKkl/w6rHSi/hnu9icAWc9YGeTW
OaoHZD+wsTNXwmlCbV2g9Q56P4Z0wSVXF719XdUnnpRPbf+u6CovNI7c+yey
d6ULNH9DukDPES5RfwbN92c9Y2UQjaNUnbhaX5gujKYL04XRdKGhC6n3h6g/
g88nR7NeuUTjKGVfKdTOC40j930vsp/4+2B0vl9I7W9B/Xk24y+4st7/Jhp3
V/Fo58Ul8o/GkVsPSC9Re16YLkwXpfRD4fnTUzP4arxtwKsKbuiP2fVgujBd
RCEvVM+udIH8uNJFEE5tipC7P4q7P4erC/TdR7uuuO1KxekqX1Sf+dH54jUN
LZ55/HzC2zB7WmNPzQMxe6QXV/ujuPsGUf2j7y/c/WZS30mlyG1XKk7tfCde
L9B6Ljw3/N3fXdUD3u7gD+J/7cMsZh/2j+rKlS7QvndUz9r7Ku2SvVB9hu/b
6P/D9/9yifwXm9eF49fWBTp/MWPrnGV3rqRKptQ4ovmk9jkCqXa5+UYtr0L9
oudFWEfhui+QO79CcQa/Hhwl1NYFOj+F1h2I5eqhcCHdoXa5+uWS2y4333x/
/1vfFt7DaOeL5ifF6r/c9QXyj+JE8xltXeTjTRIivaD1CHruIHt0H+Cei5Ty
L5UX117KDzcvVJ/c/ke64PY/iufrW3+hmiTU1oXU+e41QYcnCVF/It0hP9r+
ufaoXa69lB9uXtxz3Mg/0oVU/6P7trYuju15dODc/BHC1+NtH29cpkRxovPp
XHukU23/2u0ieyk/3Ly47brq/8ZAcAlCbV1onyNG76Wlzh1L+ef6kbKPWrva
8XD9uD1/YTRODnJ1YTROZf4BldFSjA==
    "]],
   ImageSize->{33., 28.},
   PlotRange->{{0., 33.}, {0., 28.}}]]]
}], "Subsection",
 CellID->206068702],

Cell["Do one of the following:", "Text",
 CellID->1134718933],

Cell[TextData[{
 "Type ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["1", "KeyEvent"]
}], "BulletedText",
 CellTags->"2dpalette:02",
 CellID->1566321571],

Cell[TextData[{
 "Click the ",
 StyleBox["New Graphic", "DialogElementName"],
 " button on the palette"
}], "BulletedText",
 CellTags->"2dpalette:02",
 CellID->1312098871],

Cell[CellGroupData[{

Cell[TextData[{
 "Choose ",
 StyleBox[ButtonBox["Graphics",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/GraphicsMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["New Graphic",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/InsertNewGraphic"], "MenuName"]
}], "BulletedText",
 CellTags->"2dpalette:02",
 CellID->2083637501],

Cell["A blank drawing area with a bounding box appears. ", "MathCaption",
 CellID->679647678],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[None], FaceForm[None], RectangleBox[{0, 0}, {1, 0.61803}]}, 
   {EdgeForm[RGBColor[1., 0.560784, 0.262745]], FaceForm[None], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, 
   {FaceForm[RGBColor[1., 0.560784, 0.262745]], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{3.5, 3.5}, 
     Scaled[{0., 0.}]]], 
    RectangleBox[Offset[{0., -1.75}, Scaled[{0., 0.5}]], Offset[{3.5, 1.75}, 
     Scaled[{0., 0.5}]]], 
    RectangleBox[Offset[{0., -3.5}, Scaled[{0., 1.}]], Offset[{3.5, 0.}, 
     Scaled[{0., 1.}]]], 
    RectangleBox[Offset[{-1.75, 0.}, Scaled[{0.5, 0.}]], Offset[{1.75, 3.5}, 
     Scaled[{0.5, 0.}]]], 
    RectangleBox[Offset[{-1.75, -3.5}, Scaled[{0.5, 1.}]], Offset[{1.75, 0.}, 
     Scaled[{0.5, 1.}]]], 
    RectangleBox[Offset[{-3.5, 0.}, Scaled[{1., 0.}]], Offset[{0., 3.5}, 
     Scaled[{1., 0.}]]], 
    RectangleBox[Offset[{-3.5, -1.75}, Scaled[{1., 0.5}]], Offset[{0., 1.75}, 
     Scaled[{1., 0.5}]]], 
    RectangleBox[Offset[{-3.5, -3.5}, Scaled[{1., 1.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}}]], "Input",
 CellID->373005753]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Selection Tool ",
  FontWeight->"Bold"],
 Cell[BoxData[
  GraphicsBox[RasterBox[CompressedData["
1:eJzt2k1Kw0AYxvEBXbh04aKLClXElQu/QFDUuHNRK+hGEESr4je9Qo7So/Qo
OYJHsNBslLzzL8R00snzQOniN5lmMn0z7bRr/cHV84JzrjV+rI4fiy5PNkgK
n+VyuVwul8vlxW4H2rVKet5/6PHL5WW8snyf+r2T+H0ffA8c63eS0NdfLq/S
zSxDux3wY/AD8PbEQ18febPdDK1fS9APHU++7u+fxtH58rvbBaf7w5/zqOv8
yufbzdD7cwOcPn+2wW/9TuMYfUL/dP75/SP0/Mib7WZWoN02eNnvf7D+4fr5
AP3T+KZM6PmTx+1W0kdoR58P4ftfeud3PE9yuj9sgtP6rv1d+QzcSgbrT/IK
/dz4PXsHh/Mc0f3jBPwQnPaf8vU39PzJ43YrKdQn9VO1u2vwM/Aj8C3wfH8s
9PzJ43Yrda/Pyutf+7fyGriVYeT1mXaTX+3qOj/yZruVrO9vF7q+cBxd8H9K
6PmTx+1WMth/qbq+7svWn36/lEfgVkZP/nZV16e7BKf/H80ooedPHrdb6bz4
21E/yQe8zpT1F/r6yOUh3crwzd+O/j+X9uB1arL+lU3o+ZPH7VaGVH8Xxf3W
bXxy+Ty7lfS8+Lhpj29KQs+fXC6Xy+VyuVwul8vlkfsPO/N8KQ==
    "], {{0., 0.}, {29., 24.}}, {0., 255.},
    ColorFunction->RGBColor],
   ImageSize->{29., 24.},
   PlotRange->{{0., 29.}, {0., 24.}}]]]
}], "Subsection",
 CellID->338102806],

Cell[TextData[{
 "You can use the ",
 StyleBox["Selection", "DialogElementName"],
 " tool to select a graphics primitive as a whole. \nThe selection is \
indicated by a frame with handles. \nYou can scale the selection by dragging \
a handle. \nTo scale equally in both directions, ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["drag", "PointerEvent"],
 " a handle. \nYou can move an object by dragging it. \nYou can remove or add \
an object to a selection with ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["click", "PointerEvent"],
 ".\nDrag out a rectangle to select all the objects within it.\nWhen an \
object is completely underneath another one, selecting it by dragging makes \
it visible.\nYou can then drag it by dragging its highlight.\nFor more \
information on how to use the ",
 StyleBox["Selection", "DialogElementName"],
 " tool, see",
 ButtonBox[" \"Interactive Graphics: Selecting\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InteractiveGraphicsSelecting"],
 "."
}], "MathCaption",
 CellID->235978221]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Draw Arrow Tool ",
  FontWeight->"Bold"],
 Cell[BoxData[
  GraphicsBox[RasterBox[CompressedData["
1:eJzt2k1Kw0AYxvEBXbjswkUXCrWIiIj4uRBEY+sJ/HYjbf0AF9or9CgepUfp
ETyChU6yGOadR1pqWvp/obw0v2SaGp5MkrrR6V6/LTnnqsPX+vC17HwNulm0
4ziO4ziOW27Wz0XaV8Q4yv34ZX9/HJ9lt0usVxe+LbwqnPzieKLEelvCj4Tv
C18TTn7xBXB3lcX746j3mkZ/DsYJa1f4iXDyi+NmPvt3o27ls/+V9lor+Jyw
yC+OTz2/lg+mnd9j4eQXx8fO77fIb0Z+cXxm81v6/Hsg/I/5HdvV8znOD/g/
uJXP3k18edH9OFObf9X9r8pvbUKvC6+MvOzjhy+2W/nMfH6tfMr5tx18TliT
5lfNz2r7Q+F+/i77+OB4ys3rZzH/qufPLZVflZ8z7414b3XE9qfCN4Vz/YvP
gZvXx7fG8vD+txHvgzy/jXjvvfj3TaN/BPsZ1rnwPeH+/yvL/vvjeMrt8usZ
+enf+/dGfmvdtKvra5dvXzN6lqV3X83fq34/Zvz44IvtZvnrP/P5Uj7/Wb8P
faa92A/hvct4d/n5waod4eQTnwM37z+f4ssLb6d98J52J/LbF/l1+fhWVYRz
/4nj458fHuLLi/y/xsedte+H4ziO4ziO4ziO4ziO4ziOL5z/ApHjRY4=
    "], {{0., 0.}, {29., 24.}}, {0., 255.},
    ColorFunction->RGBColor],
   ImageSize->{29., 24.},
   PlotRange->{{0., 29.}, {0., 24.}}]]]
}], "Subsection",
 CellID->78894757],

Cell[TextData[{
 "Click the ",
 StyleBox["Draw Arrow", "DialogElementName"],
 " tool and drag the pointer (",
 Cell[BoxData[
  GraphicsBox[
   RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 
    1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 
    1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 1}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 
    1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 
    1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}}, {
    Offset[{0.5, -21.5}, {0.5, 0.5}], Offset[{21.5, -0.5}, {0.5, 0.5}]}],
   ImageSize->{25., 21.}]]],
 ") to draw an arrow.\n",
 StyleBox["Hold", "Text"],
 " the ",
 StyleBox["Shift", "KeyEvent"],
 " key to draw the arrow horizontally or vertically."
}], "MathCaption",
 CellID->498860540],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[None], FaceForm[None], RectangleBox[{0, 0}, {1, 0.61803}]}, 
   {EdgeForm[{RGBColor[1., 0.560784, 0.262745], Dashing[{0.005, 0.01}]}], 
    FaceForm[None], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, {
    ArrowBox[{{0.22841225626741, 0.177918579387187}, {0.735376044568245, 
     0.431400473537605}}], 
    RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 
     1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1,
      1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 1}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 
     1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 
     0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 
     1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}}}, {
     Offset[{0.5, -21.5}, {0.689949761241544, 0.480538698766415}], 
      Offset[{21.5, -0.5}, {0.689949761241544, 
       0.480538698766415}]}]}}]], "Input",
 CellID->419256953]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Draw Freehand Tool ",
  FontWeight->"Bold"],
 Cell[BoxData[
  GraphicsBox[RasterBox[CompressedData["
1:eJzt2r1NA0EQhuGToAAHBAQQYCGEEEL8p1wN2FAAErFboBSX4lIogRJwcIml
m30thvOt4B3JIniW3Tvjj9k9OHlbPL/vNU1zuH4dr1/7TVefi7b3q67ruq7r
ut7vccG4o6R38499/7o+pscF407Bb5NO85tf/Q94XDCO8nGddMrnDXjXf8d+
f3U942HR/hLysYR18DrOwO/Ap+3GOrW+/3rO44JxBzRP/7rV3N+0PA7neS17
Oy875dv+qReL8ncBXsn5KSoat4L8Ub6pP+N1XoJP2o15av186TkPawLjKJ90
/tpRfqPCcXQ+pP3pedlx/Sn419PGPLV+vvScR7Wicdn+uqP8RoX3R/vL5Pm0
fYH57Y96qeD8NHp+oT+lz5f0fOYxOT89n7I/6lt4VPT8ox06v5Sfh7Ljfd6X
HfsjnV8rOZ/rf9ujWs3K43Aeyi/1z6uyU35of4D700r297pe8qiy+SX/yH7/
0L9fht7f+/+D+i94VJRfyg/uv2f917Xt9Y2eX9rfU7679cf++ev6kB4W7H/T
+aX+SX//8fmwrofVQv9dwjy8DrjPh3X95/ml/fm8f97a7k/XdV3XdV3XdV3X
dV3XdV3/d/4NnGV+Bw==
    "], {{0., 0.}, {29., 24.}}, {0., 255.},
    ColorFunction->RGBColor],
   ImageSize->{29., 24.},
   PlotRange->{{0., 29.}, {0., 24.}}]]]
}], "Subsection",
 CellID->40012893],

Cell[TextData[{
 "Click the ",
 StyleBox["Draw Freehand", "DialogElementName"],
 " tool button and drag the pointer (",
 Cell[BoxData[
  GraphicsBox[
   RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 
    1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 
    1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 1}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 
    1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 
    1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}}, {
    Offset[{0.5, -21.5}, {0.5, 0.5}], Offset[{21.5, -0.5}, {0.5, 0.5}]}],
   ImageSize->{25., 21.}]]],
 ") to draw a curve."
}], "MathCaption",
 CellID->596935328],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[None], FaceForm[None], RectangleBox[{0, 0}, {1, 0.61803}]}, 
   {EdgeForm[{RGBColor[1., 0.560784, 0.262745], Dashing[{0.005, 0.01}]}], 
    FaceForm[None], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    LineBox[CompressedData["
1:eJxl13001PkeB/BJtcgWEqVwtUuxNxrSXRU+dVkqXUUPK6tuqenGZtMjKiel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     "]]}, 
   RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 
    1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 
    1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 1}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 
    1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 
    1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}}, {
    Offset[{0.5, -21.5}, {0.8442361554607256, 0.3974623022861626}], 
     Offset[{21.5, -0.5}, {0.8442361554607256, 
      0.3974623022861626}]}]}]], "Input",
 CellID->631419171],

Cell[TextData[{
 StyleBox["Double Click", "PointerEvent"],
 " the ",
 StyleBox["Draw Freehand", "DialogElementName"],
 " tool to draw multiple curves."
}], "MathCaption",
 CellID->367241650],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[None], FaceForm[None], RectangleBox[{0, 0}, {1, 0.61803}]}, 
   {EdgeForm[{RGBColor[1., 0.560784, 0.262745], Dashing[{0.005, 0.01}]}], 
    FaceForm[None], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    LineBox[CompressedData["
1:eJxl13001PkeB/BJtcgWEqVwtUuxNxrSXRU+dVkqXUUPK6tuqenGZtMjKiel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     "]]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    LineBox[CompressedData["
1:eJxl1F1Ik2EUB/Ax0pgkZZa0zEztYtAHQ0V3kZ0wEcJNpojFsC5G00wiGTMX
u1BRCQvmLnZRVLvIrKbZhZSsMMmRCVFg68Jotnevc1/4maiBDcuC//PAdjHG
7+blOef8z8nRX682SCUSSe3279+/Y9/RtkuGKJ1xPSpQCT+oxlnS0fokwly2
2VJ5rj1CdRn59+zHfHRg8fDIWGqEzKbxrZVWH8WsvVr9eJjuerSXNe99NNWh
ck1Xcr/zNHc7FWFaWdiy650C2Sfk218I0a4K6+bYukBXXO4a+9kQDec79l+9
5ie1rmC5+FeQpmwnLB9e++lkrK/HOxAkH60PrQncS0uj/txkkfb8LyDRsYdd
6VXHRZIuq39qVUE6GEu/OWQWaZW6x3L3JrpI1+eTTYg0Z3t7Z21+LsHlsqY0
1Tx3jSu/rD5tllnfsHnDXsxtzHA73Re52yd6ZlY6ua2mqt3ZA9yOPHmpZor7
ucdvsmzMsve96Xj21HkowPxR2fx9ujTA6ov3N6E4NbkxwPoR75D1DxX2cm+U
TBr1rwJ0RDNTO9SV6B2L1n6bN8D6D58abBqVfeHG/GCd7HdOfVaIGfOGzQ23
b7kbuR+bxGzNDPdwnrPaIg0zI1+wTymZT2oJs/cuCJNZhfe5kVfUC6Mfigeh
yEIBd1HFi8xMHTfyD2M/YP2FpJf9n7iNOz+Hvq5yt4/Y5VJ5NMGYl9VQp1ZS
lM0Xxvxh5ANGfmDkC0b+YOQTRn5h5BtG/vHeeCsGvYNeh8jqhdGPeGPf0L8U
jbq8rVpk/Y039hfzwH5jXrgHmCeccvp8py0cZsZ9gpGXeOPeIF8w7heMPMLI
K4z7Bv8F9EPRpw==
     "]]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    LineBox[CompressedData["
1:eJxl1H0s1AEYB/BbLbUuOVusLtWsTpS81PVHpR5vdb2QvCy3vNUZuYVossto
ZKIuL+OUMFeUSuMIczOp2UXicOcOWy/3St7aXDGJKH88v99299tuv33+uuf3
PN/nseVcD4haQ6FQwv7/Vt+nr439HWtXQ0H6j5+RHj1QONS7KE3TgHvzmaA8
qhSeZAmclqo0wEuM2cV6JoV23W4Be0YDMxPPm8XKPvjs0bjQ5KYF+2pJemJ8
PywIPSMs72nhgkUG3+A3AOv9NhaCSAuxcTSDb/kAHAq9su+TrQ4k2e22kRky
8G+dybeLJx3BFXcECXRgUxkbwIuWQ/zW9Lk7rTpwoyy1KN7IIa2LZd+g1gE7
nL/DdUUO/GSLEJWZHgT0mvGJR4PwSlHx/ligHnqHPjZWuiigJTP6F/eWHjYU
fb8d0k16jyFZ32KlhK6DTnYlQj1cri0WJdQpQamZY3d+0EM5tynFgTUEuoK3
/NkpU4u7vNRZRaQVjMGTWhXp2UzO6xOOw4RpWgOtjEfaxT0jeV5C2qeC9iXQ
coRwzJLQoz6MdM4l5xebakaI+tBYPxq/D439QJcyhnPND5DG/qGxv2jsPxrn
g8b5oT2pDmG/WaRx3mhG7eP5skUtYetlmSROSRrzgp6cSXHUcbREPzBv2C9p
4VTnXWvSmE/sr4i5WoCG6D8a54P5RmP+0Zl713ULgzXEfJN4xx8mumqI+Ud3
34z0opIOpte5WI2qTYz5wX1DH23b2SMuIb3fPLjk/g3SNuH5UaE+pk6lMqyk
f5SwWbSaAFNjnpdXVh8VYfXThNKqRhV4+5md3cJRQoeXhsm6qiL2oXrUv3+S
roJpJnvbSqoCcrI7uHl936Ced+T8Kf0gYdw3dFIbPTP3HGncTzTuLxr3G//P
2BTvr9Pb6XKiPv2ob/Y7qYyoH+8F+qWDc5vZYRnxvQ96hBdrxgcI4/3B/qCx
n8bG+4XzYDYYGMVrB4h5oXGeaJy3sfE+Yl7QmCe8p5g3vLeYR2Mb32f0P0Pp
D3A=
     "]]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    LineBox[CompressedData["
1:eJxl1H8s1HEYB/CTkhY7LeGP8mORtOTa2Fh4Ton8SFeqFcLUGRYh6mxs1zJq
mZ8zFdNNkuQMDZfE4Y7jfrij2G5Nt2rrWG2uac0yYvM83+3647vvXn989/18
nuf9PG4pty7wt7FYrKSNZ/P9OKrYc8fEFCR/bYkU9HVDe9yuv26panJ246JP
ulpFlqaXa4ItleQH4luWJRmTII3/ZlgwvoEPgr1N8SIFSKOTbNVRvZDMmt29
mDUOHHnD8+CiPvhR+jhfEDRG7lQWtA01y0EUpA/o7JBAYGygfcxtGVQeu5Ra
s+cdyPRrRZ9CRoH1snp1+6kBstBFW30n7z2UORu6D74agaU6Wy/ji0HgpQx/
z7AbgexQWRu/WAr2LU37u+8Ok/UL98+vzEvBMGARMtczTHYtcLWpjBkBkTe/
hBsmhSt+MHfmO+NK07UmC+EoWSsuzOx3kpG5h/otj0bKyUtxDvzL9uPktJnY
v+OnFWRDVFVVwN0JMk+m8XzdOklWBNoM7tcryayVIw8/5qqY//VEXCzfrabz
C3LSXMKbGUu8SxfXAzV0/6WFFz2Sjxqqz+EWmTAna4rq59tl8qi11FJ9eex7
j0znGN/MtDOdbdACq+5ARK2eMfarTPnscptRC3ns+M9WNnIy9heN/W/18hmw
8tOBe2gf9/gsY8wLumFgebZpp4KM+UJHm3j+at0EGfOIxrzi//2/KG90+qrI
mHe8r9Hh8Jh+TU31SKjgJ0RzpqheOC9YT6svhsQTRVqqvzs3W1Y38b+xfycb
172W9+mgUvjz1/UQJSSullfwUhgXxjn/bu/QgZN1Z8Iv9iRZVJE7JpxXwFOJ
eOPEOuA4+nHY4nHodQiS8sOnKW9ozOOHPJXHSM00WGfU+9/ukpExv2jMNxrz
j8b5QOP8oFtZX/OdDzDGeUMn20UNXZ0bIuO8onGe8fzmxvnH+6OxPmisp7lx
n1D9t4z9QWM/ze3a66h1M7wF4+Z4cRhjHtCYF7TrTFhVTZ2G+X4rX+bG/Yd5
ROP+RWN+cX+ueoif/KlXkjHv5sZ9/A9mkfDI
     "]]}, 
   RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 
    1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 
    1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 1}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 
    1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 
    1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}}, {
    Offset[{0.4999999999999716, -21.5}, {0.7510221360722096, 
      0.5093191255523819}], 
     Offset[{21.49999999999997, -0.5}, {0.7510221360722096, 
      0.5093191255523819}]}]}]], "Input",
 CellID->132566320]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Draw Line Tool ",
  FontWeight->"Bold"],
 Cell[BoxData[
  GraphicsBox[RasterBox[CompressedData["
1:eJzt2zFqwzAUxnFBOnTM2KEFJ0PJmOYC8dp0SToVuqQOXZKAr+Cj6Sg+Qo8Q
Qz366RuMeIb8H5gMv2eBAh9SrHhR1Z+/sxDCU3e9dNdD6Kuty8FPHMfx3G7W
31Y0qHGE9+N7zx/Hp+xmPYq+5Uif/7v3/HF8ym6WyudK+Gbk/eQXx+36SveV
ezHOWrjK76tw8ovfgVsVf9J9zUWM8y6c/OJ4tvw2VbqvFPltyC+Ou+W3OIk+
8ovj7m5VW6X7jmcxzodw8ovjbvmNIr8N+cVxt/zGSvSp/fNO3E9+cTxbfkev
v/z+xXG3/Abx/Krg/AjH3d0qtX9W+c2+/vL/Kxw3y33//Ca8EN6/v+D9/eJ4
TrdKnf/K9Vc9v1L732fh5BPHzZLnv9e0y/Mj3u/D8Wz5jd/pvngYHndq88Nx
HMdxHMdxHMdxHMdxHMfvzm+HbCAQ
    "], {{0., 0.}, {29., 24.}}, {0., 255.},
    ColorFunction->RGBColor],
   ImageSize->{29., 24.},
   PlotRange->{{0., 29.}, {0., 24.}}]]]
}], "Subsection",
 CellID->236508825],

Cell[TextData[{
 "Click the ",
 StyleBox["Draw Line", "DialogElementName"],
 " tool and drag the pointer (",
 Cell[BoxData[
  GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJmYGAQh2ImhqEEGIGAFNUMQ0Q9dhlc6nGLk6Iam26YOmQ2LuVg
iMmmhtlQdaSELi1VjwIAmf4CNw==
    "], {Offset[{0.5, -21.5}, {0.5, 0.5}], Offset[{23.5, 1.5}, {0.5, 0.5}]}],
   ImageSize->{24., Automatic}]]],
 ") to draw a single line.\n",
 StyleBox["Hold", "Text"],
 " the ",
 StyleBox["Shift", "KeyEvent"],
 " key to draw a horizontal or vertical line."
}], "MathCaption",
 CellID->11885642],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[None], FaceForm[None], RectangleBox[{0, 0}, {1, 0.61803}]}, 
   {EdgeForm[{RGBColor[1., 0.560784, 0.262745], Dashing[{0.005, 0.01}]}], 
    FaceForm[None], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, {
    LineBox[{{0.22841225626741, 0.177918579387187}, {0.735376044568245, 
     0.431400473537605}}], InsetBox[
     GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJmYGAQh2ImhqEEGIGAFNUMQ0Q9dhlc6nGLk6Iam26YOmQ2LuVg
iMmmhtlQdaSELi1VjwIAmf4CNw==
       "], {
       Offset[{0.5, -21.5}, {0.5, 0.5}], Offset[{23.5, 1.5}, {0.5, 0.5}]}],
      ImageSize->{24., Automatic}], {0.7452777777777777, 0.4288633333333332}, 
     Center, {0.09333333333333327, 0.09333333333333338}]}}]], "Input",
 CellID->64927037],

Cell[TextData[{
 "You can set line styles with the ",
 StyleBox[ButtonBox["Graphics Inspector",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/GraphicsInspector"], "MenuName"],
 " palette. "
}], "MathCaption",
 CellID->272206915],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[None], FaceForm[None], RectangleBox[{0, 0}, {1, 0.61803}]}, 
   {EdgeForm[{RGBColor[1., 0.560784, 0.262745], Dashing[{0.005, 0.01}]}], 
    FaceForm[None], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, 
   {FaceForm[RGBColor[1., 0.560784, 0.262745]], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{3.5, 3.5}, 
     Scaled[{0., 0.}]]], 
    RectangleBox[Offset[{0., -1.75}, Scaled[{0., 0.5}]], Offset[{3.5, 1.75}, 
     Scaled[{0., 0.5}]]], 
    RectangleBox[Offset[{0., -3.5}, Scaled[{0., 1.}]], Offset[{3.5, 0.}, 
     Scaled[{0., 1.}]]], 
    RectangleBox[Offset[{-1.75, 0.}, Scaled[{0.5, 0.}]], Offset[{1.75, 3.5}, 
     Scaled[{0.5, 0.}]]], 
    RectangleBox[Offset[{-1.75, -3.5}, Scaled[{0.5, 1.}]], Offset[{1.75, 0.}, 
     Scaled[{0.5, 1.}]]], 
    RectangleBox[Offset[{-3.5, 0.}, Scaled[{1., 0.}]], Offset[{0., 3.5}, 
     Scaled[{1., 0.}]]], 
    RectangleBox[Offset[{-3.5, -1.75}, Scaled[{1., 0.5}]], Offset[{0., 1.75}, 
     Scaled[{1., 0.5}]]], 
    RectangleBox[Offset[{-3.5, -3.5}, Scaled[{1., 1.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], 
    LineBox[{{0.22841225626741, 0.177918579387187}, {0.735376044568245, 
     0.431400473537605}}]}, {
    {EdgeForm[RGBColor[1., 0.560784, 0.262745]], FaceForm[None], 
     RectangleBox[{0.22841, 0.17792}, {0.73538, 0.4314}]}, 
    {EdgeForm[None], FaceForm[RGBColor[1., 0.560784, 0.262745]], 
     RectangleBox[Offset[{0., 0.}, {0.22841, 0.17792}], 
      Offset[{3.5, 3.5}, {0.22841, 0.17792}]], 
     RectangleBox[Offset[{0., -1.75}, {0.22841, 0.30466}], 
      Offset[{3.5, 1.75}, {0.22841, 0.30466}]], 
     RectangleBox[Offset[{0., -3.5}, {0.22841, 0.4314}], 
      Offset[{3.5, 0.}, {0.22841, 0.4314}]], 
     RectangleBox[Offset[{-1.75, 0.}, {0.48189, 0.17792}], 
      Offset[{1.75, 3.5}, {0.48189, 0.17792}]], 
     RectangleBox[Offset[{-1.75, -3.5}, {0.48189, 0.4314}], 
      Offset[{1.75, 0.}, {0.48189, 0.4314}]], 
     RectangleBox[Offset[{-3.5, 0.}, {0.73538, 0.17792}], 
      Offset[{0., 3.5}, {0.73538, 0.17792}]], 
     RectangleBox[Offset[{-3.5, -1.75}, {0.73538, 0.30466}], 
      Offset[{0., 1.75}, {0.73538, 0.30466}]], 
     RectangleBox[Offset[{-3.5, -3.5}, {0.73538, 0.4314}], 
      Offset[{0., 0.}, {0.73538, 0.4314}]]}}, 
   {RGBColor[1., 0.560784, 0.262745], 
    LineBox[{{0.22841225626741, 0.177918579387187}, {0.735376044568245, 
     0.431400473537605}}]}, InsetBox[
    GraphicsBox[
     RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 1}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {
      0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {
      0, 1}, {0, 0}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 1}, {1, 1}, {1, 
      1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {
      0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 1}, {
      0, 1}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
      1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {
      1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
      1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {
      1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 
      1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {
      1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 1}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}}, {
      Offset[{0.5, -21.5}, {0.5, 0.5}], Offset[{21.5, -0.5}, {0.5, 0.5}]}],
     ImageSize->{17., Automatic}], {0.6118568232662192, 0.29022519015660064`},
     Center, {0.09787472035794187, 0.09787472035794179}]}]], "Input",
 CellID->132683315]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Draw Line Segments Tool ",
  FontWeight->"Bold"],
 Cell[BoxData[
  GraphicsBox[RasterBox[CompressedData["
1:eJztms1OVEEQhTvRhUsXLlhociXGGGKIQfFnodwgKDAuDBFC4gYmIP7PK9xH
8VHmUeYReARIpqoXY50+g5nc+fFUMjmZ/rh9u/tWdVXf4X63t392I6W0dPW5
d/W5mcwGvTpUcXFxcXFxcXFxcfH/j0O72JiJ8YmLzzOHZvEF7TbppyL8LhvH
kM/t+twi/bD10/4mXjLmPyuEPyf8KeEsvlvyX2hsfR4R/pjwJcIVvwvBobH9
3f3rLdCO6SrQN6T/F4Q/IfzOkE8tPy6Tftj+9JJwFr+2P0zbv8TLHBqLv4dD
3ryPtX9o138A2ivz6ie5P4u/dcJZfhqzPobm67cba23r0+zFOjgl92Hx+Yzw
B4TPyPlg0Tk28nf+/LaAorgzPbb4ajqxVqfxda5/ftn3Tqz1CRk/q3/XCB+z
Ps55flS9DkDr9LvMK+covo/I+Fh8svmz873q44lwaFbfpY1Ym9q+A/+pLX5Q
/KVzNg7S/1GZN+a/zbtYsz8jY/67Srid75rdWBMZf9/jD+w/Tbd8fd6/KqCs
vmXzV33cCk9Wb/6lfr5B/vO9zGvnO0DX43Fde/zIP7+Wx5c5MlYfM/+162F9
4OuD4u/MdDPWXJ+T+gTuX2x/ZPNn9Yfq44lw+HzP4/as7PzX0vpD/9sE4/b4
9PoanO/S55H7jJr753aszX75/gOvL7aAep5H5udX9HxelXnOz3ux9j+R+7P6
V/l1Ihw+v5O4PetO3O+8zC8dg3aPb68Pkfn7I5D/KtvfYH3/jfQ/od9/4Py7
oH10/30NlOXPZcJtf5m2f4hPl0P/q0D7uPX7lzIfeH4G50+an1ryX1g//Yjb
c/3B3h+z94t6fyQ+Bv/X+jj3g7jHNzTC2/r/CLT/fIzbMz+M+5215yu+2Bzm
3wPQ7vn3IO531uYnLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLj73/BK7
q9ID
    "], {{0., 0.}, {29., 24.}}, {0., 255.},
    ColorFunction->RGBColor],
   ImageSize->{29., 24.},
   PlotRange->{{0., 29.}, {0., 24.}}]]]
}], "Subsection",
 CellID->651477065],

Cell[TextData[{
 "Click the ",
 StyleBox["Draw Line Segments", "DialogElementName"],
 " tool and drag the pointer (",
 Cell[BoxData[
  GraphicsBox[
   RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 
    1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 
    1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 1}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 
    1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 
    1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}}, {
    Offset[{0.5, -21.5}, {0.5, 0.5}], Offset[{21.5, -0.5}, {0.5, 0.5}]}],
   ImageSize->{25., 21.}]]],
 ") to draw a multi-segment line. \nYou get a new segment after each click.\n\
To stop, double click the last point or single click the first point."
}], "MathCaption",
 CellID->8151577],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[None], FaceForm[None], RectangleBox[{0, 0}, {1, 0.61803}]}, 
   {EdgeForm[{RGBColor[1., 0.560784, 0.262745], Dashing[{0.005, 0.01}]}], 
    FaceForm[None], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, {
    {Thickness[0.004], Dashing[{}], EdgeForm[None], 
     LineBox[{{0.0894962140174265, 0.499642152371409}, {0.311727405293869, 
      0.468871679733117}, {0.2946326982726, 0.116720715095108}, {
      0.619432131676599, 0.243221547052457}, {0.581823776229808, 
      0.434682265690608}, {0.797217084697724, 0.427844382882083}, {
      0.800636026101972, 0.43126332428636}}]}, 
    RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 
     1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1,
      1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 1}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 
     1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 
     0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 
     1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}}}, {
     Offset[{0.5, -21.5}, {0.759587644249901, 0.471610127337843}], 
      Offset[{21.5, -0.5}, {0.759587644249901, 
       0.471610127337843}]}]}}]], "Input",
 CellID->463000549],

Cell[TextData[{
 "You can set the line style with the ",
 StyleBox[ButtonBox["Graphics Inspector",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/GraphicsInspector"], "MenuName"],
 " palette. "
}], "MathCaption",
 CellID->270520620],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[None], FaceForm[None], RectangleBox[{0, 0}, {1, 0.61803}]}, 
   {EdgeForm[{RGBColor[1., 0.560784, 0.262745], Dashing[{0.005, 0.01}]}], 
    FaceForm[None], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, 
   {FaceForm[RGBColor[1., 0.560784, 0.262745]], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{3.5, 3.5}, 
     Scaled[{0., 0.}]]], 
    RectangleBox[Offset[{0., -1.75}, Scaled[{0., 0.5}]], Offset[{3.5, 1.75}, 
     Scaled[{0., 0.5}]]], 
    RectangleBox[Offset[{0., -3.5}, Scaled[{0., 1.}]], Offset[{3.5, 0.}, 
     Scaled[{0., 1.}]]], 
    RectangleBox[Offset[{-1.75, 0.}, Scaled[{0.5, 0.}]], Offset[{1.75, 3.5}, 
     Scaled[{0.5, 0.}]]], 
    RectangleBox[Offset[{-1.75, -3.5}, Scaled[{0.5, 1.}]], Offset[{1.75, 0.}, 
     Scaled[{0.5, 1.}]]], 
    RectangleBox[Offset[{-3.5, 0.}, Scaled[{1., 0.}]], Offset[{0., 3.5}, 
     Scaled[{1., 0.}]]], 
    RectangleBox[Offset[{-3.5, -1.75}, Scaled[{1., 0.5}]], Offset[{0., 1.75}, 
     Scaled[{1., 0.5}]]], 
    RectangleBox[Offset[{-3.5, -3.5}, Scaled[{1., 1.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, {
    {RGBColor[0, 0, 1], AbsoluteThickness[2], 
     LineBox[{{0.0894962140174265, 0.499642152371409}, {0.311727405293869, 
      0.468871679733117}, {0.2946326982726, 0.116720715095108}, {
      0.619432131676599, 0.243221547052457}, {0.581823776229808, 
      0.434682265690608}, {0.797217084697724, 0.427844382882083}, {
      0.800636026101972, 0.43126332428636}}]}, 
    {RGBColor[1., 0.560784, 0.262745], 
     LineBox[{{0.0894962140174265, 0.499642152371409}, {0.311727405293869, 
      0.468871679733117}, {0.2946326982726, 0.116720715095108}, {
      0.619432131676599, 0.243221547052457}, {0.581823776229808, 
      0.434682265690608}, {0.797217084697724, 0.427844382882083}, {
      0.800636026101972, 0.43126332428636}}]}}, {
    {EdgeForm[RGBColor[1., 0.560784, 0.262745]], FaceForm[None], 
     RectangleBox[{0.089496, 0.11672}, {0.80064, 0.49964}]}, 
    {EdgeForm[None], FaceForm[RGBColor[1., 0.560784, 0.262745]], 
     RectangleBox[Offset[{0., 0.}, {0.089496, 0.11672}], 
      Offset[{3.5, 3.5}, {0.089496, 0.11672}]], 
     RectangleBox[Offset[{0., -1.75}, {0.089496, 0.30818}], 
      Offset[{3.5, 1.75}, {0.089496, 0.30818}]], 
     RectangleBox[Offset[{0., -3.5}, {0.089496, 0.49964}], 
      Offset[{3.5, 0.}, {0.089496, 0.49964}]], 
     RectangleBox[Offset[{-1.75, 0.}, {0.44507, 0.11672}], 
      Offset[{1.75, 3.5}, {0.44507, 0.11672}]], 
     RectangleBox[Offset[{-1.75, -3.5}, {0.44507, 0.49964}], 
      Offset[{1.75, 0.}, {0.44507, 0.49964}]], 
     RectangleBox[Offset[{-3.5, 0.}, {0.80064, 0.11672}], 
      Offset[{0., 3.5}, {0.80064, 0.11672}]], 
     RectangleBox[Offset[{-3.5, -1.75}, {0.80064, 0.30818}], 
      Offset[{0., 1.75}, {0.80064, 0.30818}]], 
     RectangleBox[Offset[{-3.5, -3.5}, {0.80064, 0.49964}], 
      Offset[{0., 0.}, {0.80064, 0.49964}]]}}, InsetBox[
    GraphicsBox[
     RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 1}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {
      0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {
      0, 1}, {0, 0}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 1}, {1, 1}, {1, 
      1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {
      0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 1}, {
      0, 1}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
      1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {
      1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
      1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {
      1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 
      1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {
      1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 1}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}}, {
      Offset[{0.5, -21.5}, {0.5, 0.5}], Offset[{21.5, -0.5}, {0.5, 0.5}]}],
     ImageSize->{17., Automatic}], {0.6118568232662192, 0.15972556301267726`},
     Center, {0.09787472035794187, 0.09787472035794179}]}]], "Input",
 CellID->440960993]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Draw Point Tool ",
  FontWeight->"Bold"],
 Cell[BoxData[
  GraphicsBox[RasterBox[CompressedData["
1:eJzt10FqQjEQBuBAu/AILlqwmy5cl3aluOkF2hsU6kbBK/QoPYpH6VEU1IXF
vB8apA/9BkIW37wkDEzCe/hYvX3elFKG23G/HbdlHz+r2cmZc84555xzzjnn
nHPOOeec80v0agxC3l2jD47P09f6cH5Or0bqv3Hwl0ZP6+tffgVejfS+hf76
mrV5eQ4+3Pl/14/zc3o1Xg95p+e0TtznPfhTcP3Jr8BrkfK+Gz2e4zH4r3ui
r/XlvMX/+j6WZbevw/freVjf/yXn9Zh0540W3R73mR6fp6/14ZxzzjnnnHPO
Oeecc84555xzzjnnnPML9A0/ICi9
    "], {{0., 0.}, {29., 24.}}, {0., 255.},
    ColorFunction->RGBColor],
   ImageSize->{29., 24.},
   PlotRange->{{0., 29.}, {0., 24.}}]]]
}], "Subsection",
 CellID->132835900],

Cell[TextData[{
 "Click the ",
 StyleBox["Draw Point", "DialogElementName"],
 " tool and then click to draw a point."
}], "MathCaption",
 CellID->187210791],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[None], FaceForm[None], RectangleBox[{0, 0}, {1, 0.61803}]}, 
   {EdgeForm[{RGBColor[1., 0.560784, 0.262745], Dashing[{0.005, 0.01}]}], 
    FaceForm[None], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, 
   {FaceForm[RGBColor[1., 0.560784, 0.262745]], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{3.5, 3.5}, 
     Scaled[{0., 0.}]]], 
    RectangleBox[Offset[{0., -1.75}, Scaled[{0., 0.5}]], Offset[{3.5, 1.75}, 
     Scaled[{0., 0.5}]]], 
    RectangleBox[Offset[{0., -3.5}, Scaled[{0., 1.}]], Offset[{3.5, 0.}, 
     Scaled[{0., 1.}]]], 
    RectangleBox[Offset[{-1.75, 0.}, Scaled[{0.5, 0.}]], Offset[{1.75, 3.5}, 
     Scaled[{0.5, 0.}]]], 
    RectangleBox[Offset[{-1.75, -3.5}, Scaled[{0.5, 1.}]], Offset[{1.75, 0.}, 
     Scaled[{0.5, 1.}]]], 
    RectangleBox[Offset[{-3.5, 0.}, Scaled[{1., 0.}]], Offset[{0., 3.5}, 
     Scaled[{1., 0.}]]], 
    RectangleBox[Offset[{-3.5, -1.75}, Scaled[{1., 0.5}]], Offset[{0., 1.75}, 
     Scaled[{1., 0.5}]]], 
    RectangleBox[Offset[{-3.5, -3.5}, Scaled[{1., 1.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, InsetBox[
    GraphicsBox[
     RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 
      0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {0, 1}, {0, 1}, {1, 1}, {0, 
      0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {
      0, 1}, {1, 1}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {
      1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 1}, {0, 1}, {0, 0}, {
      0, 0}, {0, 0}, {0, 1}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 
      1}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}}, {
      Offset[{0.5, -21.5}, {0.5, 0.5}], Offset[{21.5, -0.5}, {0.5, 0.5}]}],
     ImageSize->{23., Automatic}], 
    ImageScaled[{0.5666666666666667, 0.5770918613051146}], Center, 
    ImageScaled[{0.5, 0.5}]]}]], "Input",
 CellID->219317333],

Cell[TextData[{
 "You can set point styles with the ",
 StyleBox[ButtonBox["Graphics Inspector",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/GraphicsInspector"], "MenuName"],
 "."
}], "MathCaption",
 CellID->659560258],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[None], FaceForm[None], RectangleBox[{0, 0}, {1, 0.61803}]}, 
   {EdgeForm[{RGBColor[1., 0.560784, 0.262745], Dashing[{0.005, 0.01}]}], 
    FaceForm[None], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, 
   {FaceForm[RGBColor[1., 0.560784, 0.262745]], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{3.5, 3.5}, 
     Scaled[{0., 0.}]]], 
    RectangleBox[Offset[{0., -1.75}, Scaled[{0., 0.5}]], Offset[{3.5, 1.75}, 
     Scaled[{0., 0.5}]]], 
    RectangleBox[Offset[{0., -3.5}, Scaled[{0., 1.}]], Offset[{3.5, 0.}, 
     Scaled[{0., 1.}]]], 
    RectangleBox[Offset[{-1.75, 0.}, Scaled[{0.5, 0.}]], Offset[{1.75, 3.5}, 
     Scaled[{0.5, 0.}]]], 
    RectangleBox[Offset[{-1.75, -3.5}, Scaled[{0.5, 1.}]], Offset[{1.75, 0.}, 
     Scaled[{0.5, 1.}]]], 
    RectangleBox[Offset[{-3.5, 0.}, Scaled[{1., 0.}]], Offset[{0., 3.5}, 
     Scaled[{1., 0.}]]], 
    RectangleBox[Offset[{-3.5, -1.75}, Scaled[{1., 0.5}]], Offset[{0., 1.75}, 
     Scaled[{1., 0.5}]]], 
    RectangleBox[Offset[{-3.5, -3.5}, Scaled[{1., 1.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, 
   {RGBColor[0., 0.2635233081559472, 0.8], AbsolutePointSize[8.5], 
    PointBox[{{0.6071961222967934, 0.3036247054436987}}]}, 
   {EdgeForm[RGBColor[1., 0.560784, 0.262745]], FaceForm[None], 
    DiskBox[{0.6071961222967934, 0.3036247054436987}, 0.02]}, {
    {EdgeForm[RGBColor[1., 0.560784, 0.262745]], FaceForm[None], 
     RectangleBox[{0.5721961222967934, 0.26862470544369865`}, \
{0.6421961222967935, 0.3386247054436987}]}, 
    {EdgeForm[None], FaceForm[RGBColor[1., 0.560784, 0.262745]], 
     RectangleBox[Offset[{0, 0}, {0.5721961222967934, 0.26862470544369865`}], 
      Offset[{3.5, 3.5}, {0.5721961222967934, 0.26862470544369865`}]], 
     RectangleBox[
      Offset[{0, -1.75}, {0.5721961222967934, 0.3036247054436987}], 
      Offset[{3.5, 1.75}, {0.5721961222967934, 0.3036247054436987}]], 
     RectangleBox[Offset[{0, -3.5}, {0.5721961222967934, 0.3386247054436987}],
       Offset[{3.5, 0}, {0.5721961222967934, 0.3386247054436987}]], 
     RectangleBox[
      Offset[{-1.75, 0}, {0.6071961222967934, 0.26862470544369865`}], 
      Offset[{1.75, 3.5}, {0.6071961222967934, 0.26862470544369865`}]], 
     RectangleBox[
      Offset[{-1.75, -3.5}, {0.6071961222967934, 0.3386247054436987}], 
      Offset[{1.75, 0}, {0.6071961222967934, 0.3386247054436987}]], 
     RectangleBox[
      Offset[{-3.5, 0}, {0.6421961222967935, 0.26862470544369865`}], 
      Offset[{0, 3.5}, {0.6421961222967935, 0.26862470544369865`}]], 
     RectangleBox[
      Offset[{-3.5, -1.75}, {0.6421961222967935, 0.3036247054436987}], 
      Offset[{0, 1.75}, {0.6421961222967935, 0.3036247054436987}]], 
     RectangleBox[
      Offset[{-3.5, -3.5}, {0.6421961222967935, 0.3386247054436987}], 
      Offset[{0, 0}, {0.6421961222967935, 0.3386247054436987}]]}, 
    {RGBColor[1., 0.560784, 0.262745], 
     LineBox[{Offset[{0, -1.75}, {0.6071961222967934, 0.3036247054436987}], 
       Offset[{0, 1.75}, {0.6071961222967934, 0.3036247054436987}]}], 
     LineBox[{Offset[{-1.75, 0}, {0.6071961222967934, 0.3036247054436987}], 
       Offset[{1.75, 0}, {0.6071961222967934, 0.3036247054436987}]}]}}, 
   InsetBox[
    GraphicsBox[
     RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 1}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {
      0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {
      0, 1}, {0, 0}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 1}, {1, 1}, {1, 
      1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {
      0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 1}, {
      0, 1}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
      1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {
      1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
      1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {
      1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 
      1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {
      1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 1}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}}, {
      Offset[{0.5, -21.5}, {0.5, 0.5}], Offset[{21.5, -0.5}, {0.5, 0.5}]}],
     ImageSize->{17., Automatic}], 
    ImageScaled[{0.6066666666666667, 0.48598329794452466`}], Center, 
    ImageScaled[{0.5, 0.5}]]}]], "Input",
 CellID->341284373]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Place Text",
  FontWeight->"Bold"],
 " ",
 StyleBox["Tool ",
  FontWeight->"Bold"],
 Cell[BoxData[
  GraphicsBox[RasterBox[CompressedData["
1:eJzt2k9Kw1AQgPGALly6cNGFQhURERFR9+YIIoKioFUR3fUKHsWj9Cg9gkew
hLjr5AtNw0vab6C8xe81/zrz3rS6/za+/djIsmwwe+3NXptZGdNxPnfUdV3X
dV3XdV3XdV3X9T54HDBvB3wAvg3+e93Mt+D4dH10f/R8mj6/3Y57zeeTOr/7
7mFQfh+Dn4MfgdP5Kf8Pwen6TsBpfaH8PQO/6rjT9Zf3nzq/++5xwLwD8Atw
+nxpfyM/Bb8Ep/WH1g/rsxhS53ffPYrpJ8z7qvbvZ3g/1S/sb/kTnJ+uD/y/
v1t4fYPj5+Cjjjv2J+X6lTq/V92jwPq9B6f6hP0tv6v2H8qvG/Ca638YDfO/
6frStrt/dsOjyB+r5w3p83+A84Dnr3B8yq+a/evC9Wl/Wwyp83fdPYyW+zuq
v8l7tWdD8PL34a7ef2q3v+2HR4H9L9UH9LfYv1J/vaT1PQz722JInZ/r7mFQ
fdD+Av0z5k/Nv9+0dv/2t8WQOj/1ao+C9lf6/pqP4DxUHzX717b2T3K6/9Tu
/yeshofxUj2P6ncCv98uq/7aWn/64qnzR0/rYYzmv69r16/ruq7ruq7ruq7r
uq7ruq7ruq7rK+J/XEjlWQ==
    "], {{0., 0.}, {29., 24.}}, {0., 255.},
    ColorFunction->RGBColor],
   ImageSize->{29., 24.},
   PlotRange->{{0., 29.}, {0., 24.}}]]]
}], "Subsection",
 CellID->9065006],

Cell[TextData[{
 "You can place text in a graphics with the ",
 StyleBox["Place Text", "DialogElementName"],
 " tool."
}], "MathCaption",
 CellID->64777274],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[None], FaceForm[None], RectangleBox[{0, 0}, {1, 0.61803}]}, 
   {EdgeForm[{RGBColor[1., 0.560784, 0.262745], Dashing[{0.005, 0.01}]}], 
    FaceForm[None], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, 
   {FaceForm[RGBColor[1., 0.560784, 0.262745]], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{3.5, 3.5}, 
     Scaled[{0., 0.}]]], 
    RectangleBox[Offset[{0., -1.75}, Scaled[{0., 0.5}]], Offset[{3.5, 1.75}, 
     Scaled[{0., 0.5}]]], 
    RectangleBox[Offset[{0., -3.5}, Scaled[{0., 1.}]], Offset[{3.5, 0.}, 
     Scaled[{0., 1.}]]], 
    RectangleBox[Offset[{-1.75, 0.}, Scaled[{0.5, 0.}]], Offset[{1.75, 3.5}, 
     Scaled[{0.5, 0.}]]], 
    RectangleBox[Offset[{-1.75, -3.5}, Scaled[{0.5, 1.}]], Offset[{1.75, 0.}, 
     Scaled[{0.5, 1.}]]], 
    RectangleBox[Offset[{-3.5, 0.}, Scaled[{1., 0.}]], Offset[{0., 3.5}, 
     Scaled[{1., 0.}]]], 
    RectangleBox[Offset[{-3.5, -1.75}, Scaled[{1., 0.5}]], Offset[{0., 1.75}, 
     Scaled[{1., 0.5}]]], 
    RectangleBox[Offset[{-3.5, -3.5}, Scaled[{1., 1.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, InsetBox[
    GraphicsBox[{{}, {}, 
      {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl2Xk4VN//AHBrlsTMHUKlaF9ISmnB+1S2IqWkTQgVkrWEpFIJSUIq2VKW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        "]]}},
     AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
     Axes->True,
     AxesOrigin->{0, 0},
     PlotRange->
      NCache[{{0, 2 Pi}, {-0.9999998592131705, 0.9999998782112116}}, {{
        0, 6.283185307179586}, {-0.9999998592131705, 0.9999998782112116}}],
     PlotRangeClipping->True,
     PlotRangePadding->{
       Scaled[0.02], 
       Scaled[0.02]}], ImageScaled[{0.5, 0.5}], Center, ImageScaled[{1, 1}]], 
   InsetBox[
    GraphicsBox[
     RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      1}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 1}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 0}, {0, 
      1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 0}, {0, 
      0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 1}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}}, {{0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {
      0, 0}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 1}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}}, {
      Offset[{0.5, -21.5}, {0.5, 0.5}], Offset[{21.5, -0.5}, {0.5, 0.5}]}],
     ImageSize->{25., Automatic}], 
    ImageScaled[{0.5488888888888889, 0.878450955497835}], Center, 
    ImageScaled[{0.5, 0.5}]]}]], "Input",
 CellID->496144061],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[None], FaceForm[None], RectangleBox[{0, 0}, {1, 0.61803}]}, 
   {FaceForm[RGBColor[1., 0.560784, 0.262745]], 
    RectangleBox[Offset[{-3.5, -1.75}, Scaled[{1., 0.5}]], Offset[{0., 1.75}, 
     Scaled[{1., 0.5}]]]}, InsetBox[
    GraphicsBox[{{}, {}, 
      {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl2Xk4VN//AHBrlsTMHUKlaF9ISmnB+1S2IqWkTQgVkrWEpFIJSUIq2VKW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        "]]}},
     AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
     Axes->True,
     AxesOrigin->{0, 0},
     PlotRange->
      NCache[{{0, 2 Pi}, {-0.9999998592131705, 0.9999998782112116}}, {{
        0, 6.283185307179586}, {-0.9999998592131705, 0.9999998782112116}}],
     PlotRangeClipping->True,
     PlotRangePadding->{
       Scaled[0.02], 
       Scaled[0.02]}], ImageScaled[{0.5, 0.5}], Center, 
    ImageScaled[{1, 1}]], 
   {GrayLevel[0], AbsolutePointSize[3], AbsoluteThickness[0.5], Opacity[1], 
    Dashing[{}], Arrowheads[0.04], EdgeForm[None], InsetBox[
     RowBox[{
     "Sine", " ", 
      "Curve"}], {0.5978747203579418, 0.5086955480984345}, {-1., 0.}]}, 
   {GrayLevel[0], AbsolutePointSize[3], AbsoluteThickness[0.5], Opacity[1], 
    Dashing[{}], Arrowheads[0.04], EdgeForm[None], 
    InsetBox["", {0.3322147651006711, 0.3129461073825506}, {-1., 0.}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    LineBox[{{0.8022693452380951, 0.5364209970238086}, {0.8022693452380951, 
     0.49549837797618945`}}]}},
  Epilog->{}]], "Input",
 CellID->216695530]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Place TraditionalForm Text",
  FontWeight->"Bold"],
 " ",
 StyleBox["Tool ",
  FontWeight->"Bold"],
 Cell[BoxData[
  GraphicsBox[RasterBox[CompressedData["
1:eJzt2k9Kw0AUgPGALnoAF10oVBEXIuJ/3ZmFIG4EFXRbqlV3vUKO0qN4lB7B
I1hs3XXmE4Y6ifkehCx+w2TSvGFeMt0cjO6HK0VRdKfHxvRYLeYxGZULz7qu
67qu67qu67qu67r+Hzwc0K4L3gPfSnTqn8ZH90e+Br5ec6fxz+8/d3623YNB
z+8A/Az8HPwisf89cLo/8n3wk5o7jX9+/7nzs+0eDMrPI3CaXzQ/af4dg++C
Oz/j7vyshQfjPd6O+lm292B8v63fggH9l+D9mnuxDd6Zee78bLuHYvIG7eD5
V7czr14Xn2kc5WPcP/pxLz4v0zwx/6uau+tnMzwYp/F25XPccX2j+hjy52f+
Z6vvrW/1GngwruLtqP6rHuA6O+Ad8CWvn9a3hf4HHg5oB8+X8mM8hP5T9wdo
f4Xmt/Xt9yl3frbdgwH5X93EfUzrzx2Mg9ZP+j7r99u4Oz8b4cG4jrej+m48
gOscgkP+lFQfp+5/0voDTu/fud3/JzTDg5GYn/h+CfVr9RT33gv0n7i/Qt+v
m+K580tP81DUJb/Ic/9+uq7ruq7ruq7ruq7ruq7ruq7rut4Q/wL7KdBg
    "], {{0., 0.}, {29., 24.}}, {0., 255.},
    ColorFunction->RGBColor],
   ImageSize->{29., 24.},
   PlotRange->{{0., 29.}, {0., 24.}}]]]
}], "Subsection",
 CellID->25770655],

Cell[TextData[{
 "You can place ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " text in a graphics with the ",
 StyleBox["Place TraditionalForm Text", "DialogElementName"],
 " tool."
}], "MathCaption",
 CellID->591485334],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[None], FaceForm[None], RectangleBox[{0, 0}, {1, 0.61803}]}, 
   {EdgeForm[{RGBColor[1., 0.560784, 0.262745], Dashing[{0.005, 0.01}]}], 
    FaceForm[None], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, 
   {FaceForm[RGBColor[1., 0.560784, 0.262745]], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{3.5, 3.5}, 
     Scaled[{0., 0.}]]], 
    RectangleBox[Offset[{0., -1.75}, Scaled[{0., 0.5}]], Offset[{3.5, 1.75}, 
     Scaled[{0., 0.5}]]], 
    RectangleBox[Offset[{0., -3.5}, Scaled[{0., 1.}]], Offset[{3.5, 0.}, 
     Scaled[{0., 1.}]]], 
    RectangleBox[Offset[{-1.75, 0.}, Scaled[{0.5, 0.}]], Offset[{1.75, 3.5}, 
     Scaled[{0.5, 0.}]]], 
    RectangleBox[Offset[{-1.75, -3.5}, Scaled[{0.5, 1.}]], Offset[{1.75, 0.}, 
     Scaled[{0.5, 1.}]]], 
    RectangleBox[Offset[{-3.5, 0.}, Scaled[{1., 0.}]], Offset[{0., 3.5}, 
     Scaled[{1., 0.}]]], 
    RectangleBox[Offset[{-3.5, -1.75}, Scaled[{1., 0.5}]], Offset[{0., 1.75}, 
     Scaled[{1., 0.5}]]], 
    RectangleBox[Offset[{-3.5, -3.5}, Scaled[{1., 1.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, InsetBox[
    GraphicsBox[{{}, {}, 
      {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl2Xk4VN//AHBrlsTMHUKlaF9ISmnB+1S2IqWkTQgVkrWEpFIJSUIq2VKW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        "]]}},
     AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
     Axes->True,
     AxesOrigin->{0, 0},
     PlotRange->
      NCache[{{0, 2 Pi}, {-0.9999998592131705, 0.9999998782112116}}, {{
        0, 6.283185307179586}, {-0.9999998592131705, 0.9999998782112116}}],
     PlotRangeClipping->True,
     PlotRangePadding->{
       Scaled[0.02], 
       Scaled[0.02]}], ImageScaled[{0.5, 0.5}], Center, ImageScaled[{1, 1}]], 
   InsetBox[
    GraphicsBox[{
      RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
       0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
        0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 
       0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
        0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
       0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
       0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
       1}, {0, 1}, {0, 1}, {0, 1}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {
       0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
       1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 0}, {0, 0}, {0, 0}}, {{
       0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
       0}, {0, 1}, {0, 0}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
        0}, {0, 1}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
       0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 0}, {0, 0}, {0,
        0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 0}, {0, 0}, {0, 0}}, {{0, 
       0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
        0}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 1}, {
       0, 1}, {0, 1}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
       0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0,
        0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
       0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
        1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
       0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
       0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
        0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 
       0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 1}, {0, 1}, {0,
        1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
       0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
       0}, {0, 0}, {0, 0}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
        0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 
       0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 0}, {0,
        0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
       0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
       0, 0}, {0, 0}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
       0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {
       0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 0}, {0, 
       0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{
       0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
       0}, {0, 0}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
        0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
       0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 0}, {0, 0}, {0,
        0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 
       0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
        1}, {0, 0}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
       0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
       0}, {0, 0}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 1}, {0,
        0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
       0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
        0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
       0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
       0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
        0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}}, {
       Offset[{0.5, -21.5}, {0.5, 0.5}], Offset[{21.5, -0.5}, {0.5, 0.5}]}], 
      InsetBox[
       TagBox["",
        HoldForm], {0.6109853760445682, 0.5438324048282266}, {-1., 0.}]},
     ImageSize->{21., Automatic}], 
    ImageScaled[{0.7844444444444444, 0.9275094126919998}], Center, 
    ImageScaled[{0.5, 0.5}]]}]], "Input",
 CellID->226293590],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[None], FaceForm[None], RectangleBox[{0, 0}, {1, 0.61803}]}, 
   InsetBox[
    GraphicsBox[{{}, {}, 
      {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl2Xk4VN//AHBrlsTMHUKlaF9ISmnB+1S2IqWkTQgVkrWEpFIJSUIq2VKW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        "]]}},
     AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
     Axes->True,
     AxesOrigin->{0, 0},
     PlotRange->
      NCache[{{0, 2 Pi}, {-0.9999998592131705, 0.9999998782112116}}, {{
        0, 6.283185307179586}, {-0.9999998592131705, 0.9999998782112116}}],
     PlotRangeClipping->True,
     PlotRangePadding->{
       Scaled[0.02], 
       Scaled[0.02]}], ImageScaled[{0.5, 0.5}], Center, 
    ImageScaled[{1, 1}]], {
    {GrayLevel[0], AbsolutePointSize[3], AbsoluteThickness[0.5], Opacity[1], 
     Dashing[{}], Arrowheads[0.04], EdgeForm[None], InsetBox[
      TagBox[
       RowBox[{"y", "=", 
        RowBox[{"Sin", "(", "x", ")"}]}],
       HoldForm], {0.5908940722541814, 0.4860742416373717}, {-1., 0.}]}, 
    {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
     LineBox[{{0.7743155427719185, 0.5085504213606585}, {0.7743155427719185, 
      0.46762780231303935`}}]}}}]], "Input",
 CellID->257964831]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Draw Rectangle Tool ",
  FontWeight->"Bold"],
 Cell[BoxData[
  GraphicsBox[RasterBox[CompressedData["
1:eJzt2sFNAzEQhWFLoQgOQYKtgUMQlwgJCqAChMg5LaSUlEIpKYVIbG6M3+HF
GuP9R1rl8FmbjT2z9m788Ll/361KKbfn4+583JQ5Tvvtn584juM4juM4jvfn
cYh2a+ETnupqfObxzc4/vO5hqPF9FP6Mp7oan3l8s/MPr3sYk2in8uMFT3U1
PtOvZ+cfXvcovr/q7U6mb3d1/xBeTG/9+5S716ec+hzDo5D59Vb3w6vn6vzu
92ef3+0f6nMZHoWqT5mfm8H9yXRxftW/8v5JfQ7hUaj7s6xPN3/N/E536hO/
gkdhz5//vb4a1590sT5mfbsMj2L49W3v9w9Rn8yfy/Aw1PtR9X4lO7+Tnx9d
5/0QXg1Rn/b86eZ/7/Mf61v8Ch5F9+vb1vWZfP+Q/avWN9TnEB5G6/kz23uf
f93nT/b3DeFR2P+vJO9fyN6f0Pr6ZX2yP34Ij8LdX3Yv5l/lav+fuz9Q+cH0
o/n9qn9kfV7adZ5/OI7jOI7jOI7jOI7jOI7j+HD+Azlo+ec=
    "], {{0., 0.}, {29., 24.}}, {0., 255.},
    ColorFunction->RGBColor],
   ImageSize->{29., 24.},
   PlotRange->{{0., 29.}, {0., 24.}}]]]
}], "Subsection",
 CellID->389836818],

Cell[TextData[{
 "Click the ",
 StyleBox["Draw Rectangle", "DialogElementName"],
 " tool and drag the pointer (",
 Cell[BoxData[
  GraphicsBox[
   RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 
    1}, {1, 1}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 
    1}, {1, 1}, {1, 1}, {0, 1}, {1, 1}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {1, 1}, {0, 1}, {1, 1}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 
    1}, {1, 1}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 
    1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {0, 
    1}, {0, 1}, {0, 1}, {0, 1}, {1, 1}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 
    0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    1}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 1}, {0, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {1, 
    1}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 
    1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}}, {
    Offset[{0.5, -21.5}, {0.5, 0.5}], Offset[{21.5, -0.5}, {0.5, 0.5}]}],
   ImageSize->{22., Automatic}]]],
 ") to draw a rectangle.\nHold the ",
 StyleBox["Shift", "KeyEvent"],
 " key to draw squares."
}], "MathCaption",
 CellID->247403007],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[None], FaceForm[None], RectangleBox[{0, 0}, {1, 0.61803}]}, 
   {EdgeForm[{RGBColor[1., 0.560784, 0.262745], Dashing[{0.005, 0.01}]}], 
    FaceForm[None], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, {
    RectangleBox[{0.1532, 0.44811}, {0.79666, 0.15842}], 
    RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}}, {{0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 
     1}, {1, 1}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 
     1}, {1, 1}, {1, 1}, {0, 1}, {1, 1}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {1, 1}, {0, 1}, {1, 1}}, {{0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 
     1}, {1, 1}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1,
      1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {0, 
     1}, {0, 1}, {0, 1}, {0, 1}, {1, 1}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}}, {{0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0,
      0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      1}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 1}, {0, 1}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0,
      0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {1, 
     1}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1,
      1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}}}, {
     Offset[{0.5, -21.5}, {0.759587644249901, 0.493894249900517}], 
      Offset[{21.5, -0.5}, {0.759587644249901, 
       0.493894249900517}]}]}}]], "Input",
 CellID->12673107],

Cell[TextData[{
 "You can set face and edge styles with the ",
 StyleBox[ButtonBox["Graphics Inspector",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/GraphicsInspector"], "MenuName"],
 " palette."
}], "MathCaption",
 CellID->111120728],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[None], FaceForm[None], RectangleBox[{0, 0}, {1, 0.61803}]}, 
   {EdgeForm[{RGBColor[1., 0.560784, 0.262745], Dashing[{0.005, 0.01}]}], 
    FaceForm[None], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, 
   {FaceForm[RGBColor[1., 0.560784, 0.262745]], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{3.5, 3.5}, 
     Scaled[{0., 0.}]]], 
    RectangleBox[Offset[{0., -1.75}, Scaled[{0., 0.5}]], Offset[{3.5, 1.75}, 
     Scaled[{0., 0.5}]]], 
    RectangleBox[Offset[{0., -3.5}, Scaled[{0., 1.}]], Offset[{3.5, 0.}, 
     Scaled[{0., 1.}]]], 
    RectangleBox[Offset[{-1.75, 0.}, Scaled[{0.5, 0.}]], Offset[{1.75, 3.5}, 
     Scaled[{0.5, 0.}]]], 
    RectangleBox[Offset[{-1.75, -3.5}, Scaled[{0.5, 1.}]], Offset[{1.75, 0.}, 
     Scaled[{0.5, 1.}]]], 
    RectangleBox[Offset[{-3.5, 0.}, Scaled[{1., 0.}]], Offset[{0., 3.5}, 
     Scaled[{1., 0.}]]], 
    RectangleBox[Offset[{-3.5, -1.75}, Scaled[{1., 0.5}]], Offset[{0., 1.75}, 
     Scaled[{1., 0.5}]]], 
    RectangleBox[Offset[{-3.5, -3.5}, Scaled[{1., 1.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, 
   {RGBColor[0.490196078431373, 0.823529411764706, 0.156862745098039], 
    EdgeForm[RGBColor[1., 0.560784, 0.262745]], 
    StyleBox[RectangleBox[{0.1532, 0.44811}, {0.79666, 0.15842}],
     FontColor->RGBColor[0, 1, 0]]}, {
    {EdgeForm[None], FaceForm[RGBColor[1., 0.560784, 0.262745]], 
     RectangleBox[Offset[{0., 0.}, {0.1532, 0.15842}], 
      Offset[{3.5, 3.5}, {0.1532, 0.15842}]], 
     RectangleBox[Offset[{0., -1.75}, {0.1532, 0.30327}], 
      Offset[{3.5, 1.75}, {0.1532, 0.30327}]], 
     RectangleBox[Offset[{0., -3.5}, {0.1532, 0.44811}], 
      Offset[{3.5, 0.}, {0.1532, 0.44811}]], 
     RectangleBox[Offset[{-1.75, 0.}, {0.47493, 0.15842}], 
      Offset[{1.75, 3.5}, {0.47493, 0.15842}]], 
     RectangleBox[Offset[{-1.75, -3.5}, {0.47493, 0.44811}], 
      Offset[{1.75, 0.}, {0.47493, 0.44811}]], 
     RectangleBox[Offset[{-3.5, 0.}, {0.79666, 0.15842}], 
      Offset[{0., 3.5}, {0.79666, 0.15842}]], 
     RectangleBox[Offset[{-3.5, -1.75}, {0.79666, 0.30327}], 
      Offset[{0., 1.75}, {0.79666, 0.30327}]], 
     RectangleBox[Offset[{-3.5, -3.5}, {0.79666, 0.44811}], 
      Offset[{0., 0.}, {0.79666, 0.44811}]]}, 
    {RGBColor[1., 0.560784, 0.262745], 
     LineBox[{Offset[{0, -1.75}, {0.47493, 0.303265}], 
       Offset[{0, 1.75}, {0.47493, 0.303265}]}], 
     LineBox[{Offset[{-1.75, 0}, {0.47493, 0.303265}], 
       Offset[{1.75, 0}, {0.47493, 0.303265}]}]}}, InsetBox[
    GraphicsBox[
     RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 1}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {
      0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {
      0, 1}, {0, 0}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 1}, {1, 1}, {1, 
      1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {
      0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 1}, {
      0, 1}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
      1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {
      1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
      1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {
      1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 
      1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {
      1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 1}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}}, {
      Offset[{0.5, -21.5}, {0.5, 0.5}], Offset[{21.5, -0.5}, {0.5, 0.5}]}],
     ImageSize->{17., Automatic}], {0.6957494407158836, 0.22031467561521265`},
     Center, {0.09787472035794176, 0.09787472035794181}]}]], "Input",
 CellID->58099304]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Draw Polygon Tool ",
  FontWeight->"Bold"],
 Cell[BoxData[
  GraphicsBox[RasterBox[CompressedData["
1:eJzt291KG0EUwPGBeuFlL7zwQiENIlJE0GJBq2QMSFHBjwhtaStuo/HjKq8w
j5JHmUfJI/gIBtzeuecP2d2c3c05EHLxS2aXcM7M7MzkU3/YG3xwzi1PXquT
14JLYzz0776bm5ub5/XGxktH+w5qEdr5Zy57fcPLvJzTF8EbUv/a+Wcue22D
6msb/Av4JngbfAX8Izj1PwX1D9r5Zy57dcPL/Bn8ANyDH4LvgX8F3wHfAG+D
FzQ/0M7PeffKxpkXeTSQPf6V3fVkD13wI3Cq/w449S/UP+yCb4G3wNP61s7f
pntVI/7zoodb2VuJ7MmD7PFJdncnu/8je7iC9rvwfegfcH5A9U/z/3T+rp2/
TXe1gP4/3stO+YvjE+UvtB9h/I3Qf9D4Hx5lT6B/cDfQPsxP3D74GrjNjwtx
rYjXXvQA4yfWV17PW9952+/KHqB/GMPv5/tw/W/g6+BWn4V4aQHriyOYf/of
sqvXH31fuf1wKvuYxl+rz0p4aQHrqzh/PQYvuz5qXp/0+wV4/s5dn+n6u3Z+
193LinAB16H+u+71UXb7Oa+f0PoX7S/R/o/VZyE+ddD+OKyPxN9wH1Uf37Sf
X3Ne39P4Se1bfc7Epw7Y305offIE7kN5fKl7/ZGPqD6pfVu/nYlPHd/ldjw9
X1Z8/lf5+yu7Pun809Kba+dv0z0zaP5K53Ngfque/9r1U/b6LZxfwPqk88c2
Ps7Es0P+3BjGRw/7m1XPfzrf5y/Bf4FD/xX6sjt4fqDzUeT/z/dq5+e8e2bQ
/IbW/85lp/oNkN90vi/pg0P/Eun5Gdaf6fwQ7u/C/iWer6Xz72lo55+57FkR
4Pxo8iw7PX9S/oafsjsYv3B8pf9/zUlo55+57JlB/0+y/G5EaOefubm5ubm5
ubm5ubm5uXnN/RWYPkKj
    "], {{0., 0.}, {29., 24.}}, {0., 255.},
    ColorFunction->RGBColor],
   ImageSize->{29., 24.},
   PlotRange->{{0., 29.}, {0., 24.}}]]]
}], "Subsection",
 CellID->120316707],

Cell[TextData[{
 "Click the ",
 StyleBox["Draw Polygon", "DialogElementName"],
 " tool and drag the pointer (",
 Cell[BoxData[
  GraphicsBox[
   RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 
    1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 
    1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 1}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 
    1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 
    1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}}, {
    Offset[{0.5, -21.5}, {0.5, 0.5}], Offset[{21.5, -0.5}, {0.5, 0.5}]}],
   ImageSize->{25., 21.}]]],
 ") to draw a polygon.\nYou get a new segment after each click. \nTo stop, \
double-click the last point or single-click the first point. "
}], "MathCaption",
 CellID->627144804],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[None], FaceForm[None], RectangleBox[{0, 0}, {1, 0.61803}]}, 
   {EdgeForm[{RGBColor[1., 0.560784, 0.262745], Dashing[{0.005, 0.01}]}], 
    FaceForm[None], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, {
    PolygonBox[{{0.225752915006442, 0.369747107322225}, {0.793139308915782, 
     0.42750500370815}, {0.299759835950889, 0.0775601020755384}, {
     0.472442651488825, 0.345964444104238}, {0.307982827167236, 
     0.261026361183605}, {0.26908465622552, 0.277168405917935}}], 
    RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 
     1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1,
      1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 1}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 
     1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 
     0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 
     1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0,
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
     0}, {0, 0}}}, {
     Offset[{0.5, -21.5}, {0.752909868682849, 0.473288897731795}], 
      Offset[{21.5, -0.5}, {0.752909868682849, 
       0.473288897731795}]}]}}]], "Input",
 CellID->278576511],

Cell[TextData[{
 "You can set face and edge styles with the ",
 StyleBox[ButtonBox["Graphics Inspector",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/GraphicsInspector"], "MenuName"],
 " palette."
}], "MathCaption",
 CellID->310238965],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[None], FaceForm[None], RectangleBox[{0, 0}, {1, 0.61803}]}, 
   {EdgeForm[{RGBColor[1., 0.560784, 0.262745], Dashing[{0.005, 0.01}]}], 
    FaceForm[None], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, 
   {FaceForm[RGBColor[1., 0.560784, 0.262745]], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{3.5, 3.5}, 
     Scaled[{0., 0.}]]], 
    RectangleBox[Offset[{0., -1.75}, Scaled[{0., 0.5}]], Offset[{3.5, 1.75}, 
     Scaled[{0., 0.5}]]], 
    RectangleBox[Offset[{0., -3.5}, Scaled[{0., 1.}]], Offset[{3.5, 0.}, 
     Scaled[{0., 1.}]]], 
    RectangleBox[Offset[{-1.75, 0.}, Scaled[{0.5, 0.}]], Offset[{1.75, 3.5}, 
     Scaled[{0.5, 0.}]]], 
    RectangleBox[Offset[{-1.75, -3.5}, Scaled[{0.5, 1.}]], Offset[{1.75, 0.}, 
     Scaled[{0.5, 1.}]]], 
    RectangleBox[Offset[{-3.5, 0.}, Scaled[{1., 0.}]], Offset[{0., 3.5}, 
     Scaled[{1., 0.}]]], 
    RectangleBox[Offset[{-3.5, -1.75}, Scaled[{1., 0.5}]], Offset[{0., 1.75}, 
     Scaled[{1., 0.5}]]], 
    RectangleBox[Offset[{-3.5, -3.5}, Scaled[{1., 1.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, {
    {RGBColor[0.349019607843137, 0.709803921568627, 0.647058823529412], 
     AbsoluteThickness[2], EdgeForm[{RGBColor[0, 0, 1], AbsoluteThickness[
     2]}], PolygonBox[{{0.225752915006442, 0.369747107322225}, {
      0.793139308915782, 0.42750500370815}, {0.299759835950889, 
      0.0775601020755384}, {0.472442651488825, 0.345964444104238}, {
      0.307982827167236, 0.261026361183605}, {0.26908465622552, 
      0.277168405917935}}]}, 
    {EdgeForm[RGBColor[1., 0.560784, 0.262745]], FaceForm[None], 
     RectangleBox[{0.22575, 0.07756}, {0.79314, 0.42751}]}, 
    {EdgeForm[RGBColor[1., 0.560784, 0.262745]], FaceForm[None], 
     PolygonBox[{{0.225752915006442, 0.369747107322225}, {0.793139308915782, 
      0.42750500370815}, {0.299759835950889, 0.0775601020755384}, {
      0.472442651488825, 0.345964444104238}, {0.307982827167236, 
      0.261026361183605}, {0.26908465622552, 0.277168405917935}}]}}, 
   {EdgeForm[None], FaceForm[RGBColor[1., 0.560784, 0.262745]], 
    RectangleBox[Offset[{0., 0.}, {0.22575, 0.07756}], 
     Offset[{3.5, 3.5}, {0.22575, 0.07756}]], 
    RectangleBox[Offset[{0., -1.75}, {0.22575, 0.25254}], 
     Offset[{3.5, 1.75}, {0.22575, 0.25254}]], 
    RectangleBox[Offset[{0., -3.5}, {0.22575, 0.42751}], 
     Offset[{3.5, 0.}, {0.22575, 0.42751}]], 
    RectangleBox[Offset[{-1.75, 0.}, {0.50944, 0.07756}], 
     Offset[{1.75, 3.5}, {0.50944, 0.07756}]], 
    RectangleBox[Offset[{-1.75, -3.5}, {0.50944, 0.42751}], 
     Offset[{1.75, 0.}, {0.50944, 0.42751}]], 
    RectangleBox[Offset[{-3.5, 0.}, {0.79314, 0.07756}], 
     Offset[{0., 3.5}, {0.79314, 0.07756}]], 
    RectangleBox[Offset[{-3.5, -1.75}, {0.79314, 0.25254}], 
     Offset[{0., 1.75}, {0.79314, 0.25254}]], 
    RectangleBox[Offset[{-3.5, -3.5}, {0.79314, 0.42751}], 
     Offset[{0., 0.}, {0.79314, 0.42751}]]}, InsetBox[
    GraphicsBox[
     RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 1}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {
      0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {
      0, 1}, {0, 0}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 1}, {1, 1}, {1, 
      1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {
      0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 1}, {
      0, 1}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
      1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {
      1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
      1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {
      1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 
      1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {
      1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 1}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}}, {
      Offset[{0.5, -21.5}, {0.5, 0.5}], Offset[{21.5, -0.5}, {0.5, 0.5}]}],
     ImageSize->{17., Automatic}], {0.6351603281133482, 0.2948858911260255}, 
    Center, {0.09787472035794176, 0.09787472035794181}]}]], "Input",
 CellID->88565]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Draw Circle Tool ",
  FontWeight->"Bold"],
 Cell[BoxData[
  GraphicsBox[RasterBox[CompressedData["
1:eJzt2jtOxDAQxnFLUFBSUFCAtEiIigYkJJ7CQAXiuVCAaMKbAsQVchSOkqPs
ETgCFCnx/BGRmYR8I622+CWx44zjxPHc7dvwYSyEMP31m/36jYc6Rm/x23+5
XC6Xy+VyuVzePm9vRJsnwafBB5mdyqf60/n/UXjnZ989W3xs2z4VbV8AXwJf
AV8DX2+4P5VP9afzp/aj9v9heOdn3/3XQdd/BsqB/C+Htr8XtldPthcvto9g
/3ADfgG+B079n/o3tf8P+693fvbdk0HXD57fykPbBw/g97bHayj/BHyn4f5Q
foT6l3D+5ZntYQt8GZyev+vr752fffdkTMB2p7YX1L9ofNkGj5mdym/odP4V
tB+Oz5vgi+D19ffOz757Mjbs7UZ0/4fxM3v/a9q/nPsvtV98hOMfgNP7cT2+
eudn3z0V1aW9XYT3v+z5/8/7J5VP7V/B83dYBa/np73zs++eigHcn2n+xj2/
ve8PmY8faf6Mxlf1z054KkqY3wy74M752/rxtWn9d22v6Prp+bYTngp6v8Hx
0zu/veeXMteP2r+g8VPzQ53wVJTw/jlo+v7p3f86/v5J7R+v4Pj6vtIJTwat
n6HxleZv2z5+efffI9tpfgCPr/UJnfDfRgn5g9/nz6EeufuP8/hYwflj+x1D
+Vrf9y88W+zb5dD6ofc72yt6foP8xfVDcP+h8qn+Ec6f2u+vwjs/++5uAeu/
cX0dff97tr14bbY/rf+l+od58JaEd37K5XK5XC6Xy+VyuVwul8vlcrm8c/4J
/TCmgA==
    "], {{0., 0.}, {29., 24.}}, {0., 255.},
    ColorFunction->RGBColor],
   ImageSize->{29., 24.},
   PlotRange->{{0., 29.}, {0., 24.}}]]]
}], "Subsection",
 CellID->54243372],

Cell[TextData[{
 "Click the ",
 StyleBox["Draw Circle", "DialogElementName"],
 " tool and drag the pointer (",
 Cell[BoxData[
  GraphicsBox[
   RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {0, 1}, {0, 1}, {1, 
    1}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 
    1}, {1, 1}, {1, 1}, {0, 1}, {1, 1}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {1, 1}, {0, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {1, 1}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 
    1}, {1, 1}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 
    1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 
    1}, {0, 1}, {0, 1}, {1, 1}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 
    0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    1}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 1}, {0, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {1, 
    1}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 
    1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}}, {
    Offset[{0.5, -21.5}, {0.5, 0.5}], Offset[{21.5, -0.5}, {0.5, 0.5}]}],
   ImageSize->{21., Automatic}]]],
 ") to draw a ",
 StyleBox["circle, ellipse, or disk.", "Text"]
}], "MathCaption",
 CellID->56659744],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[None], FaceForm[None], RectangleBox[{0, 0}, {1, 0.61803}]}, 
   {EdgeForm[{RGBColor[1., 0.560784, 0.262745], Dashing[{0.005, 0.01}]}], 
    FaceForm[None], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, InsetBox[
    GraphicsBox[
     RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 0}}, {{0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {0, 1}, {0, 
      1}, {1, 1}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {
      0, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {1, 1}}, {{0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {1, 
      1}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {
      1, 1}, {1, 1}, {0, 1}, {1, 1}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {1, 1}, {0, 1}, {0, 1}, {0, 1}, {1, 1}, {0, 0}}, {{0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {
      0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {
      1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 1}, {0, 1}, {0, 0}, {
      0, 0}, {0, 0}, {0, 1}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 
      1}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}}, {
      Offset[{0.5, -21.5}, {0.5, 0.5}], Offset[{21.5, -0.5}, {0.5, 0.5}]}],
     ImageSize->{21., Automatic}], 
    ImageScaled[{0.4555555555555555, 0.5911085633605901}], Center, 
    ImageScaled[{0.5, 0.5}]], 
   {GrayLevel[0], Opacity[1], EdgeForm[None], 
    DiskBox[{0.32755406413124544`, 0.4014994258016402}, \
{0.163124533929903, 0.09321401938851603}]}}]], "Input",
 CellID->183648758],

Cell[TextData[{
 "Hold the ",
 StyleBox["Shift", "KeyEvent"],
 " key to draw circles. "
}], "MathCaption",
 CellID->100304226],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[None], FaceForm[None], RectangleBox[{0, 0}, {1, 0.61803}]}, 
   {EdgeForm[{RGBColor[1., 0.560784, 0.262745], Dashing[{0.005, 0.01}]}], 
    FaceForm[None], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, 
   {GrayLevel[0], Opacity[1], EdgeForm[None], 
    DiskBox[{0.32755406413124544`, 0.4014994258016402}, \
{0.163124533929903, 0.09321401938851603}]}, 
   {GrayLevel[0], Opacity[1], EdgeForm[None], 
    DiskBox[{0.6304996271439225, 0.2104106860551842}, \
{0.15818943650705752`, 0.1581894365070573}]}, InsetBox[
    GraphicsBox[
     RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 0}}, {{0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {0, 1}, {0, 
      1}, {1, 1}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {
      0, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {1, 1}}, {{0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {1, 
      1}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {
      1, 1}, {1, 1}, {0, 1}, {1, 1}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {1, 1}, {0, 1}, {0, 1}, {0, 1}, {1, 1}, {0, 0}}, {{0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {
      0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {
      1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 1}, {0, 1}, {0, 0}, {
      0, 0}, {0, 0}, {0, 1}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 
      1}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}}, {
      Offset[{0.5, -21.5}, {0.5, 0.5}], Offset[{21.5, -0.5}, {0.5, 0.5}]}],
     ImageSize->{21., Automatic}], 
    ImageScaled[{0.7177777777777777, 0.3037661712233475}], Center, 
    ImageScaled[{0.5, 0.5}]]}]], "Input",
 CellID->4148647],

Cell["\<\
You can draw both filled and unfilled circles, depending on the currently \
selected fill and edge attributes.\
\>", "MathCaption",
 CellID->565744163],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[None], FaceForm[None], RectangleBox[{0, 0}, {1, 0.61803}]}, 
   {EdgeForm[{RGBColor[1., 0.560784, 0.262745], Dashing[{0.005, 0.01}]}], 
    FaceForm[None], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, 
   {GrayLevel[0], Opacity[1], EdgeForm[None], 
    DiskBox[{0.32755406413124544`, 0.4014994258016402}, \
{0.163124533929903, 0.09321401938851603}]}, 
   {GrayLevel[0], Opacity[1], EdgeForm[None], 
    DiskBox[{0.6304996271439225, 0.2104106860551842}, \
{0.15818943650705752`, 0.1581894365070573}]}, 
   {Opacity[0.], EdgeForm[Opacity[0.988]], 
    DiskBox[{0.5745712155108127, 0.5133562490678609}, \
{0.0757991049929645, 0.07579910499296494}]}, InsetBox[
    GraphicsBox[
     RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 0}}, {{0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {0, 1}, {0, 
      1}, {1, 1}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {
      0, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {1, 1}}, {{0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {1, 
      1}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {
      1, 1}, {1, 1}, {0, 1}, {1, 1}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {1, 1}, {0, 1}, {0, 1}, {0, 1}, {1, 1}, {0, 0}}, {{0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {
      0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {
      1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 1}, {0, 1}, {0, 0}, {
      0, 0}, {0, 0}, {0, 1}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 
      1}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
      0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {
      0, 0}, {0, 0}, {0, 0}, {0, 0}}}, {
      Offset[{0.5, -21.5}, {0.5, 0.5}], Offset[{21.5, -0.5}, {0.5, 0.5}]}],
     ImageSize->{21., Automatic}], 
    ImageScaled[{0.5977777777777777, 0.8083674452204623}], Center, 
    ImageScaled[{0.5, 0.5}]]}]], "Input",
 CellID->563740315]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Graphics Inspector ",
  FontWeight->"Bold"],
 Cell[BoxData[
  GraphicsBox[RasterBox[CompressedData["
1:eJztnQ+IFUUYwI+SkIiQkMoos4gSLI6IEIkYKipILklBjhAJSYiwP1iUWBgh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    "]],
   ImageSize->{77., 20.},
   PlotRange->{{0., 77.}, {0., 20.}}]]]
}], "Subsection",
 CellID->336125238],

Cell[TextData[{
 "Click the ",
 StyleBox[ButtonBox["Graphics Inspector",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/GraphicsInspector"], "MenuName"],
 " button to display the ",
 StyleBox[ButtonBox["Graphics Inspector",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/GraphicsInspector"], "MenuName"],
 " palette.\nThe ",
 StyleBox[ButtonBox["Graphics Inspector",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/GraphicsInspector"], "MenuName"],
 " palette lets you interactively set the style of a graphics object.\n",
 Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Graphics",
  ImageSize->{350, 395},
  ImageMargins->0]
}], "MathCaption",
 CellID->48171806],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->530354970],

Cell[TextData[ButtonBox["Graphics Interactivity & Drawing",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GraphicsInteractivityAndDrawing"]], "TutorialMoreAbout",
 CellID->47647152],

Cell[TextData[ButtonBox["Annotating & Combining Graphics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/AnnotatingAndCombiningGraphics"]], "TutorialMoreAbout",
 CellID->39409291],

Cell[TextData[ButtonBox["Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CombiningGraphics"]], "TutorialMoreAbout",
 CellID->4750463],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GraphicsAnnotationAndAppearance"]], "TutorialMoreAbout",
 CellID->71032073],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "TutorialMoreAbout",
 CellID->113160759],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "TutorialMoreAbout",
 CellID->42656734]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->81351945],

Cell[TextData[{
 ButtonBox["Editing ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InteractiveGraphicsOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InteractiveGraphicsOverview"],
  FontSlant->"Italic"],
 ButtonBox[" Graphics",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InteractiveGraphicsOverview"]
}], "RelatedTutorials",
 CellID->683270035]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Drawing Tools - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Editing Mathematica Graphics", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/InteractiveGraphicsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/IntroductionToInteractiveGraphics"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/InteractiveGraphicsSelecting#19275731"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 37, 45.8806846}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Type Ctrl+D or choose Graphics > Drawing Tools. For more information on \
each tool, click the words pointing into the palette. Do one of the \
following:", "synonyms" -> {}, "title" -> "Drawing Tools", "type" -> 
    "Tutorial", "uri" -> "tutorial/InteractiveGraphicsPalette"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "2dpalette:01"->{
  Cell[3435, 103, 156, 5, 70, "MathCaption",
   CellTags->"2dpalette:01",
   CellID->51009339]},
 "2dpalette:02"->{
  Cell[22558, 501, 101, 2, 70, "BulletedText",
   CellTags->"2dpalette:02",
   CellID->3752896],
  Cell[22662, 505, 527, 27, 70, "BulletedText",
   CellTags->"2dpalette:02",
   CellID->1746198164],
  Cell[23350, 543, 271, 8, 70, "BulletedText",
   CellTags->"2dpalette:02",
   CellID->198101575],
  Cell[23624, 553, 121, 2, 70, "BulletedText",
   CellTags->"2dpalette:02",
   CellID->153876251],
  Cell[25501, 601, 188, 7, 70, "BulletedText",
   CellTags->"2dpalette:02",
   CellID->1566321571],
  Cell[25692, 610, 171, 6, 70, "BulletedText",
   CellTags->"2dpalette:02",
   CellID->1312098871],
  Cell[25888, 620, 388, 11, 70, "BulletedText",
   CellTags->"2dpalette:02",
   CellID->2083637501]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"2dpalette:01", 242868, 4337},
 {"2dpalette:02", 242984, 4341}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2187, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2812, 78, 50, 1, 70, "Title",
 CellID->509267359],
Cell[CellGroupData[{
Cell[2887, 83, 68, 1, 70, "Section",
 CellID->397412324],
Cell[2958, 86, 474, 15, 70, "MathCaption",
 CellID->1534169418],
Cell[3435, 103, 156, 5, 70, "MathCaption",
 CellTags->"2dpalette:01",
 CellID->51009339],
Cell[3594, 110, 18805, 380, 70, "Input",
 CellID->454629851]
}, Open  ]],
Cell[CellGroupData[{
Cell[22436, 495, 56, 1, 70, "Section",
 CellID->119334373],
Cell[22495, 498, 60, 1, 70, "Text",
 CellID->570315133],
Cell[22558, 501, 101, 2, 70, "BulletedText",
 CellTags->"2dpalette:02",
 CellID->3752896],
Cell[22662, 505, 527, 27, 70, "BulletedText",
 CellTags->"2dpalette:02",
 CellID->1746198164]
}, Open  ]],
Cell[CellGroupData[{
Cell[23226, 537, 59, 1, 70, "Section",
 CellID->137752276],
Cell[23288, 540, 59, 1, 70, "Text",
 CellID->17048901],
Cell[23350, 543, 271, 8, 70, "BulletedText",
 CellTags->"2dpalette:02",
 CellID->198101575],
Cell[23624, 553, 121, 2, 70, "BulletedText",
 CellTags->"2dpalette:02",
 CellID->153876251]
}, Open  ]],
Cell[CellGroupData[{
Cell[23782, 560, 44, 1, 70, "Section",
 CellID->373843469],
Cell[CellGroupData[{
Cell[23851, 565, 1583, 31, 70, "Subsection",
 CellID->206068702],
Cell[25437, 598, 61, 1, 70, "Text",
 CellID->1134718933],
Cell[25501, 601, 188, 7, 70, "BulletedText",
 CellTags->"2dpalette:02",
 CellID->1566321571],
Cell[25692, 610, 171, 6, 70, "BulletedText",
 CellTags->"2dpalette:02",
 CellID->1312098871],
Cell[CellGroupData[{
Cell[25888, 620, 388, 11, 70, "BulletedText",
 CellTags->"2dpalette:02",
 CellID->2083637501],
Cell[26279, 633, 93, 1, 70, "MathCaption",
 CellID->679647678],
Cell[26375, 636, 1168, 23, 70, "Input",
 CellID->373005753]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27592, 665, 966, 21, 70, "Subsection",
 CellID->338102806],
Cell[28561, 688, 1103, 25, 70, "MathCaption",
 CellID->235978221]
}, Open  ]],
Cell[CellGroupData[{
Cell[29701, 718, 970, 21, 70, "Subsection",
 CellID->78894757],
Cell[30674, 741, 4262, 64, 70, "MathCaption",
 CellID->498860540],
Cell[34939, 807, 4460, 62, 70, "Input",
 CellID->419256953]
}, Open  ]],
Cell[CellGroupData[{
Cell[39436, 874, 937, 21, 70, "Subsection",
 CellID->40012893],
Cell[40376, 897, 4145, 60, 70, "MathCaption",
 CellID->596935328],
Cell[44524, 959, 7212, 109, 70, "Input",
 CellID->631419171],
Cell[51739, 1070, 190, 6, 70, "MathCaption",
 CellID->367241650],
Cell[51932, 1078, 10567, 170, 70, "Input",
 CellID->132566320]
}, Open  ]],
Cell[CellGroupData[{
Cell[62536, 1253, 759, 18, 70, "Subsection",
 CellID->236508825],
Cell[63298, 1273, 554, 16, 70, "MathCaption",
 CellID->11885642],
Cell[63855, 1291, 801, 16, 70, "Input",
 CellID->64927037],
Cell[64659, 1309, 238, 7, 70, "MathCaption",
 CellID->272206915],
Cell[64900, 1318, 6718, 104, 70, "Input",
 CellID->132683315]
}, Open  ]],
Cell[CellGroupData[{
Cell[71655, 1427, 1293, 27, 70, "Subsection",
 CellID->651477065],
Cell[72951, 1456, 4269, 61, 70, "MathCaption",
 CellID->8151577],
Cell[77223, 1519, 4735, 66, 70, "Input",
 CellID->463000549],
Cell[81961, 1587, 241, 7, 70, "MathCaption",
 CellID->270520620],
Cell[82205, 1596, 7180, 110, 70, "Input",
 CellID->440960993]
}, Open  ]],
Cell[CellGroupData[{
Cell[89422, 1711, 638, 16, 70, "Subsection",
 CellID->132835900],
Cell[90063, 1729, 156, 5, 70, "MathCaption",
 CellID->187210791],
Cell[90222, 1736, 5375, 80, 70, "Input",
 CellID->219317333],
Cell[95600, 1818, 230, 7, 70, "MathCaption",
 CellID->659560258],
Cell[95833, 1827, 7474, 116, 70, "Input",
 CellID->341284373]
}, Open  ]],
Cell[CellGroupData[{
Cell[103344, 1948, 979, 24, 70, "Subsection",
 CellID->9065006],
Cell[104326, 1974, 156, 5, 70, "MathCaption",
 CellID->64777274],
Cell[104485, 1981, 14780, 240, 70, "Input",
 CellID->496144061],
Cell[119268, 2223, 10333, 178, 70, "Input",
 CellID->216695530]
}, Open  ]],
Cell[CellGroupData[{
Cell[129638, 2406, 967, 23, 70, "Subsection",
 CellID->25770655],
Cell[130608, 2431, 312, 10, 70, "MathCaption",
 CellID->591485334],
Cell[130923, 2443, 14951, 244, 70, "Input",
 CellID->226293590],
Cell[145877, 2689, 10022, 173, 70, "Input",
 CellID->257964831]
}, Open  ]],
Cell[CellGroupData[{
Cell[155936, 2867, 845, 19, 70, "Subsection",
 CellID->389836818],
Cell[156784, 2888, 4218, 62, 70, "MathCaption",
 CellID->247403007],
Cell[161005, 2952, 4415, 61, 70, "Input",
 CellID->12673107],
Cell[165423, 3015, 246, 7, 70, "MathCaption",
 CellID->111120728],
Cell[165672, 3024, 6780, 105, 70, "Input",
 CellID->58099304]
}, Open  ]],
Cell[CellGroupData[{
Cell[172489, 3134, 1242, 26, 70, "Subsection",
 CellID->120316707],
Cell[173734, 3162, 4255, 61, 70, "MathCaption",
 CellID->627144804],
Cell[177992, 3225, 4634, 64, 70, "Input",
 CellID->278576511],
Cell[182629, 3291, 246, 7, 70, "MathCaption",
 CellID->310238965],
Cell[182878, 3300, 7202, 110, 70, "Input",
 CellID->88565]
}, Open  ]],
Cell[CellGroupData[{
Cell[190117, 3415, 1106, 24, 70, "Subsection",
 CellID->54243372],
Cell[191226, 3441, 4183, 61, 70, "MathCaption",
 CellID->56659744],
Cell[195412, 3504, 4653, 66, 70, "Input",
 CellID->183648758],
Cell[200068, 3572, 126, 5, 70, "MathCaption",
 CellID->100304226],
Cell[200197, 3579, 4801, 69, 70, "Input",
 CellID->4148647],
Cell[205001, 3650, 161, 4, 70, "MathCaption",
 CellID->565744163],
Cell[205165, 3656, 4949, 72, 70, "Input",
 CellID->563740315]
}, Open  ]],
Cell[CellGroupData[{
Cell[210151, 3733, 2308, 43, 70, "Subsection",
 CellID->336125238],
Cell[212462, 3778, 26472, 442, 70, "MathCaption",
 CellID->48171806],
Cell[CellGroupData[{
Cell[238959, 4224, 66, 1, 70, "TutorialMoreAboutSection",
 CellID->530354970],
Cell[239028, 4227, 185, 4, 70, "TutorialMoreAbout",
 CellID->47647152],
Cell[239216, 4233, 183, 4, 70, "TutorialMoreAbout",
 CellID->39409291],
Cell[239402, 4239, 153, 3, 70, "TutorialMoreAbout",
 CellID->4750463],
Cell[239558, 4244, 185, 4, 70, "TutorialMoreAbout",
 CellID->71032073],
Cell[239746, 4250, 171, 3, 70, "TutorialMoreAbout",
 CellID->113160759],
Cell[239920, 4255, 169, 3, 70, "TutorialMoreAbout",
 CellID->42656734]
}, Open  ]],
Cell[CellGroupData[{
Cell[240126, 4263, 71, 1, 70, "RelatedTutorialsSection",
 CellID->81351945],
Cell[240200, 4266, 413, 12, 70, "RelatedTutorials",
 CellID->683270035]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[240664, 4284, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

