(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11920,        385]
NotebookOptionsPosition[      7767,        266]
NotebookOutlinePosition[     10717,        340]
CellTagsIndexPosition[     10624,        334]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Textual Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TextualInputAndOutputOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Textual Input and Output\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Language" :> Documentation`HelpLookup["paclet:ref/Language"], 
          "$Language" :> Documentation`HelpLookup["paclet:ref/$Language"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Language\"\>", 
       2->"\<\"$Language\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["International Messages", "Title",
 CellTags->{"S2.9.22", "22.1"},
 CellID->21871],

Cell[TextData[{
 "The standard set of messages for built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions are written in American English. In some versions of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", messages are also available in other languages. In addition, if you set \
up messages yourself, you can give ones in other languages. "
}], "Text",
 CellID->2649],

Cell[TextData[{
 "Languages in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are conventionally specified by strings. The languages are given in \
English, in order to avoid the possibility of needing special characters. \
Thus, for example, the French language is specified in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as ",
 Cell[BoxData["\"\<French\>\""], "InlineFormula"],
 ". "
}], "Text",
 CellID->22590],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["$Language",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/$Language"], "=", "\"\<\!\(\*
StyleBox[\"lang\", \"TI\"]\)\>\""}], Cell[
    "set the language to use", "TableText"]},
   {
    RowBox[{
     ButtonBox["$Language",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/$Language"], "=", "{", "\"\<\>", 
     SubscriptBox[
      StyleBox["lang", "TI"], "1"], "\"\<, \>\"", 
     SubscriptBox[
      StyleBox["lang", "TI"], "2"], "\"\<, \!\(\*
StyleBox[\"\[Ellipsis]\", \"TR\"]\) } \>"}], "\[SpanFromLeft]"},
   {"", Cell["set a sequence of languages to try", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->29204],

Cell["Setting the language to use for messages. ", "Caption",
 CellID->32177],

Cell[TextData[{
 "This tells ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to use French\[Hyphen]language versions of messages. "
}], "MathCaption",
 CellID->25705],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$Language", "=", "\"\<French\>\""}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->5319],

Cell[BoxData["\<\"French\"\>"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->4750]
}, Open  ]],

Cell[TextData[{
 "If your version of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has French\[Hyphen]language messages, the message generated here will be \
in French. "
}], "MathCaption",
 CellID->30528],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->20228],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sqrt", "::", "\<\"argx\"\>"}], ":", 
  " ", "\<\"\\!\\(Sqrt\\) est appel\\relax\\\\parskip\\\\z@$$EAcute]e avec \
\\!\\(3\\) arguments; il faut y avoir 1.\"\>"}]], "Message", "MSG",
 CellID->5722],

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->29668]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["symbol", "TI"], "::", 
     StyleBox["tag", "TI"]}], Cell[
    "the default form of a message", "TableText"]},
   {
    RowBox[{
     StyleBox["symbol", "TI"], "::", 
     StyleBox["tag", "TI"], "::", 
     StyleBox[
      ButtonBox["Language",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Language"], "TI"]}], Cell[
    "a message in a particular language", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->8785],

Cell["Messages in different languages. ", "Caption",
 CellID->23774],

Cell[TextData[{
 "When built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions generate messages, they look first for messages of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["s", "TI"], "::", 
   StyleBox["t", "TI"], "::", 
   StyleBox["Language", "TI"]}]], "InlineFormula"],
 ", in the language specified by ",
 Cell[BoxData[
  ButtonBox["$Language",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Language"]], "InlineFormula"],
 ". If they fail to find any such messages, then they use instead the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["s", "TI"], "::", 
   StyleBox["t", "TI"]}]], "InlineFormula"],
 " without an explicit language specification. "
}], "Text",
 CellID->19184],

Cell[TextData[{
 "The procedure used by built\[Hyphen]in functions will also be followed by \
functions you define if you call ",
 Cell[BoxData[
  ButtonBox["Message",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Message"]], "InlineFormula"],
 " with message names of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["s", "TI"], "::", 
   StyleBox["t", "TI"]}]], "InlineFormula"],
 ". If you give explicit languages in message names, however, only those \
languages will be used. "
}], "Text",
 CellID->6651],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->122001552],

Cell[TextData[ButtonBox["Textual Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TextualInputAndOutputOverview"]], "RelatedTutorials",
 CellID->364580606]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"International Messages - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Textual Input and Output", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/TextualInputAndOutputOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/Messages"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DocumentationConstructs"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 37, 53.7246354}", "context" -> "", 
    "keywords" -> {
     "French language messages", "languages", "messages", "translation", 
      "language"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The standard set of messages for built-in Mathematica functions are \
written in American English. In some versions of Mathematica, messages are \
also available in other languages. In addition, if you set up messages \
yourself, you can give ones in other languages. Languages in Mathematica are \
conventionally specified by strings. The languages are given in English, in \
order to avoid the possibility of needing special characters. Thus, for \
example, the French language is specified in Mathematica as \"French\". \
Setting the language to use for messages. ", "synonyms" -> {"2.9.22"}, 
    "title" -> "International Messages", "type" -> "Tutorial", "uri" -> 
    "tutorial/InternationalMessages"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.9.22"->{
  Cell[1916, 59, 87, 2, 70, "Title",
   CellTags->{"S2.9.22", "22.1"},
   CellID->21871]},
 "22.1"->{
  Cell[1916, 59, 87, 2, 70, "Title",
   CellTags->{"S2.9.22", "22.1"},
   CellID->21871]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.9.22", 10408, 323},
 {"22.1", 10510, 327}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1291, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1916, 59, 87, 2, 70, "Title",
 CellTags->{"S2.9.22", "22.1"},
 CellID->21871],
Cell[2006, 63, 404, 10, 70, "Text",
 CellID->2649],
Cell[2413, 75, 432, 13, 70, "Text",
 CellID->22590],
Cell[2848, 90, 1109, 30, 70, "DefinitionBox",
 CellID->29204],
Cell[3960, 122, 77, 1, 70, "Caption",
 CellID->32177],
Cell[4040, 125, 173, 6, 70, "MathCaption",
 CellID->25705],
Cell[CellGroupData[{
Cell[4238, 135, 109, 3, 28, "Input",
 CellID->5319],
Cell[4350, 140, 167, 5, 36, "Output",
 CellID->4750]
}, Open  ]],
Cell[4532, 148, 214, 7, 70, "MathCaption",
 CellID->30528],
Cell[CellGroupData[{
Cell[4771, 159, 130, 4, 70, "Input",
 CellID->20228],
Cell[4904, 165, 231, 5, 70, "Message",
 CellID->5722],
Cell[5138, 172, 218, 7, 36, "Output",
 CellID->29668]
}, Open  ]],
Cell[5371, 182, 753, 23, 70, "DefinitionBox",
 CellID->8785],
Cell[6127, 207, 68, 1, 70, "Caption",
 CellID->23774],
Cell[6198, 210, 721, 22, 70, "Text",
 CellID->19184],
Cell[6922, 234, 513, 15, 70, "Text",
 CellID->6651],
Cell[CellGroupData[{
Cell[7460, 253, 72, 1, 70, "RelatedTutorialsSection",
 CellID->122001552],
Cell[7535, 256, 178, 4, 70, "RelatedTutorials",
 CellID->364580606]
}, Open  ]]
}, Open  ]],
Cell[7740, 264, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

