(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16311,        496]
NotebookOptionsPosition[     12134,        380]
NotebookOutlinePosition[     14546,        430]
CellTagsIndexPosition[     14503,        427]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Internet Connectivity"
}], "Title",
 CellID->509267359],

Cell[CellGroupData[{

Cell["Introduction", "Section",
 CellID->620389437],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the Internet for a number of operations. For example, the ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " function can read from a URL, and the ",
 StyleBox[ButtonBox["Web Services Link",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/guide/WebServiceOperations"],
  FontSlant->"Italic"],
 " can load and call standard web services. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6 supports a major new innovation called \"paclets\", which are units of \
functionality that can be updated on demand via the ",
 "internet",
 ". The paclet system is currently used to enable automatic updates to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s comprehensive documentation suite, and also to support numerous ",
 ButtonBox["integrated data sources",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DataCollections"],
 "."
}], "Text",
 CellID->468488763],

Cell[TextData[{
 "When you click a link to a documentation notebook or call a data function \
like ",
 Cell[BoxData[
  ButtonBox["CountryData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CountryData"]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " knows whether a newer version of the information is available on a Wolfram \
Research Paclet Server, and if so it will download and install the update \
automatically. In the case of smaller paclets like documentation notebooks, \
this is often so fast that you will not even notice it happening."
}], "Text",
 CellID->136148614],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " acts like a web browser when it accesses the internet, so if you can \
browse the web from your computer, you should be able to use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s ",
 "internet",
 " connectivity features, although possibly with some configuration \
required."
}], "Text",
 CellID->137739754]
}, Open  ]],

Cell[CellGroupData[{

Cell["Internet Connectivity Dialog", "Section",
 CellID->713097862],

Cell[TextData[{
 "The ",
 StyleBox["Internet Connectivity", "DialogElementName"],
 " dialog, accessed from the ",
 StyleBox[ButtonBox["Help",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/HelpMenu"], "MenuName"],
 " menu, allows you to configure a number of settings related to the paclet \
system, and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s use of the internet in general."
}], "Text",
 CellID->2077016374],

Cell[TextData[{
 "The ",
 StyleBox["Allow ", "DialogElementName"],
 StyleBox["Mathematica", "DialogElementName",
  FontSlant->"Italic"],
 StyleBox[" to access the Internet", "DialogElementName"],
 " checkbox can be turned off to prevent ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " from even attempting to use the internet. You will not be able to get \
load-on-demand updates to documentation, and some data collections functions \
will not operate."
}], "Text",
 CellID->20188334],

Cell[TextData[{
 "The ",
 StyleBox["Test Internet Connectivity", "DialogElementName"],
 " button is useful to see if ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is properly configured for internet use. After clicking the button, you \
should see a dialog within a few seconds (perhaps slightly longer if it \
fails) reporting success or failure. If the test succeeds, then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s internet functionality should work properly. If it fails, consult the \
Troubleshooting section below."
}], "Text",
 CellID->46746640],

Cell[TextData[{
 "The ",
 StyleBox["Proxy Settings", "DialogElementName"],
 " section allows you to specify a proxy server if necessary. In many cases, \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is able to inherit the proxy settings configured globally for your system \
or browser. This is the default setting, and most users will leave it as is. \
If you know that you do not need to go through a proxy server to access the \
internet, you can click the ",
 StyleBox["Direct connection to the Internet", "DialogElementName"],
 " checkbox. You can also manually configure proxy settings if necessary. \
Contact your system administrator for the values to use. Most users will only \
need to set the HTTP proxy."
}], "Text",
 CellID->3056625],

Cell[TextData[{
 "The ",
 StyleBox["Automatically check for documentation updates", 
  "DialogElementName"],
 " checkbox can be turned off to disable load-on-demand updates to \
documentation files. This will not interfere with the operation of ",
 StyleBox["Mathematica,",
  FontSlant->"Italic"],
 " except that you will not receive updates to the documentation as they \
become available."
}], "Text",
 CellID->46670504],

Cell[TextData[{
 "The ",
 StyleBox["Update Local Indices from the Wolfram Research Server", 
  "DialogElementName"],
 " button will cause ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to read information from the Wolfram Research Paclet Server that describes \
the versions of the paclets that are available. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses this information to decide whether an update is available to a given \
resource when you access that resource. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " reads this information on a weekly basis automatically, but you can force \
an update using this button. You might want to do this to be sure you will \
get the absolute latest data from data collections functions like ",
 Cell[BoxData[
  ButtonBox["CountryData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CountryData"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ChemicalData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChemicalData"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["AstronomicalData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AstronomicalData"]], "InlineFormula"],
 ", etc."
}], "Text",
 CellID->99923229]
}, Open  ]],

Cell[CellGroupData[{

Cell["Troubleshooting Connectivity Problems", "Section",
 CellID->960992554],

Cell[TextData[{
 "If you get error messages or dialogs that report internet connectivity \
problems while running ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", the first thing to do is try the ",
 StyleBox["Test Internet Connectivity", "DialogElementName"],
 " button in the ",
 StyleBox["Internet Connectivity", "DialogElementName"],
 " dialog, accessible from the ",
 StyleBox[ButtonBox["Help",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/HelpMenu"], "MenuName"],
 " menu. If the test succeeds, then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is correctly configured for general internet use, and the problem probably \
lies elsewhere (such as trying to access an incorrect URL). If the test \
fails, try the following steps:"
}], "Text",
 CellID->500850286],

Cell[TextData[{
 "Test network connectivity by seeing if other programs on your computer can \
access the ",
 "internet",
 ". For example, launch a web browser and see if it works. If it fails, then \
the network might be unavailable, or you might have connectivity problems \
beyond what can be configured in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "ItemizedText",
 CellID->182891266],

Cell["Check proxy settings, as described below.", "ItemizedText",
 CellID->124290722],

Cell["Check firewall settings, as described below.", "ItemizedText",
 CellID->95016151],

Cell[CellGroupData[{

Cell["Proxy Settings", "Subsection",
 CellID->447715236],

Cell[TextData[{
 "Incorrect proxy settings are a common cause of problems with internet \
connectivity. Many users on a company network cannot directly access the \
internet, but instead must pass through a proxy server, which acts like a \
gateway to the internet. By default, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will attempt to use system-wide proxy settings, if your operating system \
has such settings. For example, on Windows, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will use the proxy settings configured for Internet Explorer. On Mac OS X, \
proxy settings are configured in the ",
 StyleBox["Network Preferences", "DialogElementName"],
 " panel."
}], "Text",
 CellID->170354685],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s proxy settings are configured in the ",
 StyleBox["Internet Connectivity", "DialogElementName"],
 " dialog. The default setting, described above, is ",
 StyleBox["Use proxy settings from my system or browser", 
  "DialogElementName"],
 ". If this does not work for you, try the ",
 StyleBox["Direct connection to the Internet", "DialogElementName"],
 " choice. If that does not work, then contact your system administrator for \
proxy settings to enter into the text fields. If you can successfully surf \
the web with a web browser, you can find its proxy settings dialog and read \
the values it is using. Many users will only need to set the HTTP proxy."
}], "Text",
 CellID->8764295],

Cell[TextData[{
 "If your system or browser is configured to get proxy settings from a \
configuration script, then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will not be able to use these settings, and you will have to manually \
configure its proxy settings."
}], "Text",
 CellID->419886778]
}, Open  ]],

Cell[CellGroupData[{

Cell["Firewall Settings", "Subsection",
 CellID->133968595],

Cell[TextData[{
 "Because ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " acts like a web browser when it accesses the internet, most company \
firewalls will not interfere with it. Some users, however, have so-called \
\"personal\" firewalls on their machines (ZoneAlarm, Norton, etc., or the one \
built into Microsoft Windows). If configured with strict settings, these \
firewalls might interfere with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s attempts to use the ",
 "internet",
 "."
}], "Text",
 CellID->470365973],

Cell[TextData[{
 "These types of firewalls will generally display a dialog box warning you \
that a program is trying to use the ",
 "internet",
 " and allow you to accept or reject it. If you see such a dialog, it might \
report that the program is the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel or the Java Runtime Environment that is bundled in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " layout. Configure the firewall to always allow such requests."
}], "Text",
 CellID->20705070]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Further Information", "Section",
 CellID->962041100],

Cell[TextData[{
 "If the information in this document is not sufficient to help you solve \
connectivity problems, consult the Wolfram Research Technical Support \
troubleshooting guide at ",
 ButtonBox["http://support.wolfram.com/mathematica/systems/allplatforms/\
networkconnectivityissues.html",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://support.wolfram.com/mathematica/systems/allplatforms/\
networkconnectivityissues.html"], None}]
}], "Text",
 CellID->709451675]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Mathematica Internet Connectivity - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 37, 54.0996450}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "", "status" -> "None", "summary" -> 
    "Mathematica uses the Internet for a number of operations. For example, \
the Import function can read from a URL, and the Web Services Link can load \
and call standard web services. Mathematica 6 supports a major new innovation \
called \"paclets\", which are units of functionality that can be updated on \
demand via the internet. The paclet system is currently used to enable \
automatic updates to Mathematica's comprehensive documentation suite, and \
also to support numerous integrated data sources. When you click a link to a \
documentation notebook or call a data function like CountryData, Mathematica \
knows whether a newer version of the information is available on a Wolfram \
Research Paclet Server, and if so it will download and install the update \
automatically. In the case of smaller paclets like documentation notebooks, \
this is often so fast that you will not even notice it happening. Mathematica \
acts like a web browser when it accesses the internet, so if you can browse \
the web from your computer, you should be able to use Mathematica's internet \
connectivity features, although possibly with some configuration required.", 
    "synonyms" -> {}, "title" -> "Mathematica Internet Connectivity", "type" -> 
    "Tutorial", "uri" -> "tutorial/InternetConnectivity"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 103, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[728, 29, 123, 5, 70, "Title",
 CellID->509267359],
Cell[CellGroupData[{
Cell[876, 38, 51, 1, 70, "Section",
 CellID->620389437],
Cell[930, 41, 1022, 28, 70, "Text",
 CellID->468488763],
Cell[1955, 71, 615, 15, 70, "Text",
 CellID->136148614],
Cell[2573, 88, 385, 12, 70, "Text",
 CellID->137739754]
}, Open  ]],
Cell[CellGroupData[{
Cell[2995, 105, 67, 1, 70, "Section",
 CellID->713097862],
Cell[3065, 108, 428, 13, 70, "Text",
 CellID->2077016374],
Cell[3496, 123, 492, 13, 70, "Text",
 CellID->20188334],
Cell[3991, 138, 575, 14, 70, "Text",
 CellID->46746640],
Cell[4569, 154, 756, 16, 70, "Text",
 CellID->3056625],
Cell[5328, 172, 422, 11, 70, "Text",
 CellID->46670504],
Cell[5753, 185, 1207, 34, 70, "Text",
 CellID->99923229]
}, Open  ]],
Cell[CellGroupData[{
Cell[6997, 224, 76, 1, 70, "Section",
 CellID->960992554],
Cell[7076, 227, 787, 20, 70, "Text",
 CellID->500850286],
Cell[7866, 249, 406, 11, 70, "ItemizedText",
 CellID->182891266],
Cell[8275, 262, 85, 1, 70, "ItemizedText",
 CellID->124290722],
Cell[8363, 265, 87, 1, 70, "ItemizedText",
 CellID->95016151],
Cell[CellGroupData[{
Cell[8475, 270, 56, 1, 70, "Subsection",
 CellID->447715236],
Cell[8534, 273, 721, 16, 70, "Text",
 CellID->170354685],
Cell[9258, 291, 757, 15, 70, "Text",
 CellID->8764295],
Cell[10018, 308, 305, 8, 70, "Text",
 CellID->419886778]
}, Open  ]],
Cell[CellGroupData[{
Cell[10360, 321, 59, 1, 70, "Subsection",
 CellID->133968595],
Cell[10422, 324, 542, 15, 70, "Text",
 CellID->470365973],
Cell[10967, 341, 519, 13, 70, "Text",
 CellID->20705070]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11535, 360, 58, 1, 70, "Section",
 CellID->962041100],
Cell[11596, 363, 484, 11, 70, "Text",
 CellID->709451675]
}, Open  ]]
}, Open  ]],
Cell[12107, 378, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

