(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6864,        210]
NotebookOptionsPosition[      3660,        124]
NotebookOutlinePosition[      6398,        193]
CellTagsIndexPosition[      6307,        187]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Using the Mathematica System" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/UsingTheMathematicaSystemOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Using the Mathematica System\"\>"}, "\<\"related tutorials\"\>",
       
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Interrupting Calculations", "Title",
 CellTags->{"S1.3.12", "12.1"},
 CellID->18884],

Cell[TextData[{
 "There will probably be times when you want to stop ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in the middle of a calculation. Perhaps you realize that you asked ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to do the wrong thing. Or perhaps the calculation is just taking a long \
time, and you want to find out what is going on. "
}], "Text",
 CellID->27037],

Cell[TextData[{
 "The way that you interrupt a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " calculation depends on what kind of interface you are using.",
 " ",
 " "
}], "Text",
 CellID->10915],

Cell[BoxData[GridBox[{
   {Cell["Alt\[Hyphen]Comma  or  Command\[Hyphen]Comma", "TableText"], Cell[
    "notebook interfaces", "TableText"]},
   {Cell["Control\[Hyphen]C", "TableText"], Cell[
    "text\[Hyphen]based interfaces", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->15189],

Cell[TextData[{
 "Typical keys to interrupt calculations in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->11681],

Cell[TextData[{
 "When doing some operations, it may take ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " some time to respond to your interrupt. When ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does respond, it will give you a menu of possible things to do. This will \
typically include not only aborting your computation, but also entering a \
subsession or \[OpenCurlyDoubleQuote]dialog\[CloseCurlyDoubleQuote] to \
inspect its state."
}], "Text",
 CellID->19074],

Cell[TextData[{
 ButtonBox["Using the ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UsingTheMathematicaSystemOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UsingTheMathematicaSystemOverview"],
  FontSlant->"Italic"],
 ButtonBox[" System",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UsingTheMathematicaSystemOverview"]
}], "RelatedTutorials",
 CellID->344194261]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Interrupting Calculations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Using the Mathematica System", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/UsingTheMathematicaSystemOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/WarningsAndMessages"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 37, 54.3809022}", "context" -> "", 
    "keywords" -> {
     "aborting calculations", "asynchronous interrupts", "break", "command", 
      "ControlC", "control characters", "exit", "inspector", "interrupt", 
      "killing", "menu", "state", "status check", "stopping calculations", 
      "suspend (interrupt)"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "There will probably be times when you want to stop Mathematica in the \
middle of a calculation. Perhaps you realize that you asked Mathematica to do \
the wrong thing. Or perhaps the calculation is just taking a long time, and \
you want to find out what is going on. The way that you interrupt a \
Mathematica calculation depends on what kind of interface you are using. \
Typical keys to interrupt calculations in Mathematica. ", 
    "synonyms" -> {"1.3.12"}, "title" -> "Interrupting Calculations", "type" -> 
    "Tutorial", "uri" -> "tutorial/InterruptingCalculations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.3.12"->{
  Cell[1289, 44, 90, 2, 70, "Title",
   CellTags->{"S1.3.12", "12.1"},
   CellID->18884]},
 "12.1"->{
  Cell[1289, 44, 90, 2, 70, "Title",
   CellTags->{"S1.3.12", "12.1"},
   CellID->18884]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.3.12", 6091, 176},
 {"12.1", 6193, 180}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 664, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1289, 44, 90, 2, 70, "Title",
 CellTags->{"S1.3.12", "12.1"},
 CellID->18884],
Cell[1382, 48, 398, 10, 70, "Text",
 CellID->27037],
Cell[1783, 60, 203, 8, 70, "Text",
 CellID->10915],
Cell[1989, 70, 556, 13, 70, "DefinitionBox",
 CellID->15189],
Cell[2548, 85, 148, 6, 70, "Caption",
 CellID->11681],
Cell[2699, 93, 485, 12, 70, "Text",
 CellID->19074],
Cell[3187, 107, 431, 12, 70, "RelatedTutorials",
 CellID->344194261]
}, Open  ]],
Cell[3633, 122, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

