(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17669,        600]
NotebookOptionsPosition[     13201,        458]
NotebookOutlinePosition[     15449,        517]
CellTagsIndexPosition[     15357,        511]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Special Characters" :> 
         Documentation`HelpLookup["paclet:guide/SpecialCharacters"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Special Characters\"\>"}, "\<\"more about\"\>", 
      StyleBox["\<\"more about\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Named Characters", "Title",
 CellTags->{"SA.13.1", "1.1"},
 CellID->4718],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides systemwide support for a large number of special characters. Each \
character has a name and a number of shortcut aliases. They are fully \
supported by the standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " fonts."
}], "Text",
 CellID->17135],

Cell[CellGroupData[{

Cell["Interpretation of Characters", "Section",
 CellID->13192],

Cell[TextData[{
 "The interpretations given here are those used in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ". Most of the interpretations also work in ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->30554],

Cell[TextData[{
 "You can override the interpretations by giving your own rules for ",
 Cell[BoxData[
  ButtonBox["MakeExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MakeExpression"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->19124],

Cell[BoxData[GridBox[{
   {Cell["Letters and letter\[Hyphen]like forms", "TableText"], Cell[
    "used in symbol names", "TableText"]},
   {Cell["Infix operators", "TableText"], Cell[TextData[{
     "e.g. ",
     Cell[BoxData[
      FormBox[
       RowBox[{"x", "\[CirclePlus]", "y"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell["Prefix operators", "TableText"], Cell[TextData[{
     "e.g. ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Not]", "x"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell["Postfix operators", "TableText"], Cell[TextData[{
     "e.g. ",
     Cell[BoxData[
      FormBox[
       RowBox[{"x", "!"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell["Matchfix operators", "TableText"], Cell[TextData[{
     "e.g. ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[LeftAngleBracket]", "x", "\[RightAngleBracket]"}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell["Compound operators", "TableText"], Cell[TextData[{
     "e.g. ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Integral]", 
        RowBox[{"f", 
         RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {Cell["Raw operators", "TableText"], Cell["\<\
operator characters that can be typed on an ordinary keyboard\
\>", "TableText"]},
   {Cell["Spacing characters", "TableText"], Cell[
    "interpreted in the same way as an ordinary space", "TableText"]},
   {Cell["Structural elements", "TableText"], Cell["\<\
characters used to specify structure; usually ignored in interpretation\
\>", "TableText"]},
   {Cell["Uninterpretable elements", "TableText"], Cell[
    "characters indicating missing information", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, {False}, 
     False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->31],

Cell["Types of characters. ", "Caption",
 CellID->28066],

Cell[TextData[{
 "The precedences of operators are given in\[NonBreakingSpace]\"",
 ButtonBox["Operator Input Forms",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InputSyntax#23301"],
 "\". "
}], "Text",
 CellID->26429],

Cell[TextData[{
 "Infix operators for which no grouping is specified in the listing are \
interpreted so that for example ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[CirclePlus]", "y", "\[CirclePlus]", "z"}], 
   TraditionalForm]], "InlineMath"],
 " becomes ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CirclePlus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CirclePlus"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->12722]
}, Open  ]],

Cell[CellGroupData[{

Cell["Naming Conventions", "Section",
 CellID->29556],

Cell[TextData[{
 "Characters that correspond to built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions typically have names corresponding to those functions. Other \
characters typically have names that are as generic as possible. "
}], "Text",
 CellID->13818],

Cell["\<\
Characters with different names almost always look at least slightly \
different. \
\>", "Text",
 CellID->21875],

Cell[BoxData[GridBox[{
   {
    RowBox[{"\\[", 
     StyleBox[
      RowBox[{"Capital", 
       StyleBox["\[Ellipsis]", "TR"]}]], "]"}], Cell[
    "upper\[Hyphen]case form of a letter", "TableText"]},
   {
    RowBox[{
     RowBox[{"\\[", 
      StyleBox[
       RowBox[{"Left", 
        StyleBox["\[Ellipsis]", "TR"]}]], "]"}], Cell[" and ", "TableText"], 
     RowBox[{"\\[", 
      StyleBox[
       RowBox[{"Right", 
        StyleBox["\[Ellipsis]", "TR"]}]], "]"}]}], Cell[
    "pieces of a matchfix operator (also arrows)", "TableText"]},
   {
    RowBox[{"\\[", 
     StyleBox[
      RowBox[{"Raw", 
       StyleBox["\[Ellipsis]", "TR"]}]], "]"}], Cell[
    "a printable ASCII character", "TableText"]},
   {
    RowBox[{"\\[", 
     StyleBox[
      RowBox[{
       StyleBox["\[Ellipsis]", "TR"], "Indicator"}]], "]"}], Cell[
    "a visual representation of a keyboard character", "TableText"]}
  }]], "DefinitionBox",
 CellID->1692],

Cell["Some special classes of characters. ", "Caption",
 CellID->13910],

Cell[BoxData[GridBox[{
   {Cell["style", "TableText"], Cell["Script, Gothic, etc.", "TableText"]},
   {Cell["variation", "TableText"], Cell["Curly, Gray, etc.", "TableText"]},
   {Cell["case", "TableText"], Cell["Capital, etc.", "TableText"]},
   {Cell["modifiers", "TableText"], Cell[
    "Not, Double, Nested, etc.", "TableText"]},
   {Cell["direction", "TableText"], Cell[
    "Left, Up, UpperRight, etc.", "TableText"]},
   {Cell["base", "TableText"], Cell["A, Epsilon, Plus, etc.", "TableText"]},
   {Cell["diacritical mark", "TableText"], Cell[
    "Acute, Ring, etc.", "TableText"]}
  }]], "DefinitionBox",
 CellID->18361],

Cell["Typical ordering of elements in character names. ", "Caption",
 CellID->13132]
}, Open  ]],

Cell[CellGroupData[{

Cell["Aliases", "Section",
 CellID->19728],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports both its own system of aliases, as well as aliases based on \
character names in TeX and SGML or HTML. Except where they conflict, \
character names corresponding to plain TeX, LaTeX and AMSTeX are all \
supported. Note that TeX and SGML or HTML aliases are not given explicitly in \
the list of characters below. "
}], "Text",
 CellID->30522],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["Esc", "KeyEvent"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["xxx", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["Esc", "KeyEvent"]}], Cell[TextData[{
     "ordinary ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " alias"
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      StyleBox["Esc", "KeyEvent"], 
      StyleBox["\[ThinSpace]", "InlineCode"], 
      StyleBox["\[Backslash]", "InlineCode"], 
      StyleBox["xxx", "InlineCode"]}], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["Esc", "KeyEvent"]}], Cell["TeX alias", "TableText"]},
   {
    RowBox[{
     RowBox[{
      StyleBox["Esc", "KeyEvent"], 
      StyleBox["\[ThinSpace]", "InlineCode"], 
      StyleBox["&", "InlineCode"]}], 
     StyleBox["xxx", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["Esc", "KeyEvent"]}], Cell["SGML or HTML alias", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->11149],

Cell["Types of aliases. ", "Caption",
 CellID->27277],

Cell["The following general conventions are used for all aliases: ", "Text",
 CellID->31826],

Cell[TextData[{
 "Characters that are alternatives to standard keyboard operators use these \
operators as their aliases (e.g. ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]->\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " for ",
 Cell[BoxData[
  FormBox["\[Rule]", TraditionalForm]], "InlineMath"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]&&\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " for ",
 Cell[BoxData[
  FormBox["\[And]", TraditionalForm]], "InlineMath"],
 ")."
}], "Notes",
 CellID->29348],

Cell["\<\
Most single\[Hyphen]letter aliases stand for Greek letters.\
\>", "Notes",
 CellID->68050518],

Cell["\<\
Capital\[Hyphen]letter characters have aliases beginning with capital \
letters.\
\>", "Notes",
 CellID->22829404],

Cell[TextData[{
 "When there is ambiguity in the assignment of aliases, a space is inserted \
at the beginning of the alias for the less common character (e.g. ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]->\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " for ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{"[", 
    ButtonBox["Rule",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Rule"], "]"}]}]], "InlineFormula"],
 " and ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]\[SpaceIndicator]->\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " for \[Backslash]",
 Cell[BoxData[
  RowBox[{"[", 
   ButtonBox["RightArrow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RightArrow"], "]"}]], "InlineFormula"],
 ")."
}], "Notes",
 CellID->4537015],

Cell[TextData[{
 Cell[BoxData["!"], "InlineFormula"],
 " is inserted at the beginning of the alias for a ",
 Cell[BoxData[
  ButtonBox["Not",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Not"]], "InlineFormula"],
 " character."
}], "Notes",
 CellID->61897659],

Cell["\<\
TeX aliases begin with a backslash \[Backslash].\
\>", "Notes",
 CellID->8943628],

Cell[TextData[{
 "SGML aliases begin with an ampersand ",
 Cell[BoxData["&"], "InlineFormula"],
 "."
}], "Notes",
 CellID->105631078],

Cell["\<\
User\[Hyphen]defined aliases conventionally begin with a dot or comma.\
\>", "Notes",
 CellID->563459203]
}, Open  ]],

Cell[CellGroupData[{

Cell["Font Matching", "Section",
 CellID->1278],

Cell[TextData[{
 "The special fonts provided with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " include all the characters given in this listing. Some of these characters \
also appear in certain ordinary text fonts. "
}], "Text",
 CellID->17777],

Cell[TextData[{
 "When rendering text in a particular font, the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook front end will use all the characters available in that font. It \
will use the special ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " fonts only for other characters. "
}], "Text",
 CellID->22338],

Cell["\<\
A choice is made between Times\[Hyphen]like, Helvetica\[Hyphen]like (sans \
serif) and Courier\[Hyphen]like (monospaced) variants to achieve the best \
matching with the ordinary text font in use. \
\>", "Text",
 CellID->15175],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->411515889],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialCharacters"]], "TutorialMoreAbout",
 CellID->87874397]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Named Characters - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 37, 56.4747058}", "context" -> "", 
    "keywords" -> {
     "aliases", "character names", "full names of special characters", 
      "HTML names for characters", "Letterlike forms", "names", "operators", 
      "SGML names for characters", "Short names", "spacing characters", 
      "structural elements", "TeX names for characters", 
      "uninterpretable elements"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica provides systemwide support for a large number of special \
characters. Each character has a name and a number of shortcut aliases. They \
are fully supported by the standard Mathematica fonts. The interpretations \
given here are those used in StandardForm and InputForm. Most of the \
interpretations also work in TraditionalForm. You can override the \
interpretations by giving your own rules for MakeExpression. ", 
    "synonyms" -> {}, "title" -> "Named Characters", "type" -> "Tutorial", 
    "uri" -> "tutorial/Introduction-ListingOfNamedCharacters"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "SA.13.1"->{
  Cell[1218, 42, 79, 2, 70, "Title",
   CellTags->{"SA.13.1", "1.1"},
   CellID->4718]},
 "1.1"->{
  Cell[1218, 42, 79, 2, 70, "Title",
   CellTags->{"SA.13.1", "1.1"},
   CellID->4718]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"SA.13.1", 15146, 500},
 {"1.1", 15245, 504}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 593, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1218, 42, 79, 2, 70, "Title",
 CellTags->{"SA.13.1", "1.1"},
 CellID->4718],
Cell[1300, 46, 333, 10, 70, "Text",
 CellID->17135],
Cell[CellGroupData[{
Cell[1658, 60, 63, 1, 70, "Section",
 CellID->13192],
Cell[1724, 63, 542, 18, 70, "Text",
 CellID->30554],
Cell[2269, 83, 251, 8, 70, "Text",
 CellID->19124],
Cell[2523, 93, 2158, 57, 70, "DefinitionBox",
 CellID->31],
Cell[4684, 152, 56, 1, 70, "Caption",
 CellID->28066],
Cell[4743, 155, 226, 7, 70, "Text",
 CellID->26429],
Cell[4972, 164, 549, 19, 70, "Text",
 CellID->12722]
}, Open  ]],
Cell[CellGroupData[{
Cell[5558, 188, 53, 1, 70, "Section",
 CellID->29556],
Cell[5614, 191, 287, 7, 70, "Text",
 CellID->13818],
Cell[5904, 200, 122, 4, 70, "Text",
 CellID->21875],
Cell[6029, 206, 938, 31, 70, "DefinitionBox",
 CellID->1692],
Cell[6970, 239, 71, 1, 70, "Caption",
 CellID->13910],
Cell[7044, 242, 629, 12, 70, "DefinitionBox",
 CellID->18361],
Cell[7676, 256, 84, 1, 70, "Caption",
 CellID->13132]
}, Open  ]],
Cell[CellGroupData[{
Cell[7797, 262, 42, 1, 70, "Section",
 CellID->19728],
Cell[7842, 265, 420, 9, 70, "Text",
 CellID->30522],
Cell[8265, 276, 1333, 39, 70, "DefinitionBox",
 CellID->11149],
Cell[9601, 317, 53, 1, 70, "Caption",
 CellID->27277],
Cell[9657, 320, 92, 1, 70, "Text",
 CellID->31826],
Cell[9752, 323, 560, 18, 70, "Notes",
 CellID->29348],
Cell[10315, 343, 103, 3, 70, "Notes",
 CellID->68050518],
Cell[10421, 348, 124, 4, 70, "Notes",
 CellID->22829404],
Cell[10548, 354, 807, 25, 70, "Notes",
 CellID->4537015],
Cell[11358, 381, 263, 9, 70, "Notes",
 CellID->61897659],
Cell[11624, 392, 91, 3, 70, "Notes",
 CellID->8943628],
Cell[11718, 397, 133, 5, 70, "Notes",
 CellID->105631078],
Cell[11854, 404, 115, 3, 70, "Notes",
 CellID->563459203]
}, Open  ]],
Cell[CellGroupData[{
Cell[12006, 412, 47, 1, 70, "Section",
 CellID->1278],
Cell[12056, 415, 255, 7, 70, "Text",
 CellID->17777],
Cell[12314, 424, 333, 10, 70, "Text",
 CellID->22338],
Cell[12650, 436, 237, 5, 70, "Text",
 CellID->15175],
Cell[CellGroupData[{
Cell[12912, 445, 66, 1, 70, "TutorialMoreAboutSection",
 CellID->411515889],
Cell[12981, 448, 154, 3, 70, "TutorialMoreAbout",
 CellID->87874397]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[13174, 456, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

