(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    113930,       3967]
NotebookOptionsPosition[     95277,       3339]
NotebookOutlinePosition[     97427,       3387]
CellTagsIndexPosition[     97384,       3384]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Advanced Dynamic Functionality" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AdvancedDynamicFunctionality"], 
          "Introduction to Manipulate" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntroductionToManipulate"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Advanced Dynamic Functionality\"\>", 
       2->"\<\"Introduction to Manipulate\"\>"}, "\<\"related tutorials\"\>", 
       
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dynamic Interactivity Language" :> 
          Documentation`HelpLookup[
           "paclet:guide/DynamicInteractivityLanguage"], 
          "Dynamic Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DynamicVisualization"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Dynamic Interactivity Language\"\>", 
       2->"\<\"Dynamic Visualization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dynamic" :> Documentation`HelpLookup["paclet:ref/Dynamic"], 
          "DynamicModule" :> 
          Documentation`HelpLookup["paclet:ref/DynamicModule"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Dynamic\"\>", 
       2->"\<\"DynamicModule\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Introduction to Dynamic", "Title",
 CellID->1627681926],

Cell[TextData[{
 "This tutorial describes the principles behind ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " and related functions, and goes into detail about how they interact with \
each other and with the rest of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->296418628],

Cell[TextData[{
 "These functions are the foundation of a higher-level function ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " that provides a simple yet powerful way of creating a great many \
interactive examples, programs, and demonstrations, all in a very convenient, \
though relatively rigid, structure. If that structure solves the problem at \
hand, you need look no further than ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " and you do not need to read this tutorial. However, do continue with this \
tutorial if you want to build a wider range of structures, including complex \
user interfaces."
}], "Text",
 CellID->1485096622],

Cell[TextData[{
 "Please note that this is a ",
 StyleBox["hands-on",
  FontSlant->"Italic"],
 " tutorial. You are expected to actually evaluate each of the input lines as \
you reach them in your reading, and watch what happens. The accompanying text \
will not make sense without evaluating as you read."
}], "TextEmphasisNote",
 CellID->244159640],

Cell[CellGroupData[{

Cell["The Fundamental Principle of Dynamic", "Section",
 CellID->191800398],

Cell[TextData[{
 "Ordinary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " sessions consist of a series of static inputs and outputs, which forms a \
record of calculations done in the order in which they were entered."
}], "Text",
 CellID->216335039],

Cell["Evaluate each of these four input cells one after the other.", \
"MathCaption",
 CellID->253186102],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "5"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1133711607],

Cell[CellGroupData[{

Cell[BoxData[
 SuperscriptBox["x", "2"]], "Input",
 CellLabel->"In[2]:=",
 CellID->1816062665],

Cell[BoxData["25"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1971677972]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "7"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->380135844],

Cell[CellGroupData[{

Cell[BoxData[
 SuperscriptBox["x", "2"]], "Input",
 CellLabel->"In[4]:=",
 CellID->179280283],

Cell[BoxData["49"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->171518547]
}, Open  ]],

Cell[TextData[{
 "The first output still shows the value from when ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " was 5, even though it is now 7. This is, of course, very useful, if you \
want to see a history of what you have been doing. However, you may often \
want a fundamentally different kind of output, one that is automatically \
updated to always reflect its current value. This new kind of output is \
provided by ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1897303710],

Cell[TextData[{
 "Evaluate the following cell; note that the result will be 49 because the \
current value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is 7. "
}], "MathCaption",
 CellID->2146263314],

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  SuperscriptBox["x", "2"], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->964699739],

Cell[TextData[{
 "In fact it is generally the case that when you first evaluate an input that \
contains variables wrapped in ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 ", you will get the same result as you would have without ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 ". But if you subsequently change the value of the variables, the displayed \
output will change retroactively."
}], "Text",
 CellID->206978523],

Cell["\<\
Evaluate the following cells one at a time, and note the change in the value \
displayed above.\
\>", "MathCaption",
 CellID->1321105872],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "9"}], ";"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->233129668],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "15"}], ";"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1200157948],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "10"}], ";"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->1888219412],

Cell[TextData[{
 "The first two static outputs are still 25 and 49 respectively, but the \
single dynamic output now displays 100, the square of the last value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". (This sentence will, of course, become incorrect as soon as the value of \
",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is changed again.)"
}], "Text",
 CellID->1937805765],

Cell[TextData[{
 "There are no restrictions on the kinds of values that can go into a dynamic \
output. Just because ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " was initially a number does not mean it cannot become a formula or even a \
graphic in subsequent evaluations. ",
 "This might seem like a simple feature, but it is the basis for a very \
powerful set of interactive capabilities."
}], "Text",
 CellID->1077141161],

Cell[TextData[{
 "Each time the value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is changed, the dynamic output above is updated automatically. (You might \
need to scroll back to see it.)"
}], "MathCaption",
 CellID->2111985600],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"1", "-", 
       SuperscriptBox["y", "3"]}]], ",", "y"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->384777937],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->889526042],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "0"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->224348717],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Dynamic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dynamic"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "an object that displays as the dynamically updated current value of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->1795086134],

Cell["Basic dynamic expression.", "Caption",
 CellID->14897435]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dynamic and Controls", "Section",
 CellID->1216082749],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " is often used in connection with controls such as sliders and checkboxes. \
The full range of controls available in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is discussed in ",
 ButtonBox["Control Objects",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ControlObjects"],
 "; primarily, only sliders are used here to illustrate how things work. The \
principles of using ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " with other controls is basically the same."
}], "Text",
 CellID->1100893944],

Cell[TextData[{
 "A slider is created by evaluating the ",
 Cell[BoxData[
  ButtonBox["Slider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider"]], "InlineFormula"],
 " function, in which the first argument is the position and the optional \
second argument specifies the range and step size, with the default range \
from 0 to 1 and the default step size 0."
}], "Text",
 CellID->5414256],

Cell["This is a slider in a centered position.", "MathCaption",
 CellID->992964371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Slider", "[", "0.5", "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->803087418],

Cell[BoxData[
 SliderBox[0.5]], "Output",
 ImageSize->{204, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->639756213]
}, Open  ]],

Cell["\<\
Click on the thumb and move it around. The thumb moves, but nothing else \
happens since the slider is not connected to anything.\
\>", "Text",
 CellID->555512931],

Cell[TextData[{
 "This associates the position of the slider with the current value of the \
variable ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". (This form is explained in more detail later.)"
}], "MathCaption",
 CellID->1394417808],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Slider", "[", 
  RowBox[{"Dynamic", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->491059345],

Cell[BoxData[
 SliderBox[Dynamic[$CellContext`x]]], "Output",
 ImageSize->{204, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->2079535009]
}, Open  ]],

Cell[TextData[{
 "This creates a new dynamic output of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " since the last one has probably scrolled off your screen by now."
}], "MathCaption",
 CellID->454755994],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", "x", "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->189691485],

Cell[BoxData[
 DynamicBox[ToBoxes[$CellContext`x, StandardForm],
  ImageSizeCache->{14., {0., 8.}}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->448541338]
}, Open  ]],

Cell[TextData[{
 "Drag the last slider around. As the slider moves, the value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " changes and the dynamic output updates in real time."
}], "Text",
 CellID->1279056247],

Cell[TextData[{
 "The slider also responds to changes in the value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->787036859],

Cell["To see this, evaluate this line.", "MathCaption",
 CellID->656762560],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "0.8"}], ";"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->1376707340],

Cell[TextData[{
 "You should see the slider jump, and the dynamic output of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " change, simultaneously. "
}], "Text",
 CellID->1331450602],

Cell[TextData[{
 "This creates another ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " slider."
}], "MathCaption",
 CellID->142400340],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Slider", "[", 
  RowBox[{"Dynamic", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->910666074],

Cell[BoxData[
 SliderBox[Dynamic[$CellContext`x]]], "Output",
 ImageSize->{204, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->966666796]
}, Open  ]],

Cell[TextData[{
 "Notice that if you move ",
 StyleBox["either",
  FontSlant->"Italic"],
 " of the two sliders you now have, the other one moves in \"lock sync\". \
Both are connected, dynamically and bi\[Hyphen]directionally, to the current \
value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 "."
}], "Text",
 CellID->448753549]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dynamic and Other Functions", "Section",
 CellID->238329779],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " and control constructs such as ",
 Cell[BoxData[
  ButtonBox["Slider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider"]], "InlineFormula"],
 " are in many ways just like any other functions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". They can occur anywhere in an output, in tables, and even inside typeset \
mathematical expressions. Wherever these functions occur, they carry with \
them the behavior of dynamically displaying or changing in real time the \
current value of the expression or variable they are linked to. ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " is a simple building block, but the rest of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " turns it into a flexible tool for creating nimble, zippy, and often fun \
little interactive displays."
}], "Text",
 CellID->1273086993],

Cell[TextData[{
 "This makes a table of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " sliders, which are updated in sync."
}], "MathCaption",
 CellID->551593998],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", "4", "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2100903934],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`x]], ",", 
   SliderBox[Dynamic[$CellContext`x]], ",", 
   SliderBox[Dynamic[$CellContext`x]], ",", 
   SliderBox[Dynamic[$CellContext`x]]}], "}"}]], "Output",
 ImageSize->{430, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1393516290]
}, Open  ]],

Cell["\<\
You can combine a slider with a display of its current value in a single \
output.\
\>", "MathCaption",
 CellID->1244759934],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2042005311],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`x]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{244, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->371631848]
}, Open  ]],

Cell[TextData[{
 "The great power of ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " lies in the fact that it can display any ",
 StyleBox["function",
  FontSlant->"Italic"],
 " of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " just as easily."
}], "MathCaption",
 CellID->1047099270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"10", "y", " ", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->2116427372],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`x]], ",", 
   DynamicBox[ToBoxes[
     Plot[
      Sin[(10 $CellContext`y) $CellContext`x], {$CellContext`y, 0, 2 Pi}], 
     StandardForm],
    ImageSizeCache->{180., {51., 56.}}]}], "}"}]], "Output",
 ImageSize->{410, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->1818533083]
}, Open  ]],

Cell["\<\
Using integer-valued sliders, you can create dynamically updated algebraic \
expressions.\
\>", "MathCaption",
 CellID->2023195943],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x1", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "10", ",", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", 
    RowBox[{"Expand", "[", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], "x1"], "]"}], "]"}]}], "}"}]], "Input",\

 CellLabel->"In[21]:=",
 CellID->598147403],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`x1], {1, 10, 1}], ",", 
   DynamicBox[ToBoxes[
     Expand[($CellContext`a + $CellContext`b)^$CellContext`x1], StandardForm],
    
    ImageSizeCache->{26.625, {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{256, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->1098261877]
}, Open  ]],

Cell[TextData[{
 "You can use dynamic expressions with ",
 Cell[BoxData[
  ButtonBox["Panel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Panel"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Row",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Row"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Column",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Column"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 ", and other formatting constructs."
}], "MathCaption",
 CellID->692450614],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Panel", "[", 
  RowBox[{"Column", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Row", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Slider", "[", 
         RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
        RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}], "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"10", "y", " ", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", "0", ",", 
          RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], "]"}]}], "}"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->803586405],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      InterpretationBox[
       RowBox[{
        SliderBox[Dynamic[$CellContext`x]], "\[InvisibleSpace]", 
        DynamicBox[ToBoxes[$CellContext`x, StandardForm],
         ImageSizeCache->{10., {0., 8.}}]}],
       Row[{
         Slider[
          Dynamic[$CellContext`x]], 
         Dynamic[$CellContext`x]}]]},
     {
      DynamicBox[ToBoxes[
        Plot[
         Sin[(10 $CellContext`y) $CellContext`x], {$CellContext`y, 0, 2 Pi}], 
        StandardForm],
       ImageSizeCache->{180., {51., 56.}}]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}}],
   "Column"]]], "Output",
 ImageSize->{236, 159},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->865420774]
}, Open  ]],

Cell[TextData[{
 "Notice that the last example resembles the output of ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ". This is no coincidence, because ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " in fact produces a combination of ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 ", controls, and formatting constructs, not fundamentally different from \
what you can do yourself using these lower-level functions."
}], "Text",
 CellID->528228610]
}, Open  ]],

Cell[CellGroupData[{

Cell["Localizing Variables in Dynamic Output", "Section",
 CellID->991221457],

Cell["Here is another copy of a slider connected to a simple plot.", \
"MathCaption",
 CellID->1428378020],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"10", "y", " ", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->29692327],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`x]], ",", 
   DynamicBox[ToBoxes[
     Plot[
      Sin[(10 $CellContext`y) $CellContext`x], {$CellContext`y, 0, 2 Pi}], 
     StandardForm],
    ImageSizeCache->{180., {51., 56.}}]}], "}"}]], "Output",
 ImageSize->{410, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->220207487]
}, Open  ]],

Cell["This is a slider connected to another function.", "MathCaption",
 CellID->822733785],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Tan", "[", 
       RowBox[{"10", "y", " ", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->39521462],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`x]], ",", 
   DynamicBox[ToBoxes[
     Plot[
      Tan[(10 $CellContext`y) $CellContext`x], {$CellContext`y, 0, 2 Pi}], 
     StandardForm],
    ImageSizeCache->{180., {51., 56.}}]}], "}"}]], "Output",
 ImageSize->{410, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->912910228]
}, Open  ]],

Cell[TextData[{
 "If you have both these outputs visible and drag either slider, you will \
notice that they are communicating with each other. Move the slider in one \
example, and the other example moves too. This is because you are using the \
global variable ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " in both examples. Although this can be very useful in some situations, \
most of the time you would probably be happier if these two sliders could be \
moved independently. The solution is a function called ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 "."
}], "Text",
 CellID->664764911],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DynamicModule",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DynamicModule"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["expr", "TI"]}], "]"}], Cell[TextData[{
     "an object which maintains the same local instance of the symbols ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", \[Ellipsis] in the course of all evaluations of ",
     Cell[BoxData[
      ButtonBox["Dynamic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
     " objects in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["DynamicModule",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DynamicModule"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         StyleBox["x", "TI"], "=", 
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["0", "TR"]]}], ",", 
        RowBox[{
         StyleBox["y", "TI"], "=", 
         SubscriptBox[
          StyleBox["y", "TI"], 
          StyleBox["0", "TR"]]}]}], "}"}], ",", 
      StyleBox["expr", "TI"]}], "]"}], Cell[TextData[{
     "specifies initial values for ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", \[Ellipsis] "
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->1304373355],

Cell[TextData[{
 "Localizing and initializing variables for ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " objects."
}], "Caption",
 CellID->1089908909],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " has arguments identical to ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " and is similarly used to localize and initialize variables, but there are \
important differences in how they operate. "
}], "Text",
 CellID->1493927483],

Cell[TextData[{
 "Here are the same two examples with \"private\" values of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->1025731622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", ".5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Slider", "[", 
      RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"10", "y", " ", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", "0", ",", 
          RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->60406057],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 0.5}, 
  RowBox[{"{", 
   RowBox[{
    SliderBox[Dynamic[$CellContext`x$$]], ",", 
    DynamicBox[ToBoxes[
      Plot[
       Sin[(10 $CellContext`y) $CellContext`x$$], {$CellContext`y, 0, 2 Pi}], 
      StandardForm],
     ImageSizeCache->{180., {51., 56.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{410, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->1659027828]
}, Open  ]],

Cell["\<\
Notice that these two examples now work independently of each other.\
\>", "MathCaption",
 CellID->1617103169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", ".5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Slider", "[", 
      RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"Tan", "[", 
         RowBox[{"10", "y", " ", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", "0", ",", 
          RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->1632318615],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 0.5}, 
  RowBox[{"{", 
   RowBox[{
    SliderBox[Dynamic[$CellContext`x$$]], ",", 
    DynamicBox[ToBoxes[
      Plot[
       Tan[(10 $CellContext`y) $CellContext`x$$], {$CellContext`y, 0, 2 Pi}], 
      StandardForm],
     ImageSizeCache->{180., {50., 55.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{410, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->353032548]
}, Open  ]],

Cell[TextData[{
 "Multiple ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 "s can be placed in a single output, and they maintain separate values of \
the variables associated with their respective areas in the output."
}], "MathCaption",
 CellID->347927875],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"DynamicModule", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", "=", ".5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Slider", "[", 
        RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
       RowBox[{"Dynamic", "[", 
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"10", "y", " ", "x"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"y", ",", "0", ",", 
            RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], "]"}]}], "}"}]}], "]"}], 
   ",", "\n", 
   RowBox[{"DynamicModule", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", "=", ".5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Slider", "[", 
        RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
       RowBox[{"Dynamic", "[", 
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"Tan", "[", 
           RowBox[{"10", "y", " ", "x"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"y", ",", "0", ",", 
            RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], "]"}]}], "}"}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->25824344],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   DynamicModuleBox[{$CellContext`x$$ = 0.5}, 
    RowBox[{"{", 
     RowBox[{
      SliderBox[Dynamic[$CellContext`x$$]], ",", 
      DynamicBox[ToBoxes[
        Plot[
         Sin[(10 $CellContext`y) $CellContext`x$$], {$CellContext`y, 0, 2 
          Pi}], StandardForm],
       ImageSizeCache->{180., {51., 56.}}]}], "}"}],
    DynamicModuleValues:>{}], ",", 
   DynamicModuleBox[{$CellContext`x$$ = 0.5}, 
    RowBox[{"{", 
     RowBox[{
      SliderBox[Dynamic[$CellContext`x$$]], ",", 
      DynamicBox[ToBoxes[
        Plot[
         Tan[(10 $CellContext`y) $CellContext`x$$], {$CellContext`y, 0, 2 
          Pi}], StandardForm],
       ImageSizeCache->{180., {50., 55.}}]}], "}"}],
    DynamicModuleValues:>{}]}], "}"}]], "Output",
 ImageSize->{424, 223},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->2068201222]
}, Open  ]],

Cell[TextData[{
 "You might be tempted to use ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " in place of ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 ", and in fact this would appear to work at first. However, it is not a good \
idea for several reasons, which are discussed in more detail in \"",
 ButtonBox["Advanced Dynamic Functionality\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"],
 "."
}], "Reference",
 CellID->238052914],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " does its work in the front end, not in the kernel. It remains unchanged by \
evaluation, and when formatted as output, it creates an invisible object \
embedded in the output expression which handles the localization. As long as \
that space of output remains in existence (e.g. is not deleted), the \
invisible object representing the ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " will maintain the values of the variables, allowing them to be used in \
subsequent evaluations of ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " expressions within the scope (area) of the ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 "."
}], "Text",
 CellID->193291237],

Cell[TextData[{
 "If you save a notebook containing a ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 ", close that notebook, then later reopen it in a new ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, the values of all the local variables will still be preserved and \
the sliders inside the ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " will be in the same positions. This will ",
 StyleBox["not",
  FontSlant->"Italic"],
 " be the case with sliders linked to global variables (like the earliest \
examples in this tutorial), nor with sliders linked to variables localized \
with ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " instead of ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 ". Such variables store their values in the current ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel session, and they are lost as soon as you quit ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->1680269666],

Cell[TextData[{
 "In addition to localizing variables to particular regions of output, ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " provides options to automatically initialize function definitions when an \
expression containing a ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " is opened, and to clean up values when the expression is closed or \
deleted. More details are found in ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 "."
}], "Text",
 CellID->750967949]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Second Argument of Dynamic", "Section",
 CellID->756925424],

Cell[TextData[{
 "Dynamic connections are by default bi\[Hyphen]directional. Sliders \
connected to a variable move together because they both reflect and control \
the value of the same variable. When you drag a slider thumb, the system \
constructs and evaluates expressions of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], "=", 
   StyleBox["new", "TI"]}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is the expression given in the first argument to ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["new", "TI"]], "InlineFormula"],
 " is the proposed new value determined by where you have dragged the slider \
thumb. If the assignment can be done, the new value is accepted. If the \
assignment fails, the slider will not move."
}], "Text",
 CellID->2099959987],

Cell[TextData[{
 "These two sliders move in the opposite direction when you move the first \
one. However, trying to move the second slider gives an error because you \
cannot assign a new value to the expression ",
 Cell[BoxData[
  RowBox[{"1", "-", "x"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->1887921886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Slider", "[", 
      RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
     RowBox[{"Slider", "[", 
      RowBox[{"Dynamic", "[", 
       RowBox[{"1", "-", "x"}], "]"}], "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1232253577],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 0.}, 
  RowBox[{"{", 
   RowBox[{
    SliderBox[Dynamic[$CellContext`x$$]], ",", 
    SliderBox[Dynamic[1 - $CellContext`x$$]]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{430, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->99924951]
}, Open  ]],

Cell[TextData[{
 "You can keep an arbitrary expression in the first argument of ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 ", but change the dynamically executed evaluation by using the optional \
second argument. This is a convenient way to specify \"inverse functions\" \
that update values of variables in the first arguments. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not attempt to deduce such inverse functions automatically from the \
first argument of ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 "; you have to supply one yourself."
}], "Text",
 CellID->106439503],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Dynamic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dynamic"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      StyleBox["f", "TI"]}], "]"}], Cell[TextData[{
     "continually evaluates ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "[", 
       RowBox[{
        StyleBox["val", "TI"], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     " during interactive changing or editing of ",
     Cell[BoxData[
      StyleBox["val", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->253234938],

Cell["Inverse functions.", "Caption",
 CellID->1954498259],

Cell[TextData[{
 "This specifies how the value of ",
 Cell[BoxData["x"], "InlineFormula"],
 " is to be updated and makes the second slider interactive. You can move \
both sliders and the other slider responds by moving in the opposite \
direction."
}], "MathCaption",
 CellID->161205554],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Slider", "[", 
      RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
     RowBox[{"Slider", "[", 
      RowBox[{"Dynamic", "[", 
       RowBox[{
        RowBox[{"1", "-", "x"}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "=", 
           RowBox[{"1", "-", "#"}]}], ")"}], "&"}]}], "]"}], "]"}]}], "}"}]}],
   "]"}]], "Input",
 CellLabel->"In[30]:=",
 CellID->1404867211],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 0.}, 
  RowBox[{"{", 
   RowBox[{
    SliderBox[Dynamic[$CellContext`x$$]], ",", 
    SliderBox[Dynamic[1 - $CellContext`x$$, ($CellContext`x$$ = 1 - #)& ]]}], 
   "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{430, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]=",
 CellID->1532168256]
}, Open  ]],

Cell[TextData[{
 "Now the dynamically executed expression in the second slider is the pure \
function ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "=", 
     RowBox[{"1", "-", "#"}]}], ")"}], "&"}]], "InlineFormula"],
 ", which is given the proposed new value in ",
 Cell[BoxData["#"], "InlineFormula"],
 ". Note that the function is responsible for actually doing the assignment \
to whatever variable you want to change; you cannot just say ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", "#"}], ")"}], "&"}]], "InlineFormula"],
 " if you want to change ",
 Cell[BoxData["x"], "InlineFormula"],
 "."
}], "Text",
 CellID->20516512],

Cell[TextData[{
 "The ability to interpose your own arbitrary function between the mouse \
position and the state of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is very powerful, and you can use it for purposes beyond simple inverse \
functions. The function given in the second argument is effectively free do \
to anything it wants. "
}], "Text",
 CellID->1307587176],

Cell["\<\
This defines \"detents\" that snap the slider to integer values if the thumb \
is within a certain tolerance of a round number.\
\>", "MathCaption",
 CellID->1417507281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Slider", "[", 
      RowBox[{
       RowBox[{"Dynamic", "[", 
        RowBox[{"x", ",", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Abs", "[", 
              RowBox[{"#", "-", 
               RowBox[{"Round", "[", "#", "]"}]}], "]"}], "<", "0.1"}], ",", 
            RowBox[{"x", "=", 
             RowBox[{"Round", "[", "#", "]"}]}], ",", 
            RowBox[{"x", "=", "#"}]}], "]"}], "&"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[31]:=",
 CellID->2008775596],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 0}, 
  RowBox[{"{", 
   RowBox[{
    SliderBox[
     Dynamic[$CellContext`x$$, If[
      Abs[# - Round[#]] < 0.1, $CellContext`x$$ = 
       Round[#], $CellContext`x$$ = #]& ], {0, 5}], ",", 
    DynamicBox[ToBoxes[$CellContext`x$$, StandardForm],
     ImageSizeCache->{7., {0., 8.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{237, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]=",
 CellID->675467415]
}, Open  ]],

Cell["\<\
This makes the variable take on rational numbers (integer fractions) instead \
of decimals.\
\>", "MathCaption",
 CellID->901027485],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Slider", "[", 
      RowBox[{
       RowBox[{"Dynamic", "[", 
        RowBox[{"x", ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"x", "=", 
            RowBox[{"Rationalize", "[", "#", "]"}]}], ")"}], "&"}]}], "]"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[32]:=",
 CellID->1661745398],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 0}, 
  RowBox[{"{", 
   RowBox[{
    SliderBox[
     Dynamic[$CellContext`x$$, ($CellContext`x$$ = Rationalize[#])& ], {0, 
     5}], ",", 
    DynamicBox[ToBoxes[$CellContext`x$$, StandardForm],
     ImageSizeCache->{7., {0., 8.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{237, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[32]=",
 CellID->982285863]
}, Open  ]],

Cell["\<\
For complete control over the tracking behavior it is possible to specify \
separate functions that are called at the start, middle, and end of a mouse \
click on the slider thumb. If you are familiar with conventional \
user\[Hyphen]interface programming, you will recognize these as separate, \
high-level event functions for the mouse\[Hyphen]down, mouse\[Hyphen]drag, \
and mouse\[Hyphen]up events.\
\>", "Text",
 CellID->930074951],

Cell["\<\
This changes the background color while the click-and-drag operation is \
underway.\
\>", "MathCaption",
 CellID->1688743082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "=", "0"}], ",", 
     RowBox[{"bg", "=", 
      RowBox[{"RGBColor", "[", 
       RowBox[{"0", ",", "0", ",", "1"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"Slider", "[", 
      RowBox[{"Dynamic", "[", 
       RowBox[{"x", ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"bg", "=", 
             RowBox[{"RGBColor", "[", 
              RowBox[{"1", ",", "0", ",", "0"}], "]"}]}], ")"}], "&"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"x", "=", "#"}], ")"}], "&"}], ",", "\[IndentingNewLine]",
           
          RowBox[{
           RowBox[{"(", 
            RowBox[{"bg", "=", 
             RowBox[{"RGBColor", "[", 
              RowBox[{"0", ",", "0", ",", "1"}], "]"}]}], ")"}], "&"}]}], 
         "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"Background", "\[Rule]", 
      RowBox[{"Dynamic", "[", "bg", "]"}]}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[33]:=",
 CellID->236234944],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 0, $CellContext`bg$$ = RGBColor[
  0, 0, 1]}, 
  StyleBox[
   SliderBox[
    Dynamic[$CellContext`x$$, {($CellContext`bg$$ = 
      RGBColor[1, 0, 0])& , ($CellContext`x$$ = #)& , ($CellContext`bg$$ = 
      RGBColor[0, 0, 1])& }]],
   StripOnInput->False,
   Background->Dynamic[$CellContext`bg$$]],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{204, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[33]=",
 CellID->1571704952]
}, Open  ]],

Cell[TextData[{
 "The second argument of ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " also lets you restrict the movement of a slider and effectively implement \
geometric constraints."
}], "Text",
 CellID->34112222],

Cell[TextData[{
 "You can only move the thumb of this ",
 Cell[BoxData[
  ButtonBox["Slider2D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider2D"]], "InlineFormula"],
 " along a circle."
}], "MathCaption",
 CellID->1561100422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pt", "=", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"Slider2D", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", 
      RowBox[{"pt", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"pt", "=", 
          RowBox[{"#", "/", 
           RowBox[{"Norm", "[", "#", "]"}]}]}], ")"}], "&"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"Exclusions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[34]:=",
 CellID->2093465052],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pt$$ = {1, 0}}, 
  Slider2DBox[
   Dynamic[$CellContext`pt$$, ($CellContext`pt$$ = #/Norm[#])& ], {-1, 1},
   Exclusions->{0, 0}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{84, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[34]=",
 CellID->1596270164]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Where Should Dynamic Be Placed in an Expression?", "Section",
 CellID->1063215934],

Cell[TextData[{
 "The fundamental behavior of ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " is to build a copy of the input expression into the output cell",
 ". ",
 "To be more specific, ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " has the attribute ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 " and remains unchanged by evaluation."
}], "Text",
 CellID->258776051],

Cell[TextData[{
 "The result of evaluating ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   RowBox[{
    StyleBox["x", "TI"], "+", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   RowBox[{
    StyleBox["x", "TI"], "+", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ", which you can see by examining the ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " representation of the output."
}], "MathCaption",
 CellID->1607077155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Dynamic", "[", 
   RowBox[{"x", "+", "y"}], "]"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[35]:=",
 CellID->594703982],

Cell["Dynamic[x + y]", "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[35]//InputForm=",
 CellID->2146928024]
}, Open  ]],

Cell[TextData[{
 "You do not see ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " in ordinary output because, when formatted for display in the front end, \
",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   RowBox[{
    StyleBox["x", "TI"], "+", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " is represented by an object that contains a copy of the unevaluated input \
(",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "+", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 "), but displays as the evaluated value of that expression. The ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " wrapper is still present in the output, but it is invisible."
}], "Text",
 CellID->800932336],

Cell[TextData[{
 "Because ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " does its work entirely in the front end, you cannot use it inside \
functions that need to access the value of an expression in order to do their \
work."
}], "Text",
 CellID->842271756],

Cell["For example, this works.", "MathCaption",
 CellID->1243915766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Slider", "[", 
      RowBox[{
       RowBox[{"Dynamic", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"x", " ", "i"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "0", ",", 
          RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[36]:=",
 CellID->1996685715],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 1.}, 
  RowBox[{"{", 
   RowBox[{
    SliderBox[Dynamic[$CellContext`x$$], {1, 5}], ",", 
    DynamicBox[ToBoxes[
      Plot[
       Sin[$CellContext`x$$ $CellContext`i], {$CellContext`i, 0, 2 Pi}], 
      StandardForm],
     ImageSizeCache->{180., {51., 56.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{410, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[36]=",
 CellID->1399062474]
}, Open  ]],

Cell["But this does not.", "MathCaption",
 CellID->1717343983],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Slider", "[", 
      RowBox[{
       RowBox[{"Dynamic", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{
         RowBox[{"Dynamic", "[", "x", "]"}], "i"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", 
         RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[37]:=",
 CellID->1220106601],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 1.}, 
  RowBox[{"{", 
   RowBox[{
    SliderBox[Dynamic[$CellContext`x$$], {1, 5}], ",", 
    GraphicsBox[{},
     AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
     Axes->True,
     Method->{},
     PlotRange->
      NCache[{{0, 2 Pi}, {0., 0.}}, {{0, 6.28318530717959}, {0., 0.}}],
     PlotRangeClipping->True,
     PlotRangePadding->{
       Scaled[0.02], 
       Scaled[0.02]}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{410, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[37]=",
 CellID->1244549515]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " command needs to have specific numerical values for ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " to make a plot, but the ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " inside the function being plotted does not ",
 StyleBox["evaluate",
  FontSlant->"Italic"],
 " into anything in the kernel. It remains inert as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ", preventing the ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " command from doing anything sensible."
}], "Text",
 CellID->10297804],

Cell[TextData[{
 "Another way to look at it is that the expression inside a ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " command does not appear directly anywhere in the output.  ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " is a formatting function that does its work in the front end, not in the \
kernel, so if it is used in a way where it will never be placed as output, it \
is probably a mistake."
}], "Text",
 CellID->1276500068],

Cell[TextData[{
 "When combining ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " with controls, it is particularly important to get the ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " in the right place."
}], "Text",
 CellID->775009346],

Cell[TextData[{
 "This example works as expected; move the slider and the value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " changes."
}], "MathCaption",
 CellID->738975617],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "0.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Slider", "[", 
      RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
     RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[38]:=",
 CellID->1093759167],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 0.5}, 
  RowBox[{"{", 
   RowBox[{
    SliderBox[Dynamic[$CellContext`x$$]], ",", 
    DynamicBox[ToBoxes[$CellContext`x$$, StandardForm],
     ImageSizeCache->{21., {0., 8.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{251, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[38]=",
 CellID->652976825]
}, Open  ]],

Cell[TextData[{
 "This example looks good at first, but if you move the slider, ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " does not change."
}], "MathCaption",
 CellID->350301449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "0.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Dynamic", "[", 
      RowBox[{"Slider", "[", "x", "]"}], "]"}], ",", 
     RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[39]:=",
 CellID->1263776916],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 0.5}, 
  RowBox[{"{", 
   RowBox[{
    DynamicBox[ToBoxes[
      Slider[$CellContext`x$$], StandardForm],
     ImageSizeCache->{200., {9., 14.}}], ",", 
    DynamicBox[ToBoxes[$CellContext`x$$, StandardForm],
     ImageSizeCache->{21., {0., 8.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{251, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[39]=",
 CellID->940061605]
}, Open  ]],

Cell[TextData[{
 "That is because when the ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " wrapped around ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Slider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " evaluates its contents, the value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is substituted, and the result is a slider whose first argument is a \
specific number, with no trace of the variable name left. The slider in this \
case is a ",
 StyleBox["dynamic",
  FontSlant->"Italic"],
 " display of a ",
 StyleBox["static",
  FontSlant->"Italic"],
 " slider."
}], "Text",
 CellID->1685358382],

Cell[TextData[{
 "What is needed is a ",
 StyleBox["static",
  FontSlant->"Italic"],
 " slider, which contains within it a ",
 StyleBox["dynamic",
  FontSlant->"Italic"],
 " reference to the value of the variable. In the case of controls there is a \
simple rule for where to put the ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 ". The first argument of any control function, such as ",
 Cell[BoxData[
  ButtonBox["Slider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Checkbox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Checkbox"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["PopupMenu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupMenu"]], "InlineFormula"],
 ", will almost always be ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   StyleBox["var", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Text",
 CellID->509022344],

Cell[TextData[{
 "Beyond these cases where ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " will ",
 StyleBox["not",
  FontSlant->"Italic"],
 " work in a particular position, there is often a great deal of flexibility \
about where to place ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 ". It is often used as the outermost function in an input expression, but \
this is by no means necessary, and in more sophisticated applications, ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " is usually used deeper in the expression and can even be nested."
}], "Text",
 CellID->1711169607],

Cell[TextData[{
 "This displays a table of ten copies of the value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->526584225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"Table", "[", 
   RowBox[{"x", ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[40]:=",
 CellID->520960288],

Cell[BoxData[
 DynamicBox[ToBoxes[
   Table[$CellContext`x, {$CellContext`i, 10}], StandardForm],
  ImageSizeCache->{254.6875, {2., 8.}}]], "Output",
 ImageSize->{259, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[40]=",
 CellID->578204256]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " is wrapped around the whole expression, so evaluation of the ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " command is delayed until the output is displayed in the notebook. Any time \
the value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is changed, the ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " command will be re-evaluated."
}], "Text",
 CellID->488731597],

Cell["The output from this example looks exactly the same.", "MathCaption",
 CellID->2134484651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Dynamic", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[41]:=",
 CellID->569206222],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{259, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[41]=",
 CellID->515427917]
}, Open  ]],

Cell[TextData[{
 "But in this case the ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " command is evaluated immediately, generating a list of ten separate ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " expressions, each of which evaluates ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " separately after the overall result has been placed in the notebook."
}], "Text",
 CellID->1756809416],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is changed, the first example sends a single request to the kernel to get \
the value of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Table",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Table"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["i", "TI"], ",", "10"}], "}"}]}], "]"}]], "InlineFormula"],
 ", while the second example sends ten separate requests to the kernel to get \
the value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". It might seem that the first example is obviously more efficient, and in \
this case it is. However, you should also avoid the other extreme, wrapping \
two many things into a single ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 ", which can also be inefficient."
}], "Text",
 CellID->943192109],

Cell[TextData[{
 "This initializes ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " to set up a new slider connected to the value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->1065264318],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "0.5"}], ";"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1743645400],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "=", 
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"n", " ", "m"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"m", ",", "0", ",", "4"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->74848970],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Slider", "[", 
  RowBox[{"Dynamic", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->886390838],

Cell[BoxData[
 SliderBox[Dynamic[$CellContext`x]]], "Output",
 ImageSize->{204, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->199321650]
}, Open  ]],

Cell[TextData[{
 "This is a tab view with two groups of dynamic expressions, both showing the \
dynamic values of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " (a simple number) and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " (a 3D plot)."
}], "MathCaption",
 CellID->476755027],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Dynamic", "[", "x", "]"}], ",", 
      RowBox[{"Dynamic", "[", "y", "]"}]}], "}"}], ",", 
    RowBox[{"Dynamic", "[", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->560251832],

Cell[BoxData[
 TabViewBox[{{1,"1"->
  RowBox[{"{", 
   RowBox[{
    DynamicBox[ToBoxes[$CellContext`x, StandardForm],
     ImageSizeCache->{14., {0., 8.}}], ",", 
    DynamicBox[ToBoxes[$CellContext`y, StandardForm],
     ImageSizeCache->{7., {2., 6.}}]}], "}"}]}, {2,"2"->
  DynamicBox[ToBoxes[{$CellContext`x, $CellContext`y}, StandardForm],
   ImageSizeCache->{46.1875, {2., 8.}}]}}, 1]], "Output",
 ImageSize->{65, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->2071965877]
}, Open  ]],

Cell[TextData[{
 "Drag the slider around, and note that the value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " in the first tab updates quite rapidly. On most computers it will be \
essentially instantaneous. However, updates are more sluggish in the second \
tab. Each individual ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " expression keeps track (quite carefully) of exactly when it might need to \
be re-evaluated in order to remain up-to-date. In the second tab, the output \
is forcing the whole expression ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "}"}]], "InlineFormula"],
 ", including the large, slow 3D plot, to be re-evaluated every time the \
value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " changes. By using two separate ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " expressions in the first tab, you allow the value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " to be updated without needing to also re-evaluate ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ", which has not actually changed. (You may want to delete the last output \
before proceeding, as it will slow down any examples containing the global ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " as long as it is visible on screen.)"
}], "Text",
 CellID->1584231976],

Cell[TextData[{
 "It is hard to make blanket statements about where ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " should be placed in every case, but generally speaking if you are building \
a large, complex output where only small parts of it will change, the ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " should probably be wrapped just around those parts. On the other hand, if \
all or most of the output is going to change in response to a single variable \
changing its value, then it is probably best to wrap ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " around the whole thing."
}], "Text",
 CellID->587426909]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dynamic in Options", "Section",
 CellID->901734304],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " can be used on the right-hand side of options, in those cases where the \
option value will be transmitted to the front end before being used. This is \
a somewhat subtle distinction related to the earlier discussion about where \
",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " should be placed in an expression."
}], "Text",
 CellID->656350449],

Cell[TextData[{
 "An option like ",
 Cell[BoxData[
  ButtonBox["PlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotPoints"]], "InlineFormula"],
 " in plotting commands cannot have ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " on the right-hand side, because the plotting command needs to know a \
specific numerical value before the plot can be generated. Remember that ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " has the effect of delaying evaluation until the expression reaches the \
front end, and in the case of ",
 Cell[BoxData[
  ButtonBox["PlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotPoints"]], "InlineFormula"],
 ", that is too late since the value is needed right away. On the other hand, \
options to functions that do their work in the front end can usually, and \
usefully, accept ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " in their option values."
}], "Text",
 CellID->1805985351],

Cell["\<\
For example, you can control the size of a block of text in two ways.\
\>", "Text",
 CellID->513998664],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " can be wrapped around a whole ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " expression."
}], "MathCaption",
 CellID->326227587],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "=", "12"}], ";"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->1051192653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "h", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "100"}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", 
    RowBox[{"Style", "[", 
     RowBox[{"\"\<Some Text\>\"", ",", 
      RowBox[{"FontSize", "\[Rule]", "h"}]}], "]"}], "]"}]}], "}"}]], "Input",\

 CellLabel->"In[11]:=",
 CellID->2083158634],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`h], {6, 100}], ",", 
   DynamicBox[ToBoxes[
     Style["Some Text.", FontSize -> $CellContext`x], StandardForm],
    ImageSizeCache->{10., {1., 1.}}]}], "}"}]], "Output",
 ImageSize->{240, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->1221264597]
}, Open  ]],

Cell[TextData[{
 "Or ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " can be only in the ",
 Cell[BoxData[
  ButtonBox["FontSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontSize"]], "InlineFormula"],
 " option value."
}], "MathCaption",
 CellID->46955102],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "h", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "100"}], "}"}]}], "]"}], ",", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<Some Text\>\"", ",", 
     RowBox[{"FontSize", "\[Rule]", 
      RowBox[{"Dynamic", "[", "h", "]"}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[59]:=",
 CellID->1047900865],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`h], {6, 100}], ",", 
   StyleBox["\<\"Some Text\"\>",
    StripOnInput->False,
    FontSize->Dynamic[$CellContext`h]]}], "}"}]], "Output",
 ImageSize->{266, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[59]=",
 CellID->923719870]
}, Open  ]],

Cell[TextData[{
 "There are two potential advantages to putting the ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " in the option value. First, if the dynamically regenerated expression is \
very large, in this case the block of text can be an entire document, it is \
inefficient to re\[Hyphen]transmit it from the kernel to the front end every \
time the font size is changed, as is necessary if ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " encloses the whole expression."
}], "Text",
 CellID->556449008],

Cell[TextData[{
 "Second, the output of a ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " expression is not editable (since it is liable to be regenerated at any \
moment), which makes the output of the first example non\[Hyphen]editable. \
But the text in the second example can be edited freely since it is ordinary \
static output: only the option value is dynamic."
}], "Text",
 CellID->2094678418],

Cell["\<\
Dynamic option values can be also set in the Option Inspector. They are \
allowed at the cell, notebook, or global level, and in stylesheets. (Note, \
however, that if you set a dynamic option value in a position where the value \
will be inherited by many cells, for example in a stylesheet, there can be a \
significant impact on performance.)\
\>", "Text",
 CellID->1560746055],

Cell[TextData[{
 "You can set dynamic option values through ",
 Cell[BoxData[
  ButtonBox["SetOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetOptions"]], "InlineFormula"],
 ", as well."
}], "MathCaption",
 CellID->381303918],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "0"}], ";"}]], "Input",
 CellLabel->"In[51]:=",
 CellID->2093681927],

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{
   RowBox[{"EvaluationNotebook", "[", "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"Dynamic", "[", 
     RowBox[{"Hue", "[", "x", "]"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[51]:=",
 CellID->1775830032],

Cell[TextData[{
 "Having linked the background color of the notebook to the global variable \
",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", it can now be controlled by a slider, or by a program."
}], "MathCaption",
 CellID->1992590994],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Slider", "[", 
  RowBox[{"Dynamic", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[52]:=",
 CellID->1616844840],

Cell[BoxData[
 SliderBox[Dynamic[$CellContext`x]]], "Output",
 ImageSize->{204, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[52]=",
 CellID->1162855972]
}, Open  ]],

Cell["Of course, it is good to be able to return to normal.", "MathCaption",
 CellID->53156742],

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{
   RowBox[{"EvaluationNotebook", "[", "]"}], ",", 
   RowBox[{"Background", "\[Rule]", "Inherited"}]}], "]"}]], "Input",
 CellLabel->"In[53]:=",
 CellID->52165642]
}, Open  ]],

Cell[CellGroupData[{

Cell[" Dynamic and Infinite Loops", "Section",
 CellID->574617118],

Cell[TextData[{
 "If you are not careful, you can easily throw ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " into an infinite loop."
}], "Text",
 CellID->220288465],

Cell["\<\
This counts upwards as fast as possible for as long as it remains on screen.\
\>", "MathCaption",
 CellID->355941667],

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "1"}], "}"}], ",", 
   RowBox[{"Dynamic", "[", 
    RowBox[{"x", "=", 
     RowBox[{"x", "+", "1"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[54]:=",
 CellID->1569640374],

Cell["\<\
This is not a bug (but delete the above output if it is distracting you to \
have it there).\
\>", "Text",
 CellID->1256646070],

Cell[TextData[{
 "Because the output is updated and the screen redrawn after each cycle of an \
infinite loop, it is actually quite a useful thing to be able to do. \
Generally speaking, the system will remain responsive to typing, evaluation, \
and so on, even as the infinitely updating ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " zips along."
}], "Text",
 CellID->2096313892],

Cell[TextData[{
 "It is also useful to make such a self\[Hyphen]triggering ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " that stops changing at some point."
}], "Text",
 CellID->1130870162],

Cell["\<\
This is a \"droopy\" slider, which always drops back to zero no matter what \
you drag it to.\
\>", "MathCaption",
 CellID->126423827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"VerticalSlider", "[", 
      RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"x", "=", 
       RowBox[{"Max", "[", 
        RowBox[{"0", ",", 
         RowBox[{"x", "-", "0.01"}]}], "]"}]}], "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[55]:=",
 CellID->1304536784],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 0}, 
  RowBox[{"{", 
   RowBox[{
    SliderBox[Dynamic[$CellContext`x$$],
     Appearance->"Vertical"], ",", 
    DynamicBox[
     ToBoxes[$CellContext`x$$ = Max[0, $CellContext`x$$ - 0.01], 
      StandardForm],
     ImageSizeCache->{7., {0., 8.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{60, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[55]=",
 CellID->1043573234]
}, Open  ]],

Cell[TextData[{
 "If you have a CPU monitor running, you will see that while the slider is \
dropping there is a small load on the CPU (for redrawing the screen, \
primarily), but once it reaches zero, the load drops to nothing. The dynamic \
tracking system has noticed that the value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " did not change: therefore, further updating is not necessary until someone \
else changes the value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " again (e.g. when you click on the slider). \"",
 ButtonBox["Advanced Dynamic Functionality\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"],
 " describes in more detail how the dynamic tracking system works."
}], "Text",
 CellID->1689176465]
}, Open  ]],

Cell[CellGroupData[{

Cell["A Good Trick to Know", "Section",
 CellID->2125133640],

Cell[TextData[{
 "Because it has the attribute ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " does not evaluate its first argument. This is fundamental to the workings \
of ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 ", but it can lead to a somewhat unexpected behavior."
}], "Text",
 CellID->173070576],

Cell["\<\
For example, suppose you have a list of numbers you wish to be able to modify \
by creating one slider to control each value. \
\>", "Text",
 CellID->1104312794],

Cell["\<\
This creates the list and a dynamic display of its current value.\
\>", "MathCaption",
 CellID->2113216751],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{".1", ",", ".5", ",", ".3", ",", ".9", ",", ".2"}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1631451384],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->943933506],

Cell[BoxData[
 DynamicBox[ToBoxes[$CellContext`data, StandardForm],
  ImageSizeCache->{575.3125, {13484., 12.}}]], "Output",
 ImageSize->{580, 13497},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->431937511]
}, Open  ]],

Cell[TextData[{
 "This attempts to make a table of sliders, one for each element of the list, \
using ",
 Cell[BoxData[
  RowBox[{
   StyleBox["list", "TI"], "[", 
   RowBox[{"[", 
    StyleBox["i", "TI"], "]"}], "]"}]], "InlineFormula"],
 " to access the individual members"
}], "MathCaption",
 CellID->732205992],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{"Dynamic", "[", 
     RowBox[{"data", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1104810234],

Cell["\<\
Surprisingly, this does not work! You can see an error indication around the \
sliders, they cannot be moved, and the dynamic output above never changes. \
You might even jump to the conclusion that part extraction syntax cannot be \
used in this way with controls. Nothing could be further from the truth.\
\>", "Text",
 CellID->1401990876],

Cell[TextData[{
 "The problem is that the variable ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " was given a temporary value by the ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " command, but that value was never used, because ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1070078048],

Cell[TextData[{
 "Looking at the ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " of the table of sliders reveals the problem."
}], "MathCaption",
 CellID->1749379971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Slider", "[", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"data", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "5"}], "}"}]}], "]"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[59]:=",
 CellID->1773692758],

Cell["\<\
{Slider[Dynamic[data[[i]]]], Slider[Dynamic[data[[i]]]], 
 Slider[Dynamic[data[[i]]]], Slider[Dynamic[data[[i]]]], 
 Slider[Dynamic[data[[i]]]]}\
\>", "Output",
 ImageSize->{399, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[59]//InputForm=",
 CellID->1526179699]
}, Open  ]],

Cell[TextData[{
 "What is needed is to do a replacement of the variable ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " with its temporary value, even inside held expressions. "
}], "Text",
 CellID->1233679699],

Cell[TextData[{
 "This can be done with ",
 Cell[BoxData[
  ButtonBox["/.",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceAll"]], "InlineFormula"],
 " or with the somewhat peculiar but convenient idiomatic form demonstrated \
here."
}], "MathCaption",
 CellID->630561520],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i", "=", "i"}], "}"}], ",", 
     RowBox[{"Slider", "[", 
      RowBox[{"Dynamic", "[", 
       RowBox[{"data", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "]"}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[60]:=",
 CellID->500089308],

Cell[TextData[{
 "This output shows that ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " does in fact work perfectly with part extraction syntax, a very useful \
property."
}], "Text",
 CellID->1897488845]
}, Open  ]],

Cell[CellGroupData[{

Cell["Slow Evaluations inside Dynamic", "Section",
 CellID->962859965],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " wrapped around an expression that will take forever, or even more than \
just a few seconds, to finish evaluating is a bad thing."
}], "Text",
 CellID->1498151610],

Cell[TextData[{
 "If you evaluate this example, you will have to wait about 5 seconds before \
seeing the output ",
 Cell[BoxData[
  ButtonBox["$Aborted",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Aborted"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->188348195],

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"While", "[", "True", "]"}], "]"}]], "Input",
 CellLabel->"In[61]:=",
 CellID->177217687],

Cell[TextData[{
 "During the wait for the ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " output to evaluate, the front end is frozen, and no typing or other action \
is possible. Because updating of ordinary dynamic output locks up the front \
end, it is important to restrict the expressions you put inside ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " to things that will evaluate relatively quickly (preferably, within a \
second or so). Fortunately computers, and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", are fast, so a wide range of functions, including complex 2D and 3D \
plots, can easily be evaluated in a fraction of a second."
}], "Text",
 CellID->2085330667],

Cell[TextData[{
 "To avoid locking up the front end for good, dynamic evaluations are \
internally wrapped in ",
 Cell[BoxData[
  ButtonBox["TimeConstrained",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimeConstrained"]], "InlineFormula"],
 ", with a timeout value of, by default, 5 seconds. (This can be changed with \
the ",
 Cell[BoxData["DynamicEvaluationTimeout"], "InlineFormula"],
 " option.) In certain extreme cases, ",
 Cell[BoxData[
  ButtonBox["TimeConstrained",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimeConstrained"]], "InlineFormula"],
 " can fail to abort the calculation, in which case the front end will, a few \
seconds later, put up a dialog box allowing you to terminate dynamic updating \
until the offending output has been deleted."
}], "Text",
 CellID->1219401229],

Cell[TextData[{
 "Fortunately there is an alternative if you need to have something slow in a \
",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 ". The option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SynchronousUpdating",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SynchronousUpdating"], "\[Rule]", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " allows the dynamic to be evaluated in a way that does not lock up the \
front end. During evaluation of such an asynchronous ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " the front end continues operating as usual, but the main ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Enter", "KeyEvent"],
 " evaluation queue is occupied evaluating the ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 ", so further ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Enter", "KeyEvent"],
 " evaluations will wait until the ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " finishes. (Normal synchronous ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " evaluations do not interfere with ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Enter", "KeyEvent"],
 " evaluations.)"
}], "Text",
 CellID->1040012482],

Cell["\<\
Evaluate this example, and you will see a gray placeholder rectangle for \
about 10 seconds, after which the result will be displayed.\
\>", "MathCaption",
 CellID->1120382041],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"DateList", "[", "]"}], ",", 
     RowBox[{
      RowBox[{"Pause", "[", "10", "]"}], ";", 
      RowBox[{"DateList", "[", "]"}]}]}], "}"}], ",", 
   RowBox[{"SynchronousUpdating", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[62]:=",
 CellID->1124346191],

Cell[BoxData[
 DynamicBox[ToBoxes[{
    Date[], Pause[10]; Date[]}, StandardForm],
  ImageSizeCache->{445.0625, {2., 8.}},
  SynchronousUpdating->False]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{450, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[62]=",
 CellID->408910586]
}, Open  ]],

Cell["\<\
Importantly, during that 10\[Hyphen]second pause you are free to continue \
working on other things in the front end.\
\>", "Text",
 CellID->1177822184],

Cell[TextData[{
 ButtonBox["\"Advanced Dynamic Functionality\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"],
 " gives more details about the differences between synchronous and \
asynchronous dynamic evaluations. In general, you should not plan to use \
asynchronous ones unless is it absolutely necessary. They do not update as \
quickly, and can interact in a very surprising, though not technically \
incorrect, way with controls and other synchronous evaluations."
}], "Text",
 CellID->153188442]
}, Open  ]],

Cell[CellGroupData[{

Cell["Further Reading", "Section",
 CellID->1952735588],

Cell[TextData[{
 "The implementation details behind ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " are worth understanding if you plan to use complex constructions, \
particularly those involving nested ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " expressions. This is discussed in ",
 ButtonBox["\"Advanced Dynamic Functionality\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"],
 "."
}], "Text",
 CellID->284429183],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->505375963],

Cell[TextData[ButtonBox["Dynamic Interactivity Language",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DynamicInteractivityLanguage"]], "TutorialMoreAbout",
 CellID->346793833],

Cell[TextData[ButtonBox["Dynamic Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicVisualization"]], "TutorialMoreAbout",
 CellID->116159589]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->62154653],

Cell[TextData[ButtonBox["Advanced Dynamic Functionality",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AdvancedDynamicFunctionality"]], "RelatedTutorials",
 CellID->444978337],

Cell[TextData[ButtonBox["Introduction to Manipulate",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToManipulate"]], "RelatedTutorials",\

 CellID->894362159]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->81337975],

Cell[TextData[ButtonBox["M205: Visualization and Dynamic Interactivity",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://www.wolfram.com/services/education/minicourses/m205.html"], 
   None}]], "TutorialRelatedLinks",
 CellID->228912486]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Introduction to Dynamic - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 2.4592340}", "context" -> "", 
    "keywords" -> {"reactive programming"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "This tutorial describes the principles behind Dynamic, DynamicModule and \
related functions, and goes into detail about how they interact with each \
other and with the rest of Mathematica. These functions are the foundation of \
a higher-level function Manipulate that provides a simple yet powerful way of \
creating a great many interactive examples, programs, and demonstrations, all \
in a very convenient, though relatively rigid, structure. If that structure \
solves the problem at hand, you need look no further than Manipulate and you \
do not need to read this tutorial. However, do continue with this tutorial if \
you want to build a wider range of structures, including complex user \
interfaces. Ordinary Mathematica sessions consist of a series of static \
inputs and outputs, which forms a record of calculations done in the order in \
which they were entered.", "synonyms" -> {}, "title" -> 
    "Introduction to Dynamic", "type" -> "Tutorial", "uri" -> 
    "tutorial/IntroductionToDynamic"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2278, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2903, 83, 61, 1, 70, "Title",
 CellID->1627681926],
Cell[2967, 86, 519, 17, 70, "Text",
 CellID->296418628],
Cell[3489, 105, 804, 18, 70, "Text",
 CellID->1485096622],
Cell[4296, 125, 350, 8, 70, "TextEmphasisNote",
 CellID->244159640],
Cell[CellGroupData[{
Cell[4671, 137, 75, 1, 70, "Section",
 CellID->191800398],
Cell[4749, 140, 258, 7, 70, "Text",
 CellID->216335039],
Cell[5010, 149, 105, 2, 70, "MathCaption",
 CellID->253186102],
Cell[5118, 153, 111, 4, 70, "Input",
 CellID->1133711607],
Cell[CellGroupData[{
Cell[5254, 161, 94, 3, 28, "Input",
 CellID->1816062665],
Cell[5351, 166, 160, 5, 36, "Output",
 CellID->1971677972]
}, Open  ]],
Cell[5526, 174, 110, 4, 70, "Input",
 CellID->380135844],
Cell[CellGroupData[{
Cell[5661, 182, 93, 3, 70, "Input",
 CellID->179280283],
Cell[5757, 187, 159, 5, 36, "Output",
 CellID->171518547]
}, Open  ]],
Cell[5931, 195, 598, 15, 70, "Text",
 CellID->1897303710],
Cell[6532, 212, 220, 7, 70, "MathCaption",
 CellID->2146263314],
Cell[6755, 221, 127, 4, 70, "Input",
 CellID->964699739],
Cell[6885, 227, 570, 15, 70, "Text",
 CellID->206978523],
Cell[7458, 244, 147, 4, 70, "MathCaption",
 CellID->1321105872],
Cell[7608, 250, 110, 4, 70, "Input",
 CellID->233129668],
Cell[7721, 256, 112, 4, 70, "Input",
 CellID->1200157948],
Cell[7836, 262, 112, 4, 70, "Input",
 CellID->1888219412],
Cell[7951, 268, 417, 11, 70, "Text",
 CellID->1937805765],
Cell[8371, 281, 443, 10, 70, "Text",
 CellID->1077141161],
Cell[8817, 293, 252, 7, 70, "MathCaption",
 CellID->2111985600],
Cell[9072, 302, 252, 9, 70, "Input",
 CellID->384777937],
Cell[9327, 313, 288, 10, 70, "Input",
 CellID->889526042],
Cell[9618, 325, 110, 4, 70, "Input",
 CellID->224348717],
Cell[9731, 331, 401, 12, 70, "DefinitionBox",
 CellID->1795086134],
Cell[10135, 345, 63, 1, 70, "Caption",
 CellID->14897435]
}, Open  ]],
Cell[CellGroupData[{
Cell[10235, 351, 60, 1, 70, "Section",
 CellID->1216082749],
Cell[10298, 354, 721, 21, 70, "Text",
 CellID->1100893944],
Cell[11022, 377, 397, 10, 70, "Text",
 CellID->5414256],
Cell[11422, 389, 83, 1, 70, "MathCaption",
 CellID->992964371],
Cell[CellGroupData[{
Cell[11530, 394, 105, 3, 70, "Input",
 CellID->803087418],
Cell[11638, 399, 173, 6, 70, "Output",
 CellID->639756213]
}, Open  ]],
Cell[11826, 408, 173, 4, 70, "Text",
 CellID->555512931],
Cell[12002, 414, 253, 7, 70, "MathCaption",
 CellID->1394417808],
Cell[CellGroupData[{
Cell[12280, 425, 137, 4, 70, "Input",
 CellID->491059345],
Cell[12420, 431, 194, 6, 70, "Output",
 CellID->2079535009]
}, Open  ]],
Cell[12629, 440, 222, 6, 70, "MathCaption",
 CellID->454755994],
Cell[CellGroupData[{
Cell[12876, 450, 104, 3, 70, "Input",
 CellID->189691485],
Cell[12983, 455, 242, 7, 70, "Output",
 CellID->448541338]
}, Open  ]],
Cell[13240, 465, 230, 6, 70, "Text",
 CellID->1279056247],
Cell[13473, 473, 167, 6, 70, "Text",
 CellID->787036859],
Cell[13643, 481, 75, 1, 70, "MathCaption",
 CellID->656762560],
Cell[13721, 484, 114, 4, 70, "Input",
 CellID->1376707340],
Cell[13838, 490, 197, 6, 70, "Text",
 CellID->1331450602],
Cell[14038, 498, 149, 6, 70, "MathCaption",
 CellID->142400340],
Cell[CellGroupData[{
Cell[14212, 508, 137, 4, 70, "Input",
 CellID->910666074],
Cell[14352, 514, 193, 6, 70, "Output",
 CellID->966666796]
}, Open  ]],
Cell[14560, 523, 349, 11, 70, "Text",
 CellID->448753549]
}, Open  ]],
Cell[CellGroupData[{
Cell[14946, 539, 66, 1, 70, "Section",
 CellID->238329779],
Cell[15015, 542, 1042, 27, 70, "Text",
 CellID->1273086993],
Cell[16060, 571, 178, 6, 70, "MathCaption",
 CellID->551593998],
Cell[CellGroupData[{
Cell[16263, 581, 219, 7, 70, "Input",
 CellID->2100903934],
Cell[16485, 590, 365, 11, 70, "Output",
 CellID->1393516290]
}, Open  ]],
Cell[16865, 604, 134, 4, 70, "MathCaption",
 CellID->1244759934],
Cell[CellGroupData[{
Cell[17024, 612, 221, 7, 70, "Input",
 CellID->2042005311],
Cell[17248, 621, 326, 10, 70, "Output",
 CellID->371631848]
}, Open  ]],
Cell[17589, 634, 375, 14, 70, "MathCaption",
 CellID->1047099270],
Cell[CellGroupData[{
Cell[17989, 652, 439, 14, 70, "Input",
 CellID->2116427372],
Cell[18431, 668, 409, 13, 70, "Output",
 CellID->1818533083]
}, Open  ]],
Cell[18855, 684, 141, 4, 70, "MathCaption",
 CellID->2023195943],
Cell[CellGroupData[{
Cell[19021, 692, 432, 15, 70, "Input",
 CellID->598147403],
Cell[19456, 709, 398, 12, 70, "Output",
 CellID->1098261877]
}, Open  ]],
Cell[19869, 724, 603, 23, 70, "MathCaption",
 CellID->692450614],
Cell[CellGroupData[{
Cell[20497, 751, 663, 21, 70, "Input",
 CellID->803586405],
Cell[21163, 774, 772, 26, 70, "Output",
 CellID->865420774]
}, Open  ]],
Cell[21950, 803, 684, 19, 70, "Text",
 CellID->528228610]
}, Open  ]],
Cell[CellGroupData[{
Cell[22671, 827, 77, 1, 70, "Section",
 CellID->991221457],
Cell[22751, 830, 106, 2, 70, "MathCaption",
 CellID->1428378020],
Cell[CellGroupData[{
Cell[22882, 836, 437, 14, 70, "Input",
 CellID->29692327],
Cell[23322, 852, 408, 13, 70, "Output",
 CellID->220207487]
}, Open  ]],
Cell[23745, 868, 90, 1, 70, "MathCaption",
 CellID->822733785],
Cell[CellGroupData[{
Cell[23860, 873, 437, 14, 70, "Input",
 CellID->39521462],
Cell[24300, 889, 408, 13, 70, "Output",
 CellID->912910228]
}, Open  ]],
Cell[24723, 905, 701, 16, 70, "Text",
 CellID->664764911],
Cell[25427, 923, 1703, 56, 70, "DefinitionBox",
 CellID->1304373355],
Cell[27133, 981, 228, 8, 70, "Caption",
 CellID->1089908909],
Cell[27364, 991, 449, 13, 70, "Text",
 CellID->1493927483],
Cell[27816, 1006, 180, 6, 70, "MathCaption",
 CellID->1025731622],
Cell[CellGroupData[{
Cell[28021, 1016, 576, 19, 70, "Input",
 CellID->60406057],
Cell[28600, 1037, 494, 15, 70, "Output",
 CellID->1659027828]
}, Open  ]],
Cell[29109, 1055, 120, 3, 70, "MathCaption",
 CellID->1617103169],
Cell[CellGroupData[{
Cell[29254, 1062, 578, 19, 70, "Input",
 CellID->1632318615],
Cell[29835, 1083, 493, 15, 70, "Output",
 CellID->353032548]
}, Open  ]],
Cell[30343, 1101, 343, 9, 70, "MathCaption",
 CellID->347927875],
Cell[CellGroupData[{
Cell[30711, 1114, 1198, 38, 70, "Input",
 CellID->25824344],
Cell[31912, 1154, 915, 27, 70, "Output",
 CellID->2068201222]
}, Open  ]],
Cell[32842, 1184, 632, 18, 70, "Reference",
 CellID->238052914],
Cell[33477, 1204, 1052, 27, 70, "Text",
 CellID->193291237],
Cell[34532, 1233, 1290, 38, 70, "Text",
 CellID->1680269666],
Cell[35825, 1273, 729, 20, 70, "Text",
 CellID->750967949]
}, Open  ]],
Cell[CellGroupData[{
Cell[36591, 1298, 69, 1, 70, "Section",
 CellID->756925424],
Cell[36663, 1301, 942, 24, 70, "Text",
 CellID->2099959987],
Cell[37608, 1327, 321, 8, 70, "MathCaption",
 CellID->1887921886],
Cell[CellGroupData[{
Cell[37954, 1339, 407, 13, 70, "Input",
 CellID->1232253577],
Cell[38364, 1354, 357, 11, 70, "Output",
 CellID->99924951]
}, Open  ]],
Cell[38736, 1368, 745, 19, 70, "Text",
 CellID->106439503],
Cell[39484, 1389, 636, 21, 70, "DefinitionBox",
 CellID->253234938],
Cell[40123, 1412, 58, 1, 70, "Caption",
 CellID->1954498259],
Cell[40184, 1415, 288, 7, 70, "MathCaption",
 CellID->161205554],
Cell[CellGroupData[{
Cell[40497, 1426, 557, 19, 70, "Input",
 CellID->1404867211],
Cell[41057, 1447, 394, 12, 70, "Output",
 CellID->1532168256]
}, Open  ]],
Cell[41466, 1462, 670, 20, 70, "Text",
 CellID->20516512],
Cell[42139, 1484, 380, 9, 70, "Text",
 CellID->1307587176],
Cell[42522, 1495, 179, 4, 70, "MathCaption",
 CellID->1417507281],
Cell[CellGroupData[{
Cell[42726, 1503, 826, 25, 70, "Input",
 CellID->2008775596],
Cell[43555, 1530, 517, 15, 70, "Output",
 CellID->675467415]
}, Open  ]],
Cell[44087, 1548, 142, 4, 70, "MathCaption",
 CellID->901027485],
Cell[CellGroupData[{
Cell[44254, 1556, 601, 20, 70, "Input",
 CellID->1661745398],
Cell[44858, 1578, 465, 14, 70, "Output",
 CellID->982285863]
}, Open  ]],
Cell[45338, 1595, 446, 8, 70, "Text",
 CellID->930074951],
Cell[45787, 1605, 135, 4, 70, "MathCaption",
 CellID->1688743082],
Cell[CellGroupData[{
Cell[45947, 1613, 1179, 35, 70, "Input",
 CellID->236234944],
Cell[47129, 1650, 524, 15, 70, "Output",
 CellID->1571704952]
}, Open  ]],
Cell[47668, 1668, 294, 9, 70, "Text",
 CellID->34112222],
Cell[47965, 1679, 235, 8, 70, "MathCaption",
 CellID->1561100422],
Cell[CellGroupData[{
Cell[48225, 1691, 699, 23, 70, "Input",
 CellID->2093465052],
Cell[48927, 1716, 347, 10, 70, "Output",
 CellID->1596270164]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[49323, 1732, 88, 1, 70, "Section",
 CellID->1063215934],
Cell[49414, 1735, 602, 20, 70, "Text",
 CellID->258776051],
Cell[50019, 1757, 719, 26, 70, "MathCaption",
 CellID->1607077155],
Cell[CellGroupData[{
Cell[50763, 1787, 160, 5, 70, "Input",
 CellID->594703982],
Cell[50926, 1794, 175, 5, 50, "Output",
 CellID->2146928024]
}, Open  ]],
Cell[51116, 1802, 913, 29, 70, "Text",
 CellID->800932336],
Cell[52032, 1833, 335, 10, 70, "Text",
 CellID->842271756],
Cell[52370, 1845, 68, 1, 70, "MathCaption",
 CellID->1243915766],
Cell[CellGroupData[{
Cell[52463, 1850, 631, 21, 70, "Input",
 CellID->1996685715],
Cell[53097, 1873, 496, 15, 70, "Output",
 CellID->1399062474]
}, Open  ]],
Cell[53608, 1891, 62, 1, 70, "MathCaption",
 CellID->1717343983],
Cell[CellGroupData[{
Cell[53695, 1896, 620, 20, 70, "Input",
 CellID->1220106601],
Cell[54318, 1918, 629, 20, 70, "Output",
 CellID->1244549515]
}, Open  ]],
Cell[54962, 1941, 972, 33, 70, "Text",
 CellID->10297804],
Cell[55937, 1976, 585, 15, 70, "Text",
 CellID->1276500068],
Cell[56525, 1993, 386, 13, 70, "Text",
 CellID->775009346],
Cell[56914, 2008, 194, 6, 70, "MathCaption",
 CellID->738975617],
Cell[CellGroupData[{
Cell[57133, 2018, 345, 11, 70, "Input",
 CellID->1093759167],
Cell[57481, 2031, 409, 12, 70, "Output",
 CellID->652976825]
}, Open  ]],
Cell[57905, 2046, 199, 6, 70, "MathCaption",
 CellID->350301449],
Cell[CellGroupData[{
Cell[58129, 2056, 345, 11, 70, "Input",
 CellID->1263776916],
Cell[58477, 2069, 479, 14, 70, "Output",
 CellID->940061605]
}, Open  ]],
Cell[58971, 2086, 768, 26, 70, "Text",
 CellID->1685358382],
Cell[59742, 2114, 1070, 37, 70, "Text",
 CellID->509022344],
Cell[60815, 2153, 804, 23, 70, "Text",
 CellID->1711169607],
Cell[61622, 2178, 174, 6, 70, "MathCaption",
 CellID->526584225],
Cell[CellGroupData[{
Cell[61821, 2188, 212, 7, 70, "Input",
 CellID->520960288],
Cell[62036, 2197, 281, 8, 70, "Output",
 CellID->578204256]
}, Open  ]],
Cell[62332, 2208, 666, 21, 70, "Text",
 CellID->488731597],
Cell[63001, 2231, 96, 1, 70, "MathCaption",
 CellID->2134484651],
Cell[CellGroupData[{
Cell[63122, 2236, 210, 7, 70, "Input",
 CellID->569206222],
Cell[63335, 2245, 1155, 27, 70, "Output",
 CellID->515427917]
}, Open  ]],
Cell[64505, 2275, 551, 16, 70, "Text",
 CellID->1756809416],
Cell[65059, 2293, 969, 29, 70, "Text",
 CellID->943192109],
Cell[66031, 2324, 318, 12, 70, "MathCaption",
 CellID->1065264318],
Cell[66352, 2338, 113, 4, 70, "Input",
 CellID->1743645400],
Cell[66468, 2344, 364, 12, 70, "Input",
 CellID->74848970],
Cell[CellGroupData[{
Cell[66857, 2360, 136, 4, 70, "Input",
 CellID->886390838],
Cell[66996, 2366, 192, 6, 70, "Output",
 CellID->199321650]
}, Open  ]],
Cell[67203, 2375, 314, 10, 70, "MathCaption",
 CellID->476755027],
Cell[CellGroupData[{
Cell[67542, 2389, 366, 12, 70, "Input",
 CellID->560251832],
Cell[67911, 2403, 532, 14, 70, "Output",
 CellID->2071965877]
}, Open  ]],
Cell[68458, 2420, 1555, 40, 70, "Text",
 CellID->1584231976],
Cell[70016, 2462, 849, 21, 70, "Text",
 CellID->587426909]
}, Open  ]],
Cell[CellGroupData[{
Cell[70902, 2488, 57, 1, 70, "Section",
 CellID->901734304],
Cell[70962, 2491, 557, 15, 70, "Text",
 CellID->656350449],
Cell[71522, 2508, 1167, 32, 70, "Text",
 CellID->1805985351],
Cell[72692, 2542, 113, 3, 70, "Text",
 CellID->513998664],
Cell[72808, 2547, 336, 12, 70, "MathCaption",
 CellID->326227587],
Cell[73147, 2561, 113, 4, 70, "Input",
 CellID->1051192653],
Cell[CellGroupData[{
Cell[73285, 2569, 421, 14, 70, "Input",
 CellID->2083158634],
Cell[73709, 2585, 377, 11, 70, "Output",
 CellID->1221264597]
}, Open  ]],
Cell[74101, 2599, 340, 13, 70, "MathCaption",
 CellID->46955102],
Cell[CellGroupData[{
Cell[74466, 2616, 419, 13, 70, "Input",
 CellID->1047900865],
Cell[74888, 2631, 344, 11, 70, "Output",
 CellID->923719870]
}, Open  ]],
Cell[75247, 2645, 659, 16, 70, "Text",
 CellID->556449008],
Cell[75909, 2663, 477, 11, 70, "Text",
 CellID->2094678418],
Cell[76389, 2676, 390, 7, 70, "Text",
 CellID->1560746055],
Cell[76782, 2685, 238, 8, 70, "MathCaption",
 CellID->381303918],
Cell[77023, 2695, 112, 4, 70, "Input",
 CellID->2093681927],
Cell[77138, 2701, 280, 8, 70, "Input",
 CellID->1775830032],
Cell[77421, 2711, 253, 7, 70, "MathCaption",
 CellID->1992590994],
Cell[CellGroupData[{
Cell[77699, 2722, 138, 4, 70, "Input",
 CellID->1616844840],
Cell[77840, 2728, 194, 6, 70, "Output",
 CellID->1162855972]
}, Open  ]],
Cell[78049, 2737, 95, 1, 70, "MathCaption",
 CellID->53156742],
Cell[78147, 2740, 217, 6, 70, "Input",
 CellID->52165642]
}, Open  ]],
Cell[CellGroupData[{
Cell[78401, 2751, 66, 1, 70, "Section",
 CellID->574617118],
Cell[78470, 2754, 241, 8, 70, "Text",
 CellID->220288465],
Cell[78714, 2764, 127, 3, 70, "MathCaption",
 CellID->355941667],
Cell[78844, 2769, 269, 9, 70, "Input",
 CellID->1569640374],
Cell[79116, 2780, 137, 4, 70, "Text",
 CellID->1256646070],
Cell[79256, 2786, 457, 11, 70, "Text",
 CellID->2096313892],
Cell[79716, 2799, 266, 8, 70, "Text",
 CellID->1130870162],
Cell[79985, 2809, 144, 4, 70, "MathCaption",
 CellID->126423827],
Cell[CellGroupData[{
Cell[80154, 2817, 478, 16, 70, "Input",
 CellID->1304536784],
Cell[80635, 2835, 483, 15, 70, "Output",
 CellID->1043573234]
}, Open  ]],
Cell[81133, 2853, 797, 17, 70, "Text",
 CellID->1689176465]
}, Open  ]],
Cell[CellGroupData[{
Cell[81967, 2875, 60, 1, 70, "Section",
 CellID->2125133640],
Cell[82030, 2878, 584, 19, 70, "Text",
 CellID->173070576],
Cell[82617, 2899, 171, 4, 70, "Text",
 CellID->1104312794],
Cell[82791, 2905, 117, 3, 70, "MathCaption",
 CellID->2113216751],
Cell[82911, 2910, 201, 7, 70, "Input",
 CellID->1631451384],
Cell[CellGroupData[{
Cell[83137, 2921, 106, 3, 70, "Input",
 CellID->943933506],
Cell[83246, 2926, 258, 7, 70, "Output",
 CellID->431937511]
}, Open  ]],
Cell[83519, 2936, 314, 10, 70, "MathCaption",
 CellID->732205992],
Cell[83836, 2948, 305, 10, 70, "Input",
 CellID->1104810234],
Cell[84144, 2960, 351, 6, 70, "Text",
 CellID->1401990876],
Cell[84498, 2968, 603, 21, 70, "Text",
 CellID->1070078048],
Cell[85104, 2991, 245, 8, 70, "MathCaption",
 CellID->1749379971],
Cell[CellGroupData[{
Cell[85374, 3003, 345, 11, 70, "Input",
 CellID->1773692758],
Cell[85722, 3016, 314, 9, 82, "Output",
 CellID->1526179699]
}, Open  ]],
Cell[86051, 3028, 225, 6, 70, "Text",
 CellID->1233679699],
Cell[86279, 3036, 281, 9, 70, "MathCaption",
 CellID->630561520],
Cell[86563, 3047, 423, 14, 70, "Input",
 CellID->500089308],
Cell[86989, 3063, 280, 9, 70, "Text",
 CellID->1897488845]
}, Open  ]],
Cell[CellGroupData[{
Cell[87306, 3077, 70, 1, 70, "Section",
 CellID->962859965],
Cell[87379, 3080, 299, 8, 70, "Text",
 CellID->1498151610],
Cell[87681, 3090, 278, 9, 70, "MathCaption",
 CellID->188348195],
Cell[87962, 3101, 139, 4, 70, "Input",
 CellID->177217687],
Cell[88104, 3107, 838, 20, 70, "Text",
 CellID->2085330667],
Cell[88945, 3129, 806, 19, 70, "Text",
 CellID->1219401229],
Cell[89754, 3150, 1682, 51, 70, "Text",
 CellID->1040012482],
Cell[91439, 3203, 186, 4, 70, "MathCaption",
 CellID->1120382041],
Cell[CellGroupData[{
Cell[91650, 3211, 359, 11, 70, "Input",
 CellID->1124346191],
Cell[92012, 3224, 346, 11, 70, "Output",
 CellID->408910586]
}, Open  ]],
Cell[92373, 3238, 162, 4, 70, "Text",
 CellID->1177822184],
Cell[92538, 3244, 540, 10, 70, "Text",
 CellID->153188442]
}, Open  ]],
Cell[CellGroupData[{
Cell[93115, 3259, 55, 1, 70, "Section",
 CellID->1952735588],
Cell[93173, 3262, 747, 23, 70, "Text",
 CellID->284429183],
Cell[CellGroupData[{
Cell[93945, 3289, 66, 1, 70, "TutorialMoreAboutSection",
 CellID->505375963],
Cell[94014, 3292, 181, 4, 70, "TutorialMoreAbout",
 CellID->346793833],
Cell[94198, 3298, 161, 3, 70, "TutorialMoreAbout",
 CellID->116159589]
}, Open  ]],
Cell[CellGroupData[{
Cell[94396, 3306, 71, 1, 70, "RelatedTutorialsSection",
 CellID->62154653],
Cell[94470, 3309, 183, 4, 70, "RelatedTutorials",
 CellID->444978337],
Cell[94656, 3315, 174, 4, 70, "RelatedTutorials",
 CellID->894362159]
}, Open  ]],
Cell[CellGroupData[{
Cell[94867, 3324, 97, 1, 70, "TutorialRelatedLinksSection",
 CellID->81337975],
Cell[94967, 3327, 244, 5, 70, "TutorialRelatedLinks",
 CellID->228912486]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[95250, 3337, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

