(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     57876,       1559]
NotebookOptionsPosition[     51411,       1356]
NotebookOutlinePosition[     54418,       1431]
CellTagsIndexPosition[     54324,       1425]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Structure of Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"The Structure of Graphics and Sound\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Automatic" :> Documentation`HelpLookup["paclet:ref/Automatic"],
           "Axes" :> Documentation`HelpLookup["paclet:ref/Axes"], "AxesLabel" :> 
          Documentation`HelpLookup["paclet:ref/AxesLabel"], "AxesOrigin" :> 
          Documentation`HelpLookup["paclet:ref/AxesOrigin"], "AxesStyle" :> 
          Documentation`HelpLookup["paclet:ref/AxesStyle"], "False" :> 
          Documentation`HelpLookup["paclet:ref/False"], "Frame" :> 
          Documentation`HelpLookup["paclet:ref/Frame"], "FrameLabel" :> 
          Documentation`HelpLookup["paclet:ref/FrameLabel"], "FrameStyle" :> 
          Documentation`HelpLookup["paclet:ref/FrameStyle"], "FrameTicks" :> 
          Documentation`HelpLookup["paclet:ref/FrameTicks"], "GridLines" :> 
          Documentation`HelpLookup["paclet:ref/GridLines"], "None" :> 
          Documentation`HelpLookup["paclet:ref/None"], "PlotLabel" :> 
          Documentation`HelpLookup["paclet:ref/PlotLabel"], "RotateLabel" :> 
          Documentation`HelpLookup["paclet:ref/RotateLabel"], "Ticks" :> 
          Documentation`HelpLookup["paclet:ref/Ticks"], "True" :> 
          Documentation`HelpLookup["paclet:ref/True"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Automatic\"\>", 2->"\<\"Axes\"\>", 
       3->"\<\"AxesLabel\"\>", 4->"\<\"AxesOrigin\"\>", 
       5->"\<\"AxesStyle\"\>", 6->"\<\"False\"\>", 7->"\<\"Frame\"\>", 
       8->"\<\"FrameLabel\"\>", 9->"\<\"FrameStyle\"\>", 
       10->"\<\"FrameTicks\"\>", 11->"\<\"GridLines\"\>", 12->"\<\"None\"\>", 
       13->"\<\"PlotLabel\"\>", 14->"\<\"RotateLabel\"\>", 
       15->"\<\"Ticks\"\>", 16->"\<\"True\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\<\
Labeling Two\[Hyphen]Dimensional Graphics\
\>", "Title",
 CellTags->{"S2.10.5", "5.1"},
 CellID->22832],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Axes",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Axes"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}], Cell[
    "give a pair of axes", "TableText"]},
   {
    RowBox[{
     ButtonBox["GridLines",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GridLines"], "->", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]}], Cell[
    "draw grid lines on the plot", "TableText"]},
   {
    RowBox[{
     ButtonBox["Frame",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Frame"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}], Cell[
    "put axes on a frame around the plot", "TableText"]},
   {
    RowBox[{
     ButtonBox["PlotLabel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PlotLabel"], "->", "\"\<\!\(\*
StyleBox[\"text\", \"TI\"]\)\>\""}], Cell[
    "give an overall label for the plot", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->23673],

Cell["\<\
Ways to label two\[Hyphen]dimensional plots. \
\>", "Caption",
 CellID->14943],

Cell[TextData[{
 "Here is a plot, using the default ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Axes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Axes"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->12312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"bp", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"BesselJ", "[", 
     RowBox[{"2", ",", "x"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3232],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8776894]
}, Open  ]],

Cell[TextData[{
 "Setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Frame",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Frame"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " generates a frame with axes, and removes tick marks from the ordinary \
axes. "
}], "MathCaption",
 CellID->13239],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"bp", ",", 
   RowBox[{"Frame", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7768],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->179533997]
}, Open  ]],

Cell["This includes grid lines, which are shown in light gray. ", \
"MathCaption",
 CellID->17683],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"%", ",", 
   RowBox[{"GridLines", "->", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->6209],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->300547258]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Axes",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Axes"], "->", 
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"]}], Cell["draw no axes", "TableText"]},
   {
    RowBox[{
     ButtonBox["Axes",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Axes"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}], Cell[TextData[{
     "draw both ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " axes"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Axes",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Axes"], "->", "{", 
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"], ",", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"], "}"}], Cell[TextData[{
     "draw a ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " axis but no ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " axis"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["AxesOrigin",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AxesOrigin"], "->", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]}], Cell[
    "choose the crossing point for the axes automatically", "TableText"]},
   {
    RowBox[{
     ButtonBox["AxesOrigin",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AxesOrigin"], "->", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "}"}], Cell[
    "specify the crossing point", "TableText"]},
   {
    RowBox[{
     ButtonBox["AxesStyle",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AxesStyle"], "->", 
     StyleBox["style", "TI"]}], Cell[
    "specify the style for axes", "TableText"]},
   {
    RowBox[{
     ButtonBox["AxesStyle",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AxesStyle"], "->", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["xstyle", "TI"], ",", 
       StyleBox["ystyle", "TI"]}], "}"}]}], Cell[
    "specify individual styles for axes", "TableText"]},
   {
    RowBox[{
     ButtonBox["AxesLabel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AxesLabel"], "->", 
     ButtonBox["None",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/None"]}], Cell[
    "give no axis labels", "TableText"]},
   {
    RowBox[{
     ButtonBox["AxesLabel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AxesLabel"], "->", 
     StyleBox["ylabel", "TI"]}], Cell[TextData[{
     "put a label on the ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " axis"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["AxesLabel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AxesLabel"], "->", "{", 
     StyleBox["xlabel", "TI"], ",", 
     StyleBox["ylabel", "TI"], "}"}], Cell[TextData[{
     "put labels on both ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " axes"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, {False}, 
     False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->18795],

Cell["Options for axes. ", "Caption",
 CellID->13245],

Cell[TextData[{
 "This makes the axes cross at the point ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"5", ",", "0"}], "}"}]], "InlineFormula"],
 ", and puts a label on each axis. "
}], "MathCaption",
 CellID->1912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"bp", ",", 
   RowBox[{"AxesOrigin", "->", 
    RowBox[{"{", 
     RowBox[{"5", ",", "0"}], "}"}]}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->28639],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->503522821]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Ticks",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Ticks"], "->", 
     ButtonBox["None",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/None"]}], Cell[
    "draw no tick marks", "TableText"]},
   {
    RowBox[{
     ButtonBox["Ticks",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Ticks"], "->", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]}], Cell[
    "place tick marks automatically", "TableText"]},
   {
    RowBox[{
     ButtonBox["Ticks",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Ticks"], "->", "{", 
     StyleBox["xticks", "TI"], ",", 
     StyleBox["yticks", "TI"], "}"}], Cell[
    "tick mark specifications for each axis", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->4248],

Cell[TextData[{
 "Settings for the ",
 StyleBox["Ticks", "MR"],
 " option. "
}], "Caption",
 CellID->1479],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Ticks",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ticks"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " creates a certain number of major and minor tick marks, and places them on \
axes at positions which yield the minimum number of decimal digits in the \
tick labels. In some cases, however, you may want to specify the positions \
and properties of tick marks explicitly. You will need to do this, for \
example, if you want to have tick marks at multiples of ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineMath"],
 ", or if you want to put a nonlinear scale on an axis. "
}], "Text",
 CellID->13207],

Cell[BoxData[GridBox[{
   {
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "draw no tick marks", "TableText"]},
   {
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "place tick marks automatically", "TableText"]},
   {
    RowBox[{"{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], Cell[
    "draw tick marks at the specified positions", "TableText"]},
   {
    RowBox[{"{", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["label", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["label", "TI"], "2"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], Cell[
    "draw tick marks with the specified labels", "TableText"]},
   {
    RowBox[{"{", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["label", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["len", "TI"], "1"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], Cell[
    "draw tick marks with the specified scaled lengths", "TableText"]},
   {
    RowBox[{"{", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["label", "TI"], "1"], ",", "{", 
     SubscriptBox[
      StyleBox["plen", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["mlen", "TI"], "1"], "}", "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], Cell["\<\
draw tick marks with the specified lengths in the positive and negative \
directions\
\>", "TableText"]},
   {
    RowBox[{"{", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["label", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["len", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["style", "TI"], "1"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], Cell[
    "draw tick marks with the specified styles", "TableText"]},
   {
    StyleBox["func", "TI"], Cell[TextData[{
     "a function to be applied to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     " to get the tick mark option"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->31230],

Cell["Tick mark options for each axis. ", "Caption",
 CellID->3954],

Cell[TextData[{
 "This gives tick marks at specified positions on the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " axis, and chooses the tick marks automatically on the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " axis. "
}], "MathCaption",
 CellID->19601],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"bp", ",", 
   RowBox[{"Ticks", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "Pi", ",", 
        RowBox[{"2", "Pi"}], ",", 
        RowBox[{"3", "Pi"}]}], "}"}], ",", "Automatic"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->13940],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->124844354]
}, Open  ]],

Cell[TextData[{
 "This adds tick marks with no labels at multiples of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Pi]", "/", "2"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->19718],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"bp", ",", 
   RowBox[{"Ticks", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Pi", "/", "2"}], ",", "\"\<\>\""}], "}"}], ",", "Pi", ",", 
        
        RowBox[{"{", 
         RowBox[{
          RowBox[{"3", 
           RowBox[{"Pi", "/", "2"}]}], ",", "\"\<\>\""}], "}"}], ",", 
        RowBox[{"2", "Pi"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"5", 
           RowBox[{"Pi", "/", "2"}]}], ",", "\"\<\>\""}], "}"}], ",", 
        RowBox[{"3", "Pi"}]}], "}"}], ",", "Automatic"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->23412],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->61021332]
}, Open  ]],

Cell["\<\
Particularly when you want to create complicated tick mark specifications, it \
is often convenient to define a \[OpenCurlyDoubleQuote]tick mark function\
\[CloseCurlyDoubleQuote] which creates the appropriate tick mark \
specification given the minimum and maximum values on a particular axis. \
\>", "Text",
 CellID->26623],

Cell["\<\
This defines a function which gives a list of tick mark positions with a \
spacing of 1. \
\>", "MathCaption",
 CellID->11472],

Cell[BoxData[
 RowBox[{
  RowBox[{"units", "[", 
   RowBox[{"xmin_", ",", "xmax_"}], "]"}], ":=", 
  RowBox[{"Range", "[", 
   RowBox[{
    RowBox[{"Floor", "[", "xmin", "]"}], ",", 
    RowBox[{"Floor", "[", "xmax", "]"}], ",", "1"}], "]"}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->11983],

Cell[TextData[{
 "This uses the ",
 Cell[BoxData["units"], "InlineFormula"],
 " function to specify tick marks for the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " axis. "
}], "MathCaption",
 CellID->3885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"bp", ",", 
   RowBox[{"Ticks", "->", 
    RowBox[{"{", 
     RowBox[{"units", ",", "Automatic"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->29686],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->125456381]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Frame",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Frame"], "->", 
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"]}], Cell["draw no frame", "TableText"]},
   {
    RowBox[{
     ButtonBox["Frame",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Frame"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}], Cell[
    "draw a frame around the plot", "TableText"]},
   {
    RowBox[{
     ButtonBox["FrameStyle",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FrameStyle"], "->", 
     StyleBox["style", "TI"]}], Cell[
    "specify a style for the frame", "TableText"]},
   {
    RowBox[{
     ButtonBox["FrameStyle",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FrameStyle"], "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         StyleBox["left", "TI"], ",", 
         StyleBox["right", "TI"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["bottom", "TI"], ",", 
         StyleBox["top", "TI"]}], "}"}]}], "}"}]}], Cell[
    "specify styles for each edge of the frame", "TableText"]},
   {
    RowBox[{
     ButtonBox["FrameLabel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FrameLabel"], "->", 
     ButtonBox["None",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/None"]}], Cell[
    "give no frame labels", "TableText"]},
   {
    RowBox[{
     ButtonBox["FrameLabel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FrameLabel"], "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         StyleBox["left", "TI"], ",", 
         StyleBox["right", "TI"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["bottom", "TI"], ",", 
         StyleBox["top", "TI"]}], "}"}]}], "}"}]}], Cell[
    "put labels on edges of the frame", "TableText"]},
   {
    RowBox[{
     ButtonBox["RotateLabel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RotateLabel"], "->", 
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"]}], Cell[
    "do not rotate text in labels", "TableText"]},
   {
    RowBox[{
     ButtonBox["FrameTicks",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FrameTicks"], "->", 
     ButtonBox["None",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/None"]}], Cell[
    "draw no tick marks on frame edges", "TableText"]},
   {
    RowBox[{
     ButtonBox["FrameTicks",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FrameTicks"], "->", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]}], Cell[
    "position tick marks automatically", "TableText"]},
   {
    RowBox[{
     ButtonBox["FrameTicks",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FrameTicks"], "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         StyleBox["left", "TI"], ",", 
         StyleBox["right", "TI"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["bottom", "TI"], ",", 
         StyleBox["top", "TI"]}], "}"}]}], "}"}]}], Cell[
    "specify tick marks for frame edges", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, {False}, 
     False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->14702],

Cell["Options for frame axes. ", "Caption",
 CellID->14439],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Axes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Axes"]], "InlineFormula"],
 " option allows you to draw a single pair of axes in a plot. Sometimes, \
however, you may instead want to show the scales for a plot on a frame, \
typically drawn around the whole plot. The option ",
 Cell[BoxData[
  ButtonBox["Frame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Frame"]], "InlineFormula"],
 " allows you effectively to draw four axes, corresponding to the four edges \
of the frame around a plot. These four axes are ordered clockwise, starting \
from the one at the bottom. "
}], "Text",
 CellID->10606],

Cell["This draws frame axes, and labels each of them. ", "MathCaption",
 CellID->12276],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"bp", ",", 
   RowBox[{"Frame", "->", "True"}], ",", 
   RowBox[{"FrameLabel", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<left label\>\"", ",", "\"\<right label\>\""}], "}"}], ",",
       
      RowBox[{"{", 
       RowBox[{"\"\<bottom label\>\"", ",", "\"\<top label\>\""}], "}"}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->25924],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 126},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->12263629]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["GridLines",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GridLines"], "->", 
     ButtonBox["None",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/None"]}], Cell[
    "draw no grid lines", "TableText"]},
   {
    RowBox[{
     ButtonBox["GridLines",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GridLines"], "->", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]}], Cell[
    "position grid lines automatically", "TableText"]},
   {
    RowBox[{
     ButtonBox["GridLines",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GridLines"], "->", "{", 
     StyleBox["xgrid", "TI"], ",", 
     StyleBox["ygrid", "TI"], "}"}], Cell[
    "specify grid lines in analogy with tick marks", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->13037],

Cell["Options for grid lines. ", "Caption",
 CellID->19035],

Cell[TextData[{
 "Grid lines in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " work very much like tick marks. As with tick marks, you can specify \
explicit positions for grid lines. There is no label or length to specify for \
grid lines. However, you can specify a style. "
}], "Text",
 CellID->1699],

Cell[TextData[{
 "This generates ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " but not ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " grid lines. "
}], "MathCaption",
 CellID->13316],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"bp", ",", 
   RowBox[{"GridLines", "->", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "None"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->1890],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->127926607]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->648919574],

Cell[TextData[ButtonBox["The Structure of Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]], \
"RelatedTutorials",
 CellID->1229394717]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Labeling Two-Dimensional Graphics - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["The Structure of Graphics and Sound", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/CoordinateSystemsForTwoDimensionalGraphics"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/InsettingObjectsInGraphics"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 17.7252498}", "context" -> "", 
    "keywords" -> {
     "abscissa", "axes", "AxesLabel", "AxesOrigin", "AxesStyle", "boxes", 
      "drafting lines", "edges of plot", "fiducial marks", "frame", 
      "FrameLabel", "FrameStyle", "FrameTicks", "graphics", "GridLines", 
      "headings", "labeling", "labels", "legends on plots", "lines", 
      "markings", "names", "ordinates", "origin", "PlotLabel", "plots", 
      "RotateLabel", "scales", "text", "tick marks", "ticks", "titles"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Ways to label two-dimensional plots. Here is a plot, using the default \
Axes->True. Setting Frame->True generates a frame with axes, and removes tick \
marks from the ordinary axes. ", "synonyms" -> {}, "title" -> 
    "Labeling Two-Dimensional Graphics", "type" -> "Tutorial", "uri" -> 
    "tutorial/LabelingTwoDimensionalGraphics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.10.5"->{
  Cell[3336, 79, 113, 4, 70, "Title",
   CellTags->{"S2.10.5", "5.1"},
   CellID->22832]},
 "5.1"->{
  Cell[3336, 79, 113, 4, 70, "Title",
   CellTags->{"S2.10.5", "5.1"},
   CellID->22832]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.10.5", 54109, 1414},
 {"5.1", 54210, 1418}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2711, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3336, 79, 113, 4, 70, "Title",
 CellTags->{"S2.10.5", "5.1"},
 CellID->22832],
Cell[3452, 85, 1382, 43, 70, "DefinitionBox",
 CellID->23673],
Cell[4837, 130, 88, 3, 70, "Caption",
 CellID->14943],
Cell[4928, 135, 309, 12, 70, "MathCaption",
 CellID->12312],
Cell[CellGroupData[{
Cell[5262, 151, 267, 9, 28, "Input",
 CellID->3232],
Cell[5532, 162, 2617, 47, 119, "Output",
 Evaluatable->False,
 CellID->8776894]
}, Open  ]],
Cell[8164, 212, 362, 13, 70, "MathCaption",
 CellID->13239],
Cell[CellGroupData[{
Cell[8551, 229, 151, 5, 28, "Input",
 CellID->7768],
Cell[8705, 236, 2705, 48, 132, "Output",
 Evaluatable->False,
 CellID->179533997]
}, Open  ]],
Cell[11425, 287, 98, 2, 70, "MathCaption",
 CellID->17683],
Cell[CellGroupData[{
Cell[11548, 293, 159, 5, 28, "Input",
 CellID->6209],
Cell[11710, 300, 3311, 58, 132, "Output",
 Evaluatable->False,
 CellID->300547258]
}, Open  ]],
Cell[15036, 361, 3630, 123, 70, "DefinitionBox",
 CellID->18795],
Cell[18669, 486, 53, 1, 70, "Caption",
 CellID->13245],
Cell[18725, 489, 215, 7, 70, "MathCaption",
 CellID->1912],
Cell[CellGroupData[{
Cell[18965, 500, 315, 10, 28, "Input",
 CellID->28639],
Cell[19283, 512, 2791, 50, 143, "Output",
 Evaluatable->False,
 CellID->503522821]
}, Open  ]],
Cell[22089, 565, 1133, 35, 70, "DefinitionBox",
 CellID->4248],
Cell[23225, 602, 106, 5, 70, "Caption",
 CellID->1479],
Cell[23334, 609, 846, 22, 70, "Text",
 CellID->13207],
Cell[24183, 633, 2899, 91, 70, "DefinitionBox",
 CellID->31230],
Cell[27085, 726, 67, 1, 70, "Caption",
 CellID->3954],
Cell[27155, 729, 306, 9, 70, "MathCaption",
 CellID->19601],
Cell[CellGroupData[{
Cell[27486, 742, 337, 12, 28, "Input",
 CellID->13940],
Cell[27826, 756, 2539, 46, 121, "Output",
 Evaluatable->False,
 CellID->124844354]
}, Open  ]],
Cell[30380, 805, 205, 7, 70, "MathCaption",
 CellID->19718],
Cell[CellGroupData[{
Cell[30610, 816, 724, 24, 47, "Input",
 CellID->23412],
Cell[31337, 842, 2546, 46, 121, "Output",
 Evaluatable->False,
 CellID->61021332]
}, Open  ]],
Cell[33898, 891, 335, 6, 70, "Text",
 CellID->26623],
Cell[34236, 899, 136, 4, 70, "MathCaption",
 CellID->11472],
Cell[34375, 905, 293, 9, 70, "Input",
 CellID->11983],
Cell[34671, 916, 230, 8, 70, "MathCaption",
 CellID->3885],
Cell[CellGroupData[{
Cell[34926, 928, 212, 7, 28, "Input",
 CellID->29686],
Cell[35141, 937, 2700, 48, 119, "Output",
 Evaluatable->False,
 CellID->125456381]
}, Open  ]],
Cell[37856, 988, 3651, 119, 70, "DefinitionBox",
 CellID->14702],
Cell[41510, 1109, 59, 1, 70, "Caption",
 CellID->14439],
Cell[41572, 1112, 665, 17, 70, "Text",
 CellID->10606],
Cell[42240, 1131, 87, 1, 70, "MathCaption",
 CellID->12276],
Cell[CellGroupData[{
Cell[42352, 1136, 441, 14, 47, "Input",
 CellID->25924],
Cell[42796, 1152, 3023, 54, 147, "Output",
 Evaluatable->False,
 CellID->12263629]
}, Open  ]],
Cell[45834, 1209, 1166, 35, 70, "DefinitionBox",
 CellID->13037],
Cell[47003, 1246, 59, 1, 70, "Caption",
 CellID->19035],
Cell[47065, 1249, 311, 8, 70, "Text",
 CellID->1699],
Cell[47379, 1259, 229, 9, 70, "MathCaption",
 CellID->13316],
Cell[CellGroupData[{
Cell[47633, 1272, 215, 7, 28, "Input",
 CellID->1890],
Cell[47851, 1281, 3193, 56, 119, "Output",
 Evaluatable->False,
 CellID->127926607]
}, Open  ]],
Cell[CellGroupData[{
Cell[51081, 1342, 72, 1, 70, "RelatedTutorialsSection",
 CellID->648919574],
Cell[51156, 1345, 201, 5, 70, "RelatedTutorials",
 CellID->1229394717]
}, Open  ]]
}, Open  ]],
Cell[51384, 1354, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

