(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     58256,       2126]
NotebookOptionsPosition[     31691,       1247]
NotebookOutlinePosition[     46933,       1724]
CellTagsIndexPosition[     46475,       1703]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"System Administration for Network Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]}, \
#, 2]& , Evaluator -> Automatic], {
      1->"\<\"System Administration for Network Licenses\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Launching ",
 StyleBox["MathLM",
  FontSlant->"Italic"],
 " "
}], "Title",
 CellID->5835212],

Cell[CellGroupData[{

Cell[TextData[{
 "Launching ",
 StyleBox["MathLM",
  FontSlant->"Italic"],
 " on Windows"
}], "Section",
 CellTags->{"b:1.0", "net: 1"},
 CellID->311263493],

Cell[CellGroupData[{

Cell[TextData[{
 "Launching ",
 StyleBox["MathLM",
  FontSlant->"Italic"],
 " Manually"
}], "Subsection",
 CellTags->{"i:2", "b:1.0", "net: 2"},
 CellID->354955318],

Cell[TextData[{
 "Once installed, ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " starts running automatically by default each time the machine is rebooted. \
To start or stop ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " manually, follow these instructions."
}], "Text",
 CellTags->"b:1.0",
 CellID->329375866],

Cell[TextData[{
 "It is assumed here that ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " is installed in the default location, ",
 "C:\\Program Files\\Wolfram Research \\MathLM",
 "."
}], "Text",
 CellTags->"b:1.0",
 CellID->18546427],

Cell[CellGroupData[{

Cell[TextData[{
 "To start ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " under Windows 98/Me:"
}], "Subsubsection",
 CellTags->"b:1.0",
 CellID->216609866],

Cell[TextData[{
 "Open an MS-DOS window. (From the ",
 StyleBox["Start", "MenuName"],
 " menu, choose ",
 StyleBox["Programs \[FilledRightTriangle] MS-DOS Prompt", "MenuName"],
 ".) "
}], "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:1.0",
 CellID->156156522],

Cell[TextData[{
 "Use the ",
 StyleBox["cd", "InlineCode"],
 " command to change directories to ",
 "C:\\Program Files\\Wolfram Research\\MathLM",
 ". Remember to use double quotes around directory names that include \
spaces."
}], "ItemizedText",
 CellTags->"b:1.0",
 CellID->14907943],

Cell[TextData[{
 "Type ",
 StyleBox[".\\mathlm", "InlineCode"],
 " and press ",
 StyleBox["Enter", "KeyEvent"],
 ". The ",
 StyleBox["mathlm", "InlineCode"],
 " process prints a startup message and runs in the foreground. You cannot \
start ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " manually and run it in the background."
}], "ItemizedText",
 CellTags->"b:1.0",
 CellID->36257786]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "To start ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " under Windows NT/2000/XP:"
}], "Subsubsection",
 CellTags->"b:1.0",
 CellID->28773564],

Cell[TextData[{
 "Open the Control Panel. (From the ",
 StyleBox["Start", "MenuName"],
 " menu, choose ",
 StyleBox["Settings", "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuName"],
 StyleBox["Control Panel", "MenuName"],
 ".)"
}], "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:1.0",
 CellID->55987767],

Cell["\<\
Double-click the Services icon located in the Administrative Tools folder on \
Windows 2000/XP and in the Control Panel folder on Windows NT. To change \
settings for services, you will need administrative privileges.\
\>", "ItemizedText",
 CellTags->"b:1.0",
 CellID->266760863],

Cell[TextData[{
 "Select ",
 StyleBox["Mathematica License Manager", "DialogElementName"],
 " from the list of services."
}], "ItemizedText",
 CellTags->"b:1.0",
 CellID->355313255],

Cell[TextData[{
 "On Windows 2000/XP, double-click the service name to open the ",
 StyleBox["Properties", "DialogElementName"],
 " dialog box; then click ",
 StyleBox["Start", "DialogElementName"],
 ". On Windows NT, click the ",
 StyleBox["Start", "DialogElementName"],
 " button on the Services control panel. "
}], "ItemizedText",
 CellTags->"b:1.0",
 CellID->316504170],

Cell[TextData[{
 "Alternatively, in a Command Prompt window run the command ",
 StyleBox["net start mathlm", "InlineCode"],
 "."
}], "IndentedText",
 CellTags->"b:1.0",
 CellID->179942989]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "To stop ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " under Windows 98/Me:"
}], "Subsubsection",
 CellTags->{"i:11", "b:1.0"},
 CellID->126874819],

Cell[TextData[{
 "From the desktop, press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Del", "KeyEvent"],
 ". The ",
 StyleBox["Close Program", "DialogElementName"],
 " dialog box appears."
}], "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:1.0",
 CellID->20183709],

Cell[TextData[{
 "Select ",
 StyleBox["mathlm", "DialogElementName"],
 " from the list of tasks."
}], "ItemizedText",
 CellTags->"b:1.0",
 CellID->155946793],

Cell[TextData[{
 "Click ",
 StyleBox["End Task", "DialogElementName"],
 "."
}], "ItemizedText",
 CellTags->"b:1.0",
 CellID->67730785]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "To stop ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " under Windows NT/2000/XP:"
}], "Subsubsection",
 CellTags->"b:1.0",
 CellID->153716888],

Cell["\<\
Double-click the Services icon located in the Control Panel\\Administrative \
Tools folder on Windows 2000/XP and in the Control Panel folder on Windows \
NT. To change settings for services, you will need administrative privileges.\
\
\>", "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:1.0",
 CellID->43305008],

Cell[TextData[{
 "Select ",
 StyleBox["Mathematica License Manager", "DialogElementName"],
 " from the list of services."
}], "ItemizedText",
 CellTags->"b:1.0",
 CellID->40895431],

Cell[TextData[{
 "On Windows NT/XP, select the service and click the ",
 StyleBox["Stop", "DialogElementName"],
 " button on the Services control panel. On Windows 2000, double-click the \
service name to open the ",
 StyleBox["Properties", "DialogElementName"],
 " dialog box; then click ",
 StyleBox["Stop", "DialogElementName"],
 "."
}], "ItemizedText",
 CellTags->"b:1.0",
 CellID->146063425],

Cell[TextData[{
 "Alternatively, in a Command Prompt window run the command ",
 StyleBox["net stop mathlm", "InlineCode"],
 "."
}], "IndentedText",
 CellTags->"b:1.0",
 CellID->70184551]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Starting ",
 StyleBox["MathLM",
  FontSlant->"Italic"],
 " Automatically"
}], "Subsection",
 CellTags->{"i:4", "b:1.0", "net: 3"},
 CellID->24220764],

Cell[TextData[{
 "Under normal conditions, the installer will install ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " as a service on the machine. This means ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " will start automatically each time the machine is rebooted. You can \
manually change the settings that control whether ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " starts when the machine is rebooted. "
}], "Text",
 CellTags->{"i:10", "b:1.0"},
 CellID->101920823],

Cell[TextData[{
 "It is assumed here that ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " is installed in the default location, C:\\Program Files\\Wolfram \
Research\\MathLM."
}], "Text",
 CellTags->"b:1.0",
 CellID->39884604],

Cell[CellGroupData[{

Cell[TextData[{
 "To start ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " each time a Windows 98/Me machine is rebooted:"
}], "Subsubsection",
 CellTags->"b:1.0",
 CellID->220975342],

Cell[TextData[{
 "Open an MS-DOS window. (From the ",
 StyleBox["Start", "MenuName"],
 " menu, choose ",
 StyleBox["Programs \[FilledRightTriangle] MS-DOS Prompt", "MenuName"],
 ".) "
}], "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:1.0",
 CellID->570565587],

Cell[TextData[{
 "Use the ",
 StyleBox["cd", "InlineCode"],
 " command to change directories to ",
 "C:\\Program Files\\Wolfram Research\\MathLM",
 ". Remember to use double quotes around directory names that include \
spaces."
}], "ItemizedText",
 CellTags->"b:1.0",
 CellID->106056202],

Cell[TextData[{
 "Run ",
 StyleBox[".\\mathlm -install", "InlineCode"],
 "."
}], "ItemizedText",
 CellTags->"b:1.0",
 CellID->214144821],

Cell[TextData[{
 "Reboot the machine. The ",
 StyleBox["mathlm", "InlineCode"],
 " program will be launched automatically, and a console window will flash \
briefly. This is normal."
}], "ItemizedText",
 CellTags->"b:1.0",
 CellID->466506169]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "To prevent ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " from starting each time a Windows 98/Me machine is rebooted:"
}], "Subsubsection",
 CellTags->"b:1.0",
 CellID->241627051],

Cell["Open an MS-DOS window.", "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:1.0",
 CellID->196685893],

Cell[TextData[{
 "Use the ",
 StyleBox["cd", "InlineCode"],
 " command to change directories to ",
 "C:\\Program Files\\Wolfram Research\\MathLM",
 ". Remember to use double quotes around directory names that include \
spaces."
}], "ItemizedText",
 CellTags->"b:1.0",
 CellID->272084236],

Cell[TextData[{
 "Run ",
 StyleBox[".\\mathlm -uninstall", "InlineCode"],
 "."
}], "ItemizedText",
 CellTags->"b:1.0",
 CellID->215416157]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "To start ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " each time a Windows NT/2000/XP machine is rebooted:"
}], "Subsubsection",
 CellTags->"b:1.0",
 CellID->76000657],

Cell[TextData[{
 "Open a Command Prompt window. (From the ",
 StyleBox["Start", "MenuName"],
 " menu, choose ",
 StyleBox["Programs \[FilledRightTriangle] Accessories \[FilledRightTriangle] \
Command Prompt", "MenuName"],
 ".)"
}], "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:1.0",
 CellID->32313873],

Cell[TextData[{
 "Use the ",
 StyleBox["cd", "InlineCode"],
 " command to change directories to ",
 "C:\\Program Files\\Wolfram Research\\MathLM",
 ". Remember to use double quotes around directory names that include \
spaces."
}], "ItemizedText",
 CellTags->"b:1.0",
 CellID->485738660],

Cell[CellGroupData[{

Cell[TextData[{
 "Run ",
 StyleBox[".\\mathlm -install", "InlineCode"],
 "."
}], "ItemizedText",
 CellTags->"b:1.0",
 CellID->244389379],

Cell[TextData[{
 "If ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " is already installed as a service but was previously disabled, you can \
enable it again using the following steps."
}], "Text",
 CellTags->"b:1.0",
 CellID->138799686]
}, Open  ]],

Cell["\<\
Double-click the Services icon located in the Control Panel\\Administrative \
Tools folder on Windows 2000/XP and in the Control Panel folder on Windows \
NT. To change settings for services, you will need administrative privileges.\
\
\>", "ItemizedText",
 CounterAssignments->{{"ItemizedText", 0}},
 CellTags->"b:1.0",
 CellID->54624671],

Cell[TextData[{
 "Select ",
 StyleBox["Mathematica License Manager", "DialogElementName"],
 " from the list of services and double-click."
}], "ItemizedText",
 PageBreakAbove->True,
 CellTags->"b:1.0",
 CellID->6821549],

Cell[TextData[{
 "In the dialog box that appears, set ",
 StyleBox["Startup type", "DialogElementName"],
 " to",
 StyleBox[" ", "SR"],
 StyleBox["Automatic", "DialogElementName"],
 "."
}], "ItemizedText",
 CellTags->"b:1.0",
 CellID->313924175],

Cell[CellGroupData[{

Cell[TextData[{
 "Click ",
 StyleBox["OK", "DialogElementName"],
 " to close the dialog box."
}], "ItemizedText",
 CellTags->"b:1.0",
 CellID->437504892],

Cell[TextData[{
 "On Windows NT/2000/XP, you can start or stop ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " without rebooting the machine. The ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " service will give no indication that it has started, but the operating \
system will report if it fails to start. On Windows 98/Me, however, you must \
reboot the machine for any changes in configuration to take effect."
}], "Text",
 CellTags->"b:1.0",
 CellID->549735729]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "To prevent ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " from starting each time a Windows NT/2000/XP machine is rebooted:"
}], "Subsubsection",
 CellTags->"b:1.0",
 CellID->135663368],

Cell["\<\
Double-click the Services icon located in the Control Panel\\Administrative \
Tools folder on Windows 2000/XP and in the Control Panel folder on Windows \
NT. To change settings for services, you will need administrative privileges.\
\
\>", "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:1.0",
 CellID->257086160],

Cell[TextData[{
 "Select ",
 StyleBox["Mathematica License Manager", "DialogElementName"],
 " from the list of services and double-click."
}], "ItemizedText",
 CellTags->"b:1.0",
 CellID->622642170],

Cell[TextData[{
 "In the dialog box that appears, set ",
 StyleBox["Startup type", "DialogElementName"],
 " to ",
 StyleBox["Disabled", "DialogElementName"],
 "."
}], "ItemizedText",
 CellTags->"b:1.0",
 CellID->205394612],

Cell[TextData[{
 "Click ",
 StyleBox["OK", "DialogElementName"],
 " to close the dialog box."
}], "ItemizedText",
 CellTags->"b:1.0",
 CellID->386630413],

Cell[TextData[{
 "Alternatively, in a Command Prompt window run the command ",
 StyleBox[".\\mathlm -uninstall", "InlineCode"],
 ". This will remove ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " from the Service list."
}], "IndentedText",
 CellTags->"b:1.0",
 CellID->577826878]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Launching ",
 StyleBox["MathLM",
  FontSlant->"Italic"],
 " on Unix, Linux, and Mac OS X"
}], "Section",
 CellTags->{"i:5", "b:1.1.0", "net: 1"},
 CellID->494380205],

Cell[TextData[{
 "To start ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " on Unix and Linux, you may need ",
 StyleBox["root", "InlineCode"],
 " privileges. To start ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " on Mac OS X, you must have administrative privileges. "
}], "Text",
 CellTags->"b:1.1.0",
 CellID->408218747],

Cell[TextData[{
 "You can start ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " manually at any time using the command\[Hyphen]line options listed in ",
 ButtonBox["Command-Line Options",
  BaseStyle->"Hyperlink",
  ButtonData->"i:1b"],
 ". However, it is typical to configure ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " so it starts automatically when the system is rebooted. "
}], "Text",
 CellTags->"b:1.1.0",
 CellID->68521648],

Cell[CellGroupData[{

Cell[TextData[{
 "Starting ",
 StyleBox["MathLM",
  FontSlant->"Italic"],
 " automatically on Unix and Linux"
}], "Subsection",
 CellTags->{"i:8", "b:1.1.0", "net: 3"},
 CellID->57187843],

Cell["\<\
To do this, create a new startup script containing the following lines, or \
add them to an existing system startup script.\
\>", "Text",
 CellTags->{"b:1.1.0", "i:2"},
 CellID->151223892],

Cell[TextData[{
 "if [ -f /usr/local/Wolfram/MathLM/mathlm]; \nthen \
/usr/local/Wolfram/MathLM/mathlm -logfile ",
 StyleBox["filename", "TI"],
 ";\nfi"
}], "Program",
 CellTags->"b:1.1.0",
 CellID->474912747]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Starting ",
 StyleBox["MathLM",
  FontSlant->"Italic"],
 " automatically on Mac OS X"
}], "Subsection",
 CellTags->{"i:9", "b:1.1.0", "net: 4"},
 CellID->736343166],

Cell[TextData[{
 "To do this, you can write a startup item for ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 ". Startup items are programs (such as shell scripts) that are run during \
the last phase of booting a Mac OS X system. They can be configured to \
perform tasks such as clearing away temporary files or starting system \
daemons."
}], "Text",
 CellTags->{"b:1.1.0", "i:3"},
 CellID->66357568],

Cell[CellGroupData[{

Cell[TextData[{
 "To create a startup item for ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 ":"
}], "Subsubsection",
 CellTags->{"b:1.1.0", "i:1"},
 CellID->275354653],

Cell[TextData[{
 "Create a directory called ",
 StyleBox["MathLM", "InlineCode"],
 " in /Library/StartupItems. You might need to create the directory \
/Library/StartupItems first."
}], "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:1.1.0",
 CellID->5320483],

Cell[CellGroupData[{

Cell[TextData[{
 "In ",
 "/Library/StartupItems/MathLM",
 ", create a file called ",
 StyleBox["MathLM", "InlineCode"],
 " with the following contents. The name of the file must be the same as the \
name of the directory."
}], "ItemizedText",
 CellTags->"b:1.1.0",
 CellID->162181579],

Cell["\<\
#!/bin/sh
. /etc/rc.common
##
#  This script will start up the Mathematica License Manager, mathlm.
##
if [  \"${MATHLM:=-YES-}\" = \"-YES-\" ]; then
 ConsoleMessage \"Starting the Mathematica License Manager\"
 /usr/local/Wolfram/MathLM/mathlm 
else
 ConsoleMessage \"The Mathematica License Manager was not started\"
fi\
\>", "Program",
 CellTags->"b:1.1.0",
 CellID->697044530]
}, Open  ]],

Cell[CellGroupData[{

Cell["Change permissions on the file to make it executable.", "ItemizedText",
 CellTags->"b:1.1.0",
 CellID->362882217],

Cell["chmod 755 MathLM", "Program",
 CellTags->"b:1.1.0",
 CellID->22021233]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "In the same directory, /Library/StartupItems/MathLM, create a file called \
",
 StyleBox["StartupParameters.plist", "InlineCode"],
 " with the following contents."
}], "ItemizedText",
 CellTags->"b:1.1.0",
 CellID->12592317],

Cell["\<\
{
 Description = \"Mathematica License Manager\";
 Provides = (\"MathLM\");
 Requires = (\"Core Services\");
 OrderPreference = \"None\";
 Messages = {
\tstart = \"Starting Mathematica License Manager\";
\tstop  = \"Stopping Mathematica License Manager\";
\t\t\t};
}\
\>", "Program",
 CellTags->"b:1.1.0",
 CellID->49136495]
}, Open  ]],

Cell[CellGroupData[{

Cell["Change permissions on the file to make it read-only.", "ItemizedText",
 CellTags->"b:1.1.0",
 CellID->315098495],

Cell["chmod 644 StartupParameters.plist", "Program",
 CellTags->"b:1.1.0",
 CellID->235661512]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Edit the /etc/hostconfig file, and add the following text in the Services \
section.\
\>", "ItemizedText",
 CellTags->"b:1.1.0",
 CellID->43988313],

Cell["MATHLM=-YES-", "Program",
 CellTags->"b:1.1.0",
 CellID->287705891]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "To start ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " without rebooting, run the following command."
}], "ItemizedText",
 CellTags->"b:1.1.0",
 CellID->368913394],

Cell["SystemStarter start MathLM", "Program",
 CellTags->"b:1.1.0",
 CellID->146028804]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["MathLM",
  FontSlant->"Italic"],
 " Command-Line Options"
}], "Section",
 CellTags->{"i:1b", "b:2.0", "net: 1"},
 CellID->574275790],

Cell[TextData[{
 "The ",
 StyleBox["mathlm", "InlineCode"],
 " command supports the following command-line options. On Windows, a slash \
(",
 StyleBox["/", "InlineCode"],
 ") or a dash (",
 StyleBox["-", "InlineCode"],
 ") may be used to indicate options."
}], "Text",
 CellTags->"b:2.0",
 CellID->576965005],

Cell[TextData[StyleBox["-foreground", "InlineCode"]], "IndentedText",
 CellTags->"b:2.0",
 CellID->619077759],

Cell[TextData[{
 "Keeps ",
 StyleBox["mathlm", "InlineCode"],
 " in the foreground and prints server messages to ",
 StyleBox["stdout", "InlineCode"],
 StyleBox[".", "TR"],
 " "
}], "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->52860943],

Cell[TextData[StyleBox["-help", "InlineCode"]], "IndentedText",
 CellTags->"b:2.0",
 CellID->229394810],

Cell[TextData[{
 "Prints the MathID number and a list of all command-line options. On \
Windows, this option can also be specified as ",
 StyleBox["-?", "InlineCode"],
 " or ",
 StyleBox["/?", "InlineCode"],
 "."
}], "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->63664871],

Cell[TextData[StyleBox["-install", "InlineCode"]], "IndentedText",
 CellTags->"b:2.0",
 CellID->352692029],

Cell[TextData[{
 "On Windows only, installs ",
 StyleBox["mathlm", "InlineCode"],
 " as a service program and automatically starts the service. When this \
option is specified, all additional arguments are stored as part of the ",
 StyleBox["mathlm", "InlineCode"],
 " command and used when starting ",
 StyleBox["mathlm", "InlineCode"],
 " automatically. "
}], "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->428715079],

Cell[TextData[{
 StyleBox["-language ", "InlineCode"],
 StyleBox["lang", "TI"]
}], "IndentedText",
 CellTags->"b:2.0",
 CellID->464619691],

Cell[TextData[{
 "Specifies the language in which to display server messages. The argument ",
 StyleBox["lang", "TI"],
 " can be set to English, German, French, or Japanese."
}], "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->138401801],

Cell[TextData[StyleBox["-localtime", "InlineCode"]], "IndentedText",
 CellTags->"b:2.0",
 CellID->507775327],

Cell["Uses local time instead of GMT in server messages.", \
"ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->215360],

Cell[TextData[{
 StyleBox["-logfile ", "InlineCode"],
 StyleBox["file", "TI"]
}], "IndentedText",
 CellTags->"b:2.0",
 CellID->145425822],

Cell[TextData[{
 "Writes server messages to ",
 StyleBox["file", "TI"],
 ". The format for server messages is determined by the option ",
 StyleBox["-logformat", "InlineCode"],
 ". The user running ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " must have write permission to ",
 StyleBox["file", "TI"],
 ". Otherwise, an error will be reported to ",
 StyleBox["stdout", "InlineCode"],
 ". On Windows, this error is also written to the event log."
}], "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->364221068],

Cell[TextData[{
 StyleBox["-logformat ", "InlineCode"],
 StyleBox["string", "TI"]
}], "IndentedText",
 CellTags->"b:2.0",
 CellID->550621119],

Cell[TextData[{
 "Specifies the format for displaying server messages. The default format is \
the W3C Common Logfile Format. For information on editing the string argument \
to change the display format, see \"",
 ButtonBox["Monitoring ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MonitoringMathLM"],
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MonitoringMathLM"],
  FontSlant->"Italic"],
 "\". "
}], "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->207937984],

Cell[TextData[{
 StyleBox["-loglevel ", "InlineCode"],
 StyleBox["n", "TI"]
}], "IndentedText",
 CellTags->"b:2.0",
 CellID->15324206],

Cell[TextData[{
 "Specifies the level of verbosity of server messages written to the file \
specified by ",
 StyleBox["-logfile", "InlineCode"],
 ". The numeric argument specifies the level of verbosity, with 1 being the \
least and 4 the most verbose. For each level, startup/shutdown errors are \
copied to the event log on Windows. The default verbosity level depends on \
the settings of other options."
}], "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->896309911],

Cell["The four levels are as follows.", "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->356655646],

Cell[TextData[{
 "Reports server startup/shutdown errors (password file could not be found, \
log file could not be written to, and so on). A message stating that ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " has been started is also displayed."
}], "ItemizedTextParagraph",
 CellFrameLabels->{{
    Cell[
     TextData[{
       StyleBox["1.", "TB"]}], CellBaseline -> Baseline, 
     CellSize -> {24, Inherited}, TextAlignment -> Right], Inherited}, {
   Inherited, Inherited}},
 CellTags->"b:2.0",
 CellID->108325733],

Cell["\<\
Reports everything from level 1 plus all runtime error messages (license \
denied, restricted, and so on).\
\>", "ItemizedTextParagraph",
 CellFrameLabels->{{
    Cell[
     TextData[{
       StyleBox["2.", "TB"]}], CellBaseline -> Baseline, 
     CellSize -> {24, Inherited}, TextAlignment -> Right], Inherited}, {
   Inherited, Inherited}},
 CellTags->"b:2.0",
 CellID->404945210],

Cell["\<\
Reports everything from level 2 plus all license activity (license requests, \
returns, and so on). This level also displays startup messages showing the \
process ID, socket number, and so on.\
\>", "ItemizedTextParagraph",
 CellFrameLabels->{{
    Cell[
     TextData[{
       StyleBox["3.", "TB"]}], CellBaseline -> Baseline, 
     CellSize -> {24, Inherited}, TextAlignment -> Right], Inherited}, {
   Inherited, Inherited}},
 CounterBoxOptions->{CounterFunction:>Identity},
 CellTags->"b:2.0",
 CellID->16968384],

Cell["\<\
Reports everything from level 3 plus debugging information (network \
communication) and a license table for every license transaction. This level \
is designed mainly for interactive debugging.\
\>", "ItemizedTextParagraph",
 CellFrameLabels->{{
    Cell[
     TextData[{
       StyleBox["4.", "TB"]}], CellBaseline -> Baseline, 
     CellSize -> {24, Inherited}, TextAlignment -> Right], Inherited}, {
   Inherited, Inherited}},
 CellTags->"b:2.0",
 CellID->163901371],

Cell[TextData[{
 "If the ",
 StyleBox["-foreground", "InlineCode"],
 " option is used, the default verbosity level is set to 4."
}], "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->277184795],

Cell[TextData[{
 "If the ",
 StyleBox["-logfile", "InlineCode"],
 " option is specified without the ",
 StyleBox["-loglevel", "InlineCode"],
 " option, the default is set to 3."
}], "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->519527],

Cell[TextData[{
 "If the ",
 StyleBox["-loglevel", "InlineCode"],
 " option is specified without a level, the default is set to 4."
}], "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->101963470],

Cell[TextData[StyleBox["-noremotemonitor", "InlineCode"]], "IndentedText",
 CellTags->"b:2.0",
 CellID->10348670],

Cell[TextData[{
 "Specifies that ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " cannot be remotely monitored via ",
 StyleBox[ButtonBox["MonitorLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/monitorlm"],
  FontSlant->"Italic"],
 "."
}], "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->7955180],

Cell[TextData[{
 StyleBox["-pwfile ", "InlineCode"],
 StyleBox["file", "TI"]
}], "IndentedText",
 CellTags->"b:2.0",
 CellID->789303360],

Cell[TextData[{
 "Specifies a file in which to look for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " passwords."
}], "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->8962457],

Cell[TextData[{
 StyleBox["-restrict ", "InlineCode"],
 StyleBox["file", "TI"]
}], "IndentedText",
 CellTags->"b:2.0",
 CellID->91925667],

Cell[TextData[{
 "Uses the script contained in ",
 StyleBox["file", "TI"],
 " to limit or deny access to specified users or machines. See \"",
 ButtonBox["Restricting and Reserving Licenses\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/RestrictingAndReservingLicenses"],
 " for information on how to write a restriction script."
}], "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->119307077],

Cell[TextData[{
 StyleBox["-timeout ", "InlineCode"],
 StyleBox["n", "TI"]
}], "IndentedText",
 CellTags->"b:2.0",
 CellID->502163955],

Cell[TextData[{
 "Returns a suspended license after ",
 StyleBox["n", "TI"],
 " hours. The default is infinity."
}], "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->61171193],

Cell[TextData[{
 StyleBox["-trfile ", "InlineCode"],
 StyleBox["file", "TI"]
}], "IndentedText",
 CellTags->"b:2.0",
 CellID->649120],

Cell["\<\
Specifies a file that defines substitutions for the text of error messages. \
This provides a simple way of replacing error messages by their translated \
equivalents.\
\>", "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->494177093],

Cell[TextData[StyleBox["-uninstall", "InlineCode"]], "IndentedText",
 CellTags->"b:2.0",
 CellID->136945596],

Cell[TextData[{
 "On Windows only, stops any currently running ",
 StyleBox["mathlm", "InlineCode"],
 " processes and removes ",
 StyleBox["mathlm", "InlineCode"],
 " from the list of services."
}], "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->712658826],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->370182449],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"RelatedTutorials",
 CellID->13855348]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Launching MathLM  - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 18.7877770}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Once installed, MathLM starts running automatically by default each time \
the machine is rebooted. To start or stop MathLM manually, follow these \
instructions. It is assumed here that MathLM is installed in the default \
location, C:\\Program Files\\Wolfram Research \\MathLM. Under normal \
conditions, the installer will install MathLM as a service on the machine. \
This means MathLM will start automatically each time the machine is rebooted. \
You can manually change the settings that control whether MathLM starts when \
the machine is rebooted. ", "synonyms" -> {}, "title" -> "Launching MathLM ", 
    "type" -> "Tutorial", "uri" -> "tutorial/LaunchingMathLM"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:1.0"->{
  Cell[1454, 54, 156, 7, 70, "Section",
   CellTags->{"b:1.0", "net: 1"},
   CellID->311263493],
  Cell[1635, 65, 164, 7, 70, "Subsection",
   CellTags->{"i:2", "b:1.0", "net: 2"},
   CellID->354955318],
  Cell[1802, 74, 467, 15, 70, "Text",
   CellTags->"b:1.0",
   CellID->329375866],
  Cell[2272, 91, 312, 11, 70, "Text",
   CellTags->"b:1.0",
   CellID->18546427],
  Cell[2609, 106, 234, 9, 70, "Subsubsection",
   CellTags->"b:1.0",
   CellID->216609866],
  Cell[2846, 117, 287, 9, 70, "ItemizedText",
   CounterAssignments->{{"ItemizedList", 0}},
   CellTags->"b:1.0",
   CellID->156156522],
  Cell[3136, 128, 286, 9, 70, "ItemizedText",
   CellTags->"b:1.0",
   CellID->14907943],
  Cell[3425, 139, 464, 16, 70, "ItemizedText",
   CellTags->"b:1.0",
   CellID->36257786],
  Cell[3926, 160, 238, 9, 70, "Subsubsection",
   CellTags->"b:1.0",
   CellID->28773564],
  Cell[4167, 171, 340, 11, 70, "ItemizedText",
   CounterAssignments->{{"ItemizedList", 0}},
   CellTags->"b:1.0",
   CellID->55987767],
  Cell[4510, 184, 289, 6, 70, "ItemizedText",
   CellTags->"b:1.0",
   CellID->266760863],
  Cell[4802, 192, 181, 6, 70, "ItemizedText",
   CellTags->"b:1.0",
   CellID->355313255],
  Cell[4986, 200, 374, 10, 70, "ItemizedText",
   CellTags->"b:1.0",
   CellID->316504170],
  Cell[5363, 212, 188, 6, 70, "IndentedText",
   CellTags->"b:1.0",
   CellID->179942989],
  Cell[5588, 223, 243, 9, 70, "Subsubsection",
   CellTags->{"i:11", "b:1.0"},
   CellID->126874819],
  Cell[5834, 234, 396, 13, 70, "ItemizedText",
   CounterAssignments->{{"ItemizedList", 0}},
   CellTags->"b:1.0",
   CellID->20183709],
  Cell[6233, 249, 157, 6, 70, "ItemizedText",
   CellTags->"b:1.0",
   CellID->155946793],
  Cell[6393, 257, 134, 6, 70, "ItemizedText",
   CellTags->"b:1.0",
   CellID->67730785],
  Cell[6564, 268, 238, 9, 70, "Subsubsection",
   CellTags->"b:1.0",
   CellID->153716888],
  Cell[6805, 279, 349, 8, 70, "ItemizedText",
   CounterAssignments->{{"ItemizedList", 0}},
   CellTags->"b:1.0",
   CellID->43305008],
  Cell[7157, 289, 180, 6, 70, "ItemizedText",
   CellTags->"b:1.0",
   CellID->40895431],
  Cell[7340, 297, 396, 11, 70, "ItemizedText",
   CellTags->"b:1.0",
   CellID->146063425],
  Cell[7739, 310, 186, 6, 70, "IndentedText",
   CellTags->"b:1.0",
   CellID->70184551],
  Cell[7974, 322, 167, 7, 70, "Subsection",
   CellTags->{"i:4", "b:1.0", "net: 3"},
   CellID->24220764],
  Cell[8144, 331, 705, 20, 70, "Text",
   CellTags->{"i:10", "b:1.0"},
   CellID->101920823],
  Cell[8852, 353, 303, 10, 70, "Text",
   CellTags->"b:1.0",
   CellID->39884604],
  Cell[9180, 367, 260, 9, 70, "Subsubsection",
   CellTags->"b:1.0",
   CellID->220975342],
  Cell[9443, 378, 287, 9, 70, "ItemizedText",
   CounterAssignments->{{"ItemizedList", 0}},
   CellTags->"b:1.0",
   CellID->570565587],
  Cell[9733, 389, 287, 9, 70, "ItemizedText",
   CellTags->"b:1.0",
   CellID->106056202],
  Cell[10023, 400, 136, 6, 70, "ItemizedText",
   CellTags->"b:1.0",
   CellID->214144821],
  Cell[10162, 408, 242, 7, 70, "ItemizedText",
   CellTags->"b:1.0",
   CellID->466506169],
  Cell[10441, 420, 276, 9, 70, "Subsubsection",
   CellTags->"b:1.0",
   CellID->241627051],
  Cell[10720, 431, 130, 3, 70, "ItemizedText",
   CounterAssignments->{{"ItemizedList", 0}},
   CellTags->"b:1.0",
   CellID->196685893],
  Cell[10853, 436, 287, 9, 70, "ItemizedText",
   CellTags->"b:1.0",
   CellID->272084236],
  Cell[11143, 447, 138, 6, 70, "ItemizedText",
   CellTags->"b:1.0",
   CellID->215416157],
  Cell[11318, 458, 264, 9, 70, "Subsubsection",
   CellTags->"b:1.0",
   CellID->76000657],
  Cell[11585, 469, 330, 10, 70, "ItemizedText",
   CounterAssignments->{{"ItemizedList", 0}},
   CellTags->"b:1.0",
   CellID->32313873],
  Cell[11918, 481, 287, 9, 70, "ItemizedText",
   CellTags->"b:1.0",
   CellID->485738660],
  Cell[12230, 494, 136, 6, 70, "ItemizedText",
   CellTags->"b:1.0",
   CellID->244389379],
  Cell[12369, 502, 314, 10, 70, "Text",
   CellTags->"b:1.0",
   CellID->138799686],
  Cell[12698, 515, 349, 8, 70, "ItemizedText",
   CounterAssignments->{{"ItemizedText", 0}},
   CellTags->"b:1.0",
   CellID->54624671],
  Cell[13050, 525, 219, 7, 70, "ItemizedText",
   PageBreakAbove->True,
   CellTags->"b:1.0",
   CellID->6821549],
  Cell[13272, 534, 244, 9, 70, "ItemizedText",
   CellTags->"b:1.0",
   CellID->313924175],
  Cell[13541, 547, 153, 6, 70, "ItemizedText",
   CellTags->"b:1.0",
   CellID->437504892],
  Cell[13697, 555, 620, 16, 70, "Text",
   CellTags->"b:1.0",
   CellID->549735729],
  Cell[14366, 577, 281, 9, 70, "Subsubsection",
   CellTags->"b:1.0",
   CellID->135663368],
  Cell[14650, 588, 350, 8, 70, "ItemizedText",
   CounterAssignments->{{"ItemizedList", 0}},
   CellTags->"b:1.0",
   CellID->257086160],
  Cell[15003, 598, 198, 6, 70, "ItemizedText",
   CellTags->"b:1.0",
   CellID->622642170],
  Cell[15204, 606, 222, 8, 70, "ItemizedText",
   CellTags->"b:1.0",
   CellID->205394612],
  Cell[15429, 616, 153, 6, 70, "ItemizedText",
   CellTags->"b:1.0",
   CellID->386630413],
  Cell[15585, 624, 357, 11, 70, "IndentedText",
   CellTags->"b:1.0",
   CellID->577826878]},
 "net: 1"->{
  Cell[1454, 54, 156, 7, 70, "Section",
   CellTags->{"b:1.0", "net: 1"},
   CellID->311263493],
  Cell[16003, 642, 183, 7, 70, "Section",
   CellTags->{"i:5", "b:1.1.0", "net: 1"},
   CellID->494380205],
  Cell[21678, 881, 159, 6, 70, "Section",
   CellTags->{"i:1b", "b:2.0", "net: 1"},
   CellID->574275790]},
 "i:2"->{
  Cell[1635, 65, 164, 7, 70, "Subsection",
   CellTags->{"i:2", "b:1.0", "net: 2"},
   CellID->354955318],
  Cell[17474, 700, 198, 5, 70, "Text",
   CellTags->{"b:1.1.0", "i:2"},
   CellID->151223892]},
 "net: 2"->{
  Cell[1635, 65, 164, 7, 70, "Subsection",
   CellTags->{"i:2", "b:1.0", "net: 2"},
   CellID->354955318]},
 "i:11"->{
  Cell[5588, 223, 243, 9, 70, "Subsubsection",
   CellTags->{"i:11", "b:1.0"},
   CellID->126874819]},
 "i:4"->{
  Cell[7974, 322, 167, 7, 70, "Subsection",
   CellTags->{"i:4", "b:1.0", "net: 3"},
   CellID->24220764]},
 "net: 3"->{
  Cell[7974, 322, 167, 7, 70, "Subsection",
   CellTags->{"i:4", "b:1.0", "net: 3"},
   CellID->24220764],
  Cell[17284, 691, 187, 7, 70, "Subsection",
   CellTags->{"i:8", "b:1.1.0", "net: 3"},
   CellID->57187843]},
 "i:10"->{
  Cell[8144, 331, 705, 20, 70, "Text",
   CellTags->{"i:10", "b:1.0"},
   CellID->101920823]},
 "i:5"->{
  Cell[16003, 642, 183, 7, 70, "Section",
   CellTags->{"i:5", "b:1.1.0", "net: 1"},
   CellID->494380205]},
 "b:1.1.0"->{
  Cell[16003, 642, 183, 7, 70, "Section",
   CellTags->{"i:5", "b:1.1.0", "net: 1"},
   CellID->494380205],
  Cell[16189, 651, 478, 16, 70, "Text",
   CellTags->"b:1.1.0",
   CellID->408218747],
  Cell[16670, 669, 589, 18, 70, "Text",
   CellTags->"b:1.1.0",
   CellID->68521648],
  Cell[17284, 691, 187, 7, 70, "Subsection",
   CellTags->{"i:8", "b:1.1.0", "net: 3"},
   CellID->57187843],
  Cell[17474, 700, 198, 5, 70, "Text",
   CellTags->{"b:1.1.0", "i:2"},
   CellID->151223892],
  Cell[17675, 707, 209, 7, 70, "Program",
   CellTags->"b:1.1.0",
   CellID->474912747],
  Cell[17921, 719, 182, 7, 70, "Subsection",
   CellTags->{"i:9", "b:1.1.0", "net: 4"},
   CellID->736343166],
  Cell[18106, 728, 479, 12, 70, "Text",
   CellTags->{"b:1.1.0", "i:3"},
   CellID->66357568],
  Cell[18610, 744, 245, 9, 70, "Subsubsection",
   CellTags->{"b:1.1.0", "i:1"},
   CellID->275354653],
  Cell[18858, 755, 285, 8, 70, "ItemizedText",
   CounterAssignments->{{"ItemizedList", 0}},
   CellTags->"b:1.1.0",
   CellID->5320483],
  Cell[19168, 767, 284, 9, 70, "ItemizedText",
   CellTags->"b:1.1.0",
   CellID->162181579],
  Cell[19455, 778, 390, 14, 70, "Program",
   CellTags->"b:1.1.0",
   CellID->697044530],
  Cell[19882, 797, 119, 2, 70, "ItemizedText",
   CellTags->"b:1.1.0",
   CellID->362882217],
  Cell[20004, 801, 76, 2, 70, "Program",
   CellTags->"b:1.1.0",
   CellID->22021233],
  Cell[20117, 808, 242, 7, 70, "ItemizedText",
   CellTags->"b:1.1.0",
   CellID->12592317],
  Cell[20362, 817, 334, 13, 70, "Program",
   CellTags->"b:1.1.0",
   CellID->49136495],
  Cell[20733, 835, 118, 2, 70, "ItemizedText",
   CellTags->"b:1.1.0",
   CellID->315098495],
  Cell[20854, 839, 94, 2, 70, "Program",
   CellTags->"b:1.1.0",
   CellID->235661512],
  Cell[20985, 846, 157, 5, 70, "ItemizedText",
   CellTags->"b:1.1.0",
   CellID->43988313],
  Cell[21145, 853, 73, 2, 70, "Program",
   CellTags->"b:1.1.0",
   CellID->287705891],
  Cell[21255, 860, 260, 9, 70, "ItemizedText",
   CellTags->"b:1.1.0",
   CellID->368913394],
  Cell[21518, 871, 87, 2, 70, "Program",
   CellTags->"b:1.1.0",
   CellID->146028804]},
 "i:8"->{
  Cell[17284, 691, 187, 7, 70, "Subsection",
   CellTags->{"i:8", "b:1.1.0", "net: 3"},
   CellID->57187843]},
 "i:9"->{
  Cell[17921, 719, 182, 7, 70, "Subsection",
   CellTags->{"i:9", "b:1.1.0", "net: 4"},
   CellID->736343166]},
 "net: 4"->{
  Cell[17921, 719, 182, 7, 70, "Subsection",
   CellTags->{"i:9", "b:1.1.0", "net: 4"},
   CellID->736343166]},
 "i:3"->{
  Cell[18106, 728, 479, 12, 70, "Text",
   CellTags->{"b:1.1.0", "i:3"},
   CellID->66357568]},
 "i:1"->{
  Cell[18610, 744, 245, 9, 70, "Subsubsection",
   CellTags->{"b:1.1.0", "i:1"},
   CellID->275354653]},
 "i:1b"->{
  Cell[21678, 881, 159, 6, 70, "Section",
   CellTags->{"i:1b", "b:2.0", "net: 1"},
   CellID->574275790]},
 "b:2.0"->{
  Cell[21678, 881, 159, 6, 70, "Section",
   CellTags->{"i:1b", "b:2.0", "net: 1"},
   CellID->574275790],
  Cell[21840, 889, 309, 11, 70, "Text",
   CellTags->"b:2.0",
   CellID->576965005],
  Cell[22152, 902, 109, 2, 70, "IndentedText",
   CellTags->"b:2.0",
   CellID->619077759],
  Cell[22264, 906, 245, 9, 70, "ItemizedTextParagraph",
   CellTags->"b:2.0",
   CellID->52860943],
  Cell[22512, 917, 103, 2, 70, "IndentedText",
   CellTags->"b:2.0",
   CellID->229394810],
  Cell[22618, 921, 280, 9, 70, "ItemizedTextParagraph",
   CellTags->"b:2.0",
   CellID->63664871],
  Cell[22901, 932, 106, 2, 70, "IndentedText",
   CellTags->"b:2.0",
   CellID->352692029],
  Cell[23010, 936, 426, 11, 70, "ItemizedTextParagraph",
   CellTags->"b:2.0",
   CellID->428715079],
  Cell[23439, 949, 138, 5, 70, "IndentedText",
   CellTags->"b:2.0",
   CellID->464619691],
  Cell[23580, 956, 243, 6, 70, "ItemizedTextParagraph",
   CellTags->"b:2.0",
   CellID->138401801],
  Cell[23826, 964, 108, 2, 70, "IndentedText",
   CellTags->"b:2.0",
   CellID->507775327],
  Cell[23937, 968, 122, 3, 70, "ItemizedTextParagraph",
   CellTags->"b:2.0",
   CellID->215360],
  Cell[24062, 973, 137, 5, 70, "IndentedText",
   CellTags->"b:2.0",
   CellID->145425822],
  Cell[24202, 980, 593, 17, 70, "ItemizedTextParagraph",
   CellTags->"b:2.0",
   CellID->364221068],
  Cell[24798, 999, 141, 5, 70, "IndentedText",
   CellTags->"b:2.0",
   CellID->550621119],
  Cell[24942, 1006, 514, 14, 70, "ItemizedTextParagraph",
   CellTags->"b:2.0",
   CellID->207937984],
  Cell[25459, 1022, 134, 5, 70, "IndentedText",
   CellTags->"b:2.0",
   CellID->15324206],
  Cell[25596, 1029, 476, 10, 70, "ItemizedTextParagraph",
   CellTags->"b:2.0",
   CellID->896309911],
  Cell[26075, 1041, 104, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.0",
   CellID->356655646],
  Cell[26182, 1045, 598, 16, 70, "ItemizedTextParagraph",
   CellTags->"b:2.0",
   CellID->108325733],
  Cell[26783, 1063, 392, 11, 70, "ItemizedTextParagraph",
   CellTags->"b:2.0",
   CellID->404945210],
  Cell[27178, 1076, 527, 13, 70, "ItemizedTextParagraph",
   CellTags->"b:2.0",
   CellID->16968384],
  Cell[27708, 1091, 480, 12, 70, "ItemizedTextParagraph",
   CellTags->"b:2.0",
   CellID->163901371],
  Cell[28191, 1105, 197, 6, 70, "ItemizedTextParagraph",
   CellTags->"b:2.0",
   CellID->277184795],
  Cell[28391, 1113, 243, 8, 70, "ItemizedTextParagraph",
   CellTags->"b:2.0",
   CellID->519527],
  Cell[28637, 1123, 200, 6, 70, "ItemizedTextParagraph",
   CellTags->"b:2.0",
   CellID->101963470],
  Cell[28840, 1131, 113, 2, 70, "IndentedText",
   CellTags->"b:2.0",
   CellID->10348670],
  Cell[28956, 1135, 390, 14, 70, "ItemizedTextParagraph",
   CellTags->"b:2.0",
   CellID->7955180],
  Cell[29349, 1151, 136, 5, 70, "IndentedText",
   CellTags->"b:2.0",
   CellID->789303360],
  Cell[29488, 1158, 189, 7, 70, "ItemizedTextParagraph",
   CellTags->"b:2.0",
   CellID->8962457],
  Cell[29680, 1167, 137, 5, 70, "IndentedText",
   CellTags->"b:2.0",
   CellID->91925667],
  Cell[29820, 1174, 407, 10, 70, "ItemizedTextParagraph",
   CellTags->"b:2.0",
   CellID->119307077],
  Cell[30230, 1186, 134, 5, 70, "IndentedText",
   CellTags->"b:2.0",
   CellID->502163955],
  Cell[30367, 1193, 180, 6, 70, "ItemizedTextParagraph",
   CellTags->"b:2.0",
   CellID->61171193],
  Cell[30550, 1201, 133, 5, 70, "IndentedText",
   CellTags->"b:2.0",
   CellID->649120],
  Cell[30686, 1208, 248, 6, 70, "ItemizedTextParagraph",
   CellTags->"b:2.0",
   CellID->494177093],
  Cell[30937, 1216, 108, 2, 70, "IndentedText",
   CellTags->"b:2.0",
   CellID->136945596],
  Cell[31048, 1220, 263, 8, 70, "ItemizedTextParagraph",
   CellTags->"b:2.0",
   CellID->712658826]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:1.0", 33422, 1285},
 {"net: 1", 38551, 1449},
 {"i:2", 38874, 1459},
 {"net: 2", 39090, 1466},
 {"i:11", 39209, 1470},
 {"i:4", 39322, 1474},
 {"net: 3", 39443, 1478},
 {"i:10", 39672, 1485},
 {"i:5", 39777, 1489},
 {"b:1.1.0", 39900, 1493},
 {"i:8", 42026, 1561},
 {"i:9", 42147, 1565},
 {"net: 4", 42272, 1569},
 {"i:3", 42394, 1573},
 {"i:1", 42500, 1577},
 {"i:1b", 42616, 1581},
 {"b:2.0", 42736, 1585}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 694, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1319, 44, 110, 6, 70, "Title",
 CellID->5835212],
Cell[CellGroupData[{
Cell[1454, 54, 156, 7, 70, "Section",
 CellTags->{"b:1.0", "net: 1"},
 CellID->311263493],
Cell[CellGroupData[{
Cell[1635, 65, 164, 7, 70, "Subsection",
 CellTags->{"i:2", "b:1.0", "net: 2"},
 CellID->354955318],
Cell[1802, 74, 467, 15, 70, "Text",
 CellTags->"b:1.0",
 CellID->329375866],
Cell[2272, 91, 312, 11, 70, "Text",
 CellTags->"b:1.0",
 CellID->18546427],
Cell[CellGroupData[{
Cell[2609, 106, 234, 9, 70, "Subsubsection",
 CellTags->"b:1.0",
 CellID->216609866],
Cell[2846, 117, 287, 9, 70, "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:1.0",
 CellID->156156522],
Cell[3136, 128, 286, 9, 70, "ItemizedText",
 CellTags->"b:1.0",
 CellID->14907943],
Cell[3425, 139, 464, 16, 70, "ItemizedText",
 CellTags->"b:1.0",
 CellID->36257786]
}, Open  ]],
Cell[CellGroupData[{
Cell[3926, 160, 238, 9, 70, "Subsubsection",
 CellTags->"b:1.0",
 CellID->28773564],
Cell[4167, 171, 340, 11, 70, "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:1.0",
 CellID->55987767],
Cell[4510, 184, 289, 6, 70, "ItemizedText",
 CellTags->"b:1.0",
 CellID->266760863],
Cell[4802, 192, 181, 6, 70, "ItemizedText",
 CellTags->"b:1.0",
 CellID->355313255],
Cell[4986, 200, 374, 10, 70, "ItemizedText",
 CellTags->"b:1.0",
 CellID->316504170],
Cell[5363, 212, 188, 6, 70, "IndentedText",
 CellTags->"b:1.0",
 CellID->179942989]
}, Open  ]],
Cell[CellGroupData[{
Cell[5588, 223, 243, 9, 70, "Subsubsection",
 CellTags->{"i:11", "b:1.0"},
 CellID->126874819],
Cell[5834, 234, 396, 13, 70, "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:1.0",
 CellID->20183709],
Cell[6233, 249, 157, 6, 70, "ItemizedText",
 CellTags->"b:1.0",
 CellID->155946793],
Cell[6393, 257, 134, 6, 70, "ItemizedText",
 CellTags->"b:1.0",
 CellID->67730785]
}, Open  ]],
Cell[CellGroupData[{
Cell[6564, 268, 238, 9, 70, "Subsubsection",
 CellTags->"b:1.0",
 CellID->153716888],
Cell[6805, 279, 349, 8, 70, "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:1.0",
 CellID->43305008],
Cell[7157, 289, 180, 6, 70, "ItemizedText",
 CellTags->"b:1.0",
 CellID->40895431],
Cell[7340, 297, 396, 11, 70, "ItemizedText",
 CellTags->"b:1.0",
 CellID->146063425],
Cell[7739, 310, 186, 6, 70, "IndentedText",
 CellTags->"b:1.0",
 CellID->70184551]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7974, 322, 167, 7, 70, "Subsection",
 CellTags->{"i:4", "b:1.0", "net: 3"},
 CellID->24220764],
Cell[8144, 331, 705, 20, 70, "Text",
 CellTags->{"i:10", "b:1.0"},
 CellID->101920823],
Cell[8852, 353, 303, 10, 70, "Text",
 CellTags->"b:1.0",
 CellID->39884604],
Cell[CellGroupData[{
Cell[9180, 367, 260, 9, 70, "Subsubsection",
 CellTags->"b:1.0",
 CellID->220975342],
Cell[9443, 378, 287, 9, 70, "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:1.0",
 CellID->570565587],
Cell[9733, 389, 287, 9, 70, "ItemizedText",
 CellTags->"b:1.0",
 CellID->106056202],
Cell[10023, 400, 136, 6, 70, "ItemizedText",
 CellTags->"b:1.0",
 CellID->214144821],
Cell[10162, 408, 242, 7, 70, "ItemizedText",
 CellTags->"b:1.0",
 CellID->466506169]
}, Open  ]],
Cell[CellGroupData[{
Cell[10441, 420, 276, 9, 70, "Subsubsection",
 CellTags->"b:1.0",
 CellID->241627051],
Cell[10720, 431, 130, 3, 70, "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:1.0",
 CellID->196685893],
Cell[10853, 436, 287, 9, 70, "ItemizedText",
 CellTags->"b:1.0",
 CellID->272084236],
Cell[11143, 447, 138, 6, 70, "ItemizedText",
 CellTags->"b:1.0",
 CellID->215416157]
}, Open  ]],
Cell[CellGroupData[{
Cell[11318, 458, 264, 9, 70, "Subsubsection",
 CellTags->"b:1.0",
 CellID->76000657],
Cell[11585, 469, 330, 10, 70, "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:1.0",
 CellID->32313873],
Cell[11918, 481, 287, 9, 70, "ItemizedText",
 CellTags->"b:1.0",
 CellID->485738660],
Cell[CellGroupData[{
Cell[12230, 494, 136, 6, 70, "ItemizedText",
 CellTags->"b:1.0",
 CellID->244389379],
Cell[12369, 502, 314, 10, 70, "Text",
 CellTags->"b:1.0",
 CellID->138799686]
}, Open  ]],
Cell[12698, 515, 349, 8, 70, "ItemizedText",
 CounterAssignments->{{"ItemizedText", 0}},
 CellTags->"b:1.0",
 CellID->54624671],
Cell[13050, 525, 219, 7, 70, "ItemizedText",
 PageBreakAbove->True,
 CellTags->"b:1.0",
 CellID->6821549],
Cell[13272, 534, 244, 9, 70, "ItemizedText",
 CellTags->"b:1.0",
 CellID->313924175],
Cell[CellGroupData[{
Cell[13541, 547, 153, 6, 70, "ItemizedText",
 CellTags->"b:1.0",
 CellID->437504892],
Cell[13697, 555, 620, 16, 70, "Text",
 CellTags->"b:1.0",
 CellID->549735729]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14366, 577, 281, 9, 70, "Subsubsection",
 CellTags->"b:1.0",
 CellID->135663368],
Cell[14650, 588, 350, 8, 70, "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:1.0",
 CellID->257086160],
Cell[15003, 598, 198, 6, 70, "ItemizedText",
 CellTags->"b:1.0",
 CellID->622642170],
Cell[15204, 606, 222, 8, 70, "ItemizedText",
 CellTags->"b:1.0",
 CellID->205394612],
Cell[15429, 616, 153, 6, 70, "ItemizedText",
 CellTags->"b:1.0",
 CellID->386630413],
Cell[15585, 624, 357, 11, 70, "IndentedText",
 CellTags->"b:1.0",
 CellID->577826878]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16003, 642, 183, 7, 70, "Section",
 CellTags->{"i:5", "b:1.1.0", "net: 1"},
 CellID->494380205],
Cell[16189, 651, 478, 16, 70, "Text",
 CellTags->"b:1.1.0",
 CellID->408218747],
Cell[16670, 669, 589, 18, 70, "Text",
 CellTags->"b:1.1.0",
 CellID->68521648],
Cell[CellGroupData[{
Cell[17284, 691, 187, 7, 70, "Subsection",
 CellTags->{"i:8", "b:1.1.0", "net: 3"},
 CellID->57187843],
Cell[17474, 700, 198, 5, 70, "Text",
 CellTags->{"b:1.1.0", "i:2"},
 CellID->151223892],
Cell[17675, 707, 209, 7, 70, "Program",
 CellTags->"b:1.1.0",
 CellID->474912747]
}, Open  ]],
Cell[CellGroupData[{
Cell[17921, 719, 182, 7, 70, "Subsection",
 CellTags->{"i:9", "b:1.1.0", "net: 4"},
 CellID->736343166],
Cell[18106, 728, 479, 12, 70, "Text",
 CellTags->{"b:1.1.0", "i:3"},
 CellID->66357568],
Cell[CellGroupData[{
Cell[18610, 744, 245, 9, 70, "Subsubsection",
 CellTags->{"b:1.1.0", "i:1"},
 CellID->275354653],
Cell[18858, 755, 285, 8, 70, "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:1.1.0",
 CellID->5320483],
Cell[CellGroupData[{
Cell[19168, 767, 284, 9, 70, "ItemizedText",
 CellTags->"b:1.1.0",
 CellID->162181579],
Cell[19455, 778, 390, 14, 70, "Program",
 CellTags->"b:1.1.0",
 CellID->697044530]
}, Open  ]],
Cell[CellGroupData[{
Cell[19882, 797, 119, 2, 70, "ItemizedText",
 CellTags->"b:1.1.0",
 CellID->362882217],
Cell[20004, 801, 76, 2, 70, "Program",
 CellTags->"b:1.1.0",
 CellID->22021233]
}, Open  ]],
Cell[CellGroupData[{
Cell[20117, 808, 242, 7, 70, "ItemizedText",
 CellTags->"b:1.1.0",
 CellID->12592317],
Cell[20362, 817, 334, 13, 70, "Program",
 CellTags->"b:1.1.0",
 CellID->49136495]
}, Open  ]],
Cell[CellGroupData[{
Cell[20733, 835, 118, 2, 70, "ItemizedText",
 CellTags->"b:1.1.0",
 CellID->315098495],
Cell[20854, 839, 94, 2, 70, "Program",
 CellTags->"b:1.1.0",
 CellID->235661512]
}, Open  ]],
Cell[CellGroupData[{
Cell[20985, 846, 157, 5, 70, "ItemizedText",
 CellTags->"b:1.1.0",
 CellID->43988313],
Cell[21145, 853, 73, 2, 70, "Program",
 CellTags->"b:1.1.0",
 CellID->287705891]
}, Open  ]],
Cell[CellGroupData[{
Cell[21255, 860, 260, 9, 70, "ItemizedText",
 CellTags->"b:1.1.0",
 CellID->368913394],
Cell[21518, 871, 87, 2, 70, "Program",
 CellTags->"b:1.1.0",
 CellID->146028804]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21678, 881, 159, 6, 70, "Section",
 CellTags->{"i:1b", "b:2.0", "net: 1"},
 CellID->574275790],
Cell[21840, 889, 309, 11, 70, "Text",
 CellTags->"b:2.0",
 CellID->576965005],
Cell[22152, 902, 109, 2, 70, "IndentedText",
 CellTags->"b:2.0",
 CellID->619077759],
Cell[22264, 906, 245, 9, 70, "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->52860943],
Cell[22512, 917, 103, 2, 70, "IndentedText",
 CellTags->"b:2.0",
 CellID->229394810],
Cell[22618, 921, 280, 9, 70, "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->63664871],
Cell[22901, 932, 106, 2, 70, "IndentedText",
 CellTags->"b:2.0",
 CellID->352692029],
Cell[23010, 936, 426, 11, 70, "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->428715079],
Cell[23439, 949, 138, 5, 70, "IndentedText",
 CellTags->"b:2.0",
 CellID->464619691],
Cell[23580, 956, 243, 6, 70, "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->138401801],
Cell[23826, 964, 108, 2, 70, "IndentedText",
 CellTags->"b:2.0",
 CellID->507775327],
Cell[23937, 968, 122, 3, 70, "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->215360],
Cell[24062, 973, 137, 5, 70, "IndentedText",
 CellTags->"b:2.0",
 CellID->145425822],
Cell[24202, 980, 593, 17, 70, "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->364221068],
Cell[24798, 999, 141, 5, 70, "IndentedText",
 CellTags->"b:2.0",
 CellID->550621119],
Cell[24942, 1006, 514, 14, 70, "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->207937984],
Cell[25459, 1022, 134, 5, 70, "IndentedText",
 CellTags->"b:2.0",
 CellID->15324206],
Cell[25596, 1029, 476, 10, 70, "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->896309911],
Cell[26075, 1041, 104, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->356655646],
Cell[26182, 1045, 598, 16, 70, "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->108325733],
Cell[26783, 1063, 392, 11, 70, "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->404945210],
Cell[27178, 1076, 527, 13, 70, "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->16968384],
Cell[27708, 1091, 480, 12, 70, "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->163901371],
Cell[28191, 1105, 197, 6, 70, "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->277184795],
Cell[28391, 1113, 243, 8, 70, "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->519527],
Cell[28637, 1123, 200, 6, 70, "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->101963470],
Cell[28840, 1131, 113, 2, 70, "IndentedText",
 CellTags->"b:2.0",
 CellID->10348670],
Cell[28956, 1135, 390, 14, 70, "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->7955180],
Cell[29349, 1151, 136, 5, 70, "IndentedText",
 CellTags->"b:2.0",
 CellID->789303360],
Cell[29488, 1158, 189, 7, 70, "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->8962457],
Cell[29680, 1167, 137, 5, 70, "IndentedText",
 CellTags->"b:2.0",
 CellID->91925667],
Cell[29820, 1174, 407, 10, 70, "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->119307077],
Cell[30230, 1186, 134, 5, 70, "IndentedText",
 CellTags->"b:2.0",
 CellID->502163955],
Cell[30367, 1193, 180, 6, 70, "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->61171193],
Cell[30550, 1201, 133, 5, 70, "IndentedText",
 CellTags->"b:2.0",
 CellID->649120],
Cell[30686, 1208, 248, 6, 70, "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->494177093],
Cell[30937, 1216, 108, 2, 70, "IndentedText",
 CellTags->"b:2.0",
 CellID->136945596],
Cell[31048, 1220, 263, 8, 70, "ItemizedTextParagraph",
 CellTags->"b:2.0",
 CellID->712658826],
Cell[CellGroupData[{
Cell[31336, 1232, 72, 1, 70, "RelatedTutorialsSection",
 CellID->370182449],
Cell[31411, 1235, 214, 5, 70, "RelatedTutorials",
 CellID->13855348]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[31664, 1245, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

