(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23250,        865]
NotebookOptionsPosition[     11579,        477]
NotebookOutlinePosition[     18866,        706]
CellTagsIndexPosition[     18491,        688]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"System Administration for Network Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"], 
         "System Administration for Single-User Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]\
}, #, 2]& , Evaluator -> Automatic], {
      1->"\<\"System Administration for Network Licenses\"\>", 
      2->"\<\"System Administration for Single-User Licenses\"\>"}, \
"\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Launching ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " on Mac OS X"
}], "Title",
 CellID->30543756],

Cell[CellGroupData[{

Cell[TextData[{
 "Launching ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Locally"
}], "Section",
 CellTags->{"locally", "i:2"},
 CellID->310276582],

Cell[TextData[{
 "To run ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using a network license, both the client machine and the license server \
must be on the network and ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " must be running."
}], "Text",
 CellTags->"b:3.2",
 CellID->550864072],

Cell[CellGroupData[{

Cell[TextData[{
 "To launch ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ":"
}], "Subsection",
 CellTags->"b:3.2",
 CellID->456638878],

Cell[TextData[{
 "Double-click the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " icon in the directory where ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is installed. Alternatively, if you have placed the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " icon in the dock, single-click the icon."
}], "Text",
 CellTags->"b:3.2",
 CellID->297129163]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "To launch only the ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "kernel:"
}], "Subsection",
 CellTags->{"i:11", "b:3.2"},
 CellID->365700216],

Cell[TextData[{
 "Open the Terminal application and type the full pathname of the MathKernel \
binary in the window that appears. For example, if you installed ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in the Applications folder, type ",
 StyleBox["/Applications/Mathematica.app/Contents/MacOS/MathKernel", 
  "InlineCode"],
 " in a Terminal window and press ",
 StyleBox["Return", "KeyEvent"],
 "."
}], "Text",
 CellTags->"b:3.2",
 CellID->472456408]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Launching ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " from a File Server"
}], "Section",
 CellTags->{"fs1", "i:1"},
 CellID->197293711],

Cell[TextData[{
 "To maintain a centralized location for preferences and password files or to \
save disk space, you can run ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " directly from a file server. To do this, the client machine does not \
need",
 " ",
 "to have any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " files installed locally. "
}], "Text",
 CellTags->"b:7.0.1",
 CellID->62511254],

Cell[CellGroupData[{

Cell[TextData[{
 "To run a copy of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " installed on a remote file server:"
}], "Subsection",
 CellTags->"b:7.0.1",
 CellID->19053047],

Cell[TextData[{
 "Connect to a file server on which ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is installed."
}], "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:7.0.1",
 CellID->810172647],

Cell[TextData[{
 "Double-click the icon representing the volume with the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " files. Then navigate to the location where ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is installed. "
}], "ItemizedText",
 CellTags->"b:7.0.1",
 CellID->88377554],

Cell[TextData[{
 "Double-click the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " icon in the directory where ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is installed. "
}], "ItemizedText",
 CellTags->"b:7.0.1",
 CellID->333846934]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Command-Line Options"
}], "Section",
 CellTags->{"i:20", "b:7.2", "net: 1"},
 CellID->508505],

Cell[TextData[{
 "The commands ",
 StyleBox["MathKernel", "InlineCode"],
 " and ",
 StyleBox["Mathematica", "InlineCode"],
 " have several command-line options used to specify certain configuration",
 " ",
 "information and file locations."
}], "Text",
 CellTags->"b:7.2",
 CellID->806428643],

Cell[CellGroupData[{

Cell["MathKernel", "Subsection",
 CellTags->{"i:7", "b:7.2", "net: 2"},
 CellID->340296168],

Cell[TextData[{
 "The command ",
 StyleBox["MathKernel", "InlineCode"],
 " starts the kernel, which is the part of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that handles calculations. This command is also used by the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end."
}], "Text",
 CellTags->"b:7.2",
 CellID->78951292],

Cell[CellGroupData[{

Cell["Command-Line Options", "Subsubsection",
 CellTags->"b:7.2",
 CellID->1417753],

Cell[TextData[{
 StyleBox["-initfile ", "InlineCode"],
 StyleBox["file", "TI"]
}], "IndentedText",
 CellTags->"b:7.2",
 CellID->526990064],

Cell["\<\
 Specifies the name of a file containing commands to be run on startup. \
\>", "ItemizedTextParagraph",
 CellTags->"b:7.2",
 CellID->69172102],

Cell[TextData[StyleBox["-lmverbose", "InlineCode"]], "IndentedText",
 CellTags->"b:7.2",
 CellID->358119297],

Cell[TextData[{
 "Prints diagnostic information to ",
 StyleBox["stderr", "InlineCode"],
 " on connecting to the license manager. This is useful for debugging",
 " ",
 "problems related to the license server."
}], "ItemizedTextParagraph",
 CellTags->"b:7.2",
 CellID->859387316],

Cell[TextData[StyleBox["-mathlink", "InlineCode"]], "IndentedText",
 CellTags->"b:7.2",
 CellID->113054007],

Cell[TextData[{
 "Specifies that the kernel should be run in ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " mode. See ",
 ButtonBox["www.wolfram.com/solutions/mathlink",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.wolfram.com/solutions/mathlink"], None}],
 " for additional information about ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "."
}], "ItemizedTextParagraph",
 CellTags->"b:7.2",
 CellID->6437851],

Cell[TextData[StyleBox["-noinit", "InlineCode"]], "IndentedText",
 CellTags->"b:7.2",
 CellID->189406145],

Cell["\<\
 Specifies that no initialization file should be read at startup. \
\>", "ItemizedTextParagraph",
 CellTags->"b:7.2",
 CellID->108699781],

Cell[TextData[{
 StyleBox["-password ", "InlineCode"],
 StyleBox["str", "TI"]
}], "IndentedText",
 CellTags->"b:7.2",
 CellID->77729439],

Cell[TextData[{
 "Specifies a password to use instead of the password or passwords stored in \
the mathpass file. The password should have the form \"",
 StyleBox["!servername\"", "TI"],
 " or \"",
 StyleBox["machinename mathid licensenumber password", "TI"],
 "\"."
}], "ItemizedTextParagraph",
 CellTags->"b:7.2",
 CellID->361920709],

Cell[TextData[{
 StyleBox["-pwfile ", "InlineCode"],
 StyleBox["file", "TI"]
}], "IndentedText",
 CellTags->"b:7.2",
 CellID->279364146],

Cell["Specifies the name of a file that has a valid password.", \
"ItemizedTextParagraph",
 CellTags->"b:7.2",
 CellID->280727228],

Cell[TextData[StyleBox["-run", "InlineCode"]], "IndentedText",
 CellTags->"b:7.2",
 CellID->279895965],

Cell["Takes a command to be run on startup as an argument.", \
"ItemizedTextParagraph",
 CellTags->"b:7.2",
 CellID->41025787]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mathematica ", "Subsection",
 CellTags->{"i:8", "b:7.2", "net: 3"},
 CellID->42411191],

Cell[TextData[{
 "The command ",
 StyleBox["Mathematica", "InlineCode"],
 " runs the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end. In order to run ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with a command-line option, you must start it from the command line \
using",
 " ",
 "the Terminal application. "
}], "Text",
 CellTags->"b:7.2",
 CellID->51579215],

Cell[CellGroupData[{

Cell["Command-Line Options", "Subsubsection",
 CellTags->"b:7.2",
 CellID->74445789],

Cell[TextData[StyleBox["-cleanStart", "InlineCode"]], "IndentedText",
 CellTags->"b:7.2",
 CellID->62138],

Cell["\<\
 Tells the front end to ignore caches stored in the directory \
~/Library/Mathematica/FrontEnd/6.0 Caches, and rebuilds the front end \
preferences file, ~/Library/Mathematica/FrontEnd/init.m. \
\>", "ItemizedTextParagraph",
 CellTags->"b:7.2",
 CellID->278163263],

Cell[TextData[StyleBox["-mathlink", "InlineCode"]], "IndentedText",
 CellTags->"b:7.2",
 CellID->51830434],

Cell[TextData[{
 "Causes the front end to run in ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " mode. In ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " mode, the front end runs as a child process that is capable of accepting \
",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " packets. This option may be useful when the front end is used as a",
 " ",
 "typesetting or graphics rendering service."
}], "ItemizedTextParagraph",
 CellTags->"b:7.2",
 CellID->617107994],

Cell[TextData[{
 StyleBox["-preferencesDirectory ", "InlineCode"],
 StyleBox["dir", "TI"]
}], "IndentedText",
 CellTags->"b:7.2",
 CellID->365291488],

Cell["\<\
 Specifies the location where preference settings are stored. The default \
location is ~/Library/Mathematica. \
\>", "ItemizedTextParagraph",
 CellTags->"b:7.2",
 CellID->66685837],

Cell[TextData[{
 StyleBox["-topDirectory ", "InlineCode"],
 StyleBox["dir", "TI"]
}], "IndentedText",
 CellTags->"b:7.2",
 CellID->225341268],

Cell[TextData[{
 "Specifies the location of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " installation directory. "
}], "ItemizedTextParagraph",
 CellTags->"b:7.2",
 CellID->168175889]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->61218334],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"RelatedTutorials",
 CellID->13855348],

Cell[TextData[ButtonBox["System Administration for Single-User Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]], \
"RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Launching Mathematica on Mac OS X - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 18.2721388}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "To run Mathematica using a network license, both the client machine and \
the license server must be on the network and MathLM must be running. \
Double-click the Mathematica icon in the directory where Mathematica is \
installed. Alternatively, if you have placed the Mathematica icon in the \
dock, single-click the icon. Open the Terminal application and type the full \
pathname of the MathKernel binary in the window that appears. For example, if \
you installed Mathematica in the Applications folder, type \
/Applications/Mathematica.app/Contents/MacOS/MathKernel in a Terminal window \
and press Return.", "synonyms" -> {}, "title" -> 
    "Launching Mathematica on Mac OS X", "type" -> "Tutorial", "uri" -> 
    "tutorial/LaunchingMathematicaOnMacOSX"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "locally"->{
  Cell[1717, 58, 157, 7, 70, "Section",
   CellTags->{"locally", "i:2"},
   CellID->310276582]},
 "i:2"->{
  Cell[1717, 58, 157, 7, 70, "Section",
   CellTags->{"locally", "i:2"},
   CellID->310276582]},
 "b:3.2"->{
  Cell[1877, 67, 375, 13, 70, "Text",
   CellTags->"b:3.2",
   CellID->550864072],
  Cell[2277, 84, 142, 7, 70, "Subsection",
   CellTags->"b:3.2",
   CellID->456638878],
  Cell[2422, 93, 373, 13, 70, "Text",
   CellTags->"b:3.2",
   CellID->297129163],
  Cell[2832, 111, 168, 7, 70, "Subsection",
   CellTags->{"i:11", "b:3.2"},
   CellID->365700216],
  Cell[3003, 120, 464, 13, 70, "Text",
   CellTags->"b:3.2",
   CellID->472456408]},
 "i:11"->{
  Cell[2832, 111, 168, 7, 70, "Subsection",
   CellTags->{"i:11", "b:3.2"},
   CellID->365700216]},
 "fs1"->{
  Cell[3516, 139, 164, 7, 70, "Section",
   CellTags->{"fs1", "i:1"},
   CellID->197293711]},
 "i:1"->{
  Cell[3516, 139, 164, 7, 70, "Section",
   CellTags->{"fs1", "i:1"},
   CellID->197293711]},
 "b:7.0.1"->{
  Cell[3683, 148, 412, 14, 70, "Text",
   CellTags->"b:7.0.1",
   CellID->62511254],
  Cell[4120, 166, 184, 7, 70, "Subsection",
   CellTags->"b:7.0.1",
   CellID->19053047],
  Cell[4307, 175, 227, 8, 70, "ItemizedText",
   CounterAssignments->{{"ItemizedList", 0}},
   CellTags->"b:7.0.1",
   CellID->810172647],
  Cell[4537, 185, 302, 10, 70, "ItemizedText",
   CellTags->"b:7.0.1",
   CellID->88377554],
  Cell[4842, 197, 250, 10, 70, "ItemizedText",
   CellTags->"b:7.0.1",
   CellID->333846934]},
 "i:20"->{
  Cell[5141, 213, 161, 6, 70, "Section",
   CellTags->{"i:20", "b:7.2", "net: 1"},
   CellID->508505]},
 "b:7.2"->{
  Cell[5141, 213, 161, 6, 70, "Section",
   CellTags->{"i:20", "b:7.2", "net: 1"},
   CellID->508505],
  Cell[5305, 221, 292, 10, 70, "Text",
   CellTags->"b:7.2",
   CellID->806428643],
  Cell[5622, 235, 91, 2, 70, "Subsection",
   CellTags->{"i:7", "b:7.2", "net: 2"},
   CellID->340296168],
  Cell[5716, 239, 347, 12, 70, "Text",
   CellTags->"b:7.2",
   CellID->78951292],
  Cell[6088, 255, 83, 2, 70, "Subsubsection",
   CellTags->"b:7.2",
   CellID->1417753],
  Cell[6174, 259, 138, 5, 70, "IndentedText",
   CellTags->"b:7.2",
   CellID->526990064],
  Cell[6315, 266, 152, 4, 70, "ItemizedTextParagraph",
   CellTags->"b:7.2",
   CellID->69172102],
  Cell[6470, 272, 108, 2, 70, "IndentedText",
   CellTags->"b:7.2",
   CellID->358119297],
  Cell[6581, 276, 278, 8, 70, "ItemizedTextParagraph",
   CellTags->"b:7.2",
   CellID->859387316],
  Cell[6862, 286, 107, 2, 70, "IndentedText",
   CellTags->"b:7.2",
   CellID->113054007],
  Cell[6972, 290, 435, 15, 70, "ItemizedTextParagraph",
   CellTags->"b:7.2",
   CellID->6437851],
  Cell[7410, 307, 105, 2, 70, "IndentedText",
   CellTags->"b:7.2",
   CellID->189406145],
  Cell[7518, 311, 147, 4, 70, "ItemizedTextParagraph",
   CellTags->"b:7.2",
   CellID->108699781],
  Cell[7668, 317, 136, 5, 70, "IndentedText",
   CellTags->"b:7.2",
   CellID->77729439],
  Cell[7807, 324, 335, 9, 70, "ItemizedTextParagraph",
   CellTags->"b:7.2",
   CellID->361920709],
  Cell[8145, 335, 136, 5, 70, "IndentedText",
   CellTags->"b:7.2",
   CellID->279364146],
  Cell[8284, 342, 130, 3, 70, "ItemizedTextParagraph",
   CellTags->"b:7.2",
   CellID->280727228],
  Cell[8417, 347, 102, 2, 70, "IndentedText",
   CellTags->"b:7.2",
   CellID->279895965],
  Cell[8522, 351, 126, 3, 70, "ItemizedTextParagraph",
   CellTags->"b:7.2",
   CellID->41025787],
  Cell[8697, 360, 92, 2, 70, "Subsection",
   CellTags->{"i:8", "b:7.2", "net: 3"},
   CellID->42411191],
  Cell[8792, 364, 386, 15, 70, "Text",
   CellTags->"b:7.2",
   CellID->51579215],
  Cell[9203, 383, 84, 2, 70, "Subsubsection",
   CellTags->"b:7.2",
   CellID->74445789],
  Cell[9290, 387, 105, 2, 70, "IndentedText",
   CellTags->"b:7.2",
   CellID->62138],
  Cell[9398, 391, 274, 6, 70, "ItemizedTextParagraph",
   CellTags->"b:7.2",
   CellID->278163263],
  Cell[9675, 399, 106, 2, 70, "IndentedText",
   CellTags->"b:7.2",
   CellID->51830434],
  Cell[9784, 403, 478, 16, 70, "ItemizedTextParagraph",
   CellTags->"b:7.2",
   CellID->617107994],
  Cell[10265, 421, 149, 5, 70, "IndentedText",
   CellTags->"b:7.2",
   CellID->365291488],
  Cell[10417, 428, 191, 5, 70, "ItemizedTextParagraph",
   CellTags->"b:7.2",
   CellID->66685837],
  Cell[10611, 435, 141, 5, 70, "IndentedText",
   CellTags->"b:7.2",
   CellID->225341268],
  Cell[10755, 442, 197, 7, 70, "ItemizedTextParagraph",
   CellTags->"b:7.2",
   CellID->168175889]},
 "net: 1"->{
  Cell[5141, 213, 161, 6, 70, "Section",
   CellTags->{"i:20", "b:7.2", "net: 1"},
   CellID->508505]},
 "i:7"->{
  Cell[5622, 235, 91, 2, 70, "Subsection",
   CellTags->{"i:7", "b:7.2", "net: 2"},
   CellID->340296168]},
 "net: 2"->{
  Cell[5622, 235, 91, 2, 70, "Subsection",
   CellTags->{"i:7", "b:7.2", "net: 2"},
   CellID->340296168]},
 "i:8"->{
  Cell[8697, 360, 92, 2, 70, "Subsection",
   CellTags->{"i:8", "b:7.2", "net: 3"},
   CellID->42411191]},
 "net: 3"->{
  Cell[8697, 360, 92, 2, 70, "Subsection",
   CellTags->{"i:8", "b:7.2", "net: 3"},
   CellID->42411191]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"locally", 13417, 517},
 {"i:2", 13524, 521},
 {"b:3.2", 13633, 525},
 {"i:11", 14082, 541},
 {"fs1", 14192, 545},
 {"i:1", 14296, 549},
 {"b:7.0.1", 14404, 553},
 {"i:20", 14917, 570},
 {"b:7.2", 15033, 574},
 {"net: 1", 17888, 665},
 {"i:7", 18002, 669},
 {"net: 2", 18123, 673},
 {"i:8", 18241, 677},
 {"net: 3", 18361, 681}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 940, 21, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1565, 48, 127, 6, 70, "Title",
 CellID->30543756],
Cell[CellGroupData[{
Cell[1717, 58, 157, 7, 70, "Section",
 CellTags->{"locally", "i:2"},
 CellID->310276582],
Cell[1877, 67, 375, 13, 70, "Text",
 CellTags->"b:3.2",
 CellID->550864072],
Cell[CellGroupData[{
Cell[2277, 84, 142, 7, 70, "Subsection",
 CellTags->"b:3.2",
 CellID->456638878],
Cell[2422, 93, 373, 13, 70, "Text",
 CellTags->"b:3.2",
 CellID->297129163]
}, Open  ]],
Cell[CellGroupData[{
Cell[2832, 111, 168, 7, 70, "Subsection",
 CellTags->{"i:11", "b:3.2"},
 CellID->365700216],
Cell[3003, 120, 464, 13, 70, "Text",
 CellTags->"b:3.2",
 CellID->472456408]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3516, 139, 164, 7, 70, "Section",
 CellTags->{"fs1", "i:1"},
 CellID->197293711],
Cell[3683, 148, 412, 14, 70, "Text",
 CellTags->"b:7.0.1",
 CellID->62511254],
Cell[CellGroupData[{
Cell[4120, 166, 184, 7, 70, "Subsection",
 CellTags->"b:7.0.1",
 CellID->19053047],
Cell[4307, 175, 227, 8, 70, "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:7.0.1",
 CellID->810172647],
Cell[4537, 185, 302, 10, 70, "ItemizedText",
 CellTags->"b:7.0.1",
 CellID->88377554],
Cell[4842, 197, 250, 10, 70, "ItemizedText",
 CellTags->"b:7.0.1",
 CellID->333846934]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5141, 213, 161, 6, 70, "Section",
 CellTags->{"i:20", "b:7.2", "net: 1"},
 CellID->508505],
Cell[5305, 221, 292, 10, 70, "Text",
 CellTags->"b:7.2",
 CellID->806428643],
Cell[CellGroupData[{
Cell[5622, 235, 91, 2, 70, "Subsection",
 CellTags->{"i:7", "b:7.2", "net: 2"},
 CellID->340296168],
Cell[5716, 239, 347, 12, 70, "Text",
 CellTags->"b:7.2",
 CellID->78951292],
Cell[CellGroupData[{
Cell[6088, 255, 83, 2, 70, "Subsubsection",
 CellTags->"b:7.2",
 CellID->1417753],
Cell[6174, 259, 138, 5, 70, "IndentedText",
 CellTags->"b:7.2",
 CellID->526990064],
Cell[6315, 266, 152, 4, 70, "ItemizedTextParagraph",
 CellTags->"b:7.2",
 CellID->69172102],
Cell[6470, 272, 108, 2, 70, "IndentedText",
 CellTags->"b:7.2",
 CellID->358119297],
Cell[6581, 276, 278, 8, 70, "ItemizedTextParagraph",
 CellTags->"b:7.2",
 CellID->859387316],
Cell[6862, 286, 107, 2, 70, "IndentedText",
 CellTags->"b:7.2",
 CellID->113054007],
Cell[6972, 290, 435, 15, 70, "ItemizedTextParagraph",
 CellTags->"b:7.2",
 CellID->6437851],
Cell[7410, 307, 105, 2, 70, "IndentedText",
 CellTags->"b:7.2",
 CellID->189406145],
Cell[7518, 311, 147, 4, 70, "ItemizedTextParagraph",
 CellTags->"b:7.2",
 CellID->108699781],
Cell[7668, 317, 136, 5, 70, "IndentedText",
 CellTags->"b:7.2",
 CellID->77729439],
Cell[7807, 324, 335, 9, 70, "ItemizedTextParagraph",
 CellTags->"b:7.2",
 CellID->361920709],
Cell[8145, 335, 136, 5, 70, "IndentedText",
 CellTags->"b:7.2",
 CellID->279364146],
Cell[8284, 342, 130, 3, 70, "ItemizedTextParagraph",
 CellTags->"b:7.2",
 CellID->280727228],
Cell[8417, 347, 102, 2, 70, "IndentedText",
 CellTags->"b:7.2",
 CellID->279895965],
Cell[8522, 351, 126, 3, 70, "ItemizedTextParagraph",
 CellTags->"b:7.2",
 CellID->41025787]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8697, 360, 92, 2, 70, "Subsection",
 CellTags->{"i:8", "b:7.2", "net: 3"},
 CellID->42411191],
Cell[8792, 364, 386, 15, 70, "Text",
 CellTags->"b:7.2",
 CellID->51579215],
Cell[CellGroupData[{
Cell[9203, 383, 84, 2, 70, "Subsubsection",
 CellTags->"b:7.2",
 CellID->74445789],
Cell[9290, 387, 105, 2, 70, "IndentedText",
 CellTags->"b:7.2",
 CellID->62138],
Cell[9398, 391, 274, 6, 70, "ItemizedTextParagraph",
 CellTags->"b:7.2",
 CellID->278163263],
Cell[9675, 399, 106, 2, 70, "IndentedText",
 CellTags->"b:7.2",
 CellID->51830434],
Cell[9784, 403, 478, 16, 70, "ItemizedTextParagraph",
 CellTags->"b:7.2",
 CellID->617107994],
Cell[10265, 421, 149, 5, 70, "IndentedText",
 CellTags->"b:7.2",
 CellID->365291488],
Cell[10417, 428, 191, 5, 70, "ItemizedTextParagraph",
 CellTags->"b:7.2",
 CellID->66685837],
Cell[10611, 435, 141, 5, 70, "IndentedText",
 CellTags->"b:7.2",
 CellID->225341268],
Cell[10755, 442, 197, 7, 70, "ItemizedTextParagraph",
 CellTags->"b:7.2",
 CellID->168175889]
}, Open  ]],
Cell[CellGroupData[{
Cell[10989, 454, 71, 1, 70, "RelatedTutorialsSection",
 CellID->61218334],
Cell[11063, 457, 214, 5, 70, "RelatedTutorials",
 CellID->13855348],
Cell[11280, 464, 221, 5, 70, "RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[11552, 475, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

